# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'LogDeliveryConfigurationPropertiesS3ConfigurationPropertiesArgs',
    'LogDeliveryConfigurationPropertiesS3ConfigurationPropertiesArgsDict',
    'LogDeliveryConfigurationPropertiesArgs',
    'LogDeliveryConfigurationPropertiesArgsDict',
    'MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationPropertiesS3ConfigurationPropertiesArgs',
    'MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationPropertiesS3ConfigurationPropertiesArgsDict',
    'MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationPropertiesArgs',
    'MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationPropertiesArgsDict',
    'MagneticStoreWritePropertiesPropertiesArgs',
    'MagneticStoreWritePropertiesPropertiesArgsDict',
    'RetentionPropertiesPropertiesArgs',
    'RetentionPropertiesPropertiesArgsDict',
    'ScheduledQueryDimensionMappingArgs',
    'ScheduledQueryDimensionMappingArgsDict',
    'ScheduledQueryErrorReportConfigurationArgs',
    'ScheduledQueryErrorReportConfigurationArgsDict',
    'ScheduledQueryMixedMeasureMappingArgs',
    'ScheduledQueryMixedMeasureMappingArgsDict',
    'ScheduledQueryMultiMeasureAttributeMappingArgs',
    'ScheduledQueryMultiMeasureAttributeMappingArgsDict',
    'ScheduledQueryMultiMeasureMappingsArgs',
    'ScheduledQueryMultiMeasureMappingsArgsDict',
    'ScheduledQueryNotificationConfigurationArgs',
    'ScheduledQueryNotificationConfigurationArgsDict',
    'ScheduledQueryS3ConfigurationArgs',
    'ScheduledQueryS3ConfigurationArgsDict',
    'ScheduledQueryScheduleConfigurationArgs',
    'ScheduledQueryScheduleConfigurationArgsDict',
    'ScheduledQuerySnsConfigurationArgs',
    'ScheduledQuerySnsConfigurationArgsDict',
    'ScheduledQueryTargetConfigurationArgs',
    'ScheduledQueryTargetConfigurationArgsDict',
    'ScheduledQueryTimestreamConfigurationArgs',
    'ScheduledQueryTimestreamConfigurationArgsDict',
    'SchemaPropertiesArgs',
    'SchemaPropertiesArgsDict',
    'TablePartitionKeyArgs',
    'TablePartitionKeyArgsDict',
]

MYPY = False

if not MYPY:
    class LogDeliveryConfigurationPropertiesS3ConfigurationPropertiesArgsDict(TypedDict):
        """
        S3 configuration for sending logs to customer account from the InfluxDB instance.
        """
        bucket_name: pulumi.Input[str]
        """
        The bucket name for logs to be sent from the InfluxDB instance
        """
        enabled: pulumi.Input[bool]
        """
        Specifies whether logging to customer specified bucket is enabled.
        """
elif False:
    LogDeliveryConfigurationPropertiesS3ConfigurationPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LogDeliveryConfigurationPropertiesS3ConfigurationPropertiesArgs:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[str],
                 enabled: pulumi.Input[bool]):
        """
        S3 configuration for sending logs to customer account from the InfluxDB instance.
        :param pulumi.Input[str] bucket_name: The bucket name for logs to be sent from the InfluxDB instance
        :param pulumi.Input[bool] enabled: Specifies whether logging to customer specified bucket is enabled.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[str]:
        """
        The bucket name for logs to be sent from the InfluxDB instance
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Specifies whether logging to customer specified bucket is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class LogDeliveryConfigurationPropertiesArgsDict(TypedDict):
        """
        Configuration for sending logs to customer account from the InfluxDB instance.
        """
        s3_configuration: pulumi.Input['LogDeliveryConfigurationPropertiesS3ConfigurationPropertiesArgsDict']
        """
        S3 configuration for sending logs to customer account from the InfluxDB instance.
        """
elif False:
    LogDeliveryConfigurationPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LogDeliveryConfigurationPropertiesArgs:
    def __init__(__self__, *,
                 s3_configuration: pulumi.Input['LogDeliveryConfigurationPropertiesS3ConfigurationPropertiesArgs']):
        """
        Configuration for sending logs to customer account from the InfluxDB instance.
        :param pulumi.Input['LogDeliveryConfigurationPropertiesS3ConfigurationPropertiesArgs'] s3_configuration: S3 configuration for sending logs to customer account from the InfluxDB instance.
        """
        pulumi.set(__self__, "s3_configuration", s3_configuration)

    @property
    @pulumi.getter(name="s3Configuration")
    def s3_configuration(self) -> pulumi.Input['LogDeliveryConfigurationPropertiesS3ConfigurationPropertiesArgs']:
        """
        S3 configuration for sending logs to customer account from the InfluxDB instance.
        """
        return pulumi.get(self, "s3_configuration")

    @s3_configuration.setter
    def s3_configuration(self, value: pulumi.Input['LogDeliveryConfigurationPropertiesS3ConfigurationPropertiesArgs']):
        pulumi.set(self, "s3_configuration", value)


if not MYPY:
    class MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationPropertiesS3ConfigurationPropertiesArgsDict(TypedDict):
        """
        S3 configuration for location to store rejections from magnetic store writes
        """
        bucket_name: pulumi.Input[str]
        """
        The bucket name used to store the data.
        """
        encryption_option: pulumi.Input[str]
        """
        Either SSE_KMS or SSE_S3.
        """
        kms_key_id: NotRequired[pulumi.Input[str]]
        """
        Must be provided if SSE_KMS is specified as the encryption option
        """
        object_key_prefix: NotRequired[pulumi.Input[str]]
        """
        String used to prefix all data in the bucket.
        """
elif False:
    MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationPropertiesS3ConfigurationPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationPropertiesS3ConfigurationPropertiesArgs:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[str],
                 encryption_option: pulumi.Input[str],
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 object_key_prefix: Optional[pulumi.Input[str]] = None):
        """
        S3 configuration for location to store rejections from magnetic store writes
        :param pulumi.Input[str] bucket_name: The bucket name used to store the data.
        :param pulumi.Input[str] encryption_option: Either SSE_KMS or SSE_S3.
        :param pulumi.Input[str] kms_key_id: Must be provided if SSE_KMS is specified as the encryption option
        :param pulumi.Input[str] object_key_prefix: String used to prefix all data in the bucket.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "encryption_option", encryption_option)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if object_key_prefix is not None:
            pulumi.set(__self__, "object_key_prefix", object_key_prefix)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[str]:
        """
        The bucket name used to store the data.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="encryptionOption")
    def encryption_option(self) -> pulumi.Input[str]:
        """
        Either SSE_KMS or SSE_S3.
        """
        return pulumi.get(self, "encryption_option")

    @encryption_option.setter
    def encryption_option(self, value: pulumi.Input[str]):
        pulumi.set(self, "encryption_option", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        Must be provided if SSE_KMS is specified as the encryption option
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="objectKeyPrefix")
    def object_key_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        String used to prefix all data in the bucket.
        """
        return pulumi.get(self, "object_key_prefix")

    @object_key_prefix.setter
    def object_key_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_key_prefix", value)


if not MYPY:
    class MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationPropertiesArgsDict(TypedDict):
        """
        Location to store information about records that were asynchronously rejected during magnetic store writes.
        """
        s3_configuration: NotRequired[pulumi.Input['MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationPropertiesS3ConfigurationPropertiesArgsDict']]
        """
        S3 configuration for location to store rejections from magnetic store writes
        """
elif False:
    MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationPropertiesArgs:
    def __init__(__self__, *,
                 s3_configuration: Optional[pulumi.Input['MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationPropertiesS3ConfigurationPropertiesArgs']] = None):
        """
        Location to store information about records that were asynchronously rejected during magnetic store writes.
        :param pulumi.Input['MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationPropertiesS3ConfigurationPropertiesArgs'] s3_configuration: S3 configuration for location to store rejections from magnetic store writes
        """
        if s3_configuration is not None:
            pulumi.set(__self__, "s3_configuration", s3_configuration)

    @property
    @pulumi.getter(name="s3Configuration")
    def s3_configuration(self) -> Optional[pulumi.Input['MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationPropertiesS3ConfigurationPropertiesArgs']]:
        """
        S3 configuration for location to store rejections from magnetic store writes
        """
        return pulumi.get(self, "s3_configuration")

    @s3_configuration.setter
    def s3_configuration(self, value: Optional[pulumi.Input['MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationPropertiesS3ConfigurationPropertiesArgs']]):
        pulumi.set(self, "s3_configuration", value)


if not MYPY:
    class MagneticStoreWritePropertiesPropertiesArgsDict(TypedDict):
        """
        The properties that determine whether magnetic store writes are enabled.
        """
        enable_magnetic_store_writes: pulumi.Input[bool]
        """
        Boolean flag indicating whether magnetic store writes are enabled.
        """
        magnetic_store_rejected_data_location: NotRequired[pulumi.Input['MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationPropertiesArgsDict']]
        """
        Location to store information about records that were asynchronously rejected during magnetic store writes.
        """
elif False:
    MagneticStoreWritePropertiesPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MagneticStoreWritePropertiesPropertiesArgs:
    def __init__(__self__, *,
                 enable_magnetic_store_writes: pulumi.Input[bool],
                 magnetic_store_rejected_data_location: Optional[pulumi.Input['MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationPropertiesArgs']] = None):
        """
        The properties that determine whether magnetic store writes are enabled.
        :param pulumi.Input[bool] enable_magnetic_store_writes: Boolean flag indicating whether magnetic store writes are enabled.
        :param pulumi.Input['MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationPropertiesArgs'] magnetic_store_rejected_data_location: Location to store information about records that were asynchronously rejected during magnetic store writes.
        """
        pulumi.set(__self__, "enable_magnetic_store_writes", enable_magnetic_store_writes)
        if magnetic_store_rejected_data_location is not None:
            pulumi.set(__self__, "magnetic_store_rejected_data_location", magnetic_store_rejected_data_location)

    @property
    @pulumi.getter(name="enableMagneticStoreWrites")
    def enable_magnetic_store_writes(self) -> pulumi.Input[bool]:
        """
        Boolean flag indicating whether magnetic store writes are enabled.
        """
        return pulumi.get(self, "enable_magnetic_store_writes")

    @enable_magnetic_store_writes.setter
    def enable_magnetic_store_writes(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable_magnetic_store_writes", value)

    @property
    @pulumi.getter(name="magneticStoreRejectedDataLocation")
    def magnetic_store_rejected_data_location(self) -> Optional[pulumi.Input['MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationPropertiesArgs']]:
        """
        Location to store information about records that were asynchronously rejected during magnetic store writes.
        """
        return pulumi.get(self, "magnetic_store_rejected_data_location")

    @magnetic_store_rejected_data_location.setter
    def magnetic_store_rejected_data_location(self, value: Optional[pulumi.Input['MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationPropertiesArgs']]):
        pulumi.set(self, "magnetic_store_rejected_data_location", value)


if not MYPY:
    class RetentionPropertiesPropertiesArgsDict(TypedDict):
        """
        The retention duration of the memory store and the magnetic store.
        """
        magnetic_store_retention_period_in_days: NotRequired[pulumi.Input[str]]
        """
        The duration for which data must be stored in the magnetic store.
        """
        memory_store_retention_period_in_hours: NotRequired[pulumi.Input[str]]
        """
        The duration for which data must be stored in the memory store.
        """
elif False:
    RetentionPropertiesPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RetentionPropertiesPropertiesArgs:
    def __init__(__self__, *,
                 magnetic_store_retention_period_in_days: Optional[pulumi.Input[str]] = None,
                 memory_store_retention_period_in_hours: Optional[pulumi.Input[str]] = None):
        """
        The retention duration of the memory store and the magnetic store.
        :param pulumi.Input[str] magnetic_store_retention_period_in_days: The duration for which data must be stored in the magnetic store.
        :param pulumi.Input[str] memory_store_retention_period_in_hours: The duration for which data must be stored in the memory store.
        """
        if magnetic_store_retention_period_in_days is not None:
            pulumi.set(__self__, "magnetic_store_retention_period_in_days", magnetic_store_retention_period_in_days)
        if memory_store_retention_period_in_hours is not None:
            pulumi.set(__self__, "memory_store_retention_period_in_hours", memory_store_retention_period_in_hours)

    @property
    @pulumi.getter(name="magneticStoreRetentionPeriodInDays")
    def magnetic_store_retention_period_in_days(self) -> Optional[pulumi.Input[str]]:
        """
        The duration for which data must be stored in the magnetic store.
        """
        return pulumi.get(self, "magnetic_store_retention_period_in_days")

    @magnetic_store_retention_period_in_days.setter
    def magnetic_store_retention_period_in_days(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "magnetic_store_retention_period_in_days", value)

    @property
    @pulumi.getter(name="memoryStoreRetentionPeriodInHours")
    def memory_store_retention_period_in_hours(self) -> Optional[pulumi.Input[str]]:
        """
        The duration for which data must be stored in the memory store.
        """
        return pulumi.get(self, "memory_store_retention_period_in_hours")

    @memory_store_retention_period_in_hours.setter
    def memory_store_retention_period_in_hours(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "memory_store_retention_period_in_hours", value)


if not MYPY:
    class ScheduledQueryDimensionMappingArgsDict(TypedDict):
        """
        This type is used to map column(s) from the query result to a dimension in the destination table.
        """
        dimension_value_type: pulumi.Input['ScheduledQueryDimensionValueType']
        name: pulumi.Input[str]
elif False:
    ScheduledQueryDimensionMappingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScheduledQueryDimensionMappingArgs:
    def __init__(__self__, *,
                 dimension_value_type: pulumi.Input['ScheduledQueryDimensionValueType'],
                 name: pulumi.Input[str]):
        """
        This type is used to map column(s) from the query result to a dimension in the destination table.
        """
        pulumi.set(__self__, "dimension_value_type", dimension_value_type)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="dimensionValueType")
    def dimension_value_type(self) -> pulumi.Input['ScheduledQueryDimensionValueType']:
        return pulumi.get(self, "dimension_value_type")

    @dimension_value_type.setter
    def dimension_value_type(self, value: pulumi.Input['ScheduledQueryDimensionValueType']):
        pulumi.set(self, "dimension_value_type", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


if not MYPY:
    class ScheduledQueryErrorReportConfigurationArgsDict(TypedDict):
        """
        Configuration for error reporting. Error reports will be generated when a problem is encountered when writing the query results.
        """
        s3_configuration: pulumi.Input['ScheduledQueryS3ConfigurationArgsDict']
        """
        The S3 configuration for the error reports.
        """
elif False:
    ScheduledQueryErrorReportConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScheduledQueryErrorReportConfigurationArgs:
    def __init__(__self__, *,
                 s3_configuration: pulumi.Input['ScheduledQueryS3ConfigurationArgs']):
        """
        Configuration for error reporting. Error reports will be generated when a problem is encountered when writing the query results.
        :param pulumi.Input['ScheduledQueryS3ConfigurationArgs'] s3_configuration: The S3 configuration for the error reports.
        """
        pulumi.set(__self__, "s3_configuration", s3_configuration)

    @property
    @pulumi.getter(name="s3Configuration")
    def s3_configuration(self) -> pulumi.Input['ScheduledQueryS3ConfigurationArgs']:
        """
        The S3 configuration for the error reports.
        """
        return pulumi.get(self, "s3_configuration")

    @s3_configuration.setter
    def s3_configuration(self, value: pulumi.Input['ScheduledQueryS3ConfigurationArgs']):
        pulumi.set(self, "s3_configuration", value)


if not MYPY:
    class ScheduledQueryMixedMeasureMappingArgsDict(TypedDict):
        """
        MixedMeasureMappings are mappings that can be used to ingest data into a mixture of narrow and multi measures in the derived table.
        """
        measure_value_type: pulumi.Input['ScheduledQueryMixedMeasureMappingMeasureValueType']
        measure_name: NotRequired[pulumi.Input[str]]
        multi_measure_attribute_mappings: NotRequired[pulumi.Input[Sequence[pulumi.Input['ScheduledQueryMultiMeasureAttributeMappingArgsDict']]]]
        source_column: NotRequired[pulumi.Input[str]]
        target_measure_name: NotRequired[pulumi.Input[str]]
elif False:
    ScheduledQueryMixedMeasureMappingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScheduledQueryMixedMeasureMappingArgs:
    def __init__(__self__, *,
                 measure_value_type: pulumi.Input['ScheduledQueryMixedMeasureMappingMeasureValueType'],
                 measure_name: Optional[pulumi.Input[str]] = None,
                 multi_measure_attribute_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduledQueryMultiMeasureAttributeMappingArgs']]]] = None,
                 source_column: Optional[pulumi.Input[str]] = None,
                 target_measure_name: Optional[pulumi.Input[str]] = None):
        """
        MixedMeasureMappings are mappings that can be used to ingest data into a mixture of narrow and multi measures in the derived table.
        """
        pulumi.set(__self__, "measure_value_type", measure_value_type)
        if measure_name is not None:
            pulumi.set(__self__, "measure_name", measure_name)
        if multi_measure_attribute_mappings is not None:
            pulumi.set(__self__, "multi_measure_attribute_mappings", multi_measure_attribute_mappings)
        if source_column is not None:
            pulumi.set(__self__, "source_column", source_column)
        if target_measure_name is not None:
            pulumi.set(__self__, "target_measure_name", target_measure_name)

    @property
    @pulumi.getter(name="measureValueType")
    def measure_value_type(self) -> pulumi.Input['ScheduledQueryMixedMeasureMappingMeasureValueType']:
        return pulumi.get(self, "measure_value_type")

    @measure_value_type.setter
    def measure_value_type(self, value: pulumi.Input['ScheduledQueryMixedMeasureMappingMeasureValueType']):
        pulumi.set(self, "measure_value_type", value)

    @property
    @pulumi.getter(name="measureName")
    def measure_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "measure_name")

    @measure_name.setter
    def measure_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "measure_name", value)

    @property
    @pulumi.getter(name="multiMeasureAttributeMappings")
    def multi_measure_attribute_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScheduledQueryMultiMeasureAttributeMappingArgs']]]]:
        return pulumi.get(self, "multi_measure_attribute_mappings")

    @multi_measure_attribute_mappings.setter
    def multi_measure_attribute_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduledQueryMultiMeasureAttributeMappingArgs']]]]):
        pulumi.set(self, "multi_measure_attribute_mappings", value)

    @property
    @pulumi.getter(name="sourceColumn")
    def source_column(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "source_column")

    @source_column.setter
    def source_column(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_column", value)

    @property
    @pulumi.getter(name="targetMeasureName")
    def target_measure_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "target_measure_name")

    @target_measure_name.setter
    def target_measure_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_measure_name", value)


if not MYPY:
    class ScheduledQueryMultiMeasureAttributeMappingArgsDict(TypedDict):
        """
        An attribute mapping to be used for mapping query results to ingest data for multi-measure attributes.
        """
        measure_value_type: pulumi.Input['ScheduledQueryMultiMeasureAttributeMappingMeasureValueType']
        source_column: pulumi.Input[str]
        target_multi_measure_attribute_name: NotRequired[pulumi.Input[str]]
elif False:
    ScheduledQueryMultiMeasureAttributeMappingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScheduledQueryMultiMeasureAttributeMappingArgs:
    def __init__(__self__, *,
                 measure_value_type: pulumi.Input['ScheduledQueryMultiMeasureAttributeMappingMeasureValueType'],
                 source_column: pulumi.Input[str],
                 target_multi_measure_attribute_name: Optional[pulumi.Input[str]] = None):
        """
        An attribute mapping to be used for mapping query results to ingest data for multi-measure attributes.
        """
        pulumi.set(__self__, "measure_value_type", measure_value_type)
        pulumi.set(__self__, "source_column", source_column)
        if target_multi_measure_attribute_name is not None:
            pulumi.set(__self__, "target_multi_measure_attribute_name", target_multi_measure_attribute_name)

    @property
    @pulumi.getter(name="measureValueType")
    def measure_value_type(self) -> pulumi.Input['ScheduledQueryMultiMeasureAttributeMappingMeasureValueType']:
        return pulumi.get(self, "measure_value_type")

    @measure_value_type.setter
    def measure_value_type(self, value: pulumi.Input['ScheduledQueryMultiMeasureAttributeMappingMeasureValueType']):
        pulumi.set(self, "measure_value_type", value)

    @property
    @pulumi.getter(name="sourceColumn")
    def source_column(self) -> pulumi.Input[str]:
        return pulumi.get(self, "source_column")

    @source_column.setter
    def source_column(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_column", value)

    @property
    @pulumi.getter(name="targetMultiMeasureAttributeName")
    def target_multi_measure_attribute_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "target_multi_measure_attribute_name")

    @target_multi_measure_attribute_name.setter
    def target_multi_measure_attribute_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_multi_measure_attribute_name", value)


if not MYPY:
    class ScheduledQueryMultiMeasureMappingsArgsDict(TypedDict):
        """
        Only one of MixedMeasureMappings or MultiMeasureMappings is to be provided. MultiMeasureMappings can be used to ingest data as multi measures in the derived table.
        """
        multi_measure_attribute_mappings: pulumi.Input[Sequence[pulumi.Input['ScheduledQueryMultiMeasureAttributeMappingArgsDict']]]
        """
        Required. Attribute mappings to be used for mapping query results to ingest data for multi-measure attributes.
        """
        target_multi_measure_name: NotRequired[pulumi.Input[str]]
        """
        The name of the target multi-measure name in the derived table. This input is required when measureNameColumn is not provided. If MeasureNameColumn is provided, then value from that column will be used as multi-measure name.
        """
elif False:
    ScheduledQueryMultiMeasureMappingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScheduledQueryMultiMeasureMappingsArgs:
    def __init__(__self__, *,
                 multi_measure_attribute_mappings: pulumi.Input[Sequence[pulumi.Input['ScheduledQueryMultiMeasureAttributeMappingArgs']]],
                 target_multi_measure_name: Optional[pulumi.Input[str]] = None):
        """
        Only one of MixedMeasureMappings or MultiMeasureMappings is to be provided. MultiMeasureMappings can be used to ingest data as multi measures in the derived table.
        :param pulumi.Input[Sequence[pulumi.Input['ScheduledQueryMultiMeasureAttributeMappingArgs']]] multi_measure_attribute_mappings: Required. Attribute mappings to be used for mapping query results to ingest data for multi-measure attributes.
        :param pulumi.Input[str] target_multi_measure_name: The name of the target multi-measure name in the derived table. This input is required when measureNameColumn is not provided. If MeasureNameColumn is provided, then value from that column will be used as multi-measure name.
        """
        pulumi.set(__self__, "multi_measure_attribute_mappings", multi_measure_attribute_mappings)
        if target_multi_measure_name is not None:
            pulumi.set(__self__, "target_multi_measure_name", target_multi_measure_name)

    @property
    @pulumi.getter(name="multiMeasureAttributeMappings")
    def multi_measure_attribute_mappings(self) -> pulumi.Input[Sequence[pulumi.Input['ScheduledQueryMultiMeasureAttributeMappingArgs']]]:
        """
        Required. Attribute mappings to be used for mapping query results to ingest data for multi-measure attributes.
        """
        return pulumi.get(self, "multi_measure_attribute_mappings")

    @multi_measure_attribute_mappings.setter
    def multi_measure_attribute_mappings(self, value: pulumi.Input[Sequence[pulumi.Input['ScheduledQueryMultiMeasureAttributeMappingArgs']]]):
        pulumi.set(self, "multi_measure_attribute_mappings", value)

    @property
    @pulumi.getter(name="targetMultiMeasureName")
    def target_multi_measure_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the target multi-measure name in the derived table. This input is required when measureNameColumn is not provided. If MeasureNameColumn is provided, then value from that column will be used as multi-measure name.
        """
        return pulumi.get(self, "target_multi_measure_name")

    @target_multi_measure_name.setter
    def target_multi_measure_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_multi_measure_name", value)


if not MYPY:
    class ScheduledQueryNotificationConfigurationArgsDict(TypedDict):
        """
        Notification configuration for the scheduled query. A notification is sent by Timestream when a query run finishes, when the state is updated or when you delete it.
        """
        sns_configuration: pulumi.Input['ScheduledQuerySnsConfigurationArgsDict']
        """
        Details on SNS configuration.
        """
elif False:
    ScheduledQueryNotificationConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScheduledQueryNotificationConfigurationArgs:
    def __init__(__self__, *,
                 sns_configuration: pulumi.Input['ScheduledQuerySnsConfigurationArgs']):
        """
        Notification configuration for the scheduled query. A notification is sent by Timestream when a query run finishes, when the state is updated or when you delete it.
        :param pulumi.Input['ScheduledQuerySnsConfigurationArgs'] sns_configuration: Details on SNS configuration.
        """
        pulumi.set(__self__, "sns_configuration", sns_configuration)

    @property
    @pulumi.getter(name="snsConfiguration")
    def sns_configuration(self) -> pulumi.Input['ScheduledQuerySnsConfigurationArgs']:
        """
        Details on SNS configuration.
        """
        return pulumi.get(self, "sns_configuration")

    @sns_configuration.setter
    def sns_configuration(self, value: pulumi.Input['ScheduledQuerySnsConfigurationArgs']):
        pulumi.set(self, "sns_configuration", value)


if not MYPY:
    class ScheduledQueryS3ConfigurationArgsDict(TypedDict):
        """
        Details on S3 location for error reports that result from running a query.
        """
        bucket_name: pulumi.Input[str]
        """
        Name of the S3 bucket under which error reports will be created.
        """
        encryption_option: NotRequired[pulumi.Input['ScheduledQueryEncryptionOption']]
        """
        Encryption at rest options for the error reports. If no encryption option is specified, Timestream will choose SSE_S3 as default.
        """
        object_key_prefix: NotRequired[pulumi.Input[str]]
        """
        Prefix for the error report key. Timestream by default adds the following prefix to the error report path.
        """
elif False:
    ScheduledQueryS3ConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScheduledQueryS3ConfigurationArgs:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[str],
                 encryption_option: Optional[pulumi.Input['ScheduledQueryEncryptionOption']] = None,
                 object_key_prefix: Optional[pulumi.Input[str]] = None):
        """
        Details on S3 location for error reports that result from running a query.
        :param pulumi.Input[str] bucket_name: Name of the S3 bucket under which error reports will be created.
        :param pulumi.Input['ScheduledQueryEncryptionOption'] encryption_option: Encryption at rest options for the error reports. If no encryption option is specified, Timestream will choose SSE_S3 as default.
        :param pulumi.Input[str] object_key_prefix: Prefix for the error report key. Timestream by default adds the following prefix to the error report path.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        if encryption_option is not None:
            pulumi.set(__self__, "encryption_option", encryption_option)
        if object_key_prefix is not None:
            pulumi.set(__self__, "object_key_prefix", object_key_prefix)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[str]:
        """
        Name of the S3 bucket under which error reports will be created.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="encryptionOption")
    def encryption_option(self) -> Optional[pulumi.Input['ScheduledQueryEncryptionOption']]:
        """
        Encryption at rest options for the error reports. If no encryption option is specified, Timestream will choose SSE_S3 as default.
        """
        return pulumi.get(self, "encryption_option")

    @encryption_option.setter
    def encryption_option(self, value: Optional[pulumi.Input['ScheduledQueryEncryptionOption']]):
        pulumi.set(self, "encryption_option", value)

    @property
    @pulumi.getter(name="objectKeyPrefix")
    def object_key_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Prefix for the error report key. Timestream by default adds the following prefix to the error report path.
        """
        return pulumi.get(self, "object_key_prefix")

    @object_key_prefix.setter
    def object_key_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_key_prefix", value)


if not MYPY:
    class ScheduledQueryScheduleConfigurationArgsDict(TypedDict):
        """
        Configuration for when the scheduled query is executed.
        """
        schedule_expression: pulumi.Input[str]
        """
        An expression that denotes when to trigger the scheduled query run. This can be a cron expression or a rate expression.
        """
elif False:
    ScheduledQueryScheduleConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScheduledQueryScheduleConfigurationArgs:
    def __init__(__self__, *,
                 schedule_expression: pulumi.Input[str]):
        """
        Configuration for when the scheduled query is executed.
        :param pulumi.Input[str] schedule_expression: An expression that denotes when to trigger the scheduled query run. This can be a cron expression or a rate expression.
        """
        pulumi.set(__self__, "schedule_expression", schedule_expression)

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> pulumi.Input[str]:
        """
        An expression that denotes when to trigger the scheduled query run. This can be a cron expression or a rate expression.
        """
        return pulumi.get(self, "schedule_expression")

    @schedule_expression.setter
    def schedule_expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "schedule_expression", value)


if not MYPY:
    class ScheduledQuerySnsConfigurationArgsDict(TypedDict):
        """
        SNS configuration for notification upon scheduled query execution.
        """
        topic_arn: pulumi.Input[str]
        """
        SNS topic ARN that the scheduled query status notifications will be sent to.
        """
elif False:
    ScheduledQuerySnsConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScheduledQuerySnsConfigurationArgs:
    def __init__(__self__, *,
                 topic_arn: pulumi.Input[str]):
        """
        SNS configuration for notification upon scheduled query execution.
        :param pulumi.Input[str] topic_arn: SNS topic ARN that the scheduled query status notifications will be sent to.
        """
        pulumi.set(__self__, "topic_arn", topic_arn)

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> pulumi.Input[str]:
        """
        SNS topic ARN that the scheduled query status notifications will be sent to.
        """
        return pulumi.get(self, "topic_arn")

    @topic_arn.setter
    def topic_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "topic_arn", value)


if not MYPY:
    class ScheduledQueryTargetConfigurationArgsDict(TypedDict):
        """
        Configuration of target store where scheduled query results are written to.
        """
        timestream_configuration: pulumi.Input['ScheduledQueryTimestreamConfigurationArgsDict']
        """
        Configuration needed to write data into the Timestream database and table.
        """
elif False:
    ScheduledQueryTargetConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScheduledQueryTargetConfigurationArgs:
    def __init__(__self__, *,
                 timestream_configuration: pulumi.Input['ScheduledQueryTimestreamConfigurationArgs']):
        """
        Configuration of target store where scheduled query results are written to.
        :param pulumi.Input['ScheduledQueryTimestreamConfigurationArgs'] timestream_configuration: Configuration needed to write data into the Timestream database and table.
        """
        pulumi.set(__self__, "timestream_configuration", timestream_configuration)

    @property
    @pulumi.getter(name="timestreamConfiguration")
    def timestream_configuration(self) -> pulumi.Input['ScheduledQueryTimestreamConfigurationArgs']:
        """
        Configuration needed to write data into the Timestream database and table.
        """
        return pulumi.get(self, "timestream_configuration")

    @timestream_configuration.setter
    def timestream_configuration(self, value: pulumi.Input['ScheduledQueryTimestreamConfigurationArgs']):
        pulumi.set(self, "timestream_configuration", value)


if not MYPY:
    class ScheduledQueryTimestreamConfigurationArgsDict(TypedDict):
        """
        Configuration needed to write data into the Timestream database and table.
        """
        database_name: pulumi.Input[str]
        """
        Name of Timestream database to which the query result will be written.
        """
        dimension_mappings: pulumi.Input[Sequence[pulumi.Input['ScheduledQueryDimensionMappingArgsDict']]]
        """
        This is to allow mapping column(s) from the query result to the dimension in the destination table.
        """
        table_name: pulumi.Input[str]
        """
        Name of Timestream table that the query result will be written to. The table should be within the same database that is provided in Timestream configuration.
        """
        time_column: pulumi.Input[str]
        """
        Column from query result that should be used as the time column in destination table. Column type for this should be TIMESTAMP.
        """
        measure_name_column: NotRequired[pulumi.Input[str]]
        """
        Name of the measure column. Also see `MultiMeasureMappings` and `MixedMeasureMappings` for how measure name properties on those relate to `MeasureNameColumn` .
        """
        mixed_measure_mappings: NotRequired[pulumi.Input[Sequence[pulumi.Input['ScheduledQueryMixedMeasureMappingArgsDict']]]]
        """
        Specifies how to map measures to multi-measure records.
        """
        multi_measure_mappings: NotRequired[pulumi.Input['ScheduledQueryMultiMeasureMappingsArgsDict']]
        """
        Multi-measure mappings.
        """
elif False:
    ScheduledQueryTimestreamConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScheduledQueryTimestreamConfigurationArgs:
    def __init__(__self__, *,
                 database_name: pulumi.Input[str],
                 dimension_mappings: pulumi.Input[Sequence[pulumi.Input['ScheduledQueryDimensionMappingArgs']]],
                 table_name: pulumi.Input[str],
                 time_column: pulumi.Input[str],
                 measure_name_column: Optional[pulumi.Input[str]] = None,
                 mixed_measure_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduledQueryMixedMeasureMappingArgs']]]] = None,
                 multi_measure_mappings: Optional[pulumi.Input['ScheduledQueryMultiMeasureMappingsArgs']] = None):
        """
        Configuration needed to write data into the Timestream database and table.
        :param pulumi.Input[str] database_name: Name of Timestream database to which the query result will be written.
        :param pulumi.Input[Sequence[pulumi.Input['ScheduledQueryDimensionMappingArgs']]] dimension_mappings: This is to allow mapping column(s) from the query result to the dimension in the destination table.
        :param pulumi.Input[str] table_name: Name of Timestream table that the query result will be written to. The table should be within the same database that is provided in Timestream configuration.
        :param pulumi.Input[str] time_column: Column from query result that should be used as the time column in destination table. Column type for this should be TIMESTAMP.
        :param pulumi.Input[str] measure_name_column: Name of the measure column. Also see `MultiMeasureMappings` and `MixedMeasureMappings` for how measure name properties on those relate to `MeasureNameColumn` .
        :param pulumi.Input[Sequence[pulumi.Input['ScheduledQueryMixedMeasureMappingArgs']]] mixed_measure_mappings: Specifies how to map measures to multi-measure records.
        :param pulumi.Input['ScheduledQueryMultiMeasureMappingsArgs'] multi_measure_mappings: Multi-measure mappings.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "dimension_mappings", dimension_mappings)
        pulumi.set(__self__, "table_name", table_name)
        pulumi.set(__self__, "time_column", time_column)
        if measure_name_column is not None:
            pulumi.set(__self__, "measure_name_column", measure_name_column)
        if mixed_measure_mappings is not None:
            pulumi.set(__self__, "mixed_measure_mappings", mixed_measure_mappings)
        if multi_measure_mappings is not None:
            pulumi.set(__self__, "multi_measure_mappings", multi_measure_mappings)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[str]:
        """
        Name of Timestream database to which the query result will be written.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="dimensionMappings")
    def dimension_mappings(self) -> pulumi.Input[Sequence[pulumi.Input['ScheduledQueryDimensionMappingArgs']]]:
        """
        This is to allow mapping column(s) from the query result to the dimension in the destination table.
        """
        return pulumi.get(self, "dimension_mappings")

    @dimension_mappings.setter
    def dimension_mappings(self, value: pulumi.Input[Sequence[pulumi.Input['ScheduledQueryDimensionMappingArgs']]]):
        pulumi.set(self, "dimension_mappings", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Input[str]:
        """
        Name of Timestream table that the query result will be written to. The table should be within the same database that is provided in Timestream configuration.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter(name="timeColumn")
    def time_column(self) -> pulumi.Input[str]:
        """
        Column from query result that should be used as the time column in destination table. Column type for this should be TIMESTAMP.
        """
        return pulumi.get(self, "time_column")

    @time_column.setter
    def time_column(self, value: pulumi.Input[str]):
        pulumi.set(self, "time_column", value)

    @property
    @pulumi.getter(name="measureNameColumn")
    def measure_name_column(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the measure column. Also see `MultiMeasureMappings` and `MixedMeasureMappings` for how measure name properties on those relate to `MeasureNameColumn` .
        """
        return pulumi.get(self, "measure_name_column")

    @measure_name_column.setter
    def measure_name_column(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "measure_name_column", value)

    @property
    @pulumi.getter(name="mixedMeasureMappings")
    def mixed_measure_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScheduledQueryMixedMeasureMappingArgs']]]]:
        """
        Specifies how to map measures to multi-measure records.
        """
        return pulumi.get(self, "mixed_measure_mappings")

    @mixed_measure_mappings.setter
    def mixed_measure_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduledQueryMixedMeasureMappingArgs']]]]):
        pulumi.set(self, "mixed_measure_mappings", value)

    @property
    @pulumi.getter(name="multiMeasureMappings")
    def multi_measure_mappings(self) -> Optional[pulumi.Input['ScheduledQueryMultiMeasureMappingsArgs']]:
        """
        Multi-measure mappings.
        """
        return pulumi.get(self, "multi_measure_mappings")

    @multi_measure_mappings.setter
    def multi_measure_mappings(self, value: Optional[pulumi.Input['ScheduledQueryMultiMeasureMappingsArgs']]):
        pulumi.set(self, "multi_measure_mappings", value)


if not MYPY:
    class SchemaPropertiesArgsDict(TypedDict):
        """
        A Schema specifies the expected data model of the table.
        """
        composite_partition_key: NotRequired[pulumi.Input[Sequence[pulumi.Input['TablePartitionKeyArgsDict']]]]
        """
        A non-empty list of partition keys defining the attributes used to partition the table data. The order of the list determines the partition hierarchy. The name and type of each partition key as well as the partition key order cannot be changed after the table is created. However, the enforcement level of each partition key can be changed.
        """
elif False:
    SchemaPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SchemaPropertiesArgs:
    def __init__(__self__, *,
                 composite_partition_key: Optional[pulumi.Input[Sequence[pulumi.Input['TablePartitionKeyArgs']]]] = None):
        """
        A Schema specifies the expected data model of the table.
        :param pulumi.Input[Sequence[pulumi.Input['TablePartitionKeyArgs']]] composite_partition_key: A non-empty list of partition keys defining the attributes used to partition the table data. The order of the list determines the partition hierarchy. The name and type of each partition key as well as the partition key order cannot be changed after the table is created. However, the enforcement level of each partition key can be changed.
        """
        if composite_partition_key is not None:
            pulumi.set(__self__, "composite_partition_key", composite_partition_key)

    @property
    @pulumi.getter(name="compositePartitionKey")
    def composite_partition_key(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TablePartitionKeyArgs']]]]:
        """
        A non-empty list of partition keys defining the attributes used to partition the table data. The order of the list determines the partition hierarchy. The name and type of each partition key as well as the partition key order cannot be changed after the table is created. However, the enforcement level of each partition key can be changed.
        """
        return pulumi.get(self, "composite_partition_key")

    @composite_partition_key.setter
    def composite_partition_key(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TablePartitionKeyArgs']]]]):
        pulumi.set(self, "composite_partition_key", value)


if not MYPY:
    class TablePartitionKeyArgsDict(TypedDict):
        """
        An attribute used in partitioning data in a table. There are two types of partition keys: dimension keys and measure keys. A dimension key partitions data on a dimension name, while a measure key partitions data on the measure name.
        """
        type: pulumi.Input['TablePartitionKeyType']
        enforcement_in_record: NotRequired[pulumi.Input['TablePartitionKeyEnforcementLevel']]
        name: NotRequired[pulumi.Input[str]]
elif False:
    TablePartitionKeyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TablePartitionKeyArgs:
    def __init__(__self__, *,
                 type: pulumi.Input['TablePartitionKeyType'],
                 enforcement_in_record: Optional[pulumi.Input['TablePartitionKeyEnforcementLevel']] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        An attribute used in partitioning data in a table. There are two types of partition keys: dimension keys and measure keys. A dimension key partitions data on a dimension name, while a measure key partitions data on the measure name.
        """
        pulumi.set(__self__, "type", type)
        if enforcement_in_record is not None:
            pulumi.set(__self__, "enforcement_in_record", enforcement_in_record)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['TablePartitionKeyType']:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['TablePartitionKeyType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="enforcementInRecord")
    def enforcement_in_record(self) -> Optional[pulumi.Input['TablePartitionKeyEnforcementLevel']]:
        return pulumi.get(self, "enforcement_in_record")

    @enforcement_in_record.setter
    def enforcement_in_record(self, value: Optional[pulumi.Input['TablePartitionKeyEnforcementLevel']]):
        pulumi.set(self, "enforcement_in_record", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


