# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'ApplicationCredential',
]

@pulumi.output_type
class ApplicationCredential(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "credentialType":
            suggest = "credential_type"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "secretId":
            suggest = "secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationCredential. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationCredential.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationCredential.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credential_type: Optional['ApplicationCredentialCredentialType'] = None,
                 database_name: Optional[str] = None,
                 secret_id: Optional[str] = None):
        """
        :param 'ApplicationCredentialCredentialType' credential_type: The type of the application credentials.
        :param str database_name: The name of the SAP HANA database.
        :param str secret_id: The secret ID created in AWS Secrets Manager to store the credentials of the SAP application.
        """
        if credential_type is not None:
            pulumi.set(__self__, "credential_type", credential_type)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> Optional['ApplicationCredentialCredentialType']:
        """
        The type of the application credentials.
        """
        return pulumi.get(self, "credential_type")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[str]:
        """
        The name of the SAP HANA database.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[str]:
        """
        The secret ID created in AWS Secrets Manager to store the credentials of the SAP application.
        """
        return pulumi.get(self, "secret_id")


