# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['CanaryArgs', 'Canary']

@pulumi.input_type
class CanaryArgs:
    def __init__(__self__, *,
                 artifact_s3_location: pulumi.Input[str],
                 code: pulumi.Input['CanaryCodeArgs'],
                 execution_role_arn: pulumi.Input[str],
                 runtime_version: pulumi.Input[str],
                 schedule: pulumi.Input['CanaryScheduleArgs'],
                 artifact_config: Optional[pulumi.Input['CanaryArtifactConfigArgs']] = None,
                 delete_lambda_resources_on_canary_deletion: Optional[pulumi.Input[bool]] = None,
                 failure_retention_period: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 resources_to_replicate_tags: Optional[pulumi.Input[Sequence[pulumi.Input['CanaryResourceToTag']]]] = None,
                 run_config: Optional[pulumi.Input['CanaryRunConfigArgs']] = None,
                 start_canary_after_creation: Optional[pulumi.Input[bool]] = None,
                 success_retention_period: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 visual_reference: Optional[pulumi.Input['CanaryVisualReferenceArgs']] = None,
                 vpc_config: Optional[pulumi.Input['CanaryVpcConfigArgs']] = None):
        """
        The set of arguments for constructing a Canary resource.
        :param pulumi.Input[str] artifact_s3_location: Provide the s3 bucket output location for test results
        :param pulumi.Input['CanaryCodeArgs'] code: Provide the canary script source
        :param pulumi.Input[str] execution_role_arn: Lambda Execution role used to run your canaries
        :param pulumi.Input[str] runtime_version: Runtime version of Synthetics Library
        :param pulumi.Input['CanaryScheduleArgs'] schedule: Frequency to run your canaries
        :param pulumi.Input['CanaryArtifactConfigArgs'] artifact_config: Provide artifact configuration
        :param pulumi.Input[bool] delete_lambda_resources_on_canary_deletion: Deletes associated lambda resources created by Synthetics if set to True. Default is False
        :param pulumi.Input[int] failure_retention_period: Retention period of failed canary runs represented in number of days
        :param pulumi.Input[str] name: Name of the canary.
        :param pulumi.Input[Sequence[pulumi.Input['CanaryResourceToTag']]] resources_to_replicate_tags: List of resources which canary tags should be replicated to.
        :param pulumi.Input['CanaryRunConfigArgs'] run_config: Provide canary run configuration
        :param pulumi.Input[bool] start_canary_after_creation: Runs canary if set to True. Default is False
        :param pulumi.Input[int] success_retention_period: Retention period of successful canary runs represented in number of days
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The list of key-value pairs that are associated with the canary.
        :param pulumi.Input['CanaryVisualReferenceArgs'] visual_reference: Visual reference configuration for visual testing
        :param pulumi.Input['CanaryVpcConfigArgs'] vpc_config: Provide VPC Configuration if enabled.
        """
        pulumi.set(__self__, "artifact_s3_location", artifact_s3_location)
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        pulumi.set(__self__, "runtime_version", runtime_version)
        pulumi.set(__self__, "schedule", schedule)
        if artifact_config is not None:
            pulumi.set(__self__, "artifact_config", artifact_config)
        if delete_lambda_resources_on_canary_deletion is not None:
            pulumi.set(__self__, "delete_lambda_resources_on_canary_deletion", delete_lambda_resources_on_canary_deletion)
        if failure_retention_period is not None:
            pulumi.set(__self__, "failure_retention_period", failure_retention_period)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resources_to_replicate_tags is not None:
            pulumi.set(__self__, "resources_to_replicate_tags", resources_to_replicate_tags)
        if run_config is not None:
            pulumi.set(__self__, "run_config", run_config)
        if start_canary_after_creation is not None:
            pulumi.set(__self__, "start_canary_after_creation", start_canary_after_creation)
        if success_retention_period is not None:
            pulumi.set(__self__, "success_retention_period", success_retention_period)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if visual_reference is not None:
            pulumi.set(__self__, "visual_reference", visual_reference)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @property
    @pulumi.getter(name="artifactS3Location")
    def artifact_s3_location(self) -> pulumi.Input[str]:
        """
        Provide the s3 bucket output location for test results
        """
        return pulumi.get(self, "artifact_s3_location")

    @artifact_s3_location.setter
    def artifact_s3_location(self, value: pulumi.Input[str]):
        pulumi.set(self, "artifact_s3_location", value)

    @property
    @pulumi.getter
    def code(self) -> pulumi.Input['CanaryCodeArgs']:
        """
        Provide the canary script source
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: pulumi.Input['CanaryCodeArgs']):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> pulumi.Input[str]:
        """
        Lambda Execution role used to run your canaries
        """
        return pulumi.get(self, "execution_role_arn")

    @execution_role_arn.setter
    def execution_role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "execution_role_arn", value)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> pulumi.Input[str]:
        """
        Runtime version of Synthetics Library
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "runtime_version", value)

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Input['CanaryScheduleArgs']:
        """
        Frequency to run your canaries
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: pulumi.Input['CanaryScheduleArgs']):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="artifactConfig")
    def artifact_config(self) -> Optional[pulumi.Input['CanaryArtifactConfigArgs']]:
        """
        Provide artifact configuration
        """
        return pulumi.get(self, "artifact_config")

    @artifact_config.setter
    def artifact_config(self, value: Optional[pulumi.Input['CanaryArtifactConfigArgs']]):
        pulumi.set(self, "artifact_config", value)

    @property
    @pulumi.getter(name="deleteLambdaResourcesOnCanaryDeletion")
    def delete_lambda_resources_on_canary_deletion(self) -> Optional[pulumi.Input[bool]]:
        """
        Deletes associated lambda resources created by Synthetics if set to True. Default is False
        """
        return pulumi.get(self, "delete_lambda_resources_on_canary_deletion")

    @delete_lambda_resources_on_canary_deletion.setter
    def delete_lambda_resources_on_canary_deletion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_lambda_resources_on_canary_deletion", value)

    @property
    @pulumi.getter(name="failureRetentionPeriod")
    def failure_retention_period(self) -> Optional[pulumi.Input[int]]:
        """
        Retention period of failed canary runs represented in number of days
        """
        return pulumi.get(self, "failure_retention_period")

    @failure_retention_period.setter
    def failure_retention_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failure_retention_period", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the canary.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourcesToReplicateTags")
    def resources_to_replicate_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CanaryResourceToTag']]]]:
        """
        List of resources which canary tags should be replicated to.
        """
        return pulumi.get(self, "resources_to_replicate_tags")

    @resources_to_replicate_tags.setter
    def resources_to_replicate_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CanaryResourceToTag']]]]):
        pulumi.set(self, "resources_to_replicate_tags", value)

    @property
    @pulumi.getter(name="runConfig")
    def run_config(self) -> Optional[pulumi.Input['CanaryRunConfigArgs']]:
        """
        Provide canary run configuration
        """
        return pulumi.get(self, "run_config")

    @run_config.setter
    def run_config(self, value: Optional[pulumi.Input['CanaryRunConfigArgs']]):
        pulumi.set(self, "run_config", value)

    @property
    @pulumi.getter(name="startCanaryAfterCreation")
    def start_canary_after_creation(self) -> Optional[pulumi.Input[bool]]:
        """
        Runs canary if set to True. Default is False
        """
        return pulumi.get(self, "start_canary_after_creation")

    @start_canary_after_creation.setter
    def start_canary_after_creation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "start_canary_after_creation", value)

    @property
    @pulumi.getter(name="successRetentionPeriod")
    def success_retention_period(self) -> Optional[pulumi.Input[int]]:
        """
        Retention period of successful canary runs represented in number of days
        """
        return pulumi.get(self, "success_retention_period")

    @success_retention_period.setter
    def success_retention_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "success_retention_period", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The list of key-value pairs that are associated with the canary.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="visualReference")
    def visual_reference(self) -> Optional[pulumi.Input['CanaryVisualReferenceArgs']]:
        """
        Visual reference configuration for visual testing
        """
        return pulumi.get(self, "visual_reference")

    @visual_reference.setter
    def visual_reference(self, value: Optional[pulumi.Input['CanaryVisualReferenceArgs']]):
        pulumi.set(self, "visual_reference", value)

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional[pulumi.Input['CanaryVpcConfigArgs']]:
        """
        Provide VPC Configuration if enabled.
        """
        return pulumi.get(self, "vpc_config")

    @vpc_config.setter
    def vpc_config(self, value: Optional[pulumi.Input['CanaryVpcConfigArgs']]):
        pulumi.set(self, "vpc_config", value)


class Canary(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifact_config: Optional[pulumi.Input[Union['CanaryArtifactConfigArgs', 'CanaryArtifactConfigArgsDict']]] = None,
                 artifact_s3_location: Optional[pulumi.Input[str]] = None,
                 code: Optional[pulumi.Input[Union['CanaryCodeArgs', 'CanaryCodeArgsDict']]] = None,
                 delete_lambda_resources_on_canary_deletion: Optional[pulumi.Input[bool]] = None,
                 execution_role_arn: Optional[pulumi.Input[str]] = None,
                 failure_retention_period: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 resources_to_replicate_tags: Optional[pulumi.Input[Sequence[pulumi.Input['CanaryResourceToTag']]]] = None,
                 run_config: Optional[pulumi.Input[Union['CanaryRunConfigArgs', 'CanaryRunConfigArgsDict']]] = None,
                 runtime_version: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input[Union['CanaryScheduleArgs', 'CanaryScheduleArgsDict']]] = None,
                 start_canary_after_creation: Optional[pulumi.Input[bool]] = None,
                 success_retention_period: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 visual_reference: Optional[pulumi.Input[Union['CanaryVisualReferenceArgs', 'CanaryVisualReferenceArgsDict']]] = None,
                 vpc_config: Optional[pulumi.Input[Union['CanaryVpcConfigArgs', 'CanaryVpcConfigArgsDict']]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Synthetics::Canary

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        synthetics_canary = aws_native.synthetics.Canary("syntheticsCanary",
            name="samplecanary",
            execution_role_arn="arn:aws:iam::123456789012:role/my-lambda-execution-role-to-run-canary",
            code={
                "handler": "pageLoadBlueprint.handler",
                "s3_bucket": "aws-synthetics-code-myaccount-canary1",
                "s3_key": "my-script-location",
            },
            artifact_s3_location="s3://my-results-bucket",
            runtime_version="syn-nodejs-puppeteer-3.3",
            schedule={
                "expression": "rate(1 minute)",
                "duration_in_seconds": "3600",
            },
            run_config={
                "timeout_in_seconds": 60,
            },
            failure_retention_period=30,
            success_retention_period=30,
            tags=[{
                "key": "key00AtCreate",
                "value": "value001AtCreate",
            }],
            start_canary_after_creation=True)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        synthetics_canary = aws_native.synthetics.Canary("syntheticsCanary",
            name="samplecanary",
            execution_role_arn="arn:aws:iam::123456789012:role/my-lambda-execution-role-to-run-canary",
            code={
                "handler": "pageLoadBlueprint.handler",
                "script": \"\"\"var synthetics = require('Synthetics');
        const log = require('SyntheticsLogger');
        const pageLoadBlueprint = async function () {
        // INSERT URL here
        const URL = "https://amazon.com";

        let page = await synthetics.getPage();
        const response = await page.goto(URL, {waitUntil: 'domcontentloaded', timeout: 30000});
        //Wait for page to render.
        //Increase or decrease wait time based on endpoint being monitored.
        await page.waitFor(15000);
        await synthetics.takeScreenshot('loaded', 'loaded');
        let pageTitle = await page.title();
        log.info('Page title: ' + pageTitle);
        if (response.status() !== 200) {
             throw "Failed to load page!";
        }
        };

        exports.handler = async () => {
        return await pageLoadBlueprint();
        };
        \"\"\",
            },
            artifact_s3_location="s3://my-results-bucket",
            runtime_version="syn-nodejs-puppeteer-3.3",
            schedule={
                "expression": "rate(1 minute)",
                "duration_in_seconds": "3600",
            },
            run_config={
                "timeout_in_seconds": 60,
            },
            failure_retention_period=30,
            success_retention_period=30,
            tags=[{
                "key": "key00AtCreate",
                "value": "value001AtCreate",
            }],
            start_canary_after_creation=False)

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CanaryArtifactConfigArgs', 'CanaryArtifactConfigArgsDict']] artifact_config: Provide artifact configuration
        :param pulumi.Input[str] artifact_s3_location: Provide the s3 bucket output location for test results
        :param pulumi.Input[Union['CanaryCodeArgs', 'CanaryCodeArgsDict']] code: Provide the canary script source
        :param pulumi.Input[bool] delete_lambda_resources_on_canary_deletion: Deletes associated lambda resources created by Synthetics if set to True. Default is False
        :param pulumi.Input[str] execution_role_arn: Lambda Execution role used to run your canaries
        :param pulumi.Input[int] failure_retention_period: Retention period of failed canary runs represented in number of days
        :param pulumi.Input[str] name: Name of the canary.
        :param pulumi.Input[Sequence[pulumi.Input['CanaryResourceToTag']]] resources_to_replicate_tags: List of resources which canary tags should be replicated to.
        :param pulumi.Input[Union['CanaryRunConfigArgs', 'CanaryRunConfigArgsDict']] run_config: Provide canary run configuration
        :param pulumi.Input[str] runtime_version: Runtime version of Synthetics Library
        :param pulumi.Input[Union['CanaryScheduleArgs', 'CanaryScheduleArgsDict']] schedule: Frequency to run your canaries
        :param pulumi.Input[bool] start_canary_after_creation: Runs canary if set to True. Default is False
        :param pulumi.Input[int] success_retention_period: Retention period of successful canary runs represented in number of days
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The list of key-value pairs that are associated with the canary.
        :param pulumi.Input[Union['CanaryVisualReferenceArgs', 'CanaryVisualReferenceArgsDict']] visual_reference: Visual reference configuration for visual testing
        :param pulumi.Input[Union['CanaryVpcConfigArgs', 'CanaryVpcConfigArgsDict']] vpc_config: Provide VPC Configuration if enabled.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CanaryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Synthetics::Canary

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        synthetics_canary = aws_native.synthetics.Canary("syntheticsCanary",
            name="samplecanary",
            execution_role_arn="arn:aws:iam::123456789012:role/my-lambda-execution-role-to-run-canary",
            code={
                "handler": "pageLoadBlueprint.handler",
                "s3_bucket": "aws-synthetics-code-myaccount-canary1",
                "s3_key": "my-script-location",
            },
            artifact_s3_location="s3://my-results-bucket",
            runtime_version="syn-nodejs-puppeteer-3.3",
            schedule={
                "expression": "rate(1 minute)",
                "duration_in_seconds": "3600",
            },
            run_config={
                "timeout_in_seconds": 60,
            },
            failure_retention_period=30,
            success_retention_period=30,
            tags=[{
                "key": "key00AtCreate",
                "value": "value001AtCreate",
            }],
            start_canary_after_creation=True)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        synthetics_canary = aws_native.synthetics.Canary("syntheticsCanary",
            name="samplecanary",
            execution_role_arn="arn:aws:iam::123456789012:role/my-lambda-execution-role-to-run-canary",
            code={
                "handler": "pageLoadBlueprint.handler",
                "script": \"\"\"var synthetics = require('Synthetics');
        const log = require('SyntheticsLogger');
        const pageLoadBlueprint = async function () {
        // INSERT URL here
        const URL = "https://amazon.com";

        let page = await synthetics.getPage();
        const response = await page.goto(URL, {waitUntil: 'domcontentloaded', timeout: 30000});
        //Wait for page to render.
        //Increase or decrease wait time based on endpoint being monitored.
        await page.waitFor(15000);
        await synthetics.takeScreenshot('loaded', 'loaded');
        let pageTitle = await page.title();
        log.info('Page title: ' + pageTitle);
        if (response.status() !== 200) {
             throw "Failed to load page!";
        }
        };

        exports.handler = async () => {
        return await pageLoadBlueprint();
        };
        \"\"\",
            },
            artifact_s3_location="s3://my-results-bucket",
            runtime_version="syn-nodejs-puppeteer-3.3",
            schedule={
                "expression": "rate(1 minute)",
                "duration_in_seconds": "3600",
            },
            run_config={
                "timeout_in_seconds": 60,
            },
            failure_retention_period=30,
            success_retention_period=30,
            tags=[{
                "key": "key00AtCreate",
                "value": "value001AtCreate",
            }],
            start_canary_after_creation=False)

        ```

        :param str resource_name: The name of the resource.
        :param CanaryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CanaryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifact_config: Optional[pulumi.Input[Union['CanaryArtifactConfigArgs', 'CanaryArtifactConfigArgsDict']]] = None,
                 artifact_s3_location: Optional[pulumi.Input[str]] = None,
                 code: Optional[pulumi.Input[Union['CanaryCodeArgs', 'CanaryCodeArgsDict']]] = None,
                 delete_lambda_resources_on_canary_deletion: Optional[pulumi.Input[bool]] = None,
                 execution_role_arn: Optional[pulumi.Input[str]] = None,
                 failure_retention_period: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 resources_to_replicate_tags: Optional[pulumi.Input[Sequence[pulumi.Input['CanaryResourceToTag']]]] = None,
                 run_config: Optional[pulumi.Input[Union['CanaryRunConfigArgs', 'CanaryRunConfigArgsDict']]] = None,
                 runtime_version: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input[Union['CanaryScheduleArgs', 'CanaryScheduleArgsDict']]] = None,
                 start_canary_after_creation: Optional[pulumi.Input[bool]] = None,
                 success_retention_period: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 visual_reference: Optional[pulumi.Input[Union['CanaryVisualReferenceArgs', 'CanaryVisualReferenceArgsDict']]] = None,
                 vpc_config: Optional[pulumi.Input[Union['CanaryVpcConfigArgs', 'CanaryVpcConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CanaryArgs.__new__(CanaryArgs)

            __props__.__dict__["artifact_config"] = artifact_config
            if artifact_s3_location is None and not opts.urn:
                raise TypeError("Missing required property 'artifact_s3_location'")
            __props__.__dict__["artifact_s3_location"] = artifact_s3_location
            if code is None and not opts.urn:
                raise TypeError("Missing required property 'code'")
            __props__.__dict__["code"] = code
            __props__.__dict__["delete_lambda_resources_on_canary_deletion"] = delete_lambda_resources_on_canary_deletion
            if execution_role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'execution_role_arn'")
            __props__.__dict__["execution_role_arn"] = execution_role_arn
            __props__.__dict__["failure_retention_period"] = failure_retention_period
            __props__.__dict__["name"] = name
            __props__.__dict__["resources_to_replicate_tags"] = resources_to_replicate_tags
            __props__.__dict__["run_config"] = run_config
            if runtime_version is None and not opts.urn:
                raise TypeError("Missing required property 'runtime_version'")
            __props__.__dict__["runtime_version"] = runtime_version
            if schedule is None and not opts.urn:
                raise TypeError("Missing required property 'schedule'")
            __props__.__dict__["schedule"] = schedule
            __props__.__dict__["start_canary_after_creation"] = start_canary_after_creation
            __props__.__dict__["success_retention_period"] = success_retention_period
            __props__.__dict__["tags"] = tags
            __props__.__dict__["visual_reference"] = visual_reference
            __props__.__dict__["vpc_config"] = vpc_config
            __props__.__dict__["aws_id"] = None
            __props__.__dict__["state"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["name"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Canary, __self__).__init__(
            'aws-native:synthetics:Canary',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Canary':
        """
        Get an existing Canary resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = CanaryArgs.__new__(CanaryArgs)

        __props__.__dict__["artifact_config"] = None
        __props__.__dict__["artifact_s3_location"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["code"] = None
        __props__.__dict__["delete_lambda_resources_on_canary_deletion"] = None
        __props__.__dict__["execution_role_arn"] = None
        __props__.__dict__["failure_retention_period"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["resources_to_replicate_tags"] = None
        __props__.__dict__["run_config"] = None
        __props__.__dict__["runtime_version"] = None
        __props__.__dict__["schedule"] = None
        __props__.__dict__["start_canary_after_creation"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["success_retention_period"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["visual_reference"] = None
        __props__.__dict__["vpc_config"] = None
        return Canary(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="artifactConfig")
    def artifact_config(self) -> pulumi.Output[Optional['outputs.CanaryArtifactConfig']]:
        """
        Provide artifact configuration
        """
        return pulumi.get(self, "artifact_config")

    @property
    @pulumi.getter(name="artifactS3Location")
    def artifact_s3_location(self) -> pulumi.Output[str]:
        """
        Provide the s3 bucket output location for test results
        """
        return pulumi.get(self, "artifact_s3_location")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[str]:
        """
        Id of the canary
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter
    def code(self) -> pulumi.Output['outputs.CanaryCode']:
        """
        Provide the canary script source
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="deleteLambdaResourcesOnCanaryDeletion")
    def delete_lambda_resources_on_canary_deletion(self) -> pulumi.Output[Optional[bool]]:
        """
        Deletes associated lambda resources created by Synthetics if set to True. Default is False
        """
        return pulumi.get(self, "delete_lambda_resources_on_canary_deletion")

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> pulumi.Output[str]:
        """
        Lambda Execution role used to run your canaries
        """
        return pulumi.get(self, "execution_role_arn")

    @property
    @pulumi.getter(name="failureRetentionPeriod")
    def failure_retention_period(self) -> pulumi.Output[Optional[int]]:
        """
        Retention period of failed canary runs represented in number of days
        """
        return pulumi.get(self, "failure_retention_period")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the canary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourcesToReplicateTags")
    def resources_to_replicate_tags(self) -> pulumi.Output[Optional[Sequence['CanaryResourceToTag']]]:
        """
        List of resources which canary tags should be replicated to.
        """
        return pulumi.get(self, "resources_to_replicate_tags")

    @property
    @pulumi.getter(name="runConfig")
    def run_config(self) -> pulumi.Output[Optional['outputs.CanaryRunConfig']]:
        """
        Provide canary run configuration
        """
        return pulumi.get(self, "run_config")

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> pulumi.Output[str]:
        """
        Runtime version of Synthetics Library
        """
        return pulumi.get(self, "runtime_version")

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Output['outputs.CanarySchedule']:
        """
        Frequency to run your canaries
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="startCanaryAfterCreation")
    def start_canary_after_creation(self) -> pulumi.Output[Optional[bool]]:
        """
        Runs canary if set to True. Default is False
        """
        return pulumi.get(self, "start_canary_after_creation")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        State of the canary
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="successRetentionPeriod")
    def success_retention_period(self) -> pulumi.Output[Optional[int]]:
        """
        Retention period of successful canary runs represented in number of days
        """
        return pulumi.get(self, "success_retention_period")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The list of key-value pairs that are associated with the canary.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="visualReference")
    def visual_reference(self) -> pulumi.Output[Optional['outputs.CanaryVisualReference']]:
        """
        Visual reference configuration for visual testing
        """
        return pulumi.get(self, "visual_reference")

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> pulumi.Output[Optional['outputs.CanaryVpcConfig']]:
        """
        Provide VPC Configuration if enabled.
        """
        return pulumi.get(self, "vpc_config")

