# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'CanaryArtifactConfigArgs',
    'CanaryArtifactConfigArgsDict',
    'CanaryBaseScreenshotArgs',
    'CanaryBaseScreenshotArgsDict',
    'CanaryCodeArgs',
    'CanaryCodeArgsDict',
    'CanaryRunConfigArgs',
    'CanaryRunConfigArgsDict',
    'CanaryS3EncryptionArgs',
    'CanaryS3EncryptionArgsDict',
    'CanaryScheduleArgs',
    'CanaryScheduleArgsDict',
    'CanaryVisualReferenceArgs',
    'CanaryVisualReferenceArgsDict',
    'CanaryVpcConfigArgs',
    'CanaryVpcConfigArgsDict',
]

MYPY = False

if not MYPY:
    class CanaryArtifactConfigArgsDict(TypedDict):
        s3_encryption: NotRequired[pulumi.Input['CanaryS3EncryptionArgsDict']]
        """
        Encryption configuration for uploading artifacts to S3
        """
elif False:
    CanaryArtifactConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CanaryArtifactConfigArgs:
    def __init__(__self__, *,
                 s3_encryption: Optional[pulumi.Input['CanaryS3EncryptionArgs']] = None):
        """
        :param pulumi.Input['CanaryS3EncryptionArgs'] s3_encryption: Encryption configuration for uploading artifacts to S3
        """
        if s3_encryption is not None:
            pulumi.set(__self__, "s3_encryption", s3_encryption)

    @property
    @pulumi.getter(name="s3Encryption")
    def s3_encryption(self) -> Optional[pulumi.Input['CanaryS3EncryptionArgs']]:
        """
        Encryption configuration for uploading artifacts to S3
        """
        return pulumi.get(self, "s3_encryption")

    @s3_encryption.setter
    def s3_encryption(self, value: Optional[pulumi.Input['CanaryS3EncryptionArgs']]):
        pulumi.set(self, "s3_encryption", value)


if not MYPY:
    class CanaryBaseScreenshotArgsDict(TypedDict):
        screenshot_name: pulumi.Input[str]
        """
        Name of the screenshot to be used as base reference for visual testing
        """
        ignore_coordinates: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        List of coordinates of rectangles to be ignored during visual testing
        """
elif False:
    CanaryBaseScreenshotArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CanaryBaseScreenshotArgs:
    def __init__(__self__, *,
                 screenshot_name: pulumi.Input[str],
                 ignore_coordinates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] screenshot_name: Name of the screenshot to be used as base reference for visual testing
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ignore_coordinates: List of coordinates of rectangles to be ignored during visual testing
        """
        pulumi.set(__self__, "screenshot_name", screenshot_name)
        if ignore_coordinates is not None:
            pulumi.set(__self__, "ignore_coordinates", ignore_coordinates)

    @property
    @pulumi.getter(name="screenshotName")
    def screenshot_name(self) -> pulumi.Input[str]:
        """
        Name of the screenshot to be used as base reference for visual testing
        """
        return pulumi.get(self, "screenshot_name")

    @screenshot_name.setter
    def screenshot_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "screenshot_name", value)

    @property
    @pulumi.getter(name="ignoreCoordinates")
    def ignore_coordinates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of coordinates of rectangles to be ignored during visual testing
        """
        return pulumi.get(self, "ignore_coordinates")

    @ignore_coordinates.setter
    def ignore_coordinates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ignore_coordinates", value)


if not MYPY:
    class CanaryCodeArgsDict(TypedDict):
        handler: pulumi.Input[str]
        """
        The entry point to use for the source code when running the canary. For canaries that use the `syn-python-selenium-1.0` runtime or a `syn-nodejs.puppeteer` runtime earlier than `syn-nodejs.puppeteer-3.4` , the handler must be specified as `*fileName* .handler` . For `syn-python-selenium-1.1` , `syn-nodejs.puppeteer-3.4` , and later runtimes, the handler can be specified as `*fileName* . *functionName*` , or you can specify a folder where canary scripts reside as `*folder* / *fileName* . *functionName*` .
        """
        s3_bucket: NotRequired[pulumi.Input[str]]
        """
        If your canary script is located in S3, specify the bucket name here. The bucket must already exist.
        """
        s3_key: NotRequired[pulumi.Input[str]]
        """
        The S3 key of your script. For more information, see [Working with Amazon S3 Objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingObjects.html) .
        """
        s3_object_version: NotRequired[pulumi.Input[str]]
        """
        The S3 version ID of your script.
        """
        script: NotRequired[pulumi.Input[str]]
        """
        If you input your canary script directly into the canary instead of referring to an S3 location, the value of this parameter is the script in plain text. It can be up to 5 MB.
        """
        source_location_arn: NotRequired[pulumi.Input[str]]
        """
        The ARN of the Lambda layer where Synthetics stores the canary script code.
        """
elif False:
    CanaryCodeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CanaryCodeArgs:
    def __init__(__self__, *,
                 handler: pulumi.Input[str],
                 s3_bucket: Optional[pulumi.Input[str]] = None,
                 s3_key: Optional[pulumi.Input[str]] = None,
                 s3_object_version: Optional[pulumi.Input[str]] = None,
                 script: Optional[pulumi.Input[str]] = None,
                 source_location_arn: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] handler: The entry point to use for the source code when running the canary. For canaries that use the `syn-python-selenium-1.0` runtime or a `syn-nodejs.puppeteer` runtime earlier than `syn-nodejs.puppeteer-3.4` , the handler must be specified as `*fileName* .handler` . For `syn-python-selenium-1.1` , `syn-nodejs.puppeteer-3.4` , and later runtimes, the handler can be specified as `*fileName* . *functionName*` , or you can specify a folder where canary scripts reside as `*folder* / *fileName* . *functionName*` .
        :param pulumi.Input[str] s3_bucket: If your canary script is located in S3, specify the bucket name here. The bucket must already exist.
        :param pulumi.Input[str] s3_key: The S3 key of your script. For more information, see [Working with Amazon S3 Objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingObjects.html) .
        :param pulumi.Input[str] s3_object_version: The S3 version ID of your script.
        :param pulumi.Input[str] script: If you input your canary script directly into the canary instead of referring to an S3 location, the value of this parameter is the script in plain text. It can be up to 5 MB.
        :param pulumi.Input[str] source_location_arn: The ARN of the Lambda layer where Synthetics stores the canary script code.
        """
        pulumi.set(__self__, "handler", handler)
        if s3_bucket is not None:
            pulumi.set(__self__, "s3_bucket", s3_bucket)
        if s3_key is not None:
            pulumi.set(__self__, "s3_key", s3_key)
        if s3_object_version is not None:
            pulumi.set(__self__, "s3_object_version", s3_object_version)
        if script is not None:
            pulumi.set(__self__, "script", script)
        if source_location_arn is not None:
            pulumi.set(__self__, "source_location_arn", source_location_arn)

    @property
    @pulumi.getter
    def handler(self) -> pulumi.Input[str]:
        """
        The entry point to use for the source code when running the canary. For canaries that use the `syn-python-selenium-1.0` runtime or a `syn-nodejs.puppeteer` runtime earlier than `syn-nodejs.puppeteer-3.4` , the handler must be specified as `*fileName* .handler` . For `syn-python-selenium-1.1` , `syn-nodejs.puppeteer-3.4` , and later runtimes, the handler can be specified as `*fileName* . *functionName*` , or you can specify a folder where canary scripts reside as `*folder* / *fileName* . *functionName*` .
        """
        return pulumi.get(self, "handler")

    @handler.setter
    def handler(self, value: pulumi.Input[str]):
        pulumi.set(self, "handler", value)

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        If your canary script is located in S3, specify the bucket name here. The bucket must already exist.
        """
        return pulumi.get(self, "s3_bucket")

    @s3_bucket.setter
    def s3_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_bucket", value)

    @property
    @pulumi.getter(name="s3Key")
    def s3_key(self) -> Optional[pulumi.Input[str]]:
        """
        The S3 key of your script. For more information, see [Working with Amazon S3 Objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingObjects.html) .
        """
        return pulumi.get(self, "s3_key")

    @s3_key.setter
    def s3_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_key", value)

    @property
    @pulumi.getter(name="s3ObjectVersion")
    def s3_object_version(self) -> Optional[pulumi.Input[str]]:
        """
        The S3 version ID of your script.
        """
        return pulumi.get(self, "s3_object_version")

    @s3_object_version.setter
    def s3_object_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_object_version", value)

    @property
    @pulumi.getter
    def script(self) -> Optional[pulumi.Input[str]]:
        """
        If you input your canary script directly into the canary instead of referring to an S3 location, the value of this parameter is the script in plain text. It can be up to 5 MB.
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script", value)

    @property
    @pulumi.getter(name="sourceLocationArn")
    def source_location_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the Lambda layer where Synthetics stores the canary script code.
        """
        return pulumi.get(self, "source_location_arn")

    @source_location_arn.setter
    def source_location_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_location_arn", value)


if not MYPY:
    class CanaryRunConfigArgsDict(TypedDict):
        active_tracing: NotRequired[pulumi.Input[bool]]
        """
        Enable active tracing if set to true
        """
        environment_variables: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[str]]]]
        """
        Environment variable key-value pairs.
        """
        memory_in_mb: NotRequired[pulumi.Input[int]]
        """
        Provide maximum memory available for canary in MB
        """
        timeout_in_seconds: NotRequired[pulumi.Input[int]]
        """
        Provide maximum canary timeout per run in seconds
        """
elif False:
    CanaryRunConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CanaryRunConfigArgs:
    def __init__(__self__, *,
                 active_tracing: Optional[pulumi.Input[bool]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 memory_in_mb: Optional[pulumi.Input[int]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[bool] active_tracing: Enable active tracing if set to true
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: Environment variable key-value pairs.
        :param pulumi.Input[int] memory_in_mb: Provide maximum memory available for canary in MB
        :param pulumi.Input[int] timeout_in_seconds: Provide maximum canary timeout per run in seconds
        """
        if active_tracing is not None:
            pulumi.set(__self__, "active_tracing", active_tracing)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if memory_in_mb is not None:
            pulumi.set(__self__, "memory_in_mb", memory_in_mb)
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)

    @property
    @pulumi.getter(name="activeTracing")
    def active_tracing(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable active tracing if set to true
        """
        return pulumi.get(self, "active_tracing")

    @active_tracing.setter
    def active_tracing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active_tracing", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Environment variable key-value pairs.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="memoryInMb")
    def memory_in_mb(self) -> Optional[pulumi.Input[int]]:
        """
        Provide maximum memory available for canary in MB
        """
        return pulumi.get(self, "memory_in_mb")

    @memory_in_mb.setter
    def memory_in_mb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_in_mb", value)

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Provide maximum canary timeout per run in seconds
        """
        return pulumi.get(self, "timeout_in_seconds")

    @timeout_in_seconds.setter
    def timeout_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_in_seconds", value)


if not MYPY:
    class CanaryS3EncryptionArgsDict(TypedDict):
        encryption_mode: NotRequired[pulumi.Input[str]]
        """
        Encryption mode for encrypting artifacts when uploading to S3. Valid values: SSE_S3 and SSE_KMS.
        """
        kms_key_arn: NotRequired[pulumi.Input[str]]
        """
        KMS key Arn for encrypting artifacts when uploading to S3. You must specify KMS key Arn for SSE_KMS encryption mode only.
        """
elif False:
    CanaryS3EncryptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CanaryS3EncryptionArgs:
    def __init__(__self__, *,
                 encryption_mode: Optional[pulumi.Input[str]] = None,
                 kms_key_arn: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] encryption_mode: Encryption mode for encrypting artifacts when uploading to S3. Valid values: SSE_S3 and SSE_KMS.
        :param pulumi.Input[str] kms_key_arn: KMS key Arn for encrypting artifacts when uploading to S3. You must specify KMS key Arn for SSE_KMS encryption mode only.
        """
        if encryption_mode is not None:
            pulumi.set(__self__, "encryption_mode", encryption_mode)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @property
    @pulumi.getter(name="encryptionMode")
    def encryption_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Encryption mode for encrypting artifacts when uploading to S3. Valid values: SSE_S3 and SSE_KMS.
        """
        return pulumi.get(self, "encryption_mode")

    @encryption_mode.setter
    def encryption_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_mode", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[str]]:
        """
        KMS key Arn for encrypting artifacts when uploading to S3. You must specify KMS key Arn for SSE_KMS encryption mode only.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_arn", value)


if not MYPY:
    class CanaryScheduleArgsDict(TypedDict):
        expression: pulumi.Input[str]
        """
        A `rate` expression or a `cron` expression that defines how often the canary is to run.

        For a rate expression, The syntax is `rate( *number unit* )` . *unit* can be `minute` , `minutes` , or `hour` .

        For example, `rate(1 minute)` runs the canary once a minute, `rate(10 minutes)` runs it once every 10 minutes, and `rate(1 hour)` runs it once every hour. You can specify a frequency between `rate(1 minute)` and `rate(1 hour)` .

        Specifying `rate(0 minute)` or `rate(0 hour)` is a special value that causes the canary to run only once when it is started.

        Use `cron( *expression* )` to specify a cron expression. You can't schedule a canary to wait for more than a year before running. For information about the syntax for cron expressions, see [Scheduling canary runs using cron](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html) .
        """
        duration_in_seconds: NotRequired[pulumi.Input[str]]
        """
        How long, in seconds, for the canary to continue making regular runs according to the schedule in the `Expression` value. If you specify 0, the canary continues making runs until you stop it. If you omit this field, the default of 0 is used.
        """
elif False:
    CanaryScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CanaryScheduleArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 duration_in_seconds: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] expression: A `rate` expression or a `cron` expression that defines how often the canary is to run.
               
               For a rate expression, The syntax is `rate( *number unit* )` . *unit* can be `minute` , `minutes` , or `hour` .
               
               For example, `rate(1 minute)` runs the canary once a minute, `rate(10 minutes)` runs it once every 10 minutes, and `rate(1 hour)` runs it once every hour. You can specify a frequency between `rate(1 minute)` and `rate(1 hour)` .
               
               Specifying `rate(0 minute)` or `rate(0 hour)` is a special value that causes the canary to run only once when it is started.
               
               Use `cron( *expression* )` to specify a cron expression. You can't schedule a canary to wait for more than a year before running. For information about the syntax for cron expressions, see [Scheduling canary runs using cron](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html) .
        :param pulumi.Input[str] duration_in_seconds: How long, in seconds, for the canary to continue making regular runs according to the schedule in the `Expression` value. If you specify 0, the canary continues making runs until you stop it. If you omit this field, the default of 0 is used.
        """
        pulumi.set(__self__, "expression", expression)
        if duration_in_seconds is not None:
            pulumi.set(__self__, "duration_in_seconds", duration_in_seconds)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        """
        A `rate` expression or a `cron` expression that defines how often the canary is to run.

        For a rate expression, The syntax is `rate( *number unit* )` . *unit* can be `minute` , `minutes` , or `hour` .

        For example, `rate(1 minute)` runs the canary once a minute, `rate(10 minutes)` runs it once every 10 minutes, and `rate(1 hour)` runs it once every hour. You can specify a frequency between `rate(1 minute)` and `rate(1 hour)` .

        Specifying `rate(0 minute)` or `rate(0 hour)` is a special value that causes the canary to run only once when it is started.

        Use `cron( *expression* )` to specify a cron expression. You can't schedule a canary to wait for more than a year before running. For information about the syntax for cron expressions, see [Scheduling canary runs using cron](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html) .
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter(name="durationInSeconds")
    def duration_in_seconds(self) -> Optional[pulumi.Input[str]]:
        """
        How long, in seconds, for the canary to continue making regular runs according to the schedule in the `Expression` value. If you specify 0, the canary continues making runs until you stop it. If you omit this field, the default of 0 is used.
        """
        return pulumi.get(self, "duration_in_seconds")

    @duration_in_seconds.setter
    def duration_in_seconds(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "duration_in_seconds", value)


if not MYPY:
    class CanaryVisualReferenceArgsDict(TypedDict):
        base_canary_run_id: pulumi.Input[str]
        """
        Canary run id to be used as base reference for visual testing
        """
        base_screenshots: NotRequired[pulumi.Input[Sequence[pulumi.Input['CanaryBaseScreenshotArgsDict']]]]
        """
        List of screenshots used as base reference for visual testing
        """
elif False:
    CanaryVisualReferenceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CanaryVisualReferenceArgs:
    def __init__(__self__, *,
                 base_canary_run_id: pulumi.Input[str],
                 base_screenshots: Optional[pulumi.Input[Sequence[pulumi.Input['CanaryBaseScreenshotArgs']]]] = None):
        """
        :param pulumi.Input[str] base_canary_run_id: Canary run id to be used as base reference for visual testing
        :param pulumi.Input[Sequence[pulumi.Input['CanaryBaseScreenshotArgs']]] base_screenshots: List of screenshots used as base reference for visual testing
        """
        pulumi.set(__self__, "base_canary_run_id", base_canary_run_id)
        if base_screenshots is not None:
            pulumi.set(__self__, "base_screenshots", base_screenshots)

    @property
    @pulumi.getter(name="baseCanaryRunId")
    def base_canary_run_id(self) -> pulumi.Input[str]:
        """
        Canary run id to be used as base reference for visual testing
        """
        return pulumi.get(self, "base_canary_run_id")

    @base_canary_run_id.setter
    def base_canary_run_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "base_canary_run_id", value)

    @property
    @pulumi.getter(name="baseScreenshots")
    def base_screenshots(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CanaryBaseScreenshotArgs']]]]:
        """
        List of screenshots used as base reference for visual testing
        """
        return pulumi.get(self, "base_screenshots")

    @base_screenshots.setter
    def base_screenshots(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CanaryBaseScreenshotArgs']]]]):
        pulumi.set(self, "base_screenshots", value)


if not MYPY:
    class CanaryVpcConfigArgsDict(TypedDict):
        security_group_ids: pulumi.Input[Sequence[pulumi.Input[str]]]
        """
        The IDs of the security groups for this canary.
        """
        subnet_ids: pulumi.Input[Sequence[pulumi.Input[str]]]
        """
        The IDs of the subnets where this canary is to run.
        """
        vpc_id: NotRequired[pulumi.Input[str]]
        """
        The ID of the VPC where this canary is to run.
        """
elif False:
    CanaryVpcConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CanaryVpcConfigArgs:
    def __init__(__self__, *,
                 security_group_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 subnet_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: The IDs of the security groups for this canary.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: The IDs of the subnets where this canary is to run.
        :param pulumi.Input[str] vpc_id: The ID of the VPC where this canary is to run.
        """
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The IDs of the security groups for this canary.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The IDs of the subnets where this canary is to run.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the VPC where this canary is to run.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


