# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['StateMachineArgs', 'StateMachine']

@pulumi.input_type
class StateMachineArgs:
    def __init__(__self__, *,
                 role_arn: pulumi.Input[str],
                 definition: Optional[pulumi.Input['StateMachineDefinitionArgs']] = None,
                 definition_s3_location: Optional[pulumi.Input['StateMachineS3LocationArgs']] = None,
                 definition_string: Optional[pulumi.Input[str]] = None,
                 definition_substitutions: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union[str, int, bool]]]]] = None,
                 encryption_configuration: Optional[pulumi.Input['StateMachineEncryptionConfigurationArgs']] = None,
                 logging_configuration: Optional[pulumi.Input['StateMachineLoggingConfigurationArgs']] = None,
                 state_machine_name: Optional[pulumi.Input[str]] = None,
                 state_machine_type: Optional[pulumi.Input['StateMachineType']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 tracing_configuration: Optional[pulumi.Input['StateMachineTracingConfigurationArgs']] = None):
        """
        The set of arguments for constructing a StateMachine resource.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) of the IAM role to use for this state machine.
        :param pulumi.Input['StateMachineDefinitionArgs'] definition: The Amazon States Language definition of the state machine. The state machine definition must be in JSON or YAML, and the format of the object must match the format of your CloudFormation template file. See [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html) .
        :param pulumi.Input['StateMachineS3LocationArgs'] definition_s3_location: The name of the S3 bucket where the state machine definition is stored. The state machine definition must be a JSON or YAML file.
        :param pulumi.Input[str] definition_string: The Amazon States Language definition of the state machine. The state machine definition must be in JSON. See [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html) .
        :param pulumi.Input[Mapping[str, pulumi.Input[Union[str, int, bool]]]] definition_substitutions: A map (string to string) that specifies the mappings for placeholder variables in the state machine definition. This enables the customer to inject values obtained at runtime, for example from intrinsic functions, in the state machine definition. Variables can be template parameter names, resource logical IDs, resource attributes, or a variable in a key-value map.
               
               Substitutions must follow the syntax: `${key_name}` or `${variable_1,variable_2,...}` .
        :param pulumi.Input['StateMachineEncryptionConfigurationArgs'] encryption_configuration: Encryption configuration for the state machine.
        :param pulumi.Input['StateMachineLoggingConfigurationArgs'] logging_configuration: Defines what execution history events are logged and where they are logged.
               
               > By default, the `level` is set to `OFF` . For more information see [Log Levels](https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html) in the AWS Step Functions User Guide.
        :param pulumi.Input[str] state_machine_name: The name of the state machine.
               
               A name must *not* contain:
               
               - white space
               - brackets `< > { } [ ]`
               - wildcard characters `? *`
               - special characters `" # % \\ ^ | ~ ` $ & , ; : /`
               - control characters ( `U+0000-001F` , `U+007F-009F` )
               
               > If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
        :param pulumi.Input['StateMachineType'] state_machine_type: Determines whether a `STANDARD` or `EXPRESS` state machine is created. The default is `STANDARD` . You cannot update the `type` of a state machine once it has been created. For more information on `STANDARD` and `EXPRESS` workflows, see [Standard Versus Express Workflows](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-standard-vs-express.html) in the AWS Step Functions Developer Guide.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The list of tags to add to a resource.
               
               Tags may only contain Unicode letters, digits, white space, or these symbols: `_ . : / = + - @` .
        :param pulumi.Input['StateMachineTracingConfigurationArgs'] tracing_configuration: Selects whether or not the state machine's AWS X-Ray tracing is enabled.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        if definition is not None:
            pulumi.set(__self__, "definition", definition)
        if definition_s3_location is not None:
            pulumi.set(__self__, "definition_s3_location", definition_s3_location)
        if definition_string is not None:
            pulumi.set(__self__, "definition_string", definition_string)
        if definition_substitutions is not None:
            pulumi.set(__self__, "definition_substitutions", definition_substitutions)
        if encryption_configuration is not None:
            pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if logging_configuration is not None:
            pulumi.set(__self__, "logging_configuration", logging_configuration)
        if state_machine_name is not None:
            pulumi.set(__self__, "state_machine_name", state_machine_name)
        if state_machine_type is not None:
            pulumi.set(__self__, "state_machine_type", state_machine_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tracing_configuration is not None:
            pulumi.set(__self__, "tracing_configuration", tracing_configuration)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of the IAM role to use for this state machine.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def definition(self) -> Optional[pulumi.Input['StateMachineDefinitionArgs']]:
        """
        The Amazon States Language definition of the state machine. The state machine definition must be in JSON or YAML, and the format of the object must match the format of your CloudFormation template file. See [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html) .
        """
        return pulumi.get(self, "definition")

    @definition.setter
    def definition(self, value: Optional[pulumi.Input['StateMachineDefinitionArgs']]):
        pulumi.set(self, "definition", value)

    @property
    @pulumi.getter(name="definitionS3Location")
    def definition_s3_location(self) -> Optional[pulumi.Input['StateMachineS3LocationArgs']]:
        """
        The name of the S3 bucket where the state machine definition is stored. The state machine definition must be a JSON or YAML file.
        """
        return pulumi.get(self, "definition_s3_location")

    @definition_s3_location.setter
    def definition_s3_location(self, value: Optional[pulumi.Input['StateMachineS3LocationArgs']]):
        pulumi.set(self, "definition_s3_location", value)

    @property
    @pulumi.getter(name="definitionString")
    def definition_string(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon States Language definition of the state machine. The state machine definition must be in JSON. See [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html) .
        """
        return pulumi.get(self, "definition_string")

    @definition_string.setter
    def definition_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "definition_string", value)

    @property
    @pulumi.getter(name="definitionSubstitutions")
    def definition_substitutions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Union[str, int, bool]]]]]:
        """
        A map (string to string) that specifies the mappings for placeholder variables in the state machine definition. This enables the customer to inject values obtained at runtime, for example from intrinsic functions, in the state machine definition. Variables can be template parameter names, resource logical IDs, resource attributes, or a variable in a key-value map.

        Substitutions must follow the syntax: `${key_name}` or `${variable_1,variable_2,...}` .
        """
        return pulumi.get(self, "definition_substitutions")

    @definition_substitutions.setter
    def definition_substitutions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union[str, int, bool]]]]]):
        pulumi.set(self, "definition_substitutions", value)

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional[pulumi.Input['StateMachineEncryptionConfigurationArgs']]:
        """
        Encryption configuration for the state machine.
        """
        return pulumi.get(self, "encryption_configuration")

    @encryption_configuration.setter
    def encryption_configuration(self, value: Optional[pulumi.Input['StateMachineEncryptionConfigurationArgs']]):
        pulumi.set(self, "encryption_configuration", value)

    @property
    @pulumi.getter(name="loggingConfiguration")
    def logging_configuration(self) -> Optional[pulumi.Input['StateMachineLoggingConfigurationArgs']]:
        """
        Defines what execution history events are logged and where they are logged.

        > By default, the `level` is set to `OFF` . For more information see [Log Levels](https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html) in the AWS Step Functions User Guide.
        """
        return pulumi.get(self, "logging_configuration")

    @logging_configuration.setter
    def logging_configuration(self, value: Optional[pulumi.Input['StateMachineLoggingConfigurationArgs']]):
        pulumi.set(self, "logging_configuration", value)

    @property
    @pulumi.getter(name="stateMachineName")
    def state_machine_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the state machine.

        A name must *not* contain:

        - white space
        - brackets `< > { } [ ]`
        - wildcard characters `? *`
        - special characters `" # % \\ ^ | ~ ` $ & , ; : /`
        - control characters ( `U+0000-001F` , `U+007F-009F` )

        > If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
        """
        return pulumi.get(self, "state_machine_name")

    @state_machine_name.setter
    def state_machine_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state_machine_name", value)

    @property
    @pulumi.getter(name="stateMachineType")
    def state_machine_type(self) -> Optional[pulumi.Input['StateMachineType']]:
        """
        Determines whether a `STANDARD` or `EXPRESS` state machine is created. The default is `STANDARD` . You cannot update the `type` of a state machine once it has been created. For more information on `STANDARD` and `EXPRESS` workflows, see [Standard Versus Express Workflows](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-standard-vs-express.html) in the AWS Step Functions Developer Guide.
        """
        return pulumi.get(self, "state_machine_type")

    @state_machine_type.setter
    def state_machine_type(self, value: Optional[pulumi.Input['StateMachineType']]):
        pulumi.set(self, "state_machine_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The list of tags to add to a resource.

        Tags may only contain Unicode letters, digits, white space, or these symbols: `_ . : / = + - @` .
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tracingConfiguration")
    def tracing_configuration(self) -> Optional[pulumi.Input['StateMachineTracingConfigurationArgs']]:
        """
        Selects whether or not the state machine's AWS X-Ray tracing is enabled.
        """
        return pulumi.get(self, "tracing_configuration")

    @tracing_configuration.setter
    def tracing_configuration(self, value: Optional[pulumi.Input['StateMachineTracingConfigurationArgs']]):
        pulumi.set(self, "tracing_configuration", value)


class StateMachine(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 definition: Optional[pulumi.Input[Union['StateMachineDefinitionArgs', 'StateMachineDefinitionArgsDict']]] = None,
                 definition_s3_location: Optional[pulumi.Input[Union['StateMachineS3LocationArgs', 'StateMachineS3LocationArgsDict']]] = None,
                 definition_string: Optional[pulumi.Input[str]] = None,
                 definition_substitutions: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union[str, int, bool]]]]] = None,
                 encryption_configuration: Optional[pulumi.Input[Union['StateMachineEncryptionConfigurationArgs', 'StateMachineEncryptionConfigurationArgsDict']]] = None,
                 logging_configuration: Optional[pulumi.Input[Union['StateMachineLoggingConfigurationArgs', 'StateMachineLoggingConfigurationArgsDict']]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 state_machine_name: Optional[pulumi.Input[str]] = None,
                 state_machine_type: Optional[pulumi.Input['StateMachineType']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 tracing_configuration: Optional[pulumi.Input[Union['StateMachineTracingConfigurationArgs', 'StateMachineTracingConfigurationArgsDict']]] = None,
                 __props__=None):
        """
        Resource schema for StateMachine

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_state_machine = aws_native.stepfunctions.StateMachine("myStateMachine",
            state_machine_name="HelloWorld-StateMachine",
            state_machine_type=aws_native.stepfunctions.StateMachineType.STANDARD,
            definition_string="{\\"StartAt\\": \\"HelloWorld\\",  \\"States\\": {\\"HelloWorld\\": {\\"Type\\": \\"Task\\", \\"Resource\\":  \\"arn:aws:lambda:us-east-1:111122223333;:function:HelloFunction\\", \\"End\\": true}}}",
            role_arn="arn:aws:iam::111122223333:role/service-role/StatesExecutionRole-us-east-1;")

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_state_machine = aws_native.stepfunctions.StateMachine("myStateMachine",
            state_machine_name="HelloWorld-StateMachine",
            state_machine_type=aws_native.stepfunctions.StateMachineType.STANDARD,
            definition_string=\"\"\"{
            "StartAt": "HelloWorld",
            "States" : {
                "HelloWorld" : {
                    "Type" : "Task", 
                    "Resource" : "arn:aws:lambda:us-east-1:111122223333:function:HelloFunction",
                    "End" : true
                }
            }
        }\"\"\",
            role_arn="arn:aws:iam::111122223333:role/service-role/StatesExecutionRole-us-east-1",
            tags=[
                {
                    "key": "keyname1",
                    "value": "value1",
                },
                {
                    "key": "keyname2",
                    "value": "value2",
                },
            ])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_state_machine = aws_native.stepfunctions.StateMachine("myStateMachine",
            state_machine_name="HelloWorld-StateMachine",
            definition_string=\"\"\"{
          "StartAt": "HelloWorld",
          "States": {
            "HelloWorld": {
              "Type": "Task",
              "Resource": "arn:aws:lambda:us-east-1:111122223333:function:HelloFunction",
              "End": true
            }
          }
        }\"\"\",
            role_arn="arn:aws:iam::111122223333:role/service-role/StatesExecutionRole-us-east-1",
            tags=[
                {
                    "key": "keyname1",
                    "value": "value1",
                },
                {
                    "key": "keyname2",
                    "value": "value2",
                },
            ])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_state_machine = aws_native.stepfunctions.StateMachine("myStateMachine",
            state_machine_name="HelloWorld-StateMachine",
            definition_s3_location={
                "bucket": "example_bucket",
                "key": "hello_world.json",
            },
            definition_substitutions={
                "helloFunction": "arn:aws:lambda:us-east-1:111122223333:function:HelloFunction",
            },
            role_arn="arn:aws:iam::111122223333:role/service-role/StatesExecutionRole-us-east-1")

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['StateMachineDefinitionArgs', 'StateMachineDefinitionArgsDict']] definition: The Amazon States Language definition of the state machine. The state machine definition must be in JSON or YAML, and the format of the object must match the format of your CloudFormation template file. See [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html) .
        :param pulumi.Input[Union['StateMachineS3LocationArgs', 'StateMachineS3LocationArgsDict']] definition_s3_location: The name of the S3 bucket where the state machine definition is stored. The state machine definition must be a JSON or YAML file.
        :param pulumi.Input[str] definition_string: The Amazon States Language definition of the state machine. The state machine definition must be in JSON. See [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html) .
        :param pulumi.Input[Mapping[str, pulumi.Input[Union[str, int, bool]]]] definition_substitutions: A map (string to string) that specifies the mappings for placeholder variables in the state machine definition. This enables the customer to inject values obtained at runtime, for example from intrinsic functions, in the state machine definition. Variables can be template parameter names, resource logical IDs, resource attributes, or a variable in a key-value map.
               
               Substitutions must follow the syntax: `${key_name}` or `${variable_1,variable_2,...}` .
        :param pulumi.Input[Union['StateMachineEncryptionConfigurationArgs', 'StateMachineEncryptionConfigurationArgsDict']] encryption_configuration: Encryption configuration for the state machine.
        :param pulumi.Input[Union['StateMachineLoggingConfigurationArgs', 'StateMachineLoggingConfigurationArgsDict']] logging_configuration: Defines what execution history events are logged and where they are logged.
               
               > By default, the `level` is set to `OFF` . For more information see [Log Levels](https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html) in the AWS Step Functions User Guide.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) of the IAM role to use for this state machine.
        :param pulumi.Input[str] state_machine_name: The name of the state machine.
               
               A name must *not* contain:
               
               - white space
               - brackets `< > { } [ ]`
               - wildcard characters `? *`
               - special characters `" # % \\ ^ | ~ ` $ & , ; : /`
               - control characters ( `U+0000-001F` , `U+007F-009F` )
               
               > If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
        :param pulumi.Input['StateMachineType'] state_machine_type: Determines whether a `STANDARD` or `EXPRESS` state machine is created. The default is `STANDARD` . You cannot update the `type` of a state machine once it has been created. For more information on `STANDARD` and `EXPRESS` workflows, see [Standard Versus Express Workflows](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-standard-vs-express.html) in the AWS Step Functions Developer Guide.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The list of tags to add to a resource.
               
               Tags may only contain Unicode letters, digits, white space, or these symbols: `_ . : / = + - @` .
        :param pulumi.Input[Union['StateMachineTracingConfigurationArgs', 'StateMachineTracingConfigurationArgsDict']] tracing_configuration: Selects whether or not the state machine's AWS X-Ray tracing is enabled.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StateMachineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for StateMachine

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_state_machine = aws_native.stepfunctions.StateMachine("myStateMachine",
            state_machine_name="HelloWorld-StateMachine",
            state_machine_type=aws_native.stepfunctions.StateMachineType.STANDARD,
            definition_string="{\\"StartAt\\": \\"HelloWorld\\",  \\"States\\": {\\"HelloWorld\\": {\\"Type\\": \\"Task\\", \\"Resource\\":  \\"arn:aws:lambda:us-east-1:111122223333;:function:HelloFunction\\", \\"End\\": true}}}",
            role_arn="arn:aws:iam::111122223333:role/service-role/StatesExecutionRole-us-east-1;")

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_state_machine = aws_native.stepfunctions.StateMachine("myStateMachine",
            state_machine_name="HelloWorld-StateMachine",
            state_machine_type=aws_native.stepfunctions.StateMachineType.STANDARD,
            definition_string=\"\"\"{
            "StartAt": "HelloWorld",
            "States" : {
                "HelloWorld" : {
                    "Type" : "Task", 
                    "Resource" : "arn:aws:lambda:us-east-1:111122223333:function:HelloFunction",
                    "End" : true
                }
            }
        }\"\"\",
            role_arn="arn:aws:iam::111122223333:role/service-role/StatesExecutionRole-us-east-1",
            tags=[
                {
                    "key": "keyname1",
                    "value": "value1",
                },
                {
                    "key": "keyname2",
                    "value": "value2",
                },
            ])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_state_machine = aws_native.stepfunctions.StateMachine("myStateMachine",
            state_machine_name="HelloWorld-StateMachine",
            definition_string=\"\"\"{
          "StartAt": "HelloWorld",
          "States": {
            "HelloWorld": {
              "Type": "Task",
              "Resource": "arn:aws:lambda:us-east-1:111122223333:function:HelloFunction",
              "End": true
            }
          }
        }\"\"\",
            role_arn="arn:aws:iam::111122223333:role/service-role/StatesExecutionRole-us-east-1",
            tags=[
                {
                    "key": "keyname1",
                    "value": "value1",
                },
                {
                    "key": "keyname2",
                    "value": "value2",
                },
            ])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_state_machine = aws_native.stepfunctions.StateMachine("myStateMachine",
            state_machine_name="HelloWorld-StateMachine",
            definition_s3_location={
                "bucket": "example_bucket",
                "key": "hello_world.json",
            },
            definition_substitutions={
                "helloFunction": "arn:aws:lambda:us-east-1:111122223333:function:HelloFunction",
            },
            role_arn="arn:aws:iam::111122223333:role/service-role/StatesExecutionRole-us-east-1")

        ```

        :param str resource_name: The name of the resource.
        :param StateMachineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StateMachineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 definition: Optional[pulumi.Input[Union['StateMachineDefinitionArgs', 'StateMachineDefinitionArgsDict']]] = None,
                 definition_s3_location: Optional[pulumi.Input[Union['StateMachineS3LocationArgs', 'StateMachineS3LocationArgsDict']]] = None,
                 definition_string: Optional[pulumi.Input[str]] = None,
                 definition_substitutions: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union[str, int, bool]]]]] = None,
                 encryption_configuration: Optional[pulumi.Input[Union['StateMachineEncryptionConfigurationArgs', 'StateMachineEncryptionConfigurationArgsDict']]] = None,
                 logging_configuration: Optional[pulumi.Input[Union['StateMachineLoggingConfigurationArgs', 'StateMachineLoggingConfigurationArgsDict']]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 state_machine_name: Optional[pulumi.Input[str]] = None,
                 state_machine_type: Optional[pulumi.Input['StateMachineType']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 tracing_configuration: Optional[pulumi.Input[Union['StateMachineTracingConfigurationArgs', 'StateMachineTracingConfigurationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StateMachineArgs.__new__(StateMachineArgs)

            __props__.__dict__["definition"] = definition
            __props__.__dict__["definition_s3_location"] = definition_s3_location
            __props__.__dict__["definition_string"] = definition_string
            __props__.__dict__["definition_substitutions"] = definition_substitutions
            __props__.__dict__["encryption_configuration"] = encryption_configuration
            __props__.__dict__["logging_configuration"] = logging_configuration
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["state_machine_name"] = state_machine_name
            __props__.__dict__["state_machine_type"] = state_machine_type
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tracing_configuration"] = tracing_configuration
            __props__.__dict__["arn"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["state_machine_revision_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["stateMachineName", "stateMachineType"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(StateMachine, __self__).__init__(
            'aws-native:stepfunctions:StateMachine',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'StateMachine':
        """
        Get an existing StateMachine resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = StateMachineArgs.__new__(StateMachineArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["definition"] = None
        __props__.__dict__["definition_s3_location"] = None
        __props__.__dict__["definition_string"] = None
        __props__.__dict__["definition_substitutions"] = None
        __props__.__dict__["encryption_configuration"] = None
        __props__.__dict__["logging_configuration"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["role_arn"] = None
        __props__.__dict__["state_machine_name"] = None
        __props__.__dict__["state_machine_revision_id"] = None
        __props__.__dict__["state_machine_type"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["tracing_configuration"] = None
        return StateMachine(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        Returns the ARN of the resource.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def definition(self) -> pulumi.Output[Optional['outputs.StateMachineDefinition']]:
        """
        The Amazon States Language definition of the state machine. The state machine definition must be in JSON or YAML, and the format of the object must match the format of your CloudFormation template file. See [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html) .
        """
        return pulumi.get(self, "definition")

    @property
    @pulumi.getter(name="definitionS3Location")
    def definition_s3_location(self) -> pulumi.Output[Optional['outputs.StateMachineS3Location']]:
        """
        The name of the S3 bucket where the state machine definition is stored. The state machine definition must be a JSON or YAML file.
        """
        return pulumi.get(self, "definition_s3_location")

    @property
    @pulumi.getter(name="definitionString")
    def definition_string(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon States Language definition of the state machine. The state machine definition must be in JSON. See [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html) .
        """
        return pulumi.get(self, "definition_string")

    @property
    @pulumi.getter(name="definitionSubstitutions")
    def definition_substitutions(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A map (string to string) that specifies the mappings for placeholder variables in the state machine definition. This enables the customer to inject values obtained at runtime, for example from intrinsic functions, in the state machine definition. Variables can be template parameter names, resource logical IDs, resource attributes, or a variable in a key-value map.

        Substitutions must follow the syntax: `${key_name}` or `${variable_1,variable_2,...}` .
        """
        return pulumi.get(self, "definition_substitutions")

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> pulumi.Output[Optional['outputs.StateMachineEncryptionConfiguration']]:
        """
        Encryption configuration for the state machine.
        """
        return pulumi.get(self, "encryption_configuration")

    @property
    @pulumi.getter(name="loggingConfiguration")
    def logging_configuration(self) -> pulumi.Output[Optional['outputs.StateMachineLoggingConfiguration']]:
        """
        Defines what execution history events are logged and where they are logged.

        > By default, the `level` is set to `OFF` . For more information see [Log Levels](https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html) in the AWS Step Functions User Guide.
        """
        return pulumi.get(self, "logging_configuration")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Returns the name of the state machine. For example:

        `{ "Fn::GetAtt": ["MyStateMachine", "Name"] }`

        Returns the name of your state machine:

        `HelloWorld-StateMachine`

        If you did not specify the name it will be similar to the following:

        `MyStateMachine-1234abcdefgh`

        For more information about using `Fn::GetAtt` , see [Fn::GetAtt](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-getatt.html) .
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the IAM role to use for this state machine.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="stateMachineName")
    def state_machine_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the state machine.

        A name must *not* contain:

        - white space
        - brackets `< > { } [ ]`
        - wildcard characters `? *`
        - special characters `" # % \\ ^ | ~ ` $ & , ; : /`
        - control characters ( `U+0000-001F` , `U+007F-009F` )

        > If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
        """
        return pulumi.get(self, "state_machine_name")

    @property
    @pulumi.getter(name="stateMachineRevisionId")
    def state_machine_revision_id(self) -> pulumi.Output[str]:
        """
        Identifier for a state machine revision, which is an immutable, read-only snapshot of a state machine’s definition and configuration.
        """
        return pulumi.get(self, "state_machine_revision_id")

    @property
    @pulumi.getter(name="stateMachineType")
    def state_machine_type(self) -> pulumi.Output[Optional['StateMachineType']]:
        """
        Determines whether a `STANDARD` or `EXPRESS` state machine is created. The default is `STANDARD` . You cannot update the `type` of a state machine once it has been created. For more information on `STANDARD` and `EXPRESS` workflows, see [Standard Versus Express Workflows](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-standard-vs-express.html) in the AWS Step Functions Developer Guide.
        """
        return pulumi.get(self, "state_machine_type")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The list of tags to add to a resource.

        Tags may only contain Unicode letters, digits, white space, or these symbols: `_ . : / = + - @` .
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tracingConfiguration")
    def tracing_configuration(self) -> pulumi.Output[Optional['outputs.StateMachineTracingConfiguration']]:
        """
        Selects whether or not the state machine's AWS X-Ray tracing is enabled.
        """
        return pulumi.get(self, "tracing_configuration")

