# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ActivityEncryptionConfiguration',
    'StateMachineAliasDeploymentPreference',
    'StateMachineAliasRoutingConfigurationVersion',
    'StateMachineCloudWatchLogsLogGroup',
    'StateMachineDefinition',
    'StateMachineEncryptionConfiguration',
    'StateMachineLogDestination',
    'StateMachineLoggingConfiguration',
    'StateMachineS3Location',
    'StateMachineTracingConfiguration',
]

@pulumi.output_type
class ActivityEncryptionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsDataKeyReusePeriodSeconds":
            suggest = "kms_data_key_reuse_period_seconds"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ActivityEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ActivityEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ActivityEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: 'ActivityEncryptionConfigurationType',
                 kms_data_key_reuse_period_seconds: Optional[int] = None,
                 kms_key_id: Optional[str] = None):
        """
        :param 'ActivityEncryptionConfigurationType' type: Encryption option for an activity.
        :param int kms_data_key_reuse_period_seconds: Maximum duration that Step Functions will reuse data keys. When the period expires, Step Functions will call `GenerateDataKey` . Only applies to customer managed keys.
        :param str kms_key_id: An alias, alias ARN, key ID, or key ARN of a symmetric encryption AWS KMS key to encrypt data. To specify a AWS KMS key in a different AWS account, you must use the key ARN or alias ARN.
        """
        pulumi.set(__self__, "type", type)
        if kms_data_key_reuse_period_seconds is not None:
            pulumi.set(__self__, "kms_data_key_reuse_period_seconds", kms_data_key_reuse_period_seconds)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter
    def type(self) -> 'ActivityEncryptionConfigurationType':
        """
        Encryption option for an activity.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="kmsDataKeyReusePeriodSeconds")
    def kms_data_key_reuse_period_seconds(self) -> Optional[int]:
        """
        Maximum duration that Step Functions will reuse data keys. When the period expires, Step Functions will call `GenerateDataKey` . Only applies to customer managed keys.
        """
        return pulumi.get(self, "kms_data_key_reuse_period_seconds")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        An alias, alias ARN, key ID, or key ARN of a symmetric encryption AWS KMS key to encrypt data. To specify a AWS KMS key in a different AWS account, you must use the key ARN or alias ARN.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class StateMachineAliasDeploymentPreference(dict):
    """
    The settings to enable gradual state machine deployments.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stateMachineVersionArn":
            suggest = "state_machine_version_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StateMachineAliasDeploymentPreference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StateMachineAliasDeploymentPreference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StateMachineAliasDeploymentPreference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 state_machine_version_arn: str,
                 type: 'StateMachineAliasDeploymentPreferenceType',
                 alarms: Optional[Sequence[str]] = None,
                 interval: Optional[int] = None,
                 percentage: Optional[int] = None):
        """
        The settings to enable gradual state machine deployments.
        :param str state_machine_version_arn: The Amazon Resource Name (ARN) of the [`AWS::StepFunctions::StateMachineVersion`](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachineversion.html) resource that will be the final version to which the alias points to when the traffic shifting is complete.
               
               While performing gradual deployments, you can only provide a single state machine version ARN. To explicitly set version weights in a CloudFormation template, use `RoutingConfiguration` instead.
        :param 'StateMachineAliasDeploymentPreferenceType' type: The type of deployment to perform.
        :param Sequence[str] alarms: A list of CloudWatch alarm names that will be monitored during the deployment. The deployment will fail and rollback if any alarms go into ALARM state.
        :param int interval: The time in minutes between each traffic shifting increment.
        :param int percentage: The percentage of traffic to shift to the new version in each increment.
        """
        pulumi.set(__self__, "state_machine_version_arn", state_machine_version_arn)
        pulumi.set(__self__, "type", type)
        if alarms is not None:
            pulumi.set(__self__, "alarms", alarms)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if percentage is not None:
            pulumi.set(__self__, "percentage", percentage)

    @property
    @pulumi.getter(name="stateMachineVersionArn")
    def state_machine_version_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the [`AWS::StepFunctions::StateMachineVersion`](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachineversion.html) resource that will be the final version to which the alias points to when the traffic shifting is complete.

        While performing gradual deployments, you can only provide a single state machine version ARN. To explicitly set version weights in a CloudFormation template, use `RoutingConfiguration` instead.
        """
        return pulumi.get(self, "state_machine_version_arn")

    @property
    @pulumi.getter
    def type(self) -> 'StateMachineAliasDeploymentPreferenceType':
        """
        The type of deployment to perform.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def alarms(self) -> Optional[Sequence[str]]:
        """
        A list of CloudWatch alarm names that will be monitored during the deployment. The deployment will fail and rollback if any alarms go into ALARM state.
        """
        return pulumi.get(self, "alarms")

    @property
    @pulumi.getter
    def interval(self) -> Optional[int]:
        """
        The time in minutes between each traffic shifting increment.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def percentage(self) -> Optional[int]:
        """
        The percentage of traffic to shift to the new version in each increment.
        """
        return pulumi.get(self, "percentage")


@pulumi.output_type
class StateMachineAliasRoutingConfigurationVersion(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stateMachineVersionArn":
            suggest = "state_machine_version_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StateMachineAliasRoutingConfigurationVersion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StateMachineAliasRoutingConfigurationVersion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StateMachineAliasRoutingConfigurationVersion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 state_machine_version_arn: str,
                 weight: int):
        """
        :param str state_machine_version_arn: The Amazon Resource Name (ARN) that identifies one or two state machine versions defined in the routing configuration.
        :param int weight: The percentage of traffic you want to route to the state machine version. The sum of the weights in the routing configuration must be equal to 100.
        """
        pulumi.set(__self__, "state_machine_version_arn", state_machine_version_arn)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="stateMachineVersionArn")
    def state_machine_version_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) that identifies one or two state machine versions defined in the routing configuration.
        """
        return pulumi.get(self, "state_machine_version_arn")

    @property
    @pulumi.getter
    def weight(self) -> int:
        """
        The percentage of traffic you want to route to the state machine version. The sum of the weights in the routing configuration must be equal to 100.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class StateMachineCloudWatchLogsLogGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupArn":
            suggest = "log_group_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StateMachineCloudWatchLogsLogGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StateMachineCloudWatchLogsLogGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StateMachineCloudWatchLogsLogGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_group_arn: Optional[str] = None):
        """
        :param str log_group_arn: The ARN of the the CloudWatch log group to which you want your logs emitted to. The ARN must end with `:*`
        """
        if log_group_arn is not None:
            pulumi.set(__self__, "log_group_arn", log_group_arn)

    @property
    @pulumi.getter(name="logGroupArn")
    def log_group_arn(self) -> Optional[str]:
        """
        The ARN of the the CloudWatch log group to which you want your logs emitted to. The ARN must end with `:*`
        """
        return pulumi.get(self, "log_group_arn")


@pulumi.output_type
class StateMachineDefinition(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class StateMachineEncryptionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsDataKeyReusePeriodSeconds":
            suggest = "kms_data_key_reuse_period_seconds"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StateMachineEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StateMachineEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StateMachineEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: 'StateMachineEncryptionConfigurationType',
                 kms_data_key_reuse_period_seconds: Optional[int] = None,
                 kms_key_id: Optional[str] = None):
        """
        :param 'StateMachineEncryptionConfigurationType' type: Encryption option for a state machine.
        :param int kms_data_key_reuse_period_seconds: Maximum duration that Step Functions will reuse data keys. When the period expires, Step Functions will call `GenerateDataKey` . Only applies to customer managed keys.
        :param str kms_key_id: An alias, alias ARN, key ID, or key ARN of a symmetric encryption AWS KMS key to encrypt data. To specify a AWS KMS key in a different AWS account, you must use the key ARN or alias ARN.
        """
        pulumi.set(__self__, "type", type)
        if kms_data_key_reuse_period_seconds is not None:
            pulumi.set(__self__, "kms_data_key_reuse_period_seconds", kms_data_key_reuse_period_seconds)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter
    def type(self) -> 'StateMachineEncryptionConfigurationType':
        """
        Encryption option for a state machine.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="kmsDataKeyReusePeriodSeconds")
    def kms_data_key_reuse_period_seconds(self) -> Optional[int]:
        """
        Maximum duration that Step Functions will reuse data keys. When the period expires, Step Functions will call `GenerateDataKey` . Only applies to customer managed keys.
        """
        return pulumi.get(self, "kms_data_key_reuse_period_seconds")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        An alias, alias ARN, key ID, or key ARN of a symmetric encryption AWS KMS key to encrypt data. To specify a AWS KMS key in a different AWS account, you must use the key ARN or alias ARN.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class StateMachineLogDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudWatchLogsLogGroup":
            suggest = "cloud_watch_logs_log_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StateMachineLogDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StateMachineLogDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StateMachineLogDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_watch_logs_log_group: Optional['outputs.StateMachineCloudWatchLogsLogGroup'] = None):
        """
        :param 'StateMachineCloudWatchLogsLogGroup' cloud_watch_logs_log_group: An object describing a CloudWatch log group. For more information, see [AWS::Logs::LogGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html) in the AWS CloudFormation User Guide.
        """
        if cloud_watch_logs_log_group is not None:
            pulumi.set(__self__, "cloud_watch_logs_log_group", cloud_watch_logs_log_group)

    @property
    @pulumi.getter(name="cloudWatchLogsLogGroup")
    def cloud_watch_logs_log_group(self) -> Optional['outputs.StateMachineCloudWatchLogsLogGroup']:
        """
        An object describing a CloudWatch log group. For more information, see [AWS::Logs::LogGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html) in the AWS CloudFormation User Guide.
        """
        return pulumi.get(self, "cloud_watch_logs_log_group")


@pulumi.output_type
class StateMachineLoggingConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeExecutionData":
            suggest = "include_execution_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StateMachineLoggingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StateMachineLoggingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StateMachineLoggingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destinations: Optional[Sequence['outputs.StateMachineLogDestination']] = None,
                 include_execution_data: Optional[bool] = None,
                 level: Optional['StateMachineLoggingConfigurationLevel'] = None):
        """
        :param Sequence['StateMachineLogDestination'] destinations: An array of objects that describes where your execution history events will be logged. Limited to size 1. Required, if your log level is not set to `OFF` .
        :param bool include_execution_data: Determines whether execution data is included in your log. When set to `false` , data is excluded.
        :param 'StateMachineLoggingConfigurationLevel' level: Defines which category of execution history events are logged.
        """
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if include_execution_data is not None:
            pulumi.set(__self__, "include_execution_data", include_execution_data)
        if level is not None:
            pulumi.set(__self__, "level", level)

    @property
    @pulumi.getter
    def destinations(self) -> Optional[Sequence['outputs.StateMachineLogDestination']]:
        """
        An array of objects that describes where your execution history events will be logged. Limited to size 1. Required, if your log level is not set to `OFF` .
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter(name="includeExecutionData")
    def include_execution_data(self) -> Optional[bool]:
        """
        Determines whether execution data is included in your log. When set to `false` , data is excluded.
        """
        return pulumi.get(self, "include_execution_data")

    @property
    @pulumi.getter
    def level(self) -> Optional['StateMachineLoggingConfigurationLevel']:
        """
        Defines which category of execution history events are logged.
        """
        return pulumi.get(self, "level")


@pulumi.output_type
class StateMachineS3Location(dict):
    def __init__(__self__, *,
                 bucket: str,
                 key: str,
                 version: Optional[str] = None):
        """
        :param str bucket: The name of the S3 bucket where the state machine definition JSON or YAML file is stored.
        :param str key: The name of the state machine definition file (Amazon S3 object name).
        :param str version: For versioning-enabled buckets, a specific version of the state machine definition.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The name of the S3 bucket where the state machine definition JSON or YAML file is stored.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The name of the state machine definition file (Amazon S3 object name).
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        For versioning-enabled buckets, a specific version of the state machine definition.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class StateMachineTracingConfiguration(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        """
        :param bool enabled: When set to `true` , X-Ray tracing is enabled.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        When set to `true` , X-Ray tracing is enabled.
        """
        return pulumi.get(self, "enabled")


