# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetApplicationResult',
    'AwaitableGetApplicationResult',
    'get_application',
    'get_application_output',
]

@pulumi.output_type
class GetApplicationResult:
    def __init__(__self__, application_arn=None, description=None, name=None, portal_options=None, status=None, tags=None):
        if application_arn and not isinstance(application_arn, str):
            raise TypeError("Expected argument 'application_arn' to be a str")
        pulumi.set(__self__, "application_arn", application_arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if portal_options and not isinstance(portal_options, dict):
            raise TypeError("Expected argument 'portal_options' to be a dict")
        pulumi.set(__self__, "portal_options", portal_options)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="applicationArn")
    def application_arn(self) -> Optional[str]:
        """
        The Application ARN that is returned upon creation of the Identity Center (SSO) Application
        """
        return pulumi.get(self, "application_arn")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description information for the Identity Center (SSO) Application
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name you want to assign to this Identity Center (SSO) Application
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="portalOptions")
    def portal_options(self) -> Optional['outputs.ApplicationPortalOptionsConfiguration']:
        """
        A structure that describes the options for the portal associated with an application
        """
        return pulumi.get(self, "portal_options")

    @property
    @pulumi.getter
    def status(self) -> Optional['ApplicationStatus']:
        """
        Specifies whether the application is enabled or disabled
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Specifies tags to be attached to the application
        """
        return pulumi.get(self, "tags")


class AwaitableGetApplicationResult(GetApplicationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApplicationResult(
            application_arn=self.application_arn,
            description=self.description,
            name=self.name,
            portal_options=self.portal_options,
            status=self.status,
            tags=self.tags)


def get_application(application_arn: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApplicationResult:
    """
    Resource Type definition for Identity Center (SSO) Application


    :param str application_arn: The Application ARN that is returned upon creation of the Identity Center (SSO) Application
    """
    __args__ = dict()
    __args__['applicationArn'] = application_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:sso:getApplication', __args__, opts=opts, typ=GetApplicationResult).value

    return AwaitableGetApplicationResult(
        application_arn=pulumi.get(__ret__, 'application_arn'),
        description=pulumi.get(__ret__, 'description'),
        name=pulumi.get(__ret__, 'name'),
        portal_options=pulumi.get(__ret__, 'portal_options'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'))
def get_application_output(application_arn: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetApplicationResult]:
    """
    Resource Type definition for Identity Center (SSO) Application


    :param str application_arn: The Application ARN that is returned upon creation of the Identity Center (SSO) Application
    """
    __args__ = dict()
    __args__['applicationArn'] = application_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:sso:getApplication', __args__, opts=opts, typ=GetApplicationResult)
    return __ret__.apply(lambda __response__: GetApplicationResult(
        application_arn=pulumi.get(__response__, 'application_arn'),
        description=pulumi.get(__response__, 'description'),
        name=pulumi.get(__response__, 'name'),
        portal_options=pulumi.get(__response__, 'portal_options'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags')))
