# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['ApplicationArgs', 'Application']

@pulumi.input_type
class ApplicationArgs:
    def __init__(__self__, *,
                 application_provider_arn: pulumi.Input[str],
                 instance_arn: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 portal_options: Optional[pulumi.Input['ApplicationPortalOptionsConfigurationArgs']] = None,
                 status: Optional[pulumi.Input['ApplicationStatus']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Application resource.
        :param pulumi.Input[str] application_provider_arn: The ARN of the application provider under which the operation will run
        :param pulumi.Input[str] instance_arn: The ARN of the instance of IAM Identity Center under which the operation will run
        :param pulumi.Input[str] description: The description information for the Identity Center (SSO) Application
        :param pulumi.Input[str] name: The name you want to assign to this Identity Center (SSO) Application
        :param pulumi.Input['ApplicationPortalOptionsConfigurationArgs'] portal_options: A structure that describes the options for the portal associated with an application
        :param pulumi.Input['ApplicationStatus'] status: Specifies whether the application is enabled or disabled
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: Specifies tags to be attached to the application
        """
        pulumi.set(__self__, "application_provider_arn", application_provider_arn)
        pulumi.set(__self__, "instance_arn", instance_arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if portal_options is not None:
            pulumi.set(__self__, "portal_options", portal_options)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="applicationProviderArn")
    def application_provider_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the application provider under which the operation will run
        """
        return pulumi.get(self, "application_provider_arn")

    @application_provider_arn.setter
    def application_provider_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "application_provider_arn", value)

    @property
    @pulumi.getter(name="instanceArn")
    def instance_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the instance of IAM Identity Center under which the operation will run
        """
        return pulumi.get(self, "instance_arn")

    @instance_arn.setter
    def instance_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_arn", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description information for the Identity Center (SSO) Application
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name you want to assign to this Identity Center (SSO) Application
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="portalOptions")
    def portal_options(self) -> Optional[pulumi.Input['ApplicationPortalOptionsConfigurationArgs']]:
        """
        A structure that describes the options for the portal associated with an application
        """
        return pulumi.get(self, "portal_options")

    @portal_options.setter
    def portal_options(self, value: Optional[pulumi.Input['ApplicationPortalOptionsConfigurationArgs']]):
        pulumi.set(self, "portal_options", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['ApplicationStatus']]:
        """
        Specifies whether the application is enabled or disabled
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['ApplicationStatus']]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        Specifies tags to be attached to the application
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class Application(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_provider_arn: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_arn: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 portal_options: Optional[pulumi.Input[Union['ApplicationPortalOptionsConfigurationArgs', 'ApplicationPortalOptionsConfigurationArgsDict']]] = None,
                 status: Optional[pulumi.Input['ApplicationStatus']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for Identity Center (SSO) Application

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_provider_arn: The ARN of the application provider under which the operation will run
        :param pulumi.Input[str] description: The description information for the Identity Center (SSO) Application
        :param pulumi.Input[str] instance_arn: The ARN of the instance of IAM Identity Center under which the operation will run
        :param pulumi.Input[str] name: The name you want to assign to this Identity Center (SSO) Application
        :param pulumi.Input[Union['ApplicationPortalOptionsConfigurationArgs', 'ApplicationPortalOptionsConfigurationArgsDict']] portal_options: A structure that describes the options for the portal associated with an application
        :param pulumi.Input['ApplicationStatus'] status: Specifies whether the application is enabled or disabled
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: Specifies tags to be attached to the application
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for Identity Center (SSO) Application

        :param str resource_name: The name of the resource.
        :param ApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_provider_arn: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_arn: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 portal_options: Optional[pulumi.Input[Union['ApplicationPortalOptionsConfigurationArgs', 'ApplicationPortalOptionsConfigurationArgsDict']]] = None,
                 status: Optional[pulumi.Input['ApplicationStatus']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationArgs.__new__(ApplicationArgs)

            if application_provider_arn is None and not opts.urn:
                raise TypeError("Missing required property 'application_provider_arn'")
            __props__.__dict__["application_provider_arn"] = application_provider_arn
            __props__.__dict__["description"] = description
            if instance_arn is None and not opts.urn:
                raise TypeError("Missing required property 'instance_arn'")
            __props__.__dict__["instance_arn"] = instance_arn
            __props__.__dict__["name"] = name
            __props__.__dict__["portal_options"] = portal_options
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
            __props__.__dict__["application_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["applicationProviderArn", "instanceArn"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Application, __self__).__init__(
            'aws-native:sso:Application',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Application':
        """
        Get an existing Application resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ApplicationArgs.__new__(ApplicationArgs)

        __props__.__dict__["application_arn"] = None
        __props__.__dict__["application_provider_arn"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["instance_arn"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["portal_options"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        return Application(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationArn")
    def application_arn(self) -> pulumi.Output[str]:
        """
        The Application ARN that is returned upon creation of the Identity Center (SSO) Application
        """
        return pulumi.get(self, "application_arn")

    @property
    @pulumi.getter(name="applicationProviderArn")
    def application_provider_arn(self) -> pulumi.Output[str]:
        """
        The ARN of the application provider under which the operation will run
        """
        return pulumi.get(self, "application_provider_arn")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description information for the Identity Center (SSO) Application
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="instanceArn")
    def instance_arn(self) -> pulumi.Output[str]:
        """
        The ARN of the instance of IAM Identity Center under which the operation will run
        """
        return pulumi.get(self, "instance_arn")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name you want to assign to this Identity Center (SSO) Application
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="portalOptions")
    def portal_options(self) -> pulumi.Output[Optional['outputs.ApplicationPortalOptionsConfiguration']]:
        """
        A structure that describes the options for the portal associated with an application
        """
        return pulumi.get(self, "portal_options")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional['ApplicationStatus']]:
        """
        Specifies whether the application is enabled or disabled
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        Specifies tags to be attached to the application
        """
        return pulumi.get(self, "tags")

