# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'ApplicationPortalOptionsConfigurationArgs',
    'ApplicationPortalOptionsConfigurationArgsDict',
    'ApplicationSignInOptionsArgs',
    'ApplicationSignInOptionsArgsDict',
    'InstanceAccessControlAttributeConfigurationAccessControlAttributeValueArgs',
    'InstanceAccessControlAttributeConfigurationAccessControlAttributeValueArgsDict',
    'InstanceAccessControlAttributeConfigurationAccessControlAttributeArgs',
    'InstanceAccessControlAttributeConfigurationAccessControlAttributeArgsDict',
    'InstanceAccessControlAttributeConfigurationPropertiesArgs',
    'InstanceAccessControlAttributeConfigurationPropertiesArgsDict',
    'PermissionSetCustomerManagedPolicyReferenceArgs',
    'PermissionSetCustomerManagedPolicyReferenceArgsDict',
    'PermissionSetPermissionsBoundaryArgs',
    'PermissionSetPermissionsBoundaryArgsDict',
]

MYPY = False

if not MYPY:
    class ApplicationPortalOptionsConfigurationArgsDict(TypedDict):
        """
        A structure that describes the options for the access portal associated with an application
        """
        sign_in_options: NotRequired[pulumi.Input['ApplicationSignInOptionsArgsDict']]
        """
        A structure that describes the sign-in options for the access portal
        """
        visibility: NotRequired[pulumi.Input['ApplicationPortalOptionsConfigurationVisibility']]
        """
        Indicates whether this application is visible in the access portal
        """
elif False:
    ApplicationPortalOptionsConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationPortalOptionsConfigurationArgs:
    def __init__(__self__, *,
                 sign_in_options: Optional[pulumi.Input['ApplicationSignInOptionsArgs']] = None,
                 visibility: Optional[pulumi.Input['ApplicationPortalOptionsConfigurationVisibility']] = None):
        """
        A structure that describes the options for the access portal associated with an application
        :param pulumi.Input['ApplicationSignInOptionsArgs'] sign_in_options: A structure that describes the sign-in options for the access portal
        :param pulumi.Input['ApplicationPortalOptionsConfigurationVisibility'] visibility: Indicates whether this application is visible in the access portal
        """
        if sign_in_options is not None:
            pulumi.set(__self__, "sign_in_options", sign_in_options)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)

    @property
    @pulumi.getter(name="signInOptions")
    def sign_in_options(self) -> Optional[pulumi.Input['ApplicationSignInOptionsArgs']]:
        """
        A structure that describes the sign-in options for the access portal
        """
        return pulumi.get(self, "sign_in_options")

    @sign_in_options.setter
    def sign_in_options(self, value: Optional[pulumi.Input['ApplicationSignInOptionsArgs']]):
        pulumi.set(self, "sign_in_options", value)

    @property
    @pulumi.getter
    def visibility(self) -> Optional[pulumi.Input['ApplicationPortalOptionsConfigurationVisibility']]:
        """
        Indicates whether this application is visible in the access portal
        """
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: Optional[pulumi.Input['ApplicationPortalOptionsConfigurationVisibility']]):
        pulumi.set(self, "visibility", value)


if not MYPY:
    class ApplicationSignInOptionsArgsDict(TypedDict):
        """
        A structure that describes the sign-in options for an application portal
        """
        origin: pulumi.Input['ApplicationSignInOptionsOrigin']
        """
        This determines how IAM Identity Center navigates the user to the target application
        """
        application_url: NotRequired[pulumi.Input[str]]
        """
        The URL that accepts authentication requests for an application, this is a required parameter if the Origin parameter is APPLICATION
        """
elif False:
    ApplicationSignInOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationSignInOptionsArgs:
    def __init__(__self__, *,
                 origin: pulumi.Input['ApplicationSignInOptionsOrigin'],
                 application_url: Optional[pulumi.Input[str]] = None):
        """
        A structure that describes the sign-in options for an application portal
        :param pulumi.Input['ApplicationSignInOptionsOrigin'] origin: This determines how IAM Identity Center navigates the user to the target application
        :param pulumi.Input[str] application_url: The URL that accepts authentication requests for an application, this is a required parameter if the Origin parameter is APPLICATION
        """
        pulumi.set(__self__, "origin", origin)
        if application_url is not None:
            pulumi.set(__self__, "application_url", application_url)

    @property
    @pulumi.getter
    def origin(self) -> pulumi.Input['ApplicationSignInOptionsOrigin']:
        """
        This determines how IAM Identity Center navigates the user to the target application
        """
        return pulumi.get(self, "origin")

    @origin.setter
    def origin(self, value: pulumi.Input['ApplicationSignInOptionsOrigin']):
        pulumi.set(self, "origin", value)

    @property
    @pulumi.getter(name="applicationUrl")
    def application_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL that accepts authentication requests for an application, this is a required parameter if the Origin parameter is APPLICATION
        """
        return pulumi.get(self, "application_url")

    @application_url.setter
    def application_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_url", value)


if not MYPY:
    class InstanceAccessControlAttributeConfigurationAccessControlAttributeValueArgsDict(TypedDict):
        source: pulumi.Input[Sequence[pulumi.Input[str]]]
elif False:
    InstanceAccessControlAttributeConfigurationAccessControlAttributeValueArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceAccessControlAttributeConfigurationAccessControlAttributeValueArgs:
    def __init__(__self__, *,
                 source: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "source", value)


if not MYPY:
    class InstanceAccessControlAttributeConfigurationAccessControlAttributeArgsDict(TypedDict):
        key: pulumi.Input[str]
        value: pulumi.Input['InstanceAccessControlAttributeConfigurationAccessControlAttributeValueArgsDict']
elif False:
    InstanceAccessControlAttributeConfigurationAccessControlAttributeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceAccessControlAttributeConfigurationAccessControlAttributeArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input['InstanceAccessControlAttributeConfigurationAccessControlAttributeValueArgs']):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input['InstanceAccessControlAttributeConfigurationAccessControlAttributeValueArgs']:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input['InstanceAccessControlAttributeConfigurationAccessControlAttributeValueArgs']):
        pulumi.set(self, "value", value)


if not MYPY:
    class InstanceAccessControlAttributeConfigurationPropertiesArgsDict(TypedDict):
        """
        The InstanceAccessControlAttributeConfiguration property has been deprecated but is still supported for backwards compatibility purposes. We recomend that you use  AccessControlAttributes property instead.
        """
        access_control_attributes: pulumi.Input[Sequence[pulumi.Input['InstanceAccessControlAttributeConfigurationAccessControlAttributeArgsDict']]]
elif False:
    InstanceAccessControlAttributeConfigurationPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceAccessControlAttributeConfigurationPropertiesArgs:
    def __init__(__self__, *,
                 access_control_attributes: pulumi.Input[Sequence[pulumi.Input['InstanceAccessControlAttributeConfigurationAccessControlAttributeArgs']]]):
        """
        The InstanceAccessControlAttributeConfiguration property has been deprecated but is still supported for backwards compatibility purposes. We recomend that you use  AccessControlAttributes property instead.
        """
        pulumi.set(__self__, "access_control_attributes", access_control_attributes)

    @property
    @pulumi.getter(name="accessControlAttributes")
    def access_control_attributes(self) -> pulumi.Input[Sequence[pulumi.Input['InstanceAccessControlAttributeConfigurationAccessControlAttributeArgs']]]:
        return pulumi.get(self, "access_control_attributes")

    @access_control_attributes.setter
    def access_control_attributes(self, value: pulumi.Input[Sequence[pulumi.Input['InstanceAccessControlAttributeConfigurationAccessControlAttributeArgs']]]):
        pulumi.set(self, "access_control_attributes", value)


if not MYPY:
    class PermissionSetCustomerManagedPolicyReferenceArgsDict(TypedDict):
        name: pulumi.Input[str]
        """
        The name of the IAM policy that you have configured in each account where you want to deploy your permission set.
        """
        path: NotRequired[pulumi.Input[str]]
        """
        The path to the IAM policy that you have configured in each account where you want to deploy your permission set. The default is `/` . For more information, see [Friendly names and paths](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names) in the *IAM User Guide* .
        """
elif False:
    PermissionSetCustomerManagedPolicyReferenceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PermissionSetCustomerManagedPolicyReferenceArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The name of the IAM policy that you have configured in each account where you want to deploy your permission set.
        :param pulumi.Input[str] path: The path to the IAM policy that you have configured in each account where you want to deploy your permission set. The default is `/` . For more information, see [Friendly names and paths](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names) in the *IAM User Guide* .
        """
        pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the IAM policy that you have configured in each account where you want to deploy your permission set.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to the IAM policy that you have configured in each account where you want to deploy your permission set. The default is `/` . For more information, see [Friendly names and paths](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names) in the *IAM User Guide* .
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


if not MYPY:
    class PermissionSetPermissionsBoundaryArgsDict(TypedDict):
        customer_managed_policy_reference: NotRequired[pulumi.Input['PermissionSetCustomerManagedPolicyReferenceArgsDict']]
        """
        Specifies the name and path of a customer managed policy. You must have an IAM policy that matches the name and path in each AWS account where you want to deploy your permission set.
        """
        managed_policy_arn: NotRequired[pulumi.Input[str]]
        """
        The AWS managed policy ARN that you want to attach to a permission set as a permissions boundary.
        """
elif False:
    PermissionSetPermissionsBoundaryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PermissionSetPermissionsBoundaryArgs:
    def __init__(__self__, *,
                 customer_managed_policy_reference: Optional[pulumi.Input['PermissionSetCustomerManagedPolicyReferenceArgs']] = None,
                 managed_policy_arn: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['PermissionSetCustomerManagedPolicyReferenceArgs'] customer_managed_policy_reference: Specifies the name and path of a customer managed policy. You must have an IAM policy that matches the name and path in each AWS account where you want to deploy your permission set.
        :param pulumi.Input[str] managed_policy_arn: The AWS managed policy ARN that you want to attach to a permission set as a permissions boundary.
        """
        if customer_managed_policy_reference is not None:
            pulumi.set(__self__, "customer_managed_policy_reference", customer_managed_policy_reference)
        if managed_policy_arn is not None:
            pulumi.set(__self__, "managed_policy_arn", managed_policy_arn)

    @property
    @pulumi.getter(name="customerManagedPolicyReference")
    def customer_managed_policy_reference(self) -> Optional[pulumi.Input['PermissionSetCustomerManagedPolicyReferenceArgs']]:
        """
        Specifies the name and path of a customer managed policy. You must have an IAM policy that matches the name and path in each AWS account where you want to deploy your permission set.
        """
        return pulumi.get(self, "customer_managed_policy_reference")

    @customer_managed_policy_reference.setter
    def customer_managed_policy_reference(self, value: Optional[pulumi.Input['PermissionSetCustomerManagedPolicyReferenceArgs']]):
        pulumi.set(self, "customer_managed_policy_reference", value)

    @property
    @pulumi.getter(name="managedPolicyArn")
    def managed_policy_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS managed policy ARN that you want to attach to a permission set as a permissions boundary.
        """
        return pulumi.get(self, "managed_policy_arn")

    @managed_policy_arn.setter
    def managed_policy_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "managed_policy_arn", value)


