# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetAssociationResult',
    'AwaitableGetAssociationResult',
    'get_association',
    'get_association_output',
]

@pulumi.output_type
class GetAssociationResult:
    def __init__(__self__, apply_only_at_cron_interval=None, association_id=None, association_name=None, automation_target_parameter_name=None, calendar_names=None, compliance_severity=None, document_version=None, instance_id=None, max_concurrency=None, max_errors=None, name=None, output_location=None, parameters=None, schedule_expression=None, schedule_offset=None, sync_compliance=None, targets=None):
        if apply_only_at_cron_interval and not isinstance(apply_only_at_cron_interval, bool):
            raise TypeError("Expected argument 'apply_only_at_cron_interval' to be a bool")
        pulumi.set(__self__, "apply_only_at_cron_interval", apply_only_at_cron_interval)
        if association_id and not isinstance(association_id, str):
            raise TypeError("Expected argument 'association_id' to be a str")
        pulumi.set(__self__, "association_id", association_id)
        if association_name and not isinstance(association_name, str):
            raise TypeError("Expected argument 'association_name' to be a str")
        pulumi.set(__self__, "association_name", association_name)
        if automation_target_parameter_name and not isinstance(automation_target_parameter_name, str):
            raise TypeError("Expected argument 'automation_target_parameter_name' to be a str")
        pulumi.set(__self__, "automation_target_parameter_name", automation_target_parameter_name)
        if calendar_names and not isinstance(calendar_names, list):
            raise TypeError("Expected argument 'calendar_names' to be a list")
        pulumi.set(__self__, "calendar_names", calendar_names)
        if compliance_severity and not isinstance(compliance_severity, str):
            raise TypeError("Expected argument 'compliance_severity' to be a str")
        pulumi.set(__self__, "compliance_severity", compliance_severity)
        if document_version and not isinstance(document_version, str):
            raise TypeError("Expected argument 'document_version' to be a str")
        pulumi.set(__self__, "document_version", document_version)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if max_concurrency and not isinstance(max_concurrency, str):
            raise TypeError("Expected argument 'max_concurrency' to be a str")
        pulumi.set(__self__, "max_concurrency", max_concurrency)
        if max_errors and not isinstance(max_errors, str):
            raise TypeError("Expected argument 'max_errors' to be a str")
        pulumi.set(__self__, "max_errors", max_errors)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if output_location and not isinstance(output_location, dict):
            raise TypeError("Expected argument 'output_location' to be a dict")
        pulumi.set(__self__, "output_location", output_location)
        if parameters and not isinstance(parameters, dict):
            raise TypeError("Expected argument 'parameters' to be a dict")
        pulumi.set(__self__, "parameters", parameters)
        if schedule_expression and not isinstance(schedule_expression, str):
            raise TypeError("Expected argument 'schedule_expression' to be a str")
        pulumi.set(__self__, "schedule_expression", schedule_expression)
        if schedule_offset and not isinstance(schedule_offset, int):
            raise TypeError("Expected argument 'schedule_offset' to be a int")
        pulumi.set(__self__, "schedule_offset", schedule_offset)
        if sync_compliance and not isinstance(sync_compliance, str):
            raise TypeError("Expected argument 'sync_compliance' to be a str")
        pulumi.set(__self__, "sync_compliance", sync_compliance)
        if targets and not isinstance(targets, list):
            raise TypeError("Expected argument 'targets' to be a list")
        pulumi.set(__self__, "targets", targets)

    @property
    @pulumi.getter(name="applyOnlyAtCronInterval")
    def apply_only_at_cron_interval(self) -> Optional[bool]:
        """
        By default, when you create a new association, the system runs it immediately after it is created and then according to the schedule you specified. Specify this option if you don't want an association to run immediately after you create it. This parameter is not supported for rate expressions.
        """
        return pulumi.get(self, "apply_only_at_cron_interval")

    @property
    @pulumi.getter(name="associationId")
    def association_id(self) -> Optional[str]:
        """
        Unique identifier of the association.
        """
        return pulumi.get(self, "association_id")

    @property
    @pulumi.getter(name="associationName")
    def association_name(self) -> Optional[str]:
        """
        The name of the association.
        """
        return pulumi.get(self, "association_name")

    @property
    @pulumi.getter(name="automationTargetParameterName")
    def automation_target_parameter_name(self) -> Optional[str]:
        """
        Choose the parameter that will define how your automation will branch out. This target is required for associations that use an Automation runbook and target resources by using rate controls. Automation is a capability of AWS Systems Manager .
        """
        return pulumi.get(self, "automation_target_parameter_name")

    @property
    @pulumi.getter(name="calendarNames")
    def calendar_names(self) -> Optional[Sequence[str]]:
        """
        The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your associations are gated under. The associations only run when that Change Calendar is open. For more information, see [AWS Systems Manager Change Calendar](https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar) .
        """
        return pulumi.get(self, "calendar_names")

    @property
    @pulumi.getter(name="complianceSeverity")
    def compliance_severity(self) -> Optional['AssociationComplianceSeverity']:
        """
        The severity level that is assigned to the association.
        """
        return pulumi.get(self, "compliance_severity")

    @property
    @pulumi.getter(name="documentVersion")
    def document_version(self) -> Optional[str]:
        """
        The version of the SSM document to associate with the target.
        """
        return pulumi.get(self, "document_version")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[str]:
        """
        The ID of the instance that the SSM document is associated with.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> Optional[str]:
        """
        The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all targets run the association at the same time.

        If a new managed node starts and attempts to run an association while Systems Manager is running `MaxConcurrency` associations, the association is allowed to run. During the next association interval, the new managed node will process its association within the limit specified for `MaxConcurrency` .
        """
        return pulumi.get(self, "max_concurrency")

    @property
    @pulumi.getter(name="maxErrors")
    def max_errors(self) -> Optional[str]:
        """
        The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of the target set, for example 10%. If you specify 3, for example, the system stops sending requests when the fourth error is received. If you specify 0, then the system stops sending requests after the first error is returned. If you run an association on 50 managed nodes and set `MaxError` to 10%, then the system stops sending the request when the sixth error is received.

        Executions that are already running an association when `MaxErrors` is reached are allowed to complete, but some of these executions may fail as well. If you need to ensure that there won't be more than max-errors failed executions, set `MaxConcurrency` to 1 so that executions proceed one at a time.
        """
        return pulumi.get(self, "max_errors")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the SSM document.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outputLocation")
    def output_location(self) -> Optional['outputs.AssociationInstanceAssociationOutputLocation']:
        """
        An Amazon Simple Storage Service (Amazon S3) bucket where you want to store the output details of the request.
        """
        return pulumi.get(self, "output_location")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, Sequence[str]]]:
        """
        Parameter values that the SSM document uses at runtime.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> Optional[str]:
        """
        A Cron or Rate expression that specifies when the association is applied to the target.
        """
        return pulumi.get(self, "schedule_expression")

    @property
    @pulumi.getter(name="scheduleOffset")
    def schedule_offset(self) -> Optional[int]:
        """
        Number of days to wait after the scheduled day to run an association.
        """
        return pulumi.get(self, "schedule_offset")

    @property
    @pulumi.getter(name="syncCompliance")
    def sync_compliance(self) -> Optional['AssociationSyncCompliance']:
        """
        The mode for generating association compliance. You can specify `AUTO` or `MANUAL` . In `AUTO` mode, the system uses the status of the association execution to determine the compliance status. If the association execution runs successfully, then the association is `COMPLIANT` . If the association execution doesn't run successfully, the association is `NON-COMPLIANT` .

        In `MANUAL` mode, you must specify the `AssociationId` as a parameter for the `PutComplianceItems` API action. In this case, compliance data is not managed by State Manager. It is managed by your direct call to the `PutComplianceItems` API action.

        By default, all associations use `AUTO` mode.
        """
        return pulumi.get(self, "sync_compliance")

    @property
    @pulumi.getter
    def targets(self) -> Optional[Sequence['outputs.AssociationTarget']]:
        """
        The targets that the SSM document sends commands to.
        """
        return pulumi.get(self, "targets")


class AwaitableGetAssociationResult(GetAssociationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAssociationResult(
            apply_only_at_cron_interval=self.apply_only_at_cron_interval,
            association_id=self.association_id,
            association_name=self.association_name,
            automation_target_parameter_name=self.automation_target_parameter_name,
            calendar_names=self.calendar_names,
            compliance_severity=self.compliance_severity,
            document_version=self.document_version,
            instance_id=self.instance_id,
            max_concurrency=self.max_concurrency,
            max_errors=self.max_errors,
            name=self.name,
            output_location=self.output_location,
            parameters=self.parameters,
            schedule_expression=self.schedule_expression,
            schedule_offset=self.schedule_offset,
            sync_compliance=self.sync_compliance,
            targets=self.targets)


def get_association(association_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAssociationResult:
    """
    The AWS::SSM::Association resource associates an SSM document in AWS Systems Manager with EC2 instances that contain a configuration agent to process the document.


    :param str association_id: Unique identifier of the association.
    """
    __args__ = dict()
    __args__['associationId'] = association_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ssm:getAssociation', __args__, opts=opts, typ=GetAssociationResult).value

    return AwaitableGetAssociationResult(
        apply_only_at_cron_interval=pulumi.get(__ret__, 'apply_only_at_cron_interval'),
        association_id=pulumi.get(__ret__, 'association_id'),
        association_name=pulumi.get(__ret__, 'association_name'),
        automation_target_parameter_name=pulumi.get(__ret__, 'automation_target_parameter_name'),
        calendar_names=pulumi.get(__ret__, 'calendar_names'),
        compliance_severity=pulumi.get(__ret__, 'compliance_severity'),
        document_version=pulumi.get(__ret__, 'document_version'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        max_concurrency=pulumi.get(__ret__, 'max_concurrency'),
        max_errors=pulumi.get(__ret__, 'max_errors'),
        name=pulumi.get(__ret__, 'name'),
        output_location=pulumi.get(__ret__, 'output_location'),
        parameters=pulumi.get(__ret__, 'parameters'),
        schedule_expression=pulumi.get(__ret__, 'schedule_expression'),
        schedule_offset=pulumi.get(__ret__, 'schedule_offset'),
        sync_compliance=pulumi.get(__ret__, 'sync_compliance'),
        targets=pulumi.get(__ret__, 'targets'))
def get_association_output(association_id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAssociationResult]:
    """
    The AWS::SSM::Association resource associates an SSM document in AWS Systems Manager with EC2 instances that contain a configuration agent to process the document.


    :param str association_id: Unique identifier of the association.
    """
    __args__ = dict()
    __args__['associationId'] = association_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ssm:getAssociation', __args__, opts=opts, typ=GetAssociationResult)
    return __ret__.apply(lambda __response__: GetAssociationResult(
        apply_only_at_cron_interval=pulumi.get(__response__, 'apply_only_at_cron_interval'),
        association_id=pulumi.get(__response__, 'association_id'),
        association_name=pulumi.get(__response__, 'association_name'),
        automation_target_parameter_name=pulumi.get(__response__, 'automation_target_parameter_name'),
        calendar_names=pulumi.get(__response__, 'calendar_names'),
        compliance_severity=pulumi.get(__response__, 'compliance_severity'),
        document_version=pulumi.get(__response__, 'document_version'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        max_concurrency=pulumi.get(__response__, 'max_concurrency'),
        max_errors=pulumi.get(__response__, 'max_errors'),
        name=pulumi.get(__response__, 'name'),
        output_location=pulumi.get(__response__, 'output_location'),
        parameters=pulumi.get(__response__, 'parameters'),
        schedule_expression=pulumi.get(__response__, 'schedule_expression'),
        schedule_offset=pulumi.get(__response__, 'schedule_offset'),
        sync_compliance=pulumi.get(__response__, 'sync_compliance'),
        targets=pulumi.get(__response__, 'targets')))
