# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['TopicArgs', 'Topic']

@pulumi.input_type
class TopicArgs:
    def __init__(__self__, *,
                 archive_policy: Optional[Any] = None,
                 content_based_deduplication: Optional[pulumi.Input[bool]] = None,
                 data_protection_policy: Optional[Any] = None,
                 delivery_status_logging: Optional[pulumi.Input[Sequence[pulumi.Input['TopicLoggingConfigArgs']]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 fifo_topic: Optional[pulumi.Input[bool]] = None,
                 kms_master_key_id: Optional[pulumi.Input[str]] = None,
                 signature_version: Optional[pulumi.Input[str]] = None,
                 subscription: Optional[pulumi.Input[Sequence[pulumi.Input['TopicSubscriptionArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 topic_name: Optional[pulumi.Input[str]] = None,
                 tracing_config: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Topic resource.
        :param Any archive_policy: The archive policy determines the number of days SNS retains messages. You can set a retention period from 1 to 365 days.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SNS::Topic` for more information about the expected schema for this property.
        :param pulumi.Input[bool] content_based_deduplication: Enables content-based deduplication for FIFO topics.
                 +  By default, ``ContentBasedDeduplication`` is set to ``false``. If you create a FIFO topic and this attribute is ``false``, you must specify a value for the ``MessageDeduplicationId`` parameter for the [Publish](https://docs.aws.amazon.com/sns/latest/api/API_Publish.html) action. 
                 +  When you set ``ContentBasedDeduplication`` to ``true``, SNS uses a SHA-256 hash to generate the ``MessageDeduplicationId`` using the body of the message (but not the attributes of the message).
                (Optional) To override the generated value, you can specify a value for the the ``MessageDeduplicationId`` parameter for the ``Publish`` action.
        :param Any data_protection_policy: The body of the policy document you want to use for this topic.
                You can only add one policy per topic.
                The policy must be in JSON string format.
                Length Constraints: Maximum length of 30,720.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SNS::Topic` for more information about the expected schema for this property.
        :param pulumi.Input[Sequence[pulumi.Input['TopicLoggingConfigArgs']]] delivery_status_logging: The ``DeliveryStatusLogging`` configuration enables you to log the delivery status of messages sent from your Amazon SNS topic to subscribed endpoints with the following supported delivery protocols:
                 +  HTTP 
                 +  Amazon Kinesis Data Firehose
                 +   AWS Lambda
                 +  Platform application endpoint
                 +  Amazon Simple Queue Service
                 
                Once configured, log entries are sent to Amazon CloudWatch Logs.
        :param pulumi.Input[str] display_name: The display name to use for an SNS topic with SMS subscriptions. The display name must be maximum 100 characters long, including hyphens (-), underscores (_), spaces, and tabs.
        :param pulumi.Input[bool] fifo_topic: Set to true to create a FIFO topic.
        :param pulumi.Input[str] kms_master_key_id: The ID of an AWS managed customer master key (CMK) for SNS or a custom CMK. For more information, see [Key terms](https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms). For more examples, see ``KeyId`` in the *API Reference*.
                This property applies only to [server-side-encryption](https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html).
        :param pulumi.Input[str] signature_version: The signature version corresponds to the hashing algorithm used while creating the signature of the notifications, subscription confirmations, or unsubscribe confirmation messages sent by Amazon SNS. By default, ``SignatureVersion`` is set to ``1``.
        :param pulumi.Input[Sequence[pulumi.Input['TopicSubscriptionArgs']]] subscription: The SNS subscriptions (endpoints) for this topic.
                 If you specify the ``Subscription`` property in the ``AWS::SNS::Topic`` resource and it creates an associated subscription resource, the associated subscription is not deleted when the ``AWS::SNS::Topic`` resource is deleted.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The list of tags to add to a new topic.
                 To be able to tag a topic on creation, you must have the ``sns:CreateTopic`` and ``sns:TagResource`` permissions.
        :param pulumi.Input[str] topic_name: The name of the topic you want to create. Topic names must include only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters long. FIFO topic names must end with ``.fifo``.
                If you don't specify a name, CFN generates a unique physical ID and uses that ID for the topic name. For more information, see [Name type](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html).
                 If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
        :param pulumi.Input[str] tracing_config: Tracing mode of an SNS topic. By default ``TracingConfig`` is set to ``PassThrough``, and the topic passes through the tracing header it receives from an SNS publisher to its subscriptions. If set to ``Active``, SNS will vend X-Ray segment data to topic owner account if the sampled flag in the tracing header is true.
        """
        if archive_policy is not None:
            pulumi.set(__self__, "archive_policy", archive_policy)
        if content_based_deduplication is not None:
            pulumi.set(__self__, "content_based_deduplication", content_based_deduplication)
        if data_protection_policy is not None:
            pulumi.set(__self__, "data_protection_policy", data_protection_policy)
        if delivery_status_logging is not None:
            pulumi.set(__self__, "delivery_status_logging", delivery_status_logging)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if fifo_topic is not None:
            pulumi.set(__self__, "fifo_topic", fifo_topic)
        if kms_master_key_id is not None:
            pulumi.set(__self__, "kms_master_key_id", kms_master_key_id)
        if signature_version is not None:
            pulumi.set(__self__, "signature_version", signature_version)
        if subscription is not None:
            pulumi.set(__self__, "subscription", subscription)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if topic_name is not None:
            pulumi.set(__self__, "topic_name", topic_name)
        if tracing_config is not None:
            pulumi.set(__self__, "tracing_config", tracing_config)

    @property
    @pulumi.getter(name="archivePolicy")
    def archive_policy(self) -> Optional[Any]:
        """
        The archive policy determines the number of days SNS retains messages. You can set a retention period from 1 to 365 days.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SNS::Topic` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "archive_policy")

    @archive_policy.setter
    def archive_policy(self, value: Optional[Any]):
        pulumi.set(self, "archive_policy", value)

    @property
    @pulumi.getter(name="contentBasedDeduplication")
    def content_based_deduplication(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables content-based deduplication for FIFO topics.
          +  By default, ``ContentBasedDeduplication`` is set to ``false``. If you create a FIFO topic and this attribute is ``false``, you must specify a value for the ``MessageDeduplicationId`` parameter for the [Publish](https://docs.aws.amazon.com/sns/latest/api/API_Publish.html) action. 
          +  When you set ``ContentBasedDeduplication`` to ``true``, SNS uses a SHA-256 hash to generate the ``MessageDeduplicationId`` using the body of the message (but not the attributes of the message).
         (Optional) To override the generated value, you can specify a value for the the ``MessageDeduplicationId`` parameter for the ``Publish`` action.
        """
        return pulumi.get(self, "content_based_deduplication")

    @content_based_deduplication.setter
    def content_based_deduplication(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "content_based_deduplication", value)

    @property
    @pulumi.getter(name="dataProtectionPolicy")
    def data_protection_policy(self) -> Optional[Any]:
        """
        The body of the policy document you want to use for this topic.
         You can only add one policy per topic.
         The policy must be in JSON string format.
         Length Constraints: Maximum length of 30,720.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SNS::Topic` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "data_protection_policy")

    @data_protection_policy.setter
    def data_protection_policy(self, value: Optional[Any]):
        pulumi.set(self, "data_protection_policy", value)

    @property
    @pulumi.getter(name="deliveryStatusLogging")
    def delivery_status_logging(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicLoggingConfigArgs']]]]:
        """
        The ``DeliveryStatusLogging`` configuration enables you to log the delivery status of messages sent from your Amazon SNS topic to subscribed endpoints with the following supported delivery protocols:
          +  HTTP 
          +  Amazon Kinesis Data Firehose
          +   AWS Lambda
          +  Platform application endpoint
          +  Amazon Simple Queue Service
          
         Once configured, log entries are sent to Amazon CloudWatch Logs.
        """
        return pulumi.get(self, "delivery_status_logging")

    @delivery_status_logging.setter
    def delivery_status_logging(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicLoggingConfigArgs']]]]):
        pulumi.set(self, "delivery_status_logging", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name to use for an SNS topic with SMS subscriptions. The display name must be maximum 100 characters long, including hyphens (-), underscores (_), spaces, and tabs.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="fifoTopic")
    def fifo_topic(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true to create a FIFO topic.
        """
        return pulumi.get(self, "fifo_topic")

    @fifo_topic.setter
    def fifo_topic(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fifo_topic", value)

    @property
    @pulumi.getter(name="kmsMasterKeyId")
    def kms_master_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of an AWS managed customer master key (CMK) for SNS or a custom CMK. For more information, see [Key terms](https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms). For more examples, see ``KeyId`` in the *API Reference*.
         This property applies only to [server-side-encryption](https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html).
        """
        return pulumi.get(self, "kms_master_key_id")

    @kms_master_key_id.setter
    def kms_master_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_master_key_id", value)

    @property
    @pulumi.getter(name="signatureVersion")
    def signature_version(self) -> Optional[pulumi.Input[str]]:
        """
        The signature version corresponds to the hashing algorithm used while creating the signature of the notifications, subscription confirmations, or unsubscribe confirmation messages sent by Amazon SNS. By default, ``SignatureVersion`` is set to ``1``.
        """
        return pulumi.get(self, "signature_version")

    @signature_version.setter
    def signature_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signature_version", value)

    @property
    @pulumi.getter
    def subscription(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicSubscriptionArgs']]]]:
        """
        The SNS subscriptions (endpoints) for this topic.
          If you specify the ``Subscription`` property in the ``AWS::SNS::Topic`` resource and it creates an associated subscription resource, the associated subscription is not deleted when the ``AWS::SNS::Topic`` resource is deleted.
        """
        return pulumi.get(self, "subscription")

    @subscription.setter
    def subscription(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicSubscriptionArgs']]]]):
        pulumi.set(self, "subscription", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The list of tags to add to a new topic.
          To be able to tag a topic on creation, you must have the ``sns:CreateTopic`` and ``sns:TagResource`` permissions.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the topic you want to create. Topic names must include only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters long. FIFO topic names must end with ``.fifo``.
         If you don't specify a name, CFN generates a unique physical ID and uses that ID for the topic name. For more information, see [Name type](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html).
          If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
        """
        return pulumi.get(self, "topic_name")

    @topic_name.setter
    def topic_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic_name", value)

    @property
    @pulumi.getter(name="tracingConfig")
    def tracing_config(self) -> Optional[pulumi.Input[str]]:
        """
        Tracing mode of an SNS topic. By default ``TracingConfig`` is set to ``PassThrough``, and the topic passes through the tracing header it receives from an SNS publisher to its subscriptions. If set to ``Active``, SNS will vend X-Ray segment data to topic owner account if the sampled flag in the tracing header is true.
        """
        return pulumi.get(self, "tracing_config")

    @tracing_config.setter
    def tracing_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tracing_config", value)


class Topic(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 archive_policy: Optional[Any] = None,
                 content_based_deduplication: Optional[pulumi.Input[bool]] = None,
                 data_protection_policy: Optional[Any] = None,
                 delivery_status_logging: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TopicLoggingConfigArgs', 'TopicLoggingConfigArgsDict']]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 fifo_topic: Optional[pulumi.Input[bool]] = None,
                 kms_master_key_id: Optional[pulumi.Input[str]] = None,
                 signature_version: Optional[pulumi.Input[str]] = None,
                 subscription: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TopicSubscriptionArgs', 'TopicSubscriptionArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 topic_name: Optional[pulumi.Input[str]] = None,
                 tracing_config: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The ``AWS::SNS::Topic`` resource creates a topic to which notifications can be published.
          One account can create a maximum of 100,000 standard topics and 1,000 FIFO topics. For more information, see [endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/sns.html) in the *General Reference*.
           The structure of ``AUTHPARAMS`` depends on the .signature of the API request. For more information, see [Examples of the complete Signature Version 4 signing process](https://docs.aws.amazon.com/general/latest/gr/sigv4-signed-request-examples.html) in the *General Reference*.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        car_sales_topic = aws_native.sns.Topic("carSalesTopic")
        erp_integration_queue = aws_native.sqs.Queue("erpIntegrationQueue")
        erp_subscription = aws_native.sns.Subscription("erpSubscription",
            topic_arn=car_sales_topic.id,
            endpoint=erp_integration_queue.arn,
            protocol="sqs",
            raw_message_delivery=True)
        crm_integration_queue = aws_native.sqs.Queue("crmIntegrationQueue")
        crm_subscription = aws_native.sns.Subscription("crmSubscription",
            topic_arn=car_sales_topic.id,
            endpoint=crm_integration_queue.arn,
            protocol="sqs",
            raw_message_delivery=True,
            filter_policy={
                "buyer-class": ["vip"],
            })
        config = pulumi.Config()
        my_http_endpoint = config.require("myHttpEndpoint")
        scm_subscription = aws_native.sns.Subscription("scmSubscription",
            topic_arn=car_sales_topic.id,
            endpoint=my_http_endpoint,
            protocol="https",
            delivery_policy={
                "healthyRetryPolicy": {
                    "numRetries": 20,
                    "minDelayTarget": 10,
                    "maxDelayTarget": 30,
                    "numMinDelayRetries": 3,
                    "numMaxDelayRetries": 17,
                    "numNoDelayRetries": 0,
                    "backoffFunction": "exponential",
                },
            })

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        car_sales_topic = aws_native.sns.Topic("carSalesTopic")
        erp_integration_queue = aws_native.sqs.Queue("erpIntegrationQueue")
        erp_subscription = aws_native.sns.Subscription("erpSubscription",
            topic_arn=car_sales_topic.id,
            endpoint=erp_integration_queue.arn,
            protocol="sqs",
            raw_message_delivery=True)
        crm_integration_queue = aws_native.sqs.Queue("crmIntegrationQueue")
        crm_subscription = aws_native.sns.Subscription("crmSubscription",
            topic_arn=car_sales_topic.id,
            endpoint=crm_integration_queue.arn,
            protocol="sqs",
            raw_message_delivery=True,
            filter_policy={
                "buyer-class": ["vip"],
            })
        config = pulumi.Config()
        my_http_endpoint = config.require("myHttpEndpoint")
        scm_subscription = aws_native.sns.Subscription("scmSubscription",
            topic_arn=car_sales_topic.id,
            endpoint=my_http_endpoint,
            protocol="https",
            delivery_policy={
                "healthyRetryPolicy": {
                    "numRetries": 20,
                    "minDelayTarget": 10,
                    "maxDelayTarget": 30,
                    "numMinDelayRetries": 3,
                    "numMaxDelayRetries": 17,
                    "numNoDelayRetries": 0,
                    "backoffFunction": "exponential",
                },
            })

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param Any archive_policy: The archive policy determines the number of days SNS retains messages. You can set a retention period from 1 to 365 days.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SNS::Topic` for more information about the expected schema for this property.
        :param pulumi.Input[bool] content_based_deduplication: Enables content-based deduplication for FIFO topics.
                 +  By default, ``ContentBasedDeduplication`` is set to ``false``. If you create a FIFO topic and this attribute is ``false``, you must specify a value for the ``MessageDeduplicationId`` parameter for the [Publish](https://docs.aws.amazon.com/sns/latest/api/API_Publish.html) action. 
                 +  When you set ``ContentBasedDeduplication`` to ``true``, SNS uses a SHA-256 hash to generate the ``MessageDeduplicationId`` using the body of the message (but not the attributes of the message).
                (Optional) To override the generated value, you can specify a value for the the ``MessageDeduplicationId`` parameter for the ``Publish`` action.
        :param Any data_protection_policy: The body of the policy document you want to use for this topic.
                You can only add one policy per topic.
                The policy must be in JSON string format.
                Length Constraints: Maximum length of 30,720.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SNS::Topic` for more information about the expected schema for this property.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TopicLoggingConfigArgs', 'TopicLoggingConfigArgsDict']]]] delivery_status_logging: The ``DeliveryStatusLogging`` configuration enables you to log the delivery status of messages sent from your Amazon SNS topic to subscribed endpoints with the following supported delivery protocols:
                 +  HTTP 
                 +  Amazon Kinesis Data Firehose
                 +   AWS Lambda
                 +  Platform application endpoint
                 +  Amazon Simple Queue Service
                 
                Once configured, log entries are sent to Amazon CloudWatch Logs.
        :param pulumi.Input[str] display_name: The display name to use for an SNS topic with SMS subscriptions. The display name must be maximum 100 characters long, including hyphens (-), underscores (_), spaces, and tabs.
        :param pulumi.Input[bool] fifo_topic: Set to true to create a FIFO topic.
        :param pulumi.Input[str] kms_master_key_id: The ID of an AWS managed customer master key (CMK) for SNS or a custom CMK. For more information, see [Key terms](https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms). For more examples, see ``KeyId`` in the *API Reference*.
                This property applies only to [server-side-encryption](https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html).
        :param pulumi.Input[str] signature_version: The signature version corresponds to the hashing algorithm used while creating the signature of the notifications, subscription confirmations, or unsubscribe confirmation messages sent by Amazon SNS. By default, ``SignatureVersion`` is set to ``1``.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TopicSubscriptionArgs', 'TopicSubscriptionArgsDict']]]] subscription: The SNS subscriptions (endpoints) for this topic.
                 If you specify the ``Subscription`` property in the ``AWS::SNS::Topic`` resource and it creates an associated subscription resource, the associated subscription is not deleted when the ``AWS::SNS::Topic`` resource is deleted.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The list of tags to add to a new topic.
                 To be able to tag a topic on creation, you must have the ``sns:CreateTopic`` and ``sns:TagResource`` permissions.
        :param pulumi.Input[str] topic_name: The name of the topic you want to create. Topic names must include only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters long. FIFO topic names must end with ``.fifo``.
                If you don't specify a name, CFN generates a unique physical ID and uses that ID for the topic name. For more information, see [Name type](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html).
                 If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
        :param pulumi.Input[str] tracing_config: Tracing mode of an SNS topic. By default ``TracingConfig`` is set to ``PassThrough``, and the topic passes through the tracing header it receives from an SNS publisher to its subscriptions. If set to ``Active``, SNS will vend X-Ray segment data to topic owner account if the sampled flag in the tracing header is true.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[TopicArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The ``AWS::SNS::Topic`` resource creates a topic to which notifications can be published.
          One account can create a maximum of 100,000 standard topics and 1,000 FIFO topics. For more information, see [endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/sns.html) in the *General Reference*.
           The structure of ``AUTHPARAMS`` depends on the .signature of the API request. For more information, see [Examples of the complete Signature Version 4 signing process](https://docs.aws.amazon.com/general/latest/gr/sigv4-signed-request-examples.html) in the *General Reference*.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        car_sales_topic = aws_native.sns.Topic("carSalesTopic")
        erp_integration_queue = aws_native.sqs.Queue("erpIntegrationQueue")
        erp_subscription = aws_native.sns.Subscription("erpSubscription",
            topic_arn=car_sales_topic.id,
            endpoint=erp_integration_queue.arn,
            protocol="sqs",
            raw_message_delivery=True)
        crm_integration_queue = aws_native.sqs.Queue("crmIntegrationQueue")
        crm_subscription = aws_native.sns.Subscription("crmSubscription",
            topic_arn=car_sales_topic.id,
            endpoint=crm_integration_queue.arn,
            protocol="sqs",
            raw_message_delivery=True,
            filter_policy={
                "buyer-class": ["vip"],
            })
        config = pulumi.Config()
        my_http_endpoint = config.require("myHttpEndpoint")
        scm_subscription = aws_native.sns.Subscription("scmSubscription",
            topic_arn=car_sales_topic.id,
            endpoint=my_http_endpoint,
            protocol="https",
            delivery_policy={
                "healthyRetryPolicy": {
                    "numRetries": 20,
                    "minDelayTarget": 10,
                    "maxDelayTarget": 30,
                    "numMinDelayRetries": 3,
                    "numMaxDelayRetries": 17,
                    "numNoDelayRetries": 0,
                    "backoffFunction": "exponential",
                },
            })

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        car_sales_topic = aws_native.sns.Topic("carSalesTopic")
        erp_integration_queue = aws_native.sqs.Queue("erpIntegrationQueue")
        erp_subscription = aws_native.sns.Subscription("erpSubscription",
            topic_arn=car_sales_topic.id,
            endpoint=erp_integration_queue.arn,
            protocol="sqs",
            raw_message_delivery=True)
        crm_integration_queue = aws_native.sqs.Queue("crmIntegrationQueue")
        crm_subscription = aws_native.sns.Subscription("crmSubscription",
            topic_arn=car_sales_topic.id,
            endpoint=crm_integration_queue.arn,
            protocol="sqs",
            raw_message_delivery=True,
            filter_policy={
                "buyer-class": ["vip"],
            })
        config = pulumi.Config()
        my_http_endpoint = config.require("myHttpEndpoint")
        scm_subscription = aws_native.sns.Subscription("scmSubscription",
            topic_arn=car_sales_topic.id,
            endpoint=my_http_endpoint,
            protocol="https",
            delivery_policy={
                "healthyRetryPolicy": {
                    "numRetries": 20,
                    "minDelayTarget": 10,
                    "maxDelayTarget": 30,
                    "numMinDelayRetries": 3,
                    "numMaxDelayRetries": 17,
                    "numNoDelayRetries": 0,
                    "backoffFunction": "exponential",
                },
            })

        ```

        :param str resource_name: The name of the resource.
        :param TopicArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TopicArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 archive_policy: Optional[Any] = None,
                 content_based_deduplication: Optional[pulumi.Input[bool]] = None,
                 data_protection_policy: Optional[Any] = None,
                 delivery_status_logging: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TopicLoggingConfigArgs', 'TopicLoggingConfigArgsDict']]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 fifo_topic: Optional[pulumi.Input[bool]] = None,
                 kms_master_key_id: Optional[pulumi.Input[str]] = None,
                 signature_version: Optional[pulumi.Input[str]] = None,
                 subscription: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TopicSubscriptionArgs', 'TopicSubscriptionArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 topic_name: Optional[pulumi.Input[str]] = None,
                 tracing_config: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TopicArgs.__new__(TopicArgs)

            __props__.__dict__["archive_policy"] = archive_policy
            __props__.__dict__["content_based_deduplication"] = content_based_deduplication
            __props__.__dict__["data_protection_policy"] = data_protection_policy
            __props__.__dict__["delivery_status_logging"] = delivery_status_logging
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["fifo_topic"] = fifo_topic
            __props__.__dict__["kms_master_key_id"] = kms_master_key_id
            __props__.__dict__["signature_version"] = signature_version
            __props__.__dict__["subscription"] = subscription
            __props__.__dict__["tags"] = tags
            __props__.__dict__["topic_name"] = topic_name
            __props__.__dict__["tracing_config"] = tracing_config
            __props__.__dict__["topic_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["fifoTopic", "topicName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Topic, __self__).__init__(
            'aws-native:sns:Topic',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Topic':
        """
        Get an existing Topic resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = TopicArgs.__new__(TopicArgs)

        __props__.__dict__["archive_policy"] = None
        __props__.__dict__["content_based_deduplication"] = None
        __props__.__dict__["data_protection_policy"] = None
        __props__.__dict__["delivery_status_logging"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["fifo_topic"] = None
        __props__.__dict__["kms_master_key_id"] = None
        __props__.__dict__["signature_version"] = None
        __props__.__dict__["subscription"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["topic_arn"] = None
        __props__.__dict__["topic_name"] = None
        __props__.__dict__["tracing_config"] = None
        return Topic(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="archivePolicy")
    def archive_policy(self) -> pulumi.Output[Optional[Any]]:
        """
        The archive policy determines the number of days SNS retains messages. You can set a retention period from 1 to 365 days.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SNS::Topic` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "archive_policy")

    @property
    @pulumi.getter(name="contentBasedDeduplication")
    def content_based_deduplication(self) -> pulumi.Output[Optional[bool]]:
        """
        Enables content-based deduplication for FIFO topics.
          +  By default, ``ContentBasedDeduplication`` is set to ``false``. If you create a FIFO topic and this attribute is ``false``, you must specify a value for the ``MessageDeduplicationId`` parameter for the [Publish](https://docs.aws.amazon.com/sns/latest/api/API_Publish.html) action. 
          +  When you set ``ContentBasedDeduplication`` to ``true``, SNS uses a SHA-256 hash to generate the ``MessageDeduplicationId`` using the body of the message (but not the attributes of the message).
         (Optional) To override the generated value, you can specify a value for the the ``MessageDeduplicationId`` parameter for the ``Publish`` action.
        """
        return pulumi.get(self, "content_based_deduplication")

    @property
    @pulumi.getter(name="dataProtectionPolicy")
    def data_protection_policy(self) -> pulumi.Output[Optional[Any]]:
        """
        The body of the policy document you want to use for this topic.
         You can only add one policy per topic.
         The policy must be in JSON string format.
         Length Constraints: Maximum length of 30,720.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SNS::Topic` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "data_protection_policy")

    @property
    @pulumi.getter(name="deliveryStatusLogging")
    def delivery_status_logging(self) -> pulumi.Output[Optional[Sequence['outputs.TopicLoggingConfig']]]:
        """
        The ``DeliveryStatusLogging`` configuration enables you to log the delivery status of messages sent from your Amazon SNS topic to subscribed endpoints with the following supported delivery protocols:
          +  HTTP 
          +  Amazon Kinesis Data Firehose
          +   AWS Lambda
          +  Platform application endpoint
          +  Amazon Simple Queue Service
          
         Once configured, log entries are sent to Amazon CloudWatch Logs.
        """
        return pulumi.get(self, "delivery_status_logging")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[str]]:
        """
        The display name to use for an SNS topic with SMS subscriptions. The display name must be maximum 100 characters long, including hyphens (-), underscores (_), spaces, and tabs.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="fifoTopic")
    def fifo_topic(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to true to create a FIFO topic.
        """
        return pulumi.get(self, "fifo_topic")

    @property
    @pulumi.getter(name="kmsMasterKeyId")
    def kms_master_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of an AWS managed customer master key (CMK) for SNS or a custom CMK. For more information, see [Key terms](https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms). For more examples, see ``KeyId`` in the *API Reference*.
         This property applies only to [server-side-encryption](https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html).
        """
        return pulumi.get(self, "kms_master_key_id")

    @property
    @pulumi.getter(name="signatureVersion")
    def signature_version(self) -> pulumi.Output[Optional[str]]:
        """
        The signature version corresponds to the hashing algorithm used while creating the signature of the notifications, subscription confirmations, or unsubscribe confirmation messages sent by Amazon SNS. By default, ``SignatureVersion`` is set to ``1``.
        """
        return pulumi.get(self, "signature_version")

    @property
    @pulumi.getter
    def subscription(self) -> pulumi.Output[Optional[Sequence['outputs.TopicSubscription']]]:
        """
        The SNS subscriptions (endpoints) for this topic.
          If you specify the ``Subscription`` property in the ``AWS::SNS::Topic`` resource and it creates an associated subscription resource, the associated subscription is not deleted when the ``AWS::SNS::Topic`` resource is deleted.
        """
        return pulumi.get(self, "subscription")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The list of tags to add to a new topic.
          To be able to tag a topic on creation, you must have the ``sns:CreateTopic`` and ``sns:TagResource`` permissions.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> pulumi.Output[str]:
        """
        Returns the ARN of an Amazon SNS topic.
        """
        return pulumi.get(self, "topic_arn")

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the topic you want to create. Topic names must include only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters long. FIFO topic names must end with ``.fifo``.
         If you don't specify a name, CFN generates a unique physical ID and uses that ID for the topic name. For more information, see [Name type](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html).
          If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
        """
        return pulumi.get(self, "topic_name")

    @property
    @pulumi.getter(name="tracingConfig")
    def tracing_config(self) -> pulumi.Output[Optional[str]]:
        """
        Tracing mode of an SNS topic. By default ``TracingConfig`` is set to ``PassThrough``, and the topic passes through the tracing header it receives from an SNS publisher to its subscriptions. If set to ``Active``, SNS will vend X-Ray segment data to topic owner account if the sampled flag in the tracing header is true.
        """
        return pulumi.get(self, "tracing_config")

