# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetTopicPolicyResult',
    'AwaitableGetTopicPolicyResult',
    'get_topic_policy',
    'get_topic_policy_output',
]

@pulumi.output_type
class GetTopicPolicyResult:
    def __init__(__self__, id=None, policy_document=None, topics=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if policy_document and not isinstance(policy_document, dict):
            raise TypeError("Expected argument 'policy_document' to be a dict")
        pulumi.set(__self__, "policy_document", policy_document)
        if topics and not isinstance(topics, list):
            raise TypeError("Expected argument 'topics' to be a list")
        pulumi.set(__self__, "topics", topics)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> Optional[Any]:
        """
        A policy document that contains permissions to add to the specified SNS topics.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SNS::TopicPolicy` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "policy_document")

    @property
    @pulumi.getter
    def topics(self) -> Optional[Sequence[str]]:
        """
        The Amazon Resource Names (ARN) of the topics to which you want to add the policy. You can use the ``Ref`` function to specify an ``AWS::SNS::Topic`` resource.
        """
        return pulumi.get(self, "topics")


class AwaitableGetTopicPolicyResult(GetTopicPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTopicPolicyResult(
            id=self.id,
            policy_document=self.policy_document,
            topics=self.topics)


def get_topic_policy(id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTopicPolicyResult:
    """
    The ``AWS::SNS::TopicPolicy`` resource associates SNS topics with a policy. For an example snippet, see [Declaring an policy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/quickref-iam.html#scenario-sns-policy) in the *User Guide*.


    :param str id: The provider-assigned unique ID for this managed resource.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:sns:getTopicPolicy', __args__, opts=opts, typ=GetTopicPolicyResult).value

    return AwaitableGetTopicPolicyResult(
        id=pulumi.get(__ret__, 'id'),
        policy_document=pulumi.get(__ret__, 'policy_document'),
        topics=pulumi.get(__ret__, 'topics'))
def get_topic_policy_output(id: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTopicPolicyResult]:
    """
    The ``AWS::SNS::TopicPolicy`` resource associates SNS topics with a policy. For an example snippet, see [Declaring an policy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/quickref-iam.html#scenario-sns-policy) in the *User Guide*.


    :param str id: The provider-assigned unique ID for this managed resource.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:sns:getTopicPolicy', __args__, opts=opts, typ=GetTopicPolicyResult)
    return __ret__.apply(lambda __response__: GetTopicPolicyResult(
        id=pulumi.get(__response__, 'id'),
        policy_document=pulumi.get(__response__, 'policy_document'),
        topics=pulumi.get(__response__, 'topics')))
