# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'SimulationS3Location',
]

@pulumi.output_type
class SimulationS3Location(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "objectKey":
            suggest = "object_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SimulationS3Location. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SimulationS3Location.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SimulationS3Location.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: str,
                 object_key: str):
        """
        :param str bucket_name: The Schema S3 bucket name.
        :param str object_key: This is the schema S3 object key, which includes the full path of "folders" from the bucket root to the schema.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "object_key", object_key)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The Schema S3 bucket name.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="objectKey")
    def object_key(self) -> str:
        """
        This is the schema S3 object key, which includes the full path of "folders" from the bucket root to the schema.
        """
        return pulumi.get(self, "object_key")


