# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TemplateInitArgs', 'Template']

@pulumi.input_type
class TemplateInitArgs:
    def __init__(__self__, *,
                 template: Optional[pulumi.Input['TemplateArgs']] = None):
        """
        The set of arguments for constructing a Template resource.
        :param pulumi.Input['TemplateArgs'] template: The content of the email, composed of a subject line and either an HTML part or a text-only part.
        """
        if template is not None:
            pulumi.set(__self__, "template", template)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['TemplateArgs']]:
        """
        The content of the email, composed of a subject line and either an HTML part or a text-only part.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['TemplateArgs']]):
        pulumi.set(self, "template", value)


class Template(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 template: Optional[pulumi.Input[Union['TemplateArgs', 'TemplateArgsDict']]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::SES::Template

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        template_name = config.require("templateName")
        subject_part = config.require("subjectPart")
        text_part = config.require("textPart")
        html_part = config.require("htmlPart")
        template = aws_native.ses.Template("template", template={
            "template_name": template_name,
            "subject_part": subject_part,
            "text_part": text_part,
            "html_part": html_part,
        })

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        template_name = config.require("templateName")
        subject_part = config.require("subjectPart")
        text_part = config.require("textPart")
        html_part = config.require("htmlPart")
        template = aws_native.ses.Template("template", template={
            "template_name": template_name,
            "subject_part": subject_part,
            "text_part": text_part,
            "html_part": html_part,
        })

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['TemplateArgs', 'TemplateArgsDict']] template: The content of the email, composed of a subject line and either an HTML part or a text-only part.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[TemplateInitArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::SES::Template

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        template_name = config.require("templateName")
        subject_part = config.require("subjectPart")
        text_part = config.require("textPart")
        html_part = config.require("htmlPart")
        template = aws_native.ses.Template("template", template={
            "template_name": template_name,
            "subject_part": subject_part,
            "text_part": text_part,
            "html_part": html_part,
        })

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        template_name = config.require("templateName")
        subject_part = config.require("subjectPart")
        text_part = config.require("textPart")
        html_part = config.require("htmlPart")
        template = aws_native.ses.Template("template", template={
            "template_name": template_name,
            "subject_part": subject_part,
            "text_part": text_part,
            "html_part": html_part,
        })

        ```

        :param str resource_name: The name of the resource.
        :param TemplateInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TemplateInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 template: Optional[pulumi.Input[Union['TemplateArgs', 'TemplateArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TemplateInitArgs.__new__(TemplateInitArgs)

            __props__.__dict__["template"] = template
            __props__.__dict__["aws_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["template.templateName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Template, __self__).__init__(
            'aws-native:ses:Template',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Template':
        """
        Get an existing Template resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = TemplateInitArgs.__new__(TemplateInitArgs)

        __props__.__dict__["aws_id"] = None
        __props__.__dict__["template"] = None
        return Template(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter
    def template(self) -> pulumi.Output[Optional['outputs.Template']]:
        """
        The content of the email, composed of a subject line and either an HTML part or a text-only part.
        """
        return pulumi.get(self, "template")

