# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['MailManagerRelayArgs', 'MailManagerRelay']

@pulumi.input_type
class MailManagerRelayArgs:
    def __init__(__self__, *,
                 authentication: pulumi.Input[Union['MailManagerRelayRelayAuthentication0PropertiesArgs', 'MailManagerRelayRelayAuthentication1PropertiesArgs']],
                 server_name: pulumi.Input[str],
                 server_port: pulumi.Input[float],
                 relay_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a MailManagerRelay resource.
        :param pulumi.Input[Union['MailManagerRelayRelayAuthentication0PropertiesArgs', 'MailManagerRelayRelayAuthentication1PropertiesArgs']] authentication: Authentication for the relay destination server—specify the secretARN where the SMTP credentials are stored.
        :param pulumi.Input[str] server_name: The destination relay server address.
        :param pulumi.Input[float] server_port: The destination relay server port.
        :param pulumi.Input[str] relay_name: The unique relay name.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
        """
        pulumi.set(__self__, "authentication", authentication)
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "server_port", server_port)
        if relay_name is not None:
            pulumi.set(__self__, "relay_name", relay_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def authentication(self) -> pulumi.Input[Union['MailManagerRelayRelayAuthentication0PropertiesArgs', 'MailManagerRelayRelayAuthentication1PropertiesArgs']]:
        """
        Authentication for the relay destination server—specify the secretARN where the SMTP credentials are stored.
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: pulumi.Input[Union['MailManagerRelayRelayAuthentication0PropertiesArgs', 'MailManagerRelayRelayAuthentication1PropertiesArgs']]):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Input[str]:
        """
        The destination relay server address.
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter(name="serverPort")
    def server_port(self) -> pulumi.Input[float]:
        """
        The destination relay server port.
        """
        return pulumi.get(self, "server_port")

    @server_port.setter
    def server_port(self, value: pulumi.Input[float]):
        pulumi.set(self, "server_port", value)

    @property
    @pulumi.getter(name="relayName")
    def relay_name(self) -> Optional[pulumi.Input[str]]:
        """
        The unique relay name.
        """
        return pulumi.get(self, "relay_name")

    @relay_name.setter
    def relay_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "relay_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class MailManagerRelay(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication: Optional[pulumi.Input[Union[Union['MailManagerRelayRelayAuthentication0PropertiesArgs', 'MailManagerRelayRelayAuthentication0PropertiesArgsDict'], Union['MailManagerRelayRelayAuthentication1PropertiesArgs', 'MailManagerRelayRelayAuthentication1PropertiesArgsDict']]]] = None,
                 relay_name: Optional[pulumi.Input[str]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 server_port: Optional[pulumi.Input[float]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Definition of AWS::SES::MailManagerRelay Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union[Union['MailManagerRelayRelayAuthentication0PropertiesArgs', 'MailManagerRelayRelayAuthentication0PropertiesArgsDict'], Union['MailManagerRelayRelayAuthentication1PropertiesArgs', 'MailManagerRelayRelayAuthentication1PropertiesArgsDict']]] authentication: Authentication for the relay destination server—specify the secretARN where the SMTP credentials are stored.
        :param pulumi.Input[str] relay_name: The unique relay name.
        :param pulumi.Input[str] server_name: The destination relay server address.
        :param pulumi.Input[float] server_port: The destination relay server port.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MailManagerRelayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::SES::MailManagerRelay Resource Type

        :param str resource_name: The name of the resource.
        :param MailManagerRelayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MailManagerRelayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication: Optional[pulumi.Input[Union[Union['MailManagerRelayRelayAuthentication0PropertiesArgs', 'MailManagerRelayRelayAuthentication0PropertiesArgsDict'], Union['MailManagerRelayRelayAuthentication1PropertiesArgs', 'MailManagerRelayRelayAuthentication1PropertiesArgsDict']]]] = None,
                 relay_name: Optional[pulumi.Input[str]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 server_port: Optional[pulumi.Input[float]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MailManagerRelayArgs.__new__(MailManagerRelayArgs)

            if authentication is None and not opts.urn:
                raise TypeError("Missing required property 'authentication'")
            __props__.__dict__["authentication"] = authentication
            __props__.__dict__["relay_name"] = relay_name
            if server_name is None and not opts.urn:
                raise TypeError("Missing required property 'server_name'")
            __props__.__dict__["server_name"] = server_name
            if server_port is None and not opts.urn:
                raise TypeError("Missing required property 'server_port'")
            __props__.__dict__["server_port"] = server_port
            __props__.__dict__["tags"] = tags
            __props__.__dict__["relay_arn"] = None
            __props__.__dict__["relay_id"] = None
        super(MailManagerRelay, __self__).__init__(
            'aws-native:ses:MailManagerRelay',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'MailManagerRelay':
        """
        Get an existing MailManagerRelay resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = MailManagerRelayArgs.__new__(MailManagerRelayArgs)

        __props__.__dict__["authentication"] = None
        __props__.__dict__["relay_arn"] = None
        __props__.__dict__["relay_id"] = None
        __props__.__dict__["relay_name"] = None
        __props__.__dict__["server_name"] = None
        __props__.__dict__["server_port"] = None
        __props__.__dict__["tags"] = None
        return MailManagerRelay(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def authentication(self) -> pulumi.Output[Any]:
        """
        Authentication for the relay destination server—specify the secretARN where the SMTP credentials are stored.
        """
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter(name="relayArn")
    def relay_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the relay.
        """
        return pulumi.get(self, "relay_arn")

    @property
    @pulumi.getter(name="relayId")
    def relay_id(self) -> pulumi.Output[str]:
        """
        The unique relay identifier.
        """
        return pulumi.get(self, "relay_id")

    @property
    @pulumi.getter(name="relayName")
    def relay_name(self) -> pulumi.Output[Optional[str]]:
        """
        The unique relay name.
        """
        return pulumi.get(self, "relay_name")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Output[str]:
        """
        The destination relay server address.
        """
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="serverPort")
    def server_port(self) -> pulumi.Output[float]:
        """
        The destination relay server port.
        """
        return pulumi.get(self, "server_port")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
        """
        return pulumi.get(self, "tags")

