# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs

__all__ = ['MailManagerAddonSubscriptionArgs', 'MailManagerAddonSubscription']

@pulumi.input_type
class MailManagerAddonSubscriptionArgs:
    def __init__(__self__, *,
                 addon_name: pulumi.Input[str],
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a MailManagerAddonSubscription resource.
        :param pulumi.Input[str] addon_name: The name of the Add On to subscribe to. You can only have one subscription for each Add On name.
               
               Valid Values: `TRENDMICRO_VSAPI | SPAMHAUS_DBL | ABUSIX_MAIL_INTELLIGENCE`
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
        """
        pulumi.set(__self__, "addon_name", addon_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="addonName")
    def addon_name(self) -> pulumi.Input[str]:
        """
        The name of the Add On to subscribe to. You can only have one subscription for each Add On name.

        Valid Values: `TRENDMICRO_VSAPI | SPAMHAUS_DBL | ABUSIX_MAIL_INTELLIGENCE`
        """
        return pulumi.get(self, "addon_name")

    @addon_name.setter
    def addon_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "addon_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class MailManagerAddonSubscription(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addon_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Definition of AWS::SES::MailManagerAddonSubscription Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] addon_name: The name of the Add On to subscribe to. You can only have one subscription for each Add On name.
               
               Valid Values: `TRENDMICRO_VSAPI | SPAMHAUS_DBL | ABUSIX_MAIL_INTELLIGENCE`
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MailManagerAddonSubscriptionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::SES::MailManagerAddonSubscription Resource Type

        :param str resource_name: The name of the resource.
        :param MailManagerAddonSubscriptionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MailManagerAddonSubscriptionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addon_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MailManagerAddonSubscriptionArgs.__new__(MailManagerAddonSubscriptionArgs)

            if addon_name is None and not opts.urn:
                raise TypeError("Missing required property 'addon_name'")
            __props__.__dict__["addon_name"] = addon_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["addon_subscription_arn"] = None
            __props__.__dict__["addon_subscription_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["addonName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(MailManagerAddonSubscription, __self__).__init__(
            'aws-native:ses:MailManagerAddonSubscription',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'MailManagerAddonSubscription':
        """
        Get an existing MailManagerAddonSubscription resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = MailManagerAddonSubscriptionArgs.__new__(MailManagerAddonSubscriptionArgs)

        __props__.__dict__["addon_name"] = None
        __props__.__dict__["addon_subscription_arn"] = None
        __props__.__dict__["addon_subscription_id"] = None
        __props__.__dict__["tags"] = None
        return MailManagerAddonSubscription(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="addonName")
    def addon_name(self) -> pulumi.Output[str]:
        """
        The name of the Add On to subscribe to. You can only have one subscription for each Add On name.

        Valid Values: `TRENDMICRO_VSAPI | SPAMHAUS_DBL | ABUSIX_MAIL_INTELLIGENCE`
        """
        return pulumi.get(self, "addon_name")

    @property
    @pulumi.getter(name="addonSubscriptionArn")
    def addon_subscription_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the Add On subscription.
        """
        return pulumi.get(self, "addon_subscription_arn")

    @property
    @pulumi.getter(name="addonSubscriptionId")
    def addon_subscription_id(self) -> pulumi.Output[str]:
        """
        The unique ID of the Add On subscription.
        """
        return pulumi.get(self, "addon_subscription_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
        """
        return pulumi.get(self, "tags")

