# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs

__all__ = ['MailManagerAddonInstanceArgs', 'MailManagerAddonInstance']

@pulumi.input_type
class MailManagerAddonInstanceArgs:
    def __init__(__self__, *,
                 addon_subscription_id: pulumi.Input[str],
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a MailManagerAddonInstance resource.
        :param pulumi.Input[str] addon_subscription_id: The subscription ID for the instance.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
        """
        pulumi.set(__self__, "addon_subscription_id", addon_subscription_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="addonSubscriptionId")
    def addon_subscription_id(self) -> pulumi.Input[str]:
        """
        The subscription ID for the instance.
        """
        return pulumi.get(self, "addon_subscription_id")

    @addon_subscription_id.setter
    def addon_subscription_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "addon_subscription_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class MailManagerAddonInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addon_subscription_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Definition of AWS::SES::MailManagerAddonInstance Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] addon_subscription_id: The subscription ID for the instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MailManagerAddonInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::SES::MailManagerAddonInstance Resource Type

        :param str resource_name: The name of the resource.
        :param MailManagerAddonInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MailManagerAddonInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addon_subscription_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MailManagerAddonInstanceArgs.__new__(MailManagerAddonInstanceArgs)

            if addon_subscription_id is None and not opts.urn:
                raise TypeError("Missing required property 'addon_subscription_id'")
            __props__.__dict__["addon_subscription_id"] = addon_subscription_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["addon_instance_arn"] = None
            __props__.__dict__["addon_instance_id"] = None
            __props__.__dict__["addon_name"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["addonSubscriptionId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(MailManagerAddonInstance, __self__).__init__(
            'aws-native:ses:MailManagerAddonInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'MailManagerAddonInstance':
        """
        Get an existing MailManagerAddonInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = MailManagerAddonInstanceArgs.__new__(MailManagerAddonInstanceArgs)

        __props__.__dict__["addon_instance_arn"] = None
        __props__.__dict__["addon_instance_id"] = None
        __props__.__dict__["addon_name"] = None
        __props__.__dict__["addon_subscription_id"] = None
        __props__.__dict__["tags"] = None
        return MailManagerAddonInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="addonInstanceArn")
    def addon_instance_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the Add On instance.
        """
        return pulumi.get(self, "addon_instance_arn")

    @property
    @pulumi.getter(name="addonInstanceId")
    def addon_instance_id(self) -> pulumi.Output[str]:
        """
        The unique ID of the Add On instance.
        """
        return pulumi.get(self, "addon_instance_id")

    @property
    @pulumi.getter(name="addonName")
    def addon_name(self) -> pulumi.Output[str]:
        """
        The name of the Add On for the instance.
        """
        return pulumi.get(self, "addon_name")

    @property
    @pulumi.getter(name="addonSubscriptionId")
    def addon_subscription_id(self) -> pulumi.Output[str]:
        """
        The subscription ID for the instance.
        """
        return pulumi.get(self, "addon_subscription_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
        """
        return pulumi.get(self, "tags")

