# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetMailManagerAddonInstanceResult',
    'AwaitableGetMailManagerAddonInstanceResult',
    'get_mail_manager_addon_instance',
    'get_mail_manager_addon_instance_output',
]

@pulumi.output_type
class GetMailManagerAddonInstanceResult:
    def __init__(__self__, addon_instance_arn=None, addon_instance_id=None, addon_name=None, tags=None):
        if addon_instance_arn and not isinstance(addon_instance_arn, str):
            raise TypeError("Expected argument 'addon_instance_arn' to be a str")
        pulumi.set(__self__, "addon_instance_arn", addon_instance_arn)
        if addon_instance_id and not isinstance(addon_instance_id, str):
            raise TypeError("Expected argument 'addon_instance_id' to be a str")
        pulumi.set(__self__, "addon_instance_id", addon_instance_id)
        if addon_name and not isinstance(addon_name, str):
            raise TypeError("Expected argument 'addon_name' to be a str")
        pulumi.set(__self__, "addon_name", addon_name)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="addonInstanceArn")
    def addon_instance_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the Add On instance.
        """
        return pulumi.get(self, "addon_instance_arn")

    @property
    @pulumi.getter(name="addonInstanceId")
    def addon_instance_id(self) -> Optional[str]:
        """
        The unique ID of the Add On instance.
        """
        return pulumi.get(self, "addon_instance_id")

    @property
    @pulumi.getter(name="addonName")
    def addon_name(self) -> Optional[str]:
        """
        The name of the Add On for the instance.
        """
        return pulumi.get(self, "addon_name")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
        """
        return pulumi.get(self, "tags")


class AwaitableGetMailManagerAddonInstanceResult(GetMailManagerAddonInstanceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMailManagerAddonInstanceResult(
            addon_instance_arn=self.addon_instance_arn,
            addon_instance_id=self.addon_instance_id,
            addon_name=self.addon_name,
            tags=self.tags)


def get_mail_manager_addon_instance(addon_instance_id: Optional[str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMailManagerAddonInstanceResult:
    """
    Definition of AWS::SES::MailManagerAddonInstance Resource Type


    :param str addon_instance_id: The unique ID of the Add On instance.
    """
    __args__ = dict()
    __args__['addonInstanceId'] = addon_instance_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ses:getMailManagerAddonInstance', __args__, opts=opts, typ=GetMailManagerAddonInstanceResult).value

    return AwaitableGetMailManagerAddonInstanceResult(
        addon_instance_arn=pulumi.get(__ret__, 'addon_instance_arn'),
        addon_instance_id=pulumi.get(__ret__, 'addon_instance_id'),
        addon_name=pulumi.get(__ret__, 'addon_name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_mail_manager_addon_instance_output(addon_instance_id: Optional[pulumi.Input[str]] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMailManagerAddonInstanceResult]:
    """
    Definition of AWS::SES::MailManagerAddonInstance Resource Type


    :param str addon_instance_id: The unique ID of the Add On instance.
    """
    __args__ = dict()
    __args__['addonInstanceId'] = addon_instance_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ses:getMailManagerAddonInstance', __args__, opts=opts, typ=GetMailManagerAddonInstanceResult)
    return __ret__.apply(lambda __response__: GetMailManagerAddonInstanceResult(
        addon_instance_arn=pulumi.get(__response__, 'addon_instance_arn'),
        addon_instance_id=pulumi.get(__response__, 'addon_instance_id'),
        addon_name=pulumi.get(__response__, 'addon_name'),
        tags=pulumi.get(__response__, 'tags')))
