# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EmailIdentityArgs', 'EmailIdentity']

@pulumi.input_type
class EmailIdentityArgs:
    def __init__(__self__, *,
                 email_identity: pulumi.Input[str],
                 configuration_set_attributes: Optional[pulumi.Input['EmailIdentityConfigurationSetAttributesArgs']] = None,
                 dkim_attributes: Optional[pulumi.Input['EmailIdentityDkimAttributesArgs']] = None,
                 dkim_signing_attributes: Optional[pulumi.Input['EmailIdentityDkimSigningAttributesArgs']] = None,
                 feedback_attributes: Optional[pulumi.Input['EmailIdentityFeedbackAttributesArgs']] = None,
                 mail_from_attributes: Optional[pulumi.Input['EmailIdentityMailFromAttributesArgs']] = None):
        """
        The set of arguments for constructing a EmailIdentity resource.
        :param pulumi.Input[str] email_identity: The email address or domain to verify.
        :param pulumi.Input['EmailIdentityConfigurationSetAttributesArgs'] configuration_set_attributes: Used to associate a configuration set with an email identity.
        :param pulumi.Input['EmailIdentityDkimAttributesArgs'] dkim_attributes: An object that contains information about the DKIM attributes for the identity.
        :param pulumi.Input['EmailIdentityDkimSigningAttributesArgs'] dkim_signing_attributes: If your request includes this object, Amazon SES configures the identity to use Bring Your Own DKIM (BYODKIM) for DKIM authentication purposes, or, configures the key length to be used for [Easy DKIM](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html) .
               
               You can only specify this object if the email identity is a domain, as opposed to an address.
        :param pulumi.Input['EmailIdentityFeedbackAttributesArgs'] feedback_attributes: Used to enable or disable feedback forwarding for an identity.
        :param pulumi.Input['EmailIdentityMailFromAttributesArgs'] mail_from_attributes: Used to enable or disable the custom Mail-From domain configuration for an email identity.
        """
        pulumi.set(__self__, "email_identity", email_identity)
        if configuration_set_attributes is not None:
            pulumi.set(__self__, "configuration_set_attributes", configuration_set_attributes)
        if dkim_attributes is not None:
            pulumi.set(__self__, "dkim_attributes", dkim_attributes)
        if dkim_signing_attributes is not None:
            pulumi.set(__self__, "dkim_signing_attributes", dkim_signing_attributes)
        if feedback_attributes is not None:
            pulumi.set(__self__, "feedback_attributes", feedback_attributes)
        if mail_from_attributes is not None:
            pulumi.set(__self__, "mail_from_attributes", mail_from_attributes)

    @property
    @pulumi.getter(name="emailIdentity")
    def email_identity(self) -> pulumi.Input[str]:
        """
        The email address or domain to verify.
        """
        return pulumi.get(self, "email_identity")

    @email_identity.setter
    def email_identity(self, value: pulumi.Input[str]):
        pulumi.set(self, "email_identity", value)

    @property
    @pulumi.getter(name="configurationSetAttributes")
    def configuration_set_attributes(self) -> Optional[pulumi.Input['EmailIdentityConfigurationSetAttributesArgs']]:
        """
        Used to associate a configuration set with an email identity.
        """
        return pulumi.get(self, "configuration_set_attributes")

    @configuration_set_attributes.setter
    def configuration_set_attributes(self, value: Optional[pulumi.Input['EmailIdentityConfigurationSetAttributesArgs']]):
        pulumi.set(self, "configuration_set_attributes", value)

    @property
    @pulumi.getter(name="dkimAttributes")
    def dkim_attributes(self) -> Optional[pulumi.Input['EmailIdentityDkimAttributesArgs']]:
        """
        An object that contains information about the DKIM attributes for the identity.
        """
        return pulumi.get(self, "dkim_attributes")

    @dkim_attributes.setter
    def dkim_attributes(self, value: Optional[pulumi.Input['EmailIdentityDkimAttributesArgs']]):
        pulumi.set(self, "dkim_attributes", value)

    @property
    @pulumi.getter(name="dkimSigningAttributes")
    def dkim_signing_attributes(self) -> Optional[pulumi.Input['EmailIdentityDkimSigningAttributesArgs']]:
        """
        If your request includes this object, Amazon SES configures the identity to use Bring Your Own DKIM (BYODKIM) for DKIM authentication purposes, or, configures the key length to be used for [Easy DKIM](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html) .

        You can only specify this object if the email identity is a domain, as opposed to an address.
        """
        return pulumi.get(self, "dkim_signing_attributes")

    @dkim_signing_attributes.setter
    def dkim_signing_attributes(self, value: Optional[pulumi.Input['EmailIdentityDkimSigningAttributesArgs']]):
        pulumi.set(self, "dkim_signing_attributes", value)

    @property
    @pulumi.getter(name="feedbackAttributes")
    def feedback_attributes(self) -> Optional[pulumi.Input['EmailIdentityFeedbackAttributesArgs']]:
        """
        Used to enable or disable feedback forwarding for an identity.
        """
        return pulumi.get(self, "feedback_attributes")

    @feedback_attributes.setter
    def feedback_attributes(self, value: Optional[pulumi.Input['EmailIdentityFeedbackAttributesArgs']]):
        pulumi.set(self, "feedback_attributes", value)

    @property
    @pulumi.getter(name="mailFromAttributes")
    def mail_from_attributes(self) -> Optional[pulumi.Input['EmailIdentityMailFromAttributesArgs']]:
        """
        Used to enable or disable the custom Mail-From domain configuration for an email identity.
        """
        return pulumi.get(self, "mail_from_attributes")

    @mail_from_attributes.setter
    def mail_from_attributes(self, value: Optional[pulumi.Input['EmailIdentityMailFromAttributesArgs']]):
        pulumi.set(self, "mail_from_attributes", value)


class EmailIdentity(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration_set_attributes: Optional[pulumi.Input[Union['EmailIdentityConfigurationSetAttributesArgs', 'EmailIdentityConfigurationSetAttributesArgsDict']]] = None,
                 dkim_attributes: Optional[pulumi.Input[Union['EmailIdentityDkimAttributesArgs', 'EmailIdentityDkimAttributesArgsDict']]] = None,
                 dkim_signing_attributes: Optional[pulumi.Input[Union['EmailIdentityDkimSigningAttributesArgs', 'EmailIdentityDkimSigningAttributesArgsDict']]] = None,
                 email_identity: Optional[pulumi.Input[str]] = None,
                 feedback_attributes: Optional[pulumi.Input[Union['EmailIdentityFeedbackAttributesArgs', 'EmailIdentityFeedbackAttributesArgsDict']]] = None,
                 mail_from_attributes: Optional[pulumi.Input[Union['EmailIdentityMailFromAttributesArgs', 'EmailIdentityMailFromAttributesArgsDict']]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::SES::EmailIdentity

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['EmailIdentityConfigurationSetAttributesArgs', 'EmailIdentityConfigurationSetAttributesArgsDict']] configuration_set_attributes: Used to associate a configuration set with an email identity.
        :param pulumi.Input[Union['EmailIdentityDkimAttributesArgs', 'EmailIdentityDkimAttributesArgsDict']] dkim_attributes: An object that contains information about the DKIM attributes for the identity.
        :param pulumi.Input[Union['EmailIdentityDkimSigningAttributesArgs', 'EmailIdentityDkimSigningAttributesArgsDict']] dkim_signing_attributes: If your request includes this object, Amazon SES configures the identity to use Bring Your Own DKIM (BYODKIM) for DKIM authentication purposes, or, configures the key length to be used for [Easy DKIM](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html) .
               
               You can only specify this object if the email identity is a domain, as opposed to an address.
        :param pulumi.Input[str] email_identity: The email address or domain to verify.
        :param pulumi.Input[Union['EmailIdentityFeedbackAttributesArgs', 'EmailIdentityFeedbackAttributesArgsDict']] feedback_attributes: Used to enable or disable feedback forwarding for an identity.
        :param pulumi.Input[Union['EmailIdentityMailFromAttributesArgs', 'EmailIdentityMailFromAttributesArgsDict']] mail_from_attributes: Used to enable or disable the custom Mail-From domain configuration for an email identity.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EmailIdentityArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::SES::EmailIdentity

        :param str resource_name: The name of the resource.
        :param EmailIdentityArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EmailIdentityArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration_set_attributes: Optional[pulumi.Input[Union['EmailIdentityConfigurationSetAttributesArgs', 'EmailIdentityConfigurationSetAttributesArgsDict']]] = None,
                 dkim_attributes: Optional[pulumi.Input[Union['EmailIdentityDkimAttributesArgs', 'EmailIdentityDkimAttributesArgsDict']]] = None,
                 dkim_signing_attributes: Optional[pulumi.Input[Union['EmailIdentityDkimSigningAttributesArgs', 'EmailIdentityDkimSigningAttributesArgsDict']]] = None,
                 email_identity: Optional[pulumi.Input[str]] = None,
                 feedback_attributes: Optional[pulumi.Input[Union['EmailIdentityFeedbackAttributesArgs', 'EmailIdentityFeedbackAttributesArgsDict']]] = None,
                 mail_from_attributes: Optional[pulumi.Input[Union['EmailIdentityMailFromAttributesArgs', 'EmailIdentityMailFromAttributesArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EmailIdentityArgs.__new__(EmailIdentityArgs)

            __props__.__dict__["configuration_set_attributes"] = configuration_set_attributes
            __props__.__dict__["dkim_attributes"] = dkim_attributes
            __props__.__dict__["dkim_signing_attributes"] = dkim_signing_attributes
            if email_identity is None and not opts.urn:
                raise TypeError("Missing required property 'email_identity'")
            __props__.__dict__["email_identity"] = email_identity
            __props__.__dict__["feedback_attributes"] = feedback_attributes
            __props__.__dict__["mail_from_attributes"] = mail_from_attributes
            __props__.__dict__["dkim_dns_token_name1"] = None
            __props__.__dict__["dkim_dns_token_name2"] = None
            __props__.__dict__["dkim_dns_token_name3"] = None
            __props__.__dict__["dkim_dns_token_value1"] = None
            __props__.__dict__["dkim_dns_token_value2"] = None
            __props__.__dict__["dkim_dns_token_value3"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["emailIdentity"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(EmailIdentity, __self__).__init__(
            'aws-native:ses:EmailIdentity',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'EmailIdentity':
        """
        Get an existing EmailIdentity resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = EmailIdentityArgs.__new__(EmailIdentityArgs)

        __props__.__dict__["configuration_set_attributes"] = None
        __props__.__dict__["dkim_attributes"] = None
        __props__.__dict__["dkim_dns_token_name1"] = None
        __props__.__dict__["dkim_dns_token_name2"] = None
        __props__.__dict__["dkim_dns_token_name3"] = None
        __props__.__dict__["dkim_dns_token_value1"] = None
        __props__.__dict__["dkim_dns_token_value2"] = None
        __props__.__dict__["dkim_dns_token_value3"] = None
        __props__.__dict__["dkim_signing_attributes"] = None
        __props__.__dict__["email_identity"] = None
        __props__.__dict__["feedback_attributes"] = None
        __props__.__dict__["mail_from_attributes"] = None
        return EmailIdentity(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="configurationSetAttributes")
    def configuration_set_attributes(self) -> pulumi.Output[Optional['outputs.EmailIdentityConfigurationSetAttributes']]:
        """
        Used to associate a configuration set with an email identity.
        """
        return pulumi.get(self, "configuration_set_attributes")

    @property
    @pulumi.getter(name="dkimAttributes")
    def dkim_attributes(self) -> pulumi.Output[Optional['outputs.EmailIdentityDkimAttributes']]:
        """
        An object that contains information about the DKIM attributes for the identity.
        """
        return pulumi.get(self, "dkim_attributes")

    @property
    @pulumi.getter(name="dkimDnsTokenName1")
    def dkim_dns_token_name1(self) -> pulumi.Output[str]:
        """
        The host name for the first token that you have to add to the DNS configuration for your domain.
        """
        return pulumi.get(self, "dkim_dns_token_name1")

    @property
    @pulumi.getter(name="dkimDnsTokenName2")
    def dkim_dns_token_name2(self) -> pulumi.Output[str]:
        """
        The host name for the second token that you have to add to the DNS configuration for your domain.
        """
        return pulumi.get(self, "dkim_dns_token_name2")

    @property
    @pulumi.getter(name="dkimDnsTokenName3")
    def dkim_dns_token_name3(self) -> pulumi.Output[str]:
        """
        The host name for the third token that you have to add to the DNS configuration for your domain.
        """
        return pulumi.get(self, "dkim_dns_token_name3")

    @property
    @pulumi.getter(name="dkimDnsTokenValue1")
    def dkim_dns_token_value1(self) -> pulumi.Output[str]:
        """
        The record value for the first token that you have to add to the DNS configuration for your domain.
        """
        return pulumi.get(self, "dkim_dns_token_value1")

    @property
    @pulumi.getter(name="dkimDnsTokenValue2")
    def dkim_dns_token_value2(self) -> pulumi.Output[str]:
        """
        The record value for the second token that you have to add to the DNS configuration for your domain.
        """
        return pulumi.get(self, "dkim_dns_token_value2")

    @property
    @pulumi.getter(name="dkimDnsTokenValue3")
    def dkim_dns_token_value3(self) -> pulumi.Output[str]:
        """
        The record value for the third token that you have to add to the DNS configuration for your domain.
        """
        return pulumi.get(self, "dkim_dns_token_value3")

    @property
    @pulumi.getter(name="dkimSigningAttributes")
    def dkim_signing_attributes(self) -> pulumi.Output[Optional['outputs.EmailIdentityDkimSigningAttributes']]:
        """
        If your request includes this object, Amazon SES configures the identity to use Bring Your Own DKIM (BYODKIM) for DKIM authentication purposes, or, configures the key length to be used for [Easy DKIM](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html) .

        You can only specify this object if the email identity is a domain, as opposed to an address.
        """
        return pulumi.get(self, "dkim_signing_attributes")

    @property
    @pulumi.getter(name="emailIdentity")
    def email_identity(self) -> pulumi.Output[str]:
        """
        The email address or domain to verify.
        """
        return pulumi.get(self, "email_identity")

    @property
    @pulumi.getter(name="feedbackAttributes")
    def feedback_attributes(self) -> pulumi.Output[Optional['outputs.EmailIdentityFeedbackAttributes']]:
        """
        Used to enable or disable feedback forwarding for an identity.
        """
        return pulumi.get(self, "feedback_attributes")

    @property
    @pulumi.getter(name="mailFromAttributes")
    def mail_from_attributes(self) -> pulumi.Output[Optional['outputs.EmailIdentityMailFromAttributes']]:
        """
        Used to enable or disable the custom Mail-From domain configuration for an email identity.
        """
        return pulumi.get(self, "mail_from_attributes")

