# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'GetResourceAssociationResult',
    'AwaitableGetResourceAssociationResult',
    'get_resource_association',
    'get_resource_association_output',
]

@pulumi.output_type
class GetResourceAssociationResult:
    def __init__(__self__, application_arn=None, resource_arn=None):
        if application_arn and not isinstance(application_arn, str):
            raise TypeError("Expected argument 'application_arn' to be a str")
        pulumi.set(__self__, "application_arn", application_arn)
        if resource_arn and not isinstance(resource_arn, str):
            raise TypeError("Expected argument 'resource_arn' to be a str")
        pulumi.set(__self__, "resource_arn", resource_arn)

    @property
    @pulumi.getter(name="applicationArn")
    def application_arn(self) -> Optional[str]:
        """
        The Amazon resource name (ARN) that specifies the application.
        """
        return pulumi.get(self, "application_arn")

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> Optional[str]:
        """
        The Amazon resource name (ARN) that specifies the resource.
        """
        return pulumi.get(self, "resource_arn")


class AwaitableGetResourceAssociationResult(GetResourceAssociationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourceAssociationResult(
            application_arn=self.application_arn,
            resource_arn=self.resource_arn)


def get_resource_association(application_arn: Optional[str] = None,
                             resource_arn: Optional[str] = None,
                             resource_type: Optional['ResourceAssociationResourceType'] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResourceAssociationResult:
    """
    Resource Schema for AWS::ServiceCatalogAppRegistry::ResourceAssociation


    :param str application_arn: The Amazon resource name (ARN) that specifies the application.
    :param str resource_arn: The Amazon resource name (ARN) that specifies the resource.
    :param 'ResourceAssociationResourceType' resource_type: The type of the CFN Resource for now it's enum CFN_STACK.
    """
    __args__ = dict()
    __args__['applicationArn'] = application_arn
    __args__['resourceArn'] = resource_arn
    __args__['resourceType'] = resource_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:servicecatalogappregistry:getResourceAssociation', __args__, opts=opts, typ=GetResourceAssociationResult).value

    return AwaitableGetResourceAssociationResult(
        application_arn=pulumi.get(__ret__, 'application_arn'),
        resource_arn=pulumi.get(__ret__, 'resource_arn'))
def get_resource_association_output(application_arn: Optional[pulumi.Input[str]] = None,
                                    resource_arn: Optional[pulumi.Input[str]] = None,
                                    resource_type: Optional[pulumi.Input['ResourceAssociationResourceType']] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetResourceAssociationResult]:
    """
    Resource Schema for AWS::ServiceCatalogAppRegistry::ResourceAssociation


    :param str application_arn: The Amazon resource name (ARN) that specifies the application.
    :param str resource_arn: The Amazon resource name (ARN) that specifies the resource.
    :param 'ResourceAssociationResourceType' resource_type: The type of the CFN Resource for now it's enum CFN_STACK.
    """
    __args__ = dict()
    __args__['applicationArn'] = application_arn
    __args__['resourceArn'] = resource_arn
    __args__['resourceType'] = resource_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:servicecatalogappregistry:getResourceAssociation', __args__, opts=opts, typ=GetResourceAssociationResult)
    return __ret__.apply(lambda __response__: GetResourceAssociationResult(
        application_arn=pulumi.get(__response__, 'application_arn'),
        resource_arn=pulumi.get(__response__, 'resource_arn')))
