# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['SubscriberNotificationArgs', 'SubscriberNotification']

@pulumi.input_type
class SubscriberNotificationArgs:
    def __init__(__self__, *,
                 notification_configuration: pulumi.Input['SubscriberNotificationNotificationConfigurationArgs'],
                 subscriber_arn: pulumi.Input[str]):
        """
        The set of arguments for constructing a SubscriberNotification resource.
        :param pulumi.Input['SubscriberNotificationNotificationConfigurationArgs'] notification_configuration: Specify the configurations you want to use for subscriber notification. The subscriber is notified when new data is written to the data lake for sources that the subscriber consumes in Security Lake .
        :param pulumi.Input[str] subscriber_arn: The ARN for the subscriber
        """
        pulumi.set(__self__, "notification_configuration", notification_configuration)
        pulumi.set(__self__, "subscriber_arn", subscriber_arn)

    @property
    @pulumi.getter(name="notificationConfiguration")
    def notification_configuration(self) -> pulumi.Input['SubscriberNotificationNotificationConfigurationArgs']:
        """
        Specify the configurations you want to use for subscriber notification. The subscriber is notified when new data is written to the data lake for sources that the subscriber consumes in Security Lake .
        """
        return pulumi.get(self, "notification_configuration")

    @notification_configuration.setter
    def notification_configuration(self, value: pulumi.Input['SubscriberNotificationNotificationConfigurationArgs']):
        pulumi.set(self, "notification_configuration", value)

    @property
    @pulumi.getter(name="subscriberArn")
    def subscriber_arn(self) -> pulumi.Input[str]:
        """
        The ARN for the subscriber
        """
        return pulumi.get(self, "subscriber_arn")

    @subscriber_arn.setter
    def subscriber_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "subscriber_arn", value)


class SubscriberNotification(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 notification_configuration: Optional[pulumi.Input[Union['SubscriberNotificationNotificationConfigurationArgs', 'SubscriberNotificationNotificationConfigurationArgsDict']]] = None,
                 subscriber_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::SecurityLake::SubscriberNotification

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SubscriberNotificationNotificationConfigurationArgs', 'SubscriberNotificationNotificationConfigurationArgsDict']] notification_configuration: Specify the configurations you want to use for subscriber notification. The subscriber is notified when new data is written to the data lake for sources that the subscriber consumes in Security Lake .
        :param pulumi.Input[str] subscriber_arn: The ARN for the subscriber
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SubscriberNotificationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::SecurityLake::SubscriberNotification

        :param str resource_name: The name of the resource.
        :param SubscriberNotificationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SubscriberNotificationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 notification_configuration: Optional[pulumi.Input[Union['SubscriberNotificationNotificationConfigurationArgs', 'SubscriberNotificationNotificationConfigurationArgsDict']]] = None,
                 subscriber_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SubscriberNotificationArgs.__new__(SubscriberNotificationArgs)

            if notification_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'notification_configuration'")
            __props__.__dict__["notification_configuration"] = notification_configuration
            if subscriber_arn is None and not opts.urn:
                raise TypeError("Missing required property 'subscriber_arn'")
            __props__.__dict__["subscriber_arn"] = subscriber_arn
            __props__.__dict__["subscriber_endpoint"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["subscriberArn"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(SubscriberNotification, __self__).__init__(
            'aws-native:securitylake:SubscriberNotification',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'SubscriberNotification':
        """
        Get an existing SubscriberNotification resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SubscriberNotificationArgs.__new__(SubscriberNotificationArgs)

        __props__.__dict__["notification_configuration"] = None
        __props__.__dict__["subscriber_arn"] = None
        __props__.__dict__["subscriber_endpoint"] = None
        return SubscriberNotification(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="notificationConfiguration")
    def notification_configuration(self) -> pulumi.Output['outputs.SubscriberNotificationNotificationConfiguration']:
        """
        Specify the configurations you want to use for subscriber notification. The subscriber is notified when new data is written to the data lake for sources that the subscriber consumes in Security Lake .
        """
        return pulumi.get(self, "notification_configuration")

    @property
    @pulumi.getter(name="subscriberArn")
    def subscriber_arn(self) -> pulumi.Output[str]:
        """
        The ARN for the subscriber
        """
        return pulumi.get(self, "subscriber_arn")

    @property
    @pulumi.getter(name="subscriberEndpoint")
    def subscriber_endpoint(self) -> pulumi.Output[str]:
        """
        The endpoint the subscriber should listen to for notifications
        """
        return pulumi.get(self, "subscriber_endpoint")

