# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'DataLakeEncryptionConfiguration',
    'DataLakeExpiration',
    'DataLakeLifecycleConfiguration',
    'DataLakeReplicationConfiguration',
    'DataLakeTransitions',
    'SubscriberAwsLogSource',
    'SubscriberCustomLogSource',
    'SubscriberIdentityProperties',
    'SubscriberNotificationHttpsNotificationConfiguration',
    'SubscriberNotificationNotificationConfiguration',
    'SubscriberNotificationSqsNotificationConfiguration',
    'SubscriberSource',
]

@pulumi.output_type
class DataLakeEncryptionConfiguration(dict):
    """
    Provides encryption details of Amazon Security Lake object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataLakeEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataLakeEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataLakeEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_id: Optional[str] = None):
        """
        Provides encryption details of Amazon Security Lake object.
        :param str kms_key_id: The id of KMS encryption key used by Amazon Security Lake to encrypt the Security Lake object.
        """
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The id of KMS encryption key used by Amazon Security Lake to encrypt the Security Lake object.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class DataLakeExpiration(dict):
    """
    Provides data expiration details of Amazon Security Lake object.
    """
    def __init__(__self__, *,
                 days: Optional[int] = None):
        """
        Provides data expiration details of Amazon Security Lake object.
        :param int days: The number of days before data expires in the Amazon Security Lake object.
        """
        if days is not None:
            pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        The number of days before data expires in the Amazon Security Lake object.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class DataLakeLifecycleConfiguration(dict):
    """
    Provides lifecycle details of Amazon Security Lake object.
    """
    def __init__(__self__, *,
                 expiration: Optional['outputs.DataLakeExpiration'] = None,
                 transitions: Optional[Sequence['outputs.DataLakeTransitions']] = None):
        """
        Provides lifecycle details of Amazon Security Lake object.
        :param 'DataLakeExpiration' expiration: Provides data expiration details of the Amazon Security Lake object.
        :param Sequence['DataLakeTransitions'] transitions: Provides data storage transition details of Amazon Security Lake object.
        """
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if transitions is not None:
            pulumi.set(__self__, "transitions", transitions)

    @property
    @pulumi.getter
    def expiration(self) -> Optional['outputs.DataLakeExpiration']:
        """
        Provides data expiration details of the Amazon Security Lake object.
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter
    def transitions(self) -> Optional[Sequence['outputs.DataLakeTransitions']]:
        """
        Provides data storage transition details of Amazon Security Lake object.
        """
        return pulumi.get(self, "transitions")


@pulumi.output_type
class DataLakeReplicationConfiguration(dict):
    """
    Provides replication details of Amazon Security Lake object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataLakeReplicationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataLakeReplicationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataLakeReplicationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 regions: Optional[Sequence[str]] = None,
                 role_arn: Optional[str] = None):
        """
        Provides replication details of Amazon Security Lake object.
        :param Sequence[str] regions: Specifies one or more centralized rollup Regions. The AWS Region specified in the region parameter of the `CreateDataLake` or `UpdateDataLake` operations contributes data to the rollup Region or Regions specified in this parameter.
               
               Replication enables automatic, asynchronous copying of objects across Amazon S3 buckets. S3 buckets that are configured for object replication can be owned by the same AWS account or by different accounts. You can replicate objects to a single destination bucket or to multiple destination buckets. The destination buckets can be in different Regions or within the same Region as the source bucket.
        :param str role_arn: Replication settings for the Amazon S3 buckets. This parameter uses the AWS Identity and Access Management (IAM) role you created that is managed by Security Lake, to ensure the replication setting is correct.
        """
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter
    def regions(self) -> Optional[Sequence[str]]:
        """
        Specifies one or more centralized rollup Regions. The AWS Region specified in the region parameter of the `CreateDataLake` or `UpdateDataLake` operations contributes data to the rollup Region or Regions specified in this parameter.

        Replication enables automatic, asynchronous copying of objects across Amazon S3 buckets. S3 buckets that are configured for object replication can be owned by the same AWS account or by different accounts. You can replicate objects to a single destination bucket or to multiple destination buckets. The destination buckets can be in different Regions or within the same Region as the source bucket.
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        """
        Replication settings for the Amazon S3 buckets. This parameter uses the AWS Identity and Access Management (IAM) role you created that is managed by Security Lake, to ensure the replication setting is correct.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class DataLakeTransitions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClass":
            suggest = "storage_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataLakeTransitions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataLakeTransitions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataLakeTransitions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days: Optional[int] = None,
                 storage_class: Optional[str] = None):
        """
        :param int days: Number of days before data transitions to a different S3 Storage Class in the Amazon Security Lake object.
        :param str storage_class: The range of storage classes that you can choose from based on the data access, resiliency, and cost requirements of your workloads.
        """
        if days is not None:
            pulumi.set(__self__, "days", days)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        Number of days before data transitions to a different S3 Storage Class in the Amazon Security Lake object.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[str]:
        """
        The range of storage classes that you can choose from based on the data access, resiliency, and cost requirements of your workloads.
        """
        return pulumi.get(self, "storage_class")


@pulumi.output_type
class SubscriberAwsLogSource(dict):
    """
    Amazon Security Lake supports log and event collection for natively supported AWS services.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceName":
            suggest = "source_name"
        elif key == "sourceVersion":
            suggest = "source_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriberAwsLogSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriberAwsLogSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriberAwsLogSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_name: Optional[str] = None,
                 source_version: Optional[str] = None):
        """
        Amazon Security Lake supports log and event collection for natively supported AWS services.
        :param str source_name: The name for a AWS source. This must be a Regionally unique value.
        :param str source_version: The version for a AWS source. This must be a Regionally unique value.
        """
        if source_name is not None:
            pulumi.set(__self__, "source_name", source_name)
        if source_version is not None:
            pulumi.set(__self__, "source_version", source_version)

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> Optional[str]:
        """
        The name for a AWS source. This must be a Regionally unique value.
        """
        return pulumi.get(self, "source_name")

    @property
    @pulumi.getter(name="sourceVersion")
    def source_version(self) -> Optional[str]:
        """
        The version for a AWS source. This must be a Regionally unique value.
        """
        return pulumi.get(self, "source_version")


@pulumi.output_type
class SubscriberCustomLogSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceName":
            suggest = "source_name"
        elif key == "sourceVersion":
            suggest = "source_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriberCustomLogSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriberCustomLogSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriberCustomLogSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_name: Optional[str] = None,
                 source_version: Optional[str] = None):
        """
        :param str source_name: The name for a third-party custom source. This must be a Regionally unique value.
        :param str source_version: The version for a third-party custom source. This must be a Regionally unique value.
        """
        if source_name is not None:
            pulumi.set(__self__, "source_name", source_name)
        if source_version is not None:
            pulumi.set(__self__, "source_version", source_version)

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> Optional[str]:
        """
        The name for a third-party custom source. This must be a Regionally unique value.
        """
        return pulumi.get(self, "source_name")

    @property
    @pulumi.getter(name="sourceVersion")
    def source_version(self) -> Optional[str]:
        """
        The version for a third-party custom source. This must be a Regionally unique value.
        """
        return pulumi.get(self, "source_version")


@pulumi.output_type
class SubscriberIdentityProperties(dict):
    """
    The AWS identity used to access your data.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalId":
            suggest = "external_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriberIdentityProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriberIdentityProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriberIdentityProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_id: str,
                 principal: str):
        """
        The AWS identity used to access your data.
        :param str external_id: The external ID used to establish trust relationship with the AWS identity.
        :param str principal: The AWS identity principal.
        """
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "principal", principal)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> str:
        """
        The external ID used to establish trust relationship with the AWS identity.
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter
    def principal(self) -> str:
        """
        The AWS identity principal.
        """
        return pulumi.get(self, "principal")


@pulumi.output_type
class SubscriberNotificationHttpsNotificationConfiguration(dict):
    """
    The configuration for HTTPS subscriber notification.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetRoleArn":
            suggest = "target_role_arn"
        elif key == "authorizationApiKeyName":
            suggest = "authorization_api_key_name"
        elif key == "authorizationApiKeyValue":
            suggest = "authorization_api_key_value"
        elif key == "httpMethod":
            suggest = "http_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriberNotificationHttpsNotificationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriberNotificationHttpsNotificationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriberNotificationHttpsNotificationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint: str,
                 target_role_arn: str,
                 authorization_api_key_name: Optional[str] = None,
                 authorization_api_key_value: Optional[str] = None,
                 http_method: Optional['SubscriberNotificationHttpsNotificationConfigurationHttpMethod'] = None):
        """
        The configuration for HTTPS subscriber notification.
        :param str endpoint: The subscription endpoint in Security Lake.
        :param str target_role_arn: The Amazon Resource Name (ARN) of the EventBridge API destinations IAM role that you created.
        :param str authorization_api_key_name: The key name for the notification subscription.
        :param str authorization_api_key_value: The key value for the notification subscription.
        :param 'SubscriberNotificationHttpsNotificationConfigurationHttpMethod' http_method: The HTTPS method used for the notification subscription.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "target_role_arn", target_role_arn)
        if authorization_api_key_name is not None:
            pulumi.set(__self__, "authorization_api_key_name", authorization_api_key_name)
        if authorization_api_key_value is not None:
            pulumi.set(__self__, "authorization_api_key_value", authorization_api_key_value)
        if http_method is not None:
            pulumi.set(__self__, "http_method", http_method)

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        The subscription endpoint in Security Lake.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="targetRoleArn")
    def target_role_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the EventBridge API destinations IAM role that you created.
        """
        return pulumi.get(self, "target_role_arn")

    @property
    @pulumi.getter(name="authorizationApiKeyName")
    def authorization_api_key_name(self) -> Optional[str]:
        """
        The key name for the notification subscription.
        """
        return pulumi.get(self, "authorization_api_key_name")

    @property
    @pulumi.getter(name="authorizationApiKeyValue")
    def authorization_api_key_value(self) -> Optional[str]:
        """
        The key value for the notification subscription.
        """
        return pulumi.get(self, "authorization_api_key_value")

    @property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> Optional['SubscriberNotificationHttpsNotificationConfigurationHttpMethod']:
        """
        The HTTPS method used for the notification subscription.
        """
        return pulumi.get(self, "http_method")


@pulumi.output_type
class SubscriberNotificationNotificationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpsNotificationConfiguration":
            suggest = "https_notification_configuration"
        elif key == "sqsNotificationConfiguration":
            suggest = "sqs_notification_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriberNotificationNotificationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriberNotificationNotificationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriberNotificationNotificationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 https_notification_configuration: Optional['outputs.SubscriberNotificationHttpsNotificationConfiguration'] = None,
                 sqs_notification_configuration: Optional['outputs.SubscriberNotificationSqsNotificationConfiguration'] = None):
        """
        :param 'SubscriberNotificationHttpsNotificationConfiguration' https_notification_configuration: The configurations used for HTTPS subscriber notification.
        :param 'SubscriberNotificationSqsNotificationConfiguration' sqs_notification_configuration: The configurations for SQS subscriber notification. The members of this structure are context-dependent.
        """
        if https_notification_configuration is not None:
            pulumi.set(__self__, "https_notification_configuration", https_notification_configuration)
        if sqs_notification_configuration is not None:
            pulumi.set(__self__, "sqs_notification_configuration", sqs_notification_configuration)

    @property
    @pulumi.getter(name="httpsNotificationConfiguration")
    def https_notification_configuration(self) -> Optional['outputs.SubscriberNotificationHttpsNotificationConfiguration']:
        """
        The configurations used for HTTPS subscriber notification.
        """
        return pulumi.get(self, "https_notification_configuration")

    @property
    @pulumi.getter(name="sqsNotificationConfiguration")
    def sqs_notification_configuration(self) -> Optional['outputs.SubscriberNotificationSqsNotificationConfiguration']:
        """
        The configurations for SQS subscriber notification. The members of this structure are context-dependent.
        """
        return pulumi.get(self, "sqs_notification_configuration")


@pulumi.output_type
class SubscriberNotificationSqsNotificationConfiguration(dict):
    """
    The configurations for SQS subscriber notification. The members of this structure are context-dependent.
    """
    def __init__(__self__):
        """
        The configurations for SQS subscriber notification. The members of this structure are context-dependent.
        """
        pass


@pulumi.output_type
class SubscriberSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsLogSource":
            suggest = "aws_log_source"
        elif key == "customLogSource":
            suggest = "custom_log_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriberSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriberSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriberSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_log_source: Optional['outputs.SubscriberAwsLogSource'] = None,
                 custom_log_source: Optional['outputs.SubscriberCustomLogSource'] = None):
        if aws_log_source is not None:
            pulumi.set(__self__, "aws_log_source", aws_log_source)
        if custom_log_source is not None:
            pulumi.set(__self__, "custom_log_source", custom_log_source)

    @property
    @pulumi.getter(name="awsLogSource")
    def aws_log_source(self) -> Optional['outputs.SubscriberAwsLogSource']:
        return pulumi.get(self, "aws_log_source")

    @property
    @pulumi.getter(name="customLogSource")
    def custom_log_source(self) -> Optional['outputs.SubscriberCustomLogSource']:
        return pulumi.get(self, "custom_log_source")


