# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetSubscriberNotificationResult',
    'AwaitableGetSubscriberNotificationResult',
    'get_subscriber_notification',
    'get_subscriber_notification_output',
]

@pulumi.output_type
class GetSubscriberNotificationResult:
    def __init__(__self__, notification_configuration=None, subscriber_endpoint=None):
        if notification_configuration and not isinstance(notification_configuration, dict):
            raise TypeError("Expected argument 'notification_configuration' to be a dict")
        pulumi.set(__self__, "notification_configuration", notification_configuration)
        if subscriber_endpoint and not isinstance(subscriber_endpoint, str):
            raise TypeError("Expected argument 'subscriber_endpoint' to be a str")
        pulumi.set(__self__, "subscriber_endpoint", subscriber_endpoint)

    @property
    @pulumi.getter(name="notificationConfiguration")
    def notification_configuration(self) -> Optional['outputs.SubscriberNotificationNotificationConfiguration']:
        """
        Specify the configurations you want to use for subscriber notification. The subscriber is notified when new data is written to the data lake for sources that the subscriber consumes in Security Lake .
        """
        return pulumi.get(self, "notification_configuration")

    @property
    @pulumi.getter(name="subscriberEndpoint")
    def subscriber_endpoint(self) -> Optional[str]:
        """
        The endpoint the subscriber should listen to for notifications
        """
        return pulumi.get(self, "subscriber_endpoint")


class AwaitableGetSubscriberNotificationResult(GetSubscriberNotificationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubscriberNotificationResult(
            notification_configuration=self.notification_configuration,
            subscriber_endpoint=self.subscriber_endpoint)


def get_subscriber_notification(subscriber_arn: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubscriberNotificationResult:
    """
    Resource Type definition for AWS::SecurityLake::SubscriberNotification


    :param str subscriber_arn: The ARN for the subscriber
    """
    __args__ = dict()
    __args__['subscriberArn'] = subscriber_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:securitylake:getSubscriberNotification', __args__, opts=opts, typ=GetSubscriberNotificationResult).value

    return AwaitableGetSubscriberNotificationResult(
        notification_configuration=pulumi.get(__ret__, 'notification_configuration'),
        subscriber_endpoint=pulumi.get(__ret__, 'subscriber_endpoint'))
def get_subscriber_notification_output(subscriber_arn: Optional[pulumi.Input[str]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSubscriberNotificationResult]:
    """
    Resource Type definition for AWS::SecurityLake::SubscriberNotification


    :param str subscriber_arn: The ARN for the subscriber
    """
    __args__ = dict()
    __args__['subscriberArn'] = subscriber_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:securitylake:getSubscriberNotification', __args__, opts=opts, typ=GetSubscriberNotificationResult)
    return __ret__.apply(lambda __response__: GetSubscriberNotificationResult(
        notification_configuration=pulumi.get(__response__, 'notification_configuration'),
        subscriber_endpoint=pulumi.get(__response__, 'subscriber_endpoint')))
