# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AwsLogSourceArgs', 'AwsLogSource']

@pulumi.input_type
class AwsLogSourceArgs:
    def __init__(__self__, *,
                 data_lake_arn: pulumi.Input[str],
                 source_version: pulumi.Input[str],
                 accounts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AwsLogSource resource.
        :param pulumi.Input[str] data_lake_arn: The ARN for the data lake.
        :param pulumi.Input[str] source_version: The version for a AWS source. This must be a Regionally unique value.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] accounts: AWS account where you want to collect logs from.
        :param pulumi.Input[str] source_name: The name for a AWS source. This must be a Regionally unique value.
        """
        pulumi.set(__self__, "data_lake_arn", data_lake_arn)
        pulumi.set(__self__, "source_version", source_version)
        if accounts is not None:
            pulumi.set(__self__, "accounts", accounts)
        if source_name is not None:
            pulumi.set(__self__, "source_name", source_name)

    @property
    @pulumi.getter(name="dataLakeArn")
    def data_lake_arn(self) -> pulumi.Input[str]:
        """
        The ARN for the data lake.
        """
        return pulumi.get(self, "data_lake_arn")

    @data_lake_arn.setter
    def data_lake_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_lake_arn", value)

    @property
    @pulumi.getter(name="sourceVersion")
    def source_version(self) -> pulumi.Input[str]:
        """
        The version for a AWS source. This must be a Regionally unique value.
        """
        return pulumi.get(self, "source_version")

    @source_version.setter
    def source_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_version", value)

    @property
    @pulumi.getter
    def accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        AWS account where you want to collect logs from.
        """
        return pulumi.get(self, "accounts")

    @accounts.setter
    def accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "accounts", value)

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name for a AWS source. This must be a Regionally unique value.
        """
        return pulumi.get(self, "source_name")

    @source_name.setter
    def source_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_name", value)


class AwsLogSource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accounts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 data_lake_arn: Optional[pulumi.Input[str]] = None,
                 source_name: Optional[pulumi.Input[str]] = None,
                 source_version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::SecurityLake::AwsLogSource

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] accounts: AWS account where you want to collect logs from.
        :param pulumi.Input[str] data_lake_arn: The ARN for the data lake.
        :param pulumi.Input[str] source_name: The name for a AWS source. This must be a Regionally unique value.
        :param pulumi.Input[str] source_version: The version for a AWS source. This must be a Regionally unique value.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsLogSourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::SecurityLake::AwsLogSource

        :param str resource_name: The name of the resource.
        :param AwsLogSourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsLogSourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accounts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 data_lake_arn: Optional[pulumi.Input[str]] = None,
                 source_name: Optional[pulumi.Input[str]] = None,
                 source_version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsLogSourceArgs.__new__(AwsLogSourceArgs)

            __props__.__dict__["accounts"] = accounts
            if data_lake_arn is None and not opts.urn:
                raise TypeError("Missing required property 'data_lake_arn'")
            __props__.__dict__["data_lake_arn"] = data_lake_arn
            __props__.__dict__["source_name"] = source_name
            if source_version is None and not opts.urn:
                raise TypeError("Missing required property 'source_version'")
            __props__.__dict__["source_version"] = source_version
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["dataLakeArn", "sourceName", "sourceVersion"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(AwsLogSource, __self__).__init__(
            'aws-native:securitylake:AwsLogSource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'AwsLogSource':
        """
        Get an existing AwsLogSource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AwsLogSourceArgs.__new__(AwsLogSourceArgs)

        __props__.__dict__["accounts"] = None
        __props__.__dict__["data_lake_arn"] = None
        __props__.__dict__["source_name"] = None
        __props__.__dict__["source_version"] = None
        return AwsLogSource(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def accounts(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        AWS account where you want to collect logs from.
        """
        return pulumi.get(self, "accounts")

    @property
    @pulumi.getter(name="dataLakeArn")
    def data_lake_arn(self) -> pulumi.Output[str]:
        """
        The ARN for the data lake.
        """
        return pulumi.get(self, "data_lake_arn")

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> pulumi.Output[str]:
        """
        The name for a AWS source. This must be a Regionally unique value.
        """
        return pulumi.get(self, "source_name")

    @property
    @pulumi.getter(name="sourceVersion")
    def source_version(self) -> pulumi.Output[str]:
        """
        The version for a AWS source. This must be a Regionally unique value.
        """
        return pulumi.get(self, "source_version")

