# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['SecurityControlArgs', 'SecurityControl']

@pulumi.input_type
class SecurityControlArgs:
    def __init__(__self__, *,
                 parameters: pulumi.Input[Mapping[str, pulumi.Input['SecurityControlParameterConfigurationArgs']]],
                 last_update_reason: Optional[pulumi.Input[str]] = None,
                 security_control_arn: Optional[pulumi.Input[str]] = None,
                 security_control_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SecurityControl resource.
        :param pulumi.Input[Mapping[str, pulumi.Input['SecurityControlParameterConfigurationArgs']]] parameters: An object that identifies the name of a control parameter, its current value, and whether it has been customized.
        :param pulumi.Input[str] last_update_reason: The most recent reason for updating the customizable properties of a security control. This differs from the UpdateReason field of the BatchUpdateStandardsControlAssociations API, which tracks the reason for updating the enablement status of a control. This field accepts alphanumeric characters in addition to white spaces, dashes, and underscores.
        :param pulumi.Input[str] security_control_arn: The Amazon Resource Name (ARN) for a security control across standards, such as `arn:aws:securityhub:eu-central-1:123456789012:security-control/S3.1`. This parameter doesn't mention a specific standard.
        :param pulumi.Input[str] security_control_id: The unique identifier of a security control across standards. Values for this field typically consist of an AWS service name and a number, such as APIGateway.3.
        """
        pulumi.set(__self__, "parameters", parameters)
        if last_update_reason is not None:
            pulumi.set(__self__, "last_update_reason", last_update_reason)
        if security_control_arn is not None:
            pulumi.set(__self__, "security_control_arn", security_control_arn)
        if security_control_id is not None:
            pulumi.set(__self__, "security_control_id", security_control_id)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input[Mapping[str, pulumi.Input['SecurityControlParameterConfigurationArgs']]]:
        """
        An object that identifies the name of a control parameter, its current value, and whether it has been customized.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input[Mapping[str, pulumi.Input['SecurityControlParameterConfigurationArgs']]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="lastUpdateReason")
    def last_update_reason(self) -> Optional[pulumi.Input[str]]:
        """
        The most recent reason for updating the customizable properties of a security control. This differs from the UpdateReason field of the BatchUpdateStandardsControlAssociations API, which tracks the reason for updating the enablement status of a control. This field accepts alphanumeric characters in addition to white spaces, dashes, and underscores.
        """
        return pulumi.get(self, "last_update_reason")

    @last_update_reason.setter
    def last_update_reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_update_reason", value)

    @property
    @pulumi.getter(name="securityControlArn")
    def security_control_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) for a security control across standards, such as `arn:aws:securityhub:eu-central-1:123456789012:security-control/S3.1`. This parameter doesn't mention a specific standard.
        """
        return pulumi.get(self, "security_control_arn")

    @security_control_arn.setter
    def security_control_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_control_arn", value)

    @property
    @pulumi.getter(name="securityControlId")
    def security_control_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier of a security control across standards. Values for this field typically consist of an AWS service name and a number, such as APIGateway.3.
        """
        return pulumi.get(self, "security_control_id")

    @security_control_id.setter
    def security_control_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_control_id", value)


class SecurityControl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 last_update_reason: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['SecurityControlParameterConfigurationArgs', 'SecurityControlParameterConfigurationArgsDict']]]]] = None,
                 security_control_arn: Optional[pulumi.Input[str]] = None,
                 security_control_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A security control in Security Hub describes a security best practice related to a specific resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] last_update_reason: The most recent reason for updating the customizable properties of a security control. This differs from the UpdateReason field of the BatchUpdateStandardsControlAssociations API, which tracks the reason for updating the enablement status of a control. This field accepts alphanumeric characters in addition to white spaces, dashes, and underscores.
        :param pulumi.Input[Mapping[str, pulumi.Input[Union['SecurityControlParameterConfigurationArgs', 'SecurityControlParameterConfigurationArgsDict']]]] parameters: An object that identifies the name of a control parameter, its current value, and whether it has been customized.
        :param pulumi.Input[str] security_control_arn: The Amazon Resource Name (ARN) for a security control across standards, such as `arn:aws:securityhub:eu-central-1:123456789012:security-control/S3.1`. This parameter doesn't mention a specific standard.
        :param pulumi.Input[str] security_control_id: The unique identifier of a security control across standards. Values for this field typically consist of an AWS service name and a number, such as APIGateway.3.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityControlArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A security control in Security Hub describes a security best practice related to a specific resource.

        :param str resource_name: The name of the resource.
        :param SecurityControlArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityControlArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 last_update_reason: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['SecurityControlParameterConfigurationArgs', 'SecurityControlParameterConfigurationArgsDict']]]]] = None,
                 security_control_arn: Optional[pulumi.Input[str]] = None,
                 security_control_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityControlArgs.__new__(SecurityControlArgs)

            __props__.__dict__["last_update_reason"] = last_update_reason
            if parameters is None and not opts.urn:
                raise TypeError("Missing required property 'parameters'")
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["security_control_arn"] = security_control_arn
            __props__.__dict__["security_control_id"] = security_control_id
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["securityControlId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(SecurityControl, __self__).__init__(
            'aws-native:securityhub:SecurityControl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'SecurityControl':
        """
        Get an existing SecurityControl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SecurityControlArgs.__new__(SecurityControlArgs)

        __props__.__dict__["last_update_reason"] = None
        __props__.__dict__["parameters"] = None
        __props__.__dict__["security_control_arn"] = None
        __props__.__dict__["security_control_id"] = None
        return SecurityControl(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="lastUpdateReason")
    def last_update_reason(self) -> pulumi.Output[Optional[str]]:
        """
        The most recent reason for updating the customizable properties of a security control. This differs from the UpdateReason field of the BatchUpdateStandardsControlAssociations API, which tracks the reason for updating the enablement status of a control. This field accepts alphanumeric characters in addition to white spaces, dashes, and underscores.
        """
        return pulumi.get(self, "last_update_reason")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Mapping[str, 'outputs.SecurityControlParameterConfiguration']]:
        """
        An object that identifies the name of a control parameter, its current value, and whether it has been customized.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="securityControlArn")
    def security_control_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon Resource Name (ARN) for a security control across standards, such as `arn:aws:securityhub:eu-central-1:123456789012:security-control/S3.1`. This parameter doesn't mention a specific standard.
        """
        return pulumi.get(self, "security_control_arn")

    @property
    @pulumi.getter(name="securityControlId")
    def security_control_id(self) -> pulumi.Output[Optional[str]]:
        """
        The unique identifier of a security control across standards. Values for this field typically consist of an AWS service name and a number, such as APIGateway.3.
        """
        return pulumi.get(self, "security_control_id")

