# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = ['PolicyAssociationArgs', 'PolicyAssociation']

@pulumi.input_type
class PolicyAssociationArgs:
    def __init__(__self__, *,
                 configuration_policy_id: pulumi.Input[str],
                 target_id: pulumi.Input[str],
                 target_type: pulumi.Input['PolicyAssociationTargetType']):
        """
        The set of arguments for constructing a PolicyAssociation resource.
        :param pulumi.Input[str] configuration_policy_id: The universally unique identifier (UUID) of the configuration policy or a value of SELF_MANAGED_SECURITY_HUB for a self-managed configuration
        :param pulumi.Input[str] target_id: The identifier of the target account, organizational unit, or the root
        :param pulumi.Input['PolicyAssociationTargetType'] target_type: Indicates whether the target is an AWS account, organizational unit, or the organization root
        """
        pulumi.set(__self__, "configuration_policy_id", configuration_policy_id)
        pulumi.set(__self__, "target_id", target_id)
        pulumi.set(__self__, "target_type", target_type)

    @property
    @pulumi.getter(name="configurationPolicyId")
    def configuration_policy_id(self) -> pulumi.Input[str]:
        """
        The universally unique identifier (UUID) of the configuration policy or a value of SELF_MANAGED_SECURITY_HUB for a self-managed configuration
        """
        return pulumi.get(self, "configuration_policy_id")

    @configuration_policy_id.setter
    def configuration_policy_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "configuration_policy_id", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Input[str]:
        """
        The identifier of the target account, organizational unit, or the root
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_id", value)

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> pulumi.Input['PolicyAssociationTargetType']:
        """
        Indicates whether the target is an AWS account, organizational unit, or the organization root
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: pulumi.Input['PolicyAssociationTargetType']):
        pulumi.set(self, "target_type", value)


class PolicyAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration_policy_id: Optional[pulumi.Input[str]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 target_type: Optional[pulumi.Input['PolicyAssociationTargetType']] = None,
                 __props__=None):
        """
        The AWS::SecurityHub::PolicyAssociation resource represents the AWS Security Hub Central Configuration Policy associations in your Target. Only the AWS Security Hub delegated administrator can create the resouce from the home region.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] configuration_policy_id: The universally unique identifier (UUID) of the configuration policy or a value of SELF_MANAGED_SECURITY_HUB for a self-managed configuration
        :param pulumi.Input[str] target_id: The identifier of the target account, organizational unit, or the root
        :param pulumi.Input['PolicyAssociationTargetType'] target_type: Indicates whether the target is an AWS account, organizational unit, or the organization root
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The AWS::SecurityHub::PolicyAssociation resource represents the AWS Security Hub Central Configuration Policy associations in your Target. Only the AWS Security Hub delegated administrator can create the resouce from the home region.

        :param str resource_name: The name of the resource.
        :param PolicyAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration_policy_id: Optional[pulumi.Input[str]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 target_type: Optional[pulumi.Input['PolicyAssociationTargetType']] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyAssociationArgs.__new__(PolicyAssociationArgs)

            if configuration_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'configuration_policy_id'")
            __props__.__dict__["configuration_policy_id"] = configuration_policy_id
            if target_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_id'")
            __props__.__dict__["target_id"] = target_id
            if target_type is None and not opts.urn:
                raise TypeError("Missing required property 'target_type'")
            __props__.__dict__["target_type"] = target_type
            __props__.__dict__["association_identifier"] = None
            __props__.__dict__["association_status"] = None
            __props__.__dict__["association_status_message"] = None
            __props__.__dict__["association_type"] = None
            __props__.__dict__["updated_at"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["targetId", "targetType"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(PolicyAssociation, __self__).__init__(
            'aws-native:securityhub:PolicyAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'PolicyAssociation':
        """
        Get an existing PolicyAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = PolicyAssociationArgs.__new__(PolicyAssociationArgs)

        __props__.__dict__["association_identifier"] = None
        __props__.__dict__["association_status"] = None
        __props__.__dict__["association_status_message"] = None
        __props__.__dict__["association_type"] = None
        __props__.__dict__["configuration_policy_id"] = None
        __props__.__dict__["target_id"] = None
        __props__.__dict__["target_type"] = None
        __props__.__dict__["updated_at"] = None
        return PolicyAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="associationIdentifier")
    def association_identifier(self) -> pulumi.Output[str]:
        """
        A unique identifier to indicates if the target has an association
        """
        return pulumi.get(self, "association_identifier")

    @property
    @pulumi.getter(name="associationStatus")
    def association_status(self) -> pulumi.Output['PolicyAssociationAssociationStatus']:
        """
        The current status of the association between the specified target and the configuration
        """
        return pulumi.get(self, "association_status")

    @property
    @pulumi.getter(name="associationStatusMessage")
    def association_status_message(self) -> pulumi.Output[str]:
        """
        An explanation for a FAILED value for AssociationStatus
        """
        return pulumi.get(self, "association_status_message")

    @property
    @pulumi.getter(name="associationType")
    def association_type(self) -> pulumi.Output['PolicyAssociationAssociationType']:
        """
        Indicates whether the association between the specified target and the configuration was directly applied by the Security Hub delegated administrator or inherited from a parent
        """
        return pulumi.get(self, "association_type")

    @property
    @pulumi.getter(name="configurationPolicyId")
    def configuration_policy_id(self) -> pulumi.Output[str]:
        """
        The universally unique identifier (UUID) of the configuration policy or a value of SELF_MANAGED_SECURITY_HUB for a self-managed configuration
        """
        return pulumi.get(self, "configuration_policy_id")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Output[str]:
        """
        The identifier of the target account, organizational unit, or the root
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> pulumi.Output['PolicyAssociationTargetType']:
        """
        Indicates whether the target is an AWS account, organizational unit, or the organization root
        """
        return pulumi.get(self, "target_type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        The date and time, in UTC and ISO 8601 format, that the configuration policy association was last updated
        """
        return pulumi.get(self, "updated_at")

