# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = ['OrganizationConfigurationArgs', 'OrganizationConfiguration']

@pulumi.input_type
class OrganizationConfigurationArgs:
    def __init__(__self__, *,
                 auto_enable: pulumi.Input[bool],
                 auto_enable_standards: Optional[pulumi.Input['OrganizationConfigurationAutoEnableStandards']] = None,
                 configuration_type: Optional[pulumi.Input['OrganizationConfigurationConfigurationType']] = None):
        """
        The set of arguments for constructing a OrganizationConfiguration resource.
        :param pulumi.Input[bool] auto_enable: Whether to automatically enable Security Hub in new member accounts when they join the organization.
        :param pulumi.Input['OrganizationConfigurationAutoEnableStandards'] auto_enable_standards: Whether to automatically enable Security Hub default standards in new member accounts when they join the organization.
        :param pulumi.Input['OrganizationConfigurationConfigurationType'] configuration_type: Indicates whether the organization uses local or central configuration.
        """
        pulumi.set(__self__, "auto_enable", auto_enable)
        if auto_enable_standards is not None:
            pulumi.set(__self__, "auto_enable_standards", auto_enable_standards)
        if configuration_type is not None:
            pulumi.set(__self__, "configuration_type", configuration_type)

    @property
    @pulumi.getter(name="autoEnable")
    def auto_enable(self) -> pulumi.Input[bool]:
        """
        Whether to automatically enable Security Hub in new member accounts when they join the organization.
        """
        return pulumi.get(self, "auto_enable")

    @auto_enable.setter
    def auto_enable(self, value: pulumi.Input[bool]):
        pulumi.set(self, "auto_enable", value)

    @property
    @pulumi.getter(name="autoEnableStandards")
    def auto_enable_standards(self) -> Optional[pulumi.Input['OrganizationConfigurationAutoEnableStandards']]:
        """
        Whether to automatically enable Security Hub default standards in new member accounts when they join the organization.
        """
        return pulumi.get(self, "auto_enable_standards")

    @auto_enable_standards.setter
    def auto_enable_standards(self, value: Optional[pulumi.Input['OrganizationConfigurationAutoEnableStandards']]):
        pulumi.set(self, "auto_enable_standards", value)

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> Optional[pulumi.Input['OrganizationConfigurationConfigurationType']]:
        """
        Indicates whether the organization uses local or central configuration.
        """
        return pulumi.get(self, "configuration_type")

    @configuration_type.setter
    def configuration_type(self, value: Optional[pulumi.Input['OrganizationConfigurationConfigurationType']]):
        pulumi.set(self, "configuration_type", value)


class OrganizationConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_enable: Optional[pulumi.Input[bool]] = None,
                 auto_enable_standards: Optional[pulumi.Input['OrganizationConfigurationAutoEnableStandards']] = None,
                 configuration_type: Optional[pulumi.Input['OrganizationConfigurationConfigurationType']] = None,
                 __props__=None):
        """
        The AWS::SecurityHub::OrganizationConfiguration resource represents the configuration of your organization in Security Hub. Only the Security Hub administrator account can create Organization Configuration resource in each region and can opt-in to Central Configuration only in the aggregation region of FindingAggregator.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_enable: Whether to automatically enable Security Hub in new member accounts when they join the organization.
        :param pulumi.Input['OrganizationConfigurationAutoEnableStandards'] auto_enable_standards: Whether to automatically enable Security Hub default standards in new member accounts when they join the organization.
        :param pulumi.Input['OrganizationConfigurationConfigurationType'] configuration_type: Indicates whether the organization uses local or central configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The AWS::SecurityHub::OrganizationConfiguration resource represents the configuration of your organization in Security Hub. Only the Security Hub administrator account can create Organization Configuration resource in each region and can opt-in to Central Configuration only in the aggregation region of FindingAggregator.

        :param str resource_name: The name of the resource.
        :param OrganizationConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_enable: Optional[pulumi.Input[bool]] = None,
                 auto_enable_standards: Optional[pulumi.Input['OrganizationConfigurationAutoEnableStandards']] = None,
                 configuration_type: Optional[pulumi.Input['OrganizationConfigurationConfigurationType']] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationConfigurationArgs.__new__(OrganizationConfigurationArgs)

            if auto_enable is None and not opts.urn:
                raise TypeError("Missing required property 'auto_enable'")
            __props__.__dict__["auto_enable"] = auto_enable
            __props__.__dict__["auto_enable_standards"] = auto_enable_standards
            __props__.__dict__["configuration_type"] = configuration_type
            __props__.__dict__["member_account_limit_reached"] = None
            __props__.__dict__["organization_configuration_identifier"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["status_message"] = None
        super(OrganizationConfiguration, __self__).__init__(
            'aws-native:securityhub:OrganizationConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'OrganizationConfiguration':
        """
        Get an existing OrganizationConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = OrganizationConfigurationArgs.__new__(OrganizationConfigurationArgs)

        __props__.__dict__["auto_enable"] = None
        __props__.__dict__["auto_enable_standards"] = None
        __props__.__dict__["configuration_type"] = None
        __props__.__dict__["member_account_limit_reached"] = None
        __props__.__dict__["organization_configuration_identifier"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["status_message"] = None
        return OrganizationConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoEnable")
    def auto_enable(self) -> pulumi.Output[bool]:
        """
        Whether to automatically enable Security Hub in new member accounts when they join the organization.
        """
        return pulumi.get(self, "auto_enable")

    @property
    @pulumi.getter(name="autoEnableStandards")
    def auto_enable_standards(self) -> pulumi.Output[Optional['OrganizationConfigurationAutoEnableStandards']]:
        """
        Whether to automatically enable Security Hub default standards in new member accounts when they join the organization.
        """
        return pulumi.get(self, "auto_enable_standards")

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> pulumi.Output[Optional['OrganizationConfigurationConfigurationType']]:
        """
        Indicates whether the organization uses local or central configuration.
        """
        return pulumi.get(self, "configuration_type")

    @property
    @pulumi.getter(name="memberAccountLimitReached")
    def member_account_limit_reached(self) -> pulumi.Output[bool]:
        """
        Whether the maximum number of allowed member accounts are already associated with the Security Hub administrator account.
        """
        return pulumi.get(self, "member_account_limit_reached")

    @property
    @pulumi.getter(name="organizationConfigurationIdentifier")
    def organization_configuration_identifier(self) -> pulumi.Output[str]:
        """
        The identifier of the OrganizationConfiguration being created and assigned as the unique identifier.
        """
        return pulumi.get(self, "organization_configuration_identifier")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['OrganizationConfigurationStatus']:
        """
        Describes whether central configuration could be enabled as the ConfigurationType for the organization.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> pulumi.Output[str]:
        """
        Provides an explanation if the value of Status is equal to FAILED when ConfigurationType is equal to CENTRAL.
        """
        return pulumi.get(self, "status_message")

