# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'GetOrganizationConfigurationResult',
    'AwaitableGetOrganizationConfigurationResult',
    'get_organization_configuration',
    'get_organization_configuration_output',
]

@pulumi.output_type
class GetOrganizationConfigurationResult:
    def __init__(__self__, auto_enable=None, auto_enable_standards=None, configuration_type=None, member_account_limit_reached=None, organization_configuration_identifier=None, status=None, status_message=None):
        if auto_enable and not isinstance(auto_enable, bool):
            raise TypeError("Expected argument 'auto_enable' to be a bool")
        pulumi.set(__self__, "auto_enable", auto_enable)
        if auto_enable_standards and not isinstance(auto_enable_standards, str):
            raise TypeError("Expected argument 'auto_enable_standards' to be a str")
        pulumi.set(__self__, "auto_enable_standards", auto_enable_standards)
        if configuration_type and not isinstance(configuration_type, str):
            raise TypeError("Expected argument 'configuration_type' to be a str")
        pulumi.set(__self__, "configuration_type", configuration_type)
        if member_account_limit_reached and not isinstance(member_account_limit_reached, bool):
            raise TypeError("Expected argument 'member_account_limit_reached' to be a bool")
        pulumi.set(__self__, "member_account_limit_reached", member_account_limit_reached)
        if organization_configuration_identifier and not isinstance(organization_configuration_identifier, str):
            raise TypeError("Expected argument 'organization_configuration_identifier' to be a str")
        pulumi.set(__self__, "organization_configuration_identifier", organization_configuration_identifier)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if status_message and not isinstance(status_message, str):
            raise TypeError("Expected argument 'status_message' to be a str")
        pulumi.set(__self__, "status_message", status_message)

    @property
    @pulumi.getter(name="autoEnable")
    def auto_enable(self) -> Optional[bool]:
        """
        Whether to automatically enable Security Hub in new member accounts when they join the organization.
        """
        return pulumi.get(self, "auto_enable")

    @property
    @pulumi.getter(name="autoEnableStandards")
    def auto_enable_standards(self) -> Optional['OrganizationConfigurationAutoEnableStandards']:
        """
        Whether to automatically enable Security Hub default standards in new member accounts when they join the organization.
        """
        return pulumi.get(self, "auto_enable_standards")

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> Optional['OrganizationConfigurationConfigurationType']:
        """
        Indicates whether the organization uses local or central configuration.
        """
        return pulumi.get(self, "configuration_type")

    @property
    @pulumi.getter(name="memberAccountLimitReached")
    def member_account_limit_reached(self) -> Optional[bool]:
        """
        Whether the maximum number of allowed member accounts are already associated with the Security Hub administrator account.
        """
        return pulumi.get(self, "member_account_limit_reached")

    @property
    @pulumi.getter(name="organizationConfigurationIdentifier")
    def organization_configuration_identifier(self) -> Optional[str]:
        """
        The identifier of the OrganizationConfiguration being created and assigned as the unique identifier.
        """
        return pulumi.get(self, "organization_configuration_identifier")

    @property
    @pulumi.getter
    def status(self) -> Optional['OrganizationConfigurationStatus']:
        """
        Describes whether central configuration could be enabled as the ConfigurationType for the organization.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> Optional[str]:
        """
        Provides an explanation if the value of Status is equal to FAILED when ConfigurationType is equal to CENTRAL.
        """
        return pulumi.get(self, "status_message")


class AwaitableGetOrganizationConfigurationResult(GetOrganizationConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrganizationConfigurationResult(
            auto_enable=self.auto_enable,
            auto_enable_standards=self.auto_enable_standards,
            configuration_type=self.configuration_type,
            member_account_limit_reached=self.member_account_limit_reached,
            organization_configuration_identifier=self.organization_configuration_identifier,
            status=self.status,
            status_message=self.status_message)


def get_organization_configuration(organization_configuration_identifier: Optional[str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrganizationConfigurationResult:
    """
    The AWS::SecurityHub::OrganizationConfiguration resource represents the configuration of your organization in Security Hub. Only the Security Hub administrator account can create Organization Configuration resource in each region and can opt-in to Central Configuration only in the aggregation region of FindingAggregator.


    :param str organization_configuration_identifier: The identifier of the OrganizationConfiguration being created and assigned as the unique identifier.
    """
    __args__ = dict()
    __args__['organizationConfigurationIdentifier'] = organization_configuration_identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:securityhub:getOrganizationConfiguration', __args__, opts=opts, typ=GetOrganizationConfigurationResult).value

    return AwaitableGetOrganizationConfigurationResult(
        auto_enable=pulumi.get(__ret__, 'auto_enable'),
        auto_enable_standards=pulumi.get(__ret__, 'auto_enable_standards'),
        configuration_type=pulumi.get(__ret__, 'configuration_type'),
        member_account_limit_reached=pulumi.get(__ret__, 'member_account_limit_reached'),
        organization_configuration_identifier=pulumi.get(__ret__, 'organization_configuration_identifier'),
        status=pulumi.get(__ret__, 'status'),
        status_message=pulumi.get(__ret__, 'status_message'))
def get_organization_configuration_output(organization_configuration_identifier: Optional[pulumi.Input[str]] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOrganizationConfigurationResult]:
    """
    The AWS::SecurityHub::OrganizationConfiguration resource represents the configuration of your organization in Security Hub. Only the Security Hub administrator account can create Organization Configuration resource in each region and can opt-in to Central Configuration only in the aggregation region of FindingAggregator.


    :param str organization_configuration_identifier: The identifier of the OrganizationConfiguration being created and assigned as the unique identifier.
    """
    __args__ = dict()
    __args__['organizationConfigurationIdentifier'] = organization_configuration_identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:securityhub:getOrganizationConfiguration', __args__, opts=opts, typ=GetOrganizationConfigurationResult)
    return __ret__.apply(lambda __response__: GetOrganizationConfigurationResult(
        auto_enable=pulumi.get(__response__, 'auto_enable'),
        auto_enable_standards=pulumi.get(__response__, 'auto_enable_standards'),
        configuration_type=pulumi.get(__response__, 'configuration_type'),
        member_account_limit_reached=pulumi.get(__response__, 'member_account_limit_reached'),
        organization_configuration_identifier=pulumi.get(__response__, 'organization_configuration_identifier'),
        status=pulumi.get(__response__, 'status'),
        status_message=pulumi.get(__response__, 'status_message')))
