# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetHubResult',
    'AwaitableGetHubResult',
    'get_hub',
    'get_hub_output',
]

@pulumi.output_type
class GetHubResult:
    def __init__(__self__, arn=None, auto_enable_controls=None, control_finding_generator=None, subscribed_at=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if auto_enable_controls and not isinstance(auto_enable_controls, bool):
            raise TypeError("Expected argument 'auto_enable_controls' to be a bool")
        pulumi.set(__self__, "auto_enable_controls", auto_enable_controls)
        if control_finding_generator and not isinstance(control_finding_generator, str):
            raise TypeError("Expected argument 'control_finding_generator' to be a str")
        pulumi.set(__self__, "control_finding_generator", control_finding_generator)
        if subscribed_at and not isinstance(subscribed_at, str):
            raise TypeError("Expected argument 'subscribed_at' to be a str")
        pulumi.set(__self__, "subscribed_at", subscribed_at)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        An ARN is automatically created for the customer.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoEnableControls")
    def auto_enable_controls(self) -> Optional[bool]:
        """
        Whether to automatically enable new controls when they are added to standards that are enabled
        """
        return pulumi.get(self, "auto_enable_controls")

    @property
    @pulumi.getter(name="controlFindingGenerator")
    def control_finding_generator(self) -> Optional[str]:
        """
        This field, used when enabling Security Hub, specifies whether the calling account has consolidated control findings turned on. If the value for this field is set to SECURITY_CONTROL, Security Hub generates a single finding for a control check even when the check applies to multiple enabled standards.  If the value for this field is set to STANDARD_CONTROL, Security Hub generates separate findings for a control check when the check applies to multiple enabled standards.
        """
        return pulumi.get(self, "control_finding_generator")

    @property
    @pulumi.getter(name="subscribedAt")
    def subscribed_at(self) -> Optional[str]:
        """
        The date and time when Security Hub was enabled in the account.
        """
        return pulumi.get(self, "subscribed_at")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        An array of key-value pairs to apply to this resource.

        For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
        """
        return pulumi.get(self, "tags")


class AwaitableGetHubResult(GetHubResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHubResult(
            arn=self.arn,
            auto_enable_controls=self.auto_enable_controls,
            control_finding_generator=self.control_finding_generator,
            subscribed_at=self.subscribed_at,
            tags=self.tags)


def get_hub(arn: Optional[str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHubResult:
    """
    The AWS::SecurityHub::Hub resource represents the implementation of the AWS Security Hub service in your account. One hub resource is created for each Region in which you enable Security Hub.


    :param str arn: An ARN is automatically created for the customer.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:securityhub:getHub', __args__, opts=opts, typ=GetHubResult).value

    return AwaitableGetHubResult(
        arn=pulumi.get(__ret__, 'arn'),
        auto_enable_controls=pulumi.get(__ret__, 'auto_enable_controls'),
        control_finding_generator=pulumi.get(__ret__, 'control_finding_generator'),
        subscribed_at=pulumi.get(__ret__, 'subscribed_at'),
        tags=pulumi.get(__ret__, 'tags'))
def get_hub_output(arn: Optional[pulumi.Input[str]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetHubResult]:
    """
    The AWS::SecurityHub::Hub resource represents the implementation of the AWS Security Hub service in your account. One hub resource is created for each Region in which you enable Security Hub.


    :param str arn: An ARN is automatically created for the customer.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:securityhub:getHub', __args__, opts=opts, typ=GetHubResult)
    return __ret__.apply(lambda __response__: GetHubResult(
        arn=pulumi.get(__response__, 'arn'),
        auto_enable_controls=pulumi.get(__response__, 'auto_enable_controls'),
        control_finding_generator=pulumi.get(__response__, 'control_finding_generator'),
        subscribed_at=pulumi.get(__response__, 'subscribed_at'),
        tags=pulumi.get(__response__, 'tags')))
