# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'GetFindingAggregatorResult',
    'AwaitableGetFindingAggregatorResult',
    'get_finding_aggregator',
    'get_finding_aggregator_output',
]

@pulumi.output_type
class GetFindingAggregatorResult:
    def __init__(__self__, finding_aggregation_region=None, finding_aggregator_arn=None, region_linking_mode=None, regions=None):
        if finding_aggregation_region and not isinstance(finding_aggregation_region, str):
            raise TypeError("Expected argument 'finding_aggregation_region' to be a str")
        pulumi.set(__self__, "finding_aggregation_region", finding_aggregation_region)
        if finding_aggregator_arn and not isinstance(finding_aggregator_arn, str):
            raise TypeError("Expected argument 'finding_aggregator_arn' to be a str")
        pulumi.set(__self__, "finding_aggregator_arn", finding_aggregator_arn)
        if region_linking_mode and not isinstance(region_linking_mode, str):
            raise TypeError("Expected argument 'region_linking_mode' to be a str")
        pulumi.set(__self__, "region_linking_mode", region_linking_mode)
        if regions and not isinstance(regions, list):
            raise TypeError("Expected argument 'regions' to be a list")
        pulumi.set(__self__, "regions", regions)

    @property
    @pulumi.getter(name="findingAggregationRegion")
    def finding_aggregation_region(self) -> Optional[str]:
        """
        The home Region. Findings generated in linked Regions are replicated and sent to the home Region.
        """
        return pulumi.get(self, "finding_aggregation_region")

    @property
    @pulumi.getter(name="findingAggregatorArn")
    def finding_aggregator_arn(self) -> Optional[str]:
        """
        The ARN of the finding aggregator. You use the finding aggregator ARN to retrieve details for, update, and delete the finding aggregator.
        """
        return pulumi.get(self, "finding_aggregator_arn")

    @property
    @pulumi.getter(name="regionLinkingMode")
    def region_linking_mode(self) -> Optional['FindingAggregatorRegionLinkingMode']:
        """
        Indicates whether to aggregate findings from all of the available Regions in the current partition. Also determines whether to automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.
         The selected option also determines how to use the Regions provided in the Regions list.
         The options are as follows:
          +   ``ALL_REGIONS`` - Aggregates findings from all of the Regions where Security Hub is enabled. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them. 
          +   ``ALL_REGIONS_EXCEPT_SPECIFIED`` - Aggregates findings from all of the Regions where Security Hub is enabled, except for the Regions listed in the ``Regions`` parameter. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them. 
          +   ``SPECIFIED_REGIONS`` - Aggregates findings only from the Regions listed in the ``Regions`` parameter. Security Hub does not automatically aggregate findings from new Regions. 
          +   ``NO_REGIONS`` - Aggregates no data because no Regions are selected as linked Regions.
        """
        return pulumi.get(self, "region_linking_mode")

    @property
    @pulumi.getter
    def regions(self) -> Optional[Sequence[str]]:
        """
        If ``RegionLinkingMode`` is ``ALL_REGIONS_EXCEPT_SPECIFIED``, then this is a space-separated list of Regions that do not aggregate findings to the aggregation Region.
         If ``RegionLinkingMode`` is ``SPECIFIED_REGIONS``, then this is a space-separated list of Regions that do aggregate findings to the aggregation Region. 
         An ``InvalidInputException`` error results if you populate this field while ``RegionLinkingMode`` is ``NO_REGIONS``.
        """
        return pulumi.get(self, "regions")


class AwaitableGetFindingAggregatorResult(GetFindingAggregatorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFindingAggregatorResult(
            finding_aggregation_region=self.finding_aggregation_region,
            finding_aggregator_arn=self.finding_aggregator_arn,
            region_linking_mode=self.region_linking_mode,
            regions=self.regions)


def get_finding_aggregator(finding_aggregator_arn: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFindingAggregatorResult:
    """
    The ``AWS::SecurityHub::FindingAggregator`` resource enables cross-Region aggregation. When cross-Region aggregation is enabled, you can aggregate findings, finding updates, insights, control compliance statuses, and security scores from one or more linked Regions to a single aggregation Region. You can then view and manage all of this data from the aggregation Region. For more details about cross-Region aggregation, see [Cross-Region aggregation](https://docs.aws.amazon.com/securityhub/latest/userguide/finding-aggregation.html) in the *User Guide*
     This resource must be created in the Region that you want to designate as your aggregation Region.
     Cross-Region aggregation is also a prerequisite for using [central configuration](https://docs.aws.amazon.com/securityhub/latest/userguide/central-configuration-intro.html) in ASH.


    :param str finding_aggregator_arn: The ARN of the finding aggregator. You use the finding aggregator ARN to retrieve details for, update, and delete the finding aggregator.
    """
    __args__ = dict()
    __args__['findingAggregatorArn'] = finding_aggregator_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:securityhub:getFindingAggregator', __args__, opts=opts, typ=GetFindingAggregatorResult).value

    return AwaitableGetFindingAggregatorResult(
        finding_aggregation_region=pulumi.get(__ret__, 'finding_aggregation_region'),
        finding_aggregator_arn=pulumi.get(__ret__, 'finding_aggregator_arn'),
        region_linking_mode=pulumi.get(__ret__, 'region_linking_mode'),
        regions=pulumi.get(__ret__, 'regions'))
def get_finding_aggregator_output(finding_aggregator_arn: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFindingAggregatorResult]:
    """
    The ``AWS::SecurityHub::FindingAggregator`` resource enables cross-Region aggregation. When cross-Region aggregation is enabled, you can aggregate findings, finding updates, insights, control compliance statuses, and security scores from one or more linked Regions to a single aggregation Region. You can then view and manage all of this data from the aggregation Region. For more details about cross-Region aggregation, see [Cross-Region aggregation](https://docs.aws.amazon.com/securityhub/latest/userguide/finding-aggregation.html) in the *User Guide*
     This resource must be created in the Region that you want to designate as your aggregation Region.
     Cross-Region aggregation is also a prerequisite for using [central configuration](https://docs.aws.amazon.com/securityhub/latest/userguide/central-configuration-intro.html) in ASH.


    :param str finding_aggregator_arn: The ARN of the finding aggregator. You use the finding aggregator ARN to retrieve details for, update, and delete the finding aggregator.
    """
    __args__ = dict()
    __args__['findingAggregatorArn'] = finding_aggregator_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:securityhub:getFindingAggregator', __args__, opts=opts, typ=GetFindingAggregatorResult)
    return __ret__.apply(lambda __response__: GetFindingAggregatorResult(
        finding_aggregation_region=pulumi.get(__response__, 'finding_aggregation_region'),
        finding_aggregator_arn=pulumi.get(__response__, 'finding_aggregator_arn'),
        region_linking_mode=pulumi.get(__response__, 'region_linking_mode'),
        regions=pulumi.get(__response__, 'regions')))
