# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'GetDelegatedAdminResult',
    'AwaitableGetDelegatedAdminResult',
    'get_delegated_admin',
    'get_delegated_admin_output',
]

@pulumi.output_type
class GetDelegatedAdminResult:
    def __init__(__self__, delegated_admin_identifier=None, status=None):
        if delegated_admin_identifier and not isinstance(delegated_admin_identifier, str):
            raise TypeError("Expected argument 'delegated_admin_identifier' to be a str")
        pulumi.set(__self__, "delegated_admin_identifier", delegated_admin_identifier)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="delegatedAdminIdentifier")
    def delegated_admin_identifier(self) -> Optional[str]:
        """
        The ID of the delegated Security Hub administrator account, in the format of `accountID/Region` .
        """
        return pulumi.get(self, "delegated_admin_identifier")

    @property
    @pulumi.getter
    def status(self) -> Optional['DelegatedAdminStatus']:
        """
        Whether the delegated Security Hub administrator is set for the organization.
        """
        return pulumi.get(self, "status")


class AwaitableGetDelegatedAdminResult(GetDelegatedAdminResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDelegatedAdminResult(
            delegated_admin_identifier=self.delegated_admin_identifier,
            status=self.status)


def get_delegated_admin(delegated_admin_identifier: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDelegatedAdminResult:
    """
    The ``AWS::SecurityHub::DelegatedAdmin`` resource designates the delegated ASHlong administrator account for an organization. You must enable the integration between ASH and AOlong before you can designate a delegated ASH administrator. Only the management account for an organization can designate the delegated ASH administrator account. For more information, see [Designating the delegated administrator](https://docs.aws.amazon.com/securityhub/latest/userguide/designate-orgs-admin-account.html#designate-admin-instructions) in the *User Guide*.
     To change the delegated administrator account, remove the current delegated administrator account, and then designate the new account.
     To designate multiple delegated administrators in different organizations and AWS-Regions, we recommend using [mappings](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/mappings-section-structure.html).
     Tags aren't supported for this resource.


    :param str delegated_admin_identifier: The ID of the delegated Security Hub administrator account, in the format of `accountID/Region` .
    """
    __args__ = dict()
    __args__['delegatedAdminIdentifier'] = delegated_admin_identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:securityhub:getDelegatedAdmin', __args__, opts=opts, typ=GetDelegatedAdminResult).value

    return AwaitableGetDelegatedAdminResult(
        delegated_admin_identifier=pulumi.get(__ret__, 'delegated_admin_identifier'),
        status=pulumi.get(__ret__, 'status'))
def get_delegated_admin_output(delegated_admin_identifier: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDelegatedAdminResult]:
    """
    The ``AWS::SecurityHub::DelegatedAdmin`` resource designates the delegated ASHlong administrator account for an organization. You must enable the integration between ASH and AOlong before you can designate a delegated ASH administrator. Only the management account for an organization can designate the delegated ASH administrator account. For more information, see [Designating the delegated administrator](https://docs.aws.amazon.com/securityhub/latest/userguide/designate-orgs-admin-account.html#designate-admin-instructions) in the *User Guide*.
     To change the delegated administrator account, remove the current delegated administrator account, and then designate the new account.
     To designate multiple delegated administrators in different organizations and AWS-Regions, we recommend using [mappings](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/mappings-section-structure.html).
     Tags aren't supported for this resource.


    :param str delegated_admin_identifier: The ID of the delegated Security Hub administrator account, in the format of `accountID/Region` .
    """
    __args__ = dict()
    __args__['delegatedAdminIdentifier'] = delegated_admin_identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:securityhub:getDelegatedAdmin', __args__, opts=opts, typ=GetDelegatedAdminResult)
    return __ret__.apply(lambda __response__: GetDelegatedAdminResult(
        delegated_admin_identifier=pulumi.get(__response__, 'delegated_admin_identifier'),
        status=pulumi.get(__response__, 'status')))
