# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = ['DelegatedAdminArgs', 'DelegatedAdmin']

@pulumi.input_type
class DelegatedAdminArgs:
    def __init__(__self__, *,
                 admin_account_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a DelegatedAdmin resource.
        :param pulumi.Input[str] admin_account_id: The AWS-account identifier of the account to designate as the Security Hub administrator account.
        """
        pulumi.set(__self__, "admin_account_id", admin_account_id)

    @property
    @pulumi.getter(name="adminAccountId")
    def admin_account_id(self) -> pulumi.Input[str]:
        """
        The AWS-account identifier of the account to designate as the Security Hub administrator account.
        """
        return pulumi.get(self, "admin_account_id")

    @admin_account_id.setter
    def admin_account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "admin_account_id", value)


class DelegatedAdmin(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_account_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The ``AWS::SecurityHub::DelegatedAdmin`` resource designates the delegated ASHlong administrator account for an organization. You must enable the integration between ASH and AOlong before you can designate a delegated ASH administrator. Only the management account for an organization can designate the delegated ASH administrator account. For more information, see [Designating the delegated administrator](https://docs.aws.amazon.com/securityhub/latest/userguide/designate-orgs-admin-account.html#designate-admin-instructions) in the *User Guide*.
         To change the delegated administrator account, remove the current delegated administrator account, and then designate the new account.
         To designate multiple delegated administrators in different organizations and AWS-Regions, we recommend using [mappings](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/mappings-section-structure.html).
         Tags aren't supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] admin_account_id: The AWS-account identifier of the account to designate as the Security Hub administrator account.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DelegatedAdminArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The ``AWS::SecurityHub::DelegatedAdmin`` resource designates the delegated ASHlong administrator account for an organization. You must enable the integration between ASH and AOlong before you can designate a delegated ASH administrator. Only the management account for an organization can designate the delegated ASH administrator account. For more information, see [Designating the delegated administrator](https://docs.aws.amazon.com/securityhub/latest/userguide/designate-orgs-admin-account.html#designate-admin-instructions) in the *User Guide*.
         To change the delegated administrator account, remove the current delegated administrator account, and then designate the new account.
         To designate multiple delegated administrators in different organizations and AWS-Regions, we recommend using [mappings](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/mappings-section-structure.html).
         Tags aren't supported for this resource.

        :param str resource_name: The name of the resource.
        :param DelegatedAdminArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DelegatedAdminArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_account_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DelegatedAdminArgs.__new__(DelegatedAdminArgs)

            if admin_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'admin_account_id'")
            __props__.__dict__["admin_account_id"] = admin_account_id
            __props__.__dict__["delegated_admin_identifier"] = None
            __props__.__dict__["status"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["adminAccountId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(DelegatedAdmin, __self__).__init__(
            'aws-native:securityhub:DelegatedAdmin',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DelegatedAdmin':
        """
        Get an existing DelegatedAdmin resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DelegatedAdminArgs.__new__(DelegatedAdminArgs)

        __props__.__dict__["admin_account_id"] = None
        __props__.__dict__["delegated_admin_identifier"] = None
        __props__.__dict__["status"] = None
        return DelegatedAdmin(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminAccountId")
    def admin_account_id(self) -> pulumi.Output[str]:
        """
        The AWS-account identifier of the account to designate as the Security Hub administrator account.
        """
        return pulumi.get(self, "admin_account_id")

    @property
    @pulumi.getter(name="delegatedAdminIdentifier")
    def delegated_admin_identifier(self) -> pulumi.Output[str]:
        """
        The ID of the delegated Security Hub administrator account, in the format of `accountID/Region` .
        """
        return pulumi.get(self, "delegated_admin_identifier")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['DelegatedAdminStatus']:
        """
        Whether the delegated Security Hub administrator is set for the organization.
        """
        return pulumi.get(self, "status")

