# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'SecretGenerateSecretString',
    'SecretReplicaRegion',
]

@pulumi.output_type
class SecretGenerateSecretString(dict):
    """
    Generates a random password. We recommend that you specify the maximum length and include every character type that the system you are generating a password for can support.
      *Required permissions:* ``secretsmanager:GetRandomPassword``. For more information, see [IAM policy actions for Secrets Manager](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecretsmanager.html#awssecretsmanager-actions-as-permissions) and [Authentication and access control in Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludeCharacters":
            suggest = "exclude_characters"
        elif key == "excludeLowercase":
            suggest = "exclude_lowercase"
        elif key == "excludeNumbers":
            suggest = "exclude_numbers"
        elif key == "excludePunctuation":
            suggest = "exclude_punctuation"
        elif key == "excludeUppercase":
            suggest = "exclude_uppercase"
        elif key == "generateStringKey":
            suggest = "generate_string_key"
        elif key == "includeSpace":
            suggest = "include_space"
        elif key == "passwordLength":
            suggest = "password_length"
        elif key == "requireEachIncludedType":
            suggest = "require_each_included_type"
        elif key == "secretStringTemplate":
            suggest = "secret_string_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretGenerateSecretString. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretGenerateSecretString.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretGenerateSecretString.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exclude_characters: Optional[str] = None,
                 exclude_lowercase: Optional[bool] = None,
                 exclude_numbers: Optional[bool] = None,
                 exclude_punctuation: Optional[bool] = None,
                 exclude_uppercase: Optional[bool] = None,
                 generate_string_key: Optional[str] = None,
                 include_space: Optional[bool] = None,
                 password_length: Optional[int] = None,
                 require_each_included_type: Optional[bool] = None,
                 secret_string_template: Optional[str] = None):
        """
        Generates a random password. We recommend that you specify the maximum length and include every character type that the system you are generating a password for can support.
          *Required permissions:* ``secretsmanager:GetRandomPassword``. For more information, see [IAM policy actions for Secrets Manager](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecretsmanager.html#awssecretsmanager-actions-as-permissions) and [Authentication and access control in Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html).
        :param str exclude_characters: A string of the characters that you don't want in the password.
        :param bool exclude_lowercase: Specifies whether to exclude lowercase letters from the password. If you don't include this switch, the password can contain lowercase letters.
        :param bool exclude_numbers: Specifies whether to exclude numbers from the password. If you don't include this switch, the password can contain numbers.
        :param bool exclude_punctuation: Specifies whether to exclude the following punctuation characters from the password: ``! " # $ % & ' ( ) * + , - . / : ; < = > ? @ [ \\ ] ^ _ ` { | } ~``. If you don't include this switch, the password can contain punctuation.
        :param bool exclude_uppercase: Specifies whether to exclude uppercase letters from the password. If you don't include this switch, the password can contain uppercase letters.
        :param str generate_string_key: The JSON key name for the key/value pair, where the value is the generated password. This pair is added to the JSON structure specified by the ``SecretStringTemplate`` parameter. If you specify this parameter, then you must also specify ``SecretStringTemplate``.
        :param bool include_space: Specifies whether to include the space character. If you include this switch, the password can contain space characters.
        :param int password_length: The length of the password. If you don't include this parameter, the default length is 32 characters.
        :param bool require_each_included_type: Specifies whether to include at least one upper and lowercase letter, one number, and one punctuation. If you don't include this switch, the password contains at least one of every character type.
        :param str secret_string_template: A template that the generated string must match. When you make a change to this property, a new secret version is created.
        """
        if exclude_characters is not None:
            pulumi.set(__self__, "exclude_characters", exclude_characters)
        if exclude_lowercase is not None:
            pulumi.set(__self__, "exclude_lowercase", exclude_lowercase)
        if exclude_numbers is not None:
            pulumi.set(__self__, "exclude_numbers", exclude_numbers)
        if exclude_punctuation is not None:
            pulumi.set(__self__, "exclude_punctuation", exclude_punctuation)
        if exclude_uppercase is not None:
            pulumi.set(__self__, "exclude_uppercase", exclude_uppercase)
        if generate_string_key is not None:
            pulumi.set(__self__, "generate_string_key", generate_string_key)
        if include_space is not None:
            pulumi.set(__self__, "include_space", include_space)
        if password_length is not None:
            pulumi.set(__self__, "password_length", password_length)
        if require_each_included_type is not None:
            pulumi.set(__self__, "require_each_included_type", require_each_included_type)
        if secret_string_template is not None:
            pulumi.set(__self__, "secret_string_template", secret_string_template)

    @property
    @pulumi.getter(name="excludeCharacters")
    def exclude_characters(self) -> Optional[str]:
        """
        A string of the characters that you don't want in the password.
        """
        return pulumi.get(self, "exclude_characters")

    @property
    @pulumi.getter(name="excludeLowercase")
    def exclude_lowercase(self) -> Optional[bool]:
        """
        Specifies whether to exclude lowercase letters from the password. If you don't include this switch, the password can contain lowercase letters.
        """
        return pulumi.get(self, "exclude_lowercase")

    @property
    @pulumi.getter(name="excludeNumbers")
    def exclude_numbers(self) -> Optional[bool]:
        """
        Specifies whether to exclude numbers from the password. If you don't include this switch, the password can contain numbers.
        """
        return pulumi.get(self, "exclude_numbers")

    @property
    @pulumi.getter(name="excludePunctuation")
    def exclude_punctuation(self) -> Optional[bool]:
        """
        Specifies whether to exclude the following punctuation characters from the password: ``! " # $ % & ' ( ) * + , - . / : ; < = > ? @ [ \\ ] ^ _ ` { | } ~``. If you don't include this switch, the password can contain punctuation.
        """
        return pulumi.get(self, "exclude_punctuation")

    @property
    @pulumi.getter(name="excludeUppercase")
    def exclude_uppercase(self) -> Optional[bool]:
        """
        Specifies whether to exclude uppercase letters from the password. If you don't include this switch, the password can contain uppercase letters.
        """
        return pulumi.get(self, "exclude_uppercase")

    @property
    @pulumi.getter(name="generateStringKey")
    def generate_string_key(self) -> Optional[str]:
        """
        The JSON key name for the key/value pair, where the value is the generated password. This pair is added to the JSON structure specified by the ``SecretStringTemplate`` parameter. If you specify this parameter, then you must also specify ``SecretStringTemplate``.
        """
        return pulumi.get(self, "generate_string_key")

    @property
    @pulumi.getter(name="includeSpace")
    def include_space(self) -> Optional[bool]:
        """
        Specifies whether to include the space character. If you include this switch, the password can contain space characters.
        """
        return pulumi.get(self, "include_space")

    @property
    @pulumi.getter(name="passwordLength")
    def password_length(self) -> Optional[int]:
        """
        The length of the password. If you don't include this parameter, the default length is 32 characters.
        """
        return pulumi.get(self, "password_length")

    @property
    @pulumi.getter(name="requireEachIncludedType")
    def require_each_included_type(self) -> Optional[bool]:
        """
        Specifies whether to include at least one upper and lowercase letter, one number, and one punctuation. If you don't include this switch, the password contains at least one of every character type.
        """
        return pulumi.get(self, "require_each_included_type")

    @property
    @pulumi.getter(name="secretStringTemplate")
    def secret_string_template(self) -> Optional[str]:
        """
        A template that the generated string must match. When you make a change to this property, a new secret version is created.
        """
        return pulumi.get(self, "secret_string_template")


@pulumi.output_type
class SecretReplicaRegion(dict):
    """
    Specifies a ``Region`` and the ``KmsKeyId`` for a replica secret.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretReplicaRegion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretReplicaRegion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretReplicaRegion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region: str,
                 kms_key_id: Optional[str] = None):
        """
        Specifies a ``Region`` and the ``KmsKeyId`` for a replica secret.
        :param str region: A string that represents a ``Region``, for example "us-east-1".
        :param str kms_key_id: The ARN, key ID, or alias of the KMS key to encrypt the secret. If you don't include this field, Secrets Manager uses ``aws/secretsmanager``.
        """
        pulumi.set(__self__, "region", region)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        A string that represents a ``Region``, for example "us-east-1".
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The ARN, key ID, or alias of the KMS key to encrypt the secret. If you don't include this field, Secrets Manager uses ``aws/secretsmanager``.
        """
        return pulumi.get(self, "kms_key_id")


