# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetResourcePolicyResult',
    'AwaitableGetResourcePolicyResult',
    'get_resource_policy',
    'get_resource_policy_output',
]

@pulumi.output_type
class GetResourcePolicyResult:
    def __init__(__self__, id=None, resource_policy=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if resource_policy and not isinstance(resource_policy, dict):
            raise TypeError("Expected argument 'resource_policy' to be a dict")
        pulumi.set(__self__, "resource_policy", resource_policy)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The Arn of the secret.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resourcePolicy")
    def resource_policy(self) -> Optional[Any]:
        """
        A JSON-formatted string for an AWS resource-based policy.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SecretsManager::ResourcePolicy` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "resource_policy")


class AwaitableGetResourcePolicyResult(GetResourcePolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourcePolicyResult(
            id=self.id,
            resource_policy=self.resource_policy)


def get_resource_policy(id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResourcePolicyResult:
    """
    Resource Type definition for AWS::SecretsManager::ResourcePolicy


    :param str id: The Arn of the secret.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:secretsmanager:getResourcePolicy', __args__, opts=opts, typ=GetResourcePolicyResult).value

    return AwaitableGetResourcePolicyResult(
        id=pulumi.get(__ret__, 'id'),
        resource_policy=pulumi.get(__ret__, 'resource_policy'))
def get_resource_policy_output(id: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetResourcePolicyResult]:
    """
    Resource Type definition for AWS::SecretsManager::ResourcePolicy


    :param str id: The Arn of the secret.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:secretsmanager:getResourcePolicy', __args__, opts=opts, typ=GetResourcePolicyResult)
    return __ret__.apply(lambda __response__: GetResourcePolicyResult(
        id=pulumi.get(__response__, 'id'),
        resource_policy=pulumi.get(__response__, 'resource_policy')))
