# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ScheduleAwsVpcConfiguration',
    'ScheduleCapacityProviderStrategyItem',
    'ScheduleDeadLetterConfig',
    'ScheduleEcsParameters',
    'ScheduleEventBridgeParameters',
    'ScheduleFlexibleTimeWindow',
    'ScheduleKinesisParameters',
    'ScheduleNetworkConfiguration',
    'SchedulePlacementConstraint',
    'SchedulePlacementStrategy',
    'ScheduleRetryPolicy',
    'ScheduleSageMakerPipelineParameter',
    'ScheduleSageMakerPipelineParameters',
    'ScheduleSqsParameters',
    'ScheduleTarget',
]

@pulumi.output_type
class ScheduleAwsVpcConfiguration(dict):
    """
    This structure specifies the VPC subnets and security groups for the task, and whether a public IP address is to be used. This structure is relevant only for ECS tasks that use the awsvpc network mode.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assignPublicIp":
            suggest = "assign_public_ip"
        elif key == "securityGroups":
            suggest = "security_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleAwsVpcConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleAwsVpcConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleAwsVpcConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnets: Sequence[str],
                 assign_public_ip: Optional['ScheduleAssignPublicIp'] = None,
                 security_groups: Optional[Sequence[str]] = None):
        """
        This structure specifies the VPC subnets and security groups for the task, and whether a public IP address is to be used. This structure is relevant only for ECS tasks that use the awsvpc network mode.
        :param Sequence[str] subnets: Specifies the subnets associated with the task. These subnets must all be in the same VPC. You can specify as many as 16 subnets.
        :param 'ScheduleAssignPublicIp' assign_public_ip: Specifies whether the task's elastic network interface receives a public IP address. You can specify `ENABLED` only when `LaunchType` in `EcsParameters` is set to `FARGATE` .
        :param Sequence[str] security_groups: Specifies the security groups associated with the task. These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.
        """
        pulumi.set(__self__, "subnets", subnets)
        if assign_public_ip is not None:
            pulumi.set(__self__, "assign_public_ip", assign_public_ip)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[str]:
        """
        Specifies the subnets associated with the task. These subnets must all be in the same VPC. You can specify as many as 16 subnets.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter(name="assignPublicIp")
    def assign_public_ip(self) -> Optional['ScheduleAssignPublicIp']:
        """
        Specifies whether the task's elastic network interface receives a public IP address. You can specify `ENABLED` only when `LaunchType` in `EcsParameters` is set to `FARGATE` .
        """
        return pulumi.get(self, "assign_public_ip")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[Sequence[str]]:
        """
        Specifies the security groups associated with the task. These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.
        """
        return pulumi.get(self, "security_groups")


@pulumi.output_type
class ScheduleCapacityProviderStrategyItem(dict):
    """
    The details of a capacity provider strategy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityProvider":
            suggest = "capacity_provider"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleCapacityProviderStrategyItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleCapacityProviderStrategyItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleCapacityProviderStrategyItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity_provider: str,
                 base: Optional[float] = None,
                 weight: Optional[float] = None):
        """
        The details of a capacity provider strategy.
        :param str capacity_provider: The short name of the capacity provider.
        :param float base: The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. If no value is specified, the default value of 0 is used.
        :param float weight: The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied.
        """
        pulumi.set(__self__, "capacity_provider", capacity_provider)
        if base is not None:
            pulumi.set(__self__, "base", base)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="capacityProvider")
    def capacity_provider(self) -> str:
        """
        The short name of the capacity provider.
        """
        return pulumi.get(self, "capacity_provider")

    @property
    @pulumi.getter
    def base(self) -> Optional[float]:
        """
        The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. If no value is specified, the default value of 0 is used.
        """
        return pulumi.get(self, "base")

    @property
    @pulumi.getter
    def weight(self) -> Optional[float]:
        """
        The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class ScheduleDeadLetterConfig(dict):
    """
    A DeadLetterConfig object that contains information about a dead-letter queue configuration.
    """
    def __init__(__self__, *,
                 arn: Optional[str] = None):
        """
        A DeadLetterConfig object that contains information about a dead-letter queue configuration.
        :param str arn: The ARN of the SQS queue specified as the target for the dead-letter queue.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The ARN of the SQS queue specified as the target for the dead-letter queue.
        """
        return pulumi.get(self, "arn")


@pulumi.output_type
class ScheduleEcsParameters(dict):
    """
    The custom parameters to be used when the target is an Amazon ECS task.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskDefinitionArn":
            suggest = "task_definition_arn"
        elif key == "capacityProviderStrategy":
            suggest = "capacity_provider_strategy"
        elif key == "enableEcsManagedTags":
            suggest = "enable_ecs_managed_tags"
        elif key == "enableExecuteCommand":
            suggest = "enable_execute_command"
        elif key == "launchType":
            suggest = "launch_type"
        elif key == "networkConfiguration":
            suggest = "network_configuration"
        elif key == "placementConstraints":
            suggest = "placement_constraints"
        elif key == "placementStrategy":
            suggest = "placement_strategy"
        elif key == "platformVersion":
            suggest = "platform_version"
        elif key == "propagateTags":
            suggest = "propagate_tags"
        elif key == "referenceId":
            suggest = "reference_id"
        elif key == "taskCount":
            suggest = "task_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleEcsParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleEcsParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleEcsParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 task_definition_arn: str,
                 capacity_provider_strategy: Optional[Sequence['outputs.ScheduleCapacityProviderStrategyItem']] = None,
                 enable_ecs_managed_tags: Optional[bool] = None,
                 enable_execute_command: Optional[bool] = None,
                 group: Optional[str] = None,
                 launch_type: Optional['ScheduleLaunchType'] = None,
                 network_configuration: Optional['outputs.ScheduleNetworkConfiguration'] = None,
                 placement_constraints: Optional[Sequence['outputs.SchedulePlacementConstraint']] = None,
                 placement_strategy: Optional[Sequence['outputs.SchedulePlacementStrategy']] = None,
                 platform_version: Optional[str] = None,
                 propagate_tags: Optional['SchedulePropagateTags'] = None,
                 reference_id: Optional[str] = None,
                 tags: Optional[Sequence[Mapping[str, str]]] = None,
                 task_count: Optional[float] = None):
        """
        The custom parameters to be used when the target is an Amazon ECS task.
        :param str task_definition_arn: The ARN of the task definition to use if the event target is an Amazon ECS task.
        :param Sequence['ScheduleCapacityProviderStrategyItem'] capacity_provider_strategy: The capacity provider strategy to use for the task.
        :param bool enable_ecs_managed_tags: Specifies whether to enable Amazon ECS managed tags for the task. For more information, see Tagging Your Amazon ECS Resources in the Amazon Elastic Container Service Developer Guide.
        :param bool enable_execute_command: Whether or not to enable the execute command functionality for the containers in this task. If true, this enables execute command functionality on all containers in the task.
        :param str group: Specifies an ECS task group for the task. The maximum length is 255 characters.
        :param 'ScheduleLaunchType' launch_type: Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. The `FARGATE` value is supported only in the Regions where Fargate with Amazon ECS is supported. For more information, see [AWS Fargate on Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/AWS_Fargate.html) in the *Amazon ECS Developer Guide* .
        :param 'ScheduleNetworkConfiguration' network_configuration: This structure specifies the network configuration for an ECS task.
        :param Sequence['SchedulePlacementConstraint'] placement_constraints: An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime).
        :param Sequence['SchedulePlacementStrategy'] placement_strategy: The placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task.
        :param str platform_version: Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as 1.1.0.
        :param 'SchedulePropagateTags' propagate_tags: Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the Amazon ECS [`TagResource`](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_TagResource.html) API action.
        :param str reference_id: The reference ID to use for the task.
        :param Sequence[Mapping[str, str]] tags: The metadata that you apply to the task to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. To learn more, see RunTask in the Amazon ECS API Reference.
        :param float task_count: The number of tasks to create based on TaskDefinition. The default is 1.
        """
        pulumi.set(__self__, "task_definition_arn", task_definition_arn)
        if capacity_provider_strategy is not None:
            pulumi.set(__self__, "capacity_provider_strategy", capacity_provider_strategy)
        if enable_ecs_managed_tags is not None:
            pulumi.set(__self__, "enable_ecs_managed_tags", enable_ecs_managed_tags)
        if enable_execute_command is not None:
            pulumi.set(__self__, "enable_execute_command", enable_execute_command)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if launch_type is not None:
            pulumi.set(__self__, "launch_type", launch_type)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if placement_constraints is not None:
            pulumi.set(__self__, "placement_constraints", placement_constraints)
        if placement_strategy is not None:
            pulumi.set(__self__, "placement_strategy", placement_strategy)
        if platform_version is not None:
            pulumi.set(__self__, "platform_version", platform_version)
        if propagate_tags is not None:
            pulumi.set(__self__, "propagate_tags", propagate_tags)
        if reference_id is not None:
            pulumi.set(__self__, "reference_id", reference_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if task_count is not None:
            pulumi.set(__self__, "task_count", task_count)

    @property
    @pulumi.getter(name="taskDefinitionArn")
    def task_definition_arn(self) -> str:
        """
        The ARN of the task definition to use if the event target is an Amazon ECS task.
        """
        return pulumi.get(self, "task_definition_arn")

    @property
    @pulumi.getter(name="capacityProviderStrategy")
    def capacity_provider_strategy(self) -> Optional[Sequence['outputs.ScheduleCapacityProviderStrategyItem']]:
        """
        The capacity provider strategy to use for the task.
        """
        return pulumi.get(self, "capacity_provider_strategy")

    @property
    @pulumi.getter(name="enableEcsManagedTags")
    def enable_ecs_managed_tags(self) -> Optional[bool]:
        """
        Specifies whether to enable Amazon ECS managed tags for the task. For more information, see Tagging Your Amazon ECS Resources in the Amazon Elastic Container Service Developer Guide.
        """
        return pulumi.get(self, "enable_ecs_managed_tags")

    @property
    @pulumi.getter(name="enableExecuteCommand")
    def enable_execute_command(self) -> Optional[bool]:
        """
        Whether or not to enable the execute command functionality for the containers in this task. If true, this enables execute command functionality on all containers in the task.
        """
        return pulumi.get(self, "enable_execute_command")

    @property
    @pulumi.getter
    def group(self) -> Optional[str]:
        """
        Specifies an ECS task group for the task. The maximum length is 255 characters.
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter(name="launchType")
    def launch_type(self) -> Optional['ScheduleLaunchType']:
        """
        Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. The `FARGATE` value is supported only in the Regions where Fargate with Amazon ECS is supported. For more information, see [AWS Fargate on Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/AWS_Fargate.html) in the *Amazon ECS Developer Guide* .
        """
        return pulumi.get(self, "launch_type")

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional['outputs.ScheduleNetworkConfiguration']:
        """
        This structure specifies the network configuration for an ECS task.
        """
        return pulumi.get(self, "network_configuration")

    @property
    @pulumi.getter(name="placementConstraints")
    def placement_constraints(self) -> Optional[Sequence['outputs.SchedulePlacementConstraint']]:
        """
        An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime).
        """
        return pulumi.get(self, "placement_constraints")

    @property
    @pulumi.getter(name="placementStrategy")
    def placement_strategy(self) -> Optional[Sequence['outputs.SchedulePlacementStrategy']]:
        """
        The placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task.
        """
        return pulumi.get(self, "placement_strategy")

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> Optional[str]:
        """
        Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as 1.1.0.
        """
        return pulumi.get(self, "platform_version")

    @property
    @pulumi.getter(name="propagateTags")
    def propagate_tags(self) -> Optional['SchedulePropagateTags']:
        """
        Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the Amazon ECS [`TagResource`](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_TagResource.html) API action.
        """
        return pulumi.get(self, "propagate_tags")

    @property
    @pulumi.getter(name="referenceId")
    def reference_id(self) -> Optional[str]:
        """
        The reference ID to use for the task.
        """
        return pulumi.get(self, "reference_id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[Mapping[str, str]]]:
        """
        The metadata that you apply to the task to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. To learn more, see RunTask in the Amazon ECS API Reference.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="taskCount")
    def task_count(self) -> Optional[float]:
        """
        The number of tasks to create based on TaskDefinition. The default is 1.
        """
        return pulumi.get(self, "task_count")


@pulumi.output_type
class ScheduleEventBridgeParameters(dict):
    """
    EventBridge PutEvent predefined target type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "detailType":
            suggest = "detail_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleEventBridgeParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleEventBridgeParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleEventBridgeParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 detail_type: str,
                 source: str):
        """
        EventBridge PutEvent predefined target type.
        :param str detail_type: Free-form string, with a maximum of 128 characters, used to decide what fields to expect in the event detail.
        :param str source: The source of the event.
        """
        pulumi.set(__self__, "detail_type", detail_type)
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter(name="detailType")
    def detail_type(self) -> str:
        """
        Free-form string, with a maximum of 128 characters, used to decide what fields to expect in the event detail.
        """
        return pulumi.get(self, "detail_type")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        The source of the event.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class ScheduleFlexibleTimeWindow(dict):
    """
    Flexible time window allows configuration of a window within which a schedule can be invoked
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumWindowInMinutes":
            suggest = "maximum_window_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleFlexibleTimeWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleFlexibleTimeWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleFlexibleTimeWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mode: 'ScheduleFlexibleTimeWindowMode',
                 maximum_window_in_minutes: Optional[float] = None):
        """
        Flexible time window allows configuration of a window within which a schedule can be invoked
        :param 'ScheduleFlexibleTimeWindowMode' mode: Determines whether the schedule is invoked within a flexible time window. You must use quotation marks when you specify this value in your JSON or YAML template.
               
               *Allowed Values* : `"OFF"` | `"FLEXIBLE"`
        :param float maximum_window_in_minutes: The maximum time window during which a schedule can be invoked.
        """
        pulumi.set(__self__, "mode", mode)
        if maximum_window_in_minutes is not None:
            pulumi.set(__self__, "maximum_window_in_minutes", maximum_window_in_minutes)

    @property
    @pulumi.getter
    def mode(self) -> 'ScheduleFlexibleTimeWindowMode':
        """
        Determines whether the schedule is invoked within a flexible time window. You must use quotation marks when you specify this value in your JSON or YAML template.

        *Allowed Values* : `"OFF"` | `"FLEXIBLE"`
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="maximumWindowInMinutes")
    def maximum_window_in_minutes(self) -> Optional[float]:
        """
        The maximum time window during which a schedule can be invoked.
        """
        return pulumi.get(self, "maximum_window_in_minutes")


@pulumi.output_type
class ScheduleKinesisParameters(dict):
    """
    The custom parameter you can use to control the shard to which EventBridge Scheduler sends the event.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "partitionKey":
            suggest = "partition_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleKinesisParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleKinesisParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleKinesisParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 partition_key: str):
        """
        The custom parameter you can use to control the shard to which EventBridge Scheduler sends the event.
        :param str partition_key: The custom parameter used as the Kinesis partition key. For more information, see Amazon Kinesis Streams Key Concepts in the Amazon Kinesis Streams Developer Guide.
        """
        pulumi.set(__self__, "partition_key", partition_key)

    @property
    @pulumi.getter(name="partitionKey")
    def partition_key(self) -> str:
        """
        The custom parameter used as the Kinesis partition key. For more information, see Amazon Kinesis Streams Key Concepts in the Amazon Kinesis Streams Developer Guide.
        """
        return pulumi.get(self, "partition_key")


@pulumi.output_type
class ScheduleNetworkConfiguration(dict):
    """
    This structure specifies the network configuration for an ECS task.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsvpcConfiguration":
            suggest = "awsvpc_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleNetworkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleNetworkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleNetworkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 awsvpc_configuration: Optional['outputs.ScheduleAwsVpcConfiguration'] = None):
        """
        This structure specifies the network configuration for an ECS task.
        :param 'ScheduleAwsVpcConfiguration' awsvpc_configuration: Specifies the Amazon VPC subnets and security groups for the task, and whether a public IP address is to be used. This structure is relevant only for ECS tasks that use the awsvpc network mode.
        """
        if awsvpc_configuration is not None:
            pulumi.set(__self__, "awsvpc_configuration", awsvpc_configuration)

    @property
    @pulumi.getter(name="awsvpcConfiguration")
    def awsvpc_configuration(self) -> Optional['outputs.ScheduleAwsVpcConfiguration']:
        """
        Specifies the Amazon VPC subnets and security groups for the task, and whether a public IP address is to be used. This structure is relevant only for ECS tasks that use the awsvpc network mode.
        """
        return pulumi.get(self, "awsvpc_configuration")


@pulumi.output_type
class SchedulePlacementConstraint(dict):
    """
    An object representing a constraint on task placement.
    """
    def __init__(__self__, *,
                 expression: Optional[str] = None,
                 type: Optional['SchedulePlacementConstraintType'] = None):
        """
        An object representing a constraint on task placement.
        :param str expression: A cluster query language expression to apply to the constraint. You cannot specify an expression if the constraint type is distinctInstance. To learn more, see Cluster Query Language in the Amazon Elastic Container Service Developer Guide.
        :param 'SchedulePlacementConstraintType' type: The type of constraint. Use `distinctInstance` to ensure that each task in a particular group is running on a different container instance. Use `memberOf` to restrict the selection to a group of valid candidates.
        """
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def expression(self) -> Optional[str]:
        """
        A cluster query language expression to apply to the constraint. You cannot specify an expression if the constraint type is distinctInstance. To learn more, see Cluster Query Language in the Amazon Elastic Container Service Developer Guide.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def type(self) -> Optional['SchedulePlacementConstraintType']:
        """
        The type of constraint. Use `distinctInstance` to ensure that each task in a particular group is running on a different container instance. Use `memberOf` to restrict the selection to a group of valid candidates.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class SchedulePlacementStrategy(dict):
    """
    The task placement strategy for a task or service.
    """
    def __init__(__self__, *,
                 field: Optional[str] = None,
                 type: Optional['SchedulePlacementStrategyType'] = None):
        """
        The task placement strategy for a task or service.
        :param str field: The field to apply the placement strategy against. For the spread placement strategy, valid values are instanceId (or host, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as attribute:ecs.availability-zone. For the binpack placement strategy, valid values are cpu and memory. For the random placement strategy, this field is not used.
        :param 'SchedulePlacementStrategyType' type: The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task).
        """
        if field is not None:
            pulumi.set(__self__, "field", field)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def field(self) -> Optional[str]:
        """
        The field to apply the placement strategy against. For the spread placement strategy, valid values are instanceId (or host, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as attribute:ecs.availability-zone. For the binpack placement strategy, valid values are cpu and memory. For the random placement strategy, this field is not used.
        """
        return pulumi.get(self, "field")

    @property
    @pulumi.getter
    def type(self) -> Optional['SchedulePlacementStrategyType']:
        """
        The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task).
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ScheduleRetryPolicy(dict):
    """
    A RetryPolicy object that includes information about the retry policy settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumEventAgeInSeconds":
            suggest = "maximum_event_age_in_seconds"
        elif key == "maximumRetryAttempts":
            suggest = "maximum_retry_attempts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleRetryPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleRetryPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleRetryPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maximum_event_age_in_seconds: Optional[float] = None,
                 maximum_retry_attempts: Optional[float] = None):
        """
        A RetryPolicy object that includes information about the retry policy settings.
        :param float maximum_event_age_in_seconds: The maximum amount of time, in seconds, to continue to make retry attempts.
        :param float maximum_retry_attempts: The maximum number of retry attempts to make before the request fails. Retry attempts with exponential backoff continue until either the maximum number of attempts is made or until the duration of the MaximumEventAgeInSeconds is reached.
        """
        if maximum_event_age_in_seconds is not None:
            pulumi.set(__self__, "maximum_event_age_in_seconds", maximum_event_age_in_seconds)
        if maximum_retry_attempts is not None:
            pulumi.set(__self__, "maximum_retry_attempts", maximum_retry_attempts)

    @property
    @pulumi.getter(name="maximumEventAgeInSeconds")
    def maximum_event_age_in_seconds(self) -> Optional[float]:
        """
        The maximum amount of time, in seconds, to continue to make retry attempts.
        """
        return pulumi.get(self, "maximum_event_age_in_seconds")

    @property
    @pulumi.getter(name="maximumRetryAttempts")
    def maximum_retry_attempts(self) -> Optional[float]:
        """
        The maximum number of retry attempts to make before the request fails. Retry attempts with exponential backoff continue until either the maximum number of attempts is made or until the duration of the MaximumEventAgeInSeconds is reached.
        """
        return pulumi.get(self, "maximum_retry_attempts")


@pulumi.output_type
class ScheduleSageMakerPipelineParameter(dict):
    """
    Name/Value pair of a parameter to start execution of a SageMaker Model Building Pipeline.
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        Name/Value pair of a parameter to start execution of a SageMaker Model Building Pipeline.
        :param str name: Name of parameter to start execution of a SageMaker Model Building Pipeline.
        :param str value: Value of parameter to start execution of a SageMaker Model Building Pipeline.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of parameter to start execution of a SageMaker Model Building Pipeline.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value of parameter to start execution of a SageMaker Model Building Pipeline.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ScheduleSageMakerPipelineParameters(dict):
    """
    These are custom parameters to use when the target is a SageMaker Model Building Pipeline that starts based on AWS EventBridge Scheduler schedules.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pipelineParameterList":
            suggest = "pipeline_parameter_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleSageMakerPipelineParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleSageMakerPipelineParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleSageMakerPipelineParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pipeline_parameter_list: Optional[Sequence['outputs.ScheduleSageMakerPipelineParameter']] = None):
        """
        These are custom parameters to use when the target is a SageMaker Model Building Pipeline that starts based on AWS EventBridge Scheduler schedules.
        :param Sequence['ScheduleSageMakerPipelineParameter'] pipeline_parameter_list: List of Parameter names and values for SageMaker Model Building Pipeline execution.
        """
        if pipeline_parameter_list is not None:
            pulumi.set(__self__, "pipeline_parameter_list", pipeline_parameter_list)

    @property
    @pulumi.getter(name="pipelineParameterList")
    def pipeline_parameter_list(self) -> Optional[Sequence['outputs.ScheduleSageMakerPipelineParameter']]:
        """
        List of Parameter names and values for SageMaker Model Building Pipeline execution.
        """
        return pulumi.get(self, "pipeline_parameter_list")


@pulumi.output_type
class ScheduleSqsParameters(dict):
    """
    Contains the message group ID to use when the target is a FIFO queue. If you specify an SQS FIFO queue as a target, the queue must have content-based deduplication enabled.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageGroupId":
            suggest = "message_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleSqsParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleSqsParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleSqsParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message_group_id: Optional[str] = None):
        """
        Contains the message group ID to use when the target is a FIFO queue. If you specify an SQS FIFO queue as a target, the queue must have content-based deduplication enabled.
        :param str message_group_id: The FIFO message group ID to use as the target.
        """
        if message_group_id is not None:
            pulumi.set(__self__, "message_group_id", message_group_id)

    @property
    @pulumi.getter(name="messageGroupId")
    def message_group_id(self) -> Optional[str]:
        """
        The FIFO message group ID to use as the target.
        """
        return pulumi.get(self, "message_group_id")


@pulumi.output_type
class ScheduleTarget(dict):
    """
    The schedule target.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "deadLetterConfig":
            suggest = "dead_letter_config"
        elif key == "ecsParameters":
            suggest = "ecs_parameters"
        elif key == "eventBridgeParameters":
            suggest = "event_bridge_parameters"
        elif key == "kinesisParameters":
            suggest = "kinesis_parameters"
        elif key == "retryPolicy":
            suggest = "retry_policy"
        elif key == "sageMakerPipelineParameters":
            suggest = "sage_maker_pipeline_parameters"
        elif key == "sqsParameters":
            suggest = "sqs_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arn: str,
                 role_arn: str,
                 dead_letter_config: Optional['outputs.ScheduleDeadLetterConfig'] = None,
                 ecs_parameters: Optional['outputs.ScheduleEcsParameters'] = None,
                 event_bridge_parameters: Optional['outputs.ScheduleEventBridgeParameters'] = None,
                 input: Optional[str] = None,
                 kinesis_parameters: Optional['outputs.ScheduleKinesisParameters'] = None,
                 retry_policy: Optional['outputs.ScheduleRetryPolicy'] = None,
                 sage_maker_pipeline_parameters: Optional['outputs.ScheduleSageMakerPipelineParameters'] = None,
                 sqs_parameters: Optional['outputs.ScheduleSqsParameters'] = None):
        """
        The schedule target.
        :param str arn: The Amazon Resource Name (ARN) of the target.
        :param str role_arn: The Amazon Resource Name (ARN) of the IAM role to be used for this target when the schedule is triggered.
        :param 'ScheduleDeadLetterConfig' dead_letter_config: An object that contains information about an Amazon SQS queue that EventBridge Scheduler uses as a dead-letter queue for your schedule. If specified, EventBridge Scheduler delivers failed events that could not be successfully delivered to a target to the queue.
        :param 'ScheduleEcsParameters' ecs_parameters: The templated target type for the Amazon ECS [`RunTask`](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html) API operation.
        :param 'ScheduleEventBridgeParameters' event_bridge_parameters: The templated target type for the EventBridge [`PutEvents`](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html) API operation.
        :param str input: The text, or well-formed JSON, passed to the target. If you are configuring a templated Lambda, AWS Step Functions, or Amazon EventBridge target, the input must be a well-formed JSON. For all other target types, a JSON is not required. If you do not specify anything for this field, EventBridge Scheduler delivers a default notification to the target.
        :param 'ScheduleKinesisParameters' kinesis_parameters: The templated target type for the Amazon Kinesis [`PutRecord`](https://docs.aws.amazon.com/kinesis/latest/APIReference/API_PutRecord.html) API operation.
        :param 'ScheduleRetryPolicy' retry_policy: A `RetryPolicy` object that includes information about the retry policy settings, including the maximum age of an event, and the maximum number of times EventBridge Scheduler will try to deliver the event to a target.
        :param 'ScheduleSageMakerPipelineParameters' sage_maker_pipeline_parameters: The templated target type for the Amazon SageMaker [`StartPipelineExecution`](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StartPipelineExecution.html) API operation.
        :param 'ScheduleSqsParameters' sqs_parameters: The templated target type for the Amazon SQS [`SendMessage`](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_SendMessage.html) API operation. Contains the message group ID to use when the target is a FIFO queue. If you specify an Amazon SQS FIFO queue as a target, the queue must have content-based deduplication enabled. For more information, see [Using the Amazon SQS message deduplication ID](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagededuplicationid-property.html) in the *Amazon SQS Developer Guide* .
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "role_arn", role_arn)
        if dead_letter_config is not None:
            pulumi.set(__self__, "dead_letter_config", dead_letter_config)
        if ecs_parameters is not None:
            pulumi.set(__self__, "ecs_parameters", ecs_parameters)
        if event_bridge_parameters is not None:
            pulumi.set(__self__, "event_bridge_parameters", event_bridge_parameters)
        if input is not None:
            pulumi.set(__self__, "input", input)
        if kinesis_parameters is not None:
            pulumi.set(__self__, "kinesis_parameters", kinesis_parameters)
        if retry_policy is not None:
            pulumi.set(__self__, "retry_policy", retry_policy)
        if sage_maker_pipeline_parameters is not None:
            pulumi.set(__self__, "sage_maker_pipeline_parameters", sage_maker_pipeline_parameters)
        if sqs_parameters is not None:
            pulumi.set(__self__, "sqs_parameters", sqs_parameters)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the target.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the IAM role to be used for this target when the schedule is triggered.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="deadLetterConfig")
    def dead_letter_config(self) -> Optional['outputs.ScheduleDeadLetterConfig']:
        """
        An object that contains information about an Amazon SQS queue that EventBridge Scheduler uses as a dead-letter queue for your schedule. If specified, EventBridge Scheduler delivers failed events that could not be successfully delivered to a target to the queue.
        """
        return pulumi.get(self, "dead_letter_config")

    @property
    @pulumi.getter(name="ecsParameters")
    def ecs_parameters(self) -> Optional['outputs.ScheduleEcsParameters']:
        """
        The templated target type for the Amazon ECS [`RunTask`](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html) API operation.
        """
        return pulumi.get(self, "ecs_parameters")

    @property
    @pulumi.getter(name="eventBridgeParameters")
    def event_bridge_parameters(self) -> Optional['outputs.ScheduleEventBridgeParameters']:
        """
        The templated target type for the EventBridge [`PutEvents`](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html) API operation.
        """
        return pulumi.get(self, "event_bridge_parameters")

    @property
    @pulumi.getter
    def input(self) -> Optional[str]:
        """
        The text, or well-formed JSON, passed to the target. If you are configuring a templated Lambda, AWS Step Functions, or Amazon EventBridge target, the input must be a well-formed JSON. For all other target types, a JSON is not required. If you do not specify anything for this field, EventBridge Scheduler delivers a default notification to the target.
        """
        return pulumi.get(self, "input")

    @property
    @pulumi.getter(name="kinesisParameters")
    def kinesis_parameters(self) -> Optional['outputs.ScheduleKinesisParameters']:
        """
        The templated target type for the Amazon Kinesis [`PutRecord`](https://docs.aws.amazon.com/kinesis/latest/APIReference/API_PutRecord.html) API operation.
        """
        return pulumi.get(self, "kinesis_parameters")

    @property
    @pulumi.getter(name="retryPolicy")
    def retry_policy(self) -> Optional['outputs.ScheduleRetryPolicy']:
        """
        A `RetryPolicy` object that includes information about the retry policy settings, including the maximum age of an event, and the maximum number of times EventBridge Scheduler will try to deliver the event to a target.
        """
        return pulumi.get(self, "retry_policy")

    @property
    @pulumi.getter(name="sageMakerPipelineParameters")
    def sage_maker_pipeline_parameters(self) -> Optional['outputs.ScheduleSageMakerPipelineParameters']:
        """
        The templated target type for the Amazon SageMaker [`StartPipelineExecution`](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StartPipelineExecution.html) API operation.
        """
        return pulumi.get(self, "sage_maker_pipeline_parameters")

    @property
    @pulumi.getter(name="sqsParameters")
    def sqs_parameters(self) -> Optional['outputs.ScheduleSqsParameters']:
        """
        The templated target type for the Amazon SQS [`SendMessage`](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_SendMessage.html) API operation. Contains the message group ID to use when the target is a FIFO queue. If you specify an Amazon SQS FIFO queue as a target, the queue must have content-based deduplication enabled. For more information, see [Using the Amazon SQS message deduplication ID](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagededuplicationid-property.html) in the *Amazon SQS Developer Guide* .
        """
        return pulumi.get(self, "sqs_parameters")


