# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'ScheduleAwsVpcConfigurationArgs',
    'ScheduleAwsVpcConfigurationArgsDict',
    'ScheduleCapacityProviderStrategyItemArgs',
    'ScheduleCapacityProviderStrategyItemArgsDict',
    'ScheduleDeadLetterConfigArgs',
    'ScheduleDeadLetterConfigArgsDict',
    'ScheduleEcsParametersArgs',
    'ScheduleEcsParametersArgsDict',
    'ScheduleEventBridgeParametersArgs',
    'ScheduleEventBridgeParametersArgsDict',
    'ScheduleFlexibleTimeWindowArgs',
    'ScheduleFlexibleTimeWindowArgsDict',
    'ScheduleKinesisParametersArgs',
    'ScheduleKinesisParametersArgsDict',
    'ScheduleNetworkConfigurationArgs',
    'ScheduleNetworkConfigurationArgsDict',
    'SchedulePlacementConstraintArgs',
    'SchedulePlacementConstraintArgsDict',
    'SchedulePlacementStrategyArgs',
    'SchedulePlacementStrategyArgsDict',
    'ScheduleRetryPolicyArgs',
    'ScheduleRetryPolicyArgsDict',
    'ScheduleSageMakerPipelineParametersArgs',
    'ScheduleSageMakerPipelineParametersArgsDict',
    'ScheduleSageMakerPipelineParameterArgs',
    'ScheduleSageMakerPipelineParameterArgsDict',
    'ScheduleSqsParametersArgs',
    'ScheduleSqsParametersArgsDict',
    'ScheduleTargetArgs',
    'ScheduleTargetArgsDict',
]

MYPY = False

if not MYPY:
    class ScheduleAwsVpcConfigurationArgsDict(TypedDict):
        """
        This structure specifies the VPC subnets and security groups for the task, and whether a public IP address is to be used. This structure is relevant only for ECS tasks that use the awsvpc network mode.
        """
        subnets: pulumi.Input[Sequence[pulumi.Input[str]]]
        """
        Specifies the subnets associated with the task. These subnets must all be in the same VPC. You can specify as many as 16 subnets.
        """
        assign_public_ip: NotRequired[pulumi.Input['ScheduleAssignPublicIp']]
        """
        Specifies whether the task's elastic network interface receives a public IP address. You can specify `ENABLED` only when `LaunchType` in `EcsParameters` is set to `FARGATE` .
        """
        security_groups: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        Specifies the security groups associated with the task. These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.
        """
elif False:
    ScheduleAwsVpcConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScheduleAwsVpcConfigurationArgs:
    def __init__(__self__, *,
                 subnets: pulumi.Input[Sequence[pulumi.Input[str]]],
                 assign_public_ip: Optional[pulumi.Input['ScheduleAssignPublicIp']] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        This structure specifies the VPC subnets and security groups for the task, and whether a public IP address is to be used. This structure is relevant only for ECS tasks that use the awsvpc network mode.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnets: Specifies the subnets associated with the task. These subnets must all be in the same VPC. You can specify as many as 16 subnets.
        :param pulumi.Input['ScheduleAssignPublicIp'] assign_public_ip: Specifies whether the task's elastic network interface receives a public IP address. You can specify `ENABLED` only when `LaunchType` in `EcsParameters` is set to `FARGATE` .
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: Specifies the security groups associated with the task. These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.
        """
        pulumi.set(__self__, "subnets", subnets)
        if assign_public_ip is not None:
            pulumi.set(__self__, "assign_public_ip", assign_public_ip)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)

    @property
    @pulumi.getter
    def subnets(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies the subnets associated with the task. These subnets must all be in the same VPC. You can specify as many as 16 subnets.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "subnets", value)

    @property
    @pulumi.getter(name="assignPublicIp")
    def assign_public_ip(self) -> Optional[pulumi.Input['ScheduleAssignPublicIp']]:
        """
        Specifies whether the task's elastic network interface receives a public IP address. You can specify `ENABLED` only when `LaunchType` in `EcsParameters` is set to `FARGATE` .
        """
        return pulumi.get(self, "assign_public_ip")

    @assign_public_ip.setter
    def assign_public_ip(self, value: Optional[pulumi.Input['ScheduleAssignPublicIp']]):
        pulumi.set(self, "assign_public_ip", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the security groups associated with the task. These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_groups", value)


if not MYPY:
    class ScheduleCapacityProviderStrategyItemArgsDict(TypedDict):
        """
        The details of a capacity provider strategy.
        """
        capacity_provider: pulumi.Input[str]
        """
        The short name of the capacity provider.
        """
        base: NotRequired[pulumi.Input[float]]
        """
        The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. If no value is specified, the default value of 0 is used.
        """
        weight: NotRequired[pulumi.Input[float]]
        """
        The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied.
        """
elif False:
    ScheduleCapacityProviderStrategyItemArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScheduleCapacityProviderStrategyItemArgs:
    def __init__(__self__, *,
                 capacity_provider: pulumi.Input[str],
                 base: Optional[pulumi.Input[float]] = None,
                 weight: Optional[pulumi.Input[float]] = None):
        """
        The details of a capacity provider strategy.
        :param pulumi.Input[str] capacity_provider: The short name of the capacity provider.
        :param pulumi.Input[float] base: The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. If no value is specified, the default value of 0 is used.
        :param pulumi.Input[float] weight: The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied.
        """
        pulumi.set(__self__, "capacity_provider", capacity_provider)
        if base is not None:
            pulumi.set(__self__, "base", base)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="capacityProvider")
    def capacity_provider(self) -> pulumi.Input[str]:
        """
        The short name of the capacity provider.
        """
        return pulumi.get(self, "capacity_provider")

    @capacity_provider.setter
    def capacity_provider(self, value: pulumi.Input[str]):
        pulumi.set(self, "capacity_provider", value)

    @property
    @pulumi.getter
    def base(self) -> Optional[pulumi.Input[float]]:
        """
        The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. If no value is specified, the default value of 0 is used.
        """
        return pulumi.get(self, "base")

    @base.setter
    def base(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "base", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[float]]:
        """
        The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "weight", value)


if not MYPY:
    class ScheduleDeadLetterConfigArgsDict(TypedDict):
        """
        A DeadLetterConfig object that contains information about a dead-letter queue configuration.
        """
        arn: NotRequired[pulumi.Input[str]]
        """
        The ARN of the SQS queue specified as the target for the dead-letter queue.
        """
elif False:
    ScheduleDeadLetterConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScheduleDeadLetterConfigArgs:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None):
        """
        A DeadLetterConfig object that contains information about a dead-letter queue configuration.
        :param pulumi.Input[str] arn: The ARN of the SQS queue specified as the target for the dead-letter queue.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the SQS queue specified as the target for the dead-letter queue.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)


if not MYPY:
    class ScheduleEcsParametersArgsDict(TypedDict):
        """
        The custom parameters to be used when the target is an Amazon ECS task.
        """
        task_definition_arn: pulumi.Input[str]
        """
        The ARN of the task definition to use if the event target is an Amazon ECS task.
        """
        capacity_provider_strategy: NotRequired[pulumi.Input[Sequence[pulumi.Input['ScheduleCapacityProviderStrategyItemArgsDict']]]]
        """
        The capacity provider strategy to use for the task.
        """
        enable_ecs_managed_tags: NotRequired[pulumi.Input[bool]]
        """
        Specifies whether to enable Amazon ECS managed tags for the task. For more information, see Tagging Your Amazon ECS Resources in the Amazon Elastic Container Service Developer Guide.
        """
        enable_execute_command: NotRequired[pulumi.Input[bool]]
        """
        Whether or not to enable the execute command functionality for the containers in this task. If true, this enables execute command functionality on all containers in the task.
        """
        group: NotRequired[pulumi.Input[str]]
        """
        Specifies an ECS task group for the task. The maximum length is 255 characters.
        """
        launch_type: NotRequired[pulumi.Input['ScheduleLaunchType']]
        """
        Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. The `FARGATE` value is supported only in the Regions where Fargate with Amazon ECS is supported. For more information, see [AWS Fargate on Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/AWS_Fargate.html) in the *Amazon ECS Developer Guide* .
        """
        network_configuration: NotRequired[pulumi.Input['ScheduleNetworkConfigurationArgsDict']]
        """
        This structure specifies the network configuration for an ECS task.
        """
        placement_constraints: NotRequired[pulumi.Input[Sequence[pulumi.Input['SchedulePlacementConstraintArgsDict']]]]
        """
        An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime).
        """
        placement_strategy: NotRequired[pulumi.Input[Sequence[pulumi.Input['SchedulePlacementStrategyArgsDict']]]]
        """
        The placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task.
        """
        platform_version: NotRequired[pulumi.Input[str]]
        """
        Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as 1.1.0.
        """
        propagate_tags: NotRequired[pulumi.Input['SchedulePropagateTags']]
        """
        Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the Amazon ECS [`TagResource`](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_TagResource.html) API action.
        """
        reference_id: NotRequired[pulumi.Input[str]]
        """
        The reference ID to use for the task.
        """
        tags: NotRequired[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]
        """
        The metadata that you apply to the task to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. To learn more, see RunTask in the Amazon ECS API Reference.
        """
        task_count: NotRequired[pulumi.Input[float]]
        """
        The number of tasks to create based on TaskDefinition. The default is 1.
        """
elif False:
    ScheduleEcsParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScheduleEcsParametersArgs:
    def __init__(__self__, *,
                 task_definition_arn: pulumi.Input[str],
                 capacity_provider_strategy: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduleCapacityProviderStrategyItemArgs']]]] = None,
                 enable_ecs_managed_tags: Optional[pulumi.Input[bool]] = None,
                 enable_execute_command: Optional[pulumi.Input[bool]] = None,
                 group: Optional[pulumi.Input[str]] = None,
                 launch_type: Optional[pulumi.Input['ScheduleLaunchType']] = None,
                 network_configuration: Optional[pulumi.Input['ScheduleNetworkConfigurationArgs']] = None,
                 placement_constraints: Optional[pulumi.Input[Sequence[pulumi.Input['SchedulePlacementConstraintArgs']]]] = None,
                 placement_strategy: Optional[pulumi.Input[Sequence[pulumi.Input['SchedulePlacementStrategyArgs']]]] = None,
                 platform_version: Optional[pulumi.Input[str]] = None,
                 propagate_tags: Optional[pulumi.Input['SchedulePropagateTags']] = None,
                 reference_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]] = None,
                 task_count: Optional[pulumi.Input[float]] = None):
        """
        The custom parameters to be used when the target is an Amazon ECS task.
        :param pulumi.Input[str] task_definition_arn: The ARN of the task definition to use if the event target is an Amazon ECS task.
        :param pulumi.Input[Sequence[pulumi.Input['ScheduleCapacityProviderStrategyItemArgs']]] capacity_provider_strategy: The capacity provider strategy to use for the task.
        :param pulumi.Input[bool] enable_ecs_managed_tags: Specifies whether to enable Amazon ECS managed tags for the task. For more information, see Tagging Your Amazon ECS Resources in the Amazon Elastic Container Service Developer Guide.
        :param pulumi.Input[bool] enable_execute_command: Whether or not to enable the execute command functionality for the containers in this task. If true, this enables execute command functionality on all containers in the task.
        :param pulumi.Input[str] group: Specifies an ECS task group for the task. The maximum length is 255 characters.
        :param pulumi.Input['ScheduleLaunchType'] launch_type: Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. The `FARGATE` value is supported only in the Regions where Fargate with Amazon ECS is supported. For more information, see [AWS Fargate on Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/AWS_Fargate.html) in the *Amazon ECS Developer Guide* .
        :param pulumi.Input['ScheduleNetworkConfigurationArgs'] network_configuration: This structure specifies the network configuration for an ECS task.
        :param pulumi.Input[Sequence[pulumi.Input['SchedulePlacementConstraintArgs']]] placement_constraints: An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime).
        :param pulumi.Input[Sequence[pulumi.Input['SchedulePlacementStrategyArgs']]] placement_strategy: The placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task.
        :param pulumi.Input[str] platform_version: Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as 1.1.0.
        :param pulumi.Input['SchedulePropagateTags'] propagate_tags: Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the Amazon ECS [`TagResource`](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_TagResource.html) API action.
        :param pulumi.Input[str] reference_id: The reference ID to use for the task.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]] tags: The metadata that you apply to the task to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. To learn more, see RunTask in the Amazon ECS API Reference.
        :param pulumi.Input[float] task_count: The number of tasks to create based on TaskDefinition. The default is 1.
        """
        pulumi.set(__self__, "task_definition_arn", task_definition_arn)
        if capacity_provider_strategy is not None:
            pulumi.set(__self__, "capacity_provider_strategy", capacity_provider_strategy)
        if enable_ecs_managed_tags is not None:
            pulumi.set(__self__, "enable_ecs_managed_tags", enable_ecs_managed_tags)
        if enable_execute_command is not None:
            pulumi.set(__self__, "enable_execute_command", enable_execute_command)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if launch_type is not None:
            pulumi.set(__self__, "launch_type", launch_type)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if placement_constraints is not None:
            pulumi.set(__self__, "placement_constraints", placement_constraints)
        if placement_strategy is not None:
            pulumi.set(__self__, "placement_strategy", placement_strategy)
        if platform_version is not None:
            pulumi.set(__self__, "platform_version", platform_version)
        if propagate_tags is not None:
            pulumi.set(__self__, "propagate_tags", propagate_tags)
        if reference_id is not None:
            pulumi.set(__self__, "reference_id", reference_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if task_count is not None:
            pulumi.set(__self__, "task_count", task_count)

    @property
    @pulumi.getter(name="taskDefinitionArn")
    def task_definition_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the task definition to use if the event target is an Amazon ECS task.
        """
        return pulumi.get(self, "task_definition_arn")

    @task_definition_arn.setter
    def task_definition_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_definition_arn", value)

    @property
    @pulumi.getter(name="capacityProviderStrategy")
    def capacity_provider_strategy(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScheduleCapacityProviderStrategyItemArgs']]]]:
        """
        The capacity provider strategy to use for the task.
        """
        return pulumi.get(self, "capacity_provider_strategy")

    @capacity_provider_strategy.setter
    def capacity_provider_strategy(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduleCapacityProviderStrategyItemArgs']]]]):
        pulumi.set(self, "capacity_provider_strategy", value)

    @property
    @pulumi.getter(name="enableEcsManagedTags")
    def enable_ecs_managed_tags(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable Amazon ECS managed tags for the task. For more information, see Tagging Your Amazon ECS Resources in the Amazon Elastic Container Service Developer Guide.
        """
        return pulumi.get(self, "enable_ecs_managed_tags")

    @enable_ecs_managed_tags.setter
    def enable_ecs_managed_tags(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ecs_managed_tags", value)

    @property
    @pulumi.getter(name="enableExecuteCommand")
    def enable_execute_command(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to enable the execute command functionality for the containers in this task. If true, this enables execute command functionality on all containers in the task.
        """
        return pulumi.get(self, "enable_execute_command")

    @enable_execute_command.setter
    def enable_execute_command(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_execute_command", value)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies an ECS task group for the task. The maximum length is 255 characters.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter(name="launchType")
    def launch_type(self) -> Optional[pulumi.Input['ScheduleLaunchType']]:
        """
        Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. The `FARGATE` value is supported only in the Regions where Fargate with Amazon ECS is supported. For more information, see [AWS Fargate on Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/AWS_Fargate.html) in the *Amazon ECS Developer Guide* .
        """
        return pulumi.get(self, "launch_type")

    @launch_type.setter
    def launch_type(self, value: Optional[pulumi.Input['ScheduleLaunchType']]):
        pulumi.set(self, "launch_type", value)

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['ScheduleNetworkConfigurationArgs']]:
        """
        This structure specifies the network configuration for an ECS task.
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['ScheduleNetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)

    @property
    @pulumi.getter(name="placementConstraints")
    def placement_constraints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SchedulePlacementConstraintArgs']]]]:
        """
        An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime).
        """
        return pulumi.get(self, "placement_constraints")

    @placement_constraints.setter
    def placement_constraints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SchedulePlacementConstraintArgs']]]]):
        pulumi.set(self, "placement_constraints", value)

    @property
    @pulumi.getter(name="placementStrategy")
    def placement_strategy(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SchedulePlacementStrategyArgs']]]]:
        """
        The placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task.
        """
        return pulumi.get(self, "placement_strategy")

    @placement_strategy.setter
    def placement_strategy(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SchedulePlacementStrategyArgs']]]]):
        pulumi.set(self, "placement_strategy", value)

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as 1.1.0.
        """
        return pulumi.get(self, "platform_version")

    @platform_version.setter
    def platform_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform_version", value)

    @property
    @pulumi.getter(name="propagateTags")
    def propagate_tags(self) -> Optional[pulumi.Input['SchedulePropagateTags']]:
        """
        Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the Amazon ECS [`TagResource`](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_TagResource.html) API action.
        """
        return pulumi.get(self, "propagate_tags")

    @propagate_tags.setter
    def propagate_tags(self, value: Optional[pulumi.Input['SchedulePropagateTags']]):
        pulumi.set(self, "propagate_tags", value)

    @property
    @pulumi.getter(name="referenceId")
    def reference_id(self) -> Optional[pulumi.Input[str]]:
        """
        The reference ID to use for the task.
        """
        return pulumi.get(self, "reference_id")

    @reference_id.setter
    def reference_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reference_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]:
        """
        The metadata that you apply to the task to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. To learn more, see RunTask in the Amazon ECS API Reference.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="taskCount")
    def task_count(self) -> Optional[pulumi.Input[float]]:
        """
        The number of tasks to create based on TaskDefinition. The default is 1.
        """
        return pulumi.get(self, "task_count")

    @task_count.setter
    def task_count(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "task_count", value)


if not MYPY:
    class ScheduleEventBridgeParametersArgsDict(TypedDict):
        """
        EventBridge PutEvent predefined target type.
        """
        detail_type: pulumi.Input[str]
        """
        Free-form string, with a maximum of 128 characters, used to decide what fields to expect in the event detail.
        """
        source: pulumi.Input[str]
        """
        The source of the event.
        """
elif False:
    ScheduleEventBridgeParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScheduleEventBridgeParametersArgs:
    def __init__(__self__, *,
                 detail_type: pulumi.Input[str],
                 source: pulumi.Input[str]):
        """
        EventBridge PutEvent predefined target type.
        :param pulumi.Input[str] detail_type: Free-form string, with a maximum of 128 characters, used to decide what fields to expect in the event detail.
        :param pulumi.Input[str] source: The source of the event.
        """
        pulumi.set(__self__, "detail_type", detail_type)
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter(name="detailType")
    def detail_type(self) -> pulumi.Input[str]:
        """
        Free-form string, with a maximum of 128 characters, used to decide what fields to expect in the event detail.
        """
        return pulumi.get(self, "detail_type")

    @detail_type.setter
    def detail_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "detail_type", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[str]:
        """
        The source of the event.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[str]):
        pulumi.set(self, "source", value)


if not MYPY:
    class ScheduleFlexibleTimeWindowArgsDict(TypedDict):
        """
        Flexible time window allows configuration of a window within which a schedule can be invoked
        """
        mode: pulumi.Input['ScheduleFlexibleTimeWindowMode']
        """
        Determines whether the schedule is invoked within a flexible time window. You must use quotation marks when you specify this value in your JSON or YAML template.

        *Allowed Values* : `"OFF"` | `"FLEXIBLE"`
        """
        maximum_window_in_minutes: NotRequired[pulumi.Input[float]]
        """
        The maximum time window during which a schedule can be invoked.
        """
elif False:
    ScheduleFlexibleTimeWindowArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScheduleFlexibleTimeWindowArgs:
    def __init__(__self__, *,
                 mode: pulumi.Input['ScheduleFlexibleTimeWindowMode'],
                 maximum_window_in_minutes: Optional[pulumi.Input[float]] = None):
        """
        Flexible time window allows configuration of a window within which a schedule can be invoked
        :param pulumi.Input['ScheduleFlexibleTimeWindowMode'] mode: Determines whether the schedule is invoked within a flexible time window. You must use quotation marks when you specify this value in your JSON or YAML template.
               
               *Allowed Values* : `"OFF"` | `"FLEXIBLE"`
        :param pulumi.Input[float] maximum_window_in_minutes: The maximum time window during which a schedule can be invoked.
        """
        pulumi.set(__self__, "mode", mode)
        if maximum_window_in_minutes is not None:
            pulumi.set(__self__, "maximum_window_in_minutes", maximum_window_in_minutes)

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Input['ScheduleFlexibleTimeWindowMode']:
        """
        Determines whether the schedule is invoked within a flexible time window. You must use quotation marks when you specify this value in your JSON or YAML template.

        *Allowed Values* : `"OFF"` | `"FLEXIBLE"`
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input['ScheduleFlexibleTimeWindowMode']):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="maximumWindowInMinutes")
    def maximum_window_in_minutes(self) -> Optional[pulumi.Input[float]]:
        """
        The maximum time window during which a schedule can be invoked.
        """
        return pulumi.get(self, "maximum_window_in_minutes")

    @maximum_window_in_minutes.setter
    def maximum_window_in_minutes(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "maximum_window_in_minutes", value)


if not MYPY:
    class ScheduleKinesisParametersArgsDict(TypedDict):
        """
        The custom parameter you can use to control the shard to which EventBridge Scheduler sends the event.
        """
        partition_key: pulumi.Input[str]
        """
        The custom parameter used as the Kinesis partition key. For more information, see Amazon Kinesis Streams Key Concepts in the Amazon Kinesis Streams Developer Guide.
        """
elif False:
    ScheduleKinesisParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScheduleKinesisParametersArgs:
    def __init__(__self__, *,
                 partition_key: pulumi.Input[str]):
        """
        The custom parameter you can use to control the shard to which EventBridge Scheduler sends the event.
        :param pulumi.Input[str] partition_key: The custom parameter used as the Kinesis partition key. For more information, see Amazon Kinesis Streams Key Concepts in the Amazon Kinesis Streams Developer Guide.
        """
        pulumi.set(__self__, "partition_key", partition_key)

    @property
    @pulumi.getter(name="partitionKey")
    def partition_key(self) -> pulumi.Input[str]:
        """
        The custom parameter used as the Kinesis partition key. For more information, see Amazon Kinesis Streams Key Concepts in the Amazon Kinesis Streams Developer Guide.
        """
        return pulumi.get(self, "partition_key")

    @partition_key.setter
    def partition_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "partition_key", value)


if not MYPY:
    class ScheduleNetworkConfigurationArgsDict(TypedDict):
        """
        This structure specifies the network configuration for an ECS task.
        """
        awsvpc_configuration: NotRequired[pulumi.Input['ScheduleAwsVpcConfigurationArgsDict']]
        """
        Specifies the Amazon VPC subnets and security groups for the task, and whether a public IP address is to be used. This structure is relevant only for ECS tasks that use the awsvpc network mode.
        """
elif False:
    ScheduleNetworkConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScheduleNetworkConfigurationArgs:
    def __init__(__self__, *,
                 awsvpc_configuration: Optional[pulumi.Input['ScheduleAwsVpcConfigurationArgs']] = None):
        """
        This structure specifies the network configuration for an ECS task.
        :param pulumi.Input['ScheduleAwsVpcConfigurationArgs'] awsvpc_configuration: Specifies the Amazon VPC subnets and security groups for the task, and whether a public IP address is to be used. This structure is relevant only for ECS tasks that use the awsvpc network mode.
        """
        if awsvpc_configuration is not None:
            pulumi.set(__self__, "awsvpc_configuration", awsvpc_configuration)

    @property
    @pulumi.getter(name="awsvpcConfiguration")
    def awsvpc_configuration(self) -> Optional[pulumi.Input['ScheduleAwsVpcConfigurationArgs']]:
        """
        Specifies the Amazon VPC subnets and security groups for the task, and whether a public IP address is to be used. This structure is relevant only for ECS tasks that use the awsvpc network mode.
        """
        return pulumi.get(self, "awsvpc_configuration")

    @awsvpc_configuration.setter
    def awsvpc_configuration(self, value: Optional[pulumi.Input['ScheduleAwsVpcConfigurationArgs']]):
        pulumi.set(self, "awsvpc_configuration", value)


if not MYPY:
    class SchedulePlacementConstraintArgsDict(TypedDict):
        """
        An object representing a constraint on task placement.
        """
        expression: NotRequired[pulumi.Input[str]]
        """
        A cluster query language expression to apply to the constraint. You cannot specify an expression if the constraint type is distinctInstance. To learn more, see Cluster Query Language in the Amazon Elastic Container Service Developer Guide.
        """
        type: NotRequired[pulumi.Input['SchedulePlacementConstraintType']]
        """
        The type of constraint. Use `distinctInstance` to ensure that each task in a particular group is running on a different container instance. Use `memberOf` to restrict the selection to a group of valid candidates.
        """
elif False:
    SchedulePlacementConstraintArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SchedulePlacementConstraintArgs:
    def __init__(__self__, *,
                 expression: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input['SchedulePlacementConstraintType']] = None):
        """
        An object representing a constraint on task placement.
        :param pulumi.Input[str] expression: A cluster query language expression to apply to the constraint. You cannot specify an expression if the constraint type is distinctInstance. To learn more, see Cluster Query Language in the Amazon Elastic Container Service Developer Guide.
        :param pulumi.Input['SchedulePlacementConstraintType'] type: The type of constraint. Use `distinctInstance` to ensure that each task in a particular group is running on a different container instance. Use `memberOf` to restrict the selection to a group of valid candidates.
        """
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        A cluster query language expression to apply to the constraint. You cannot specify an expression if the constraint type is distinctInstance. To learn more, see Cluster Query Language in the Amazon Elastic Container Service Developer Guide.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['SchedulePlacementConstraintType']]:
        """
        The type of constraint. Use `distinctInstance` to ensure that each task in a particular group is running on a different container instance. Use `memberOf` to restrict the selection to a group of valid candidates.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['SchedulePlacementConstraintType']]):
        pulumi.set(self, "type", value)


if not MYPY:
    class SchedulePlacementStrategyArgsDict(TypedDict):
        """
        The task placement strategy for a task or service.
        """
        field: NotRequired[pulumi.Input[str]]
        """
        The field to apply the placement strategy against. For the spread placement strategy, valid values are instanceId (or host, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as attribute:ecs.availability-zone. For the binpack placement strategy, valid values are cpu and memory. For the random placement strategy, this field is not used.
        """
        type: NotRequired[pulumi.Input['SchedulePlacementStrategyType']]
        """
        The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task).
        """
elif False:
    SchedulePlacementStrategyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SchedulePlacementStrategyArgs:
    def __init__(__self__, *,
                 field: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input['SchedulePlacementStrategyType']] = None):
        """
        The task placement strategy for a task or service.
        :param pulumi.Input[str] field: The field to apply the placement strategy against. For the spread placement strategy, valid values are instanceId (or host, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as attribute:ecs.availability-zone. For the binpack placement strategy, valid values are cpu and memory. For the random placement strategy, this field is not used.
        :param pulumi.Input['SchedulePlacementStrategyType'] type: The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task).
        """
        if field is not None:
            pulumi.set(__self__, "field", field)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def field(self) -> Optional[pulumi.Input[str]]:
        """
        The field to apply the placement strategy against. For the spread placement strategy, valid values are instanceId (or host, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as attribute:ecs.availability-zone. For the binpack placement strategy, valid values are cpu and memory. For the random placement strategy, this field is not used.
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['SchedulePlacementStrategyType']]:
        """
        The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['SchedulePlacementStrategyType']]):
        pulumi.set(self, "type", value)


if not MYPY:
    class ScheduleRetryPolicyArgsDict(TypedDict):
        """
        A RetryPolicy object that includes information about the retry policy settings.
        """
        maximum_event_age_in_seconds: NotRequired[pulumi.Input[float]]
        """
        The maximum amount of time, in seconds, to continue to make retry attempts.
        """
        maximum_retry_attempts: NotRequired[pulumi.Input[float]]
        """
        The maximum number of retry attempts to make before the request fails. Retry attempts with exponential backoff continue until either the maximum number of attempts is made or until the duration of the MaximumEventAgeInSeconds is reached.
        """
elif False:
    ScheduleRetryPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScheduleRetryPolicyArgs:
    def __init__(__self__, *,
                 maximum_event_age_in_seconds: Optional[pulumi.Input[float]] = None,
                 maximum_retry_attempts: Optional[pulumi.Input[float]] = None):
        """
        A RetryPolicy object that includes information about the retry policy settings.
        :param pulumi.Input[float] maximum_event_age_in_seconds: The maximum amount of time, in seconds, to continue to make retry attempts.
        :param pulumi.Input[float] maximum_retry_attempts: The maximum number of retry attempts to make before the request fails. Retry attempts with exponential backoff continue until either the maximum number of attempts is made or until the duration of the MaximumEventAgeInSeconds is reached.
        """
        if maximum_event_age_in_seconds is not None:
            pulumi.set(__self__, "maximum_event_age_in_seconds", maximum_event_age_in_seconds)
        if maximum_retry_attempts is not None:
            pulumi.set(__self__, "maximum_retry_attempts", maximum_retry_attempts)

    @property
    @pulumi.getter(name="maximumEventAgeInSeconds")
    def maximum_event_age_in_seconds(self) -> Optional[pulumi.Input[float]]:
        """
        The maximum amount of time, in seconds, to continue to make retry attempts.
        """
        return pulumi.get(self, "maximum_event_age_in_seconds")

    @maximum_event_age_in_seconds.setter
    def maximum_event_age_in_seconds(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "maximum_event_age_in_seconds", value)

    @property
    @pulumi.getter(name="maximumRetryAttempts")
    def maximum_retry_attempts(self) -> Optional[pulumi.Input[float]]:
        """
        The maximum number of retry attempts to make before the request fails. Retry attempts with exponential backoff continue until either the maximum number of attempts is made or until the duration of the MaximumEventAgeInSeconds is reached.
        """
        return pulumi.get(self, "maximum_retry_attempts")

    @maximum_retry_attempts.setter
    def maximum_retry_attempts(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "maximum_retry_attempts", value)


if not MYPY:
    class ScheduleSageMakerPipelineParametersArgsDict(TypedDict):
        """
        These are custom parameters to use when the target is a SageMaker Model Building Pipeline that starts based on AWS EventBridge Scheduler schedules.
        """
        pipeline_parameter_list: NotRequired[pulumi.Input[Sequence[pulumi.Input['ScheduleSageMakerPipelineParameterArgsDict']]]]
        """
        List of Parameter names and values for SageMaker Model Building Pipeline execution.
        """
elif False:
    ScheduleSageMakerPipelineParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScheduleSageMakerPipelineParametersArgs:
    def __init__(__self__, *,
                 pipeline_parameter_list: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduleSageMakerPipelineParameterArgs']]]] = None):
        """
        These are custom parameters to use when the target is a SageMaker Model Building Pipeline that starts based on AWS EventBridge Scheduler schedules.
        :param pulumi.Input[Sequence[pulumi.Input['ScheduleSageMakerPipelineParameterArgs']]] pipeline_parameter_list: List of Parameter names and values for SageMaker Model Building Pipeline execution.
        """
        if pipeline_parameter_list is not None:
            pulumi.set(__self__, "pipeline_parameter_list", pipeline_parameter_list)

    @property
    @pulumi.getter(name="pipelineParameterList")
    def pipeline_parameter_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScheduleSageMakerPipelineParameterArgs']]]]:
        """
        List of Parameter names and values for SageMaker Model Building Pipeline execution.
        """
        return pulumi.get(self, "pipeline_parameter_list")

    @pipeline_parameter_list.setter
    def pipeline_parameter_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduleSageMakerPipelineParameterArgs']]]]):
        pulumi.set(self, "pipeline_parameter_list", value)


if not MYPY:
    class ScheduleSageMakerPipelineParameterArgsDict(TypedDict):
        """
        Name/Value pair of a parameter to start execution of a SageMaker Model Building Pipeline.
        """
        name: pulumi.Input[str]
        """
        Name of parameter to start execution of a SageMaker Model Building Pipeline.
        """
        value: pulumi.Input[str]
        """
        Value of parameter to start execution of a SageMaker Model Building Pipeline.
        """
elif False:
    ScheduleSageMakerPipelineParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScheduleSageMakerPipelineParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        Name/Value pair of a parameter to start execution of a SageMaker Model Building Pipeline.
        :param pulumi.Input[str] name: Name of parameter to start execution of a SageMaker Model Building Pipeline.
        :param pulumi.Input[str] value: Value of parameter to start execution of a SageMaker Model Building Pipeline.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of parameter to start execution of a SageMaker Model Building Pipeline.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Value of parameter to start execution of a SageMaker Model Building Pipeline.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ScheduleSqsParametersArgsDict(TypedDict):
        """
        Contains the message group ID to use when the target is a FIFO queue. If you specify an SQS FIFO queue as a target, the queue must have content-based deduplication enabled.
        """
        message_group_id: NotRequired[pulumi.Input[str]]
        """
        The FIFO message group ID to use as the target.
        """
elif False:
    ScheduleSqsParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScheduleSqsParametersArgs:
    def __init__(__self__, *,
                 message_group_id: Optional[pulumi.Input[str]] = None):
        """
        Contains the message group ID to use when the target is a FIFO queue. If you specify an SQS FIFO queue as a target, the queue must have content-based deduplication enabled.
        :param pulumi.Input[str] message_group_id: The FIFO message group ID to use as the target.
        """
        if message_group_id is not None:
            pulumi.set(__self__, "message_group_id", message_group_id)

    @property
    @pulumi.getter(name="messageGroupId")
    def message_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The FIFO message group ID to use as the target.
        """
        return pulumi.get(self, "message_group_id")

    @message_group_id.setter
    def message_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_group_id", value)


if not MYPY:
    class ScheduleTargetArgsDict(TypedDict):
        """
        The schedule target.
        """
        arn: pulumi.Input[str]
        """
        The Amazon Resource Name (ARN) of the target.
        """
        role_arn: pulumi.Input[str]
        """
        The Amazon Resource Name (ARN) of the IAM role to be used for this target when the schedule is triggered.
        """
        dead_letter_config: NotRequired[pulumi.Input['ScheduleDeadLetterConfigArgsDict']]
        """
        An object that contains information about an Amazon SQS queue that EventBridge Scheduler uses as a dead-letter queue for your schedule. If specified, EventBridge Scheduler delivers failed events that could not be successfully delivered to a target to the queue.
        """
        ecs_parameters: NotRequired[pulumi.Input['ScheduleEcsParametersArgsDict']]
        """
        The templated target type for the Amazon ECS [`RunTask`](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html) API operation.
        """
        event_bridge_parameters: NotRequired[pulumi.Input['ScheduleEventBridgeParametersArgsDict']]
        """
        The templated target type for the EventBridge [`PutEvents`](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html) API operation.
        """
        input: NotRequired[pulumi.Input[str]]
        """
        The text, or well-formed JSON, passed to the target. If you are configuring a templated Lambda, AWS Step Functions, or Amazon EventBridge target, the input must be a well-formed JSON. For all other target types, a JSON is not required. If you do not specify anything for this field, EventBridge Scheduler delivers a default notification to the target.
        """
        kinesis_parameters: NotRequired[pulumi.Input['ScheduleKinesisParametersArgsDict']]
        """
        The templated target type for the Amazon Kinesis [`PutRecord`](https://docs.aws.amazon.com/kinesis/latest/APIReference/API_PutRecord.html) API operation.
        """
        retry_policy: NotRequired[pulumi.Input['ScheduleRetryPolicyArgsDict']]
        """
        A `RetryPolicy` object that includes information about the retry policy settings, including the maximum age of an event, and the maximum number of times EventBridge Scheduler will try to deliver the event to a target.
        """
        sage_maker_pipeline_parameters: NotRequired[pulumi.Input['ScheduleSageMakerPipelineParametersArgsDict']]
        """
        The templated target type for the Amazon SageMaker [`StartPipelineExecution`](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StartPipelineExecution.html) API operation.
        """
        sqs_parameters: NotRequired[pulumi.Input['ScheduleSqsParametersArgsDict']]
        """
        The templated target type for the Amazon SQS [`SendMessage`](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_SendMessage.html) API operation. Contains the message group ID to use when the target is a FIFO queue. If you specify an Amazon SQS FIFO queue as a target, the queue must have content-based deduplication enabled. For more information, see [Using the Amazon SQS message deduplication ID](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagededuplicationid-property.html) in the *Amazon SQS Developer Guide* .
        """
elif False:
    ScheduleTargetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScheduleTargetArgs:
    def __init__(__self__, *,
                 arn: pulumi.Input[str],
                 role_arn: pulumi.Input[str],
                 dead_letter_config: Optional[pulumi.Input['ScheduleDeadLetterConfigArgs']] = None,
                 ecs_parameters: Optional[pulumi.Input['ScheduleEcsParametersArgs']] = None,
                 event_bridge_parameters: Optional[pulumi.Input['ScheduleEventBridgeParametersArgs']] = None,
                 input: Optional[pulumi.Input[str]] = None,
                 kinesis_parameters: Optional[pulumi.Input['ScheduleKinesisParametersArgs']] = None,
                 retry_policy: Optional[pulumi.Input['ScheduleRetryPolicyArgs']] = None,
                 sage_maker_pipeline_parameters: Optional[pulumi.Input['ScheduleSageMakerPipelineParametersArgs']] = None,
                 sqs_parameters: Optional[pulumi.Input['ScheduleSqsParametersArgs']] = None):
        """
        The schedule target.
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) of the target.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) of the IAM role to be used for this target when the schedule is triggered.
        :param pulumi.Input['ScheduleDeadLetterConfigArgs'] dead_letter_config: An object that contains information about an Amazon SQS queue that EventBridge Scheduler uses as a dead-letter queue for your schedule. If specified, EventBridge Scheduler delivers failed events that could not be successfully delivered to a target to the queue.
        :param pulumi.Input['ScheduleEcsParametersArgs'] ecs_parameters: The templated target type for the Amazon ECS [`RunTask`](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html) API operation.
        :param pulumi.Input['ScheduleEventBridgeParametersArgs'] event_bridge_parameters: The templated target type for the EventBridge [`PutEvents`](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html) API operation.
        :param pulumi.Input[str] input: The text, or well-formed JSON, passed to the target. If you are configuring a templated Lambda, AWS Step Functions, or Amazon EventBridge target, the input must be a well-formed JSON. For all other target types, a JSON is not required. If you do not specify anything for this field, EventBridge Scheduler delivers a default notification to the target.
        :param pulumi.Input['ScheduleKinesisParametersArgs'] kinesis_parameters: The templated target type for the Amazon Kinesis [`PutRecord`](https://docs.aws.amazon.com/kinesis/latest/APIReference/API_PutRecord.html) API operation.
        :param pulumi.Input['ScheduleRetryPolicyArgs'] retry_policy: A `RetryPolicy` object that includes information about the retry policy settings, including the maximum age of an event, and the maximum number of times EventBridge Scheduler will try to deliver the event to a target.
        :param pulumi.Input['ScheduleSageMakerPipelineParametersArgs'] sage_maker_pipeline_parameters: The templated target type for the Amazon SageMaker [`StartPipelineExecution`](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StartPipelineExecution.html) API operation.
        :param pulumi.Input['ScheduleSqsParametersArgs'] sqs_parameters: The templated target type for the Amazon SQS [`SendMessage`](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_SendMessage.html) API operation. Contains the message group ID to use when the target is a FIFO queue. If you specify an Amazon SQS FIFO queue as a target, the queue must have content-based deduplication enabled. For more information, see [Using the Amazon SQS message deduplication ID](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagededuplicationid-property.html) in the *Amazon SQS Developer Guide* .
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "role_arn", role_arn)
        if dead_letter_config is not None:
            pulumi.set(__self__, "dead_letter_config", dead_letter_config)
        if ecs_parameters is not None:
            pulumi.set(__self__, "ecs_parameters", ecs_parameters)
        if event_bridge_parameters is not None:
            pulumi.set(__self__, "event_bridge_parameters", event_bridge_parameters)
        if input is not None:
            pulumi.set(__self__, "input", input)
        if kinesis_parameters is not None:
            pulumi.set(__self__, "kinesis_parameters", kinesis_parameters)
        if retry_policy is not None:
            pulumi.set(__self__, "retry_policy", retry_policy)
        if sage_maker_pipeline_parameters is not None:
            pulumi.set(__self__, "sage_maker_pipeline_parameters", sage_maker_pipeline_parameters)
        if sqs_parameters is not None:
            pulumi.set(__self__, "sqs_parameters", sqs_parameters)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of the target.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of the IAM role to be used for this target when the schedule is triggered.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="deadLetterConfig")
    def dead_letter_config(self) -> Optional[pulumi.Input['ScheduleDeadLetterConfigArgs']]:
        """
        An object that contains information about an Amazon SQS queue that EventBridge Scheduler uses as a dead-letter queue for your schedule. If specified, EventBridge Scheduler delivers failed events that could not be successfully delivered to a target to the queue.
        """
        return pulumi.get(self, "dead_letter_config")

    @dead_letter_config.setter
    def dead_letter_config(self, value: Optional[pulumi.Input['ScheduleDeadLetterConfigArgs']]):
        pulumi.set(self, "dead_letter_config", value)

    @property
    @pulumi.getter(name="ecsParameters")
    def ecs_parameters(self) -> Optional[pulumi.Input['ScheduleEcsParametersArgs']]:
        """
        The templated target type for the Amazon ECS [`RunTask`](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html) API operation.
        """
        return pulumi.get(self, "ecs_parameters")

    @ecs_parameters.setter
    def ecs_parameters(self, value: Optional[pulumi.Input['ScheduleEcsParametersArgs']]):
        pulumi.set(self, "ecs_parameters", value)

    @property
    @pulumi.getter(name="eventBridgeParameters")
    def event_bridge_parameters(self) -> Optional[pulumi.Input['ScheduleEventBridgeParametersArgs']]:
        """
        The templated target type for the EventBridge [`PutEvents`](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html) API operation.
        """
        return pulumi.get(self, "event_bridge_parameters")

    @event_bridge_parameters.setter
    def event_bridge_parameters(self, value: Optional[pulumi.Input['ScheduleEventBridgeParametersArgs']]):
        pulumi.set(self, "event_bridge_parameters", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input[str]]:
        """
        The text, or well-formed JSON, passed to the target. If you are configuring a templated Lambda, AWS Step Functions, or Amazon EventBridge target, the input must be a well-formed JSON. For all other target types, a JSON is not required. If you do not specify anything for this field, EventBridge Scheduler delivers a default notification to the target.
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "input", value)

    @property
    @pulumi.getter(name="kinesisParameters")
    def kinesis_parameters(self) -> Optional[pulumi.Input['ScheduleKinesisParametersArgs']]:
        """
        The templated target type for the Amazon Kinesis [`PutRecord`](https://docs.aws.amazon.com/kinesis/latest/APIReference/API_PutRecord.html) API operation.
        """
        return pulumi.get(self, "kinesis_parameters")

    @kinesis_parameters.setter
    def kinesis_parameters(self, value: Optional[pulumi.Input['ScheduleKinesisParametersArgs']]):
        pulumi.set(self, "kinesis_parameters", value)

    @property
    @pulumi.getter(name="retryPolicy")
    def retry_policy(self) -> Optional[pulumi.Input['ScheduleRetryPolicyArgs']]:
        """
        A `RetryPolicy` object that includes information about the retry policy settings, including the maximum age of an event, and the maximum number of times EventBridge Scheduler will try to deliver the event to a target.
        """
        return pulumi.get(self, "retry_policy")

    @retry_policy.setter
    def retry_policy(self, value: Optional[pulumi.Input['ScheduleRetryPolicyArgs']]):
        pulumi.set(self, "retry_policy", value)

    @property
    @pulumi.getter(name="sageMakerPipelineParameters")
    def sage_maker_pipeline_parameters(self) -> Optional[pulumi.Input['ScheduleSageMakerPipelineParametersArgs']]:
        """
        The templated target type for the Amazon SageMaker [`StartPipelineExecution`](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StartPipelineExecution.html) API operation.
        """
        return pulumi.get(self, "sage_maker_pipeline_parameters")

    @sage_maker_pipeline_parameters.setter
    def sage_maker_pipeline_parameters(self, value: Optional[pulumi.Input['ScheduleSageMakerPipelineParametersArgs']]):
        pulumi.set(self, "sage_maker_pipeline_parameters", value)

    @property
    @pulumi.getter(name="sqsParameters")
    def sqs_parameters(self) -> Optional[pulumi.Input['ScheduleSqsParametersArgs']]:
        """
        The templated target type for the Amazon SQS [`SendMessage`](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_SendMessage.html) API operation. Contains the message group ID to use when the target is a FIFO queue. If you specify an Amazon SQS FIFO queue as a target, the queue must have content-based deduplication enabled. For more information, see [Using the Amazon SQS message deduplication ID](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagededuplicationid-property.html) in the *Amazon SQS Developer Guide* .
        """
        return pulumi.get(self, "sqs_parameters")

    @sqs_parameters.setter
    def sqs_parameters(self, value: Optional[pulumi.Input['ScheduleSqsParametersArgs']]):
        pulumi.set(self, "sqs_parameters", value)


