# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AppImageConfigCodeEditorAppImageConfig',
    'AppImageConfigContainerConfig',
    'AppImageConfigCustomImageContainerEnvironmentVariable',
    'AppImageConfigFileSystemConfig',
    'AppImageConfigJupyterLabAppImageConfig',
    'AppImageConfigKernelGatewayImageConfig',
    'AppImageConfigKernelSpec',
    'AppResourceSpec',
    'ClusterInstanceGroup',
    'ClusterInstanceStorageConfig',
    'ClusterLifeCycleConfig',
    'ClusterOrchestrator',
    'ClusterOrchestratorEksConfig',
    'ClusterVpcConfig',
    'DataQualityJobDefinitionBatchTransformInput',
    'DataQualityJobDefinitionClusterConfig',
    'DataQualityJobDefinitionConstraintsResource',
    'DataQualityJobDefinitionCsv',
    'DataQualityJobDefinitionDataQualityAppSpecification',
    'DataQualityJobDefinitionDataQualityBaselineConfig',
    'DataQualityJobDefinitionDataQualityJobInput',
    'DataQualityJobDefinitionDatasetFormat',
    'DataQualityJobDefinitionEndpointInput',
    'DataQualityJobDefinitionJson',
    'DataQualityJobDefinitionMonitoringOutput',
    'DataQualityJobDefinitionMonitoringOutputConfig',
    'DataQualityJobDefinitionMonitoringResources',
    'DataQualityJobDefinitionNetworkConfig',
    'DataQualityJobDefinitionS3Output',
    'DataQualityJobDefinitionStatisticsResource',
    'DataQualityJobDefinitionStoppingCondition',
    'DataQualityJobDefinitionVpcConfig',
    'Device',
    'DeviceFleetEdgeOutputConfig',
    'DomainAppLifecycleManagement',
    'DomainCodeEditorAppSettings',
    'DomainCodeRepository',
    'DomainCustomFileSystemConfig',
    'DomainCustomImage',
    'DomainCustomPosixUserConfig',
    'DomainDefaultEbsStorageSettings',
    'DomainDefaultSpaceSettings',
    'DomainDefaultSpaceStorageSettings',
    'DomainDockerSettings',
    'DomainEfsFileSystemConfig',
    'DomainIdleSettings',
    'DomainJupyterLabAppSettings',
    'DomainJupyterServerAppSettings',
    'DomainKernelGatewayAppSettings',
    'DomainRSessionAppSettings',
    'DomainRStudioServerProAppSettings',
    'DomainRStudioServerProDomainSettings',
    'DomainResourceSpec',
    'DomainSettings',
    'DomainSharingSettings',
    'DomainStudioWebPortalSettings',
    'DomainUserSettings',
    'FeatureGroupDataCatalogConfig',
    'FeatureGroupFeatureDefinition',
    'FeatureGroupOnlineStoreSecurityConfig',
    'FeatureGroupS3StorageConfig',
    'FeatureGroupThroughputConfig',
    'FeatureGroupTtlDuration',
    'InferenceComponentComputeResourceRequirements',
    'InferenceComponentContainerSpecification',
    'InferenceComponentDeployedImage',
    'InferenceComponentRuntimeConfig',
    'InferenceComponentSpecification',
    'InferenceComponentStartupParameters',
    'InferenceExperimentCaptureContentTypeHeader',
    'InferenceExperimentDataStorageConfig',
    'InferenceExperimentEndpointMetadata',
    'InferenceExperimentModelInfrastructureConfig',
    'InferenceExperimentModelVariantConfig',
    'InferenceExperimentRealTimeInferenceConfig',
    'InferenceExperimentSchedule',
    'InferenceExperimentShadowModeConfig',
    'InferenceExperimentShadowModelVariantConfig',
    'ModelBiasJobDefinitionBatchTransformInput',
    'ModelBiasJobDefinitionClusterConfig',
    'ModelBiasJobDefinitionConstraintsResource',
    'ModelBiasJobDefinitionCsv',
    'ModelBiasJobDefinitionDatasetFormat',
    'ModelBiasJobDefinitionEndpointInput',
    'ModelBiasJobDefinitionJson',
    'ModelBiasJobDefinitionModelBiasAppSpecification',
    'ModelBiasJobDefinitionModelBiasBaselineConfig',
    'ModelBiasJobDefinitionModelBiasJobInput',
    'ModelBiasJobDefinitionMonitoringGroundTruthS3Input',
    'ModelBiasJobDefinitionMonitoringOutput',
    'ModelBiasJobDefinitionMonitoringOutputConfig',
    'ModelBiasJobDefinitionMonitoringResources',
    'ModelBiasJobDefinitionNetworkConfig',
    'ModelBiasJobDefinitionS3Output',
    'ModelBiasJobDefinitionStoppingCondition',
    'ModelBiasJobDefinitionVpcConfig',
    'ModelCardAdditionalInformation',
    'ModelCardBarChartMetric',
    'ModelCardBusinessDetails',
    'ModelCardContainer',
    'ModelCardContent',
    'ModelCardEvaluationDetail',
    'ModelCardInferenceSpecification',
    'ModelCardIntendedUses',
    'ModelCardLinearGraphMetric',
    'ModelCardMatrixMetric',
    'ModelCardMetricGroup',
    'ModelCardModelOverview',
    'ModelCardModelOverviewInferenceEnvironmentProperties',
    'ModelCardModelPackageCreator',
    'ModelCardModelPackageDetails',
    'ModelCardObjectiveFunction',
    'ModelCardObjectiveFunctionFunctionProperties',
    'ModelCardSecurityConfig',
    'ModelCardSimpleMetric',
    'ModelCardSourceAlgorithm',
    'ModelCardTrainingDetails',
    'ModelCardTrainingDetailsTrainingJobDetailsProperties',
    'ModelCardTrainingDetailsTrainingJobDetailsPropertiesTrainingEnvironmentProperties',
    'ModelCardTrainingHyperParameter',
    'ModelCardTrainingMetric',
    'ModelCardUserContext',
    'ModelExplainabilityJobDefinitionBatchTransformInput',
    'ModelExplainabilityJobDefinitionClusterConfig',
    'ModelExplainabilityJobDefinitionConstraintsResource',
    'ModelExplainabilityJobDefinitionCsv',
    'ModelExplainabilityJobDefinitionDatasetFormat',
    'ModelExplainabilityJobDefinitionEndpointInput',
    'ModelExplainabilityJobDefinitionJson',
    'ModelExplainabilityJobDefinitionModelExplainabilityAppSpecification',
    'ModelExplainabilityJobDefinitionModelExplainabilityBaselineConfig',
    'ModelExplainabilityJobDefinitionModelExplainabilityJobInput',
    'ModelExplainabilityJobDefinitionMonitoringOutput',
    'ModelExplainabilityJobDefinitionMonitoringOutputConfig',
    'ModelExplainabilityJobDefinitionMonitoringResources',
    'ModelExplainabilityJobDefinitionNetworkConfig',
    'ModelExplainabilityJobDefinitionS3Output',
    'ModelExplainabilityJobDefinitionStoppingCondition',
    'ModelExplainabilityJobDefinitionVpcConfig',
    'ModelPackageAdditionalInferenceSpecificationDefinition',
    'ModelPackageBias',
    'ModelPackageContainerDefinition',
    'ModelPackageContainerDefinitionModelInputProperties',
    'ModelPackageCustomerMetadataProperties',
    'ModelPackageDataSource',
    'ModelPackageDriftCheckBaselines',
    'ModelPackageDriftCheckBias',
    'ModelPackageDriftCheckExplainability',
    'ModelPackageDriftCheckModelDataQuality',
    'ModelPackageDriftCheckModelQuality',
    'ModelPackageEnvironment',
    'ModelPackageExplainability',
    'ModelPackageFileSource',
    'ModelPackageInferenceSpecification',
    'ModelPackageMetadataProperties',
    'ModelPackageMetricsSource',
    'ModelPackageModelAccessConfig',
    'ModelPackageModelCard',
    'ModelPackageModelDataQuality',
    'ModelPackageModelDataSource',
    'ModelPackageModelMetrics',
    'ModelPackageModelQuality',
    'ModelPackageS3DataSource',
    'ModelPackageS3ModelDataSource',
    'ModelPackageSecurityConfig',
    'ModelPackageSourceAlgorithm',
    'ModelPackageSourceAlgorithmSpecification',
    'ModelPackageStatusDetails',
    'ModelPackageStatusItem',
    'ModelPackageTransformInput',
    'ModelPackageTransformJobDefinition',
    'ModelPackageTransformOutput',
    'ModelPackageTransformResources',
    'ModelPackageValidationProfile',
    'ModelPackageValidationSpecification',
    'ModelQualityJobDefinitionBatchTransformInput',
    'ModelQualityJobDefinitionClusterConfig',
    'ModelQualityJobDefinitionConstraintsResource',
    'ModelQualityJobDefinitionCsv',
    'ModelQualityJobDefinitionDatasetFormat',
    'ModelQualityJobDefinitionEndpointInput',
    'ModelQualityJobDefinitionJson',
    'ModelQualityJobDefinitionModelQualityAppSpecification',
    'ModelQualityJobDefinitionModelQualityBaselineConfig',
    'ModelQualityJobDefinitionModelQualityJobInput',
    'ModelQualityJobDefinitionMonitoringGroundTruthS3Input',
    'ModelQualityJobDefinitionMonitoringOutput',
    'ModelQualityJobDefinitionMonitoringOutputConfig',
    'ModelQualityJobDefinitionMonitoringResources',
    'ModelQualityJobDefinitionNetworkConfig',
    'ModelQualityJobDefinitionS3Output',
    'ModelQualityJobDefinitionStoppingCondition',
    'ModelQualityJobDefinitionVpcConfig',
    'MonitoringScheduleBaselineConfig',
    'MonitoringScheduleBatchTransformInput',
    'MonitoringScheduleClusterConfig',
    'MonitoringScheduleConfig',
    'MonitoringScheduleConstraintsResource',
    'MonitoringScheduleCsv',
    'MonitoringScheduleDatasetFormat',
    'MonitoringScheduleEndpointInput',
    'MonitoringScheduleJson',
    'MonitoringScheduleMonitoringAppSpecification',
    'MonitoringScheduleMonitoringExecutionSummary',
    'MonitoringScheduleMonitoringInput',
    'MonitoringScheduleMonitoringJobDefinition',
    'MonitoringScheduleMonitoringOutput',
    'MonitoringScheduleMonitoringOutputConfig',
    'MonitoringScheduleMonitoringResources',
    'MonitoringScheduleNetworkConfig',
    'MonitoringScheduleS3Output',
    'MonitoringScheduleScheduleConfig',
    'MonitoringScheduleStatisticsResource',
    'MonitoringScheduleStoppingCondition',
    'MonitoringScheduleVpcConfig',
    'OfflineStoreConfigProperties',
    'OnlineStoreConfigProperties',
    'ParallelismConfigurationProperties',
    'PipelineDefinition0Properties',
    'PipelineDefinition1Properties',
    'PipelineS3Location',
    'ProjectProvisioningParameter',
    'ServiceCatalogProvisionedProductDetailsProperties',
    'ServiceCatalogProvisioningDetailsProperties',
    'SpaceAppLifecycleManagement',
    'SpaceCodeEditorAppSettings',
    'SpaceCodeRepository',
    'SpaceCustomFileSystem',
    'SpaceCustomImage',
    'SpaceEbsStorageSettings',
    'SpaceEfsFileSystem',
    'SpaceIdleSettings',
    'SpaceJupyterLabAppSettings',
    'SpaceJupyterServerAppSettings',
    'SpaceKernelGatewayAppSettings',
    'SpaceOwnershipSettings',
    'SpaceResourceSpec',
    'SpaceSettings',
    'SpaceSharingSettings',
    'SpaceStorageSettings',
    'UserProfileAppLifecycleManagement',
    'UserProfileCodeEditorAppSettings',
    'UserProfileCodeRepository',
    'UserProfileCustomFileSystemConfig',
    'UserProfileCustomImage',
    'UserProfileCustomPosixUserConfig',
    'UserProfileDefaultEbsStorageSettings',
    'UserProfileDefaultSpaceStorageSettings',
    'UserProfileEfsFileSystemConfig',
    'UserProfileIdleSettings',
    'UserProfileJupyterLabAppSettings',
    'UserProfileJupyterServerAppSettings',
    'UserProfileKernelGatewayAppSettings',
    'UserProfileRStudioServerProAppSettings',
    'UserProfileResourceSpec',
    'UserProfileSharingSettings',
    'UserProfileStudioWebPortalSettings',
    'UserProfileUserSettings',
]

@pulumi.output_type
class AppImageConfigCodeEditorAppImageConfig(dict):
    """
    The configuration for the kernels in a SageMaker image running as a CodeEditor app.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerConfig":
            suggest = "container_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppImageConfigCodeEditorAppImageConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppImageConfigCodeEditorAppImageConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppImageConfigCodeEditorAppImageConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_config: Optional['outputs.AppImageConfigContainerConfig'] = None):
        """
        The configuration for the kernels in a SageMaker image running as a CodeEditor app.
        :param 'AppImageConfigContainerConfig' container_config: The container configuration for a SageMaker image.
        """
        if container_config is not None:
            pulumi.set(__self__, "container_config", container_config)

    @property
    @pulumi.getter(name="containerConfig")
    def container_config(self) -> Optional['outputs.AppImageConfigContainerConfig']:
        """
        The container configuration for a SageMaker image.
        """
        return pulumi.get(self, "container_config")


@pulumi.output_type
class AppImageConfigContainerConfig(dict):
    """
    The container configuration for a SageMaker image.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerArguments":
            suggest = "container_arguments"
        elif key == "containerEntrypoint":
            suggest = "container_entrypoint"
        elif key == "containerEnvironmentVariables":
            suggest = "container_environment_variables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppImageConfigContainerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppImageConfigContainerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppImageConfigContainerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_arguments: Optional[Sequence[str]] = None,
                 container_entrypoint: Optional[Sequence[str]] = None,
                 container_environment_variables: Optional[Sequence['outputs.AppImageConfigCustomImageContainerEnvironmentVariable']] = None):
        """
        The container configuration for a SageMaker image.
        :param Sequence[str] container_arguments: A list of arguments to apply to the container.
        :param Sequence[str] container_entrypoint: The custom entry point to use on container.
        :param Sequence['AppImageConfigCustomImageContainerEnvironmentVariable'] container_environment_variables: A list of variables to apply to the custom container.
        """
        if container_arguments is not None:
            pulumi.set(__self__, "container_arguments", container_arguments)
        if container_entrypoint is not None:
            pulumi.set(__self__, "container_entrypoint", container_entrypoint)
        if container_environment_variables is not None:
            pulumi.set(__self__, "container_environment_variables", container_environment_variables)

    @property
    @pulumi.getter(name="containerArguments")
    def container_arguments(self) -> Optional[Sequence[str]]:
        """
        A list of arguments to apply to the container.
        """
        return pulumi.get(self, "container_arguments")

    @property
    @pulumi.getter(name="containerEntrypoint")
    def container_entrypoint(self) -> Optional[Sequence[str]]:
        """
        The custom entry point to use on container.
        """
        return pulumi.get(self, "container_entrypoint")

    @property
    @pulumi.getter(name="containerEnvironmentVariables")
    def container_environment_variables(self) -> Optional[Sequence['outputs.AppImageConfigCustomImageContainerEnvironmentVariable']]:
        """
        A list of variables to apply to the custom container.
        """
        return pulumi.get(self, "container_environment_variables")


@pulumi.output_type
class AppImageConfigCustomImageContainerEnvironmentVariable(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: The key that identifies a container environment variable.
        :param str value: The value of the container environment variable.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key that identifies a container environment variable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the container environment variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AppImageConfigFileSystemConfig(dict):
    """
    The Amazon Elastic File System (EFS) storage configuration for a SageMaker image.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultGid":
            suggest = "default_gid"
        elif key == "defaultUid":
            suggest = "default_uid"
        elif key == "mountPath":
            suggest = "mount_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppImageConfigFileSystemConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppImageConfigFileSystemConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppImageConfigFileSystemConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_gid: Optional[int] = None,
                 default_uid: Optional[int] = None,
                 mount_path: Optional[str] = None):
        """
        The Amazon Elastic File System (EFS) storage configuration for a SageMaker image.
        :param int default_gid: The default POSIX group ID (GID). If not specified, defaults to 100.
        :param int default_uid: The default POSIX user ID (UID). If not specified, defaults to 1000.
        :param str mount_path: The path within the image to mount the user's EFS home directory. The directory should be empty. If not specified, defaults to /home/sagemaker-user.
        """
        if default_gid is not None:
            pulumi.set(__self__, "default_gid", default_gid)
        if default_uid is not None:
            pulumi.set(__self__, "default_uid", default_uid)
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)

    @property
    @pulumi.getter(name="defaultGid")
    def default_gid(self) -> Optional[int]:
        """
        The default POSIX group ID (GID). If not specified, defaults to 100.
        """
        return pulumi.get(self, "default_gid")

    @property
    @pulumi.getter(name="defaultUid")
    def default_uid(self) -> Optional[int]:
        """
        The default POSIX user ID (UID). If not specified, defaults to 1000.
        """
        return pulumi.get(self, "default_uid")

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[str]:
        """
        The path within the image to mount the user's EFS home directory. The directory should be empty. If not specified, defaults to /home/sagemaker-user.
        """
        return pulumi.get(self, "mount_path")


@pulumi.output_type
class AppImageConfigJupyterLabAppImageConfig(dict):
    """
    The configuration for the kernels in a SageMaker image running as a JupyterLab app.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerConfig":
            suggest = "container_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppImageConfigJupyterLabAppImageConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppImageConfigJupyterLabAppImageConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppImageConfigJupyterLabAppImageConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_config: Optional['outputs.AppImageConfigContainerConfig'] = None):
        """
        The configuration for the kernels in a SageMaker image running as a JupyterLab app.
        :param 'AppImageConfigContainerConfig' container_config: The container configuration for a SageMaker image.
        """
        if container_config is not None:
            pulumi.set(__self__, "container_config", container_config)

    @property
    @pulumi.getter(name="containerConfig")
    def container_config(self) -> Optional['outputs.AppImageConfigContainerConfig']:
        """
        The container configuration for a SageMaker image.
        """
        return pulumi.get(self, "container_config")


@pulumi.output_type
class AppImageConfigKernelGatewayImageConfig(dict):
    """
    The configuration for the file system and kernels in a SageMaker image running as a KernelGateway app.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kernelSpecs":
            suggest = "kernel_specs"
        elif key == "fileSystemConfig":
            suggest = "file_system_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppImageConfigKernelGatewayImageConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppImageConfigKernelGatewayImageConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppImageConfigKernelGatewayImageConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kernel_specs: Sequence['outputs.AppImageConfigKernelSpec'],
                 file_system_config: Optional['outputs.AppImageConfigFileSystemConfig'] = None):
        """
        The configuration for the file system and kernels in a SageMaker image running as a KernelGateway app.
        :param Sequence['AppImageConfigKernelSpec'] kernel_specs: The specification of the Jupyter kernels in the image.
        :param 'AppImageConfigFileSystemConfig' file_system_config: The Amazon Elastic File System (EFS) storage configuration for a SageMaker image.
        """
        pulumi.set(__self__, "kernel_specs", kernel_specs)
        if file_system_config is not None:
            pulumi.set(__self__, "file_system_config", file_system_config)

    @property
    @pulumi.getter(name="kernelSpecs")
    def kernel_specs(self) -> Sequence['outputs.AppImageConfigKernelSpec']:
        """
        The specification of the Jupyter kernels in the image.
        """
        return pulumi.get(self, "kernel_specs")

    @property
    @pulumi.getter(name="fileSystemConfig")
    def file_system_config(self) -> Optional['outputs.AppImageConfigFileSystemConfig']:
        """
        The Amazon Elastic File System (EFS) storage configuration for a SageMaker image.
        """
        return pulumi.get(self, "file_system_config")


@pulumi.output_type
class AppImageConfigKernelSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppImageConfigKernelSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppImageConfigKernelSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppImageConfigKernelSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 display_name: Optional[str] = None):
        """
        :param str name: The name of the kernel.
        :param str display_name: The display name of the kernel.
        """
        pulumi.set(__self__, "name", name)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the kernel.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name of the kernel.
        """
        return pulumi.get(self, "display_name")


@pulumi.output_type
class AppResourceSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "lifecycleConfigArn":
            suggest = "lifecycle_config_arn"
        elif key == "sageMakerImageArn":
            suggest = "sage_maker_image_arn"
        elif key == "sageMakerImageVersionArn":
            suggest = "sage_maker_image_version_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppResourceSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppResourceSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppResourceSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: Optional['AppResourceSpecInstanceType'] = None,
                 lifecycle_config_arn: Optional[str] = None,
                 sage_maker_image_arn: Optional[str] = None,
                 sage_maker_image_version_arn: Optional[str] = None):
        """
        :param 'AppResourceSpecInstanceType' instance_type: The instance type that the image version runs on.
        :param str lifecycle_config_arn: The Amazon Resource Name (ARN) of the Lifecycle Configuration to attach to the Resource.
        :param str sage_maker_image_arn: The ARN of the SageMaker image that the image version belongs to.
        :param str sage_maker_image_version_arn: The ARN of the image version created on the instance.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if lifecycle_config_arn is not None:
            pulumi.set(__self__, "lifecycle_config_arn", lifecycle_config_arn)
        if sage_maker_image_arn is not None:
            pulumi.set(__self__, "sage_maker_image_arn", sage_maker_image_arn)
        if sage_maker_image_version_arn is not None:
            pulumi.set(__self__, "sage_maker_image_version_arn", sage_maker_image_version_arn)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional['AppResourceSpecInstanceType']:
        """
        The instance type that the image version runs on.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="lifecycleConfigArn")
    def lifecycle_config_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the Lifecycle Configuration to attach to the Resource.
        """
        return pulumi.get(self, "lifecycle_config_arn")

    @property
    @pulumi.getter(name="sageMakerImageArn")
    def sage_maker_image_arn(self) -> Optional[str]:
        """
        The ARN of the SageMaker image that the image version belongs to.
        """
        return pulumi.get(self, "sage_maker_image_arn")

    @property
    @pulumi.getter(name="sageMakerImageVersionArn")
    def sage_maker_image_version_arn(self) -> Optional[str]:
        """
        The ARN of the image version created on the instance.
        """
        return pulumi.get(self, "sage_maker_image_version_arn")


@pulumi.output_type
class ClusterInstanceGroup(dict):
    """
    Details of an instance group in a SageMaker HyperPod cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionRole":
            suggest = "execution_role"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "instanceGroupName":
            suggest = "instance_group_name"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "lifeCycleConfig":
            suggest = "life_cycle_config"
        elif key == "currentCount":
            suggest = "current_count"
        elif key == "instanceStorageConfigs":
            suggest = "instance_storage_configs"
        elif key == "onStartDeepHealthChecks":
            suggest = "on_start_deep_health_checks"
        elif key == "threadsPerCore":
            suggest = "threads_per_core"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterInstanceGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterInstanceGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterInstanceGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_role: str,
                 instance_count: int,
                 instance_group_name: str,
                 instance_type: str,
                 life_cycle_config: 'outputs.ClusterLifeCycleConfig',
                 current_count: Optional[int] = None,
                 instance_storage_configs: Optional[Sequence['outputs.ClusterInstanceStorageConfig']] = None,
                 on_start_deep_health_checks: Optional[Sequence['ClusterDeepHealthCheckType']] = None,
                 threads_per_core: Optional[int] = None):
        """
        Details of an instance group in a SageMaker HyperPod cluster.
        :param int instance_count: The number of instances you specified to add to the instance group of a SageMaker HyperPod cluster.
        :param int current_count: The number of instances that are currently in the instance group of a SageMaker HyperPod cluster.
        :param int threads_per_core: The number you specified to TreadsPerCore in CreateCluster for enabling or disabling multithreading. For instance types that support multithreading, you can specify 1 for disabling multithreading and 2 for enabling multithreading.
        """
        pulumi.set(__self__, "execution_role", execution_role)
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "instance_group_name", instance_group_name)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "life_cycle_config", life_cycle_config)
        if current_count is not None:
            pulumi.set(__self__, "current_count", current_count)
        if instance_storage_configs is not None:
            pulumi.set(__self__, "instance_storage_configs", instance_storage_configs)
        if on_start_deep_health_checks is not None:
            pulumi.set(__self__, "on_start_deep_health_checks", on_start_deep_health_checks)
        if threads_per_core is not None:
            pulumi.set(__self__, "threads_per_core", threads_per_core)

    @property
    @pulumi.getter(name="executionRole")
    def execution_role(self) -> str:
        return pulumi.get(self, "execution_role")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> int:
        """
        The number of instances you specified to add to the instance group of a SageMaker HyperPod cluster.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceGroupName")
    def instance_group_name(self) -> str:
        return pulumi.get(self, "instance_group_name")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="lifeCycleConfig")
    def life_cycle_config(self) -> 'outputs.ClusterLifeCycleConfig':
        return pulumi.get(self, "life_cycle_config")

    @property
    @pulumi.getter(name="currentCount")
    def current_count(self) -> Optional[int]:
        """
        The number of instances that are currently in the instance group of a SageMaker HyperPod cluster.
        """
        return pulumi.get(self, "current_count")

    @property
    @pulumi.getter(name="instanceStorageConfigs")
    def instance_storage_configs(self) -> Optional[Sequence['outputs.ClusterInstanceStorageConfig']]:
        return pulumi.get(self, "instance_storage_configs")

    @property
    @pulumi.getter(name="onStartDeepHealthChecks")
    def on_start_deep_health_checks(self) -> Optional[Sequence['ClusterDeepHealthCheckType']]:
        return pulumi.get(self, "on_start_deep_health_checks")

    @property
    @pulumi.getter(name="threadsPerCore")
    def threads_per_core(self) -> Optional[int]:
        """
        The number you specified to TreadsPerCore in CreateCluster for enabling or disabling multithreading. For instance types that support multithreading, you can specify 1 for disabling multithreading and 2 for enabling multithreading.
        """
        return pulumi.get(self, "threads_per_core")


@pulumi.output_type
class ClusterInstanceStorageConfig(dict):
    """
    Defines the configuration for attaching additional storage to the instances in the SageMaker HyperPod cluster instance group.
    """
    def __init__(__self__):
        """
        Defines the configuration for attaching additional storage to the instances in the SageMaker HyperPod cluster instance group.
        """
        pass


@pulumi.output_type
class ClusterLifeCycleConfig(dict):
    """
    The lifecycle configuration for a SageMaker HyperPod cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onCreate":
            suggest = "on_create"
        elif key == "sourceS3Uri":
            suggest = "source_s3_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterLifeCycleConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterLifeCycleConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterLifeCycleConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 on_create: str,
                 source_s3_uri: str):
        """
        The lifecycle configuration for a SageMaker HyperPod cluster.
        :param str on_create: The file name of the entrypoint script of lifecycle scripts under SourceS3Uri. This entrypoint script runs during cluster creation.
        :param str source_s3_uri: An Amazon S3 bucket path where your lifecycle scripts are stored.
        """
        pulumi.set(__self__, "on_create", on_create)
        pulumi.set(__self__, "source_s3_uri", source_s3_uri)

    @property
    @pulumi.getter(name="onCreate")
    def on_create(self) -> str:
        """
        The file name of the entrypoint script of lifecycle scripts under SourceS3Uri. This entrypoint script runs during cluster creation.
        """
        return pulumi.get(self, "on_create")

    @property
    @pulumi.getter(name="sourceS3Uri")
    def source_s3_uri(self) -> str:
        """
        An Amazon S3 bucket path where your lifecycle scripts are stored.
        """
        return pulumi.get(self, "source_s3_uri")


@pulumi.output_type
class ClusterOrchestrator(dict):
    """
    Specifies parameter(s) specific to the orchestrator, e.g. specify the EKS cluster.
    """
    def __init__(__self__, *,
                 eks: 'outputs.ClusterOrchestratorEksConfig'):
        """
        Specifies parameter(s) specific to the orchestrator, e.g. specify the EKS cluster.
        :param 'ClusterOrchestratorEksConfig' eks: The configuration of the Amazon EKS orchestrator cluster for the SageMaker HyperPod cluster.
        """
        pulumi.set(__self__, "eks", eks)

    @property
    @pulumi.getter
    def eks(self) -> 'outputs.ClusterOrchestratorEksConfig':
        """
        The configuration of the Amazon EKS orchestrator cluster for the SageMaker HyperPod cluster.
        """
        return pulumi.get(self, "eks")


@pulumi.output_type
class ClusterOrchestratorEksConfig(dict):
    """
    Specifies parameter(s) related to EKS as orchestrator, e.g. the EKS cluster nodes will attach to,
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterArn":
            suggest = "cluster_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterOrchestratorEksConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterOrchestratorEksConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterOrchestratorEksConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_arn: str):
        """
        Specifies parameter(s) related to EKS as orchestrator, e.g. the EKS cluster nodes will attach to,
        :param str cluster_arn: The ARN of the EKS cluster, such as arn:aws:eks:us-west-2:123456789012:cluster/my-eks-cluster
        """
        pulumi.set(__self__, "cluster_arn", cluster_arn)

    @property
    @pulumi.getter(name="clusterArn")
    def cluster_arn(self) -> str:
        """
        The ARN of the EKS cluster, such as arn:aws:eks:us-west-2:123456789012:cluster/my-eks-cluster
        """
        return pulumi.get(self, "cluster_arn")


@pulumi.output_type
class ClusterVpcConfig(dict):
    """
    Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to. You can control access to and from your resources by configuring a VPC.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupIds":
            suggest = "security_group_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_ids: Sequence[str],
                 subnets: Sequence[str]):
        """
        Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to. You can control access to and from your resources by configuring a VPC.
        :param Sequence[str] security_group_ids: The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the Subnets field.
        :param Sequence[str] subnets: The ID of the subnets in the VPC to which you want to connect your training job or model.
        """
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[str]:
        """
        The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the Subnets field.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[str]:
        """
        The ID of the subnets in the VPC to which you want to connect your training job or model.
        """
        return pulumi.get(self, "subnets")


@pulumi.output_type
class DataQualityJobDefinitionBatchTransformInput(dict):
    """
    The batch transform input for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataCapturedDestinationS3Uri":
            suggest = "data_captured_destination_s3_uri"
        elif key == "datasetFormat":
            suggest = "dataset_format"
        elif key == "localPath":
            suggest = "local_path"
        elif key == "excludeFeaturesAttribute":
            suggest = "exclude_features_attribute"
        elif key == "s3DataDistributionType":
            suggest = "s3_data_distribution_type"
        elif key == "s3InputMode":
            suggest = "s3_input_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataQualityJobDefinitionBatchTransformInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataQualityJobDefinitionBatchTransformInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataQualityJobDefinitionBatchTransformInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_captured_destination_s3_uri: str,
                 dataset_format: 'outputs.DataQualityJobDefinitionDatasetFormat',
                 local_path: str,
                 exclude_features_attribute: Optional[str] = None,
                 s3_data_distribution_type: Optional['DataQualityJobDefinitionBatchTransformInputS3DataDistributionType'] = None,
                 s3_input_mode: Optional['DataQualityJobDefinitionBatchTransformInputS3InputMode'] = None):
        """
        The batch transform input for a monitoring job.
        :param str data_captured_destination_s3_uri: A URI that identifies the Amazon S3 storage location where Batch Transform Job captures data.
        :param 'DataQualityJobDefinitionDatasetFormat' dataset_format: The dataset format for your batch transform job.
        :param str local_path: Path to the filesystem where the endpoint data is available to the container.
        :param str exclude_features_attribute: Indexes or names of the features to be excluded from analysis
        :param 'DataQualityJobDefinitionBatchTransformInputS3DataDistributionType' s3_data_distribution_type: Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to FullyReplicated
        :param 'DataQualityJobDefinitionBatchTransformInputS3InputMode' s3_input_mode: Whether the Pipe or File is used as the input mode for transfering data for the monitoring job. Pipe mode is recommended for large datasets. File mode is useful for small files that fit in memory. Defaults to File.
        """
        pulumi.set(__self__, "data_captured_destination_s3_uri", data_captured_destination_s3_uri)
        pulumi.set(__self__, "dataset_format", dataset_format)
        pulumi.set(__self__, "local_path", local_path)
        if exclude_features_attribute is not None:
            pulumi.set(__self__, "exclude_features_attribute", exclude_features_attribute)
        if s3_data_distribution_type is not None:
            pulumi.set(__self__, "s3_data_distribution_type", s3_data_distribution_type)
        if s3_input_mode is not None:
            pulumi.set(__self__, "s3_input_mode", s3_input_mode)

    @property
    @pulumi.getter(name="dataCapturedDestinationS3Uri")
    def data_captured_destination_s3_uri(self) -> str:
        """
        A URI that identifies the Amazon S3 storage location where Batch Transform Job captures data.
        """
        return pulumi.get(self, "data_captured_destination_s3_uri")

    @property
    @pulumi.getter(name="datasetFormat")
    def dataset_format(self) -> 'outputs.DataQualityJobDefinitionDatasetFormat':
        """
        The dataset format for your batch transform job.
        """
        return pulumi.get(self, "dataset_format")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> str:
        """
        Path to the filesystem where the endpoint data is available to the container.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter(name="excludeFeaturesAttribute")
    def exclude_features_attribute(self) -> Optional[str]:
        """
        Indexes or names of the features to be excluded from analysis
        """
        return pulumi.get(self, "exclude_features_attribute")

    @property
    @pulumi.getter(name="s3DataDistributionType")
    def s3_data_distribution_type(self) -> Optional['DataQualityJobDefinitionBatchTransformInputS3DataDistributionType']:
        """
        Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to FullyReplicated
        """
        return pulumi.get(self, "s3_data_distribution_type")

    @property
    @pulumi.getter(name="s3InputMode")
    def s3_input_mode(self) -> Optional['DataQualityJobDefinitionBatchTransformInputS3InputMode']:
        """
        Whether the Pipe or File is used as the input mode for transfering data for the monitoring job. Pipe mode is recommended for large datasets. File mode is useful for small files that fit in memory. Defaults to File.
        """
        return pulumi.get(self, "s3_input_mode")


@pulumi.output_type
class DataQualityJobDefinitionClusterConfig(dict):
    """
    Configuration for the cluster used to run model monitoring jobs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceCount":
            suggest = "instance_count"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "volumeSizeInGb":
            suggest = "volume_size_in_gb"
        elif key == "volumeKmsKeyId":
            suggest = "volume_kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataQualityJobDefinitionClusterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataQualityJobDefinitionClusterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataQualityJobDefinitionClusterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_count: int,
                 instance_type: str,
                 volume_size_in_gb: int,
                 volume_kms_key_id: Optional[str] = None):
        """
        Configuration for the cluster used to run model monitoring jobs.
        :param int instance_count: The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1. The default value is 1.
        :param str instance_type: The ML compute instance type for the processing job.
        :param int volume_size_in_gb: The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
        :param str volume_kms_key_id: The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
        """
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "volume_size_in_gb", volume_size_in_gb)
        if volume_kms_key_id is not None:
            pulumi.set(__self__, "volume_kms_key_id", volume_kms_key_id)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> int:
        """
        The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1. The default value is 1.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        The ML compute instance type for the processing job.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="volumeSizeInGb")
    def volume_size_in_gb(self) -> int:
        """
        The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
        """
        return pulumi.get(self, "volume_size_in_gb")

    @property
    @pulumi.getter(name="volumeKmsKeyId")
    def volume_kms_key_id(self) -> Optional[str]:
        """
        The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
        """
        return pulumi.get(self, "volume_kms_key_id")


@pulumi.output_type
class DataQualityJobDefinitionConstraintsResource(dict):
    """
    The baseline constraints resource for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Uri":
            suggest = "s3_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataQualityJobDefinitionConstraintsResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataQualityJobDefinitionConstraintsResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataQualityJobDefinitionConstraintsResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_uri: Optional[str] = None):
        """
        The baseline constraints resource for a monitoring job.
        :param str s3_uri: The Amazon S3 URI for baseline constraint file in Amazon S3 that the current monitoring job should validated against.
        """
        if s3_uri is not None:
            pulumi.set(__self__, "s3_uri", s3_uri)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> Optional[str]:
        """
        The Amazon S3 URI for baseline constraint file in Amazon S3 that the current monitoring job should validated against.
        """
        return pulumi.get(self, "s3_uri")


@pulumi.output_type
class DataQualityJobDefinitionCsv(dict):
    """
    The CSV format
    """
    def __init__(__self__, *,
                 header: Optional[bool] = None):
        """
        The CSV format
        :param bool header: A boolean flag indicating if given CSV has header
        """
        if header is not None:
            pulumi.set(__self__, "header", header)

    @property
    @pulumi.getter
    def header(self) -> Optional[bool]:
        """
        A boolean flag indicating if given CSV has header
        """
        return pulumi.get(self, "header")


@pulumi.output_type
class DataQualityJobDefinitionDataQualityAppSpecification(dict):
    """
    Container image configuration object for the monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageUri":
            suggest = "image_uri"
        elif key == "containerArguments":
            suggest = "container_arguments"
        elif key == "containerEntrypoint":
            suggest = "container_entrypoint"
        elif key == "postAnalyticsProcessorSourceUri":
            suggest = "post_analytics_processor_source_uri"
        elif key == "recordPreprocessorSourceUri":
            suggest = "record_preprocessor_source_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataQualityJobDefinitionDataQualityAppSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataQualityJobDefinitionDataQualityAppSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataQualityJobDefinitionDataQualityAppSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_uri: str,
                 container_arguments: Optional[Sequence[str]] = None,
                 container_entrypoint: Optional[Sequence[str]] = None,
                 environment: Optional[Any] = None,
                 post_analytics_processor_source_uri: Optional[str] = None,
                 record_preprocessor_source_uri: Optional[str] = None):
        """
        Container image configuration object for the monitoring job.
        :param str image_uri: The container image to be run by the monitoring job.
        :param Sequence[str] container_arguments: An array of arguments for the container used to run the monitoring job.
        :param Sequence[str] container_entrypoint: Specifies the entrypoint for a container used to run the monitoring job.
        :param Any environment: Sets the environment variables in the Docker container
        :param str post_analytics_processor_source_uri: An Amazon S3 URI to a script that is called after analysis has been performed. Applicable only for the built-in (first party) containers.
        :param str record_preprocessor_source_uri: An Amazon S3 URI to a script that is called per row prior to running analysis. It can base64 decode the payload and convert it into a flatted json so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers
        """
        pulumi.set(__self__, "image_uri", image_uri)
        if container_arguments is not None:
            pulumi.set(__self__, "container_arguments", container_arguments)
        if container_entrypoint is not None:
            pulumi.set(__self__, "container_entrypoint", container_entrypoint)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if post_analytics_processor_source_uri is not None:
            pulumi.set(__self__, "post_analytics_processor_source_uri", post_analytics_processor_source_uri)
        if record_preprocessor_source_uri is not None:
            pulumi.set(__self__, "record_preprocessor_source_uri", record_preprocessor_source_uri)

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> str:
        """
        The container image to be run by the monitoring job.
        """
        return pulumi.get(self, "image_uri")

    @property
    @pulumi.getter(name="containerArguments")
    def container_arguments(self) -> Optional[Sequence[str]]:
        """
        An array of arguments for the container used to run the monitoring job.
        """
        return pulumi.get(self, "container_arguments")

    @property
    @pulumi.getter(name="containerEntrypoint")
    def container_entrypoint(self) -> Optional[Sequence[str]]:
        """
        Specifies the entrypoint for a container used to run the monitoring job.
        """
        return pulumi.get(self, "container_entrypoint")

    @property
    @pulumi.getter
    def environment(self) -> Optional[Any]:
        """
        Sets the environment variables in the Docker container
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="postAnalyticsProcessorSourceUri")
    def post_analytics_processor_source_uri(self) -> Optional[str]:
        """
        An Amazon S3 URI to a script that is called after analysis has been performed. Applicable only for the built-in (first party) containers.
        """
        return pulumi.get(self, "post_analytics_processor_source_uri")

    @property
    @pulumi.getter(name="recordPreprocessorSourceUri")
    def record_preprocessor_source_uri(self) -> Optional[str]:
        """
        An Amazon S3 URI to a script that is called per row prior to running analysis. It can base64 decode the payload and convert it into a flatted json so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers
        """
        return pulumi.get(self, "record_preprocessor_source_uri")


@pulumi.output_type
class DataQualityJobDefinitionDataQualityBaselineConfig(dict):
    """
    Baseline configuration used to validate that the data conforms to the specified constraints and statistics.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseliningJobName":
            suggest = "baselining_job_name"
        elif key == "constraintsResource":
            suggest = "constraints_resource"
        elif key == "statisticsResource":
            suggest = "statistics_resource"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataQualityJobDefinitionDataQualityBaselineConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataQualityJobDefinitionDataQualityBaselineConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataQualityJobDefinitionDataQualityBaselineConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 baselining_job_name: Optional[str] = None,
                 constraints_resource: Optional['outputs.DataQualityJobDefinitionConstraintsResource'] = None,
                 statistics_resource: Optional['outputs.DataQualityJobDefinitionStatisticsResource'] = None):
        """
        Baseline configuration used to validate that the data conforms to the specified constraints and statistics.
        :param str baselining_job_name: The name of the job that performs baselining for the data quality monitoring job.
        :param 'DataQualityJobDefinitionConstraintsResource' constraints_resource: The constraints resource for a monitoring job.
        :param 'DataQualityJobDefinitionStatisticsResource' statistics_resource: Configuration for monitoring constraints and monitoring statistics. These baseline resources are compared against the results of the current job from the series of jobs scheduled to collect data periodically.
        """
        if baselining_job_name is not None:
            pulumi.set(__self__, "baselining_job_name", baselining_job_name)
        if constraints_resource is not None:
            pulumi.set(__self__, "constraints_resource", constraints_resource)
        if statistics_resource is not None:
            pulumi.set(__self__, "statistics_resource", statistics_resource)

    @property
    @pulumi.getter(name="baseliningJobName")
    def baselining_job_name(self) -> Optional[str]:
        """
        The name of the job that performs baselining for the data quality monitoring job.
        """
        return pulumi.get(self, "baselining_job_name")

    @property
    @pulumi.getter(name="constraintsResource")
    def constraints_resource(self) -> Optional['outputs.DataQualityJobDefinitionConstraintsResource']:
        """
        The constraints resource for a monitoring job.
        """
        return pulumi.get(self, "constraints_resource")

    @property
    @pulumi.getter(name="statisticsResource")
    def statistics_resource(self) -> Optional['outputs.DataQualityJobDefinitionStatisticsResource']:
        """
        Configuration for monitoring constraints and monitoring statistics. These baseline resources are compared against the results of the current job from the series of jobs scheduled to collect data periodically.
        """
        return pulumi.get(self, "statistics_resource")


@pulumi.output_type
class DataQualityJobDefinitionDataQualityJobInput(dict):
    """
    The inputs for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "batchTransformInput":
            suggest = "batch_transform_input"
        elif key == "endpointInput":
            suggest = "endpoint_input"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataQualityJobDefinitionDataQualityJobInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataQualityJobDefinitionDataQualityJobInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataQualityJobDefinitionDataQualityJobInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 batch_transform_input: Optional['outputs.DataQualityJobDefinitionBatchTransformInput'] = None,
                 endpoint_input: Optional['outputs.DataQualityJobDefinitionEndpointInput'] = None):
        """
        The inputs for a monitoring job.
        :param 'DataQualityJobDefinitionBatchTransformInput' batch_transform_input: Input object for the batch transform job.
        :param 'DataQualityJobDefinitionEndpointInput' endpoint_input: Input object for the endpoint
        """
        if batch_transform_input is not None:
            pulumi.set(__self__, "batch_transform_input", batch_transform_input)
        if endpoint_input is not None:
            pulumi.set(__self__, "endpoint_input", endpoint_input)

    @property
    @pulumi.getter(name="batchTransformInput")
    def batch_transform_input(self) -> Optional['outputs.DataQualityJobDefinitionBatchTransformInput']:
        """
        Input object for the batch transform job.
        """
        return pulumi.get(self, "batch_transform_input")

    @property
    @pulumi.getter(name="endpointInput")
    def endpoint_input(self) -> Optional['outputs.DataQualityJobDefinitionEndpointInput']:
        """
        Input object for the endpoint
        """
        return pulumi.get(self, "endpoint_input")


@pulumi.output_type
class DataQualityJobDefinitionDatasetFormat(dict):
    """
    The dataset format of the data to monitor
    """
    def __init__(__self__, *,
                 csv: Optional['outputs.DataQualityJobDefinitionCsv'] = None,
                 json: Optional['outputs.DataQualityJobDefinitionJson'] = None,
                 parquet: Optional[bool] = None):
        """
        The dataset format of the data to monitor
        """
        if csv is not None:
            pulumi.set(__self__, "csv", csv)
        if json is not None:
            pulumi.set(__self__, "json", json)
        if parquet is not None:
            pulumi.set(__self__, "parquet", parquet)

    @property
    @pulumi.getter
    def csv(self) -> Optional['outputs.DataQualityJobDefinitionCsv']:
        return pulumi.get(self, "csv")

    @property
    @pulumi.getter
    def json(self) -> Optional['outputs.DataQualityJobDefinitionJson']:
        return pulumi.get(self, "json")

    @property
    @pulumi.getter
    def parquet(self) -> Optional[bool]:
        return pulumi.get(self, "parquet")


@pulumi.output_type
class DataQualityJobDefinitionEndpointInput(dict):
    """
    The endpoint for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointName":
            suggest = "endpoint_name"
        elif key == "localPath":
            suggest = "local_path"
        elif key == "excludeFeaturesAttribute":
            suggest = "exclude_features_attribute"
        elif key == "s3DataDistributionType":
            suggest = "s3_data_distribution_type"
        elif key == "s3InputMode":
            suggest = "s3_input_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataQualityJobDefinitionEndpointInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataQualityJobDefinitionEndpointInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataQualityJobDefinitionEndpointInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_name: str,
                 local_path: str,
                 exclude_features_attribute: Optional[str] = None,
                 s3_data_distribution_type: Optional['DataQualityJobDefinitionEndpointInputS3DataDistributionType'] = None,
                 s3_input_mode: Optional['DataQualityJobDefinitionEndpointInputS3InputMode'] = None):
        """
        The endpoint for a monitoring job.
        :param str endpoint_name: An endpoint in customer's account which has enabled `DataCaptureConfig` enabled.
        :param str local_path: Path to the filesystem where the endpoint data is available to the container.
        :param str exclude_features_attribute: Indexes or names of the features to be excluded from analysis
        :param 'DataQualityJobDefinitionEndpointInputS3DataDistributionType' s3_data_distribution_type: Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to FullyReplicated
        :param 'DataQualityJobDefinitionEndpointInputS3InputMode' s3_input_mode: Whether the Pipe or File is used as the input mode for transfering data for the monitoring job. Pipe mode is recommended for large datasets. File mode is useful for small files that fit in memory. Defaults to File.
        """
        pulumi.set(__self__, "endpoint_name", endpoint_name)
        pulumi.set(__self__, "local_path", local_path)
        if exclude_features_attribute is not None:
            pulumi.set(__self__, "exclude_features_attribute", exclude_features_attribute)
        if s3_data_distribution_type is not None:
            pulumi.set(__self__, "s3_data_distribution_type", s3_data_distribution_type)
        if s3_input_mode is not None:
            pulumi.set(__self__, "s3_input_mode", s3_input_mode)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> str:
        """
        An endpoint in customer's account which has enabled `DataCaptureConfig` enabled.
        """
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> str:
        """
        Path to the filesystem where the endpoint data is available to the container.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter(name="excludeFeaturesAttribute")
    def exclude_features_attribute(self) -> Optional[str]:
        """
        Indexes or names of the features to be excluded from analysis
        """
        return pulumi.get(self, "exclude_features_attribute")

    @property
    @pulumi.getter(name="s3DataDistributionType")
    def s3_data_distribution_type(self) -> Optional['DataQualityJobDefinitionEndpointInputS3DataDistributionType']:
        """
        Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to FullyReplicated
        """
        return pulumi.get(self, "s3_data_distribution_type")

    @property
    @pulumi.getter(name="s3InputMode")
    def s3_input_mode(self) -> Optional['DataQualityJobDefinitionEndpointInputS3InputMode']:
        """
        Whether the Pipe or File is used as the input mode for transfering data for the monitoring job. Pipe mode is recommended for large datasets. File mode is useful for small files that fit in memory. Defaults to File.
        """
        return pulumi.get(self, "s3_input_mode")


@pulumi.output_type
class DataQualityJobDefinitionJson(dict):
    """
    The Json format
    """
    def __init__(__self__, *,
                 line: Optional[bool] = None):
        """
        The Json format
        :param bool line: A boolean flag indicating if it is JSON line format
        """
        if line is not None:
            pulumi.set(__self__, "line", line)

    @property
    @pulumi.getter
    def line(self) -> Optional[bool]:
        """
        A boolean flag indicating if it is JSON line format
        """
        return pulumi.get(self, "line")


@pulumi.output_type
class DataQualityJobDefinitionMonitoringOutput(dict):
    """
    The output object for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Output":
            suggest = "s3_output"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataQualityJobDefinitionMonitoringOutput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataQualityJobDefinitionMonitoringOutput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataQualityJobDefinitionMonitoringOutput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_output: 'outputs.DataQualityJobDefinitionS3Output'):
        """
        The output object for a monitoring job.
        :param 'DataQualityJobDefinitionS3Output' s3_output: The Amazon S3 storage location where the results of a monitoring job are saved.
        """
        pulumi.set(__self__, "s3_output", s3_output)

    @property
    @pulumi.getter(name="s3Output")
    def s3_output(self) -> 'outputs.DataQualityJobDefinitionS3Output':
        """
        The Amazon S3 storage location where the results of a monitoring job are saved.
        """
        return pulumi.get(self, "s3_output")


@pulumi.output_type
class DataQualityJobDefinitionMonitoringOutputConfig(dict):
    """
    The output configuration for monitoring jobs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "monitoringOutputs":
            suggest = "monitoring_outputs"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataQualityJobDefinitionMonitoringOutputConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataQualityJobDefinitionMonitoringOutputConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataQualityJobDefinitionMonitoringOutputConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 monitoring_outputs: Sequence['outputs.DataQualityJobDefinitionMonitoringOutput'],
                 kms_key_id: Optional[str] = None):
        """
        The output configuration for monitoring jobs.
        :param Sequence['DataQualityJobDefinitionMonitoringOutput'] monitoring_outputs: Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
        :param str kms_key_id: The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
        """
        pulumi.set(__self__, "monitoring_outputs", monitoring_outputs)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="monitoringOutputs")
    def monitoring_outputs(self) -> Sequence['outputs.DataQualityJobDefinitionMonitoringOutput']:
        """
        Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
        """
        return pulumi.get(self, "monitoring_outputs")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class DataQualityJobDefinitionMonitoringResources(dict):
    """
    Identifies the resources to deploy for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterConfig":
            suggest = "cluster_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataQualityJobDefinitionMonitoringResources. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataQualityJobDefinitionMonitoringResources.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataQualityJobDefinitionMonitoringResources.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_config: 'outputs.DataQualityJobDefinitionClusterConfig'):
        """
        Identifies the resources to deploy for a monitoring job.
        :param 'DataQualityJobDefinitionClusterConfig' cluster_config: The configuration for the cluster resources used to run the processing job.
        """
        pulumi.set(__self__, "cluster_config", cluster_config)

    @property
    @pulumi.getter(name="clusterConfig")
    def cluster_config(self) -> 'outputs.DataQualityJobDefinitionClusterConfig':
        """
        The configuration for the cluster resources used to run the processing job.
        """
        return pulumi.get(self, "cluster_config")


@pulumi.output_type
class DataQualityJobDefinitionNetworkConfig(dict):
    """
    Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableInterContainerTrafficEncryption":
            suggest = "enable_inter_container_traffic_encryption"
        elif key == "enableNetworkIsolation":
            suggest = "enable_network_isolation"
        elif key == "vpcConfig":
            suggest = "vpc_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataQualityJobDefinitionNetworkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataQualityJobDefinitionNetworkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataQualityJobDefinitionNetworkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_inter_container_traffic_encryption: Optional[bool] = None,
                 enable_network_isolation: Optional[bool] = None,
                 vpc_config: Optional['outputs.DataQualityJobDefinitionVpcConfig'] = None):
        """
        Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
        :param bool enable_inter_container_traffic_encryption: Whether to encrypt all communications between distributed processing jobs. Choose True to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
        :param bool enable_network_isolation: Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
        :param 'DataQualityJobDefinitionVpcConfig' vpc_config: Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.
        """
        if enable_inter_container_traffic_encryption is not None:
            pulumi.set(__self__, "enable_inter_container_traffic_encryption", enable_inter_container_traffic_encryption)
        if enable_network_isolation is not None:
            pulumi.set(__self__, "enable_network_isolation", enable_network_isolation)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @property
    @pulumi.getter(name="enableInterContainerTrafficEncryption")
    def enable_inter_container_traffic_encryption(self) -> Optional[bool]:
        """
        Whether to encrypt all communications between distributed processing jobs. Choose True to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
        """
        return pulumi.get(self, "enable_inter_container_traffic_encryption")

    @property
    @pulumi.getter(name="enableNetworkIsolation")
    def enable_network_isolation(self) -> Optional[bool]:
        """
        Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
        """
        return pulumi.get(self, "enable_network_isolation")

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional['outputs.DataQualityJobDefinitionVpcConfig']:
        """
        Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.
        """
        return pulumi.get(self, "vpc_config")


@pulumi.output_type
class DataQualityJobDefinitionS3Output(dict):
    """
    Information about where and how to store the results of a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localPath":
            suggest = "local_path"
        elif key == "s3Uri":
            suggest = "s3_uri"
        elif key == "s3UploadMode":
            suggest = "s3_upload_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataQualityJobDefinitionS3Output. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataQualityJobDefinitionS3Output.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataQualityJobDefinitionS3Output.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_path: str,
                 s3_uri: str,
                 s3_upload_mode: Optional['DataQualityJobDefinitionS3OutputS3UploadMode'] = None):
        """
        Information about where and how to store the results of a monitoring job.
        :param str local_path: The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. LocalPath is an absolute path for the output data.
        :param str s3_uri: A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
        :param 'DataQualityJobDefinitionS3OutputS3UploadMode' s3_upload_mode: Whether to upload the results of the monitoring job continuously or after the job completes.
        """
        pulumi.set(__self__, "local_path", local_path)
        pulumi.set(__self__, "s3_uri", s3_uri)
        if s3_upload_mode is not None:
            pulumi.set(__self__, "s3_upload_mode", s3_upload_mode)

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> str:
        """
        The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. LocalPath is an absolute path for the output data.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> str:
        """
        A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
        """
        return pulumi.get(self, "s3_uri")

    @property
    @pulumi.getter(name="s3UploadMode")
    def s3_upload_mode(self) -> Optional['DataQualityJobDefinitionS3OutputS3UploadMode']:
        """
        Whether to upload the results of the monitoring job continuously or after the job completes.
        """
        return pulumi.get(self, "s3_upload_mode")


@pulumi.output_type
class DataQualityJobDefinitionStatisticsResource(dict):
    """
    The baseline statistics resource for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Uri":
            suggest = "s3_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataQualityJobDefinitionStatisticsResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataQualityJobDefinitionStatisticsResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataQualityJobDefinitionStatisticsResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_uri: Optional[str] = None):
        """
        The baseline statistics resource for a monitoring job.
        :param str s3_uri: The Amazon S3 URI for the baseline statistics file in Amazon S3 that the current monitoring job should be validated against.
        """
        if s3_uri is not None:
            pulumi.set(__self__, "s3_uri", s3_uri)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> Optional[str]:
        """
        The Amazon S3 URI for the baseline statistics file in Amazon S3 that the current monitoring job should be validated against.
        """
        return pulumi.get(self, "s3_uri")


@pulumi.output_type
class DataQualityJobDefinitionStoppingCondition(dict):
    """
    Specifies a time limit for how long the monitoring job is allowed to run.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxRuntimeInSeconds":
            suggest = "max_runtime_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataQualityJobDefinitionStoppingCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataQualityJobDefinitionStoppingCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataQualityJobDefinitionStoppingCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_runtime_in_seconds: int):
        """
        Specifies a time limit for how long the monitoring job is allowed to run.
        :param int max_runtime_in_seconds: The maximum runtime allowed in seconds.
        """
        pulumi.set(__self__, "max_runtime_in_seconds", max_runtime_in_seconds)

    @property
    @pulumi.getter(name="maxRuntimeInSeconds")
    def max_runtime_in_seconds(self) -> int:
        """
        The maximum runtime allowed in seconds.
        """
        return pulumi.get(self, "max_runtime_in_seconds")


@pulumi.output_type
class DataQualityJobDefinitionVpcConfig(dict):
    """
    Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupIds":
            suggest = "security_group_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataQualityJobDefinitionVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataQualityJobDefinitionVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataQualityJobDefinitionVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_ids: Sequence[str],
                 subnets: Sequence[str]):
        """
        Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.
        :param Sequence[str] security_group_ids: The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the Subnets field.
        :param Sequence[str] subnets: The ID of the subnets in the VPC to which you want to connect to your monitoring jobs.
        """
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[str]:
        """
        The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the Subnets field.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[str]:
        """
        The ID of the subnets in the VPC to which you want to connect to your monitoring jobs.
        """
        return pulumi.get(self, "subnets")


@pulumi.output_type
class Device(dict):
    """
    Edge device you want to create
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceName":
            suggest = "device_name"
        elif key == "iotThingName":
            suggest = "iot_thing_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Device. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Device.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Device.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_name: str,
                 description: Optional[str] = None,
                 iot_thing_name: Optional[str] = None):
        """
        Edge device you want to create
        :param str device_name: The name of the device
        :param str description: Description of the device
        :param str iot_thing_name: AWS Internet of Things (IoT) object name.
        """
        pulumi.set(__self__, "device_name", device_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if iot_thing_name is not None:
            pulumi.set(__self__, "iot_thing_name", iot_thing_name)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> str:
        """
        The name of the device
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the device
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="iotThingName")
    def iot_thing_name(self) -> Optional[str]:
        """
        AWS Internet of Things (IoT) object name.
        """
        return pulumi.get(self, "iot_thing_name")


@pulumi.output_type
class DeviceFleetEdgeOutputConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3OutputLocation":
            suggest = "s3_output_location"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceFleetEdgeOutputConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceFleetEdgeOutputConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceFleetEdgeOutputConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_output_location: str,
                 kms_key_id: Optional[str] = None):
        """
        :param str s3_output_location: The Amazon Simple Storage (S3) bucket URI
        :param str kms_key_id: The KMS key id used for encryption on the S3 bucket
        """
        pulumi.set(__self__, "s3_output_location", s3_output_location)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="s3OutputLocation")
    def s3_output_location(self) -> str:
        """
        The Amazon Simple Storage (S3) bucket URI
        """
        return pulumi.get(self, "s3_output_location")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The KMS key id used for encryption on the S3 bucket
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class DomainAppLifecycleManagement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idleSettings":
            suggest = "idle_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainAppLifecycleManagement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainAppLifecycleManagement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainAppLifecycleManagement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 idle_settings: Optional['outputs.DomainIdleSettings'] = None):
        """
        :param 'DomainIdleSettings' idle_settings: Settings related to idle shutdown of Studio applications.
        """
        if idle_settings is not None:
            pulumi.set(__self__, "idle_settings", idle_settings)

    @property
    @pulumi.getter(name="idleSettings")
    def idle_settings(self) -> Optional['outputs.DomainIdleSettings']:
        """
        Settings related to idle shutdown of Studio applications.
        """
        return pulumi.get(self, "idle_settings")


@pulumi.output_type
class DomainCodeEditorAppSettings(dict):
    """
    The CodeEditor app settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appLifecycleManagement":
            suggest = "app_lifecycle_management"
        elif key == "customImages":
            suggest = "custom_images"
        elif key == "defaultResourceSpec":
            suggest = "default_resource_spec"
        elif key == "lifecycleConfigArns":
            suggest = "lifecycle_config_arns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainCodeEditorAppSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainCodeEditorAppSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainCodeEditorAppSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_lifecycle_management: Optional['outputs.DomainAppLifecycleManagement'] = None,
                 custom_images: Optional[Sequence['outputs.DomainCustomImage']] = None,
                 default_resource_spec: Optional['outputs.DomainResourceSpec'] = None,
                 lifecycle_config_arns: Optional[Sequence[str]] = None):
        """
        The CodeEditor app settings.
        :param 'DomainAppLifecycleManagement' app_lifecycle_management: Settings that are used to configure and manage the lifecycle of CodeEditor applications.
        :param Sequence['DomainCustomImage'] custom_images: A list of custom images for use for CodeEditor apps.
        :param 'DomainResourceSpec' default_resource_spec: The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the CodeEditor app.
        :param Sequence[str] lifecycle_config_arns: A list of LifecycleConfigArns available for use with CodeEditor apps.
        """
        if app_lifecycle_management is not None:
            pulumi.set(__self__, "app_lifecycle_management", app_lifecycle_management)
        if custom_images is not None:
            pulumi.set(__self__, "custom_images", custom_images)
        if default_resource_spec is not None:
            pulumi.set(__self__, "default_resource_spec", default_resource_spec)
        if lifecycle_config_arns is not None:
            pulumi.set(__self__, "lifecycle_config_arns", lifecycle_config_arns)

    @property
    @pulumi.getter(name="appLifecycleManagement")
    def app_lifecycle_management(self) -> Optional['outputs.DomainAppLifecycleManagement']:
        """
        Settings that are used to configure and manage the lifecycle of CodeEditor applications.
        """
        return pulumi.get(self, "app_lifecycle_management")

    @property
    @pulumi.getter(name="customImages")
    def custom_images(self) -> Optional[Sequence['outputs.DomainCustomImage']]:
        """
        A list of custom images for use for CodeEditor apps.
        """
        return pulumi.get(self, "custom_images")

    @property
    @pulumi.getter(name="defaultResourceSpec")
    def default_resource_spec(self) -> Optional['outputs.DomainResourceSpec']:
        """
        The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the CodeEditor app.
        """
        return pulumi.get(self, "default_resource_spec")

    @property
    @pulumi.getter(name="lifecycleConfigArns")
    def lifecycle_config_arns(self) -> Optional[Sequence[str]]:
        """
        A list of LifecycleConfigArns available for use with CodeEditor apps.
        """
        return pulumi.get(self, "lifecycle_config_arns")


@pulumi.output_type
class DomainCodeRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repositoryUrl":
            suggest = "repository_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainCodeRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainCodeRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainCodeRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repository_url: str):
        """
        :param str repository_url: A CodeRepository (valid URL) to be used within Jupyter's Git extension.
        """
        pulumi.set(__self__, "repository_url", repository_url)

    @property
    @pulumi.getter(name="repositoryUrl")
    def repository_url(self) -> str:
        """
        A CodeRepository (valid URL) to be used within Jupyter's Git extension.
        """
        return pulumi.get(self, "repository_url")


@pulumi.output_type
class DomainCustomFileSystemConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "efsFileSystemConfig":
            suggest = "efs_file_system_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainCustomFileSystemConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainCustomFileSystemConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainCustomFileSystemConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 efs_file_system_config: Optional['outputs.DomainEfsFileSystemConfig'] = None):
        """
        :param 'DomainEfsFileSystemConfig' efs_file_system_config: The settings for a custom Amazon EFS file system.
        """
        if efs_file_system_config is not None:
            pulumi.set(__self__, "efs_file_system_config", efs_file_system_config)

    @property
    @pulumi.getter(name="efsFileSystemConfig")
    def efs_file_system_config(self) -> Optional['outputs.DomainEfsFileSystemConfig']:
        """
        The settings for a custom Amazon EFS file system.
        """
        return pulumi.get(self, "efs_file_system_config")


@pulumi.output_type
class DomainCustomImage(dict):
    """
    A custom SageMaker image.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appImageConfigName":
            suggest = "app_image_config_name"
        elif key == "imageName":
            suggest = "image_name"
        elif key == "imageVersionNumber":
            suggest = "image_version_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainCustomImage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainCustomImage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainCustomImage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_image_config_name: str,
                 image_name: str,
                 image_version_number: Optional[int] = None):
        """
        A custom SageMaker image.
        :param str app_image_config_name: The Name of the AppImageConfig.
        :param str image_name: The name of the CustomImage. Must be unique to your account.
        :param int image_version_number: The version number of the CustomImage.
        """
        pulumi.set(__self__, "app_image_config_name", app_image_config_name)
        pulumi.set(__self__, "image_name", image_name)
        if image_version_number is not None:
            pulumi.set(__self__, "image_version_number", image_version_number)

    @property
    @pulumi.getter(name="appImageConfigName")
    def app_image_config_name(self) -> str:
        """
        The Name of the AppImageConfig.
        """
        return pulumi.get(self, "app_image_config_name")

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> str:
        """
        The name of the CustomImage. Must be unique to your account.
        """
        return pulumi.get(self, "image_name")

    @property
    @pulumi.getter(name="imageVersionNumber")
    def image_version_number(self) -> Optional[int]:
        """
        The version number of the CustomImage.
        """
        return pulumi.get(self, "image_version_number")


@pulumi.output_type
class DomainCustomPosixUserConfig(dict):
    def __init__(__self__, *,
                 gid: int,
                 uid: int):
        """
        :param int gid: The POSIX group ID.
        :param int uid: The POSIX user ID.
        """
        pulumi.set(__self__, "gid", gid)
        pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def gid(self) -> int:
        """
        The POSIX group ID.
        """
        return pulumi.get(self, "gid")

    @property
    @pulumi.getter
    def uid(self) -> int:
        """
        The POSIX user ID.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class DomainDefaultEbsStorageSettings(dict):
    """
    Properties related to the Amazon Elastic Block Store volume. Must be provided if storage type is Amazon EBS and must not be provided if storage type is not Amazon EBS
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultEbsVolumeSizeInGb":
            suggest = "default_ebs_volume_size_in_gb"
        elif key == "maximumEbsVolumeSizeInGb":
            suggest = "maximum_ebs_volume_size_in_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainDefaultEbsStorageSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainDefaultEbsStorageSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainDefaultEbsStorageSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_ebs_volume_size_in_gb: int,
                 maximum_ebs_volume_size_in_gb: int):
        """
        Properties related to the Amazon Elastic Block Store volume. Must be provided if storage type is Amazon EBS and must not be provided if storage type is not Amazon EBS
        :param int default_ebs_volume_size_in_gb: Default size of the Amazon EBS volume in Gb
        :param int maximum_ebs_volume_size_in_gb: Maximum size of the Amazon EBS volume in Gb. Must be greater than or equal to the DefaultEbsVolumeSizeInGb.
        """
        pulumi.set(__self__, "default_ebs_volume_size_in_gb", default_ebs_volume_size_in_gb)
        pulumi.set(__self__, "maximum_ebs_volume_size_in_gb", maximum_ebs_volume_size_in_gb)

    @property
    @pulumi.getter(name="defaultEbsVolumeSizeInGb")
    def default_ebs_volume_size_in_gb(self) -> int:
        """
        Default size of the Amazon EBS volume in Gb
        """
        return pulumi.get(self, "default_ebs_volume_size_in_gb")

    @property
    @pulumi.getter(name="maximumEbsVolumeSizeInGb")
    def maximum_ebs_volume_size_in_gb(self) -> int:
        """
        Maximum size of the Amazon EBS volume in Gb. Must be greater than or equal to the DefaultEbsVolumeSizeInGb.
        """
        return pulumi.get(self, "maximum_ebs_volume_size_in_gb")


@pulumi.output_type
class DomainDefaultSpaceSettings(dict):
    """
    A collection of settings that apply to spaces of Amazon SageMaker Studio. These settings are specified when the Create/Update Domain API is called.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionRole":
            suggest = "execution_role"
        elif key == "customFileSystemConfigs":
            suggest = "custom_file_system_configs"
        elif key == "customPosixUserConfig":
            suggest = "custom_posix_user_config"
        elif key == "jupyterLabAppSettings":
            suggest = "jupyter_lab_app_settings"
        elif key == "jupyterServerAppSettings":
            suggest = "jupyter_server_app_settings"
        elif key == "kernelGatewayAppSettings":
            suggest = "kernel_gateway_app_settings"
        elif key == "securityGroups":
            suggest = "security_groups"
        elif key == "spaceStorageSettings":
            suggest = "space_storage_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainDefaultSpaceSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainDefaultSpaceSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainDefaultSpaceSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_role: str,
                 custom_file_system_configs: Optional[Sequence['outputs.DomainCustomFileSystemConfig']] = None,
                 custom_posix_user_config: Optional['outputs.DomainCustomPosixUserConfig'] = None,
                 jupyter_lab_app_settings: Optional['outputs.DomainJupyterLabAppSettings'] = None,
                 jupyter_server_app_settings: Optional['outputs.DomainJupyterServerAppSettings'] = None,
                 kernel_gateway_app_settings: Optional['outputs.DomainKernelGatewayAppSettings'] = None,
                 security_groups: Optional[Sequence[str]] = None,
                 space_storage_settings: Optional['outputs.DomainDefaultSpaceStorageSettings'] = None):
        """
        A collection of settings that apply to spaces of Amazon SageMaker Studio. These settings are specified when the Create/Update Domain API is called.
        :param str execution_role: The execution role for the space.
        :param Sequence['DomainCustomFileSystemConfig'] custom_file_system_configs: The settings for assigning a custom file system to a domain. Permitted users can access this file system in Amazon SageMaker Studio.
        :param 'DomainCustomPosixUserConfig' custom_posix_user_config: The Jupyter lab's custom posix user configurations.
        :param 'DomainJupyterLabAppSettings' jupyter_lab_app_settings: The Jupyter lab's app settings.
        :param 'DomainJupyterServerAppSettings' jupyter_server_app_settings: The Jupyter server's app settings.
        :param 'DomainKernelGatewayAppSettings' kernel_gateway_app_settings: The kernel gateway app settings.
        :param Sequence[str] security_groups: The security groups for the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
        :param 'DomainDefaultSpaceStorageSettings' space_storage_settings: The Jupyter lab's space storage settings.
        """
        pulumi.set(__self__, "execution_role", execution_role)
        if custom_file_system_configs is not None:
            pulumi.set(__self__, "custom_file_system_configs", custom_file_system_configs)
        if custom_posix_user_config is not None:
            pulumi.set(__self__, "custom_posix_user_config", custom_posix_user_config)
        if jupyter_lab_app_settings is not None:
            pulumi.set(__self__, "jupyter_lab_app_settings", jupyter_lab_app_settings)
        if jupyter_server_app_settings is not None:
            pulumi.set(__self__, "jupyter_server_app_settings", jupyter_server_app_settings)
        if kernel_gateway_app_settings is not None:
            pulumi.set(__self__, "kernel_gateway_app_settings", kernel_gateway_app_settings)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if space_storage_settings is not None:
            pulumi.set(__self__, "space_storage_settings", space_storage_settings)

    @property
    @pulumi.getter(name="executionRole")
    def execution_role(self) -> str:
        """
        The execution role for the space.
        """
        return pulumi.get(self, "execution_role")

    @property
    @pulumi.getter(name="customFileSystemConfigs")
    def custom_file_system_configs(self) -> Optional[Sequence['outputs.DomainCustomFileSystemConfig']]:
        """
        The settings for assigning a custom file system to a domain. Permitted users can access this file system in Amazon SageMaker Studio.
        """
        return pulumi.get(self, "custom_file_system_configs")

    @property
    @pulumi.getter(name="customPosixUserConfig")
    def custom_posix_user_config(self) -> Optional['outputs.DomainCustomPosixUserConfig']:
        """
        The Jupyter lab's custom posix user configurations.
        """
        return pulumi.get(self, "custom_posix_user_config")

    @property
    @pulumi.getter(name="jupyterLabAppSettings")
    def jupyter_lab_app_settings(self) -> Optional['outputs.DomainJupyterLabAppSettings']:
        """
        The Jupyter lab's app settings.
        """
        return pulumi.get(self, "jupyter_lab_app_settings")

    @property
    @pulumi.getter(name="jupyterServerAppSettings")
    def jupyter_server_app_settings(self) -> Optional['outputs.DomainJupyterServerAppSettings']:
        """
        The Jupyter server's app settings.
        """
        return pulumi.get(self, "jupyter_server_app_settings")

    @property
    @pulumi.getter(name="kernelGatewayAppSettings")
    def kernel_gateway_app_settings(self) -> Optional['outputs.DomainKernelGatewayAppSettings']:
        """
        The kernel gateway app settings.
        """
        return pulumi.get(self, "kernel_gateway_app_settings")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[Sequence[str]]:
        """
        The security groups for the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter(name="spaceStorageSettings")
    def space_storage_settings(self) -> Optional['outputs.DomainDefaultSpaceStorageSettings']:
        """
        The Jupyter lab's space storage settings.
        """
        return pulumi.get(self, "space_storage_settings")


@pulumi.output_type
class DomainDefaultSpaceStorageSettings(dict):
    """
    Default storage settings for a space.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultEbsStorageSettings":
            suggest = "default_ebs_storage_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainDefaultSpaceStorageSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainDefaultSpaceStorageSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainDefaultSpaceStorageSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_ebs_storage_settings: Optional['outputs.DomainDefaultEbsStorageSettings'] = None):
        """
        Default storage settings for a space.
        :param 'DomainDefaultEbsStorageSettings' default_ebs_storage_settings: The default EBS storage settings for a space.
        """
        if default_ebs_storage_settings is not None:
            pulumi.set(__self__, "default_ebs_storage_settings", default_ebs_storage_settings)

    @property
    @pulumi.getter(name="defaultEbsStorageSettings")
    def default_ebs_storage_settings(self) -> Optional['outputs.DomainDefaultEbsStorageSettings']:
        """
        The default EBS storage settings for a space.
        """
        return pulumi.get(self, "default_ebs_storage_settings")


@pulumi.output_type
class DomainDockerSettings(dict):
    """
    A collection of settings that are required to start docker-proxy server.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableDockerAccess":
            suggest = "enable_docker_access"
        elif key == "vpcOnlyTrustedAccounts":
            suggest = "vpc_only_trusted_accounts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainDockerSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainDockerSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainDockerSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_docker_access: Optional['DomainDockerSettingsEnableDockerAccess'] = None,
                 vpc_only_trusted_accounts: Optional[Sequence[str]] = None):
        """
        A collection of settings that are required to start docker-proxy server.
        :param 'DomainDockerSettingsEnableDockerAccess' enable_docker_access: The flag to enable/disable docker-proxy server
        :param Sequence[str] vpc_only_trusted_accounts: A list of account id's that would be used to pull images from in VpcOnly mode
        """
        if enable_docker_access is not None:
            pulumi.set(__self__, "enable_docker_access", enable_docker_access)
        if vpc_only_trusted_accounts is not None:
            pulumi.set(__self__, "vpc_only_trusted_accounts", vpc_only_trusted_accounts)

    @property
    @pulumi.getter(name="enableDockerAccess")
    def enable_docker_access(self) -> Optional['DomainDockerSettingsEnableDockerAccess']:
        """
        The flag to enable/disable docker-proxy server
        """
        return pulumi.get(self, "enable_docker_access")

    @property
    @pulumi.getter(name="vpcOnlyTrustedAccounts")
    def vpc_only_trusted_accounts(self) -> Optional[Sequence[str]]:
        """
        A list of account id's that would be used to pull images from in VpcOnly mode
        """
        return pulumi.get(self, "vpc_only_trusted_accounts")


@pulumi.output_type
class DomainEfsFileSystemConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileSystemId":
            suggest = "file_system_id"
        elif key == "fileSystemPath":
            suggest = "file_system_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainEfsFileSystemConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainEfsFileSystemConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainEfsFileSystemConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_system_id: str,
                 file_system_path: Optional[str] = None):
        """
        :param str file_system_id: The ID of your Amazon EFS file system.
        :param str file_system_path: The path to the file system directory that is accessible in Amazon SageMaker Studio. Permitted users can access only this directory and below.
        """
        pulumi.set(__self__, "file_system_id", file_system_id)
        if file_system_path is not None:
            pulumi.set(__self__, "file_system_path", file_system_path)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> str:
        """
        The ID of your Amazon EFS file system.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter(name="fileSystemPath")
    def file_system_path(self) -> Optional[str]:
        """
        The path to the file system directory that is accessible in Amazon SageMaker Studio. Permitted users can access only this directory and below.
        """
        return pulumi.get(self, "file_system_path")


@pulumi.output_type
class DomainIdleSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idleTimeoutInMinutes":
            suggest = "idle_timeout_in_minutes"
        elif key == "lifecycleManagement":
            suggest = "lifecycle_management"
        elif key == "maxIdleTimeoutInMinutes":
            suggest = "max_idle_timeout_in_minutes"
        elif key == "minIdleTimeoutInMinutes":
            suggest = "min_idle_timeout_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainIdleSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainIdleSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainIdleSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 idle_timeout_in_minutes: Optional[int] = None,
                 lifecycle_management: Optional['DomainLifecycleManagement'] = None,
                 max_idle_timeout_in_minutes: Optional[int] = None,
                 min_idle_timeout_in_minutes: Optional[int] = None):
        """
        :param int idle_timeout_in_minutes: The time that SageMaker waits after the application becomes idle before shutting it down.
        :param 'DomainLifecycleManagement' lifecycle_management: Indicates whether idle shutdown is activated for the application type.
        :param int max_idle_timeout_in_minutes: The maximum value in minutes that custom idle shutdown can be set to by the user.
        :param int min_idle_timeout_in_minutes: The minimum value in minutes that custom idle shutdown can be set to by the user.
        """
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if lifecycle_management is not None:
            pulumi.set(__self__, "lifecycle_management", lifecycle_management)
        if max_idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "max_idle_timeout_in_minutes", max_idle_timeout_in_minutes)
        if min_idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "min_idle_timeout_in_minutes", min_idle_timeout_in_minutes)

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[int]:
        """
        The time that SageMaker waits after the application becomes idle before shutting it down.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @property
    @pulumi.getter(name="lifecycleManagement")
    def lifecycle_management(self) -> Optional['DomainLifecycleManagement']:
        """
        Indicates whether idle shutdown is activated for the application type.
        """
        return pulumi.get(self, "lifecycle_management")

    @property
    @pulumi.getter(name="maxIdleTimeoutInMinutes")
    def max_idle_timeout_in_minutes(self) -> Optional[int]:
        """
        The maximum value in minutes that custom idle shutdown can be set to by the user.
        """
        return pulumi.get(self, "max_idle_timeout_in_minutes")

    @property
    @pulumi.getter(name="minIdleTimeoutInMinutes")
    def min_idle_timeout_in_minutes(self) -> Optional[int]:
        """
        The minimum value in minutes that custom idle shutdown can be set to by the user.
        """
        return pulumi.get(self, "min_idle_timeout_in_minutes")


@pulumi.output_type
class DomainJupyterLabAppSettings(dict):
    """
    The JupyterLab app settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appLifecycleManagement":
            suggest = "app_lifecycle_management"
        elif key == "codeRepositories":
            suggest = "code_repositories"
        elif key == "customImages":
            suggest = "custom_images"
        elif key == "defaultResourceSpec":
            suggest = "default_resource_spec"
        elif key == "lifecycleConfigArns":
            suggest = "lifecycle_config_arns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainJupyterLabAppSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainJupyterLabAppSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainJupyterLabAppSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_lifecycle_management: Optional['outputs.DomainAppLifecycleManagement'] = None,
                 code_repositories: Optional[Sequence['outputs.DomainCodeRepository']] = None,
                 custom_images: Optional[Sequence['outputs.DomainCustomImage']] = None,
                 default_resource_spec: Optional['outputs.DomainResourceSpec'] = None,
                 lifecycle_config_arns: Optional[Sequence[str]] = None):
        """
        The JupyterLab app settings.
        :param 'DomainAppLifecycleManagement' app_lifecycle_management: Indicates whether idle shutdown is activated for JupyterLab applications.
        :param Sequence['DomainCodeRepository'] code_repositories: A list of CodeRepositories available for use with JupyterLab apps.
        :param Sequence['DomainCustomImage'] custom_images: A list of custom images for use for JupyterLab apps.
        :param 'DomainResourceSpec' default_resource_spec: The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterLab app.
        :param Sequence[str] lifecycle_config_arns: A list of LifecycleConfigArns available for use with JupyterLab apps.
        """
        if app_lifecycle_management is not None:
            pulumi.set(__self__, "app_lifecycle_management", app_lifecycle_management)
        if code_repositories is not None:
            pulumi.set(__self__, "code_repositories", code_repositories)
        if custom_images is not None:
            pulumi.set(__self__, "custom_images", custom_images)
        if default_resource_spec is not None:
            pulumi.set(__self__, "default_resource_spec", default_resource_spec)
        if lifecycle_config_arns is not None:
            pulumi.set(__self__, "lifecycle_config_arns", lifecycle_config_arns)

    @property
    @pulumi.getter(name="appLifecycleManagement")
    def app_lifecycle_management(self) -> Optional['outputs.DomainAppLifecycleManagement']:
        """
        Indicates whether idle shutdown is activated for JupyterLab applications.
        """
        return pulumi.get(self, "app_lifecycle_management")

    @property
    @pulumi.getter(name="codeRepositories")
    def code_repositories(self) -> Optional[Sequence['outputs.DomainCodeRepository']]:
        """
        A list of CodeRepositories available for use with JupyterLab apps.
        """
        return pulumi.get(self, "code_repositories")

    @property
    @pulumi.getter(name="customImages")
    def custom_images(self) -> Optional[Sequence['outputs.DomainCustomImage']]:
        """
        A list of custom images for use for JupyterLab apps.
        """
        return pulumi.get(self, "custom_images")

    @property
    @pulumi.getter(name="defaultResourceSpec")
    def default_resource_spec(self) -> Optional['outputs.DomainResourceSpec']:
        """
        The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterLab app.
        """
        return pulumi.get(self, "default_resource_spec")

    @property
    @pulumi.getter(name="lifecycleConfigArns")
    def lifecycle_config_arns(self) -> Optional[Sequence[str]]:
        """
        A list of LifecycleConfigArns available for use with JupyterLab apps.
        """
        return pulumi.get(self, "lifecycle_config_arns")


@pulumi.output_type
class DomainJupyterServerAppSettings(dict):
    """
    The JupyterServer app settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultResourceSpec":
            suggest = "default_resource_spec"
        elif key == "lifecycleConfigArns":
            suggest = "lifecycle_config_arns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainJupyterServerAppSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainJupyterServerAppSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainJupyterServerAppSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_resource_spec: Optional['outputs.DomainResourceSpec'] = None,
                 lifecycle_config_arns: Optional[Sequence[str]] = None):
        """
        The JupyterServer app settings.
        :param 'DomainResourceSpec' default_resource_spec: The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterServer app.
        :param Sequence[str] lifecycle_config_arns: A list of LifecycleConfigArns available for use with JupyterServer apps.
        """
        if default_resource_spec is not None:
            pulumi.set(__self__, "default_resource_spec", default_resource_spec)
        if lifecycle_config_arns is not None:
            pulumi.set(__self__, "lifecycle_config_arns", lifecycle_config_arns)

    @property
    @pulumi.getter(name="defaultResourceSpec")
    def default_resource_spec(self) -> Optional['outputs.DomainResourceSpec']:
        """
        The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterServer app.
        """
        return pulumi.get(self, "default_resource_spec")

    @property
    @pulumi.getter(name="lifecycleConfigArns")
    def lifecycle_config_arns(self) -> Optional[Sequence[str]]:
        """
        A list of LifecycleConfigArns available for use with JupyterServer apps.
        """
        return pulumi.get(self, "lifecycle_config_arns")


@pulumi.output_type
class DomainKernelGatewayAppSettings(dict):
    """
    The kernel gateway app settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customImages":
            suggest = "custom_images"
        elif key == "defaultResourceSpec":
            suggest = "default_resource_spec"
        elif key == "lifecycleConfigArns":
            suggest = "lifecycle_config_arns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainKernelGatewayAppSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainKernelGatewayAppSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainKernelGatewayAppSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_images: Optional[Sequence['outputs.DomainCustomImage']] = None,
                 default_resource_spec: Optional['outputs.DomainResourceSpec'] = None,
                 lifecycle_config_arns: Optional[Sequence[str]] = None):
        """
        The kernel gateway app settings.
        :param Sequence['DomainCustomImage'] custom_images: A list of custom SageMaker images that are configured to run as a KernelGateway app.
        :param 'DomainResourceSpec' default_resource_spec: The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the KernelGateway app.
        :param Sequence[str] lifecycle_config_arns: A list of LifecycleConfigArns available for use with KernelGateway apps.
        """
        if custom_images is not None:
            pulumi.set(__self__, "custom_images", custom_images)
        if default_resource_spec is not None:
            pulumi.set(__self__, "default_resource_spec", default_resource_spec)
        if lifecycle_config_arns is not None:
            pulumi.set(__self__, "lifecycle_config_arns", lifecycle_config_arns)

    @property
    @pulumi.getter(name="customImages")
    def custom_images(self) -> Optional[Sequence['outputs.DomainCustomImage']]:
        """
        A list of custom SageMaker images that are configured to run as a KernelGateway app.
        """
        return pulumi.get(self, "custom_images")

    @property
    @pulumi.getter(name="defaultResourceSpec")
    def default_resource_spec(self) -> Optional['outputs.DomainResourceSpec']:
        """
        The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the KernelGateway app.
        """
        return pulumi.get(self, "default_resource_spec")

    @property
    @pulumi.getter(name="lifecycleConfigArns")
    def lifecycle_config_arns(self) -> Optional[Sequence[str]]:
        """
        A list of LifecycleConfigArns available for use with KernelGateway apps.
        """
        return pulumi.get(self, "lifecycle_config_arns")


@pulumi.output_type
class DomainRSessionAppSettings(dict):
    """
    A collection of settings that apply to an RSessionGateway app.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customImages":
            suggest = "custom_images"
        elif key == "defaultResourceSpec":
            suggest = "default_resource_spec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainRSessionAppSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainRSessionAppSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainRSessionAppSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_images: Optional[Sequence['outputs.DomainCustomImage']] = None,
                 default_resource_spec: Optional['outputs.DomainResourceSpec'] = None):
        """
        A collection of settings that apply to an RSessionGateway app.
        :param Sequence['DomainCustomImage'] custom_images: A list of custom SageMaker images that are configured to run as a KernelGateway app.
        :param 'DomainResourceSpec' default_resource_spec: Specifies the ARNs of a SageMaker image and SageMaker image version, and the instance type that the version runs on.
        """
        if custom_images is not None:
            pulumi.set(__self__, "custom_images", custom_images)
        if default_resource_spec is not None:
            pulumi.set(__self__, "default_resource_spec", default_resource_spec)

    @property
    @pulumi.getter(name="customImages")
    def custom_images(self) -> Optional[Sequence['outputs.DomainCustomImage']]:
        """
        A list of custom SageMaker images that are configured to run as a KernelGateway app.
        """
        return pulumi.get(self, "custom_images")

    @property
    @pulumi.getter(name="defaultResourceSpec")
    def default_resource_spec(self) -> Optional['outputs.DomainResourceSpec']:
        """
        Specifies the ARNs of a SageMaker image and SageMaker image version, and the instance type that the version runs on.
        """
        return pulumi.get(self, "default_resource_spec")


@pulumi.output_type
class DomainRStudioServerProAppSettings(dict):
    """
    A collection of settings that configure user interaction with the RStudioServerPro app.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessStatus":
            suggest = "access_status"
        elif key == "userGroup":
            suggest = "user_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainRStudioServerProAppSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainRStudioServerProAppSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainRStudioServerProAppSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_status: Optional['DomainRStudioServerProAppSettingsAccessStatus'] = None,
                 user_group: Optional['DomainRStudioServerProAppSettingsUserGroup'] = None):
        """
        A collection of settings that configure user interaction with the RStudioServerPro app.
        :param 'DomainRStudioServerProAppSettingsAccessStatus' access_status: Indicates whether the current user has access to the RStudioServerPro app.
        :param 'DomainRStudioServerProAppSettingsUserGroup' user_group: The level of permissions that the user has within the RStudioServerPro app. This value defaults to User. The Admin value allows the user access to the RStudio Administrative Dashboard.
        """
        if access_status is not None:
            pulumi.set(__self__, "access_status", access_status)
        if user_group is not None:
            pulumi.set(__self__, "user_group", user_group)

    @property
    @pulumi.getter(name="accessStatus")
    def access_status(self) -> Optional['DomainRStudioServerProAppSettingsAccessStatus']:
        """
        Indicates whether the current user has access to the RStudioServerPro app.
        """
        return pulumi.get(self, "access_status")

    @property
    @pulumi.getter(name="userGroup")
    def user_group(self) -> Optional['DomainRStudioServerProAppSettingsUserGroup']:
        """
        The level of permissions that the user has within the RStudioServerPro app. This value defaults to User. The Admin value allows the user access to the RStudio Administrative Dashboard.
        """
        return pulumi.get(self, "user_group")


@pulumi.output_type
class DomainRStudioServerProDomainSettings(dict):
    """
    A collection of settings that update the current configuration for the RStudioServerPro Domain-level app.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainExecutionRoleArn":
            suggest = "domain_execution_role_arn"
        elif key == "defaultResourceSpec":
            suggest = "default_resource_spec"
        elif key == "rStudioConnectUrl":
            suggest = "r_studio_connect_url"
        elif key == "rStudioPackageManagerUrl":
            suggest = "r_studio_package_manager_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainRStudioServerProDomainSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainRStudioServerProDomainSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainRStudioServerProDomainSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_execution_role_arn: str,
                 default_resource_spec: Optional['outputs.DomainResourceSpec'] = None,
                 r_studio_connect_url: Optional[str] = None,
                 r_studio_package_manager_url: Optional[str] = None):
        """
        A collection of settings that update the current configuration for the RStudioServerPro Domain-level app.
        :param str domain_execution_role_arn: The ARN of the execution role for the RStudioServerPro Domain-level app.
        :param 'DomainResourceSpec' default_resource_spec: A collection that defines the default `InstanceType` , `SageMakerImageArn` , and `SageMakerImageVersionArn` for the Domain.
        :param str r_studio_connect_url: A URL pointing to an RStudio Connect server.
        :param str r_studio_package_manager_url: A URL pointing to an RStudio Package Manager server.
        """
        pulumi.set(__self__, "domain_execution_role_arn", domain_execution_role_arn)
        if default_resource_spec is not None:
            pulumi.set(__self__, "default_resource_spec", default_resource_spec)
        if r_studio_connect_url is not None:
            pulumi.set(__self__, "r_studio_connect_url", r_studio_connect_url)
        if r_studio_package_manager_url is not None:
            pulumi.set(__self__, "r_studio_package_manager_url", r_studio_package_manager_url)

    @property
    @pulumi.getter(name="domainExecutionRoleArn")
    def domain_execution_role_arn(self) -> str:
        """
        The ARN of the execution role for the RStudioServerPro Domain-level app.
        """
        return pulumi.get(self, "domain_execution_role_arn")

    @property
    @pulumi.getter(name="defaultResourceSpec")
    def default_resource_spec(self) -> Optional['outputs.DomainResourceSpec']:
        """
        A collection that defines the default `InstanceType` , `SageMakerImageArn` , and `SageMakerImageVersionArn` for the Domain.
        """
        return pulumi.get(self, "default_resource_spec")

    @property
    @pulumi.getter(name="rStudioConnectUrl")
    def r_studio_connect_url(self) -> Optional[str]:
        """
        A URL pointing to an RStudio Connect server.
        """
        return pulumi.get(self, "r_studio_connect_url")

    @property
    @pulumi.getter(name="rStudioPackageManagerUrl")
    def r_studio_package_manager_url(self) -> Optional[str]:
        """
        A URL pointing to an RStudio Package Manager server.
        """
        return pulumi.get(self, "r_studio_package_manager_url")


@pulumi.output_type
class DomainResourceSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "lifecycleConfigArn":
            suggest = "lifecycle_config_arn"
        elif key == "sageMakerImageArn":
            suggest = "sage_maker_image_arn"
        elif key == "sageMakerImageVersionArn":
            suggest = "sage_maker_image_version_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainResourceSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainResourceSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainResourceSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: Optional['DomainResourceSpecInstanceType'] = None,
                 lifecycle_config_arn: Optional[str] = None,
                 sage_maker_image_arn: Optional[str] = None,
                 sage_maker_image_version_arn: Optional[str] = None):
        """
        :param 'DomainResourceSpecInstanceType' instance_type: The instance type that the image version runs on.
        :param str lifecycle_config_arn: The Amazon Resource Name (ARN) of the Lifecycle Configuration to attach to the Resource.
        :param str sage_maker_image_arn: The Amazon Resource Name (ARN) of the SageMaker image that the image version belongs to.
        :param str sage_maker_image_version_arn: The Amazon Resource Name (ARN) of the image version created on the instance.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if lifecycle_config_arn is not None:
            pulumi.set(__self__, "lifecycle_config_arn", lifecycle_config_arn)
        if sage_maker_image_arn is not None:
            pulumi.set(__self__, "sage_maker_image_arn", sage_maker_image_arn)
        if sage_maker_image_version_arn is not None:
            pulumi.set(__self__, "sage_maker_image_version_arn", sage_maker_image_version_arn)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional['DomainResourceSpecInstanceType']:
        """
        The instance type that the image version runs on.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="lifecycleConfigArn")
    def lifecycle_config_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the Lifecycle Configuration to attach to the Resource.
        """
        return pulumi.get(self, "lifecycle_config_arn")

    @property
    @pulumi.getter(name="sageMakerImageArn")
    def sage_maker_image_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the SageMaker image that the image version belongs to.
        """
        return pulumi.get(self, "sage_maker_image_arn")

    @property
    @pulumi.getter(name="sageMakerImageVersionArn")
    def sage_maker_image_version_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the image version created on the instance.
        """
        return pulumi.get(self, "sage_maker_image_version_arn")


@pulumi.output_type
class DomainSettings(dict):
    """
    A collection of Domain settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dockerSettings":
            suggest = "docker_settings"
        elif key == "rStudioServerProDomainSettings":
            suggest = "r_studio_server_pro_domain_settings"
        elif key == "securityGroupIds":
            suggest = "security_group_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 docker_settings: Optional['outputs.DomainDockerSettings'] = None,
                 r_studio_server_pro_domain_settings: Optional['outputs.DomainRStudioServerProDomainSettings'] = None,
                 security_group_ids: Optional[Sequence[str]] = None):
        """
        A collection of Domain settings.
        :param 'DomainDockerSettings' docker_settings: A collection of settings that configure the domain's Docker interaction.
        :param 'DomainRStudioServerProDomainSettings' r_studio_server_pro_domain_settings: A collection of settings that configure the `RStudioServerPro` Domain-level app.
        :param Sequence[str] security_group_ids: The security groups for the Amazon Virtual Private Cloud that the Domain uses for communication between Domain-level apps and user apps.
        """
        if docker_settings is not None:
            pulumi.set(__self__, "docker_settings", docker_settings)
        if r_studio_server_pro_domain_settings is not None:
            pulumi.set(__self__, "r_studio_server_pro_domain_settings", r_studio_server_pro_domain_settings)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)

    @property
    @pulumi.getter(name="dockerSettings")
    def docker_settings(self) -> Optional['outputs.DomainDockerSettings']:
        """
        A collection of settings that configure the domain's Docker interaction.
        """
        return pulumi.get(self, "docker_settings")

    @property
    @pulumi.getter(name="rStudioServerProDomainSettings")
    def r_studio_server_pro_domain_settings(self) -> Optional['outputs.DomainRStudioServerProDomainSettings']:
        """
        A collection of settings that configure the `RStudioServerPro` Domain-level app.
        """
        return pulumi.get(self, "r_studio_server_pro_domain_settings")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[str]]:
        """
        The security groups for the Amazon Virtual Private Cloud that the Domain uses for communication between Domain-level apps and user apps.
        """
        return pulumi.get(self, "security_group_ids")


@pulumi.output_type
class DomainSharingSettings(dict):
    """
    Specifies options when sharing an Amazon SageMaker Studio notebook. These settings are specified as part of DefaultUserSettings when the CreateDomain API is called, and as part of UserSettings when the CreateUserProfile API is called.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notebookOutputOption":
            suggest = "notebook_output_option"
        elif key == "s3KmsKeyId":
            suggest = "s3_kms_key_id"
        elif key == "s3OutputPath":
            suggest = "s3_output_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainSharingSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainSharingSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainSharingSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 notebook_output_option: Optional['DomainSharingSettingsNotebookOutputOption'] = None,
                 s3_kms_key_id: Optional[str] = None,
                 s3_output_path: Optional[str] = None):
        """
        Specifies options when sharing an Amazon SageMaker Studio notebook. These settings are specified as part of DefaultUserSettings when the CreateDomain API is called, and as part of UserSettings when the CreateUserProfile API is called.
        :param 'DomainSharingSettingsNotebookOutputOption' notebook_output_option: Whether to include the notebook cell output when sharing the notebook. The default is Disabled.
        :param str s3_kms_key_id: When NotebookOutputOption is Allowed, the AWS Key Management Service (KMS) encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.
        :param str s3_output_path: When NotebookOutputOption is Allowed, the Amazon S3 bucket used to store the shared notebook snapshots.
        """
        if notebook_output_option is not None:
            pulumi.set(__self__, "notebook_output_option", notebook_output_option)
        if s3_kms_key_id is not None:
            pulumi.set(__self__, "s3_kms_key_id", s3_kms_key_id)
        if s3_output_path is not None:
            pulumi.set(__self__, "s3_output_path", s3_output_path)

    @property
    @pulumi.getter(name="notebookOutputOption")
    def notebook_output_option(self) -> Optional['DomainSharingSettingsNotebookOutputOption']:
        """
        Whether to include the notebook cell output when sharing the notebook. The default is Disabled.
        """
        return pulumi.get(self, "notebook_output_option")

    @property
    @pulumi.getter(name="s3KmsKeyId")
    def s3_kms_key_id(self) -> Optional[str]:
        """
        When NotebookOutputOption is Allowed, the AWS Key Management Service (KMS) encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.
        """
        return pulumi.get(self, "s3_kms_key_id")

    @property
    @pulumi.getter(name="s3OutputPath")
    def s3_output_path(self) -> Optional[str]:
        """
        When NotebookOutputOption is Allowed, the Amazon S3 bucket used to store the shared notebook snapshots.
        """
        return pulumi.get(self, "s3_output_path")


@pulumi.output_type
class DomainStudioWebPortalSettings(dict):
    """
    Studio settings. If these settings are applied on a user level, they take priority over the settings applied on a domain level.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hiddenAppTypes":
            suggest = "hidden_app_types"
        elif key == "hiddenMlTools":
            suggest = "hidden_ml_tools"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainStudioWebPortalSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainStudioWebPortalSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainStudioWebPortalSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hidden_app_types: Optional[Sequence['DomainAppType']] = None,
                 hidden_ml_tools: Optional[Sequence['DomainMlTools']] = None):
        """
        Studio settings. If these settings are applied on a user level, they take priority over the settings applied on a domain level.
        :param Sequence['DomainAppType'] hidden_app_types: Applications supported in Studio that are hidden from the Studio left navigation pane.
        :param Sequence['DomainMlTools'] hidden_ml_tools: The machine learning tools that are hidden from the Studio left navigation pane.
        """
        if hidden_app_types is not None:
            pulumi.set(__self__, "hidden_app_types", hidden_app_types)
        if hidden_ml_tools is not None:
            pulumi.set(__self__, "hidden_ml_tools", hidden_ml_tools)

    @property
    @pulumi.getter(name="hiddenAppTypes")
    def hidden_app_types(self) -> Optional[Sequence['DomainAppType']]:
        """
        Applications supported in Studio that are hidden from the Studio left navigation pane.
        """
        return pulumi.get(self, "hidden_app_types")

    @property
    @pulumi.getter(name="hiddenMlTools")
    def hidden_ml_tools(self) -> Optional[Sequence['DomainMlTools']]:
        """
        The machine learning tools that are hidden from the Studio left navigation pane.
        """
        return pulumi.get(self, "hidden_ml_tools")


@pulumi.output_type
class DomainUserSettings(dict):
    """
    A collection of settings that apply to users of Amazon SageMaker Studio. These settings are specified when the CreateUserProfile API is called, and as DefaultUserSettings when the CreateDomain API is called.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionRole":
            suggest = "execution_role"
        elif key == "codeEditorAppSettings":
            suggest = "code_editor_app_settings"
        elif key == "customFileSystemConfigs":
            suggest = "custom_file_system_configs"
        elif key == "customPosixUserConfig":
            suggest = "custom_posix_user_config"
        elif key == "defaultLandingUri":
            suggest = "default_landing_uri"
        elif key == "jupyterLabAppSettings":
            suggest = "jupyter_lab_app_settings"
        elif key == "jupyterServerAppSettings":
            suggest = "jupyter_server_app_settings"
        elif key == "kernelGatewayAppSettings":
            suggest = "kernel_gateway_app_settings"
        elif key == "rSessionAppSettings":
            suggest = "r_session_app_settings"
        elif key == "rStudioServerProAppSettings":
            suggest = "r_studio_server_pro_app_settings"
        elif key == "securityGroups":
            suggest = "security_groups"
        elif key == "sharingSettings":
            suggest = "sharing_settings"
        elif key == "spaceStorageSettings":
            suggest = "space_storage_settings"
        elif key == "studioWebPortal":
            suggest = "studio_web_portal"
        elif key == "studioWebPortalSettings":
            suggest = "studio_web_portal_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainUserSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainUserSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainUserSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_role: str,
                 code_editor_app_settings: Optional['outputs.DomainCodeEditorAppSettings'] = None,
                 custom_file_system_configs: Optional[Sequence['outputs.DomainCustomFileSystemConfig']] = None,
                 custom_posix_user_config: Optional['outputs.DomainCustomPosixUserConfig'] = None,
                 default_landing_uri: Optional[str] = None,
                 jupyter_lab_app_settings: Optional['outputs.DomainJupyterLabAppSettings'] = None,
                 jupyter_server_app_settings: Optional['outputs.DomainJupyterServerAppSettings'] = None,
                 kernel_gateway_app_settings: Optional['outputs.DomainKernelGatewayAppSettings'] = None,
                 r_session_app_settings: Optional['outputs.DomainRSessionAppSettings'] = None,
                 r_studio_server_pro_app_settings: Optional['outputs.DomainRStudioServerProAppSettings'] = None,
                 security_groups: Optional[Sequence[str]] = None,
                 sharing_settings: Optional['outputs.DomainSharingSettings'] = None,
                 space_storage_settings: Optional['outputs.DomainDefaultSpaceStorageSettings'] = None,
                 studio_web_portal: Optional['DomainUserSettingsStudioWebPortal'] = None,
                 studio_web_portal_settings: Optional['outputs.DomainStudioWebPortalSettings'] = None):
        """
        A collection of settings that apply to users of Amazon SageMaker Studio. These settings are specified when the CreateUserProfile API is called, and as DefaultUserSettings when the CreateDomain API is called.
        :param str execution_role: The execution role for the user.
        :param 'DomainCodeEditorAppSettings' code_editor_app_settings: The Code Editor application settings.
        :param Sequence['DomainCustomFileSystemConfig'] custom_file_system_configs: The settings for assigning a custom file system to a user profile. Permitted users can access this file system in Amazon SageMaker Studio.
        :param 'DomainCustomPosixUserConfig' custom_posix_user_config: Details about the POSIX identity that is used for file system operations.
        :param str default_landing_uri: Defines which Amazon SageMaker application users are directed to by default.
        :param 'DomainJupyterLabAppSettings' jupyter_lab_app_settings: The settings for the JupyterLab application.
        :param 'DomainJupyterServerAppSettings' jupyter_server_app_settings: The Jupyter server's app settings.
        :param 'DomainKernelGatewayAppSettings' kernel_gateway_app_settings: The kernel gateway app settings.
        :param 'DomainRSessionAppSettings' r_session_app_settings: A collection of settings that configure the `RSessionGateway` app.
        :param 'DomainRStudioServerProAppSettings' r_studio_server_pro_app_settings: A collection of settings that configure user interaction with the `RStudioServerPro` app.
        :param Sequence[str] security_groups: The security groups for the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
        :param 'DomainSharingSettings' sharing_settings: The sharing settings.
        :param 'DomainDefaultSpaceStorageSettings' space_storage_settings: The storage settings for a space.
        :param 'DomainUserSettingsStudioWebPortal' studio_web_portal: Indicates whether the Studio experience is available to users. If not, users cannot access Studio.
        :param 'DomainStudioWebPortalSettings' studio_web_portal_settings: Studio settings. If these settings are applied on a user level, they take priority over the settings applied on a domain level.
        """
        pulumi.set(__self__, "execution_role", execution_role)
        if code_editor_app_settings is not None:
            pulumi.set(__self__, "code_editor_app_settings", code_editor_app_settings)
        if custom_file_system_configs is not None:
            pulumi.set(__self__, "custom_file_system_configs", custom_file_system_configs)
        if custom_posix_user_config is not None:
            pulumi.set(__self__, "custom_posix_user_config", custom_posix_user_config)
        if default_landing_uri is not None:
            pulumi.set(__self__, "default_landing_uri", default_landing_uri)
        if jupyter_lab_app_settings is not None:
            pulumi.set(__self__, "jupyter_lab_app_settings", jupyter_lab_app_settings)
        if jupyter_server_app_settings is not None:
            pulumi.set(__self__, "jupyter_server_app_settings", jupyter_server_app_settings)
        if kernel_gateway_app_settings is not None:
            pulumi.set(__self__, "kernel_gateway_app_settings", kernel_gateway_app_settings)
        if r_session_app_settings is not None:
            pulumi.set(__self__, "r_session_app_settings", r_session_app_settings)
        if r_studio_server_pro_app_settings is not None:
            pulumi.set(__self__, "r_studio_server_pro_app_settings", r_studio_server_pro_app_settings)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if sharing_settings is not None:
            pulumi.set(__self__, "sharing_settings", sharing_settings)
        if space_storage_settings is not None:
            pulumi.set(__self__, "space_storage_settings", space_storage_settings)
        if studio_web_portal is not None:
            pulumi.set(__self__, "studio_web_portal", studio_web_portal)
        if studio_web_portal_settings is not None:
            pulumi.set(__self__, "studio_web_portal_settings", studio_web_portal_settings)

    @property
    @pulumi.getter(name="executionRole")
    def execution_role(self) -> str:
        """
        The execution role for the user.
        """
        return pulumi.get(self, "execution_role")

    @property
    @pulumi.getter(name="codeEditorAppSettings")
    def code_editor_app_settings(self) -> Optional['outputs.DomainCodeEditorAppSettings']:
        """
        The Code Editor application settings.
        """
        return pulumi.get(self, "code_editor_app_settings")

    @property
    @pulumi.getter(name="customFileSystemConfigs")
    def custom_file_system_configs(self) -> Optional[Sequence['outputs.DomainCustomFileSystemConfig']]:
        """
        The settings for assigning a custom file system to a user profile. Permitted users can access this file system in Amazon SageMaker Studio.
        """
        return pulumi.get(self, "custom_file_system_configs")

    @property
    @pulumi.getter(name="customPosixUserConfig")
    def custom_posix_user_config(self) -> Optional['outputs.DomainCustomPosixUserConfig']:
        """
        Details about the POSIX identity that is used for file system operations.
        """
        return pulumi.get(self, "custom_posix_user_config")

    @property
    @pulumi.getter(name="defaultLandingUri")
    def default_landing_uri(self) -> Optional[str]:
        """
        Defines which Amazon SageMaker application users are directed to by default.
        """
        return pulumi.get(self, "default_landing_uri")

    @property
    @pulumi.getter(name="jupyterLabAppSettings")
    def jupyter_lab_app_settings(self) -> Optional['outputs.DomainJupyterLabAppSettings']:
        """
        The settings for the JupyterLab application.
        """
        return pulumi.get(self, "jupyter_lab_app_settings")

    @property
    @pulumi.getter(name="jupyterServerAppSettings")
    def jupyter_server_app_settings(self) -> Optional['outputs.DomainJupyterServerAppSettings']:
        """
        The Jupyter server's app settings.
        """
        return pulumi.get(self, "jupyter_server_app_settings")

    @property
    @pulumi.getter(name="kernelGatewayAppSettings")
    def kernel_gateway_app_settings(self) -> Optional['outputs.DomainKernelGatewayAppSettings']:
        """
        The kernel gateway app settings.
        """
        return pulumi.get(self, "kernel_gateway_app_settings")

    @property
    @pulumi.getter(name="rSessionAppSettings")
    def r_session_app_settings(self) -> Optional['outputs.DomainRSessionAppSettings']:
        """
        A collection of settings that configure the `RSessionGateway` app.
        """
        return pulumi.get(self, "r_session_app_settings")

    @property
    @pulumi.getter(name="rStudioServerProAppSettings")
    def r_studio_server_pro_app_settings(self) -> Optional['outputs.DomainRStudioServerProAppSettings']:
        """
        A collection of settings that configure user interaction with the `RStudioServerPro` app.
        """
        return pulumi.get(self, "r_studio_server_pro_app_settings")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[Sequence[str]]:
        """
        The security groups for the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter(name="sharingSettings")
    def sharing_settings(self) -> Optional['outputs.DomainSharingSettings']:
        """
        The sharing settings.
        """
        return pulumi.get(self, "sharing_settings")

    @property
    @pulumi.getter(name="spaceStorageSettings")
    def space_storage_settings(self) -> Optional['outputs.DomainDefaultSpaceStorageSettings']:
        """
        The storage settings for a space.
        """
        return pulumi.get(self, "space_storage_settings")

    @property
    @pulumi.getter(name="studioWebPortal")
    def studio_web_portal(self) -> Optional['DomainUserSettingsStudioWebPortal']:
        """
        Indicates whether the Studio experience is available to users. If not, users cannot access Studio.
        """
        return pulumi.get(self, "studio_web_portal")

    @property
    @pulumi.getter(name="studioWebPortalSettings")
    def studio_web_portal_settings(self) -> Optional['outputs.DomainStudioWebPortalSettings']:
        """
        Studio settings. If these settings are applied on a user level, they take priority over the settings applied on a domain level.
        """
        return pulumi.get(self, "studio_web_portal_settings")


@pulumi.output_type
class FeatureGroupDataCatalogConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tableName":
            suggest = "table_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FeatureGroupDataCatalogConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FeatureGroupDataCatalogConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FeatureGroupDataCatalogConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 catalog: str,
                 database: str,
                 table_name: str):
        """
        :param str catalog: The name of the Glue table catalog.
        :param str database: The name of the Glue table database.
        :param str table_name: The name of the Glue table.
        """
        pulumi.set(__self__, "catalog", catalog)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "table_name", table_name)

    @property
    @pulumi.getter
    def catalog(self) -> str:
        """
        The name of the Glue table catalog.
        """
        return pulumi.get(self, "catalog")

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        The name of the Glue table database.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> str:
        """
        The name of the Glue table.
        """
        return pulumi.get(self, "table_name")


@pulumi.output_type
class FeatureGroupFeatureDefinition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "featureName":
            suggest = "feature_name"
        elif key == "featureType":
            suggest = "feature_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FeatureGroupFeatureDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FeatureGroupFeatureDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FeatureGroupFeatureDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 feature_name: str,
                 feature_type: 'FeatureGroupFeatureDefinitionFeatureType'):
        """
        :param str feature_name: The name of a feature. The type must be a string. `FeatureName` cannot be any of the following: `is_deleted` , `write_time` , `api_invocation_time` .
               
               The name:
               
               - Must start with an alphanumeric character.
               - Can only include alphanumeric characters, underscores, and hyphens. Spaces are not allowed.
        :param 'FeatureGroupFeatureDefinitionFeatureType' feature_type: The value type of a feature. Valid values are Integral, Fractional, or String.
        """
        pulumi.set(__self__, "feature_name", feature_name)
        pulumi.set(__self__, "feature_type", feature_type)

    @property
    @pulumi.getter(name="featureName")
    def feature_name(self) -> str:
        """
        The name of a feature. The type must be a string. `FeatureName` cannot be any of the following: `is_deleted` , `write_time` , `api_invocation_time` .

        The name:

        - Must start with an alphanumeric character.
        - Can only include alphanumeric characters, underscores, and hyphens. Spaces are not allowed.
        """
        return pulumi.get(self, "feature_name")

    @property
    @pulumi.getter(name="featureType")
    def feature_type(self) -> 'FeatureGroupFeatureDefinitionFeatureType':
        """
        The value type of a feature. Valid values are Integral, Fractional, or String.
        """
        return pulumi.get(self, "feature_type")


@pulumi.output_type
class FeatureGroupOnlineStoreSecurityConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FeatureGroupOnlineStoreSecurityConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FeatureGroupOnlineStoreSecurityConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FeatureGroupOnlineStoreSecurityConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_id: Optional[str] = None):
        """
        :param str kms_key_id: The AWS Key Management Service (KMS) key ARN that SageMaker Feature Store uses to encrypt the Amazon S3 objects at rest using Amazon S3 server-side encryption.
               
               The caller (either user or IAM role) of `CreateFeatureGroup` must have below permissions to the `OnlineStore` `KmsKeyId` :
               
               - `"kms:Encrypt"`
               - `"kms:Decrypt"`
               - `"kms:DescribeKey"`
               - `"kms:CreateGrant"`
               - `"kms:RetireGrant"`
               - `"kms:ReEncryptFrom"`
               - `"kms:ReEncryptTo"`
               - `"kms:GenerateDataKey"`
               - `"kms:ListAliases"`
               - `"kms:ListGrants"`
               - `"kms:RevokeGrant"`
               
               The caller (either user or IAM role) to all DataPlane operations ( `PutRecord` , `GetRecord` , `DeleteRecord` ) must have the following permissions to the `KmsKeyId` :
               
               - `"kms:Decrypt"`
        """
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The AWS Key Management Service (KMS) key ARN that SageMaker Feature Store uses to encrypt the Amazon S3 objects at rest using Amazon S3 server-side encryption.

        The caller (either user or IAM role) of `CreateFeatureGroup` must have below permissions to the `OnlineStore` `KmsKeyId` :

        - `"kms:Encrypt"`
        - `"kms:Decrypt"`
        - `"kms:DescribeKey"`
        - `"kms:CreateGrant"`
        - `"kms:RetireGrant"`
        - `"kms:ReEncryptFrom"`
        - `"kms:ReEncryptTo"`
        - `"kms:GenerateDataKey"`
        - `"kms:ListAliases"`
        - `"kms:ListGrants"`
        - `"kms:RevokeGrant"`

        The caller (either user or IAM role) to all DataPlane operations ( `PutRecord` , `GetRecord` , `DeleteRecord` ) must have the following permissions to the `KmsKeyId` :

        - `"kms:Decrypt"`
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class FeatureGroupS3StorageConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Uri":
            suggest = "s3_uri"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FeatureGroupS3StorageConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FeatureGroupS3StorageConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FeatureGroupS3StorageConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_uri: str,
                 kms_key_id: Optional[str] = None):
        """
        :param str s3_uri: The S3 URI, or location in Amazon S3, of `OfflineStore` .
               
               S3 URIs have a format similar to the following: `s3://example-bucket/prefix/` .
        :param str kms_key_id: The AWS Key Management Service (KMS) key ARN of the key used to encrypt any objects written into the `OfflineStore` S3 location.
               
               The IAM `roleARN` that is passed as a parameter to `CreateFeatureGroup` must have below permissions to the `KmsKeyId` :
               
               - `"kms:GenerateDataKey"`
        """
        pulumi.set(__self__, "s3_uri", s3_uri)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> str:
        """
        The S3 URI, or location in Amazon S3, of `OfflineStore` .

        S3 URIs have a format similar to the following: `s3://example-bucket/prefix/` .
        """
        return pulumi.get(self, "s3_uri")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The AWS Key Management Service (KMS) key ARN of the key used to encrypt any objects written into the `OfflineStore` S3 location.

        The IAM `roleARN` that is passed as a parameter to `CreateFeatureGroup` must have below permissions to the `KmsKeyId` :

        - `"kms:GenerateDataKey"`
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class FeatureGroupThroughputConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "throughputMode":
            suggest = "throughput_mode"
        elif key == "provisionedReadCapacityUnits":
            suggest = "provisioned_read_capacity_units"
        elif key == "provisionedWriteCapacityUnits":
            suggest = "provisioned_write_capacity_units"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FeatureGroupThroughputConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FeatureGroupThroughputConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FeatureGroupThroughputConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 throughput_mode: 'FeatureGroupThroughputMode',
                 provisioned_read_capacity_units: Optional[int] = None,
                 provisioned_write_capacity_units: Optional[int] = None):
        """
        :param 'FeatureGroupThroughputMode' throughput_mode: The mode used for your feature group throughput: `ON_DEMAND` or `PROVISIONED` .
        :param int provisioned_read_capacity_units: For provisioned feature groups with online store enabled, this indicates the read throughput you are billed for and can consume without throttling.
        :param int provisioned_write_capacity_units: For provisioned feature groups, this indicates the write throughput you are billed for and can consume without throttling.
        """
        pulumi.set(__self__, "throughput_mode", throughput_mode)
        if provisioned_read_capacity_units is not None:
            pulumi.set(__self__, "provisioned_read_capacity_units", provisioned_read_capacity_units)
        if provisioned_write_capacity_units is not None:
            pulumi.set(__self__, "provisioned_write_capacity_units", provisioned_write_capacity_units)

    @property
    @pulumi.getter(name="throughputMode")
    def throughput_mode(self) -> 'FeatureGroupThroughputMode':
        """
        The mode used for your feature group throughput: `ON_DEMAND` or `PROVISIONED` .
        """
        return pulumi.get(self, "throughput_mode")

    @property
    @pulumi.getter(name="provisionedReadCapacityUnits")
    def provisioned_read_capacity_units(self) -> Optional[int]:
        """
        For provisioned feature groups with online store enabled, this indicates the read throughput you are billed for and can consume without throttling.
        """
        return pulumi.get(self, "provisioned_read_capacity_units")

    @property
    @pulumi.getter(name="provisionedWriteCapacityUnits")
    def provisioned_write_capacity_units(self) -> Optional[int]:
        """
        For provisioned feature groups, this indicates the write throughput you are billed for and can consume without throttling.
        """
        return pulumi.get(self, "provisioned_write_capacity_units")


@pulumi.output_type
class FeatureGroupTtlDuration(dict):
    """
    TTL configuration of the feature group
    """
    def __init__(__self__, *,
                 unit: Optional['FeatureGroupUnit'] = None,
                 value: Optional[int] = None):
        """
        TTL configuration of the feature group
        :param 'FeatureGroupUnit' unit: `TtlDuration` time unit.
        :param int value: `TtlDuration` time value.
        """
        if unit is not None:
            pulumi.set(__self__, "unit", unit)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional['FeatureGroupUnit']:
        """
        `TtlDuration` time unit.
        """
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def value(self) -> Optional[int]:
        """
        `TtlDuration` time value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class InferenceComponentComputeResourceRequirements(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxMemoryRequiredInMb":
            suggest = "max_memory_required_in_mb"
        elif key == "minMemoryRequiredInMb":
            suggest = "min_memory_required_in_mb"
        elif key == "numberOfAcceleratorDevicesRequired":
            suggest = "number_of_accelerator_devices_required"
        elif key == "numberOfCpuCoresRequired":
            suggest = "number_of_cpu_cores_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InferenceComponentComputeResourceRequirements. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InferenceComponentComputeResourceRequirements.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InferenceComponentComputeResourceRequirements.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_memory_required_in_mb: Optional[int] = None,
                 min_memory_required_in_mb: Optional[int] = None,
                 number_of_accelerator_devices_required: Optional[float] = None,
                 number_of_cpu_cores_required: Optional[float] = None):
        """
        :param int max_memory_required_in_mb: The maximum MB of memory to allocate to run a model that you assign to an inference component.
        :param int min_memory_required_in_mb: The minimum MB of memory to allocate to run a model that you assign to an inference component.
        :param float number_of_accelerator_devices_required: The number of accelerators to allocate to run a model that you assign to an inference component. Accelerators include GPUs and AWS Inferentia.
        :param float number_of_cpu_cores_required: The number of CPU cores to allocate to run a model that you assign to an inference component.
        """
        if max_memory_required_in_mb is not None:
            pulumi.set(__self__, "max_memory_required_in_mb", max_memory_required_in_mb)
        if min_memory_required_in_mb is not None:
            pulumi.set(__self__, "min_memory_required_in_mb", min_memory_required_in_mb)
        if number_of_accelerator_devices_required is not None:
            pulumi.set(__self__, "number_of_accelerator_devices_required", number_of_accelerator_devices_required)
        if number_of_cpu_cores_required is not None:
            pulumi.set(__self__, "number_of_cpu_cores_required", number_of_cpu_cores_required)

    @property
    @pulumi.getter(name="maxMemoryRequiredInMb")
    def max_memory_required_in_mb(self) -> Optional[int]:
        """
        The maximum MB of memory to allocate to run a model that you assign to an inference component.
        """
        return pulumi.get(self, "max_memory_required_in_mb")

    @property
    @pulumi.getter(name="minMemoryRequiredInMb")
    def min_memory_required_in_mb(self) -> Optional[int]:
        """
        The minimum MB of memory to allocate to run a model that you assign to an inference component.
        """
        return pulumi.get(self, "min_memory_required_in_mb")

    @property
    @pulumi.getter(name="numberOfAcceleratorDevicesRequired")
    def number_of_accelerator_devices_required(self) -> Optional[float]:
        """
        The number of accelerators to allocate to run a model that you assign to an inference component. Accelerators include GPUs and AWS Inferentia.
        """
        return pulumi.get(self, "number_of_accelerator_devices_required")

    @property
    @pulumi.getter(name="numberOfCpuCoresRequired")
    def number_of_cpu_cores_required(self) -> Optional[float]:
        """
        The number of CPU cores to allocate to run a model that you assign to an inference component.
        """
        return pulumi.get(self, "number_of_cpu_cores_required")


@pulumi.output_type
class InferenceComponentContainerSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactUrl":
            suggest = "artifact_url"
        elif key == "deployedImage":
            suggest = "deployed_image"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InferenceComponentContainerSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InferenceComponentContainerSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InferenceComponentContainerSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifact_url: Optional[str] = None,
                 deployed_image: Optional['outputs.InferenceComponentDeployedImage'] = None,
                 environment: Optional[Mapping[str, str]] = None,
                 image: Optional[str] = None):
        """
        :param str artifact_url: The Amazon S3 path where the model artifacts, which result from model training, are stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix).
        :param Mapping[str, str] environment: The environment variables to set in the Docker container. Each key and value in the Environment string-to-string map can have length of up to 1024. We support up to 16 entries in the map.
        :param str image: The Amazon Elastic Container Registry (Amazon ECR) path where the Docker image for the model is stored.
        """
        if artifact_url is not None:
            pulumi.set(__self__, "artifact_url", artifact_url)
        if deployed_image is not None:
            pulumi.set(__self__, "deployed_image", deployed_image)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if image is not None:
            pulumi.set(__self__, "image", image)

    @property
    @pulumi.getter(name="artifactUrl")
    def artifact_url(self) -> Optional[str]:
        """
        The Amazon S3 path where the model artifacts, which result from model training, are stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix).
        """
        return pulumi.get(self, "artifact_url")

    @property
    @pulumi.getter(name="deployedImage")
    def deployed_image(self) -> Optional['outputs.InferenceComponentDeployedImage']:
        return pulumi.get(self, "deployed_image")

    @property
    @pulumi.getter
    def environment(self) -> Optional[Mapping[str, str]]:
        """
        The environment variables to set in the Docker container. Each key and value in the Environment string-to-string map can have length of up to 1024. We support up to 16 entries in the map.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def image(self) -> Optional[str]:
        """
        The Amazon Elastic Container Registry (Amazon ECR) path where the Docker image for the model is stored.
        """
        return pulumi.get(self, "image")


@pulumi.output_type
class InferenceComponentDeployedImage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resolutionTime":
            suggest = "resolution_time"
        elif key == "resolvedImage":
            suggest = "resolved_image"
        elif key == "specifiedImage":
            suggest = "specified_image"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InferenceComponentDeployedImage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InferenceComponentDeployedImage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InferenceComponentDeployedImage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resolution_time: Optional[str] = None,
                 resolved_image: Optional[str] = None,
                 specified_image: Optional[str] = None):
        """
        :param str resolution_time: The date and time when the image path for the model resolved to the `ResolvedImage`
        :param str resolved_image: The specific digest path of the image hosted in this `ProductionVariant` .
        :param str specified_image: The image path you specified when you created the model.
        """
        if resolution_time is not None:
            pulumi.set(__self__, "resolution_time", resolution_time)
        if resolved_image is not None:
            pulumi.set(__self__, "resolved_image", resolved_image)
        if specified_image is not None:
            pulumi.set(__self__, "specified_image", specified_image)

    @property
    @pulumi.getter(name="resolutionTime")
    def resolution_time(self) -> Optional[str]:
        """
        The date and time when the image path for the model resolved to the `ResolvedImage`
        """
        return pulumi.get(self, "resolution_time")

    @property
    @pulumi.getter(name="resolvedImage")
    def resolved_image(self) -> Optional[str]:
        """
        The specific digest path of the image hosted in this `ProductionVariant` .
        """
        return pulumi.get(self, "resolved_image")

    @property
    @pulumi.getter(name="specifiedImage")
    def specified_image(self) -> Optional[str]:
        """
        The image path you specified when you created the model.
        """
        return pulumi.get(self, "specified_image")


@pulumi.output_type
class InferenceComponentRuntimeConfig(dict):
    """
    The runtime config for the inference component
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "copyCount":
            suggest = "copy_count"
        elif key == "currentCopyCount":
            suggest = "current_copy_count"
        elif key == "desiredCopyCount":
            suggest = "desired_copy_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InferenceComponentRuntimeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InferenceComponentRuntimeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InferenceComponentRuntimeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 copy_count: Optional[int] = None,
                 current_copy_count: Optional[int] = None,
                 desired_copy_count: Optional[int] = None):
        """
        The runtime config for the inference component
        :param int copy_count: The number of runtime copies of the model container to deploy with the inference component. Each copy can serve inference requests.
        """
        if copy_count is not None:
            pulumi.set(__self__, "copy_count", copy_count)
        if current_copy_count is not None:
            pulumi.set(__self__, "current_copy_count", current_copy_count)
        if desired_copy_count is not None:
            pulumi.set(__self__, "desired_copy_count", desired_copy_count)

    @property
    @pulumi.getter(name="copyCount")
    def copy_count(self) -> Optional[int]:
        """
        The number of runtime copies of the model container to deploy with the inference component. Each copy can serve inference requests.
        """
        return pulumi.get(self, "copy_count")

    @property
    @pulumi.getter(name="currentCopyCount")
    def current_copy_count(self) -> Optional[int]:
        return pulumi.get(self, "current_copy_count")

    @property
    @pulumi.getter(name="desiredCopyCount")
    def desired_copy_count(self) -> Optional[int]:
        return pulumi.get(self, "desired_copy_count")


@pulumi.output_type
class InferenceComponentSpecification(dict):
    """
    The specification for the inference component
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeResourceRequirements":
            suggest = "compute_resource_requirements"
        elif key == "modelName":
            suggest = "model_name"
        elif key == "startupParameters":
            suggest = "startup_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InferenceComponentSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InferenceComponentSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InferenceComponentSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_resource_requirements: 'outputs.InferenceComponentComputeResourceRequirements',
                 container: Optional['outputs.InferenceComponentContainerSpecification'] = None,
                 model_name: Optional[str] = None,
                 startup_parameters: Optional['outputs.InferenceComponentStartupParameters'] = None):
        """
        The specification for the inference component
        :param 'InferenceComponentComputeResourceRequirements' compute_resource_requirements: The compute resources allocated to run the model assigned to the inference component.
        :param 'InferenceComponentContainerSpecification' container: Defines a container that provides the runtime environment for a model that you deploy with an inference component.
        :param str model_name: The name of an existing SageMaker model object in your account that you want to deploy with the inference component.
        :param 'InferenceComponentStartupParameters' startup_parameters: Settings that take effect while the model container starts up.
        """
        pulumi.set(__self__, "compute_resource_requirements", compute_resource_requirements)
        if container is not None:
            pulumi.set(__self__, "container", container)
        if model_name is not None:
            pulumi.set(__self__, "model_name", model_name)
        if startup_parameters is not None:
            pulumi.set(__self__, "startup_parameters", startup_parameters)

    @property
    @pulumi.getter(name="computeResourceRequirements")
    def compute_resource_requirements(self) -> 'outputs.InferenceComponentComputeResourceRequirements':
        """
        The compute resources allocated to run the model assigned to the inference component.
        """
        return pulumi.get(self, "compute_resource_requirements")

    @property
    @pulumi.getter
    def container(self) -> Optional['outputs.InferenceComponentContainerSpecification']:
        """
        Defines a container that provides the runtime environment for a model that you deploy with an inference component.
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter(name="modelName")
    def model_name(self) -> Optional[str]:
        """
        The name of an existing SageMaker model object in your account that you want to deploy with the inference component.
        """
        return pulumi.get(self, "model_name")

    @property
    @pulumi.getter(name="startupParameters")
    def startup_parameters(self) -> Optional['outputs.InferenceComponentStartupParameters']:
        """
        Settings that take effect while the model container starts up.
        """
        return pulumi.get(self, "startup_parameters")


@pulumi.output_type
class InferenceComponentStartupParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerStartupHealthCheckTimeoutInSeconds":
            suggest = "container_startup_health_check_timeout_in_seconds"
        elif key == "modelDataDownloadTimeoutInSeconds":
            suggest = "model_data_download_timeout_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InferenceComponentStartupParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InferenceComponentStartupParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InferenceComponentStartupParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_startup_health_check_timeout_in_seconds: Optional[int] = None,
                 model_data_download_timeout_in_seconds: Optional[int] = None):
        """
        :param int container_startup_health_check_timeout_in_seconds: The timeout value, in seconds, for your inference container to pass health check by Amazon S3 Hosting. For more information about health check, see [How Your Container Should Respond to Health Check (Ping) Requests](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-inference-code.html#your-algorithms-inference-algo-ping-requests) .
        :param int model_data_download_timeout_in_seconds: The timeout value, in seconds, to download and extract the model that you want to host from Amazon S3 to the individual inference instance associated with this inference component.
        """
        if container_startup_health_check_timeout_in_seconds is not None:
            pulumi.set(__self__, "container_startup_health_check_timeout_in_seconds", container_startup_health_check_timeout_in_seconds)
        if model_data_download_timeout_in_seconds is not None:
            pulumi.set(__self__, "model_data_download_timeout_in_seconds", model_data_download_timeout_in_seconds)

    @property
    @pulumi.getter(name="containerStartupHealthCheckTimeoutInSeconds")
    def container_startup_health_check_timeout_in_seconds(self) -> Optional[int]:
        """
        The timeout value, in seconds, for your inference container to pass health check by Amazon S3 Hosting. For more information about health check, see [How Your Container Should Respond to Health Check (Ping) Requests](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-inference-code.html#your-algorithms-inference-algo-ping-requests) .
        """
        return pulumi.get(self, "container_startup_health_check_timeout_in_seconds")

    @property
    @pulumi.getter(name="modelDataDownloadTimeoutInSeconds")
    def model_data_download_timeout_in_seconds(self) -> Optional[int]:
        """
        The timeout value, in seconds, to download and extract the model that you want to host from Amazon S3 to the individual inference instance associated with this inference component.
        """
        return pulumi.get(self, "model_data_download_timeout_in_seconds")


@pulumi.output_type
class InferenceExperimentCaptureContentTypeHeader(dict):
    """
    Configuration specifying how to treat different headers. If no headers are specified SageMaker will by default base64 encode when capturing the data.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "csvContentTypes":
            suggest = "csv_content_types"
        elif key == "jsonContentTypes":
            suggest = "json_content_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InferenceExperimentCaptureContentTypeHeader. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InferenceExperimentCaptureContentTypeHeader.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InferenceExperimentCaptureContentTypeHeader.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 csv_content_types: Optional[Sequence[str]] = None,
                 json_content_types: Optional[Sequence[str]] = None):
        """
        Configuration specifying how to treat different headers. If no headers are specified SageMaker will by default base64 encode when capturing the data.
        :param Sequence[str] csv_content_types: The list of all content type headers that SageMaker will treat as CSV and capture accordingly.
        :param Sequence[str] json_content_types: The list of all content type headers that SageMaker will treat as JSON and capture accordingly.
        """
        if csv_content_types is not None:
            pulumi.set(__self__, "csv_content_types", csv_content_types)
        if json_content_types is not None:
            pulumi.set(__self__, "json_content_types", json_content_types)

    @property
    @pulumi.getter(name="csvContentTypes")
    def csv_content_types(self) -> Optional[Sequence[str]]:
        """
        The list of all content type headers that SageMaker will treat as CSV and capture accordingly.
        """
        return pulumi.get(self, "csv_content_types")

    @property
    @pulumi.getter(name="jsonContentTypes")
    def json_content_types(self) -> Optional[Sequence[str]]:
        """
        The list of all content type headers that SageMaker will treat as JSON and capture accordingly.
        """
        return pulumi.get(self, "json_content_types")


@pulumi.output_type
class InferenceExperimentDataStorageConfig(dict):
    """
    The Amazon S3 location and configuration for storing inference request and response data.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "kmsKey":
            suggest = "kms_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InferenceExperimentDataStorageConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InferenceExperimentDataStorageConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InferenceExperimentDataStorageConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: str,
                 content_type: Optional['outputs.InferenceExperimentCaptureContentTypeHeader'] = None,
                 kms_key: Optional[str] = None):
        """
        The Amazon S3 location and configuration for storing inference request and response data.
        :param str destination: The Amazon S3 bucket where the inference request and response data is stored.
        :param 'InferenceExperimentCaptureContentTypeHeader' content_type: Configuration specifying how to treat different headers. If no headers are specified SageMaker will by default base64 encode when capturing the data.
        :param str kms_key: The AWS Key Management Service key that Amazon SageMaker uses to encrypt captured data at rest using Amazon S3 server-side encryption.
        """
        pulumi.set(__self__, "destination", destination)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)

    @property
    @pulumi.getter
    def destination(self) -> str:
        """
        The Amazon S3 bucket where the inference request and response data is stored.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional['outputs.InferenceExperimentCaptureContentTypeHeader']:
        """
        Configuration specifying how to treat different headers. If no headers are specified SageMaker will by default base64 encode when capturing the data.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[str]:
        """
        The AWS Key Management Service key that Amazon SageMaker uses to encrypt captured data at rest using Amazon S3 server-side encryption.
        """
        return pulumi.get(self, "kms_key")


@pulumi.output_type
class InferenceExperimentEndpointMetadata(dict):
    """
    The metadata of the endpoint on which the inference experiment ran.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointName":
            suggest = "endpoint_name"
        elif key == "endpointConfigName":
            suggest = "endpoint_config_name"
        elif key == "endpointStatus":
            suggest = "endpoint_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InferenceExperimentEndpointMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InferenceExperimentEndpointMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InferenceExperimentEndpointMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_name: str,
                 endpoint_config_name: Optional[str] = None,
                 endpoint_status: Optional['InferenceExperimentEndpointMetadataEndpointStatus'] = None):
        """
        The metadata of the endpoint on which the inference experiment ran.
        :param str endpoint_name: The name of the endpoint.
        :param str endpoint_config_name: The name of the endpoint configuration.
        :param 'InferenceExperimentEndpointMetadataEndpointStatus' endpoint_status: The status of the endpoint. For possible values of the status of an endpoint.
        """
        pulumi.set(__self__, "endpoint_name", endpoint_name)
        if endpoint_config_name is not None:
            pulumi.set(__self__, "endpoint_config_name", endpoint_config_name)
        if endpoint_status is not None:
            pulumi.set(__self__, "endpoint_status", endpoint_status)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> str:
        """
        The name of the endpoint.
        """
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="endpointConfigName")
    def endpoint_config_name(self) -> Optional[str]:
        """
        The name of the endpoint configuration.
        """
        return pulumi.get(self, "endpoint_config_name")

    @property
    @pulumi.getter(name="endpointStatus")
    def endpoint_status(self) -> Optional['InferenceExperimentEndpointMetadataEndpointStatus']:
        """
        The status of the endpoint. For possible values of the status of an endpoint.
        """
        return pulumi.get(self, "endpoint_status")


@pulumi.output_type
class InferenceExperimentModelInfrastructureConfig(dict):
    """
    The configuration for the infrastructure that the model will be deployed to.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "infrastructureType":
            suggest = "infrastructure_type"
        elif key == "realTimeInferenceConfig":
            suggest = "real_time_inference_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InferenceExperimentModelInfrastructureConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InferenceExperimentModelInfrastructureConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InferenceExperimentModelInfrastructureConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 infrastructure_type: 'InferenceExperimentModelInfrastructureConfigInfrastructureType',
                 real_time_inference_config: 'outputs.InferenceExperimentRealTimeInferenceConfig'):
        """
        The configuration for the infrastructure that the model will be deployed to.
        :param 'InferenceExperimentModelInfrastructureConfigInfrastructureType' infrastructure_type: The type of the inference experiment that you want to run.
        :param 'InferenceExperimentRealTimeInferenceConfig' real_time_inference_config: The infrastructure configuration for deploying the model to real-time inference.
        """
        pulumi.set(__self__, "infrastructure_type", infrastructure_type)
        pulumi.set(__self__, "real_time_inference_config", real_time_inference_config)

    @property
    @pulumi.getter(name="infrastructureType")
    def infrastructure_type(self) -> 'InferenceExperimentModelInfrastructureConfigInfrastructureType':
        """
        The type of the inference experiment that you want to run.
        """
        return pulumi.get(self, "infrastructure_type")

    @property
    @pulumi.getter(name="realTimeInferenceConfig")
    def real_time_inference_config(self) -> 'outputs.InferenceExperimentRealTimeInferenceConfig':
        """
        The infrastructure configuration for deploying the model to real-time inference.
        """
        return pulumi.get(self, "real_time_inference_config")


@pulumi.output_type
class InferenceExperimentModelVariantConfig(dict):
    """
    Contains information about the deployment options of a model.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "infrastructureConfig":
            suggest = "infrastructure_config"
        elif key == "modelName":
            suggest = "model_name"
        elif key == "variantName":
            suggest = "variant_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InferenceExperimentModelVariantConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InferenceExperimentModelVariantConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InferenceExperimentModelVariantConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 infrastructure_config: 'outputs.InferenceExperimentModelInfrastructureConfig',
                 model_name: str,
                 variant_name: str):
        """
        Contains information about the deployment options of a model.
        :param 'InferenceExperimentModelInfrastructureConfig' infrastructure_config: The configuration for the infrastructure that the model will be deployed to.
        :param str model_name: The name of the Amazon SageMaker Model entity.
        :param str variant_name: The name of the variant.
        """
        pulumi.set(__self__, "infrastructure_config", infrastructure_config)
        pulumi.set(__self__, "model_name", model_name)
        pulumi.set(__self__, "variant_name", variant_name)

    @property
    @pulumi.getter(name="infrastructureConfig")
    def infrastructure_config(self) -> 'outputs.InferenceExperimentModelInfrastructureConfig':
        """
        The configuration for the infrastructure that the model will be deployed to.
        """
        return pulumi.get(self, "infrastructure_config")

    @property
    @pulumi.getter(name="modelName")
    def model_name(self) -> str:
        """
        The name of the Amazon SageMaker Model entity.
        """
        return pulumi.get(self, "model_name")

    @property
    @pulumi.getter(name="variantName")
    def variant_name(self) -> str:
        """
        The name of the variant.
        """
        return pulumi.get(self, "variant_name")


@pulumi.output_type
class InferenceExperimentRealTimeInferenceConfig(dict):
    """
    The infrastructure configuration for deploying the model to a real-time inference endpoint.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceCount":
            suggest = "instance_count"
        elif key == "instanceType":
            suggest = "instance_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InferenceExperimentRealTimeInferenceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InferenceExperimentRealTimeInferenceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InferenceExperimentRealTimeInferenceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_count: int,
                 instance_type: str):
        """
        The infrastructure configuration for deploying the model to a real-time inference endpoint.
        :param int instance_count: The number of instances of the type specified by InstanceType.
        :param str instance_type: The instance type the model is deployed to.
        """
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "instance_type", instance_type)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> int:
        """
        The number of instances of the type specified by InstanceType.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        The instance type the model is deployed to.
        """
        return pulumi.get(self, "instance_type")


@pulumi.output_type
class InferenceExperimentSchedule(dict):
    """
    The duration for which you want the inference experiment to run.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InferenceExperimentSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InferenceExperimentSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InferenceExperimentSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: Optional[str] = None,
                 start_time: Optional[str] = None):
        """
        The duration for which you want the inference experiment to run.
        :param str end_time: The timestamp at which the inference experiment ended or will end.
        :param str start_time: The timestamp at which the inference experiment started or will start.
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[str]:
        """
        The timestamp at which the inference experiment ended or will end.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        The timestamp at which the inference experiment started or will start.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class InferenceExperimentShadowModeConfig(dict):
    """
    The configuration of ShadowMode inference experiment type. Use this field to specify a production variant which takes all the inference requests, and a shadow variant to which Amazon SageMaker replicates a percentage of the inference requests. For the shadow variant also specify the percentage of requests that Amazon SageMaker replicates.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shadowModelVariants":
            suggest = "shadow_model_variants"
        elif key == "sourceModelVariantName":
            suggest = "source_model_variant_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InferenceExperimentShadowModeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InferenceExperimentShadowModeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InferenceExperimentShadowModeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 shadow_model_variants: Sequence['outputs.InferenceExperimentShadowModelVariantConfig'],
                 source_model_variant_name: str):
        """
        The configuration of ShadowMode inference experiment type. Use this field to specify a production variant which takes all the inference requests, and a shadow variant to which Amazon SageMaker replicates a percentage of the inference requests. For the shadow variant also specify the percentage of requests that Amazon SageMaker replicates.
        :param Sequence['InferenceExperimentShadowModelVariantConfig'] shadow_model_variants: List of shadow variant configurations.
        :param str source_model_variant_name: The name of the production variant, which takes all the inference requests.
        """
        pulumi.set(__self__, "shadow_model_variants", shadow_model_variants)
        pulumi.set(__self__, "source_model_variant_name", source_model_variant_name)

    @property
    @pulumi.getter(name="shadowModelVariants")
    def shadow_model_variants(self) -> Sequence['outputs.InferenceExperimentShadowModelVariantConfig']:
        """
        List of shadow variant configurations.
        """
        return pulumi.get(self, "shadow_model_variants")

    @property
    @pulumi.getter(name="sourceModelVariantName")
    def source_model_variant_name(self) -> str:
        """
        The name of the production variant, which takes all the inference requests.
        """
        return pulumi.get(self, "source_model_variant_name")


@pulumi.output_type
class InferenceExperimentShadowModelVariantConfig(dict):
    """
    The name and sampling percentage of a shadow variant.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "samplingPercentage":
            suggest = "sampling_percentage"
        elif key == "shadowModelVariantName":
            suggest = "shadow_model_variant_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InferenceExperimentShadowModelVariantConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InferenceExperimentShadowModelVariantConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InferenceExperimentShadowModelVariantConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sampling_percentage: int,
                 shadow_model_variant_name: str):
        """
        The name and sampling percentage of a shadow variant.
        :param int sampling_percentage: The percentage of inference requests that Amazon SageMaker replicates from the production variant to the shadow variant.
        :param str shadow_model_variant_name: The name of the shadow variant.
        """
        pulumi.set(__self__, "sampling_percentage", sampling_percentage)
        pulumi.set(__self__, "shadow_model_variant_name", shadow_model_variant_name)

    @property
    @pulumi.getter(name="samplingPercentage")
    def sampling_percentage(self) -> int:
        """
        The percentage of inference requests that Amazon SageMaker replicates from the production variant to the shadow variant.
        """
        return pulumi.get(self, "sampling_percentage")

    @property
    @pulumi.getter(name="shadowModelVariantName")
    def shadow_model_variant_name(self) -> str:
        """
        The name of the shadow variant.
        """
        return pulumi.get(self, "shadow_model_variant_name")


@pulumi.output_type
class ModelBiasJobDefinitionBatchTransformInput(dict):
    """
    The batch transform input for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataCapturedDestinationS3Uri":
            suggest = "data_captured_destination_s3_uri"
        elif key == "datasetFormat":
            suggest = "dataset_format"
        elif key == "localPath":
            suggest = "local_path"
        elif key == "endTimeOffset":
            suggest = "end_time_offset"
        elif key == "featuresAttribute":
            suggest = "features_attribute"
        elif key == "inferenceAttribute":
            suggest = "inference_attribute"
        elif key == "probabilityAttribute":
            suggest = "probability_attribute"
        elif key == "probabilityThresholdAttribute":
            suggest = "probability_threshold_attribute"
        elif key == "s3DataDistributionType":
            suggest = "s3_data_distribution_type"
        elif key == "s3InputMode":
            suggest = "s3_input_mode"
        elif key == "startTimeOffset":
            suggest = "start_time_offset"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelBiasJobDefinitionBatchTransformInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelBiasJobDefinitionBatchTransformInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelBiasJobDefinitionBatchTransformInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_captured_destination_s3_uri: str,
                 dataset_format: 'outputs.ModelBiasJobDefinitionDatasetFormat',
                 local_path: str,
                 end_time_offset: Optional[str] = None,
                 features_attribute: Optional[str] = None,
                 inference_attribute: Optional[str] = None,
                 probability_attribute: Optional[str] = None,
                 probability_threshold_attribute: Optional[float] = None,
                 s3_data_distribution_type: Optional['ModelBiasJobDefinitionBatchTransformInputS3DataDistributionType'] = None,
                 s3_input_mode: Optional['ModelBiasJobDefinitionBatchTransformInputS3InputMode'] = None,
                 start_time_offset: Optional[str] = None):
        """
        The batch transform input for a monitoring job.
        :param str data_captured_destination_s3_uri: A URI that identifies the Amazon S3 storage location where Batch Transform Job captures data.
        :param 'ModelBiasJobDefinitionDatasetFormat' dataset_format: The dataset format for your batch transform job.
        :param str local_path: Path to the filesystem where the endpoint data is available to the container.
        :param str end_time_offset: Monitoring end time offset, e.g. PT0H
        :param str features_attribute: JSONpath to locate features in JSONlines dataset
        :param str inference_attribute: Index or JSONpath to locate predicted label(s)
        :param str probability_attribute: Index or JSONpath to locate probabilities
        :param float probability_threshold_attribute: The threshold for the class probability to be evaluated as a positive result.
        :param 'ModelBiasJobDefinitionBatchTransformInputS3DataDistributionType' s3_data_distribution_type: Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to FullyReplicated
        :param 'ModelBiasJobDefinitionBatchTransformInputS3InputMode' s3_input_mode: Whether the Pipe or File is used as the input mode for transfering data for the monitoring job. Pipe mode is recommended for large datasets. File mode is useful for small files that fit in memory. Defaults to File.
        :param str start_time_offset: Monitoring start time offset, e.g. -PT1H
        """
        pulumi.set(__self__, "data_captured_destination_s3_uri", data_captured_destination_s3_uri)
        pulumi.set(__self__, "dataset_format", dataset_format)
        pulumi.set(__self__, "local_path", local_path)
        if end_time_offset is not None:
            pulumi.set(__self__, "end_time_offset", end_time_offset)
        if features_attribute is not None:
            pulumi.set(__self__, "features_attribute", features_attribute)
        if inference_attribute is not None:
            pulumi.set(__self__, "inference_attribute", inference_attribute)
        if probability_attribute is not None:
            pulumi.set(__self__, "probability_attribute", probability_attribute)
        if probability_threshold_attribute is not None:
            pulumi.set(__self__, "probability_threshold_attribute", probability_threshold_attribute)
        if s3_data_distribution_type is not None:
            pulumi.set(__self__, "s3_data_distribution_type", s3_data_distribution_type)
        if s3_input_mode is not None:
            pulumi.set(__self__, "s3_input_mode", s3_input_mode)
        if start_time_offset is not None:
            pulumi.set(__self__, "start_time_offset", start_time_offset)

    @property
    @pulumi.getter(name="dataCapturedDestinationS3Uri")
    def data_captured_destination_s3_uri(self) -> str:
        """
        A URI that identifies the Amazon S3 storage location where Batch Transform Job captures data.
        """
        return pulumi.get(self, "data_captured_destination_s3_uri")

    @property
    @pulumi.getter(name="datasetFormat")
    def dataset_format(self) -> 'outputs.ModelBiasJobDefinitionDatasetFormat':
        """
        The dataset format for your batch transform job.
        """
        return pulumi.get(self, "dataset_format")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> str:
        """
        Path to the filesystem where the endpoint data is available to the container.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter(name="endTimeOffset")
    def end_time_offset(self) -> Optional[str]:
        """
        Monitoring end time offset, e.g. PT0H
        """
        return pulumi.get(self, "end_time_offset")

    @property
    @pulumi.getter(name="featuresAttribute")
    def features_attribute(self) -> Optional[str]:
        """
        JSONpath to locate features in JSONlines dataset
        """
        return pulumi.get(self, "features_attribute")

    @property
    @pulumi.getter(name="inferenceAttribute")
    def inference_attribute(self) -> Optional[str]:
        """
        Index or JSONpath to locate predicted label(s)
        """
        return pulumi.get(self, "inference_attribute")

    @property
    @pulumi.getter(name="probabilityAttribute")
    def probability_attribute(self) -> Optional[str]:
        """
        Index or JSONpath to locate probabilities
        """
        return pulumi.get(self, "probability_attribute")

    @property
    @pulumi.getter(name="probabilityThresholdAttribute")
    def probability_threshold_attribute(self) -> Optional[float]:
        """
        The threshold for the class probability to be evaluated as a positive result.
        """
        return pulumi.get(self, "probability_threshold_attribute")

    @property
    @pulumi.getter(name="s3DataDistributionType")
    def s3_data_distribution_type(self) -> Optional['ModelBiasJobDefinitionBatchTransformInputS3DataDistributionType']:
        """
        Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to FullyReplicated
        """
        return pulumi.get(self, "s3_data_distribution_type")

    @property
    @pulumi.getter(name="s3InputMode")
    def s3_input_mode(self) -> Optional['ModelBiasJobDefinitionBatchTransformInputS3InputMode']:
        """
        Whether the Pipe or File is used as the input mode for transfering data for the monitoring job. Pipe mode is recommended for large datasets. File mode is useful for small files that fit in memory. Defaults to File.
        """
        return pulumi.get(self, "s3_input_mode")

    @property
    @pulumi.getter(name="startTimeOffset")
    def start_time_offset(self) -> Optional[str]:
        """
        Monitoring start time offset, e.g. -PT1H
        """
        return pulumi.get(self, "start_time_offset")


@pulumi.output_type
class ModelBiasJobDefinitionClusterConfig(dict):
    """
    Configuration for the cluster used to run model monitoring jobs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceCount":
            suggest = "instance_count"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "volumeSizeInGb":
            suggest = "volume_size_in_gb"
        elif key == "volumeKmsKeyId":
            suggest = "volume_kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelBiasJobDefinitionClusterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelBiasJobDefinitionClusterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelBiasJobDefinitionClusterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_count: int,
                 instance_type: str,
                 volume_size_in_gb: int,
                 volume_kms_key_id: Optional[str] = None):
        """
        Configuration for the cluster used to run model monitoring jobs.
        :param int instance_count: The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1. The default value is 1.
        :param str instance_type: The ML compute instance type for the processing job.
        :param int volume_size_in_gb: The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
        :param str volume_kms_key_id: The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
        """
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "volume_size_in_gb", volume_size_in_gb)
        if volume_kms_key_id is not None:
            pulumi.set(__self__, "volume_kms_key_id", volume_kms_key_id)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> int:
        """
        The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1. The default value is 1.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        The ML compute instance type for the processing job.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="volumeSizeInGb")
    def volume_size_in_gb(self) -> int:
        """
        The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
        """
        return pulumi.get(self, "volume_size_in_gb")

    @property
    @pulumi.getter(name="volumeKmsKeyId")
    def volume_kms_key_id(self) -> Optional[str]:
        """
        The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
        """
        return pulumi.get(self, "volume_kms_key_id")


@pulumi.output_type
class ModelBiasJobDefinitionConstraintsResource(dict):
    """
    The baseline constraints resource for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Uri":
            suggest = "s3_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelBiasJobDefinitionConstraintsResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelBiasJobDefinitionConstraintsResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelBiasJobDefinitionConstraintsResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_uri: Optional[str] = None):
        """
        The baseline constraints resource for a monitoring job.
        :param str s3_uri: The Amazon S3 URI for baseline constraint file in Amazon S3 that the current monitoring job should validated against.
        """
        if s3_uri is not None:
            pulumi.set(__self__, "s3_uri", s3_uri)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> Optional[str]:
        """
        The Amazon S3 URI for baseline constraint file in Amazon S3 that the current monitoring job should validated against.
        """
        return pulumi.get(self, "s3_uri")


@pulumi.output_type
class ModelBiasJobDefinitionCsv(dict):
    """
    The CSV format
    """
    def __init__(__self__, *,
                 header: Optional[bool] = None):
        """
        The CSV format
        :param bool header: A boolean flag indicating if given CSV has header
        """
        if header is not None:
            pulumi.set(__self__, "header", header)

    @property
    @pulumi.getter
    def header(self) -> Optional[bool]:
        """
        A boolean flag indicating if given CSV has header
        """
        return pulumi.get(self, "header")


@pulumi.output_type
class ModelBiasJobDefinitionDatasetFormat(dict):
    """
    The dataset format of the data to monitor
    """
    def __init__(__self__, *,
                 csv: Optional['outputs.ModelBiasJobDefinitionCsv'] = None,
                 json: Optional['outputs.ModelBiasJobDefinitionJson'] = None,
                 parquet: Optional[bool] = None):
        """
        The dataset format of the data to monitor
        """
        if csv is not None:
            pulumi.set(__self__, "csv", csv)
        if json is not None:
            pulumi.set(__self__, "json", json)
        if parquet is not None:
            pulumi.set(__self__, "parquet", parquet)

    @property
    @pulumi.getter
    def csv(self) -> Optional['outputs.ModelBiasJobDefinitionCsv']:
        return pulumi.get(self, "csv")

    @property
    @pulumi.getter
    def json(self) -> Optional['outputs.ModelBiasJobDefinitionJson']:
        return pulumi.get(self, "json")

    @property
    @pulumi.getter
    def parquet(self) -> Optional[bool]:
        return pulumi.get(self, "parquet")


@pulumi.output_type
class ModelBiasJobDefinitionEndpointInput(dict):
    """
    The endpoint for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointName":
            suggest = "endpoint_name"
        elif key == "localPath":
            suggest = "local_path"
        elif key == "endTimeOffset":
            suggest = "end_time_offset"
        elif key == "featuresAttribute":
            suggest = "features_attribute"
        elif key == "inferenceAttribute":
            suggest = "inference_attribute"
        elif key == "probabilityAttribute":
            suggest = "probability_attribute"
        elif key == "probabilityThresholdAttribute":
            suggest = "probability_threshold_attribute"
        elif key == "s3DataDistributionType":
            suggest = "s3_data_distribution_type"
        elif key == "s3InputMode":
            suggest = "s3_input_mode"
        elif key == "startTimeOffset":
            suggest = "start_time_offset"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelBiasJobDefinitionEndpointInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelBiasJobDefinitionEndpointInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelBiasJobDefinitionEndpointInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_name: str,
                 local_path: str,
                 end_time_offset: Optional[str] = None,
                 features_attribute: Optional[str] = None,
                 inference_attribute: Optional[str] = None,
                 probability_attribute: Optional[str] = None,
                 probability_threshold_attribute: Optional[float] = None,
                 s3_data_distribution_type: Optional['ModelBiasJobDefinitionEndpointInputS3DataDistributionType'] = None,
                 s3_input_mode: Optional['ModelBiasJobDefinitionEndpointInputS3InputMode'] = None,
                 start_time_offset: Optional[str] = None):
        """
        The endpoint for a monitoring job.
        :param str endpoint_name: An endpoint in customer's account which has enabled `DataCaptureConfig` enabled.
        :param str local_path: Path to the filesystem where the endpoint data is available to the container.
        :param str end_time_offset: Monitoring end time offset, e.g. PT0H
        :param str features_attribute: JSONpath to locate features in JSONlines dataset
        :param str inference_attribute: Index or JSONpath to locate predicted label(s)
        :param str probability_attribute: Index or JSONpath to locate probabilities
        :param float probability_threshold_attribute: The threshold for the class probability to be evaluated as a positive result.
        :param 'ModelBiasJobDefinitionEndpointInputS3DataDistributionType' s3_data_distribution_type: Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to FullyReplicated
        :param 'ModelBiasJobDefinitionEndpointInputS3InputMode' s3_input_mode: Whether the Pipe or File is used as the input mode for transfering data for the monitoring job. Pipe mode is recommended for large datasets. File mode is useful for small files that fit in memory. Defaults to File.
        :param str start_time_offset: Monitoring start time offset, e.g. -PT1H
        """
        pulumi.set(__self__, "endpoint_name", endpoint_name)
        pulumi.set(__self__, "local_path", local_path)
        if end_time_offset is not None:
            pulumi.set(__self__, "end_time_offset", end_time_offset)
        if features_attribute is not None:
            pulumi.set(__self__, "features_attribute", features_attribute)
        if inference_attribute is not None:
            pulumi.set(__self__, "inference_attribute", inference_attribute)
        if probability_attribute is not None:
            pulumi.set(__self__, "probability_attribute", probability_attribute)
        if probability_threshold_attribute is not None:
            pulumi.set(__self__, "probability_threshold_attribute", probability_threshold_attribute)
        if s3_data_distribution_type is not None:
            pulumi.set(__self__, "s3_data_distribution_type", s3_data_distribution_type)
        if s3_input_mode is not None:
            pulumi.set(__self__, "s3_input_mode", s3_input_mode)
        if start_time_offset is not None:
            pulumi.set(__self__, "start_time_offset", start_time_offset)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> str:
        """
        An endpoint in customer's account which has enabled `DataCaptureConfig` enabled.
        """
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> str:
        """
        Path to the filesystem where the endpoint data is available to the container.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter(name="endTimeOffset")
    def end_time_offset(self) -> Optional[str]:
        """
        Monitoring end time offset, e.g. PT0H
        """
        return pulumi.get(self, "end_time_offset")

    @property
    @pulumi.getter(name="featuresAttribute")
    def features_attribute(self) -> Optional[str]:
        """
        JSONpath to locate features in JSONlines dataset
        """
        return pulumi.get(self, "features_attribute")

    @property
    @pulumi.getter(name="inferenceAttribute")
    def inference_attribute(self) -> Optional[str]:
        """
        Index or JSONpath to locate predicted label(s)
        """
        return pulumi.get(self, "inference_attribute")

    @property
    @pulumi.getter(name="probabilityAttribute")
    def probability_attribute(self) -> Optional[str]:
        """
        Index or JSONpath to locate probabilities
        """
        return pulumi.get(self, "probability_attribute")

    @property
    @pulumi.getter(name="probabilityThresholdAttribute")
    def probability_threshold_attribute(self) -> Optional[float]:
        """
        The threshold for the class probability to be evaluated as a positive result.
        """
        return pulumi.get(self, "probability_threshold_attribute")

    @property
    @pulumi.getter(name="s3DataDistributionType")
    def s3_data_distribution_type(self) -> Optional['ModelBiasJobDefinitionEndpointInputS3DataDistributionType']:
        """
        Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to FullyReplicated
        """
        return pulumi.get(self, "s3_data_distribution_type")

    @property
    @pulumi.getter(name="s3InputMode")
    def s3_input_mode(self) -> Optional['ModelBiasJobDefinitionEndpointInputS3InputMode']:
        """
        Whether the Pipe or File is used as the input mode for transfering data for the monitoring job. Pipe mode is recommended for large datasets. File mode is useful for small files that fit in memory. Defaults to File.
        """
        return pulumi.get(self, "s3_input_mode")

    @property
    @pulumi.getter(name="startTimeOffset")
    def start_time_offset(self) -> Optional[str]:
        """
        Monitoring start time offset, e.g. -PT1H
        """
        return pulumi.get(self, "start_time_offset")


@pulumi.output_type
class ModelBiasJobDefinitionJson(dict):
    """
    The Json format
    """
    def __init__(__self__, *,
                 line: Optional[bool] = None):
        """
        The Json format
        :param bool line: A boolean flag indicating if it is JSON line format
        """
        if line is not None:
            pulumi.set(__self__, "line", line)

    @property
    @pulumi.getter
    def line(self) -> Optional[bool]:
        """
        A boolean flag indicating if it is JSON line format
        """
        return pulumi.get(self, "line")


@pulumi.output_type
class ModelBiasJobDefinitionModelBiasAppSpecification(dict):
    """
    Container image configuration object for the monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configUri":
            suggest = "config_uri"
        elif key == "imageUri":
            suggest = "image_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelBiasJobDefinitionModelBiasAppSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelBiasJobDefinitionModelBiasAppSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelBiasJobDefinitionModelBiasAppSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_uri: str,
                 image_uri: str,
                 environment: Optional[Any] = None):
        """
        Container image configuration object for the monitoring job.
        :param str config_uri: The S3 URI to an analysis configuration file
        :param str image_uri: The container image to be run by the monitoring job.
        :param Any environment: Sets the environment variables in the Docker container
        """
        pulumi.set(__self__, "config_uri", config_uri)
        pulumi.set(__self__, "image_uri", image_uri)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)

    @property
    @pulumi.getter(name="configUri")
    def config_uri(self) -> str:
        """
        The S3 URI to an analysis configuration file
        """
        return pulumi.get(self, "config_uri")

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> str:
        """
        The container image to be run by the monitoring job.
        """
        return pulumi.get(self, "image_uri")

    @property
    @pulumi.getter
    def environment(self) -> Optional[Any]:
        """
        Sets the environment variables in the Docker container
        """
        return pulumi.get(self, "environment")


@pulumi.output_type
class ModelBiasJobDefinitionModelBiasBaselineConfig(dict):
    """
    Baseline configuration used to validate that the data conforms to the specified constraints and statistics.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseliningJobName":
            suggest = "baselining_job_name"
        elif key == "constraintsResource":
            suggest = "constraints_resource"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelBiasJobDefinitionModelBiasBaselineConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelBiasJobDefinitionModelBiasBaselineConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelBiasJobDefinitionModelBiasBaselineConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 baselining_job_name: Optional[str] = None,
                 constraints_resource: Optional['outputs.ModelBiasJobDefinitionConstraintsResource'] = None):
        """
        Baseline configuration used to validate that the data conforms to the specified constraints and statistics.
        :param str baselining_job_name: The name of the baseline model bias job.
        :param 'ModelBiasJobDefinitionConstraintsResource' constraints_resource: The constraints resource for a monitoring job.
        """
        if baselining_job_name is not None:
            pulumi.set(__self__, "baselining_job_name", baselining_job_name)
        if constraints_resource is not None:
            pulumi.set(__self__, "constraints_resource", constraints_resource)

    @property
    @pulumi.getter(name="baseliningJobName")
    def baselining_job_name(self) -> Optional[str]:
        """
        The name of the baseline model bias job.
        """
        return pulumi.get(self, "baselining_job_name")

    @property
    @pulumi.getter(name="constraintsResource")
    def constraints_resource(self) -> Optional['outputs.ModelBiasJobDefinitionConstraintsResource']:
        """
        The constraints resource for a monitoring job.
        """
        return pulumi.get(self, "constraints_resource")


@pulumi.output_type
class ModelBiasJobDefinitionModelBiasJobInput(dict):
    """
    The inputs for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groundTruthS3Input":
            suggest = "ground_truth_s3_input"
        elif key == "batchTransformInput":
            suggest = "batch_transform_input"
        elif key == "endpointInput":
            suggest = "endpoint_input"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelBiasJobDefinitionModelBiasJobInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelBiasJobDefinitionModelBiasJobInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelBiasJobDefinitionModelBiasJobInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ground_truth_s3_input: 'outputs.ModelBiasJobDefinitionMonitoringGroundTruthS3Input',
                 batch_transform_input: Optional['outputs.ModelBiasJobDefinitionBatchTransformInput'] = None,
                 endpoint_input: Optional['outputs.ModelBiasJobDefinitionEndpointInput'] = None):
        """
        The inputs for a monitoring job.
        :param 'ModelBiasJobDefinitionMonitoringGroundTruthS3Input' ground_truth_s3_input: Location of ground truth labels to use in model bias job.
        :param 'ModelBiasJobDefinitionBatchTransformInput' batch_transform_input: Input object for the batch transform job.
        :param 'ModelBiasJobDefinitionEndpointInput' endpoint_input: Input object for the endpoint
        """
        pulumi.set(__self__, "ground_truth_s3_input", ground_truth_s3_input)
        if batch_transform_input is not None:
            pulumi.set(__self__, "batch_transform_input", batch_transform_input)
        if endpoint_input is not None:
            pulumi.set(__self__, "endpoint_input", endpoint_input)

    @property
    @pulumi.getter(name="groundTruthS3Input")
    def ground_truth_s3_input(self) -> 'outputs.ModelBiasJobDefinitionMonitoringGroundTruthS3Input':
        """
        Location of ground truth labels to use in model bias job.
        """
        return pulumi.get(self, "ground_truth_s3_input")

    @property
    @pulumi.getter(name="batchTransformInput")
    def batch_transform_input(self) -> Optional['outputs.ModelBiasJobDefinitionBatchTransformInput']:
        """
        Input object for the batch transform job.
        """
        return pulumi.get(self, "batch_transform_input")

    @property
    @pulumi.getter(name="endpointInput")
    def endpoint_input(self) -> Optional['outputs.ModelBiasJobDefinitionEndpointInput']:
        """
        Input object for the endpoint
        """
        return pulumi.get(self, "endpoint_input")


@pulumi.output_type
class ModelBiasJobDefinitionMonitoringGroundTruthS3Input(dict):
    """
    Ground truth input provided in S3 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Uri":
            suggest = "s3_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelBiasJobDefinitionMonitoringGroundTruthS3Input. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelBiasJobDefinitionMonitoringGroundTruthS3Input.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelBiasJobDefinitionMonitoringGroundTruthS3Input.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_uri: str):
        """
        Ground truth input provided in S3 
        :param str s3_uri: A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
        """
        pulumi.set(__self__, "s3_uri", s3_uri)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> str:
        """
        A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
        """
        return pulumi.get(self, "s3_uri")


@pulumi.output_type
class ModelBiasJobDefinitionMonitoringOutput(dict):
    """
    The output object for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Output":
            suggest = "s3_output"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelBiasJobDefinitionMonitoringOutput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelBiasJobDefinitionMonitoringOutput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelBiasJobDefinitionMonitoringOutput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_output: 'outputs.ModelBiasJobDefinitionS3Output'):
        """
        The output object for a monitoring job.
        :param 'ModelBiasJobDefinitionS3Output' s3_output: The Amazon S3 storage location where the results of a monitoring job are saved.
        """
        pulumi.set(__self__, "s3_output", s3_output)

    @property
    @pulumi.getter(name="s3Output")
    def s3_output(self) -> 'outputs.ModelBiasJobDefinitionS3Output':
        """
        The Amazon S3 storage location where the results of a monitoring job are saved.
        """
        return pulumi.get(self, "s3_output")


@pulumi.output_type
class ModelBiasJobDefinitionMonitoringOutputConfig(dict):
    """
    The output configuration for monitoring jobs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "monitoringOutputs":
            suggest = "monitoring_outputs"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelBiasJobDefinitionMonitoringOutputConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelBiasJobDefinitionMonitoringOutputConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelBiasJobDefinitionMonitoringOutputConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 monitoring_outputs: Sequence['outputs.ModelBiasJobDefinitionMonitoringOutput'],
                 kms_key_id: Optional[str] = None):
        """
        The output configuration for monitoring jobs.
        :param Sequence['ModelBiasJobDefinitionMonitoringOutput'] monitoring_outputs: Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
        :param str kms_key_id: The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
        """
        pulumi.set(__self__, "monitoring_outputs", monitoring_outputs)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="monitoringOutputs")
    def monitoring_outputs(self) -> Sequence['outputs.ModelBiasJobDefinitionMonitoringOutput']:
        """
        Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
        """
        return pulumi.get(self, "monitoring_outputs")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class ModelBiasJobDefinitionMonitoringResources(dict):
    """
    Identifies the resources to deploy for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterConfig":
            suggest = "cluster_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelBiasJobDefinitionMonitoringResources. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelBiasJobDefinitionMonitoringResources.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelBiasJobDefinitionMonitoringResources.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_config: 'outputs.ModelBiasJobDefinitionClusterConfig'):
        """
        Identifies the resources to deploy for a monitoring job.
        :param 'ModelBiasJobDefinitionClusterConfig' cluster_config: The configuration for the cluster resources used to run the processing job.
        """
        pulumi.set(__self__, "cluster_config", cluster_config)

    @property
    @pulumi.getter(name="clusterConfig")
    def cluster_config(self) -> 'outputs.ModelBiasJobDefinitionClusterConfig':
        """
        The configuration for the cluster resources used to run the processing job.
        """
        return pulumi.get(self, "cluster_config")


@pulumi.output_type
class ModelBiasJobDefinitionNetworkConfig(dict):
    """
    Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableInterContainerTrafficEncryption":
            suggest = "enable_inter_container_traffic_encryption"
        elif key == "enableNetworkIsolation":
            suggest = "enable_network_isolation"
        elif key == "vpcConfig":
            suggest = "vpc_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelBiasJobDefinitionNetworkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelBiasJobDefinitionNetworkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelBiasJobDefinitionNetworkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_inter_container_traffic_encryption: Optional[bool] = None,
                 enable_network_isolation: Optional[bool] = None,
                 vpc_config: Optional['outputs.ModelBiasJobDefinitionVpcConfig'] = None):
        """
        Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
        :param bool enable_inter_container_traffic_encryption: Whether to encrypt all communications between distributed processing jobs. Choose True to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
        :param bool enable_network_isolation: Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
        :param 'ModelBiasJobDefinitionVpcConfig' vpc_config: Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.
        """
        if enable_inter_container_traffic_encryption is not None:
            pulumi.set(__self__, "enable_inter_container_traffic_encryption", enable_inter_container_traffic_encryption)
        if enable_network_isolation is not None:
            pulumi.set(__self__, "enable_network_isolation", enable_network_isolation)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @property
    @pulumi.getter(name="enableInterContainerTrafficEncryption")
    def enable_inter_container_traffic_encryption(self) -> Optional[bool]:
        """
        Whether to encrypt all communications between distributed processing jobs. Choose True to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
        """
        return pulumi.get(self, "enable_inter_container_traffic_encryption")

    @property
    @pulumi.getter(name="enableNetworkIsolation")
    def enable_network_isolation(self) -> Optional[bool]:
        """
        Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
        """
        return pulumi.get(self, "enable_network_isolation")

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional['outputs.ModelBiasJobDefinitionVpcConfig']:
        """
        Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.
        """
        return pulumi.get(self, "vpc_config")


@pulumi.output_type
class ModelBiasJobDefinitionS3Output(dict):
    """
    Information about where and how to store the results of a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localPath":
            suggest = "local_path"
        elif key == "s3Uri":
            suggest = "s3_uri"
        elif key == "s3UploadMode":
            suggest = "s3_upload_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelBiasJobDefinitionS3Output. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelBiasJobDefinitionS3Output.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelBiasJobDefinitionS3Output.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_path: str,
                 s3_uri: str,
                 s3_upload_mode: Optional['ModelBiasJobDefinitionS3OutputS3UploadMode'] = None):
        """
        Information about where and how to store the results of a monitoring job.
        :param str local_path: The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. LocalPath is an absolute path for the output data.
        :param str s3_uri: A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
        :param 'ModelBiasJobDefinitionS3OutputS3UploadMode' s3_upload_mode: Whether to upload the results of the monitoring job continuously or after the job completes.
        """
        pulumi.set(__self__, "local_path", local_path)
        pulumi.set(__self__, "s3_uri", s3_uri)
        if s3_upload_mode is not None:
            pulumi.set(__self__, "s3_upload_mode", s3_upload_mode)

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> str:
        """
        The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. LocalPath is an absolute path for the output data.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> str:
        """
        A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
        """
        return pulumi.get(self, "s3_uri")

    @property
    @pulumi.getter(name="s3UploadMode")
    def s3_upload_mode(self) -> Optional['ModelBiasJobDefinitionS3OutputS3UploadMode']:
        """
        Whether to upload the results of the monitoring job continuously or after the job completes.
        """
        return pulumi.get(self, "s3_upload_mode")


@pulumi.output_type
class ModelBiasJobDefinitionStoppingCondition(dict):
    """
    Specifies a time limit for how long the monitoring job is allowed to run.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxRuntimeInSeconds":
            suggest = "max_runtime_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelBiasJobDefinitionStoppingCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelBiasJobDefinitionStoppingCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelBiasJobDefinitionStoppingCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_runtime_in_seconds: int):
        """
        Specifies a time limit for how long the monitoring job is allowed to run.
        :param int max_runtime_in_seconds: The maximum runtime allowed in seconds.
        """
        pulumi.set(__self__, "max_runtime_in_seconds", max_runtime_in_seconds)

    @property
    @pulumi.getter(name="maxRuntimeInSeconds")
    def max_runtime_in_seconds(self) -> int:
        """
        The maximum runtime allowed in seconds.
        """
        return pulumi.get(self, "max_runtime_in_seconds")


@pulumi.output_type
class ModelBiasJobDefinitionVpcConfig(dict):
    """
    Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupIds":
            suggest = "security_group_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelBiasJobDefinitionVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelBiasJobDefinitionVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelBiasJobDefinitionVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_ids: Sequence[str],
                 subnets: Sequence[str]):
        """
        Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.
        :param Sequence[str] security_group_ids: The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the Subnets field.
        :param Sequence[str] subnets: The ID of the subnets in the VPC to which you want to connect to your monitoring jobs.
        """
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[str]:
        """
        The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the Subnets field.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[str]:
        """
        The ID of the subnets in the VPC to which you want to connect to your monitoring jobs.
        """
        return pulumi.get(self, "subnets")


@pulumi.output_type
class ModelCardAdditionalInformation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caveatsAndRecommendations":
            suggest = "caveats_and_recommendations"
        elif key == "customDetails":
            suggest = "custom_details"
        elif key == "ethicalConsiderations":
            suggest = "ethical_considerations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelCardAdditionalInformation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelCardAdditionalInformation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelCardAdditionalInformation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 caveats_and_recommendations: Optional[str] = None,
                 custom_details: Optional[Mapping[str, str]] = None,
                 ethical_considerations: Optional[str] = None):
        """
        :param str caveats_and_recommendations: Caveats and recommendations for people who might use this model in their applications.
        :param Mapping[str, str] custom_details: customer details.
        :param str ethical_considerations: Any ethical considerations that the author wants to provide.
        """
        if caveats_and_recommendations is not None:
            pulumi.set(__self__, "caveats_and_recommendations", caveats_and_recommendations)
        if custom_details is not None:
            pulumi.set(__self__, "custom_details", custom_details)
        if ethical_considerations is not None:
            pulumi.set(__self__, "ethical_considerations", ethical_considerations)

    @property
    @pulumi.getter(name="caveatsAndRecommendations")
    def caveats_and_recommendations(self) -> Optional[str]:
        """
        Caveats and recommendations for people who might use this model in their applications.
        """
        return pulumi.get(self, "caveats_and_recommendations")

    @property
    @pulumi.getter(name="customDetails")
    def custom_details(self) -> Optional[Mapping[str, str]]:
        """
        customer details.
        """
        return pulumi.get(self, "custom_details")

    @property
    @pulumi.getter(name="ethicalConsiderations")
    def ethical_considerations(self) -> Optional[str]:
        """
        Any ethical considerations that the author wants to provide.
        """
        return pulumi.get(self, "ethical_considerations")


@pulumi.output_type
class ModelCardBarChartMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "xAxisName":
            suggest = "x_axis_name"
        elif key == "yAxisName":
            suggest = "y_axis_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelCardBarChartMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelCardBarChartMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelCardBarChartMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 type: 'ModelCardBarChartMetricType',
                 value: Sequence[float],
                 notes: Optional[str] = None,
                 x_axis_name: Optional[Sequence[str]] = None,
                 y_axis_name: Optional[str] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if x_axis_name is not None:
            pulumi.set(__self__, "x_axis_name", x_axis_name)
        if y_axis_name is not None:
            pulumi.set(__self__, "y_axis_name", y_axis_name)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> 'ModelCardBarChartMetricType':
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Sequence[float]:
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def notes(self) -> Optional[str]:
        return pulumi.get(self, "notes")

    @property
    @pulumi.getter(name="xAxisName")
    def x_axis_name(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "x_axis_name")

    @property
    @pulumi.getter(name="yAxisName")
    def y_axis_name(self) -> Optional[str]:
        return pulumi.get(self, "y_axis_name")


@pulumi.output_type
class ModelCardBusinessDetails(dict):
    """
    Business details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "businessProblem":
            suggest = "business_problem"
        elif key == "businessStakeholders":
            suggest = "business_stakeholders"
        elif key == "lineOfBusiness":
            suggest = "line_of_business"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelCardBusinessDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelCardBusinessDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelCardBusinessDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 business_problem: Optional[str] = None,
                 business_stakeholders: Optional[str] = None,
                 line_of_business: Optional[str] = None):
        """
        Business details.
        :param str business_problem: What business problem does the model solve?
        :param str business_stakeholders: Business stakeholders.
        :param str line_of_business: Line of business.
        """
        if business_problem is not None:
            pulumi.set(__self__, "business_problem", business_problem)
        if business_stakeholders is not None:
            pulumi.set(__self__, "business_stakeholders", business_stakeholders)
        if line_of_business is not None:
            pulumi.set(__self__, "line_of_business", line_of_business)

    @property
    @pulumi.getter(name="businessProblem")
    def business_problem(self) -> Optional[str]:
        """
        What business problem does the model solve?
        """
        return pulumi.get(self, "business_problem")

    @property
    @pulumi.getter(name="businessStakeholders")
    def business_stakeholders(self) -> Optional[str]:
        """
        Business stakeholders.
        """
        return pulumi.get(self, "business_stakeholders")

    @property
    @pulumi.getter(name="lineOfBusiness")
    def line_of_business(self) -> Optional[str]:
        """
        Line of business.
        """
        return pulumi.get(self, "line_of_business")


@pulumi.output_type
class ModelCardContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "modelDataUrl":
            suggest = "model_data_url"
        elif key == "nearestModelName":
            suggest = "nearest_model_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelCardContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelCardContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelCardContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: str,
                 model_data_url: Optional[str] = None,
                 nearest_model_name: Optional[str] = None):
        """
        :param str image: Inference environment path. The Amazon EC2 Container Registry (Amazon ECR) path where inference code is stored.
        :param str model_data_url: The Amazon S3 path where the model artifacts, which result from model training, are stored.
        :param str nearest_model_name: The name of a pre-trained machine learning benchmarked by Amazon SageMaker Inference Recommender model that matches your model.
        """
        pulumi.set(__self__, "image", image)
        if model_data_url is not None:
            pulumi.set(__self__, "model_data_url", model_data_url)
        if nearest_model_name is not None:
            pulumi.set(__self__, "nearest_model_name", nearest_model_name)

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        Inference environment path. The Amazon EC2 Container Registry (Amazon ECR) path where inference code is stored.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="modelDataUrl")
    def model_data_url(self) -> Optional[str]:
        """
        The Amazon S3 path where the model artifacts, which result from model training, are stored.
        """
        return pulumi.get(self, "model_data_url")

    @property
    @pulumi.getter(name="nearestModelName")
    def nearest_model_name(self) -> Optional[str]:
        """
        The name of a pre-trained machine learning benchmarked by Amazon SageMaker Inference Recommender model that matches your model.
        """
        return pulumi.get(self, "nearest_model_name")


@pulumi.output_type
class ModelCardContent(dict):
    """
    The content of the model card.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalInformation":
            suggest = "additional_information"
        elif key == "businessDetails":
            suggest = "business_details"
        elif key == "evaluationDetails":
            suggest = "evaluation_details"
        elif key == "intendedUses":
            suggest = "intended_uses"
        elif key == "modelOverview":
            suggest = "model_overview"
        elif key == "modelPackageDetails":
            suggest = "model_package_details"
        elif key == "trainingDetails":
            suggest = "training_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelCardContent. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelCardContent.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelCardContent.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_information: Optional['outputs.ModelCardAdditionalInformation'] = None,
                 business_details: Optional['outputs.ModelCardBusinessDetails'] = None,
                 evaluation_details: Optional[Sequence['outputs.ModelCardEvaluationDetail']] = None,
                 intended_uses: Optional['outputs.ModelCardIntendedUses'] = None,
                 model_overview: Optional['outputs.ModelCardModelOverview'] = None,
                 model_package_details: Optional['outputs.ModelCardModelPackageDetails'] = None,
                 training_details: Optional['outputs.ModelCardTrainingDetails'] = None):
        """
        The content of the model card.
        :param 'ModelCardAdditionalInformation' additional_information: Additional information about the model.
        :param 'ModelCardBusinessDetails' business_details: Information about how the model supports business goals.
        :param Sequence['ModelCardEvaluationDetail'] evaluation_details: An overview about the model's evaluation.
        :param 'ModelCardIntendedUses' intended_uses: The intended usage of the model.
        :param 'ModelCardModelOverview' model_overview: An overview about the model
        :param 'ModelCardTrainingDetails' training_details: An overview about model training.
        """
        if additional_information is not None:
            pulumi.set(__self__, "additional_information", additional_information)
        if business_details is not None:
            pulumi.set(__self__, "business_details", business_details)
        if evaluation_details is not None:
            pulumi.set(__self__, "evaluation_details", evaluation_details)
        if intended_uses is not None:
            pulumi.set(__self__, "intended_uses", intended_uses)
        if model_overview is not None:
            pulumi.set(__self__, "model_overview", model_overview)
        if model_package_details is not None:
            pulumi.set(__self__, "model_package_details", model_package_details)
        if training_details is not None:
            pulumi.set(__self__, "training_details", training_details)

    @property
    @pulumi.getter(name="additionalInformation")
    def additional_information(self) -> Optional['outputs.ModelCardAdditionalInformation']:
        """
        Additional information about the model.
        """
        return pulumi.get(self, "additional_information")

    @property
    @pulumi.getter(name="businessDetails")
    def business_details(self) -> Optional['outputs.ModelCardBusinessDetails']:
        """
        Information about how the model supports business goals.
        """
        return pulumi.get(self, "business_details")

    @property
    @pulumi.getter(name="evaluationDetails")
    def evaluation_details(self) -> Optional[Sequence['outputs.ModelCardEvaluationDetail']]:
        """
        An overview about the model's evaluation.
        """
        return pulumi.get(self, "evaluation_details")

    @property
    @pulumi.getter(name="intendedUses")
    def intended_uses(self) -> Optional['outputs.ModelCardIntendedUses']:
        """
        The intended usage of the model.
        """
        return pulumi.get(self, "intended_uses")

    @property
    @pulumi.getter(name="modelOverview")
    def model_overview(self) -> Optional['outputs.ModelCardModelOverview']:
        """
        An overview about the model
        """
        return pulumi.get(self, "model_overview")

    @property
    @pulumi.getter(name="modelPackageDetails")
    def model_package_details(self) -> Optional['outputs.ModelCardModelPackageDetails']:
        return pulumi.get(self, "model_package_details")

    @property
    @pulumi.getter(name="trainingDetails")
    def training_details(self) -> Optional['outputs.ModelCardTrainingDetails']:
        """
        An overview about model training.
        """
        return pulumi.get(self, "training_details")


@pulumi.output_type
class ModelCardEvaluationDetail(dict):
    """
    item of evaluation details
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "evaluationJobArn":
            suggest = "evaluation_job_arn"
        elif key == "evaluationObservation":
            suggest = "evaluation_observation"
        elif key == "metricGroups":
            suggest = "metric_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelCardEvaluationDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelCardEvaluationDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelCardEvaluationDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 datasets: Optional[Sequence[str]] = None,
                 evaluation_job_arn: Optional[str] = None,
                 evaluation_observation: Optional[str] = None,
                 metadata: Optional[Mapping[str, str]] = None,
                 metric_groups: Optional[Sequence['outputs.ModelCardMetricGroup']] = None):
        """
        item of evaluation details
        :param Mapping[str, str] metadata: additional attributes associated with the evaluation results.
        """
        pulumi.set(__self__, "name", name)
        if datasets is not None:
            pulumi.set(__self__, "datasets", datasets)
        if evaluation_job_arn is not None:
            pulumi.set(__self__, "evaluation_job_arn", evaluation_job_arn)
        if evaluation_observation is not None:
            pulumi.set(__self__, "evaluation_observation", evaluation_observation)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if metric_groups is not None:
            pulumi.set(__self__, "metric_groups", metric_groups)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def datasets(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "datasets")

    @property
    @pulumi.getter(name="evaluationJobArn")
    def evaluation_job_arn(self) -> Optional[str]:
        return pulumi.get(self, "evaluation_job_arn")

    @property
    @pulumi.getter(name="evaluationObservation")
    def evaluation_observation(self) -> Optional[str]:
        return pulumi.get(self, "evaluation_observation")

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Mapping[str, str]]:
        """
        additional attributes associated with the evaluation results.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="metricGroups")
    def metric_groups(self) -> Optional[Sequence['outputs.ModelCardMetricGroup']]:
        return pulumi.get(self, "metric_groups")


@pulumi.output_type
class ModelCardInferenceSpecification(dict):
    def __init__(__self__, *,
                 containers: Sequence['outputs.ModelCardContainer']):
        """
        :param Sequence['ModelCardContainer'] containers: Contains inference related information which were used to create model package.
        """
        pulumi.set(__self__, "containers", containers)

    @property
    @pulumi.getter
    def containers(self) -> Sequence['outputs.ModelCardContainer']:
        """
        Contains inference related information which were used to create model package.
        """
        return pulumi.get(self, "containers")


@pulumi.output_type
class ModelCardIntendedUses(dict):
    """
    Intended usage of model.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "explanationsForRiskRating":
            suggest = "explanations_for_risk_rating"
        elif key == "factorsAffectingModelEfficiency":
            suggest = "factors_affecting_model_efficiency"
        elif key == "intendedUses":
            suggest = "intended_uses"
        elif key == "purposeOfModel":
            suggest = "purpose_of_model"
        elif key == "riskRating":
            suggest = "risk_rating"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelCardIntendedUses. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelCardIntendedUses.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelCardIntendedUses.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 explanations_for_risk_rating: Optional[str] = None,
                 factors_affecting_model_efficiency: Optional[str] = None,
                 intended_uses: Optional[str] = None,
                 purpose_of_model: Optional[str] = None,
                 risk_rating: Optional['ModelCardRiskRating'] = None):
        """
        Intended usage of model.
        :param str explanations_for_risk_rating: An explanation of why your organization categorizes the model with its risk rating.
        :param str factors_affecting_model_efficiency: Factors affecting model efficacy.
        :param str intended_uses: intended use cases.
        :param str purpose_of_model: Why the model was developed?
        :param 'ModelCardRiskRating' risk_rating: Your organization's risk rating. You can specify one the following values as the risk rating:
               
               - High
               - Medium
               - Low
               - Unknown
        """
        if explanations_for_risk_rating is not None:
            pulumi.set(__self__, "explanations_for_risk_rating", explanations_for_risk_rating)
        if factors_affecting_model_efficiency is not None:
            pulumi.set(__self__, "factors_affecting_model_efficiency", factors_affecting_model_efficiency)
        if intended_uses is not None:
            pulumi.set(__self__, "intended_uses", intended_uses)
        if purpose_of_model is not None:
            pulumi.set(__self__, "purpose_of_model", purpose_of_model)
        if risk_rating is not None:
            pulumi.set(__self__, "risk_rating", risk_rating)

    @property
    @pulumi.getter(name="explanationsForRiskRating")
    def explanations_for_risk_rating(self) -> Optional[str]:
        """
        An explanation of why your organization categorizes the model with its risk rating.
        """
        return pulumi.get(self, "explanations_for_risk_rating")

    @property
    @pulumi.getter(name="factorsAffectingModelEfficiency")
    def factors_affecting_model_efficiency(self) -> Optional[str]:
        """
        Factors affecting model efficacy.
        """
        return pulumi.get(self, "factors_affecting_model_efficiency")

    @property
    @pulumi.getter(name="intendedUses")
    def intended_uses(self) -> Optional[str]:
        """
        intended use cases.
        """
        return pulumi.get(self, "intended_uses")

    @property
    @pulumi.getter(name="purposeOfModel")
    def purpose_of_model(self) -> Optional[str]:
        """
        Why the model was developed?
        """
        return pulumi.get(self, "purpose_of_model")

    @property
    @pulumi.getter(name="riskRating")
    def risk_rating(self) -> Optional['ModelCardRiskRating']:
        """
        Your organization's risk rating. You can specify one the following values as the risk rating:

        - High
        - Medium
        - Low
        - Unknown
        """
        return pulumi.get(self, "risk_rating")


@pulumi.output_type
class ModelCardLinearGraphMetric(dict):
    """
    Linear graph metric.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "xAxisName":
            suggest = "x_axis_name"
        elif key == "yAxisName":
            suggest = "y_axis_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelCardLinearGraphMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelCardLinearGraphMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelCardLinearGraphMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 type: 'ModelCardLinearGraphMetricType',
                 value: Sequence[Sequence[float]],
                 notes: Optional[str] = None,
                 x_axis_name: Optional[str] = None,
                 y_axis_name: Optional[str] = None):
        """
        Linear graph metric.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if x_axis_name is not None:
            pulumi.set(__self__, "x_axis_name", x_axis_name)
        if y_axis_name is not None:
            pulumi.set(__self__, "y_axis_name", y_axis_name)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> 'ModelCardLinearGraphMetricType':
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Sequence[Sequence[float]]:
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def notes(self) -> Optional[str]:
        return pulumi.get(self, "notes")

    @property
    @pulumi.getter(name="xAxisName")
    def x_axis_name(self) -> Optional[str]:
        return pulumi.get(self, "x_axis_name")

    @property
    @pulumi.getter(name="yAxisName")
    def y_axis_name(self) -> Optional[str]:
        return pulumi.get(self, "y_axis_name")


@pulumi.output_type
class ModelCardMatrixMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "xAxisName":
            suggest = "x_axis_name"
        elif key == "yAxisName":
            suggest = "y_axis_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelCardMatrixMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelCardMatrixMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelCardMatrixMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 type: 'ModelCardMatrixMetricType',
                 value: Sequence[Sequence[float]],
                 notes: Optional[str] = None,
                 x_axis_name: Optional[Sequence[str]] = None,
                 y_axis_name: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if x_axis_name is not None:
            pulumi.set(__self__, "x_axis_name", x_axis_name)
        if y_axis_name is not None:
            pulumi.set(__self__, "y_axis_name", y_axis_name)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> 'ModelCardMatrixMetricType':
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Sequence[Sequence[float]]:
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def notes(self) -> Optional[str]:
        return pulumi.get(self, "notes")

    @property
    @pulumi.getter(name="xAxisName")
    def x_axis_name(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "x_axis_name")

    @property
    @pulumi.getter(name="yAxisName")
    def y_axis_name(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "y_axis_name")


@pulumi.output_type
class ModelCardMetricGroup(dict):
    """
    item in metric groups
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricData":
            suggest = "metric_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelCardMetricGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelCardMetricGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelCardMetricGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_data: Sequence[Any],
                 name: str):
        """
        item in metric groups
        """
        pulumi.set(__self__, "metric_data", metric_data)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="metricData")
    def metric_data(self) -> Sequence[Any]:
        return pulumi.get(self, "metric_data")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")


@pulumi.output_type
class ModelCardModelOverview(dict):
    """
    Overview about the model.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "algorithmType":
            suggest = "algorithm_type"
        elif key == "inferenceEnvironment":
            suggest = "inference_environment"
        elif key == "modelArtifact":
            suggest = "model_artifact"
        elif key == "modelCreator":
            suggest = "model_creator"
        elif key == "modelDescription":
            suggest = "model_description"
        elif key == "modelId":
            suggest = "model_id"
        elif key == "modelName":
            suggest = "model_name"
        elif key == "modelOwner":
            suggest = "model_owner"
        elif key == "modelVersion":
            suggest = "model_version"
        elif key == "problemType":
            suggest = "problem_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelCardModelOverview. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelCardModelOverview.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelCardModelOverview.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm_type: Optional[str] = None,
                 inference_environment: Optional['outputs.ModelCardModelOverviewInferenceEnvironmentProperties'] = None,
                 model_artifact: Optional[Sequence[str]] = None,
                 model_creator: Optional[str] = None,
                 model_description: Optional[str] = None,
                 model_id: Optional[str] = None,
                 model_name: Optional[str] = None,
                 model_owner: Optional[str] = None,
                 model_version: Optional[float] = None,
                 problem_type: Optional[str] = None):
        """
        Overview about the model.
        :param str algorithm_type: Algorithm used to solve the problem.
        :param 'ModelCardModelOverviewInferenceEnvironmentProperties' inference_environment: Overview about the inference.
        :param Sequence[str] model_artifact: Location of the model artifact.
        :param str model_creator: Creator of model.
        :param str model_description: description of model.
        :param str model_id: SageMaker Model Arn or Non SageMaker Model id.
        :param str model_name: Name of the model.
        :param str model_owner: Owner of model.
        :param float model_version: Version of the model.
        :param str problem_type: Problem being solved with the model.
        """
        if algorithm_type is not None:
            pulumi.set(__self__, "algorithm_type", algorithm_type)
        if inference_environment is not None:
            pulumi.set(__self__, "inference_environment", inference_environment)
        if model_artifact is not None:
            pulumi.set(__self__, "model_artifact", model_artifact)
        if model_creator is not None:
            pulumi.set(__self__, "model_creator", model_creator)
        if model_description is not None:
            pulumi.set(__self__, "model_description", model_description)
        if model_id is not None:
            pulumi.set(__self__, "model_id", model_id)
        if model_name is not None:
            pulumi.set(__self__, "model_name", model_name)
        if model_owner is not None:
            pulumi.set(__self__, "model_owner", model_owner)
        if model_version is not None:
            pulumi.set(__self__, "model_version", model_version)
        if problem_type is not None:
            pulumi.set(__self__, "problem_type", problem_type)

    @property
    @pulumi.getter(name="algorithmType")
    def algorithm_type(self) -> Optional[str]:
        """
        Algorithm used to solve the problem.
        """
        return pulumi.get(self, "algorithm_type")

    @property
    @pulumi.getter(name="inferenceEnvironment")
    def inference_environment(self) -> Optional['outputs.ModelCardModelOverviewInferenceEnvironmentProperties']:
        """
        Overview about the inference.
        """
        return pulumi.get(self, "inference_environment")

    @property
    @pulumi.getter(name="modelArtifact")
    def model_artifact(self) -> Optional[Sequence[str]]:
        """
        Location of the model artifact.
        """
        return pulumi.get(self, "model_artifact")

    @property
    @pulumi.getter(name="modelCreator")
    def model_creator(self) -> Optional[str]:
        """
        Creator of model.
        """
        return pulumi.get(self, "model_creator")

    @property
    @pulumi.getter(name="modelDescription")
    def model_description(self) -> Optional[str]:
        """
        description of model.
        """
        return pulumi.get(self, "model_description")

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[str]:
        """
        SageMaker Model Arn or Non SageMaker Model id.
        """
        return pulumi.get(self, "model_id")

    @property
    @pulumi.getter(name="modelName")
    def model_name(self) -> Optional[str]:
        """
        Name of the model.
        """
        return pulumi.get(self, "model_name")

    @property
    @pulumi.getter(name="modelOwner")
    def model_owner(self) -> Optional[str]:
        """
        Owner of model.
        """
        return pulumi.get(self, "model_owner")

    @property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> Optional[float]:
        """
        Version of the model.
        """
        return pulumi.get(self, "model_version")

    @property
    @pulumi.getter(name="problemType")
    def problem_type(self) -> Optional[str]:
        """
        Problem being solved with the model.
        """
        return pulumi.get(self, "problem_type")


@pulumi.output_type
class ModelCardModelOverviewInferenceEnvironmentProperties(dict):
    """
    Overview about the inference.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerImage":
            suggest = "container_image"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelCardModelOverviewInferenceEnvironmentProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelCardModelOverviewInferenceEnvironmentProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelCardModelOverviewInferenceEnvironmentProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_image: Optional[Sequence[str]] = None):
        """
        Overview about the inference.
        :param Sequence[str] container_image: SageMaker inference image uri.
        """
        if container_image is not None:
            pulumi.set(__self__, "container_image", container_image)

    @property
    @pulumi.getter(name="containerImage")
    def container_image(self) -> Optional[Sequence[str]]:
        """
        SageMaker inference image uri.
        """
        return pulumi.get(self, "container_image")


@pulumi.output_type
class ModelCardModelPackageCreator(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userProfileName":
            suggest = "user_profile_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelCardModelPackageCreator. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelCardModelPackageCreator.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelCardModelPackageCreator.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_profile_name: Optional[str] = None):
        """
        :param str user_profile_name: The name of the user's profile in Studio
        """
        if user_profile_name is not None:
            pulumi.set(__self__, "user_profile_name", user_profile_name)

    @property
    @pulumi.getter(name="userProfileName")
    def user_profile_name(self) -> Optional[str]:
        """
        The name of the user's profile in Studio
        """
        return pulumi.get(self, "user_profile_name")


@pulumi.output_type
class ModelCardModelPackageDetails(dict):
    """
    Metadata information related to model package version
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "approvalDescription":
            suggest = "approval_description"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "inferenceSpecification":
            suggest = "inference_specification"
        elif key == "modelApprovalStatus":
            suggest = "model_approval_status"
        elif key == "modelPackageArn":
            suggest = "model_package_arn"
        elif key == "modelPackageDescription":
            suggest = "model_package_description"
        elif key == "modelPackageGroupName":
            suggest = "model_package_group_name"
        elif key == "modelPackageName":
            suggest = "model_package_name"
        elif key == "modelPackageStatus":
            suggest = "model_package_status"
        elif key == "modelPackageVersion":
            suggest = "model_package_version"
        elif key == "sourceAlgorithms":
            suggest = "source_algorithms"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelCardModelPackageDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelCardModelPackageDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelCardModelPackageDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 approval_description: Optional[str] = None,
                 created_by: Optional['outputs.ModelCardModelPackageCreator'] = None,
                 domain: Optional[str] = None,
                 inference_specification: Optional['outputs.ModelCardInferenceSpecification'] = None,
                 model_approval_status: Optional['ModelCardModelPackageDetailsModelApprovalStatus'] = None,
                 model_package_arn: Optional[str] = None,
                 model_package_description: Optional[str] = None,
                 model_package_group_name: Optional[str] = None,
                 model_package_name: Optional[str] = None,
                 model_package_status: Optional['ModelCardModelPackageDetailsModelPackageStatus'] = None,
                 model_package_version: Optional[float] = None,
                 source_algorithms: Optional[Sequence['outputs.ModelCardSourceAlgorithm']] = None,
                 task: Optional[str] = None):
        """
        Metadata information related to model package version
        :param str approval_description: A description provided for the model approval
        :param 'ModelCardModelPackageCreator' created_by: Information about the user who created model package.
        :param str domain: The machine learning domain of the model package you specified. Common machine learning domains include computer vision and natural language processing.
        :param 'ModelCardInferenceSpecification' inference_specification: Details about inference jobs that can be run with models based on this model package.
        :param 'ModelCardModelPackageDetailsModelApprovalStatus' model_approval_status: Current approval status of model package
        :param str model_package_arn: The Amazon Resource Name (ARN) of the model package
        :param str model_package_description: A brief summary of the model package
        :param str model_package_group_name: If the model is a versioned model, the name of the model group that the versioned model belongs to.
        :param str model_package_name: Name of the model package
        :param 'ModelCardModelPackageDetailsModelPackageStatus' model_package_status: Current status of model package
        :param float model_package_version: Version of the model package
        :param Sequence['ModelCardSourceAlgorithm'] source_algorithms: A list of algorithms that were used to create a model package.
        :param str task: The machine learning task you specified that your model package accomplishes. Common machine learning tasks include object detection and image classification.
        """
        if approval_description is not None:
            pulumi.set(__self__, "approval_description", approval_description)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if inference_specification is not None:
            pulumi.set(__self__, "inference_specification", inference_specification)
        if model_approval_status is not None:
            pulumi.set(__self__, "model_approval_status", model_approval_status)
        if model_package_arn is not None:
            pulumi.set(__self__, "model_package_arn", model_package_arn)
        if model_package_description is not None:
            pulumi.set(__self__, "model_package_description", model_package_description)
        if model_package_group_name is not None:
            pulumi.set(__self__, "model_package_group_name", model_package_group_name)
        if model_package_name is not None:
            pulumi.set(__self__, "model_package_name", model_package_name)
        if model_package_status is not None:
            pulumi.set(__self__, "model_package_status", model_package_status)
        if model_package_version is not None:
            pulumi.set(__self__, "model_package_version", model_package_version)
        if source_algorithms is not None:
            pulumi.set(__self__, "source_algorithms", source_algorithms)
        if task is not None:
            pulumi.set(__self__, "task", task)

    @property
    @pulumi.getter(name="approvalDescription")
    def approval_description(self) -> Optional[str]:
        """
        A description provided for the model approval
        """
        return pulumi.get(self, "approval_description")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional['outputs.ModelCardModelPackageCreator']:
        """
        Information about the user who created model package.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        The machine learning domain of the model package you specified. Common machine learning domains include computer vision and natural language processing.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="inferenceSpecification")
    def inference_specification(self) -> Optional['outputs.ModelCardInferenceSpecification']:
        """
        Details about inference jobs that can be run with models based on this model package.
        """
        return pulumi.get(self, "inference_specification")

    @property
    @pulumi.getter(name="modelApprovalStatus")
    def model_approval_status(self) -> Optional['ModelCardModelPackageDetailsModelApprovalStatus']:
        """
        Current approval status of model package
        """
        return pulumi.get(self, "model_approval_status")

    @property
    @pulumi.getter(name="modelPackageArn")
    def model_package_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the model package
        """
        return pulumi.get(self, "model_package_arn")

    @property
    @pulumi.getter(name="modelPackageDescription")
    def model_package_description(self) -> Optional[str]:
        """
        A brief summary of the model package
        """
        return pulumi.get(self, "model_package_description")

    @property
    @pulumi.getter(name="modelPackageGroupName")
    def model_package_group_name(self) -> Optional[str]:
        """
        If the model is a versioned model, the name of the model group that the versioned model belongs to.
        """
        return pulumi.get(self, "model_package_group_name")

    @property
    @pulumi.getter(name="modelPackageName")
    def model_package_name(self) -> Optional[str]:
        """
        Name of the model package
        """
        return pulumi.get(self, "model_package_name")

    @property
    @pulumi.getter(name="modelPackageStatus")
    def model_package_status(self) -> Optional['ModelCardModelPackageDetailsModelPackageStatus']:
        """
        Current status of model package
        """
        return pulumi.get(self, "model_package_status")

    @property
    @pulumi.getter(name="modelPackageVersion")
    def model_package_version(self) -> Optional[float]:
        """
        Version of the model package
        """
        return pulumi.get(self, "model_package_version")

    @property
    @pulumi.getter(name="sourceAlgorithms")
    def source_algorithms(self) -> Optional[Sequence['outputs.ModelCardSourceAlgorithm']]:
        """
        A list of algorithms that were used to create a model package.
        """
        return pulumi.get(self, "source_algorithms")

    @property
    @pulumi.getter
    def task(self) -> Optional[str]:
        """
        The machine learning task you specified that your model package accomplishes. Common machine learning tasks include object detection and image classification.
        """
        return pulumi.get(self, "task")


@pulumi.output_type
class ModelCardObjectiveFunction(dict):
    """
    the objective function the model will optimize for.
    """
    def __init__(__self__, *,
                 function: Optional['outputs.ModelCardObjectiveFunctionFunctionProperties'] = None,
                 notes: Optional[str] = None):
        """
        the objective function the model will optimize for.
        :param 'ModelCardObjectiveFunctionFunctionProperties' function: objective function that training job is optimized for.
        :param str notes: Notes about the object function, including other considerations for possible objective functions.
        """
        if function is not None:
            pulumi.set(__self__, "function", function)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)

    @property
    @pulumi.getter
    def function(self) -> Optional['outputs.ModelCardObjectiveFunctionFunctionProperties']:
        """
        objective function that training job is optimized for.
        """
        return pulumi.get(self, "function")

    @property
    @pulumi.getter
    def notes(self) -> Optional[str]:
        """
        Notes about the object function, including other considerations for possible objective functions.
        """
        return pulumi.get(self, "notes")


@pulumi.output_type
class ModelCardObjectiveFunctionFunctionProperties(dict):
    """
    objective function that training job is optimized for.
    """
    def __init__(__self__, *,
                 condition: Optional[str] = None,
                 facet: Optional[str] = None,
                 function: Optional['ModelCardObjectiveFunctionFunctionPropertiesFunction'] = None):
        """
        objective function that training job is optimized for.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if facet is not None:
            pulumi.set(__self__, "facet", facet)
        if function is not None:
            pulumi.set(__self__, "function", function)

    @property
    @pulumi.getter
    def condition(self) -> Optional[str]:
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def facet(self) -> Optional[str]:
        return pulumi.get(self, "facet")

    @property
    @pulumi.getter
    def function(self) -> Optional['ModelCardObjectiveFunctionFunctionPropertiesFunction']:
        return pulumi.get(self, "function")


@pulumi.output_type
class ModelCardSecurityConfig(dict):
    """
    An optional Key Management Service key to encrypt, decrypt, and re-encrypt model card content for regulated workloads with highly sensitive data.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelCardSecurityConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelCardSecurityConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelCardSecurityConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_id: Optional[str] = None):
        """
        An optional Key Management Service key to encrypt, decrypt, and re-encrypt model card content for regulated workloads with highly sensitive data.


        :param str kms_key_id: A Key Management Service key ID to use for encrypting a model card.
        """
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        A Key Management Service key ID to use for encrypting a model card.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class ModelCardSimpleMetric(dict):
    """
    metric data
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "xAxisName":
            suggest = "x_axis_name"
        elif key == "yAxisName":
            suggest = "y_axis_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelCardSimpleMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelCardSimpleMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelCardSimpleMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 type: 'ModelCardSimpleMetricType',
                 value: Any,
                 notes: Optional[str] = None,
                 x_axis_name: Optional[str] = None,
                 y_axis_name: Optional[str] = None):
        """
        metric data
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if x_axis_name is not None:
            pulumi.set(__self__, "x_axis_name", x_axis_name)
        if y_axis_name is not None:
            pulumi.set(__self__, "y_axis_name", y_axis_name)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> 'ModelCardSimpleMetricType':
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Any:
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def notes(self) -> Optional[str]:
        return pulumi.get(self, "notes")

    @property
    @pulumi.getter(name="xAxisName")
    def x_axis_name(self) -> Optional[str]:
        return pulumi.get(self, "x_axis_name")

    @property
    @pulumi.getter(name="yAxisName")
    def y_axis_name(self) -> Optional[str]:
        return pulumi.get(self, "y_axis_name")


@pulumi.output_type
class ModelCardSourceAlgorithm(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "algorithmName":
            suggest = "algorithm_name"
        elif key == "modelDataUrl":
            suggest = "model_data_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelCardSourceAlgorithm. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelCardSourceAlgorithm.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelCardSourceAlgorithm.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm_name: str,
                 model_data_url: Optional[str] = None):
        """
        :param str algorithm_name: The name of an algorithm that was used to create the model package. The algorithm must be either an algorithm resource in your SageMaker account or an algorithm in AWS Marketplace that you are subscribed to.
        :param str model_data_url: The Amazon S3 path where the model artifacts, which result from model training, are stored.
        """
        pulumi.set(__self__, "algorithm_name", algorithm_name)
        if model_data_url is not None:
            pulumi.set(__self__, "model_data_url", model_data_url)

    @property
    @pulumi.getter(name="algorithmName")
    def algorithm_name(self) -> str:
        """
        The name of an algorithm that was used to create the model package. The algorithm must be either an algorithm resource in your SageMaker account or an algorithm in AWS Marketplace that you are subscribed to.
        """
        return pulumi.get(self, "algorithm_name")

    @property
    @pulumi.getter(name="modelDataUrl")
    def model_data_url(self) -> Optional[str]:
        """
        The Amazon S3 path where the model artifacts, which result from model training, are stored.
        """
        return pulumi.get(self, "model_data_url")


@pulumi.output_type
class ModelCardTrainingDetails(dict):
    """
    Overview about the training.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectiveFunction":
            suggest = "objective_function"
        elif key == "trainingJobDetails":
            suggest = "training_job_details"
        elif key == "trainingObservations":
            suggest = "training_observations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelCardTrainingDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelCardTrainingDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelCardTrainingDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 objective_function: Optional['outputs.ModelCardObjectiveFunction'] = None,
                 training_job_details: Optional['outputs.ModelCardTrainingDetailsTrainingJobDetailsProperties'] = None,
                 training_observations: Optional[str] = None):
        """
        Overview about the training.
        :param 'ModelCardObjectiveFunction' objective_function: The function that is optimized during model training.
        :param 'ModelCardTrainingDetailsTrainingJobDetailsProperties' training_job_details: Details about any associated training jobs.
        :param str training_observations: Any observations about training.
        """
        if objective_function is not None:
            pulumi.set(__self__, "objective_function", objective_function)
        if training_job_details is not None:
            pulumi.set(__self__, "training_job_details", training_job_details)
        if training_observations is not None:
            pulumi.set(__self__, "training_observations", training_observations)

    @property
    @pulumi.getter(name="objectiveFunction")
    def objective_function(self) -> Optional['outputs.ModelCardObjectiveFunction']:
        """
        The function that is optimized during model training.
        """
        return pulumi.get(self, "objective_function")

    @property
    @pulumi.getter(name="trainingJobDetails")
    def training_job_details(self) -> Optional['outputs.ModelCardTrainingDetailsTrainingJobDetailsProperties']:
        """
        Details about any associated training jobs.
        """
        return pulumi.get(self, "training_job_details")

    @property
    @pulumi.getter(name="trainingObservations")
    def training_observations(self) -> Optional[str]:
        """
        Any observations about training.
        """
        return pulumi.get(self, "training_observations")


@pulumi.output_type
class ModelCardTrainingDetailsTrainingJobDetailsProperties(dict):
    """
    Details about any associated training jobs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hyperParameters":
            suggest = "hyper_parameters"
        elif key == "trainingArn":
            suggest = "training_arn"
        elif key == "trainingDatasets":
            suggest = "training_datasets"
        elif key == "trainingEnvironment":
            suggest = "training_environment"
        elif key == "trainingMetrics":
            suggest = "training_metrics"
        elif key == "userProvidedHyperParameters":
            suggest = "user_provided_hyper_parameters"
        elif key == "userProvidedTrainingMetrics":
            suggest = "user_provided_training_metrics"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelCardTrainingDetailsTrainingJobDetailsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelCardTrainingDetailsTrainingJobDetailsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelCardTrainingDetailsTrainingJobDetailsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hyper_parameters: Optional[Sequence['outputs.ModelCardTrainingHyperParameter']] = None,
                 training_arn: Optional[str] = None,
                 training_datasets: Optional[Sequence[str]] = None,
                 training_environment: Optional['outputs.ModelCardTrainingDetailsTrainingJobDetailsPropertiesTrainingEnvironmentProperties'] = None,
                 training_metrics: Optional[Sequence['outputs.ModelCardTrainingMetric']] = None,
                 user_provided_hyper_parameters: Optional[Sequence['outputs.ModelCardTrainingHyperParameter']] = None,
                 user_provided_training_metrics: Optional[Sequence['outputs.ModelCardTrainingMetric']] = None):
        """
        Details about any associated training jobs.
        :param str training_arn: SageMaker Training job arn.
        :param Sequence[str] training_datasets: Location of the model datasets.
        """
        if hyper_parameters is not None:
            pulumi.set(__self__, "hyper_parameters", hyper_parameters)
        if training_arn is not None:
            pulumi.set(__self__, "training_arn", training_arn)
        if training_datasets is not None:
            pulumi.set(__self__, "training_datasets", training_datasets)
        if training_environment is not None:
            pulumi.set(__self__, "training_environment", training_environment)
        if training_metrics is not None:
            pulumi.set(__self__, "training_metrics", training_metrics)
        if user_provided_hyper_parameters is not None:
            pulumi.set(__self__, "user_provided_hyper_parameters", user_provided_hyper_parameters)
        if user_provided_training_metrics is not None:
            pulumi.set(__self__, "user_provided_training_metrics", user_provided_training_metrics)

    @property
    @pulumi.getter(name="hyperParameters")
    def hyper_parameters(self) -> Optional[Sequence['outputs.ModelCardTrainingHyperParameter']]:
        return pulumi.get(self, "hyper_parameters")

    @property
    @pulumi.getter(name="trainingArn")
    def training_arn(self) -> Optional[str]:
        """
        SageMaker Training job arn.
        """
        return pulumi.get(self, "training_arn")

    @property
    @pulumi.getter(name="trainingDatasets")
    def training_datasets(self) -> Optional[Sequence[str]]:
        """
        Location of the model datasets.
        """
        return pulumi.get(self, "training_datasets")

    @property
    @pulumi.getter(name="trainingEnvironment")
    def training_environment(self) -> Optional['outputs.ModelCardTrainingDetailsTrainingJobDetailsPropertiesTrainingEnvironmentProperties']:
        return pulumi.get(self, "training_environment")

    @property
    @pulumi.getter(name="trainingMetrics")
    def training_metrics(self) -> Optional[Sequence['outputs.ModelCardTrainingMetric']]:
        return pulumi.get(self, "training_metrics")

    @property
    @pulumi.getter(name="userProvidedHyperParameters")
    def user_provided_hyper_parameters(self) -> Optional[Sequence['outputs.ModelCardTrainingHyperParameter']]:
        return pulumi.get(self, "user_provided_hyper_parameters")

    @property
    @pulumi.getter(name="userProvidedTrainingMetrics")
    def user_provided_training_metrics(self) -> Optional[Sequence['outputs.ModelCardTrainingMetric']]:
        return pulumi.get(self, "user_provided_training_metrics")


@pulumi.output_type
class ModelCardTrainingDetailsTrainingJobDetailsPropertiesTrainingEnvironmentProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerImage":
            suggest = "container_image"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelCardTrainingDetailsTrainingJobDetailsPropertiesTrainingEnvironmentProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelCardTrainingDetailsTrainingJobDetailsPropertiesTrainingEnvironmentProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelCardTrainingDetailsTrainingJobDetailsPropertiesTrainingEnvironmentProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_image: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] container_image: SageMaker training image uri.
        """
        if container_image is not None:
            pulumi.set(__self__, "container_image", container_image)

    @property
    @pulumi.getter(name="containerImage")
    def container_image(self) -> Optional[Sequence[str]]:
        """
        SageMaker training image uri.
        """
        return pulumi.get(self, "container_image")


@pulumi.output_type
class ModelCardTrainingHyperParameter(dict):
    """
    training hyper parameter
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        training hyper parameter
        :param str name: The name of the hyper parameter.
        :param str value: The value specified for the hyper parameter.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the hyper parameter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value specified for the hyper parameter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ModelCardTrainingMetric(dict):
    """
    training metric data.
    """
    def __init__(__self__, *,
                 name: str,
                 value: float,
                 notes: Optional[str] = None):
        """
        training metric data.
        :param str name: The name of the result from the SageMaker training job.
        :param float value: The value of a result from the SageMaker training job.
        :param str notes: Any additional notes describing the result of the training job.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the result from the SageMaker training job.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> float:
        """
        The value of a result from the SageMaker training job.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def notes(self) -> Optional[str]:
        """
        Any additional notes describing the result of the training job.
        """
        return pulumi.get(self, "notes")


@pulumi.output_type
class ModelCardUserContext(dict):
    """
    Information about the user who created or modified an experiment, trial, trial component, lineage group, project, or model card.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainId":
            suggest = "domain_id"
        elif key == "userProfileArn":
            suggest = "user_profile_arn"
        elif key == "userProfileName":
            suggest = "user_profile_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelCardUserContext. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelCardUserContext.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelCardUserContext.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_id: Optional[str] = None,
                 user_profile_arn: Optional[str] = None,
                 user_profile_name: Optional[str] = None):
        """
        Information about the user who created or modified an experiment, trial, trial component, lineage group, project, or model card.
        :param str domain_id: The domain associated with the user.
        :param str user_profile_arn: The Amazon Resource Name (ARN) of the user's profile.
        :param str user_profile_name: The name of the user's profile.
        """
        if domain_id is not None:
            pulumi.set(__self__, "domain_id", domain_id)
        if user_profile_arn is not None:
            pulumi.set(__self__, "user_profile_arn", user_profile_arn)
        if user_profile_name is not None:
            pulumi.set(__self__, "user_profile_name", user_profile_name)

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[str]:
        """
        The domain associated with the user.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="userProfileArn")
    def user_profile_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the user's profile.
        """
        return pulumi.get(self, "user_profile_arn")

    @property
    @pulumi.getter(name="userProfileName")
    def user_profile_name(self) -> Optional[str]:
        """
        The name of the user's profile.
        """
        return pulumi.get(self, "user_profile_name")


@pulumi.output_type
class ModelExplainabilityJobDefinitionBatchTransformInput(dict):
    """
    The batch transform input for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataCapturedDestinationS3Uri":
            suggest = "data_captured_destination_s3_uri"
        elif key == "datasetFormat":
            suggest = "dataset_format"
        elif key == "localPath":
            suggest = "local_path"
        elif key == "featuresAttribute":
            suggest = "features_attribute"
        elif key == "inferenceAttribute":
            suggest = "inference_attribute"
        elif key == "probabilityAttribute":
            suggest = "probability_attribute"
        elif key == "s3DataDistributionType":
            suggest = "s3_data_distribution_type"
        elif key == "s3InputMode":
            suggest = "s3_input_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelExplainabilityJobDefinitionBatchTransformInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelExplainabilityJobDefinitionBatchTransformInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelExplainabilityJobDefinitionBatchTransformInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_captured_destination_s3_uri: str,
                 dataset_format: 'outputs.ModelExplainabilityJobDefinitionDatasetFormat',
                 local_path: str,
                 features_attribute: Optional[str] = None,
                 inference_attribute: Optional[str] = None,
                 probability_attribute: Optional[str] = None,
                 s3_data_distribution_type: Optional['ModelExplainabilityJobDefinitionBatchTransformInputS3DataDistributionType'] = None,
                 s3_input_mode: Optional['ModelExplainabilityJobDefinitionBatchTransformInputS3InputMode'] = None):
        """
        The batch transform input for a monitoring job.
        :param str data_captured_destination_s3_uri: A URI that identifies the Amazon S3 storage location where Batch Transform Job captures data.
        :param 'ModelExplainabilityJobDefinitionDatasetFormat' dataset_format: The dataset format for your batch transform job.
        :param str local_path: Path to the filesystem where the endpoint data is available to the container.
        :param str features_attribute: JSONpath to locate features in JSONlines dataset
        :param str inference_attribute: Index or JSONpath to locate predicted label(s)
        :param str probability_attribute: Index or JSONpath to locate probabilities
        :param 'ModelExplainabilityJobDefinitionBatchTransformInputS3DataDistributionType' s3_data_distribution_type: Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to FullyReplicated
        :param 'ModelExplainabilityJobDefinitionBatchTransformInputS3InputMode' s3_input_mode: Whether the Pipe or File is used as the input mode for transfering data for the monitoring job. Pipe mode is recommended for large datasets. File mode is useful for small files that fit in memory. Defaults to File.
        """
        pulumi.set(__self__, "data_captured_destination_s3_uri", data_captured_destination_s3_uri)
        pulumi.set(__self__, "dataset_format", dataset_format)
        pulumi.set(__self__, "local_path", local_path)
        if features_attribute is not None:
            pulumi.set(__self__, "features_attribute", features_attribute)
        if inference_attribute is not None:
            pulumi.set(__self__, "inference_attribute", inference_attribute)
        if probability_attribute is not None:
            pulumi.set(__self__, "probability_attribute", probability_attribute)
        if s3_data_distribution_type is not None:
            pulumi.set(__self__, "s3_data_distribution_type", s3_data_distribution_type)
        if s3_input_mode is not None:
            pulumi.set(__self__, "s3_input_mode", s3_input_mode)

    @property
    @pulumi.getter(name="dataCapturedDestinationS3Uri")
    def data_captured_destination_s3_uri(self) -> str:
        """
        A URI that identifies the Amazon S3 storage location where Batch Transform Job captures data.
        """
        return pulumi.get(self, "data_captured_destination_s3_uri")

    @property
    @pulumi.getter(name="datasetFormat")
    def dataset_format(self) -> 'outputs.ModelExplainabilityJobDefinitionDatasetFormat':
        """
        The dataset format for your batch transform job.
        """
        return pulumi.get(self, "dataset_format")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> str:
        """
        Path to the filesystem where the endpoint data is available to the container.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter(name="featuresAttribute")
    def features_attribute(self) -> Optional[str]:
        """
        JSONpath to locate features in JSONlines dataset
        """
        return pulumi.get(self, "features_attribute")

    @property
    @pulumi.getter(name="inferenceAttribute")
    def inference_attribute(self) -> Optional[str]:
        """
        Index or JSONpath to locate predicted label(s)
        """
        return pulumi.get(self, "inference_attribute")

    @property
    @pulumi.getter(name="probabilityAttribute")
    def probability_attribute(self) -> Optional[str]:
        """
        Index or JSONpath to locate probabilities
        """
        return pulumi.get(self, "probability_attribute")

    @property
    @pulumi.getter(name="s3DataDistributionType")
    def s3_data_distribution_type(self) -> Optional['ModelExplainabilityJobDefinitionBatchTransformInputS3DataDistributionType']:
        """
        Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to FullyReplicated
        """
        return pulumi.get(self, "s3_data_distribution_type")

    @property
    @pulumi.getter(name="s3InputMode")
    def s3_input_mode(self) -> Optional['ModelExplainabilityJobDefinitionBatchTransformInputS3InputMode']:
        """
        Whether the Pipe or File is used as the input mode for transfering data for the monitoring job. Pipe mode is recommended for large datasets. File mode is useful for small files that fit in memory. Defaults to File.
        """
        return pulumi.get(self, "s3_input_mode")


@pulumi.output_type
class ModelExplainabilityJobDefinitionClusterConfig(dict):
    """
    Configuration for the cluster used to run model monitoring jobs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceCount":
            suggest = "instance_count"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "volumeSizeInGb":
            suggest = "volume_size_in_gb"
        elif key == "volumeKmsKeyId":
            suggest = "volume_kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelExplainabilityJobDefinitionClusterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelExplainabilityJobDefinitionClusterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelExplainabilityJobDefinitionClusterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_count: int,
                 instance_type: str,
                 volume_size_in_gb: int,
                 volume_kms_key_id: Optional[str] = None):
        """
        Configuration for the cluster used to run model monitoring jobs.
        :param int instance_count: The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1. The default value is 1.
        :param str instance_type: The ML compute instance type for the processing job.
        :param int volume_size_in_gb: The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
        :param str volume_kms_key_id: The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
        """
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "volume_size_in_gb", volume_size_in_gb)
        if volume_kms_key_id is not None:
            pulumi.set(__self__, "volume_kms_key_id", volume_kms_key_id)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> int:
        """
        The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1. The default value is 1.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        The ML compute instance type for the processing job.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="volumeSizeInGb")
    def volume_size_in_gb(self) -> int:
        """
        The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
        """
        return pulumi.get(self, "volume_size_in_gb")

    @property
    @pulumi.getter(name="volumeKmsKeyId")
    def volume_kms_key_id(self) -> Optional[str]:
        """
        The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
        """
        return pulumi.get(self, "volume_kms_key_id")


@pulumi.output_type
class ModelExplainabilityJobDefinitionConstraintsResource(dict):
    """
    The baseline constraints resource for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Uri":
            suggest = "s3_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelExplainabilityJobDefinitionConstraintsResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelExplainabilityJobDefinitionConstraintsResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelExplainabilityJobDefinitionConstraintsResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_uri: Optional[str] = None):
        """
        The baseline constraints resource for a monitoring job.
        :param str s3_uri: The Amazon S3 URI for baseline constraint file in Amazon S3 that the current monitoring job should validated against.
        """
        if s3_uri is not None:
            pulumi.set(__self__, "s3_uri", s3_uri)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> Optional[str]:
        """
        The Amazon S3 URI for baseline constraint file in Amazon S3 that the current monitoring job should validated against.
        """
        return pulumi.get(self, "s3_uri")


@pulumi.output_type
class ModelExplainabilityJobDefinitionCsv(dict):
    """
    The CSV format
    """
    def __init__(__self__, *,
                 header: Optional[bool] = None):
        """
        The CSV format
        :param bool header: A boolean flag indicating if given CSV has header
        """
        if header is not None:
            pulumi.set(__self__, "header", header)

    @property
    @pulumi.getter
    def header(self) -> Optional[bool]:
        """
        A boolean flag indicating if given CSV has header
        """
        return pulumi.get(self, "header")


@pulumi.output_type
class ModelExplainabilityJobDefinitionDatasetFormat(dict):
    """
    The dataset format of the data to monitor
    """
    def __init__(__self__, *,
                 csv: Optional['outputs.ModelExplainabilityJobDefinitionCsv'] = None,
                 json: Optional['outputs.ModelExplainabilityJobDefinitionJson'] = None,
                 parquet: Optional[bool] = None):
        """
        The dataset format of the data to monitor
        """
        if csv is not None:
            pulumi.set(__self__, "csv", csv)
        if json is not None:
            pulumi.set(__self__, "json", json)
        if parquet is not None:
            pulumi.set(__self__, "parquet", parquet)

    @property
    @pulumi.getter
    def csv(self) -> Optional['outputs.ModelExplainabilityJobDefinitionCsv']:
        return pulumi.get(self, "csv")

    @property
    @pulumi.getter
    def json(self) -> Optional['outputs.ModelExplainabilityJobDefinitionJson']:
        return pulumi.get(self, "json")

    @property
    @pulumi.getter
    def parquet(self) -> Optional[bool]:
        return pulumi.get(self, "parquet")


@pulumi.output_type
class ModelExplainabilityJobDefinitionEndpointInput(dict):
    """
    The endpoint for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointName":
            suggest = "endpoint_name"
        elif key == "localPath":
            suggest = "local_path"
        elif key == "featuresAttribute":
            suggest = "features_attribute"
        elif key == "inferenceAttribute":
            suggest = "inference_attribute"
        elif key == "probabilityAttribute":
            suggest = "probability_attribute"
        elif key == "s3DataDistributionType":
            suggest = "s3_data_distribution_type"
        elif key == "s3InputMode":
            suggest = "s3_input_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelExplainabilityJobDefinitionEndpointInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelExplainabilityJobDefinitionEndpointInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelExplainabilityJobDefinitionEndpointInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_name: str,
                 local_path: str,
                 features_attribute: Optional[str] = None,
                 inference_attribute: Optional[str] = None,
                 probability_attribute: Optional[str] = None,
                 s3_data_distribution_type: Optional['ModelExplainabilityJobDefinitionEndpointInputS3DataDistributionType'] = None,
                 s3_input_mode: Optional['ModelExplainabilityJobDefinitionEndpointInputS3InputMode'] = None):
        """
        The endpoint for a monitoring job.
        :param str endpoint_name: An endpoint in customer's account which has enabled `DataCaptureConfig` enabled.
        :param str local_path: Path to the filesystem where the endpoint data is available to the container.
        :param str features_attribute: JSONpath to locate features in JSONlines dataset
        :param str inference_attribute: Index or JSONpath to locate predicted label(s)
        :param str probability_attribute: Index or JSONpath to locate probabilities
        :param 'ModelExplainabilityJobDefinitionEndpointInputS3DataDistributionType' s3_data_distribution_type: Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to FullyReplicated
        :param 'ModelExplainabilityJobDefinitionEndpointInputS3InputMode' s3_input_mode: Whether the Pipe or File is used as the input mode for transfering data for the monitoring job. Pipe mode is recommended for large datasets. File mode is useful for small files that fit in memory. Defaults to File.
        """
        pulumi.set(__self__, "endpoint_name", endpoint_name)
        pulumi.set(__self__, "local_path", local_path)
        if features_attribute is not None:
            pulumi.set(__self__, "features_attribute", features_attribute)
        if inference_attribute is not None:
            pulumi.set(__self__, "inference_attribute", inference_attribute)
        if probability_attribute is not None:
            pulumi.set(__self__, "probability_attribute", probability_attribute)
        if s3_data_distribution_type is not None:
            pulumi.set(__self__, "s3_data_distribution_type", s3_data_distribution_type)
        if s3_input_mode is not None:
            pulumi.set(__self__, "s3_input_mode", s3_input_mode)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> str:
        """
        An endpoint in customer's account which has enabled `DataCaptureConfig` enabled.
        """
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> str:
        """
        Path to the filesystem where the endpoint data is available to the container.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter(name="featuresAttribute")
    def features_attribute(self) -> Optional[str]:
        """
        JSONpath to locate features in JSONlines dataset
        """
        return pulumi.get(self, "features_attribute")

    @property
    @pulumi.getter(name="inferenceAttribute")
    def inference_attribute(self) -> Optional[str]:
        """
        Index or JSONpath to locate predicted label(s)
        """
        return pulumi.get(self, "inference_attribute")

    @property
    @pulumi.getter(name="probabilityAttribute")
    def probability_attribute(self) -> Optional[str]:
        """
        Index or JSONpath to locate probabilities
        """
        return pulumi.get(self, "probability_attribute")

    @property
    @pulumi.getter(name="s3DataDistributionType")
    def s3_data_distribution_type(self) -> Optional['ModelExplainabilityJobDefinitionEndpointInputS3DataDistributionType']:
        """
        Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to FullyReplicated
        """
        return pulumi.get(self, "s3_data_distribution_type")

    @property
    @pulumi.getter(name="s3InputMode")
    def s3_input_mode(self) -> Optional['ModelExplainabilityJobDefinitionEndpointInputS3InputMode']:
        """
        Whether the Pipe or File is used as the input mode for transfering data for the monitoring job. Pipe mode is recommended for large datasets. File mode is useful for small files that fit in memory. Defaults to File.
        """
        return pulumi.get(self, "s3_input_mode")


@pulumi.output_type
class ModelExplainabilityJobDefinitionJson(dict):
    """
    The Json format
    """
    def __init__(__self__, *,
                 line: Optional[bool] = None):
        """
        The Json format
        :param bool line: A boolean flag indicating if it is JSON line format
        """
        if line is not None:
            pulumi.set(__self__, "line", line)

    @property
    @pulumi.getter
    def line(self) -> Optional[bool]:
        """
        A boolean flag indicating if it is JSON line format
        """
        return pulumi.get(self, "line")


@pulumi.output_type
class ModelExplainabilityJobDefinitionModelExplainabilityAppSpecification(dict):
    """
    Container image configuration object for the monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configUri":
            suggest = "config_uri"
        elif key == "imageUri":
            suggest = "image_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelExplainabilityJobDefinitionModelExplainabilityAppSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelExplainabilityJobDefinitionModelExplainabilityAppSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelExplainabilityJobDefinitionModelExplainabilityAppSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_uri: str,
                 image_uri: str,
                 environment: Optional[Any] = None):
        """
        Container image configuration object for the monitoring job.
        :param str config_uri: The S3 URI to an analysis configuration file
        :param str image_uri: The container image to be run by the monitoring job.
        :param Any environment: Sets the environment variables in the Docker container
        """
        pulumi.set(__self__, "config_uri", config_uri)
        pulumi.set(__self__, "image_uri", image_uri)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)

    @property
    @pulumi.getter(name="configUri")
    def config_uri(self) -> str:
        """
        The S3 URI to an analysis configuration file
        """
        return pulumi.get(self, "config_uri")

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> str:
        """
        The container image to be run by the monitoring job.
        """
        return pulumi.get(self, "image_uri")

    @property
    @pulumi.getter
    def environment(self) -> Optional[Any]:
        """
        Sets the environment variables in the Docker container
        """
        return pulumi.get(self, "environment")


@pulumi.output_type
class ModelExplainabilityJobDefinitionModelExplainabilityBaselineConfig(dict):
    """
    Baseline configuration used to validate that the data conforms to the specified constraints and statistics.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseliningJobName":
            suggest = "baselining_job_name"
        elif key == "constraintsResource":
            suggest = "constraints_resource"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelExplainabilityJobDefinitionModelExplainabilityBaselineConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelExplainabilityJobDefinitionModelExplainabilityBaselineConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelExplainabilityJobDefinitionModelExplainabilityBaselineConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 baselining_job_name: Optional[str] = None,
                 constraints_resource: Optional['outputs.ModelExplainabilityJobDefinitionConstraintsResource'] = None):
        """
        Baseline configuration used to validate that the data conforms to the specified constraints and statistics.
        :param str baselining_job_name: The name of the baseline model explainability job.
        :param 'ModelExplainabilityJobDefinitionConstraintsResource' constraints_resource: The constraints resource for a model explainability job.
        """
        if baselining_job_name is not None:
            pulumi.set(__self__, "baselining_job_name", baselining_job_name)
        if constraints_resource is not None:
            pulumi.set(__self__, "constraints_resource", constraints_resource)

    @property
    @pulumi.getter(name="baseliningJobName")
    def baselining_job_name(self) -> Optional[str]:
        """
        The name of the baseline model explainability job.
        """
        return pulumi.get(self, "baselining_job_name")

    @property
    @pulumi.getter(name="constraintsResource")
    def constraints_resource(self) -> Optional['outputs.ModelExplainabilityJobDefinitionConstraintsResource']:
        """
        The constraints resource for a model explainability job.
        """
        return pulumi.get(self, "constraints_resource")


@pulumi.output_type
class ModelExplainabilityJobDefinitionModelExplainabilityJobInput(dict):
    """
    The inputs for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "batchTransformInput":
            suggest = "batch_transform_input"
        elif key == "endpointInput":
            suggest = "endpoint_input"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelExplainabilityJobDefinitionModelExplainabilityJobInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelExplainabilityJobDefinitionModelExplainabilityJobInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelExplainabilityJobDefinitionModelExplainabilityJobInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 batch_transform_input: Optional['outputs.ModelExplainabilityJobDefinitionBatchTransformInput'] = None,
                 endpoint_input: Optional['outputs.ModelExplainabilityJobDefinitionEndpointInput'] = None):
        """
        The inputs for a monitoring job.
        :param 'ModelExplainabilityJobDefinitionBatchTransformInput' batch_transform_input: Input object for the batch transform job.
        :param 'ModelExplainabilityJobDefinitionEndpointInput' endpoint_input: Input object for the endpoint
        """
        if batch_transform_input is not None:
            pulumi.set(__self__, "batch_transform_input", batch_transform_input)
        if endpoint_input is not None:
            pulumi.set(__self__, "endpoint_input", endpoint_input)

    @property
    @pulumi.getter(name="batchTransformInput")
    def batch_transform_input(self) -> Optional['outputs.ModelExplainabilityJobDefinitionBatchTransformInput']:
        """
        Input object for the batch transform job.
        """
        return pulumi.get(self, "batch_transform_input")

    @property
    @pulumi.getter(name="endpointInput")
    def endpoint_input(self) -> Optional['outputs.ModelExplainabilityJobDefinitionEndpointInput']:
        """
        Input object for the endpoint
        """
        return pulumi.get(self, "endpoint_input")


@pulumi.output_type
class ModelExplainabilityJobDefinitionMonitoringOutput(dict):
    """
    The output object for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Output":
            suggest = "s3_output"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelExplainabilityJobDefinitionMonitoringOutput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelExplainabilityJobDefinitionMonitoringOutput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelExplainabilityJobDefinitionMonitoringOutput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_output: 'outputs.ModelExplainabilityJobDefinitionS3Output'):
        """
        The output object for a monitoring job.
        :param 'ModelExplainabilityJobDefinitionS3Output' s3_output: The Amazon S3 storage location where the results of a monitoring job are saved.
        """
        pulumi.set(__self__, "s3_output", s3_output)

    @property
    @pulumi.getter(name="s3Output")
    def s3_output(self) -> 'outputs.ModelExplainabilityJobDefinitionS3Output':
        """
        The Amazon S3 storage location where the results of a monitoring job are saved.
        """
        return pulumi.get(self, "s3_output")


@pulumi.output_type
class ModelExplainabilityJobDefinitionMonitoringOutputConfig(dict):
    """
    The output configuration for monitoring jobs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "monitoringOutputs":
            suggest = "monitoring_outputs"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelExplainabilityJobDefinitionMonitoringOutputConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelExplainabilityJobDefinitionMonitoringOutputConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelExplainabilityJobDefinitionMonitoringOutputConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 monitoring_outputs: Sequence['outputs.ModelExplainabilityJobDefinitionMonitoringOutput'],
                 kms_key_id: Optional[str] = None):
        """
        The output configuration for monitoring jobs.
        :param Sequence['ModelExplainabilityJobDefinitionMonitoringOutput'] monitoring_outputs: Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
        :param str kms_key_id: The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
        """
        pulumi.set(__self__, "monitoring_outputs", monitoring_outputs)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="monitoringOutputs")
    def monitoring_outputs(self) -> Sequence['outputs.ModelExplainabilityJobDefinitionMonitoringOutput']:
        """
        Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
        """
        return pulumi.get(self, "monitoring_outputs")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class ModelExplainabilityJobDefinitionMonitoringResources(dict):
    """
    Identifies the resources to deploy for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterConfig":
            suggest = "cluster_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelExplainabilityJobDefinitionMonitoringResources. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelExplainabilityJobDefinitionMonitoringResources.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelExplainabilityJobDefinitionMonitoringResources.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_config: 'outputs.ModelExplainabilityJobDefinitionClusterConfig'):
        """
        Identifies the resources to deploy for a monitoring job.
        :param 'ModelExplainabilityJobDefinitionClusterConfig' cluster_config: The configuration for the cluster resources used to run the processing job.
        """
        pulumi.set(__self__, "cluster_config", cluster_config)

    @property
    @pulumi.getter(name="clusterConfig")
    def cluster_config(self) -> 'outputs.ModelExplainabilityJobDefinitionClusterConfig':
        """
        The configuration for the cluster resources used to run the processing job.
        """
        return pulumi.get(self, "cluster_config")


@pulumi.output_type
class ModelExplainabilityJobDefinitionNetworkConfig(dict):
    """
    Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableInterContainerTrafficEncryption":
            suggest = "enable_inter_container_traffic_encryption"
        elif key == "enableNetworkIsolation":
            suggest = "enable_network_isolation"
        elif key == "vpcConfig":
            suggest = "vpc_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelExplainabilityJobDefinitionNetworkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelExplainabilityJobDefinitionNetworkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelExplainabilityJobDefinitionNetworkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_inter_container_traffic_encryption: Optional[bool] = None,
                 enable_network_isolation: Optional[bool] = None,
                 vpc_config: Optional['outputs.ModelExplainabilityJobDefinitionVpcConfig'] = None):
        """
        Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
        :param bool enable_inter_container_traffic_encryption: Whether to encrypt all communications between distributed processing jobs. Choose True to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
        :param bool enable_network_isolation: Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
        :param 'ModelExplainabilityJobDefinitionVpcConfig' vpc_config: Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.
        """
        if enable_inter_container_traffic_encryption is not None:
            pulumi.set(__self__, "enable_inter_container_traffic_encryption", enable_inter_container_traffic_encryption)
        if enable_network_isolation is not None:
            pulumi.set(__self__, "enable_network_isolation", enable_network_isolation)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @property
    @pulumi.getter(name="enableInterContainerTrafficEncryption")
    def enable_inter_container_traffic_encryption(self) -> Optional[bool]:
        """
        Whether to encrypt all communications between distributed processing jobs. Choose True to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
        """
        return pulumi.get(self, "enable_inter_container_traffic_encryption")

    @property
    @pulumi.getter(name="enableNetworkIsolation")
    def enable_network_isolation(self) -> Optional[bool]:
        """
        Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
        """
        return pulumi.get(self, "enable_network_isolation")

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional['outputs.ModelExplainabilityJobDefinitionVpcConfig']:
        """
        Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.
        """
        return pulumi.get(self, "vpc_config")


@pulumi.output_type
class ModelExplainabilityJobDefinitionS3Output(dict):
    """
    Information about where and how to store the results of a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localPath":
            suggest = "local_path"
        elif key == "s3Uri":
            suggest = "s3_uri"
        elif key == "s3UploadMode":
            suggest = "s3_upload_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelExplainabilityJobDefinitionS3Output. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelExplainabilityJobDefinitionS3Output.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelExplainabilityJobDefinitionS3Output.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_path: str,
                 s3_uri: str,
                 s3_upload_mode: Optional['ModelExplainabilityJobDefinitionS3OutputS3UploadMode'] = None):
        """
        Information about where and how to store the results of a monitoring job.
        :param str local_path: The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. LocalPath is an absolute path for the output data.
        :param str s3_uri: A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
        :param 'ModelExplainabilityJobDefinitionS3OutputS3UploadMode' s3_upload_mode: Whether to upload the results of the monitoring job continuously or after the job completes.
        """
        pulumi.set(__self__, "local_path", local_path)
        pulumi.set(__self__, "s3_uri", s3_uri)
        if s3_upload_mode is not None:
            pulumi.set(__self__, "s3_upload_mode", s3_upload_mode)

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> str:
        """
        The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. LocalPath is an absolute path for the output data.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> str:
        """
        A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
        """
        return pulumi.get(self, "s3_uri")

    @property
    @pulumi.getter(name="s3UploadMode")
    def s3_upload_mode(self) -> Optional['ModelExplainabilityJobDefinitionS3OutputS3UploadMode']:
        """
        Whether to upload the results of the monitoring job continuously or after the job completes.
        """
        return pulumi.get(self, "s3_upload_mode")


@pulumi.output_type
class ModelExplainabilityJobDefinitionStoppingCondition(dict):
    """
    Specifies a time limit for how long the monitoring job is allowed to run.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxRuntimeInSeconds":
            suggest = "max_runtime_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelExplainabilityJobDefinitionStoppingCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelExplainabilityJobDefinitionStoppingCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelExplainabilityJobDefinitionStoppingCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_runtime_in_seconds: int):
        """
        Specifies a time limit for how long the monitoring job is allowed to run.
        :param int max_runtime_in_seconds: The maximum runtime allowed in seconds.
        """
        pulumi.set(__self__, "max_runtime_in_seconds", max_runtime_in_seconds)

    @property
    @pulumi.getter(name="maxRuntimeInSeconds")
    def max_runtime_in_seconds(self) -> int:
        """
        The maximum runtime allowed in seconds.
        """
        return pulumi.get(self, "max_runtime_in_seconds")


@pulumi.output_type
class ModelExplainabilityJobDefinitionVpcConfig(dict):
    """
    Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupIds":
            suggest = "security_group_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelExplainabilityJobDefinitionVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelExplainabilityJobDefinitionVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelExplainabilityJobDefinitionVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_ids: Sequence[str],
                 subnets: Sequence[str]):
        """
        Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.
        :param Sequence[str] security_group_ids: The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the Subnets field.
        :param Sequence[str] subnets: The ID of the subnets in the VPC to which you want to connect to your monitoring jobs.
        """
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[str]:
        """
        The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the Subnets field.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[str]:
        """
        The ID of the subnets in the VPC to which you want to connect to your monitoring jobs.
        """
        return pulumi.get(self, "subnets")


@pulumi.output_type
class ModelPackageAdditionalInferenceSpecificationDefinition(dict):
    """
    Additional Inference Specification specifies details about inference jobs that can be run with models based on this model package.AdditionalInferenceSpecifications can be added to existing model packages using AdditionalInferenceSpecificationsToAdd.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "supportedContentTypes":
            suggest = "supported_content_types"
        elif key == "supportedRealtimeInferenceInstanceTypes":
            suggest = "supported_realtime_inference_instance_types"
        elif key == "supportedResponseMimeTypes":
            suggest = "supported_response_mime_types"
        elif key == "supportedTransformInstanceTypes":
            suggest = "supported_transform_instance_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelPackageAdditionalInferenceSpecificationDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelPackageAdditionalInferenceSpecificationDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelPackageAdditionalInferenceSpecificationDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 containers: Sequence['outputs.ModelPackageContainerDefinition'],
                 name: str,
                 description: Optional[str] = None,
                 supported_content_types: Optional[Sequence[str]] = None,
                 supported_realtime_inference_instance_types: Optional[Sequence[str]] = None,
                 supported_response_mime_types: Optional[Sequence[str]] = None,
                 supported_transform_instance_types: Optional[Sequence[str]] = None):
        """
        Additional Inference Specification specifies details about inference jobs that can be run with models based on this model package.AdditionalInferenceSpecifications can be added to existing model packages using AdditionalInferenceSpecificationsToAdd.
        :param Sequence['ModelPackageContainerDefinition'] containers: The Amazon ECR registry path of the Docker image that contains the inference code.
        :param str name: A unique name to identify the additional inference specification. The name must be unique within the list of your additional inference specifications for a particular model package.
        :param str description: A description of the additional Inference specification.
        :param Sequence[str] supported_content_types: The supported MIME types for the input data.
        :param Sequence[str] supported_realtime_inference_instance_types: A list of the instance types that are used to generate inferences in real-time
        :param Sequence[str] supported_response_mime_types: The supported MIME types for the output data.
        :param Sequence[str] supported_transform_instance_types: A list of the instance types on which a transformation job can be run or on which an endpoint can be deployed.
        """
        pulumi.set(__self__, "containers", containers)
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if supported_content_types is not None:
            pulumi.set(__self__, "supported_content_types", supported_content_types)
        if supported_realtime_inference_instance_types is not None:
            pulumi.set(__self__, "supported_realtime_inference_instance_types", supported_realtime_inference_instance_types)
        if supported_response_mime_types is not None:
            pulumi.set(__self__, "supported_response_mime_types", supported_response_mime_types)
        if supported_transform_instance_types is not None:
            pulumi.set(__self__, "supported_transform_instance_types", supported_transform_instance_types)

    @property
    @pulumi.getter
    def containers(self) -> Sequence['outputs.ModelPackageContainerDefinition']:
        """
        The Amazon ECR registry path of the Docker image that contains the inference code.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify the additional inference specification. The name must be unique within the list of your additional inference specifications for a particular model package.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of the additional Inference specification.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="supportedContentTypes")
    def supported_content_types(self) -> Optional[Sequence[str]]:
        """
        The supported MIME types for the input data.
        """
        return pulumi.get(self, "supported_content_types")

    @property
    @pulumi.getter(name="supportedRealtimeInferenceInstanceTypes")
    def supported_realtime_inference_instance_types(self) -> Optional[Sequence[str]]:
        """
        A list of the instance types that are used to generate inferences in real-time
        """
        return pulumi.get(self, "supported_realtime_inference_instance_types")

    @property
    @pulumi.getter(name="supportedResponseMimeTypes")
    def supported_response_mime_types(self) -> Optional[Sequence[str]]:
        """
        The supported MIME types for the output data.
        """
        return pulumi.get(self, "supported_response_mime_types")

    @property
    @pulumi.getter(name="supportedTransformInstanceTypes")
    def supported_transform_instance_types(self) -> Optional[Sequence[str]]:
        """
        A list of the instance types on which a transformation job can be run or on which an endpoint can be deployed.
        """
        return pulumi.get(self, "supported_transform_instance_types")


@pulumi.output_type
class ModelPackageBias(dict):
    """
    Contains bias metrics for a model.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postTrainingReport":
            suggest = "post_training_report"
        elif key == "preTrainingReport":
            suggest = "pre_training_report"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelPackageBias. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelPackageBias.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelPackageBias.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 post_training_report: Optional['outputs.ModelPackageMetricsSource'] = None,
                 pre_training_report: Optional['outputs.ModelPackageMetricsSource'] = None,
                 report: Optional['outputs.ModelPackageMetricsSource'] = None):
        """
        Contains bias metrics for a model.
        :param 'ModelPackageMetricsSource' post_training_report: The post-training bias report for a model.
        :param 'ModelPackageMetricsSource' pre_training_report: The pre-training bias report for a model.
        :param 'ModelPackageMetricsSource' report: The bias report for a model
        """
        if post_training_report is not None:
            pulumi.set(__self__, "post_training_report", post_training_report)
        if pre_training_report is not None:
            pulumi.set(__self__, "pre_training_report", pre_training_report)
        if report is not None:
            pulumi.set(__self__, "report", report)

    @property
    @pulumi.getter(name="postTrainingReport")
    def post_training_report(self) -> Optional['outputs.ModelPackageMetricsSource']:
        """
        The post-training bias report for a model.
        """
        return pulumi.get(self, "post_training_report")

    @property
    @pulumi.getter(name="preTrainingReport")
    def pre_training_report(self) -> Optional['outputs.ModelPackageMetricsSource']:
        """
        The pre-training bias report for a model.
        """
        return pulumi.get(self, "pre_training_report")

    @property
    @pulumi.getter
    def report(self) -> Optional['outputs.ModelPackageMetricsSource']:
        """
        The bias report for a model
        """
        return pulumi.get(self, "report")


@pulumi.output_type
class ModelPackageContainerDefinition(dict):
    """
    Describes the Docker container for the model package.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerHostname":
            suggest = "container_hostname"
        elif key == "frameworkVersion":
            suggest = "framework_version"
        elif key == "imageDigest":
            suggest = "image_digest"
        elif key == "modelDataSource":
            suggest = "model_data_source"
        elif key == "modelDataUrl":
            suggest = "model_data_url"
        elif key == "modelInput":
            suggest = "model_input"
        elif key == "nearestModelName":
            suggest = "nearest_model_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelPackageContainerDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelPackageContainerDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelPackageContainerDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: str,
                 container_hostname: Optional[str] = None,
                 environment: Optional['outputs.ModelPackageEnvironment'] = None,
                 framework: Optional[str] = None,
                 framework_version: Optional[str] = None,
                 image_digest: Optional[str] = None,
                 model_data_source: Optional['outputs.ModelPackageModelDataSource'] = None,
                 model_data_url: Optional[str] = None,
                 model_input: Optional['outputs.ModelPackageContainerDefinitionModelInputProperties'] = None,
                 nearest_model_name: Optional[str] = None):
        """
        Describes the Docker container for the model package.
        :param str image: The Amazon EC2 Container Registry (Amazon ECR) path where inference code is stored.
        :param str container_hostname: The DNS host name for the Docker container.
        :param str framework: The machine learning framework of the model package container image.
        :param str framework_version: The framework version of the Model Package Container Image.
        :param str image_digest: An MD5 hash of the training algorithm that identifies the Docker image used for training.
        :param str model_data_url: A structure with Model Input details.
        :param str nearest_model_name: The name of a pre-trained machine learning benchmarked by Amazon SageMaker Inference Recommender model that matches your model.
        """
        pulumi.set(__self__, "image", image)
        if container_hostname is not None:
            pulumi.set(__self__, "container_hostname", container_hostname)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if framework is not None:
            pulumi.set(__self__, "framework", framework)
        if framework_version is not None:
            pulumi.set(__self__, "framework_version", framework_version)
        if image_digest is not None:
            pulumi.set(__self__, "image_digest", image_digest)
        if model_data_source is not None:
            pulumi.set(__self__, "model_data_source", model_data_source)
        if model_data_url is not None:
            pulumi.set(__self__, "model_data_url", model_data_url)
        if model_input is not None:
            pulumi.set(__self__, "model_input", model_input)
        if nearest_model_name is not None:
            pulumi.set(__self__, "nearest_model_name", nearest_model_name)

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        The Amazon EC2 Container Registry (Amazon ECR) path where inference code is stored.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="containerHostname")
    def container_hostname(self) -> Optional[str]:
        """
        The DNS host name for the Docker container.
        """
        return pulumi.get(self, "container_hostname")

    @property
    @pulumi.getter
    def environment(self) -> Optional['outputs.ModelPackageEnvironment']:
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def framework(self) -> Optional[str]:
        """
        The machine learning framework of the model package container image.
        """
        return pulumi.get(self, "framework")

    @property
    @pulumi.getter(name="frameworkVersion")
    def framework_version(self) -> Optional[str]:
        """
        The framework version of the Model Package Container Image.
        """
        return pulumi.get(self, "framework_version")

    @property
    @pulumi.getter(name="imageDigest")
    def image_digest(self) -> Optional[str]:
        """
        An MD5 hash of the training algorithm that identifies the Docker image used for training.
        """
        return pulumi.get(self, "image_digest")

    @property
    @pulumi.getter(name="modelDataSource")
    def model_data_source(self) -> Optional['outputs.ModelPackageModelDataSource']:
        return pulumi.get(self, "model_data_source")

    @property
    @pulumi.getter(name="modelDataUrl")
    def model_data_url(self) -> Optional[str]:
        """
        A structure with Model Input details.
        """
        return pulumi.get(self, "model_data_url")

    @property
    @pulumi.getter(name="modelInput")
    def model_input(self) -> Optional['outputs.ModelPackageContainerDefinitionModelInputProperties']:
        return pulumi.get(self, "model_input")

    @property
    @pulumi.getter(name="nearestModelName")
    def nearest_model_name(self) -> Optional[str]:
        """
        The name of a pre-trained machine learning benchmarked by Amazon SageMaker Inference Recommender model that matches your model.
        """
        return pulumi.get(self, "nearest_model_name")


@pulumi.output_type
class ModelPackageContainerDefinitionModelInputProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataInputConfig":
            suggest = "data_input_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelPackageContainerDefinitionModelInputProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelPackageContainerDefinitionModelInputProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelPackageContainerDefinitionModelInputProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_input_config: str):
        """
        :param str data_input_config: The input configuration object for the model.
        """
        pulumi.set(__self__, "data_input_config", data_input_config)

    @property
    @pulumi.getter(name="dataInputConfig")
    def data_input_config(self) -> str:
        """
        The input configuration object for the model.
        """
        return pulumi.get(self, "data_input_config")


@pulumi.output_type
class ModelPackageCustomerMetadataProperties(dict):
    """
    The metadata properties associated with the model package versions.
    """
    def __init__(__self__):
        """
        The metadata properties associated with the model package versions.
        """
        pass


@pulumi.output_type
class ModelPackageDataSource(dict):
    """
    Describes the input source of a transform job and the way the transform job consumes it.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3DataSource":
            suggest = "s3_data_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelPackageDataSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelPackageDataSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelPackageDataSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_data_source: 'outputs.ModelPackageS3DataSource'):
        """
        Describes the input source of a transform job and the way the transform job consumes it.
        :param 'ModelPackageS3DataSource' s3_data_source: The S3 location of the data source that is associated with a channel.
        """
        pulumi.set(__self__, "s3_data_source", s3_data_source)

    @property
    @pulumi.getter(name="s3DataSource")
    def s3_data_source(self) -> 'outputs.ModelPackageS3DataSource':
        """
        The S3 location of the data source that is associated with a channel.
        """
        return pulumi.get(self, "s3_data_source")


@pulumi.output_type
class ModelPackageDriftCheckBaselines(dict):
    """
    Represents the drift check baselines that can be used when the model monitor is set using the model package.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "modelDataQuality":
            suggest = "model_data_quality"
        elif key == "modelQuality":
            suggest = "model_quality"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelPackageDriftCheckBaselines. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelPackageDriftCheckBaselines.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelPackageDriftCheckBaselines.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bias: Optional['outputs.ModelPackageDriftCheckBias'] = None,
                 explainability: Optional['outputs.ModelPackageDriftCheckExplainability'] = None,
                 model_data_quality: Optional['outputs.ModelPackageDriftCheckModelDataQuality'] = None,
                 model_quality: Optional['outputs.ModelPackageDriftCheckModelQuality'] = None):
        """
        Represents the drift check baselines that can be used when the model monitor is set using the model package.
        :param 'ModelPackageDriftCheckBias' bias: Represents the drift check bias baselines that can be used when the model monitor is set using the model package.
        :param 'ModelPackageDriftCheckExplainability' explainability: Represents the drift check explainability baselines that can be used when the model monitor is set using the model package.
        :param 'ModelPackageDriftCheckModelDataQuality' model_data_quality: Represents the drift check model data quality baselines that can be used when the model monitor is set using the model package.
        :param 'ModelPackageDriftCheckModelQuality' model_quality: Represents the drift check model quality baselines that can be used when the model monitor is set using the model package.
        """
        if bias is not None:
            pulumi.set(__self__, "bias", bias)
        if explainability is not None:
            pulumi.set(__self__, "explainability", explainability)
        if model_data_quality is not None:
            pulumi.set(__self__, "model_data_quality", model_data_quality)
        if model_quality is not None:
            pulumi.set(__self__, "model_quality", model_quality)

    @property
    @pulumi.getter
    def bias(self) -> Optional['outputs.ModelPackageDriftCheckBias']:
        """
        Represents the drift check bias baselines that can be used when the model monitor is set using the model package.
        """
        return pulumi.get(self, "bias")

    @property
    @pulumi.getter
    def explainability(self) -> Optional['outputs.ModelPackageDriftCheckExplainability']:
        """
        Represents the drift check explainability baselines that can be used when the model monitor is set using the model package.
        """
        return pulumi.get(self, "explainability")

    @property
    @pulumi.getter(name="modelDataQuality")
    def model_data_quality(self) -> Optional['outputs.ModelPackageDriftCheckModelDataQuality']:
        """
        Represents the drift check model data quality baselines that can be used when the model monitor is set using the model package.
        """
        return pulumi.get(self, "model_data_quality")

    @property
    @pulumi.getter(name="modelQuality")
    def model_quality(self) -> Optional['outputs.ModelPackageDriftCheckModelQuality']:
        """
        Represents the drift check model quality baselines that can be used when the model monitor is set using the model package.
        """
        return pulumi.get(self, "model_quality")


@pulumi.output_type
class ModelPackageDriftCheckBias(dict):
    """
    Represents the drift check bias baselines that can be used when the model monitor is set using the model package.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configFile":
            suggest = "config_file"
        elif key == "postTrainingConstraints":
            suggest = "post_training_constraints"
        elif key == "preTrainingConstraints":
            suggest = "pre_training_constraints"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelPackageDriftCheckBias. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelPackageDriftCheckBias.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelPackageDriftCheckBias.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_file: Optional['outputs.ModelPackageFileSource'] = None,
                 post_training_constraints: Optional['outputs.ModelPackageMetricsSource'] = None,
                 pre_training_constraints: Optional['outputs.ModelPackageMetricsSource'] = None):
        """
        Represents the drift check bias baselines that can be used when the model monitor is set using the model package.
        :param 'ModelPackageFileSource' config_file: The bias config file for a model.
        :param 'ModelPackageMetricsSource' post_training_constraints: The post-training constraints.
        :param 'ModelPackageMetricsSource' pre_training_constraints: The pre-training constraints.
        """
        if config_file is not None:
            pulumi.set(__self__, "config_file", config_file)
        if post_training_constraints is not None:
            pulumi.set(__self__, "post_training_constraints", post_training_constraints)
        if pre_training_constraints is not None:
            pulumi.set(__self__, "pre_training_constraints", pre_training_constraints)

    @property
    @pulumi.getter(name="configFile")
    def config_file(self) -> Optional['outputs.ModelPackageFileSource']:
        """
        The bias config file for a model.
        """
        return pulumi.get(self, "config_file")

    @property
    @pulumi.getter(name="postTrainingConstraints")
    def post_training_constraints(self) -> Optional['outputs.ModelPackageMetricsSource']:
        """
        The post-training constraints.
        """
        return pulumi.get(self, "post_training_constraints")

    @property
    @pulumi.getter(name="preTrainingConstraints")
    def pre_training_constraints(self) -> Optional['outputs.ModelPackageMetricsSource']:
        """
        The pre-training constraints.
        """
        return pulumi.get(self, "pre_training_constraints")


@pulumi.output_type
class ModelPackageDriftCheckExplainability(dict):
    """
    Contains explainability metrics for a model.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configFile":
            suggest = "config_file"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelPackageDriftCheckExplainability. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelPackageDriftCheckExplainability.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelPackageDriftCheckExplainability.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_file: Optional['outputs.ModelPackageFileSource'] = None,
                 constraints: Optional['outputs.ModelPackageMetricsSource'] = None):
        """
        Contains explainability metrics for a model.
        :param 'ModelPackageFileSource' config_file: The explainability config file for the model.
        :param 'ModelPackageMetricsSource' constraints: The drift check explainability constraints.
        """
        if config_file is not None:
            pulumi.set(__self__, "config_file", config_file)
        if constraints is not None:
            pulumi.set(__self__, "constraints", constraints)

    @property
    @pulumi.getter(name="configFile")
    def config_file(self) -> Optional['outputs.ModelPackageFileSource']:
        """
        The explainability config file for the model.
        """
        return pulumi.get(self, "config_file")

    @property
    @pulumi.getter
    def constraints(self) -> Optional['outputs.ModelPackageMetricsSource']:
        """
        The drift check explainability constraints.
        """
        return pulumi.get(self, "constraints")


@pulumi.output_type
class ModelPackageDriftCheckModelDataQuality(dict):
    """
    Represents the drift check data quality baselines that can be used when the model monitor is set using the model package.
    """
    def __init__(__self__, *,
                 constraints: Optional['outputs.ModelPackageMetricsSource'] = None,
                 statistics: Optional['outputs.ModelPackageMetricsSource'] = None):
        """
        Represents the drift check data quality baselines that can be used when the model monitor is set using the model package.
        :param 'ModelPackageMetricsSource' constraints: The drift check model data quality constraints.
        :param 'ModelPackageMetricsSource' statistics: The drift check model data quality statistics.
        """
        if constraints is not None:
            pulumi.set(__self__, "constraints", constraints)
        if statistics is not None:
            pulumi.set(__self__, "statistics", statistics)

    @property
    @pulumi.getter
    def constraints(self) -> Optional['outputs.ModelPackageMetricsSource']:
        """
        The drift check model data quality constraints.
        """
        return pulumi.get(self, "constraints")

    @property
    @pulumi.getter
    def statistics(self) -> Optional['outputs.ModelPackageMetricsSource']:
        """
        The drift check model data quality statistics.
        """
        return pulumi.get(self, "statistics")


@pulumi.output_type
class ModelPackageDriftCheckModelQuality(dict):
    """
    Represents the drift check model quality baselines that can be used when the model monitor is set using the model package.
    """
    def __init__(__self__, *,
                 constraints: Optional['outputs.ModelPackageMetricsSource'] = None,
                 statistics: Optional['outputs.ModelPackageMetricsSource'] = None):
        """
        Represents the drift check model quality baselines that can be used when the model monitor is set using the model package.
        :param 'ModelPackageMetricsSource' constraints: The drift check model quality constraints.
        :param 'ModelPackageMetricsSource' statistics: The drift check model quality statistics.
        """
        if constraints is not None:
            pulumi.set(__self__, "constraints", constraints)
        if statistics is not None:
            pulumi.set(__self__, "statistics", statistics)

    @property
    @pulumi.getter
    def constraints(self) -> Optional['outputs.ModelPackageMetricsSource']:
        """
        The drift check model quality constraints.
        """
        return pulumi.get(self, "constraints")

    @property
    @pulumi.getter
    def statistics(self) -> Optional['outputs.ModelPackageMetricsSource']:
        """
        The drift check model quality statistics.
        """
        return pulumi.get(self, "statistics")


@pulumi.output_type
class ModelPackageEnvironment(dict):
    """
    Sets the environment variables in the Docker container
    """
    def __init__(__self__):
        """
        Sets the environment variables in the Docker container
        """
        pass


@pulumi.output_type
class ModelPackageExplainability(dict):
    """
    Contains explainability metrics for a model.
    """
    def __init__(__self__, *,
                 report: Optional['outputs.ModelPackageMetricsSource'] = None):
        """
        Contains explainability metrics for a model.
        :param 'ModelPackageMetricsSource' report: The explainability report for a model.
        """
        if report is not None:
            pulumi.set(__self__, "report", report)

    @property
    @pulumi.getter
    def report(self) -> Optional['outputs.ModelPackageMetricsSource']:
        """
        The explainability report for a model.
        """
        return pulumi.get(self, "report")


@pulumi.output_type
class ModelPackageFileSource(dict):
    """
    Represents a File Source Object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Uri":
            suggest = "s3_uri"
        elif key == "contentDigest":
            suggest = "content_digest"
        elif key == "contentType":
            suggest = "content_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelPackageFileSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelPackageFileSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelPackageFileSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_uri: str,
                 content_digest: Optional[str] = None,
                 content_type: Optional[str] = None):
        """
        Represents a File Source Object.
        :param str s3_uri: The Amazon S3 URI for the file source.
        :param str content_digest: The digest of the file source.
        :param str content_type: The type of content stored in the file source.
        """
        pulumi.set(__self__, "s3_uri", s3_uri)
        if content_digest is not None:
            pulumi.set(__self__, "content_digest", content_digest)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> str:
        """
        The Amazon S3 URI for the file source.
        """
        return pulumi.get(self, "s3_uri")

    @property
    @pulumi.getter(name="contentDigest")
    def content_digest(self) -> Optional[str]:
        """
        The digest of the file source.
        """
        return pulumi.get(self, "content_digest")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[str]:
        """
        The type of content stored in the file source.
        """
        return pulumi.get(self, "content_type")


@pulumi.output_type
class ModelPackageInferenceSpecification(dict):
    """
    Details about inference jobs that can be run with models based on this model package.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "supportedContentTypes":
            suggest = "supported_content_types"
        elif key == "supportedResponseMimeTypes":
            suggest = "supported_response_mime_types"
        elif key == "supportedRealtimeInferenceInstanceTypes":
            suggest = "supported_realtime_inference_instance_types"
        elif key == "supportedTransformInstanceTypes":
            suggest = "supported_transform_instance_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelPackageInferenceSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelPackageInferenceSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelPackageInferenceSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 containers: Sequence['outputs.ModelPackageContainerDefinition'],
                 supported_content_types: Sequence[str],
                 supported_response_mime_types: Sequence[str],
                 supported_realtime_inference_instance_types: Optional[Sequence[str]] = None,
                 supported_transform_instance_types: Optional[Sequence[str]] = None):
        """
        Details about inference jobs that can be run with models based on this model package.
        :param Sequence['ModelPackageContainerDefinition'] containers: The Amazon ECR registry path of the Docker image that contains the inference code.
        :param Sequence[str] supported_content_types: The supported MIME types for the input data.
        :param Sequence[str] supported_response_mime_types: The supported MIME types for the output data.
        :param Sequence[str] supported_realtime_inference_instance_types: A list of the instance types that are used to generate inferences in real-time
        :param Sequence[str] supported_transform_instance_types: A list of the instance types on which a transformation job can be run or on which an endpoint can be deployed.
        """
        pulumi.set(__self__, "containers", containers)
        pulumi.set(__self__, "supported_content_types", supported_content_types)
        pulumi.set(__self__, "supported_response_mime_types", supported_response_mime_types)
        if supported_realtime_inference_instance_types is not None:
            pulumi.set(__self__, "supported_realtime_inference_instance_types", supported_realtime_inference_instance_types)
        if supported_transform_instance_types is not None:
            pulumi.set(__self__, "supported_transform_instance_types", supported_transform_instance_types)

    @property
    @pulumi.getter
    def containers(self) -> Sequence['outputs.ModelPackageContainerDefinition']:
        """
        The Amazon ECR registry path of the Docker image that contains the inference code.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter(name="supportedContentTypes")
    def supported_content_types(self) -> Sequence[str]:
        """
        The supported MIME types for the input data.
        """
        return pulumi.get(self, "supported_content_types")

    @property
    @pulumi.getter(name="supportedResponseMimeTypes")
    def supported_response_mime_types(self) -> Sequence[str]:
        """
        The supported MIME types for the output data.
        """
        return pulumi.get(self, "supported_response_mime_types")

    @property
    @pulumi.getter(name="supportedRealtimeInferenceInstanceTypes")
    def supported_realtime_inference_instance_types(self) -> Optional[Sequence[str]]:
        """
        A list of the instance types that are used to generate inferences in real-time
        """
        return pulumi.get(self, "supported_realtime_inference_instance_types")

    @property
    @pulumi.getter(name="supportedTransformInstanceTypes")
    def supported_transform_instance_types(self) -> Optional[Sequence[str]]:
        """
        A list of the instance types on which a transformation job can be run or on which an endpoint can be deployed.
        """
        return pulumi.get(self, "supported_transform_instance_types")


@pulumi.output_type
class ModelPackageMetadataProperties(dict):
    """
    Metadata properties of the tracking entity, trial, or trial component.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commitId":
            suggest = "commit_id"
        elif key == "generatedBy":
            suggest = "generated_by"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelPackageMetadataProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelPackageMetadataProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelPackageMetadataProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 commit_id: Optional[str] = None,
                 generated_by: Optional[str] = None,
                 project_id: Optional[str] = None,
                 repository: Optional[str] = None):
        """
        Metadata properties of the tracking entity, trial, or trial component.
        :param str commit_id: The commit ID.
        :param str generated_by: The entity this entity was generated by.
        :param str project_id: The project ID metadata.
        :param str repository: The repository metadata.
        """
        if commit_id is not None:
            pulumi.set(__self__, "commit_id", commit_id)
        if generated_by is not None:
            pulumi.set(__self__, "generated_by", generated_by)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)

    @property
    @pulumi.getter(name="commitId")
    def commit_id(self) -> Optional[str]:
        """
        The commit ID.
        """
        return pulumi.get(self, "commit_id")

    @property
    @pulumi.getter(name="generatedBy")
    def generated_by(self) -> Optional[str]:
        """
        The entity this entity was generated by.
        """
        return pulumi.get(self, "generated_by")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        """
        The project ID metadata.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def repository(self) -> Optional[str]:
        """
        The repository metadata.
        """
        return pulumi.get(self, "repository")


@pulumi.output_type
class ModelPackageMetricsSource(dict):
    """
    Represents a Metric Source Object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "s3Uri":
            suggest = "s3_uri"
        elif key == "contentDigest":
            suggest = "content_digest"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelPackageMetricsSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelPackageMetricsSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelPackageMetricsSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_type: str,
                 s3_uri: str,
                 content_digest: Optional[str] = None):
        """
        Represents a Metric Source Object.
        :param str content_type: The type of content stored in the metric source.
        :param str s3_uri: The Amazon S3 URI for the metric source.
        :param str content_digest: The digest of the metric source.
        """
        pulumi.set(__self__, "content_type", content_type)
        pulumi.set(__self__, "s3_uri", s3_uri)
        if content_digest is not None:
            pulumi.set(__self__, "content_digest", content_digest)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        The type of content stored in the metric source.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> str:
        """
        The Amazon S3 URI for the metric source.
        """
        return pulumi.get(self, "s3_uri")

    @property
    @pulumi.getter(name="contentDigest")
    def content_digest(self) -> Optional[str]:
        """
        The digest of the metric source.
        """
        return pulumi.get(self, "content_digest")


@pulumi.output_type
class ModelPackageModelAccessConfig(dict):
    """
    Specifies the access configuration file for the ML model.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceptEula":
            suggest = "accept_eula"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelPackageModelAccessConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelPackageModelAccessConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelPackageModelAccessConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accept_eula: bool):
        """
        Specifies the access configuration file for the ML model.
        :param bool accept_eula: Specifies agreement to the model end-user license agreement (EULA).
        """
        pulumi.set(__self__, "accept_eula", accept_eula)

    @property
    @pulumi.getter(name="acceptEula")
    def accept_eula(self) -> bool:
        """
        Specifies agreement to the model end-user license agreement (EULA).
        """
        return pulumi.get(self, "accept_eula")


@pulumi.output_type
class ModelPackageModelCard(dict):
    """
    The model card associated with the model package.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "modelCardContent":
            suggest = "model_card_content"
        elif key == "modelCardStatus":
            suggest = "model_card_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelPackageModelCard. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelPackageModelCard.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelPackageModelCard.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 model_card_content: str,
                 model_card_status: 'ModelPackageModelCardModelCardStatus'):
        """
        The model card associated with the model package.
        :param str model_card_content: The content of the model card.
        :param 'ModelPackageModelCardModelCardStatus' model_card_status: The approval status of the model card within your organization.
        """
        pulumi.set(__self__, "model_card_content", model_card_content)
        pulumi.set(__self__, "model_card_status", model_card_status)

    @property
    @pulumi.getter(name="modelCardContent")
    def model_card_content(self) -> str:
        """
        The content of the model card.
        """
        return pulumi.get(self, "model_card_content")

    @property
    @pulumi.getter(name="modelCardStatus")
    def model_card_status(self) -> 'ModelPackageModelCardModelCardStatus':
        """
        The approval status of the model card within your organization.
        """
        return pulumi.get(self, "model_card_status")


@pulumi.output_type
class ModelPackageModelDataQuality(dict):
    """
    Metrics that measure the quality of the input data for a model.
    """
    def __init__(__self__, *,
                 constraints: Optional['outputs.ModelPackageMetricsSource'] = None,
                 statistics: Optional['outputs.ModelPackageMetricsSource'] = None):
        """
        Metrics that measure the quality of the input data for a model.
        :param 'ModelPackageMetricsSource' constraints: Data quality constraints for a model.
        :param 'ModelPackageMetricsSource' statistics: Data quality statistics for a model.
        """
        if constraints is not None:
            pulumi.set(__self__, "constraints", constraints)
        if statistics is not None:
            pulumi.set(__self__, "statistics", statistics)

    @property
    @pulumi.getter
    def constraints(self) -> Optional['outputs.ModelPackageMetricsSource']:
        """
        Data quality constraints for a model.
        """
        return pulumi.get(self, "constraints")

    @property
    @pulumi.getter
    def statistics(self) -> Optional['outputs.ModelPackageMetricsSource']:
        """
        Data quality statistics for a model.
        """
        return pulumi.get(self, "statistics")


@pulumi.output_type
class ModelPackageModelDataSource(dict):
    """
    Specifies the location of ML model data to deploy during endpoint creation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3DataSource":
            suggest = "s3_data_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelPackageModelDataSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelPackageModelDataSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelPackageModelDataSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_data_source: Optional['outputs.ModelPackageS3ModelDataSource'] = None):
        """
        Specifies the location of ML model data to deploy during endpoint creation.
        """
        if s3_data_source is not None:
            pulumi.set(__self__, "s3_data_source", s3_data_source)

    @property
    @pulumi.getter(name="s3DataSource")
    def s3_data_source(self) -> Optional['outputs.ModelPackageS3ModelDataSource']:
        return pulumi.get(self, "s3_data_source")


@pulumi.output_type
class ModelPackageModelMetrics(dict):
    """
    A structure that contains model metrics reports.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "modelDataQuality":
            suggest = "model_data_quality"
        elif key == "modelQuality":
            suggest = "model_quality"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelPackageModelMetrics. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelPackageModelMetrics.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelPackageModelMetrics.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bias: Optional['outputs.ModelPackageBias'] = None,
                 explainability: Optional['outputs.ModelPackageExplainability'] = None,
                 model_data_quality: Optional['outputs.ModelPackageModelDataQuality'] = None,
                 model_quality: Optional['outputs.ModelPackageModelQuality'] = None):
        """
        A structure that contains model metrics reports.
        :param 'ModelPackageBias' bias: Metrics that measure bias in a model.
        :param 'ModelPackageExplainability' explainability: Metrics that help explain a model.
        :param 'ModelPackageModelDataQuality' model_data_quality: Metrics that measure the quality of the input data for a model.
        :param 'ModelPackageModelQuality' model_quality: Metrics that measure the quality of a model.
        """
        if bias is not None:
            pulumi.set(__self__, "bias", bias)
        if explainability is not None:
            pulumi.set(__self__, "explainability", explainability)
        if model_data_quality is not None:
            pulumi.set(__self__, "model_data_quality", model_data_quality)
        if model_quality is not None:
            pulumi.set(__self__, "model_quality", model_quality)

    @property
    @pulumi.getter
    def bias(self) -> Optional['outputs.ModelPackageBias']:
        """
        Metrics that measure bias in a model.
        """
        return pulumi.get(self, "bias")

    @property
    @pulumi.getter
    def explainability(self) -> Optional['outputs.ModelPackageExplainability']:
        """
        Metrics that help explain a model.
        """
        return pulumi.get(self, "explainability")

    @property
    @pulumi.getter(name="modelDataQuality")
    def model_data_quality(self) -> Optional['outputs.ModelPackageModelDataQuality']:
        """
        Metrics that measure the quality of the input data for a model.
        """
        return pulumi.get(self, "model_data_quality")

    @property
    @pulumi.getter(name="modelQuality")
    def model_quality(self) -> Optional['outputs.ModelPackageModelQuality']:
        """
        Metrics that measure the quality of a model.
        """
        return pulumi.get(self, "model_quality")


@pulumi.output_type
class ModelPackageModelQuality(dict):
    """
    Metrics that measure the quality of a model.
    """
    def __init__(__self__, *,
                 constraints: Optional['outputs.ModelPackageMetricsSource'] = None,
                 statistics: Optional['outputs.ModelPackageMetricsSource'] = None):
        """
        Metrics that measure the quality of a model.
        :param 'ModelPackageMetricsSource' constraints: Model quality constraints.
        :param 'ModelPackageMetricsSource' statistics: Model quality statistics.
        """
        if constraints is not None:
            pulumi.set(__self__, "constraints", constraints)
        if statistics is not None:
            pulumi.set(__self__, "statistics", statistics)

    @property
    @pulumi.getter
    def constraints(self) -> Optional['outputs.ModelPackageMetricsSource']:
        """
        Model quality constraints.
        """
        return pulumi.get(self, "constraints")

    @property
    @pulumi.getter
    def statistics(self) -> Optional['outputs.ModelPackageMetricsSource']:
        """
        Model quality statistics.
        """
        return pulumi.get(self, "statistics")


@pulumi.output_type
class ModelPackageS3DataSource(dict):
    """
    Describes the S3 data source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3DataType":
            suggest = "s3_data_type"
        elif key == "s3Uri":
            suggest = "s3_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelPackageS3DataSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelPackageS3DataSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelPackageS3DataSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_data_type: 'ModelPackageS3DataSourceS3DataType',
                 s3_uri: str):
        """
        Describes the S3 data source.
        :param 'ModelPackageS3DataSourceS3DataType' s3_data_type: The S3 Data Source Type
        :param str s3_uri: Depending on the value specified for the S3DataType, identifies either a key name prefix or a manifest.
        """
        pulumi.set(__self__, "s3_data_type", s3_data_type)
        pulumi.set(__self__, "s3_uri", s3_uri)

    @property
    @pulumi.getter(name="s3DataType")
    def s3_data_type(self) -> 'ModelPackageS3DataSourceS3DataType':
        """
        The S3 Data Source Type
        """
        return pulumi.get(self, "s3_data_type")

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> str:
        """
        Depending on the value specified for the S3DataType, identifies either a key name prefix or a manifest.
        """
        return pulumi.get(self, "s3_uri")


@pulumi.output_type
class ModelPackageS3ModelDataSource(dict):
    """
    Specifies the S3 location of ML model data to deploy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compressionType":
            suggest = "compression_type"
        elif key == "s3DataType":
            suggest = "s3_data_type"
        elif key == "s3Uri":
            suggest = "s3_uri"
        elif key == "modelAccessConfig":
            suggest = "model_access_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelPackageS3ModelDataSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelPackageS3ModelDataSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelPackageS3ModelDataSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compression_type: 'ModelPackageS3ModelDataSourceCompressionType',
                 s3_data_type: 'ModelPackageS3ModelDataSourceS3DataType',
                 s3_uri: str,
                 model_access_config: Optional['outputs.ModelPackageModelAccessConfig'] = None):
        """
        Specifies the S3 location of ML model data to deploy.
        :param 'ModelPackageS3ModelDataSourceCompressionType' compression_type: Specifies how the ML model data is prepared.
        :param 'ModelPackageS3ModelDataSourceS3DataType' s3_data_type: Specifies the type of ML model data to deploy.
        :param str s3_uri: Specifies the S3 path of ML model data to deploy.
        """
        pulumi.set(__self__, "compression_type", compression_type)
        pulumi.set(__self__, "s3_data_type", s3_data_type)
        pulumi.set(__self__, "s3_uri", s3_uri)
        if model_access_config is not None:
            pulumi.set(__self__, "model_access_config", model_access_config)

    @property
    @pulumi.getter(name="compressionType")
    def compression_type(self) -> 'ModelPackageS3ModelDataSourceCompressionType':
        """
        Specifies how the ML model data is prepared.
        """
        return pulumi.get(self, "compression_type")

    @property
    @pulumi.getter(name="s3DataType")
    def s3_data_type(self) -> 'ModelPackageS3ModelDataSourceS3DataType':
        """
        Specifies the type of ML model data to deploy.
        """
        return pulumi.get(self, "s3_data_type")

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> str:
        """
        Specifies the S3 path of ML model data to deploy.
        """
        return pulumi.get(self, "s3_uri")

    @property
    @pulumi.getter(name="modelAccessConfig")
    def model_access_config(self) -> Optional['outputs.ModelPackageModelAccessConfig']:
        return pulumi.get(self, "model_access_config")


@pulumi.output_type
class ModelPackageSecurityConfig(dict):
    """
    An optional AWS Key Management Service key to encrypt, decrypt, and re-encrypt model package information for regulated workloads with highly sensitive data.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelPackageSecurityConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelPackageSecurityConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelPackageSecurityConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_id: str):
        """
        An optional AWS Key Management Service key to encrypt, decrypt, and re-encrypt model package information for regulated workloads with highly sensitive data.
        :param str kms_key_id: The AWS KMS Key ID (KMSKeyId) used for encryption of model package information.
        """
        pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> str:
        """
        The AWS KMS Key ID (KMSKeyId) used for encryption of model package information.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class ModelPackageSourceAlgorithm(dict):
    """
    Specifies an algorithm that was used to create the model package. The algorithm must be either an algorithm resource in your Amazon SageMaker account or an algorithm in AWS Marketplace that you are subscribed to.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "algorithmName":
            suggest = "algorithm_name"
        elif key == "modelDataUrl":
            suggest = "model_data_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelPackageSourceAlgorithm. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelPackageSourceAlgorithm.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelPackageSourceAlgorithm.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm_name: str,
                 model_data_url: Optional[str] = None):
        """
        Specifies an algorithm that was used to create the model package. The algorithm must be either an algorithm resource in your Amazon SageMaker account or an algorithm in AWS Marketplace that you are subscribed to.
        :param str algorithm_name: The name of an algorithm that was used to create the model package. The algorithm must be either an algorithm resource in your Amazon SageMaker account or an algorithm in AWS Marketplace that you are subscribed to.
        :param str model_data_url: The Amazon S3 path where the model artifacts, which result from model training, are stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix).
        """
        pulumi.set(__self__, "algorithm_name", algorithm_name)
        if model_data_url is not None:
            pulumi.set(__self__, "model_data_url", model_data_url)

    @property
    @pulumi.getter(name="algorithmName")
    def algorithm_name(self) -> str:
        """
        The name of an algorithm that was used to create the model package. The algorithm must be either an algorithm resource in your Amazon SageMaker account or an algorithm in AWS Marketplace that you are subscribed to.
        """
        return pulumi.get(self, "algorithm_name")

    @property
    @pulumi.getter(name="modelDataUrl")
    def model_data_url(self) -> Optional[str]:
        """
        The Amazon S3 path where the model artifacts, which result from model training, are stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix).
        """
        return pulumi.get(self, "model_data_url")


@pulumi.output_type
class ModelPackageSourceAlgorithmSpecification(dict):
    """
    Details about the algorithm that was used to create the model package.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceAlgorithms":
            suggest = "source_algorithms"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelPackageSourceAlgorithmSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelPackageSourceAlgorithmSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelPackageSourceAlgorithmSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_algorithms: Sequence['outputs.ModelPackageSourceAlgorithm']):
        """
        Details about the algorithm that was used to create the model package.
        :param Sequence['ModelPackageSourceAlgorithm'] source_algorithms: A list of algorithms that were used to create a model package.
        """
        pulumi.set(__self__, "source_algorithms", source_algorithms)

    @property
    @pulumi.getter(name="sourceAlgorithms")
    def source_algorithms(self) -> Sequence['outputs.ModelPackageSourceAlgorithm']:
        """
        A list of algorithms that were used to create a model package.
        """
        return pulumi.get(self, "source_algorithms")


@pulumi.output_type
class ModelPackageStatusDetails(dict):
    """
    Details about the current status of the model package.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "validationStatuses":
            suggest = "validation_statuses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelPackageStatusDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelPackageStatusDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelPackageStatusDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 validation_statuses: Optional[Sequence['outputs.ModelPackageStatusItem']] = None):
        """
        Details about the current status of the model package.
        :param Sequence['ModelPackageStatusItem'] validation_statuses: The validation status of the model package.
        """
        if validation_statuses is not None:
            pulumi.set(__self__, "validation_statuses", validation_statuses)

    @property
    @pulumi.getter(name="validationStatuses")
    def validation_statuses(self) -> Optional[Sequence['outputs.ModelPackageStatusItem']]:
        """
        The validation status of the model package.
        """
        return pulumi.get(self, "validation_statuses")


@pulumi.output_type
class ModelPackageStatusItem(dict):
    """
    Represents the overall status of a model package.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureReason":
            suggest = "failure_reason"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelPackageStatusItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelPackageStatusItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelPackageStatusItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 status: 'ModelPackageStatusItemStatus',
                 failure_reason: Optional[str] = None):
        """
        Represents the overall status of a model package.
        :param str name: The name of the model package for which the overall status is being reported.
        :param 'ModelPackageStatusItemStatus' status: The current status.
        :param str failure_reason: If the overall status is Failed, the reason for the failure.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "status", status)
        if failure_reason is not None:
            pulumi.set(__self__, "failure_reason", failure_reason)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the model package for which the overall status is being reported.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> 'ModelPackageStatusItemStatus':
        """
        The current status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="failureReason")
    def failure_reason(self) -> Optional[str]:
        """
        If the overall status is Failed, the reason for the failure.
        """
        return pulumi.get(self, "failure_reason")


@pulumi.output_type
class ModelPackageTransformInput(dict):
    """
    Describes the input source of a transform job and the way the transform job consumes it.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataSource":
            suggest = "data_source"
        elif key == "compressionType":
            suggest = "compression_type"
        elif key == "contentType":
            suggest = "content_type"
        elif key == "splitType":
            suggest = "split_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelPackageTransformInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelPackageTransformInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelPackageTransformInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_source: 'outputs.ModelPackageDataSource',
                 compression_type: Optional['ModelPackageTransformInputCompressionType'] = None,
                 content_type: Optional[str] = None,
                 split_type: Optional['ModelPackageTransformInputSplitType'] = None):
        """
        Describes the input source of a transform job and the way the transform job consumes it.
        :param 'ModelPackageDataSource' data_source: Describes the location of the channel data, which is, the S3 location of the input data that the model can consume.
        :param 'ModelPackageTransformInputCompressionType' compression_type: If your transform data is compressed, specify the compression type. Amazon SageMaker automatically decompresses the data for the transform job accordingly. The default value is None.
        :param str content_type: The multipurpose internet mail extension (MIME) type of the data. Amazon SageMaker uses the MIME type with each http call to transfer data to the transform job.
        :param 'ModelPackageTransformInputSplitType' split_type: The method to use to split the transform job's data files into smaller batches. 
        """
        pulumi.set(__self__, "data_source", data_source)
        if compression_type is not None:
            pulumi.set(__self__, "compression_type", compression_type)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if split_type is not None:
            pulumi.set(__self__, "split_type", split_type)

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> 'outputs.ModelPackageDataSource':
        """
        Describes the location of the channel data, which is, the S3 location of the input data that the model can consume.
        """
        return pulumi.get(self, "data_source")

    @property
    @pulumi.getter(name="compressionType")
    def compression_type(self) -> Optional['ModelPackageTransformInputCompressionType']:
        """
        If your transform data is compressed, specify the compression type. Amazon SageMaker automatically decompresses the data for the transform job accordingly. The default value is None.
        """
        return pulumi.get(self, "compression_type")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[str]:
        """
        The multipurpose internet mail extension (MIME) type of the data. Amazon SageMaker uses the MIME type with each http call to transfer data to the transform job.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="splitType")
    def split_type(self) -> Optional['ModelPackageTransformInputSplitType']:
        """
        The method to use to split the transform job's data files into smaller batches. 
        """
        return pulumi.get(self, "split_type")


@pulumi.output_type
class ModelPackageTransformJobDefinition(dict):
    """
    Defines the input needed to run a transform job using the inference specification specified in the algorithm.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "transformInput":
            suggest = "transform_input"
        elif key == "transformOutput":
            suggest = "transform_output"
        elif key == "transformResources":
            suggest = "transform_resources"
        elif key == "batchStrategy":
            suggest = "batch_strategy"
        elif key == "maxConcurrentTransforms":
            suggest = "max_concurrent_transforms"
        elif key == "maxPayloadInMb":
            suggest = "max_payload_in_mb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelPackageTransformJobDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelPackageTransformJobDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelPackageTransformJobDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 transform_input: 'outputs.ModelPackageTransformInput',
                 transform_output: 'outputs.ModelPackageTransformOutput',
                 transform_resources: 'outputs.ModelPackageTransformResources',
                 batch_strategy: Optional['ModelPackageTransformJobDefinitionBatchStrategy'] = None,
                 environment: Optional['outputs.ModelPackageEnvironment'] = None,
                 max_concurrent_transforms: Optional[int] = None,
                 max_payload_in_mb: Optional[int] = None):
        """
        Defines the input needed to run a transform job using the inference specification specified in the algorithm.
        :param 'ModelPackageTransformInput' transform_input: A description of the input source and the way the transform job consumes it.
        :param 'ModelPackageTransformOutput' transform_output: Identifies the Amazon S3 location where you want Amazon SageMaker to save the results from the transform job.
        :param 'ModelPackageTransformResources' transform_resources: Identifies the ML compute instances for the transform job.
        :param 'ModelPackageTransformJobDefinitionBatchStrategy' batch_strategy: A string that determines the number of records included in a single mini-batch.
        :param 'ModelPackageEnvironment' environment: The environment variables to set in the Docker container. We support up to 16 key and values entries in the map.
        :param int max_concurrent_transforms: The maximum number of parallel requests that can be sent to each instance in a transform job. The default value is 1.
        :param int max_payload_in_mb: The maximum payload size allowed, in MB. A payload is the data portion of a record (without metadata).
        """
        pulumi.set(__self__, "transform_input", transform_input)
        pulumi.set(__self__, "transform_output", transform_output)
        pulumi.set(__self__, "transform_resources", transform_resources)
        if batch_strategy is not None:
            pulumi.set(__self__, "batch_strategy", batch_strategy)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if max_concurrent_transforms is not None:
            pulumi.set(__self__, "max_concurrent_transforms", max_concurrent_transforms)
        if max_payload_in_mb is not None:
            pulumi.set(__self__, "max_payload_in_mb", max_payload_in_mb)

    @property
    @pulumi.getter(name="transformInput")
    def transform_input(self) -> 'outputs.ModelPackageTransformInput':
        """
        A description of the input source and the way the transform job consumes it.
        """
        return pulumi.get(self, "transform_input")

    @property
    @pulumi.getter(name="transformOutput")
    def transform_output(self) -> 'outputs.ModelPackageTransformOutput':
        """
        Identifies the Amazon S3 location where you want Amazon SageMaker to save the results from the transform job.
        """
        return pulumi.get(self, "transform_output")

    @property
    @pulumi.getter(name="transformResources")
    def transform_resources(self) -> 'outputs.ModelPackageTransformResources':
        """
        Identifies the ML compute instances for the transform job.
        """
        return pulumi.get(self, "transform_resources")

    @property
    @pulumi.getter(name="batchStrategy")
    def batch_strategy(self) -> Optional['ModelPackageTransformJobDefinitionBatchStrategy']:
        """
        A string that determines the number of records included in a single mini-batch.
        """
        return pulumi.get(self, "batch_strategy")

    @property
    @pulumi.getter
    def environment(self) -> Optional['outputs.ModelPackageEnvironment']:
        """
        The environment variables to set in the Docker container. We support up to 16 key and values entries in the map.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="maxConcurrentTransforms")
    def max_concurrent_transforms(self) -> Optional[int]:
        """
        The maximum number of parallel requests that can be sent to each instance in a transform job. The default value is 1.
        """
        return pulumi.get(self, "max_concurrent_transforms")

    @property
    @pulumi.getter(name="maxPayloadInMb")
    def max_payload_in_mb(self) -> Optional[int]:
        """
        The maximum payload size allowed, in MB. A payload is the data portion of a record (without metadata).
        """
        return pulumi.get(self, "max_payload_in_mb")


@pulumi.output_type
class ModelPackageTransformOutput(dict):
    """
    Describes the results of a transform job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3OutputPath":
            suggest = "s3_output_path"
        elif key == "assembleWith":
            suggest = "assemble_with"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelPackageTransformOutput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelPackageTransformOutput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelPackageTransformOutput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_output_path: str,
                 accept: Optional[str] = None,
                 assemble_with: Optional['ModelPackageTransformOutputAssembleWith'] = None,
                 kms_key_id: Optional[str] = None):
        """
        Describes the results of a transform job.
        :param str s3_output_path: The Amazon S3 path where you want Amazon SageMaker to store the results of the transform job.
        :param str accept: The MIME type used to specify the output data. Amazon SageMaker uses the MIME type with each http call to transfer data from the transform job.
        :param 'ModelPackageTransformOutputAssembleWith' assemble_with: Defines how to assemble the results of the transform job as a single S3 object.
        :param str kms_key_id: The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
        """
        pulumi.set(__self__, "s3_output_path", s3_output_path)
        if accept is not None:
            pulumi.set(__self__, "accept", accept)
        if assemble_with is not None:
            pulumi.set(__self__, "assemble_with", assemble_with)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="s3OutputPath")
    def s3_output_path(self) -> str:
        """
        The Amazon S3 path where you want Amazon SageMaker to store the results of the transform job.
        """
        return pulumi.get(self, "s3_output_path")

    @property
    @pulumi.getter
    def accept(self) -> Optional[str]:
        """
        The MIME type used to specify the output data. Amazon SageMaker uses the MIME type with each http call to transfer data from the transform job.
        """
        return pulumi.get(self, "accept")

    @property
    @pulumi.getter(name="assembleWith")
    def assemble_with(self) -> Optional['ModelPackageTransformOutputAssembleWith']:
        """
        Defines how to assemble the results of the transform job as a single S3 object.
        """
        return pulumi.get(self, "assemble_with")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class ModelPackageTransformResources(dict):
    """
    Describes the resources, including ML instance types and ML instance count, to use for transform job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceCount":
            suggest = "instance_count"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "volumeKmsKeyId":
            suggest = "volume_kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelPackageTransformResources. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelPackageTransformResources.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelPackageTransformResources.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_count: int,
                 instance_type: str,
                 volume_kms_key_id: Optional[str] = None):
        """
        Describes the resources, including ML instance types and ML instance count, to use for transform job.
        :param int instance_count: The number of ML compute instances to use in the transform job. For distributed transform jobs, specify a value greater than 1. The default value is 1.
        :param str instance_type: The ML compute instance type for the transform job.
        :param str volume_kms_key_id: The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt model data on the storage volume attached to the ML compute instance(s) that run the batch transform job.
        """
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "instance_type", instance_type)
        if volume_kms_key_id is not None:
            pulumi.set(__self__, "volume_kms_key_id", volume_kms_key_id)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> int:
        """
        The number of ML compute instances to use in the transform job. For distributed transform jobs, specify a value greater than 1. The default value is 1.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        The ML compute instance type for the transform job.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="volumeKmsKeyId")
    def volume_kms_key_id(self) -> Optional[str]:
        """
        The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt model data on the storage volume attached to the ML compute instance(s) that run the batch transform job.
        """
        return pulumi.get(self, "volume_kms_key_id")


@pulumi.output_type
class ModelPackageValidationProfile(dict):
    """
    Contains data, such as the inputs and targeted instance types that are used in the process of validating the model package.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "profileName":
            suggest = "profile_name"
        elif key == "transformJobDefinition":
            suggest = "transform_job_definition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelPackageValidationProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelPackageValidationProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelPackageValidationProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 profile_name: str,
                 transform_job_definition: 'outputs.ModelPackageTransformJobDefinition'):
        """
        Contains data, such as the inputs and targeted instance types that are used in the process of validating the model package.
        :param str profile_name: The name of the profile for the model package.
        :param 'ModelPackageTransformJobDefinition' transform_job_definition: The `TransformJobDefinition` object that describes the transform job used for the validation of the model package.
        """
        pulumi.set(__self__, "profile_name", profile_name)
        pulumi.set(__self__, "transform_job_definition", transform_job_definition)

    @property
    @pulumi.getter(name="profileName")
    def profile_name(self) -> str:
        """
        The name of the profile for the model package.
        """
        return pulumi.get(self, "profile_name")

    @property
    @pulumi.getter(name="transformJobDefinition")
    def transform_job_definition(self) -> 'outputs.ModelPackageTransformJobDefinition':
        """
        The `TransformJobDefinition` object that describes the transform job used for the validation of the model package.
        """
        return pulumi.get(self, "transform_job_definition")


@pulumi.output_type
class ModelPackageValidationSpecification(dict):
    """
    Specifies configurations for one or more transform jobs that Amazon SageMaker runs to test the model package.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "validationProfiles":
            suggest = "validation_profiles"
        elif key == "validationRole":
            suggest = "validation_role"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelPackageValidationSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelPackageValidationSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelPackageValidationSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 validation_profiles: Sequence['outputs.ModelPackageValidationProfile'],
                 validation_role: str):
        """
        Specifies configurations for one or more transform jobs that Amazon SageMaker runs to test the model package.
        :param Sequence['ModelPackageValidationProfile'] validation_profiles: An array of `ModelPackageValidationProfile` objects, each of which specifies a batch transform job that SageMaker runs to validate your model package.
        :param str validation_role: The IAM roles to be used for the validation of the model package.
        """
        pulumi.set(__self__, "validation_profiles", validation_profiles)
        pulumi.set(__self__, "validation_role", validation_role)

    @property
    @pulumi.getter(name="validationProfiles")
    def validation_profiles(self) -> Sequence['outputs.ModelPackageValidationProfile']:
        """
        An array of `ModelPackageValidationProfile` objects, each of which specifies a batch transform job that SageMaker runs to validate your model package.
        """
        return pulumi.get(self, "validation_profiles")

    @property
    @pulumi.getter(name="validationRole")
    def validation_role(self) -> str:
        """
        The IAM roles to be used for the validation of the model package.
        """
        return pulumi.get(self, "validation_role")


@pulumi.output_type
class ModelQualityJobDefinitionBatchTransformInput(dict):
    """
    The batch transform input for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataCapturedDestinationS3Uri":
            suggest = "data_captured_destination_s3_uri"
        elif key == "datasetFormat":
            suggest = "dataset_format"
        elif key == "localPath":
            suggest = "local_path"
        elif key == "endTimeOffset":
            suggest = "end_time_offset"
        elif key == "inferenceAttribute":
            suggest = "inference_attribute"
        elif key == "probabilityAttribute":
            suggest = "probability_attribute"
        elif key == "probabilityThresholdAttribute":
            suggest = "probability_threshold_attribute"
        elif key == "s3DataDistributionType":
            suggest = "s3_data_distribution_type"
        elif key == "s3InputMode":
            suggest = "s3_input_mode"
        elif key == "startTimeOffset":
            suggest = "start_time_offset"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelQualityJobDefinitionBatchTransformInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelQualityJobDefinitionBatchTransformInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelQualityJobDefinitionBatchTransformInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_captured_destination_s3_uri: str,
                 dataset_format: 'outputs.ModelQualityJobDefinitionDatasetFormat',
                 local_path: str,
                 end_time_offset: Optional[str] = None,
                 inference_attribute: Optional[str] = None,
                 probability_attribute: Optional[str] = None,
                 probability_threshold_attribute: Optional[float] = None,
                 s3_data_distribution_type: Optional['ModelQualityJobDefinitionBatchTransformInputS3DataDistributionType'] = None,
                 s3_input_mode: Optional['ModelQualityJobDefinitionBatchTransformInputS3InputMode'] = None,
                 start_time_offset: Optional[str] = None):
        """
        The batch transform input for a monitoring job.
        :param str data_captured_destination_s3_uri: A URI that identifies the Amazon S3 storage location where Batch Transform Job captures data.
        :param 'ModelQualityJobDefinitionDatasetFormat' dataset_format: The dataset format for your batch transform job.
        :param str local_path: Path to the filesystem where the endpoint data is available to the container.
        :param str end_time_offset: Monitoring end time offset, e.g. PT0H
        :param str inference_attribute: Index or JSONpath to locate predicted label(s)
        :param str probability_attribute: Index or JSONpath to locate probabilities
        :param float probability_threshold_attribute: The threshold for the class probability to be evaluated as a positive result.
        :param 'ModelQualityJobDefinitionBatchTransformInputS3DataDistributionType' s3_data_distribution_type: Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to FullyReplicated
        :param 'ModelQualityJobDefinitionBatchTransformInputS3InputMode' s3_input_mode: Whether the Pipe or File is used as the input mode for transfering data for the monitoring job. Pipe mode is recommended for large datasets. File mode is useful for small files that fit in memory. Defaults to File.
        :param str start_time_offset: Monitoring start time offset, e.g. -PT1H
        """
        pulumi.set(__self__, "data_captured_destination_s3_uri", data_captured_destination_s3_uri)
        pulumi.set(__self__, "dataset_format", dataset_format)
        pulumi.set(__self__, "local_path", local_path)
        if end_time_offset is not None:
            pulumi.set(__self__, "end_time_offset", end_time_offset)
        if inference_attribute is not None:
            pulumi.set(__self__, "inference_attribute", inference_attribute)
        if probability_attribute is not None:
            pulumi.set(__self__, "probability_attribute", probability_attribute)
        if probability_threshold_attribute is not None:
            pulumi.set(__self__, "probability_threshold_attribute", probability_threshold_attribute)
        if s3_data_distribution_type is not None:
            pulumi.set(__self__, "s3_data_distribution_type", s3_data_distribution_type)
        if s3_input_mode is not None:
            pulumi.set(__self__, "s3_input_mode", s3_input_mode)
        if start_time_offset is not None:
            pulumi.set(__self__, "start_time_offset", start_time_offset)

    @property
    @pulumi.getter(name="dataCapturedDestinationS3Uri")
    def data_captured_destination_s3_uri(self) -> str:
        """
        A URI that identifies the Amazon S3 storage location where Batch Transform Job captures data.
        """
        return pulumi.get(self, "data_captured_destination_s3_uri")

    @property
    @pulumi.getter(name="datasetFormat")
    def dataset_format(self) -> 'outputs.ModelQualityJobDefinitionDatasetFormat':
        """
        The dataset format for your batch transform job.
        """
        return pulumi.get(self, "dataset_format")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> str:
        """
        Path to the filesystem where the endpoint data is available to the container.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter(name="endTimeOffset")
    def end_time_offset(self) -> Optional[str]:
        """
        Monitoring end time offset, e.g. PT0H
        """
        return pulumi.get(self, "end_time_offset")

    @property
    @pulumi.getter(name="inferenceAttribute")
    def inference_attribute(self) -> Optional[str]:
        """
        Index or JSONpath to locate predicted label(s)
        """
        return pulumi.get(self, "inference_attribute")

    @property
    @pulumi.getter(name="probabilityAttribute")
    def probability_attribute(self) -> Optional[str]:
        """
        Index or JSONpath to locate probabilities
        """
        return pulumi.get(self, "probability_attribute")

    @property
    @pulumi.getter(name="probabilityThresholdAttribute")
    def probability_threshold_attribute(self) -> Optional[float]:
        """
        The threshold for the class probability to be evaluated as a positive result.
        """
        return pulumi.get(self, "probability_threshold_attribute")

    @property
    @pulumi.getter(name="s3DataDistributionType")
    def s3_data_distribution_type(self) -> Optional['ModelQualityJobDefinitionBatchTransformInputS3DataDistributionType']:
        """
        Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to FullyReplicated
        """
        return pulumi.get(self, "s3_data_distribution_type")

    @property
    @pulumi.getter(name="s3InputMode")
    def s3_input_mode(self) -> Optional['ModelQualityJobDefinitionBatchTransformInputS3InputMode']:
        """
        Whether the Pipe or File is used as the input mode for transfering data for the monitoring job. Pipe mode is recommended for large datasets. File mode is useful for small files that fit in memory. Defaults to File.
        """
        return pulumi.get(self, "s3_input_mode")

    @property
    @pulumi.getter(name="startTimeOffset")
    def start_time_offset(self) -> Optional[str]:
        """
        Monitoring start time offset, e.g. -PT1H
        """
        return pulumi.get(self, "start_time_offset")


@pulumi.output_type
class ModelQualityJobDefinitionClusterConfig(dict):
    """
    Configuration for the cluster used to run model monitoring jobs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceCount":
            suggest = "instance_count"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "volumeSizeInGb":
            suggest = "volume_size_in_gb"
        elif key == "volumeKmsKeyId":
            suggest = "volume_kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelQualityJobDefinitionClusterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelQualityJobDefinitionClusterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelQualityJobDefinitionClusterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_count: int,
                 instance_type: str,
                 volume_size_in_gb: int,
                 volume_kms_key_id: Optional[str] = None):
        """
        Configuration for the cluster used to run model monitoring jobs.
        :param int instance_count: The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1. The default value is 1.
        :param str instance_type: The ML compute instance type for the processing job.
        :param int volume_size_in_gb: The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
        :param str volume_kms_key_id: The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
        """
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "volume_size_in_gb", volume_size_in_gb)
        if volume_kms_key_id is not None:
            pulumi.set(__self__, "volume_kms_key_id", volume_kms_key_id)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> int:
        """
        The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1. The default value is 1.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        The ML compute instance type for the processing job.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="volumeSizeInGb")
    def volume_size_in_gb(self) -> int:
        """
        The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
        """
        return pulumi.get(self, "volume_size_in_gb")

    @property
    @pulumi.getter(name="volumeKmsKeyId")
    def volume_kms_key_id(self) -> Optional[str]:
        """
        The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
        """
        return pulumi.get(self, "volume_kms_key_id")


@pulumi.output_type
class ModelQualityJobDefinitionConstraintsResource(dict):
    """
    The baseline constraints resource for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Uri":
            suggest = "s3_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelQualityJobDefinitionConstraintsResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelQualityJobDefinitionConstraintsResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelQualityJobDefinitionConstraintsResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_uri: Optional[str] = None):
        """
        The baseline constraints resource for a monitoring job.
        :param str s3_uri: The Amazon S3 URI for baseline constraint file in Amazon S3 that the current monitoring job should validated against.
        """
        if s3_uri is not None:
            pulumi.set(__self__, "s3_uri", s3_uri)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> Optional[str]:
        """
        The Amazon S3 URI for baseline constraint file in Amazon S3 that the current monitoring job should validated against.
        """
        return pulumi.get(self, "s3_uri")


@pulumi.output_type
class ModelQualityJobDefinitionCsv(dict):
    """
    The CSV format
    """
    def __init__(__self__, *,
                 header: Optional[bool] = None):
        """
        The CSV format
        :param bool header: A boolean flag indicating if given CSV has header
        """
        if header is not None:
            pulumi.set(__self__, "header", header)

    @property
    @pulumi.getter
    def header(self) -> Optional[bool]:
        """
        A boolean flag indicating if given CSV has header
        """
        return pulumi.get(self, "header")


@pulumi.output_type
class ModelQualityJobDefinitionDatasetFormat(dict):
    """
    The dataset format of the data to monitor
    """
    def __init__(__self__, *,
                 csv: Optional['outputs.ModelQualityJobDefinitionCsv'] = None,
                 json: Optional['outputs.ModelQualityJobDefinitionJson'] = None,
                 parquet: Optional[bool] = None):
        """
        The dataset format of the data to monitor
        """
        if csv is not None:
            pulumi.set(__self__, "csv", csv)
        if json is not None:
            pulumi.set(__self__, "json", json)
        if parquet is not None:
            pulumi.set(__self__, "parquet", parquet)

    @property
    @pulumi.getter
    def csv(self) -> Optional['outputs.ModelQualityJobDefinitionCsv']:
        return pulumi.get(self, "csv")

    @property
    @pulumi.getter
    def json(self) -> Optional['outputs.ModelQualityJobDefinitionJson']:
        return pulumi.get(self, "json")

    @property
    @pulumi.getter
    def parquet(self) -> Optional[bool]:
        return pulumi.get(self, "parquet")


@pulumi.output_type
class ModelQualityJobDefinitionEndpointInput(dict):
    """
    The endpoint for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointName":
            suggest = "endpoint_name"
        elif key == "localPath":
            suggest = "local_path"
        elif key == "endTimeOffset":
            suggest = "end_time_offset"
        elif key == "inferenceAttribute":
            suggest = "inference_attribute"
        elif key == "probabilityAttribute":
            suggest = "probability_attribute"
        elif key == "probabilityThresholdAttribute":
            suggest = "probability_threshold_attribute"
        elif key == "s3DataDistributionType":
            suggest = "s3_data_distribution_type"
        elif key == "s3InputMode":
            suggest = "s3_input_mode"
        elif key == "startTimeOffset":
            suggest = "start_time_offset"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelQualityJobDefinitionEndpointInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelQualityJobDefinitionEndpointInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelQualityJobDefinitionEndpointInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_name: str,
                 local_path: str,
                 end_time_offset: Optional[str] = None,
                 inference_attribute: Optional[str] = None,
                 probability_attribute: Optional[str] = None,
                 probability_threshold_attribute: Optional[float] = None,
                 s3_data_distribution_type: Optional['ModelQualityJobDefinitionEndpointInputS3DataDistributionType'] = None,
                 s3_input_mode: Optional['ModelQualityJobDefinitionEndpointInputS3InputMode'] = None,
                 start_time_offset: Optional[str] = None):
        """
        The endpoint for a monitoring job.
        :param str endpoint_name: An endpoint in customer's account which has enabled `DataCaptureConfig` enabled.
        :param str local_path: Path to the filesystem where the endpoint data is available to the container.
        :param str end_time_offset: Monitoring end time offset, e.g. PT0H
        :param str inference_attribute: Index or JSONpath to locate predicted label(s)
        :param str probability_attribute: Index or JSONpath to locate probabilities
        :param float probability_threshold_attribute: The threshold for the class probability to be evaluated as a positive result.
        :param 'ModelQualityJobDefinitionEndpointInputS3DataDistributionType' s3_data_distribution_type: Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to FullyReplicated
        :param 'ModelQualityJobDefinitionEndpointInputS3InputMode' s3_input_mode: Whether the Pipe or File is used as the input mode for transfering data for the monitoring job. Pipe mode is recommended for large datasets. File mode is useful for small files that fit in memory. Defaults to File.
        :param str start_time_offset: Monitoring start time offset, e.g. -PT1H
        """
        pulumi.set(__self__, "endpoint_name", endpoint_name)
        pulumi.set(__self__, "local_path", local_path)
        if end_time_offset is not None:
            pulumi.set(__self__, "end_time_offset", end_time_offset)
        if inference_attribute is not None:
            pulumi.set(__self__, "inference_attribute", inference_attribute)
        if probability_attribute is not None:
            pulumi.set(__self__, "probability_attribute", probability_attribute)
        if probability_threshold_attribute is not None:
            pulumi.set(__self__, "probability_threshold_attribute", probability_threshold_attribute)
        if s3_data_distribution_type is not None:
            pulumi.set(__self__, "s3_data_distribution_type", s3_data_distribution_type)
        if s3_input_mode is not None:
            pulumi.set(__self__, "s3_input_mode", s3_input_mode)
        if start_time_offset is not None:
            pulumi.set(__self__, "start_time_offset", start_time_offset)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> str:
        """
        An endpoint in customer's account which has enabled `DataCaptureConfig` enabled.
        """
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> str:
        """
        Path to the filesystem where the endpoint data is available to the container.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter(name="endTimeOffset")
    def end_time_offset(self) -> Optional[str]:
        """
        Monitoring end time offset, e.g. PT0H
        """
        return pulumi.get(self, "end_time_offset")

    @property
    @pulumi.getter(name="inferenceAttribute")
    def inference_attribute(self) -> Optional[str]:
        """
        Index or JSONpath to locate predicted label(s)
        """
        return pulumi.get(self, "inference_attribute")

    @property
    @pulumi.getter(name="probabilityAttribute")
    def probability_attribute(self) -> Optional[str]:
        """
        Index or JSONpath to locate probabilities
        """
        return pulumi.get(self, "probability_attribute")

    @property
    @pulumi.getter(name="probabilityThresholdAttribute")
    def probability_threshold_attribute(self) -> Optional[float]:
        """
        The threshold for the class probability to be evaluated as a positive result.
        """
        return pulumi.get(self, "probability_threshold_attribute")

    @property
    @pulumi.getter(name="s3DataDistributionType")
    def s3_data_distribution_type(self) -> Optional['ModelQualityJobDefinitionEndpointInputS3DataDistributionType']:
        """
        Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to FullyReplicated
        """
        return pulumi.get(self, "s3_data_distribution_type")

    @property
    @pulumi.getter(name="s3InputMode")
    def s3_input_mode(self) -> Optional['ModelQualityJobDefinitionEndpointInputS3InputMode']:
        """
        Whether the Pipe or File is used as the input mode for transfering data for the monitoring job. Pipe mode is recommended for large datasets. File mode is useful for small files that fit in memory. Defaults to File.
        """
        return pulumi.get(self, "s3_input_mode")

    @property
    @pulumi.getter(name="startTimeOffset")
    def start_time_offset(self) -> Optional[str]:
        """
        Monitoring start time offset, e.g. -PT1H
        """
        return pulumi.get(self, "start_time_offset")


@pulumi.output_type
class ModelQualityJobDefinitionJson(dict):
    """
    The Json format
    """
    def __init__(__self__, *,
                 line: Optional[bool] = None):
        """
        The Json format
        :param bool line: A boolean flag indicating if it is JSON line format
        """
        if line is not None:
            pulumi.set(__self__, "line", line)

    @property
    @pulumi.getter
    def line(self) -> Optional[bool]:
        """
        A boolean flag indicating if it is JSON line format
        """
        return pulumi.get(self, "line")


@pulumi.output_type
class ModelQualityJobDefinitionModelQualityAppSpecification(dict):
    """
    Container image configuration object for the monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageUri":
            suggest = "image_uri"
        elif key == "problemType":
            suggest = "problem_type"
        elif key == "containerArguments":
            suggest = "container_arguments"
        elif key == "containerEntrypoint":
            suggest = "container_entrypoint"
        elif key == "postAnalyticsProcessorSourceUri":
            suggest = "post_analytics_processor_source_uri"
        elif key == "recordPreprocessorSourceUri":
            suggest = "record_preprocessor_source_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelQualityJobDefinitionModelQualityAppSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelQualityJobDefinitionModelQualityAppSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelQualityJobDefinitionModelQualityAppSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_uri: str,
                 problem_type: 'ModelQualityJobDefinitionProblemType',
                 container_arguments: Optional[Sequence[str]] = None,
                 container_entrypoint: Optional[Sequence[str]] = None,
                 environment: Optional[Any] = None,
                 post_analytics_processor_source_uri: Optional[str] = None,
                 record_preprocessor_source_uri: Optional[str] = None):
        """
        Container image configuration object for the monitoring job.
        :param str image_uri: The container image to be run by the monitoring job.
        :param 'ModelQualityJobDefinitionProblemType' problem_type: The machine learning problem type of the model that the monitoring job monitors.
        :param Sequence[str] container_arguments: An array of arguments for the container used to run the monitoring job.
        :param Sequence[str] container_entrypoint: Specifies the entrypoint for a container used to run the monitoring job.
        :param Any environment: Sets the environment variables in the Docker container
        :param str post_analytics_processor_source_uri: An Amazon S3 URI to a script that is called after analysis has been performed. Applicable only for the built-in (first party) containers.
        :param str record_preprocessor_source_uri: An Amazon S3 URI to a script that is called per row prior to running analysis. It can base64 decode the payload and convert it into a flatted json so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers
        """
        pulumi.set(__self__, "image_uri", image_uri)
        pulumi.set(__self__, "problem_type", problem_type)
        if container_arguments is not None:
            pulumi.set(__self__, "container_arguments", container_arguments)
        if container_entrypoint is not None:
            pulumi.set(__self__, "container_entrypoint", container_entrypoint)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if post_analytics_processor_source_uri is not None:
            pulumi.set(__self__, "post_analytics_processor_source_uri", post_analytics_processor_source_uri)
        if record_preprocessor_source_uri is not None:
            pulumi.set(__self__, "record_preprocessor_source_uri", record_preprocessor_source_uri)

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> str:
        """
        The container image to be run by the monitoring job.
        """
        return pulumi.get(self, "image_uri")

    @property
    @pulumi.getter(name="problemType")
    def problem_type(self) -> 'ModelQualityJobDefinitionProblemType':
        """
        The machine learning problem type of the model that the monitoring job monitors.
        """
        return pulumi.get(self, "problem_type")

    @property
    @pulumi.getter(name="containerArguments")
    def container_arguments(self) -> Optional[Sequence[str]]:
        """
        An array of arguments for the container used to run the monitoring job.
        """
        return pulumi.get(self, "container_arguments")

    @property
    @pulumi.getter(name="containerEntrypoint")
    def container_entrypoint(self) -> Optional[Sequence[str]]:
        """
        Specifies the entrypoint for a container used to run the monitoring job.
        """
        return pulumi.get(self, "container_entrypoint")

    @property
    @pulumi.getter
    def environment(self) -> Optional[Any]:
        """
        Sets the environment variables in the Docker container
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="postAnalyticsProcessorSourceUri")
    def post_analytics_processor_source_uri(self) -> Optional[str]:
        """
        An Amazon S3 URI to a script that is called after analysis has been performed. Applicable only for the built-in (first party) containers.
        """
        return pulumi.get(self, "post_analytics_processor_source_uri")

    @property
    @pulumi.getter(name="recordPreprocessorSourceUri")
    def record_preprocessor_source_uri(self) -> Optional[str]:
        """
        An Amazon S3 URI to a script that is called per row prior to running analysis. It can base64 decode the payload and convert it into a flatted json so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers
        """
        return pulumi.get(self, "record_preprocessor_source_uri")


@pulumi.output_type
class ModelQualityJobDefinitionModelQualityBaselineConfig(dict):
    """
    Baseline configuration used to validate that the data conforms to the specified constraints and statistics.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseliningJobName":
            suggest = "baselining_job_name"
        elif key == "constraintsResource":
            suggest = "constraints_resource"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelQualityJobDefinitionModelQualityBaselineConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelQualityJobDefinitionModelQualityBaselineConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelQualityJobDefinitionModelQualityBaselineConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 baselining_job_name: Optional[str] = None,
                 constraints_resource: Optional['outputs.ModelQualityJobDefinitionConstraintsResource'] = None):
        """
        Baseline configuration used to validate that the data conforms to the specified constraints and statistics.
        :param str baselining_job_name: The name of the job that performs baselining for the monitoring job.
        :param 'ModelQualityJobDefinitionConstraintsResource' constraints_resource: The constraints resource for a monitoring job.
        """
        if baselining_job_name is not None:
            pulumi.set(__self__, "baselining_job_name", baselining_job_name)
        if constraints_resource is not None:
            pulumi.set(__self__, "constraints_resource", constraints_resource)

    @property
    @pulumi.getter(name="baseliningJobName")
    def baselining_job_name(self) -> Optional[str]:
        """
        The name of the job that performs baselining for the monitoring job.
        """
        return pulumi.get(self, "baselining_job_name")

    @property
    @pulumi.getter(name="constraintsResource")
    def constraints_resource(self) -> Optional['outputs.ModelQualityJobDefinitionConstraintsResource']:
        """
        The constraints resource for a monitoring job.
        """
        return pulumi.get(self, "constraints_resource")


@pulumi.output_type
class ModelQualityJobDefinitionModelQualityJobInput(dict):
    """
    The inputs for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groundTruthS3Input":
            suggest = "ground_truth_s3_input"
        elif key == "batchTransformInput":
            suggest = "batch_transform_input"
        elif key == "endpointInput":
            suggest = "endpoint_input"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelQualityJobDefinitionModelQualityJobInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelQualityJobDefinitionModelQualityJobInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelQualityJobDefinitionModelQualityJobInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ground_truth_s3_input: 'outputs.ModelQualityJobDefinitionMonitoringGroundTruthS3Input',
                 batch_transform_input: Optional['outputs.ModelQualityJobDefinitionBatchTransformInput'] = None,
                 endpoint_input: Optional['outputs.ModelQualityJobDefinitionEndpointInput'] = None):
        """
        The inputs for a monitoring job.
        :param 'ModelQualityJobDefinitionMonitoringGroundTruthS3Input' ground_truth_s3_input: The ground truth label provided for the model.
        :param 'ModelQualityJobDefinitionBatchTransformInput' batch_transform_input: Input object for the batch transform job.
        :param 'ModelQualityJobDefinitionEndpointInput' endpoint_input: Input object for the endpoint
        """
        pulumi.set(__self__, "ground_truth_s3_input", ground_truth_s3_input)
        if batch_transform_input is not None:
            pulumi.set(__self__, "batch_transform_input", batch_transform_input)
        if endpoint_input is not None:
            pulumi.set(__self__, "endpoint_input", endpoint_input)

    @property
    @pulumi.getter(name="groundTruthS3Input")
    def ground_truth_s3_input(self) -> 'outputs.ModelQualityJobDefinitionMonitoringGroundTruthS3Input':
        """
        The ground truth label provided for the model.
        """
        return pulumi.get(self, "ground_truth_s3_input")

    @property
    @pulumi.getter(name="batchTransformInput")
    def batch_transform_input(self) -> Optional['outputs.ModelQualityJobDefinitionBatchTransformInput']:
        """
        Input object for the batch transform job.
        """
        return pulumi.get(self, "batch_transform_input")

    @property
    @pulumi.getter(name="endpointInput")
    def endpoint_input(self) -> Optional['outputs.ModelQualityJobDefinitionEndpointInput']:
        """
        Input object for the endpoint
        """
        return pulumi.get(self, "endpoint_input")


@pulumi.output_type
class ModelQualityJobDefinitionMonitoringGroundTruthS3Input(dict):
    """
    Ground truth input provided in S3 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Uri":
            suggest = "s3_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelQualityJobDefinitionMonitoringGroundTruthS3Input. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelQualityJobDefinitionMonitoringGroundTruthS3Input.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelQualityJobDefinitionMonitoringGroundTruthS3Input.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_uri: str):
        """
        Ground truth input provided in S3 
        :param str s3_uri: A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
        """
        pulumi.set(__self__, "s3_uri", s3_uri)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> str:
        """
        A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
        """
        return pulumi.get(self, "s3_uri")


@pulumi.output_type
class ModelQualityJobDefinitionMonitoringOutput(dict):
    """
    The output object for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Output":
            suggest = "s3_output"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelQualityJobDefinitionMonitoringOutput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelQualityJobDefinitionMonitoringOutput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelQualityJobDefinitionMonitoringOutput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_output: 'outputs.ModelQualityJobDefinitionS3Output'):
        """
        The output object for a monitoring job.
        :param 'ModelQualityJobDefinitionS3Output' s3_output: The Amazon S3 storage location where the results of a monitoring job are saved.
        """
        pulumi.set(__self__, "s3_output", s3_output)

    @property
    @pulumi.getter(name="s3Output")
    def s3_output(self) -> 'outputs.ModelQualityJobDefinitionS3Output':
        """
        The Amazon S3 storage location where the results of a monitoring job are saved.
        """
        return pulumi.get(self, "s3_output")


@pulumi.output_type
class ModelQualityJobDefinitionMonitoringOutputConfig(dict):
    """
    The output configuration for monitoring jobs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "monitoringOutputs":
            suggest = "monitoring_outputs"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelQualityJobDefinitionMonitoringOutputConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelQualityJobDefinitionMonitoringOutputConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelQualityJobDefinitionMonitoringOutputConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 monitoring_outputs: Sequence['outputs.ModelQualityJobDefinitionMonitoringOutput'],
                 kms_key_id: Optional[str] = None):
        """
        The output configuration for monitoring jobs.
        :param Sequence['ModelQualityJobDefinitionMonitoringOutput'] monitoring_outputs: Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
        :param str kms_key_id: The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
        """
        pulumi.set(__self__, "monitoring_outputs", monitoring_outputs)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="monitoringOutputs")
    def monitoring_outputs(self) -> Sequence['outputs.ModelQualityJobDefinitionMonitoringOutput']:
        """
        Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
        """
        return pulumi.get(self, "monitoring_outputs")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class ModelQualityJobDefinitionMonitoringResources(dict):
    """
    Identifies the resources to deploy for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterConfig":
            suggest = "cluster_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelQualityJobDefinitionMonitoringResources. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelQualityJobDefinitionMonitoringResources.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelQualityJobDefinitionMonitoringResources.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_config: 'outputs.ModelQualityJobDefinitionClusterConfig'):
        """
        Identifies the resources to deploy for a monitoring job.
        :param 'ModelQualityJobDefinitionClusterConfig' cluster_config: The configuration for the cluster resources used to run the processing job.
        """
        pulumi.set(__self__, "cluster_config", cluster_config)

    @property
    @pulumi.getter(name="clusterConfig")
    def cluster_config(self) -> 'outputs.ModelQualityJobDefinitionClusterConfig':
        """
        The configuration for the cluster resources used to run the processing job.
        """
        return pulumi.get(self, "cluster_config")


@pulumi.output_type
class ModelQualityJobDefinitionNetworkConfig(dict):
    """
    Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableInterContainerTrafficEncryption":
            suggest = "enable_inter_container_traffic_encryption"
        elif key == "enableNetworkIsolation":
            suggest = "enable_network_isolation"
        elif key == "vpcConfig":
            suggest = "vpc_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelQualityJobDefinitionNetworkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelQualityJobDefinitionNetworkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelQualityJobDefinitionNetworkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_inter_container_traffic_encryption: Optional[bool] = None,
                 enable_network_isolation: Optional[bool] = None,
                 vpc_config: Optional['outputs.ModelQualityJobDefinitionVpcConfig'] = None):
        """
        Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
        :param bool enable_inter_container_traffic_encryption: Whether to encrypt all communications between distributed processing jobs. Choose True to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
        :param bool enable_network_isolation: Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
        :param 'ModelQualityJobDefinitionVpcConfig' vpc_config: Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.
        """
        if enable_inter_container_traffic_encryption is not None:
            pulumi.set(__self__, "enable_inter_container_traffic_encryption", enable_inter_container_traffic_encryption)
        if enable_network_isolation is not None:
            pulumi.set(__self__, "enable_network_isolation", enable_network_isolation)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @property
    @pulumi.getter(name="enableInterContainerTrafficEncryption")
    def enable_inter_container_traffic_encryption(self) -> Optional[bool]:
        """
        Whether to encrypt all communications between distributed processing jobs. Choose True to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
        """
        return pulumi.get(self, "enable_inter_container_traffic_encryption")

    @property
    @pulumi.getter(name="enableNetworkIsolation")
    def enable_network_isolation(self) -> Optional[bool]:
        """
        Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
        """
        return pulumi.get(self, "enable_network_isolation")

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional['outputs.ModelQualityJobDefinitionVpcConfig']:
        """
        Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.
        """
        return pulumi.get(self, "vpc_config")


@pulumi.output_type
class ModelQualityJobDefinitionS3Output(dict):
    """
    Information about where and how to store the results of a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localPath":
            suggest = "local_path"
        elif key == "s3Uri":
            suggest = "s3_uri"
        elif key == "s3UploadMode":
            suggest = "s3_upload_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelQualityJobDefinitionS3Output. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelQualityJobDefinitionS3Output.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelQualityJobDefinitionS3Output.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_path: str,
                 s3_uri: str,
                 s3_upload_mode: Optional['ModelQualityJobDefinitionS3OutputS3UploadMode'] = None):
        """
        Information about where and how to store the results of a monitoring job.
        :param str local_path: The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. LocalPath is an absolute path for the output data.
        :param str s3_uri: A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
        :param 'ModelQualityJobDefinitionS3OutputS3UploadMode' s3_upload_mode: Whether to upload the results of the monitoring job continuously or after the job completes.
        """
        pulumi.set(__self__, "local_path", local_path)
        pulumi.set(__self__, "s3_uri", s3_uri)
        if s3_upload_mode is not None:
            pulumi.set(__self__, "s3_upload_mode", s3_upload_mode)

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> str:
        """
        The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. LocalPath is an absolute path for the output data.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> str:
        """
        A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
        """
        return pulumi.get(self, "s3_uri")

    @property
    @pulumi.getter(name="s3UploadMode")
    def s3_upload_mode(self) -> Optional['ModelQualityJobDefinitionS3OutputS3UploadMode']:
        """
        Whether to upload the results of the monitoring job continuously or after the job completes.
        """
        return pulumi.get(self, "s3_upload_mode")


@pulumi.output_type
class ModelQualityJobDefinitionStoppingCondition(dict):
    """
    Specifies a time limit for how long the monitoring job is allowed to run.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxRuntimeInSeconds":
            suggest = "max_runtime_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelQualityJobDefinitionStoppingCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelQualityJobDefinitionStoppingCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelQualityJobDefinitionStoppingCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_runtime_in_seconds: int):
        """
        Specifies a time limit for how long the monitoring job is allowed to run.
        :param int max_runtime_in_seconds: The maximum runtime allowed in seconds.
        """
        pulumi.set(__self__, "max_runtime_in_seconds", max_runtime_in_seconds)

    @property
    @pulumi.getter(name="maxRuntimeInSeconds")
    def max_runtime_in_seconds(self) -> int:
        """
        The maximum runtime allowed in seconds.
        """
        return pulumi.get(self, "max_runtime_in_seconds")


@pulumi.output_type
class ModelQualityJobDefinitionVpcConfig(dict):
    """
    Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupIds":
            suggest = "security_group_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelQualityJobDefinitionVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelQualityJobDefinitionVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelQualityJobDefinitionVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_ids: Sequence[str],
                 subnets: Sequence[str]):
        """
        Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.
        :param Sequence[str] security_group_ids: The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the Subnets field.
        :param Sequence[str] subnets: The ID of the subnets in the VPC to which you want to connect to your monitoring jobs.
        """
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[str]:
        """
        The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the Subnets field.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[str]:
        """
        The ID of the subnets in the VPC to which you want to connect to your monitoring jobs.
        """
        return pulumi.get(self, "subnets")


@pulumi.output_type
class MonitoringScheduleBaselineConfig(dict):
    """
    Baseline configuration used to validate that the data conforms to the specified constraints and statistics.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "constraintsResource":
            suggest = "constraints_resource"
        elif key == "statisticsResource":
            suggest = "statistics_resource"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleBaselineConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleBaselineConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleBaselineConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 constraints_resource: Optional['outputs.MonitoringScheduleConstraintsResource'] = None,
                 statistics_resource: Optional['outputs.MonitoringScheduleStatisticsResource'] = None):
        """
        Baseline configuration used to validate that the data conforms to the specified constraints and statistics.
        :param 'MonitoringScheduleConstraintsResource' constraints_resource: The Amazon S3 URI for the constraints resource.
        :param 'MonitoringScheduleStatisticsResource' statistics_resource: The baseline statistics file in Amazon S3 that the current monitoring job should be validated against.
        """
        if constraints_resource is not None:
            pulumi.set(__self__, "constraints_resource", constraints_resource)
        if statistics_resource is not None:
            pulumi.set(__self__, "statistics_resource", statistics_resource)

    @property
    @pulumi.getter(name="constraintsResource")
    def constraints_resource(self) -> Optional['outputs.MonitoringScheduleConstraintsResource']:
        """
        The Amazon S3 URI for the constraints resource.
        """
        return pulumi.get(self, "constraints_resource")

    @property
    @pulumi.getter(name="statisticsResource")
    def statistics_resource(self) -> Optional['outputs.MonitoringScheduleStatisticsResource']:
        """
        The baseline statistics file in Amazon S3 that the current monitoring job should be validated against.
        """
        return pulumi.get(self, "statistics_resource")


@pulumi.output_type
class MonitoringScheduleBatchTransformInput(dict):
    """
    The batch transform input for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataCapturedDestinationS3Uri":
            suggest = "data_captured_destination_s3_uri"
        elif key == "datasetFormat":
            suggest = "dataset_format"
        elif key == "localPath":
            suggest = "local_path"
        elif key == "excludeFeaturesAttribute":
            suggest = "exclude_features_attribute"
        elif key == "s3DataDistributionType":
            suggest = "s3_data_distribution_type"
        elif key == "s3InputMode":
            suggest = "s3_input_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleBatchTransformInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleBatchTransformInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleBatchTransformInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_captured_destination_s3_uri: str,
                 dataset_format: 'outputs.MonitoringScheduleDatasetFormat',
                 local_path: str,
                 exclude_features_attribute: Optional[str] = None,
                 s3_data_distribution_type: Optional['MonitoringScheduleBatchTransformInputS3DataDistributionType'] = None,
                 s3_input_mode: Optional['MonitoringScheduleBatchTransformInputS3InputMode'] = None):
        """
        The batch transform input for a monitoring job.
        :param str data_captured_destination_s3_uri: A URI that identifies the Amazon S3 storage location where Batch Transform Job captures data.
        :param str local_path: Path to the filesystem where the endpoint data is available to the container.
        :param str exclude_features_attribute: Indexes or names of the features to be excluded from analysis
        :param 'MonitoringScheduleBatchTransformInputS3DataDistributionType' s3_data_distribution_type: Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to FullyReplicated
        :param 'MonitoringScheduleBatchTransformInputS3InputMode' s3_input_mode: Whether the Pipe or File is used as the input mode for transfering data for the monitoring job. Pipe mode is recommended for large datasets. File mode is useful for small files that fit in memory. Defaults to File.
        """
        pulumi.set(__self__, "data_captured_destination_s3_uri", data_captured_destination_s3_uri)
        pulumi.set(__self__, "dataset_format", dataset_format)
        pulumi.set(__self__, "local_path", local_path)
        if exclude_features_attribute is not None:
            pulumi.set(__self__, "exclude_features_attribute", exclude_features_attribute)
        if s3_data_distribution_type is not None:
            pulumi.set(__self__, "s3_data_distribution_type", s3_data_distribution_type)
        if s3_input_mode is not None:
            pulumi.set(__self__, "s3_input_mode", s3_input_mode)

    @property
    @pulumi.getter(name="dataCapturedDestinationS3Uri")
    def data_captured_destination_s3_uri(self) -> str:
        """
        A URI that identifies the Amazon S3 storage location where Batch Transform Job captures data.
        """
        return pulumi.get(self, "data_captured_destination_s3_uri")

    @property
    @pulumi.getter(name="datasetFormat")
    def dataset_format(self) -> 'outputs.MonitoringScheduleDatasetFormat':
        return pulumi.get(self, "dataset_format")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> str:
        """
        Path to the filesystem where the endpoint data is available to the container.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter(name="excludeFeaturesAttribute")
    def exclude_features_attribute(self) -> Optional[str]:
        """
        Indexes or names of the features to be excluded from analysis
        """
        return pulumi.get(self, "exclude_features_attribute")

    @property
    @pulumi.getter(name="s3DataDistributionType")
    def s3_data_distribution_type(self) -> Optional['MonitoringScheduleBatchTransformInputS3DataDistributionType']:
        """
        Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to FullyReplicated
        """
        return pulumi.get(self, "s3_data_distribution_type")

    @property
    @pulumi.getter(name="s3InputMode")
    def s3_input_mode(self) -> Optional['MonitoringScheduleBatchTransformInputS3InputMode']:
        """
        Whether the Pipe or File is used as the input mode for transfering data for the monitoring job. Pipe mode is recommended for large datasets. File mode is useful for small files that fit in memory. Defaults to File.
        """
        return pulumi.get(self, "s3_input_mode")


@pulumi.output_type
class MonitoringScheduleClusterConfig(dict):
    """
    Configuration for the cluster used to run model monitoring jobs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceCount":
            suggest = "instance_count"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "volumeSizeInGb":
            suggest = "volume_size_in_gb"
        elif key == "volumeKmsKeyId":
            suggest = "volume_kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleClusterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleClusterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleClusterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_count: int,
                 instance_type: str,
                 volume_size_in_gb: int,
                 volume_kms_key_id: Optional[str] = None):
        """
        Configuration for the cluster used to run model monitoring jobs.
        :param int instance_count: The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1. The default value is 1.
        :param str instance_type: The ML compute instance type for the processing job.
        :param int volume_size_in_gb: The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
        :param str volume_kms_key_id: The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
        """
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "volume_size_in_gb", volume_size_in_gb)
        if volume_kms_key_id is not None:
            pulumi.set(__self__, "volume_kms_key_id", volume_kms_key_id)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> int:
        """
        The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1. The default value is 1.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        The ML compute instance type for the processing job.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="volumeSizeInGb")
    def volume_size_in_gb(self) -> int:
        """
        The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
        """
        return pulumi.get(self, "volume_size_in_gb")

    @property
    @pulumi.getter(name="volumeKmsKeyId")
    def volume_kms_key_id(self) -> Optional[str]:
        """
        The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
        """
        return pulumi.get(self, "volume_kms_key_id")


@pulumi.output_type
class MonitoringScheduleConfig(dict):
    """
    The configuration object that specifies the monitoring schedule and defines the monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "monitoringJobDefinition":
            suggest = "monitoring_job_definition"
        elif key == "monitoringJobDefinitionName":
            suggest = "monitoring_job_definition_name"
        elif key == "monitoringType":
            suggest = "monitoring_type"
        elif key == "scheduleConfig":
            suggest = "schedule_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 monitoring_job_definition: Optional['outputs.MonitoringScheduleMonitoringJobDefinition'] = None,
                 monitoring_job_definition_name: Optional[str] = None,
                 monitoring_type: Optional['MonitoringScheduleMonitoringType'] = None,
                 schedule_config: Optional['outputs.MonitoringScheduleScheduleConfig'] = None):
        """
        The configuration object that specifies the monitoring schedule and defines the monitoring job.
        :param 'MonitoringScheduleMonitoringJobDefinition' monitoring_job_definition: Defines the monitoring job.
        :param str monitoring_job_definition_name: Name of the job definition
        :param 'MonitoringScheduleMonitoringType' monitoring_type: The type of the monitoring job definition to schedule.
        :param 'MonitoringScheduleScheduleConfig' schedule_config: Configures the monitoring schedule.
        """
        if monitoring_job_definition is not None:
            pulumi.set(__self__, "monitoring_job_definition", monitoring_job_definition)
        if monitoring_job_definition_name is not None:
            pulumi.set(__self__, "monitoring_job_definition_name", monitoring_job_definition_name)
        if monitoring_type is not None:
            pulumi.set(__self__, "monitoring_type", monitoring_type)
        if schedule_config is not None:
            pulumi.set(__self__, "schedule_config", schedule_config)

    @property
    @pulumi.getter(name="monitoringJobDefinition")
    def monitoring_job_definition(self) -> Optional['outputs.MonitoringScheduleMonitoringJobDefinition']:
        """
        Defines the monitoring job.
        """
        return pulumi.get(self, "monitoring_job_definition")

    @property
    @pulumi.getter(name="monitoringJobDefinitionName")
    def monitoring_job_definition_name(self) -> Optional[str]:
        """
        Name of the job definition
        """
        return pulumi.get(self, "monitoring_job_definition_name")

    @property
    @pulumi.getter(name="monitoringType")
    def monitoring_type(self) -> Optional['MonitoringScheduleMonitoringType']:
        """
        The type of the monitoring job definition to schedule.
        """
        return pulumi.get(self, "monitoring_type")

    @property
    @pulumi.getter(name="scheduleConfig")
    def schedule_config(self) -> Optional['outputs.MonitoringScheduleScheduleConfig']:
        """
        Configures the monitoring schedule.
        """
        return pulumi.get(self, "schedule_config")


@pulumi.output_type
class MonitoringScheduleConstraintsResource(dict):
    """
    The baseline constraints resource for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Uri":
            suggest = "s3_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleConstraintsResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleConstraintsResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleConstraintsResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_uri: Optional[str] = None):
        """
        The baseline constraints resource for a monitoring job.
        :param str s3_uri: The Amazon S3 URI for baseline constraint file in Amazon S3 that the current monitoring job should validated against.
        """
        if s3_uri is not None:
            pulumi.set(__self__, "s3_uri", s3_uri)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> Optional[str]:
        """
        The Amazon S3 URI for baseline constraint file in Amazon S3 that the current monitoring job should validated against.
        """
        return pulumi.get(self, "s3_uri")


@pulumi.output_type
class MonitoringScheduleCsv(dict):
    """
    The CSV format
    """
    def __init__(__self__, *,
                 header: Optional[bool] = None):
        """
        The CSV format
        :param bool header: A boolean flag indicating if given CSV has header
        """
        if header is not None:
            pulumi.set(__self__, "header", header)

    @property
    @pulumi.getter
    def header(self) -> Optional[bool]:
        """
        A boolean flag indicating if given CSV has header
        """
        return pulumi.get(self, "header")


@pulumi.output_type
class MonitoringScheduleDatasetFormat(dict):
    """
    The dataset format of the data to monitor
    """
    def __init__(__self__, *,
                 csv: Optional['outputs.MonitoringScheduleCsv'] = None,
                 json: Optional['outputs.MonitoringScheduleJson'] = None,
                 parquet: Optional[bool] = None):
        """
        The dataset format of the data to monitor
        """
        if csv is not None:
            pulumi.set(__self__, "csv", csv)
        if json is not None:
            pulumi.set(__self__, "json", json)
        if parquet is not None:
            pulumi.set(__self__, "parquet", parquet)

    @property
    @pulumi.getter
    def csv(self) -> Optional['outputs.MonitoringScheduleCsv']:
        return pulumi.get(self, "csv")

    @property
    @pulumi.getter
    def json(self) -> Optional['outputs.MonitoringScheduleJson']:
        return pulumi.get(self, "json")

    @property
    @pulumi.getter
    def parquet(self) -> Optional[bool]:
        return pulumi.get(self, "parquet")


@pulumi.output_type
class MonitoringScheduleEndpointInput(dict):
    """
    The endpoint for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointName":
            suggest = "endpoint_name"
        elif key == "localPath":
            suggest = "local_path"
        elif key == "excludeFeaturesAttribute":
            suggest = "exclude_features_attribute"
        elif key == "s3DataDistributionType":
            suggest = "s3_data_distribution_type"
        elif key == "s3InputMode":
            suggest = "s3_input_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleEndpointInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleEndpointInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleEndpointInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_name: str,
                 local_path: str,
                 exclude_features_attribute: Optional[str] = None,
                 s3_data_distribution_type: Optional['MonitoringScheduleEndpointInputS3DataDistributionType'] = None,
                 s3_input_mode: Optional['MonitoringScheduleEndpointInputS3InputMode'] = None):
        """
        The endpoint for a monitoring job.
        :param str local_path: Path to the filesystem where the endpoint data is available to the container.
        :param str exclude_features_attribute: Indexes or names of the features to be excluded from analysis
        :param 'MonitoringScheduleEndpointInputS3DataDistributionType' s3_data_distribution_type: Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to FullyReplicated
        :param 'MonitoringScheduleEndpointInputS3InputMode' s3_input_mode: Whether the Pipe or File is used as the input mode for transfering data for the monitoring job. Pipe mode is recommended for large datasets. File mode is useful for small files that fit in memory. Defaults to File.
        """
        pulumi.set(__self__, "endpoint_name", endpoint_name)
        pulumi.set(__self__, "local_path", local_path)
        if exclude_features_attribute is not None:
            pulumi.set(__self__, "exclude_features_attribute", exclude_features_attribute)
        if s3_data_distribution_type is not None:
            pulumi.set(__self__, "s3_data_distribution_type", s3_data_distribution_type)
        if s3_input_mode is not None:
            pulumi.set(__self__, "s3_input_mode", s3_input_mode)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> str:
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> str:
        """
        Path to the filesystem where the endpoint data is available to the container.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter(name="excludeFeaturesAttribute")
    def exclude_features_attribute(self) -> Optional[str]:
        """
        Indexes or names of the features to be excluded from analysis
        """
        return pulumi.get(self, "exclude_features_attribute")

    @property
    @pulumi.getter(name="s3DataDistributionType")
    def s3_data_distribution_type(self) -> Optional['MonitoringScheduleEndpointInputS3DataDistributionType']:
        """
        Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to FullyReplicated
        """
        return pulumi.get(self, "s3_data_distribution_type")

    @property
    @pulumi.getter(name="s3InputMode")
    def s3_input_mode(self) -> Optional['MonitoringScheduleEndpointInputS3InputMode']:
        """
        Whether the Pipe or File is used as the input mode for transfering data for the monitoring job. Pipe mode is recommended for large datasets. File mode is useful for small files that fit in memory. Defaults to File.
        """
        return pulumi.get(self, "s3_input_mode")


@pulumi.output_type
class MonitoringScheduleJson(dict):
    """
    The Json format
    """
    def __init__(__self__, *,
                 line: Optional[bool] = None):
        """
        The Json format
        :param bool line: A boolean flag indicating if it is JSON line format
        """
        if line is not None:
            pulumi.set(__self__, "line", line)

    @property
    @pulumi.getter
    def line(self) -> Optional[bool]:
        """
        A boolean flag indicating if it is JSON line format
        """
        return pulumi.get(self, "line")


@pulumi.output_type
class MonitoringScheduleMonitoringAppSpecification(dict):
    """
    Container image configuration object for the monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageUri":
            suggest = "image_uri"
        elif key == "containerArguments":
            suggest = "container_arguments"
        elif key == "containerEntrypoint":
            suggest = "container_entrypoint"
        elif key == "postAnalyticsProcessorSourceUri":
            suggest = "post_analytics_processor_source_uri"
        elif key == "recordPreprocessorSourceUri":
            suggest = "record_preprocessor_source_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleMonitoringAppSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleMonitoringAppSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleMonitoringAppSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_uri: str,
                 container_arguments: Optional[Sequence[str]] = None,
                 container_entrypoint: Optional[Sequence[str]] = None,
                 post_analytics_processor_source_uri: Optional[str] = None,
                 record_preprocessor_source_uri: Optional[str] = None):
        """
        Container image configuration object for the monitoring job.
        :param str image_uri: The container image to be run by the monitoring job.
        :param Sequence[str] container_arguments: An array of arguments for the container used to run the monitoring job.
        :param Sequence[str] container_entrypoint: Specifies the entrypoint for a container used to run the monitoring job.
        :param str post_analytics_processor_source_uri: An Amazon S3 URI to a script that is called after analysis has been performed. Applicable only for the built-in (first party) containers.
        :param str record_preprocessor_source_uri: An Amazon S3 URI to a script that is called per row prior to running analysis. It can base64 decode the payload and convert it into a flatted json so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers
        """
        pulumi.set(__self__, "image_uri", image_uri)
        if container_arguments is not None:
            pulumi.set(__self__, "container_arguments", container_arguments)
        if container_entrypoint is not None:
            pulumi.set(__self__, "container_entrypoint", container_entrypoint)
        if post_analytics_processor_source_uri is not None:
            pulumi.set(__self__, "post_analytics_processor_source_uri", post_analytics_processor_source_uri)
        if record_preprocessor_source_uri is not None:
            pulumi.set(__self__, "record_preprocessor_source_uri", record_preprocessor_source_uri)

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> str:
        """
        The container image to be run by the monitoring job.
        """
        return pulumi.get(self, "image_uri")

    @property
    @pulumi.getter(name="containerArguments")
    def container_arguments(self) -> Optional[Sequence[str]]:
        """
        An array of arguments for the container used to run the monitoring job.
        """
        return pulumi.get(self, "container_arguments")

    @property
    @pulumi.getter(name="containerEntrypoint")
    def container_entrypoint(self) -> Optional[Sequence[str]]:
        """
        Specifies the entrypoint for a container used to run the monitoring job.
        """
        return pulumi.get(self, "container_entrypoint")

    @property
    @pulumi.getter(name="postAnalyticsProcessorSourceUri")
    def post_analytics_processor_source_uri(self) -> Optional[str]:
        """
        An Amazon S3 URI to a script that is called after analysis has been performed. Applicable only for the built-in (first party) containers.
        """
        return pulumi.get(self, "post_analytics_processor_source_uri")

    @property
    @pulumi.getter(name="recordPreprocessorSourceUri")
    def record_preprocessor_source_uri(self) -> Optional[str]:
        """
        An Amazon S3 URI to a script that is called per row prior to running analysis. It can base64 decode the payload and convert it into a flatted json so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers
        """
        return pulumi.get(self, "record_preprocessor_source_uri")


@pulumi.output_type
class MonitoringScheduleMonitoringExecutionSummary(dict):
    """
    Summary of information about monitoring job
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "creationTime":
            suggest = "creation_time"
        elif key == "lastModifiedTime":
            suggest = "last_modified_time"
        elif key == "monitoringExecutionStatus":
            suggest = "monitoring_execution_status"
        elif key == "monitoringScheduleName":
            suggest = "monitoring_schedule_name"
        elif key == "scheduledTime":
            suggest = "scheduled_time"
        elif key == "endpointName":
            suggest = "endpoint_name"
        elif key == "failureReason":
            suggest = "failure_reason"
        elif key == "processingJobArn":
            suggest = "processing_job_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleMonitoringExecutionSummary. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleMonitoringExecutionSummary.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleMonitoringExecutionSummary.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 creation_time: str,
                 last_modified_time: str,
                 monitoring_execution_status: 'MonitoringScheduleMonitoringExecutionSummaryMonitoringExecutionStatus',
                 monitoring_schedule_name: str,
                 scheduled_time: str,
                 endpoint_name: Optional[str] = None,
                 failure_reason: Optional[str] = None,
                 processing_job_arn: Optional[str] = None):
        """
        Summary of information about monitoring job
        :param str creation_time: The time at which the monitoring job was created.
        :param str last_modified_time: A timestamp that indicates the last time the monitoring job was modified.
        :param 'MonitoringScheduleMonitoringExecutionSummaryMonitoringExecutionStatus' monitoring_execution_status: The status of the monitoring job.
        :param str monitoring_schedule_name: The name of the monitoring schedule.
        :param str scheduled_time: The time the monitoring job was scheduled.
        :param str endpoint_name: The name of the endpoint used to run the monitoring job.
        :param str failure_reason: Contains the reason a monitoring job failed, if it failed.
        :param str processing_job_arn: The Amazon Resource Name (ARN) of the monitoring job.
        """
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "last_modified_time", last_modified_time)
        pulumi.set(__self__, "monitoring_execution_status", monitoring_execution_status)
        pulumi.set(__self__, "monitoring_schedule_name", monitoring_schedule_name)
        pulumi.set(__self__, "scheduled_time", scheduled_time)
        if endpoint_name is not None:
            pulumi.set(__self__, "endpoint_name", endpoint_name)
        if failure_reason is not None:
            pulumi.set(__self__, "failure_reason", failure_reason)
        if processing_job_arn is not None:
            pulumi.set(__self__, "processing_job_arn", processing_job_arn)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        The time at which the monitoring job was created.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> str:
        """
        A timestamp that indicates the last time the monitoring job was modified.
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter(name="monitoringExecutionStatus")
    def monitoring_execution_status(self) -> 'MonitoringScheduleMonitoringExecutionSummaryMonitoringExecutionStatus':
        """
        The status of the monitoring job.
        """
        return pulumi.get(self, "monitoring_execution_status")

    @property
    @pulumi.getter(name="monitoringScheduleName")
    def monitoring_schedule_name(self) -> str:
        """
        The name of the monitoring schedule.
        """
        return pulumi.get(self, "monitoring_schedule_name")

    @property
    @pulumi.getter(name="scheduledTime")
    def scheduled_time(self) -> str:
        """
        The time the monitoring job was scheduled.
        """
        return pulumi.get(self, "scheduled_time")

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> Optional[str]:
        """
        The name of the endpoint used to run the monitoring job.
        """
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="failureReason")
    def failure_reason(self) -> Optional[str]:
        """
        Contains the reason a monitoring job failed, if it failed.
        """
        return pulumi.get(self, "failure_reason")

    @property
    @pulumi.getter(name="processingJobArn")
    def processing_job_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the monitoring job.
        """
        return pulumi.get(self, "processing_job_arn")


@pulumi.output_type
class MonitoringScheduleMonitoringInput(dict):
    """
    The inputs for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "batchTransformInput":
            suggest = "batch_transform_input"
        elif key == "endpointInput":
            suggest = "endpoint_input"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleMonitoringInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleMonitoringInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleMonitoringInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 batch_transform_input: Optional['outputs.MonitoringScheduleBatchTransformInput'] = None,
                 endpoint_input: Optional['outputs.MonitoringScheduleEndpointInput'] = None):
        """
        The inputs for a monitoring job.
        """
        if batch_transform_input is not None:
            pulumi.set(__self__, "batch_transform_input", batch_transform_input)
        if endpoint_input is not None:
            pulumi.set(__self__, "endpoint_input", endpoint_input)

    @property
    @pulumi.getter(name="batchTransformInput")
    def batch_transform_input(self) -> Optional['outputs.MonitoringScheduleBatchTransformInput']:
        return pulumi.get(self, "batch_transform_input")

    @property
    @pulumi.getter(name="endpointInput")
    def endpoint_input(self) -> Optional['outputs.MonitoringScheduleEndpointInput']:
        return pulumi.get(self, "endpoint_input")


@pulumi.output_type
class MonitoringScheduleMonitoringJobDefinition(dict):
    """
    Defines the monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "monitoringAppSpecification":
            suggest = "monitoring_app_specification"
        elif key == "monitoringInputs":
            suggest = "monitoring_inputs"
        elif key == "monitoringOutputConfig":
            suggest = "monitoring_output_config"
        elif key == "monitoringResources":
            suggest = "monitoring_resources"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "baselineConfig":
            suggest = "baseline_config"
        elif key == "networkConfig":
            suggest = "network_config"
        elif key == "stoppingCondition":
            suggest = "stopping_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleMonitoringJobDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleMonitoringJobDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleMonitoringJobDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 monitoring_app_specification: 'outputs.MonitoringScheduleMonitoringAppSpecification',
                 monitoring_inputs: Sequence['outputs.MonitoringScheduleMonitoringInput'],
                 monitoring_output_config: 'outputs.MonitoringScheduleMonitoringOutputConfig',
                 monitoring_resources: 'outputs.MonitoringScheduleMonitoringResources',
                 role_arn: str,
                 baseline_config: Optional['outputs.MonitoringScheduleBaselineConfig'] = None,
                 environment: Optional[Any] = None,
                 network_config: Optional['outputs.MonitoringScheduleNetworkConfig'] = None,
                 stopping_condition: Optional['outputs.MonitoringScheduleStoppingCondition'] = None):
        """
        Defines the monitoring job.
        :param 'MonitoringScheduleMonitoringAppSpecification' monitoring_app_specification: Configures the monitoring job to run a specified Docker container image.
        :param Sequence['MonitoringScheduleMonitoringInput'] monitoring_inputs: The array of inputs for the monitoring job. Currently we support monitoring an Amazon SageMaker Endpoint.
        :param 'MonitoringScheduleMonitoringOutputConfig' monitoring_output_config: The array of outputs from the monitoring job to be uploaded to Amazon S3.
        :param 'MonitoringScheduleMonitoringResources' monitoring_resources: Identifies the resources, ML compute instances, and ML storage volumes to deploy for a monitoring job. In distributed processing, you specify more than one instance.
        :param str role_arn: The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
        :param 'MonitoringScheduleBaselineConfig' baseline_config: Baseline configuration used to validate that the data conforms to the specified constraints and statistics
        :param Any environment: Sets the environment variables in the Docker container
        :param 'MonitoringScheduleNetworkConfig' network_config: Specifies networking options for an monitoring job.
        :param 'MonitoringScheduleStoppingCondition' stopping_condition: Specifies a time limit for how long the monitoring job is allowed to run.
        """
        pulumi.set(__self__, "monitoring_app_specification", monitoring_app_specification)
        pulumi.set(__self__, "monitoring_inputs", monitoring_inputs)
        pulumi.set(__self__, "monitoring_output_config", monitoring_output_config)
        pulumi.set(__self__, "monitoring_resources", monitoring_resources)
        pulumi.set(__self__, "role_arn", role_arn)
        if baseline_config is not None:
            pulumi.set(__self__, "baseline_config", baseline_config)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if network_config is not None:
            pulumi.set(__self__, "network_config", network_config)
        if stopping_condition is not None:
            pulumi.set(__self__, "stopping_condition", stopping_condition)

    @property
    @pulumi.getter(name="monitoringAppSpecification")
    def monitoring_app_specification(self) -> 'outputs.MonitoringScheduleMonitoringAppSpecification':
        """
        Configures the monitoring job to run a specified Docker container image.
        """
        return pulumi.get(self, "monitoring_app_specification")

    @property
    @pulumi.getter(name="monitoringInputs")
    def monitoring_inputs(self) -> Sequence['outputs.MonitoringScheduleMonitoringInput']:
        """
        The array of inputs for the monitoring job. Currently we support monitoring an Amazon SageMaker Endpoint.
        """
        return pulumi.get(self, "monitoring_inputs")

    @property
    @pulumi.getter(name="monitoringOutputConfig")
    def monitoring_output_config(self) -> 'outputs.MonitoringScheduleMonitoringOutputConfig':
        """
        The array of outputs from the monitoring job to be uploaded to Amazon S3.
        """
        return pulumi.get(self, "monitoring_output_config")

    @property
    @pulumi.getter(name="monitoringResources")
    def monitoring_resources(self) -> 'outputs.MonitoringScheduleMonitoringResources':
        """
        Identifies the resources, ML compute instances, and ML storage volumes to deploy for a monitoring job. In distributed processing, you specify more than one instance.
        """
        return pulumi.get(self, "monitoring_resources")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="baselineConfig")
    def baseline_config(self) -> Optional['outputs.MonitoringScheduleBaselineConfig']:
        """
        Baseline configuration used to validate that the data conforms to the specified constraints and statistics
        """
        return pulumi.get(self, "baseline_config")

    @property
    @pulumi.getter
    def environment(self) -> Optional[Any]:
        """
        Sets the environment variables in the Docker container
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> Optional['outputs.MonitoringScheduleNetworkConfig']:
        """
        Specifies networking options for an monitoring job.
        """
        return pulumi.get(self, "network_config")

    @property
    @pulumi.getter(name="stoppingCondition")
    def stopping_condition(self) -> Optional['outputs.MonitoringScheduleStoppingCondition']:
        """
        Specifies a time limit for how long the monitoring job is allowed to run.
        """
        return pulumi.get(self, "stopping_condition")


@pulumi.output_type
class MonitoringScheduleMonitoringOutput(dict):
    """
    The output object for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Output":
            suggest = "s3_output"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleMonitoringOutput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleMonitoringOutput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleMonitoringOutput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_output: 'outputs.MonitoringScheduleS3Output'):
        """
        The output object for a monitoring job.
        :param 'MonitoringScheduleS3Output' s3_output: The Amazon S3 storage location where the results of a monitoring job are saved.
        """
        pulumi.set(__self__, "s3_output", s3_output)

    @property
    @pulumi.getter(name="s3Output")
    def s3_output(self) -> 'outputs.MonitoringScheduleS3Output':
        """
        The Amazon S3 storage location where the results of a monitoring job are saved.
        """
        return pulumi.get(self, "s3_output")


@pulumi.output_type
class MonitoringScheduleMonitoringOutputConfig(dict):
    """
    The output configuration for monitoring jobs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "monitoringOutputs":
            suggest = "monitoring_outputs"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleMonitoringOutputConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleMonitoringOutputConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleMonitoringOutputConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 monitoring_outputs: Sequence['outputs.MonitoringScheduleMonitoringOutput'],
                 kms_key_id: Optional[str] = None):
        """
        The output configuration for monitoring jobs.
        :param Sequence['MonitoringScheduleMonitoringOutput'] monitoring_outputs: Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
        :param str kms_key_id: The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
        """
        pulumi.set(__self__, "monitoring_outputs", monitoring_outputs)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="monitoringOutputs")
    def monitoring_outputs(self) -> Sequence['outputs.MonitoringScheduleMonitoringOutput']:
        """
        Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
        """
        return pulumi.get(self, "monitoring_outputs")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class MonitoringScheduleMonitoringResources(dict):
    """
    Identifies the resources to deploy for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterConfig":
            suggest = "cluster_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleMonitoringResources. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleMonitoringResources.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleMonitoringResources.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_config: 'outputs.MonitoringScheduleClusterConfig'):
        """
        Identifies the resources to deploy for a monitoring job.
        :param 'MonitoringScheduleClusterConfig' cluster_config: The configuration for the cluster resources used to run the processing job.
        """
        pulumi.set(__self__, "cluster_config", cluster_config)

    @property
    @pulumi.getter(name="clusterConfig")
    def cluster_config(self) -> 'outputs.MonitoringScheduleClusterConfig':
        """
        The configuration for the cluster resources used to run the processing job.
        """
        return pulumi.get(self, "cluster_config")


@pulumi.output_type
class MonitoringScheduleNetworkConfig(dict):
    """
    Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableInterContainerTrafficEncryption":
            suggest = "enable_inter_container_traffic_encryption"
        elif key == "enableNetworkIsolation":
            suggest = "enable_network_isolation"
        elif key == "vpcConfig":
            suggest = "vpc_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleNetworkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleNetworkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleNetworkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_inter_container_traffic_encryption: Optional[bool] = None,
                 enable_network_isolation: Optional[bool] = None,
                 vpc_config: Optional['outputs.MonitoringScheduleVpcConfig'] = None):
        """
        Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
        :param bool enable_inter_container_traffic_encryption: Whether to encrypt all communications between distributed processing jobs. Choose True to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
        :param bool enable_network_isolation: Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
        :param 'MonitoringScheduleVpcConfig' vpc_config: Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC. For more information, see [Protect Endpoints by Using an Amazon Virtual Private Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html) and [Protect Training Jobs by Using an Amazon Virtual Private Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html) .
        """
        if enable_inter_container_traffic_encryption is not None:
            pulumi.set(__self__, "enable_inter_container_traffic_encryption", enable_inter_container_traffic_encryption)
        if enable_network_isolation is not None:
            pulumi.set(__self__, "enable_network_isolation", enable_network_isolation)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @property
    @pulumi.getter(name="enableInterContainerTrafficEncryption")
    def enable_inter_container_traffic_encryption(self) -> Optional[bool]:
        """
        Whether to encrypt all communications between distributed processing jobs. Choose True to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
        """
        return pulumi.get(self, "enable_inter_container_traffic_encryption")

    @property
    @pulumi.getter(name="enableNetworkIsolation")
    def enable_network_isolation(self) -> Optional[bool]:
        """
        Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
        """
        return pulumi.get(self, "enable_network_isolation")

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional['outputs.MonitoringScheduleVpcConfig']:
        """
        Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC. For more information, see [Protect Endpoints by Using an Amazon Virtual Private Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html) and [Protect Training Jobs by Using an Amazon Virtual Private Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html) .
        """
        return pulumi.get(self, "vpc_config")


@pulumi.output_type
class MonitoringScheduleS3Output(dict):
    """
    Information about where and how to store the results of a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localPath":
            suggest = "local_path"
        elif key == "s3Uri":
            suggest = "s3_uri"
        elif key == "s3UploadMode":
            suggest = "s3_upload_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleS3Output. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleS3Output.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleS3Output.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_path: str,
                 s3_uri: str,
                 s3_upload_mode: Optional['MonitoringScheduleS3OutputS3UploadMode'] = None):
        """
        Information about where and how to store the results of a monitoring job.
        :param str local_path: The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. LocalPath is an absolute path for the output data.
        :param str s3_uri: A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
        :param 'MonitoringScheduleS3OutputS3UploadMode' s3_upload_mode: Whether to upload the results of the monitoring job continuously or after the job completes.
        """
        pulumi.set(__self__, "local_path", local_path)
        pulumi.set(__self__, "s3_uri", s3_uri)
        if s3_upload_mode is not None:
            pulumi.set(__self__, "s3_upload_mode", s3_upload_mode)

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> str:
        """
        The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. LocalPath is an absolute path for the output data.
        """
        return pulumi.get(self, "local_path")

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> str:
        """
        A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
        """
        return pulumi.get(self, "s3_uri")

    @property
    @pulumi.getter(name="s3UploadMode")
    def s3_upload_mode(self) -> Optional['MonitoringScheduleS3OutputS3UploadMode']:
        """
        Whether to upload the results of the monitoring job continuously or after the job completes.
        """
        return pulumi.get(self, "s3_upload_mode")


@pulumi.output_type
class MonitoringScheduleScheduleConfig(dict):
    """
    Configuration details about the monitoring schedule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scheduleExpression":
            suggest = "schedule_expression"
        elif key == "dataAnalysisEndTime":
            suggest = "data_analysis_end_time"
        elif key == "dataAnalysisStartTime":
            suggest = "data_analysis_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleScheduleConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleScheduleConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleScheduleConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schedule_expression: str,
                 data_analysis_end_time: Optional[str] = None,
                 data_analysis_start_time: Optional[str] = None):
        """
        Configuration details about the monitoring schedule.
        :param str schedule_expression: A cron expression or 'NOW' that describes details about the monitoring schedule.
        :param str data_analysis_end_time: Data Analysis end time, e.g. PT0H
        :param str data_analysis_start_time: Data Analysis start time, e.g. -PT1H
        """
        pulumi.set(__self__, "schedule_expression", schedule_expression)
        if data_analysis_end_time is not None:
            pulumi.set(__self__, "data_analysis_end_time", data_analysis_end_time)
        if data_analysis_start_time is not None:
            pulumi.set(__self__, "data_analysis_start_time", data_analysis_start_time)

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> str:
        """
        A cron expression or 'NOW' that describes details about the monitoring schedule.
        """
        return pulumi.get(self, "schedule_expression")

    @property
    @pulumi.getter(name="dataAnalysisEndTime")
    def data_analysis_end_time(self) -> Optional[str]:
        """
        Data Analysis end time, e.g. PT0H
        """
        return pulumi.get(self, "data_analysis_end_time")

    @property
    @pulumi.getter(name="dataAnalysisStartTime")
    def data_analysis_start_time(self) -> Optional[str]:
        """
        Data Analysis start time, e.g. -PT1H
        """
        return pulumi.get(self, "data_analysis_start_time")


@pulumi.output_type
class MonitoringScheduleStatisticsResource(dict):
    """
    The baseline statistics resource for a monitoring job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Uri":
            suggest = "s3_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleStatisticsResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleStatisticsResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleStatisticsResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_uri: Optional[str] = None):
        """
        The baseline statistics resource for a monitoring job.
        :param str s3_uri: The Amazon S3 URI for the baseline statistics file in Amazon S3 that the current monitoring job should be validated against.
        """
        if s3_uri is not None:
            pulumi.set(__self__, "s3_uri", s3_uri)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> Optional[str]:
        """
        The Amazon S3 URI for the baseline statistics file in Amazon S3 that the current monitoring job should be validated against.
        """
        return pulumi.get(self, "s3_uri")


@pulumi.output_type
class MonitoringScheduleStoppingCondition(dict):
    """
    Specifies a time limit for how long the monitoring job is allowed to run.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxRuntimeInSeconds":
            suggest = "max_runtime_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleStoppingCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleStoppingCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleStoppingCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_runtime_in_seconds: int):
        """
        Specifies a time limit for how long the monitoring job is allowed to run.
        :param int max_runtime_in_seconds: The maximum runtime allowed in seconds.
        """
        pulumi.set(__self__, "max_runtime_in_seconds", max_runtime_in_seconds)

    @property
    @pulumi.getter(name="maxRuntimeInSeconds")
    def max_runtime_in_seconds(self) -> int:
        """
        The maximum runtime allowed in seconds.
        """
        return pulumi.get(self, "max_runtime_in_seconds")


@pulumi.output_type
class MonitoringScheduleVpcConfig(dict):
    """
    Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupIds":
            suggest = "security_group_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringScheduleVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringScheduleVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringScheduleVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_ids: Sequence[str],
                 subnets: Sequence[str]):
        """
        Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.
        :param Sequence[str] security_group_ids: The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the Subnets field.
        :param Sequence[str] subnets: The ID of the subnets in the VPC to which you want to connect to your monitoring jobs.
        """
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[str]:
        """
        The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the Subnets field.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[str]:
        """
        The ID of the subnets in the VPC to which you want to connect to your monitoring jobs.
        """
        return pulumi.get(self, "subnets")


@pulumi.output_type
class OfflineStoreConfigProperties(dict):
    """
    The configuration of an `OfflineStore` .
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3StorageConfig":
            suggest = "s3_storage_config"
        elif key == "dataCatalogConfig":
            suggest = "data_catalog_config"
        elif key == "disableGlueTableCreation":
            suggest = "disable_glue_table_creation"
        elif key == "tableFormat":
            suggest = "table_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OfflineStoreConfigProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OfflineStoreConfigProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OfflineStoreConfigProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_storage_config: 'outputs.FeatureGroupS3StorageConfig',
                 data_catalog_config: Optional['outputs.FeatureGroupDataCatalogConfig'] = None,
                 disable_glue_table_creation: Optional[bool] = None,
                 table_format: Optional['FeatureGroupTableFormat'] = None):
        """
        The configuration of an `OfflineStore` .
        :param 'FeatureGroupS3StorageConfig' s3_storage_config: The Amazon Simple Storage (Amazon S3) location of `OfflineStore` .
        :param 'FeatureGroupDataCatalogConfig' data_catalog_config: The meta data of the Glue table that is autogenerated when an `OfflineStore` is created.
        :param bool disable_glue_table_creation: Set to `True` to disable the automatic creation of an AWS Glue table when configuring an `OfflineStore` . If set to `False` , Feature Store will name the `OfflineStore` Glue table following [Athena's naming recommendations](https://docs.aws.amazon.com/athena/latest/ug/tables-databases-columns-names.html) .
               
               The default value is `False` .
        :param 'FeatureGroupTableFormat' table_format: Format for the offline store table. Supported formats are Glue (Default) and [Apache Iceberg](https://docs.aws.amazon.com/https://iceberg.apache.org/) .
        """
        pulumi.set(__self__, "s3_storage_config", s3_storage_config)
        if data_catalog_config is not None:
            pulumi.set(__self__, "data_catalog_config", data_catalog_config)
        if disable_glue_table_creation is not None:
            pulumi.set(__self__, "disable_glue_table_creation", disable_glue_table_creation)
        if table_format is not None:
            pulumi.set(__self__, "table_format", table_format)

    @property
    @pulumi.getter(name="s3StorageConfig")
    def s3_storage_config(self) -> 'outputs.FeatureGroupS3StorageConfig':
        """
        The Amazon Simple Storage (Amazon S3) location of `OfflineStore` .
        """
        return pulumi.get(self, "s3_storage_config")

    @property
    @pulumi.getter(name="dataCatalogConfig")
    def data_catalog_config(self) -> Optional['outputs.FeatureGroupDataCatalogConfig']:
        """
        The meta data of the Glue table that is autogenerated when an `OfflineStore` is created.
        """
        return pulumi.get(self, "data_catalog_config")

    @property
    @pulumi.getter(name="disableGlueTableCreation")
    def disable_glue_table_creation(self) -> Optional[bool]:
        """
        Set to `True` to disable the automatic creation of an AWS Glue table when configuring an `OfflineStore` . If set to `False` , Feature Store will name the `OfflineStore` Glue table following [Athena's naming recommendations](https://docs.aws.amazon.com/athena/latest/ug/tables-databases-columns-names.html) .

        The default value is `False` .
        """
        return pulumi.get(self, "disable_glue_table_creation")

    @property
    @pulumi.getter(name="tableFormat")
    def table_format(self) -> Optional['FeatureGroupTableFormat']:
        """
        Format for the offline store table. Supported formats are Glue (Default) and [Apache Iceberg](https://docs.aws.amazon.com/https://iceberg.apache.org/) .
        """
        return pulumi.get(self, "table_format")


@pulumi.output_type
class OnlineStoreConfigProperties(dict):
    """
    The configuration of an `OnlineStore` .
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableOnlineStore":
            suggest = "enable_online_store"
        elif key == "securityConfig":
            suggest = "security_config"
        elif key == "storageType":
            suggest = "storage_type"
        elif key == "ttlDuration":
            suggest = "ttl_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OnlineStoreConfigProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OnlineStoreConfigProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OnlineStoreConfigProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_online_store: Optional[bool] = None,
                 security_config: Optional['outputs.FeatureGroupOnlineStoreSecurityConfig'] = None,
                 storage_type: Optional['FeatureGroupStorageType'] = None,
                 ttl_duration: Optional['outputs.FeatureGroupTtlDuration'] = None):
        """
        The configuration of an `OnlineStore` .
        :param bool enable_online_store: Turn `OnlineStore` off by specifying `False` for the `EnableOnlineStore` flag. Turn `OnlineStore` on by specifying `True` for the `EnableOnlineStore` flag.
               
               The default value is `False` .
        :param 'FeatureGroupOnlineStoreSecurityConfig' security_config: Use to specify KMS Key ID ( `KMSKeyId` ) for at-rest encryption of your `OnlineStore` .
        :param 'FeatureGroupStorageType' storage_type: Option for different tiers of low latency storage for real-time data retrieval.
               
               - `Standard` : A managed low latency data store for feature groups.
               - `InMemory` : A managed data store for feature groups that supports very low latency retrieval.
        :param 'FeatureGroupTtlDuration' ttl_duration: Time to live duration, where the record is hard deleted after the expiration time is reached; `ExpiresAt` = `EventTime` + `TtlDuration` . For information on HardDelete, see the [DeleteRecord](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_DeleteRecord.html) API in the Amazon SageMaker API Reference guide.
        """
        if enable_online_store is not None:
            pulumi.set(__self__, "enable_online_store", enable_online_store)
        if security_config is not None:
            pulumi.set(__self__, "security_config", security_config)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if ttl_duration is not None:
            pulumi.set(__self__, "ttl_duration", ttl_duration)

    @property
    @pulumi.getter(name="enableOnlineStore")
    def enable_online_store(self) -> Optional[bool]:
        """
        Turn `OnlineStore` off by specifying `False` for the `EnableOnlineStore` flag. Turn `OnlineStore` on by specifying `True` for the `EnableOnlineStore` flag.

        The default value is `False` .
        """
        return pulumi.get(self, "enable_online_store")

    @property
    @pulumi.getter(name="securityConfig")
    def security_config(self) -> Optional['outputs.FeatureGroupOnlineStoreSecurityConfig']:
        """
        Use to specify KMS Key ID ( `KMSKeyId` ) for at-rest encryption of your `OnlineStore` .
        """
        return pulumi.get(self, "security_config")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional['FeatureGroupStorageType']:
        """
        Option for different tiers of low latency storage for real-time data retrieval.

        - `Standard` : A managed low latency data store for feature groups.
        - `InMemory` : A managed data store for feature groups that supports very low latency retrieval.
        """
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter(name="ttlDuration")
    def ttl_duration(self) -> Optional['outputs.FeatureGroupTtlDuration']:
        """
        Time to live duration, where the record is hard deleted after the expiration time is reached; `ExpiresAt` = `EventTime` + `TtlDuration` . For information on HardDelete, see the [DeleteRecord](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_DeleteRecord.html) API in the Amazon SageMaker API Reference guide.
        """
        return pulumi.get(self, "ttl_duration")


@pulumi.output_type
class ParallelismConfigurationProperties(dict):
    """
    The parallelism configuration applied to the pipeline.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxParallelExecutionSteps":
            suggest = "max_parallel_execution_steps"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ParallelismConfigurationProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ParallelismConfigurationProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ParallelismConfigurationProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_parallel_execution_steps: int):
        """
        The parallelism configuration applied to the pipeline.
        :param int max_parallel_execution_steps: Maximum parallel execution steps
        """
        pulumi.set(__self__, "max_parallel_execution_steps", max_parallel_execution_steps)

    @property
    @pulumi.getter(name="maxParallelExecutionSteps")
    def max_parallel_execution_steps(self) -> int:
        """
        Maximum parallel execution steps
        """
        return pulumi.get(self, "max_parallel_execution_steps")


@pulumi.output_type
class PipelineDefinition0Properties(dict):
    """
    The definition of the pipeline. This can be either a JSON string or an Amazon S3 location.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pipelineDefinitionBody":
            suggest = "pipeline_definition_body"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineDefinition0Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineDefinition0Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineDefinition0Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pipeline_definition_body: str):
        """
        The definition of the pipeline. This can be either a JSON string or an Amazon S3 location.
        :param str pipeline_definition_body: A specification that defines the pipeline in JSON format.
        """
        pulumi.set(__self__, "pipeline_definition_body", pipeline_definition_body)

    @property
    @pulumi.getter(name="pipelineDefinitionBody")
    def pipeline_definition_body(self) -> str:
        """
        A specification that defines the pipeline in JSON format.
        """
        return pulumi.get(self, "pipeline_definition_body")


@pulumi.output_type
class PipelineDefinition1Properties(dict):
    """
    The definition of the pipeline. This can be either a JSON string or an Amazon S3 location.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pipelineDefinitionS3Location":
            suggest = "pipeline_definition_s3_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineDefinition1Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineDefinition1Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineDefinition1Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pipeline_definition_s3_location: 'outputs.PipelineS3Location'):
        """
        The definition of the pipeline. This can be either a JSON string or an Amazon S3 location.
        """
        pulumi.set(__self__, "pipeline_definition_s3_location", pipeline_definition_s3_location)

    @property
    @pulumi.getter(name="pipelineDefinitionS3Location")
    def pipeline_definition_s3_location(self) -> 'outputs.PipelineS3Location':
        return pulumi.get(self, "pipeline_definition_s3_location")


@pulumi.output_type
class PipelineS3Location(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eTag":
            suggest = "e_tag"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineS3Location. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineS3Location.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineS3Location.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 key: str,
                 e_tag: Optional[str] = None,
                 version: Optional[str] = None):
        """
        :param str bucket: The name of the S3 bucket where the PipelineDefinition file is stored.
        :param str key: The file name of the PipelineDefinition file (Amazon S3 object name).
        :param str e_tag: The Amazon S3 ETag (a file checksum) of the PipelineDefinition file. If you don't specify a value, SageMaker skips ETag validation of your PipelineDefinition file.
        :param str version: For versioning-enabled buckets, a specific version of the PipelineDefinition file.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)
        if e_tag is not None:
            pulumi.set(__self__, "e_tag", e_tag)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The name of the S3 bucket where the PipelineDefinition file is stored.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The file name of the PipelineDefinition file (Amazon S3 object name).
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="eTag")
    def e_tag(self) -> Optional[str]:
        """
        The Amazon S3 ETag (a file checksum) of the PipelineDefinition file. If you don't specify a value, SageMaker skips ETag validation of your PipelineDefinition file.
        """
        return pulumi.get(self, "e_tag")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        For versioning-enabled buckets, a specific version of the PipelineDefinition file.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ProjectProvisioningParameter(dict):
    """
    Information about a parameter used to provision a product.
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        Information about a parameter used to provision a product.
        :param str key: The parameter key.
        :param str value: The parameter value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The parameter key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The parameter value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceCatalogProvisionedProductDetailsProperties(dict):
    """
    Provisioned ServiceCatalog  Details
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisionedProductId":
            suggest = "provisioned_product_id"
        elif key == "provisionedProductStatusMessage":
            suggest = "provisioned_product_status_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceCatalogProvisionedProductDetailsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceCatalogProvisionedProductDetailsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceCatalogProvisionedProductDetailsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioned_product_id: Optional[str] = None,
                 provisioned_product_status_message: Optional[str] = None):
        """
        Provisioned ServiceCatalog  Details
        :param str provisioned_product_id: The ID of the provisioned product.
        :param str provisioned_product_status_message: The current status of the product.
               
               - `AVAILABLE` - Stable state, ready to perform any operation. The most recent operation succeeded and completed.
               - `UNDER_CHANGE` - Transitive state. Operations performed might not have valid results. Wait for an AVAILABLE status before performing operations.
               - `TAINTED` - Stable state, ready to perform any operation. The stack has completed the requested operation but is not exactly what was requested. For example, a request to update to a new version failed and the stack rolled back to the current version.
               - `ERROR` - An unexpected error occurred. The provisioned product exists but the stack is not running. For example, CloudFormation received a parameter value that was not valid and could not launch the stack.
               - `PLAN_IN_PROGRESS` - Transitive state. The plan operations were performed to provision a new product, but resources have not yet been created. After reviewing the list of resources to be created, execute the plan. Wait for an AVAILABLE status before performing operations.
        """
        if provisioned_product_id is not None:
            pulumi.set(__self__, "provisioned_product_id", provisioned_product_id)
        if provisioned_product_status_message is not None:
            pulumi.set(__self__, "provisioned_product_status_message", provisioned_product_status_message)

    @property
    @pulumi.getter(name="provisionedProductId")
    def provisioned_product_id(self) -> Optional[str]:
        """
        The ID of the provisioned product.
        """
        return pulumi.get(self, "provisioned_product_id")

    @property
    @pulumi.getter(name="provisionedProductStatusMessage")
    def provisioned_product_status_message(self) -> Optional[str]:
        """
        The current status of the product.

        - `AVAILABLE` - Stable state, ready to perform any operation. The most recent operation succeeded and completed.
        - `UNDER_CHANGE` - Transitive state. Operations performed might not have valid results. Wait for an AVAILABLE status before performing operations.
        - `TAINTED` - Stable state, ready to perform any operation. The stack has completed the requested operation but is not exactly what was requested. For example, a request to update to a new version failed and the stack rolled back to the current version.
        - `ERROR` - An unexpected error occurred. The provisioned product exists but the stack is not running. For example, CloudFormation received a parameter value that was not valid and could not launch the stack.
        - `PLAN_IN_PROGRESS` - Transitive state. The plan operations were performed to provision a new product, but resources have not yet been created. After reviewing the list of resources to be created, execute the plan. Wait for an AVAILABLE status before performing operations.
        """
        return pulumi.get(self, "provisioned_product_status_message")


@pulumi.output_type
class ServiceCatalogProvisioningDetailsProperties(dict):
    """
    Input ServiceCatalog Provisioning Details
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "productId":
            suggest = "product_id"
        elif key == "pathId":
            suggest = "path_id"
        elif key == "provisioningArtifactId":
            suggest = "provisioning_artifact_id"
        elif key == "provisioningParameters":
            suggest = "provisioning_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceCatalogProvisioningDetailsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceCatalogProvisioningDetailsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceCatalogProvisioningDetailsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 product_id: str,
                 path_id: Optional[str] = None,
                 provisioning_artifact_id: Optional[str] = None,
                 provisioning_parameters: Optional[Sequence['outputs.ProjectProvisioningParameter']] = None):
        """
        Input ServiceCatalog Provisioning Details
        :param str product_id: The ID of the product to provision.
        :param str path_id: The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path.
        :param str provisioning_artifact_id: The ID of the provisioning artifact.
        :param Sequence['ProjectProvisioningParameter'] provisioning_parameters: Parameters specified by the administrator that are required for provisioning the product.
        """
        pulumi.set(__self__, "product_id", product_id)
        if path_id is not None:
            pulumi.set(__self__, "path_id", path_id)
        if provisioning_artifact_id is not None:
            pulumi.set(__self__, "provisioning_artifact_id", provisioning_artifact_id)
        if provisioning_parameters is not None:
            pulumi.set(__self__, "provisioning_parameters", provisioning_parameters)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> str:
        """
        The ID of the product to provision.
        """
        return pulumi.get(self, "product_id")

    @property
    @pulumi.getter(name="pathId")
    def path_id(self) -> Optional[str]:
        """
        The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path.
        """
        return pulumi.get(self, "path_id")

    @property
    @pulumi.getter(name="provisioningArtifactId")
    def provisioning_artifact_id(self) -> Optional[str]:
        """
        The ID of the provisioning artifact.
        """
        return pulumi.get(self, "provisioning_artifact_id")

    @property
    @pulumi.getter(name="provisioningParameters")
    def provisioning_parameters(self) -> Optional[Sequence['outputs.ProjectProvisioningParameter']]:
        """
        Parameters specified by the administrator that are required for provisioning the product.
        """
        return pulumi.get(self, "provisioning_parameters")


@pulumi.output_type
class SpaceAppLifecycleManagement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idleSettings":
            suggest = "idle_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpaceAppLifecycleManagement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpaceAppLifecycleManagement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpaceAppLifecycleManagement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 idle_settings: Optional['outputs.SpaceIdleSettings'] = None):
        """
        :param 'SpaceIdleSettings' idle_settings: Settings related to idle shutdown of Studio applications.
        """
        if idle_settings is not None:
            pulumi.set(__self__, "idle_settings", idle_settings)

    @property
    @pulumi.getter(name="idleSettings")
    def idle_settings(self) -> Optional['outputs.SpaceIdleSettings']:
        """
        Settings related to idle shutdown of Studio applications.
        """
        return pulumi.get(self, "idle_settings")


@pulumi.output_type
class SpaceCodeEditorAppSettings(dict):
    """
    The CodeEditor app settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appLifecycleManagement":
            suggest = "app_lifecycle_management"
        elif key == "defaultResourceSpec":
            suggest = "default_resource_spec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpaceCodeEditorAppSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpaceCodeEditorAppSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpaceCodeEditorAppSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_lifecycle_management: Optional['outputs.SpaceAppLifecycleManagement'] = None,
                 default_resource_spec: Optional['outputs.SpaceResourceSpec'] = None):
        """
        The CodeEditor app settings.
        :param 'SpaceAppLifecycleManagement' app_lifecycle_management: Settings that are used to configure and manage the lifecycle of CodeEditor applications in a space.
        :param 'SpaceResourceSpec' default_resource_spec: Specifies the ARNs of a SageMaker image and SageMaker image version, and the instance type that the version runs on.
        """
        if app_lifecycle_management is not None:
            pulumi.set(__self__, "app_lifecycle_management", app_lifecycle_management)
        if default_resource_spec is not None:
            pulumi.set(__self__, "default_resource_spec", default_resource_spec)

    @property
    @pulumi.getter(name="appLifecycleManagement")
    def app_lifecycle_management(self) -> Optional['outputs.SpaceAppLifecycleManagement']:
        """
        Settings that are used to configure and manage the lifecycle of CodeEditor applications in a space.
        """
        return pulumi.get(self, "app_lifecycle_management")

    @property
    @pulumi.getter(name="defaultResourceSpec")
    def default_resource_spec(self) -> Optional['outputs.SpaceResourceSpec']:
        """
        Specifies the ARNs of a SageMaker image and SageMaker image version, and the instance type that the version runs on.
        """
        return pulumi.get(self, "default_resource_spec")


@pulumi.output_type
class SpaceCodeRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repositoryUrl":
            suggest = "repository_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpaceCodeRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpaceCodeRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpaceCodeRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repository_url: str):
        """
        :param str repository_url: A CodeRepository (valid URL) to be used within Jupyter's Git extension.
        """
        pulumi.set(__self__, "repository_url", repository_url)

    @property
    @pulumi.getter(name="repositoryUrl")
    def repository_url(self) -> str:
        """
        A CodeRepository (valid URL) to be used within Jupyter's Git extension.
        """
        return pulumi.get(self, "repository_url")


@pulumi.output_type
class SpaceCustomFileSystem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "efsFileSystem":
            suggest = "efs_file_system"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpaceCustomFileSystem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpaceCustomFileSystem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpaceCustomFileSystem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 efs_file_system: Optional['outputs.SpaceEfsFileSystem'] = None):
        if efs_file_system is not None:
            pulumi.set(__self__, "efs_file_system", efs_file_system)

    @property
    @pulumi.getter(name="efsFileSystem")
    def efs_file_system(self) -> Optional['outputs.SpaceEfsFileSystem']:
        return pulumi.get(self, "efs_file_system")


@pulumi.output_type
class SpaceCustomImage(dict):
    """
    A custom SageMaker image.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appImageConfigName":
            suggest = "app_image_config_name"
        elif key == "imageName":
            suggest = "image_name"
        elif key == "imageVersionNumber":
            suggest = "image_version_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpaceCustomImage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpaceCustomImage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpaceCustomImage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_image_config_name: str,
                 image_name: str,
                 image_version_number: Optional[int] = None):
        """
        A custom SageMaker image.
        :param str app_image_config_name: The Name of the AppImageConfig.
        :param str image_name: The name of the CustomImage. Must be unique to your account.
        :param int image_version_number: The version number of the CustomImage.
        """
        pulumi.set(__self__, "app_image_config_name", app_image_config_name)
        pulumi.set(__self__, "image_name", image_name)
        if image_version_number is not None:
            pulumi.set(__self__, "image_version_number", image_version_number)

    @property
    @pulumi.getter(name="appImageConfigName")
    def app_image_config_name(self) -> str:
        """
        The Name of the AppImageConfig.
        """
        return pulumi.get(self, "app_image_config_name")

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> str:
        """
        The name of the CustomImage. Must be unique to your account.
        """
        return pulumi.get(self, "image_name")

    @property
    @pulumi.getter(name="imageVersionNumber")
    def image_version_number(self) -> Optional[int]:
        """
        The version number of the CustomImage.
        """
        return pulumi.get(self, "image_version_number")


@pulumi.output_type
class SpaceEbsStorageSettings(dict):
    """
    Properties related to the space's Amazon Elastic Block Store volume.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ebsVolumeSizeInGb":
            suggest = "ebs_volume_size_in_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpaceEbsStorageSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpaceEbsStorageSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpaceEbsStorageSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ebs_volume_size_in_gb: int):
        """
        Properties related to the space's Amazon Elastic Block Store volume.
        :param int ebs_volume_size_in_gb: Size of the Amazon EBS volume in Gb
        """
        pulumi.set(__self__, "ebs_volume_size_in_gb", ebs_volume_size_in_gb)

    @property
    @pulumi.getter(name="ebsVolumeSizeInGb")
    def ebs_volume_size_in_gb(self) -> int:
        """
        Size of the Amazon EBS volume in Gb
        """
        return pulumi.get(self, "ebs_volume_size_in_gb")


@pulumi.output_type
class SpaceEfsFileSystem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileSystemId":
            suggest = "file_system_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpaceEfsFileSystem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpaceEfsFileSystem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpaceEfsFileSystem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_system_id: str):
        pulumi.set(__self__, "file_system_id", file_system_id)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> str:
        return pulumi.get(self, "file_system_id")


@pulumi.output_type
class SpaceIdleSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idleTimeoutInMinutes":
            suggest = "idle_timeout_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpaceIdleSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpaceIdleSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpaceIdleSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 idle_timeout_in_minutes: Optional[int] = None):
        """
        :param int idle_timeout_in_minutes: The space idle timeout value set in minutes
        """
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[int]:
        """
        The space idle timeout value set in minutes
        """
        return pulumi.get(self, "idle_timeout_in_minutes")


@pulumi.output_type
class SpaceJupyterLabAppSettings(dict):
    """
    The JupyterServer app settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appLifecycleManagement":
            suggest = "app_lifecycle_management"
        elif key == "codeRepositories":
            suggest = "code_repositories"
        elif key == "defaultResourceSpec":
            suggest = "default_resource_spec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpaceJupyterLabAppSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpaceJupyterLabAppSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpaceJupyterLabAppSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_lifecycle_management: Optional['outputs.SpaceAppLifecycleManagement'] = None,
                 code_repositories: Optional[Sequence['outputs.SpaceCodeRepository']] = None,
                 default_resource_spec: Optional['outputs.SpaceResourceSpec'] = None):
        """
        The JupyterServer app settings.
        :param 'SpaceAppLifecycleManagement' app_lifecycle_management: Settings that are used to configure and manage the lifecycle of JupyterLab applications in a space.
        :param Sequence['SpaceCodeRepository'] code_repositories: A list of CodeRepositories available for use with JupyterLab apps.
        :param 'SpaceResourceSpec' default_resource_spec: Specifies the ARNs of a SageMaker image and SageMaker image version, and the instance type that the version runs on.
        """
        if app_lifecycle_management is not None:
            pulumi.set(__self__, "app_lifecycle_management", app_lifecycle_management)
        if code_repositories is not None:
            pulumi.set(__self__, "code_repositories", code_repositories)
        if default_resource_spec is not None:
            pulumi.set(__self__, "default_resource_spec", default_resource_spec)

    @property
    @pulumi.getter(name="appLifecycleManagement")
    def app_lifecycle_management(self) -> Optional['outputs.SpaceAppLifecycleManagement']:
        """
        Settings that are used to configure and manage the lifecycle of JupyterLab applications in a space.
        """
        return pulumi.get(self, "app_lifecycle_management")

    @property
    @pulumi.getter(name="codeRepositories")
    def code_repositories(self) -> Optional[Sequence['outputs.SpaceCodeRepository']]:
        """
        A list of CodeRepositories available for use with JupyterLab apps.
        """
        return pulumi.get(self, "code_repositories")

    @property
    @pulumi.getter(name="defaultResourceSpec")
    def default_resource_spec(self) -> Optional['outputs.SpaceResourceSpec']:
        """
        Specifies the ARNs of a SageMaker image and SageMaker image version, and the instance type that the version runs on.
        """
        return pulumi.get(self, "default_resource_spec")


@pulumi.output_type
class SpaceJupyterServerAppSettings(dict):
    """
    The JupyterServer app settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultResourceSpec":
            suggest = "default_resource_spec"
        elif key == "lifecycleConfigArns":
            suggest = "lifecycle_config_arns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpaceJupyterServerAppSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpaceJupyterServerAppSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpaceJupyterServerAppSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_resource_spec: Optional['outputs.SpaceResourceSpec'] = None,
                 lifecycle_config_arns: Optional[Sequence[str]] = None):
        """
        The JupyterServer app settings.
        :param 'SpaceResourceSpec' default_resource_spec: The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterServer app. If you use the `LifecycleConfigArns` parameter, then this parameter is also required.
        :param Sequence[str] lifecycle_config_arns: A list of LifecycleConfigArns available for use with JupyterServer apps.
        """
        if default_resource_spec is not None:
            pulumi.set(__self__, "default_resource_spec", default_resource_spec)
        if lifecycle_config_arns is not None:
            pulumi.set(__self__, "lifecycle_config_arns", lifecycle_config_arns)

    @property
    @pulumi.getter(name="defaultResourceSpec")
    def default_resource_spec(self) -> Optional['outputs.SpaceResourceSpec']:
        """
        The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterServer app. If you use the `LifecycleConfigArns` parameter, then this parameter is also required.
        """
        return pulumi.get(self, "default_resource_spec")

    @property
    @pulumi.getter(name="lifecycleConfigArns")
    def lifecycle_config_arns(self) -> Optional[Sequence[str]]:
        """
        A list of LifecycleConfigArns available for use with JupyterServer apps.
        """
        return pulumi.get(self, "lifecycle_config_arns")


@pulumi.output_type
class SpaceKernelGatewayAppSettings(dict):
    """
    The kernel gateway app settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customImages":
            suggest = "custom_images"
        elif key == "defaultResourceSpec":
            suggest = "default_resource_spec"
        elif key == "lifecycleConfigArns":
            suggest = "lifecycle_config_arns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpaceKernelGatewayAppSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpaceKernelGatewayAppSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpaceKernelGatewayAppSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_images: Optional[Sequence['outputs.SpaceCustomImage']] = None,
                 default_resource_spec: Optional['outputs.SpaceResourceSpec'] = None,
                 lifecycle_config_arns: Optional[Sequence[str]] = None):
        """
        The kernel gateway app settings.
        :param Sequence['SpaceCustomImage'] custom_images: A list of custom SageMaker images that are configured to run as a KernelGateway app.
        :param 'SpaceResourceSpec' default_resource_spec: The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the KernelGateway app.
        :param Sequence[str] lifecycle_config_arns: A list of LifecycleConfigArns available for use with KernelGateway apps.
        """
        if custom_images is not None:
            pulumi.set(__self__, "custom_images", custom_images)
        if default_resource_spec is not None:
            pulumi.set(__self__, "default_resource_spec", default_resource_spec)
        if lifecycle_config_arns is not None:
            pulumi.set(__self__, "lifecycle_config_arns", lifecycle_config_arns)

    @property
    @pulumi.getter(name="customImages")
    def custom_images(self) -> Optional[Sequence['outputs.SpaceCustomImage']]:
        """
        A list of custom SageMaker images that are configured to run as a KernelGateway app.
        """
        return pulumi.get(self, "custom_images")

    @property
    @pulumi.getter(name="defaultResourceSpec")
    def default_resource_spec(self) -> Optional['outputs.SpaceResourceSpec']:
        """
        The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the KernelGateway app.
        """
        return pulumi.get(self, "default_resource_spec")

    @property
    @pulumi.getter(name="lifecycleConfigArns")
    def lifecycle_config_arns(self) -> Optional[Sequence[str]]:
        """
        A list of LifecycleConfigArns available for use with KernelGateway apps.
        """
        return pulumi.get(self, "lifecycle_config_arns")


@pulumi.output_type
class SpaceOwnershipSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ownerUserProfileName":
            suggest = "owner_user_profile_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpaceOwnershipSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpaceOwnershipSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpaceOwnershipSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 owner_user_profile_name: str):
        """
        :param str owner_user_profile_name: The user profile who is the owner of the space.
        """
        pulumi.set(__self__, "owner_user_profile_name", owner_user_profile_name)

    @property
    @pulumi.getter(name="ownerUserProfileName")
    def owner_user_profile_name(self) -> str:
        """
        The user profile who is the owner of the space.
        """
        return pulumi.get(self, "owner_user_profile_name")


@pulumi.output_type
class SpaceResourceSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "lifecycleConfigArn":
            suggest = "lifecycle_config_arn"
        elif key == "sageMakerImageArn":
            suggest = "sage_maker_image_arn"
        elif key == "sageMakerImageVersionArn":
            suggest = "sage_maker_image_version_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpaceResourceSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpaceResourceSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpaceResourceSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: Optional['SpaceResourceSpecInstanceType'] = None,
                 lifecycle_config_arn: Optional[str] = None,
                 sage_maker_image_arn: Optional[str] = None,
                 sage_maker_image_version_arn: Optional[str] = None):
        """
        :param 'SpaceResourceSpecInstanceType' instance_type: The instance type that the image version runs on.
        :param str lifecycle_config_arn: The Amazon Resource Name (ARN) of the Lifecycle Configuration to attach to the Resource.
        :param str sage_maker_image_arn: The ARN of the SageMaker image that the image version belongs to.
        :param str sage_maker_image_version_arn: The ARN of the image version created on the instance.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if lifecycle_config_arn is not None:
            pulumi.set(__self__, "lifecycle_config_arn", lifecycle_config_arn)
        if sage_maker_image_arn is not None:
            pulumi.set(__self__, "sage_maker_image_arn", sage_maker_image_arn)
        if sage_maker_image_version_arn is not None:
            pulumi.set(__self__, "sage_maker_image_version_arn", sage_maker_image_version_arn)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional['SpaceResourceSpecInstanceType']:
        """
        The instance type that the image version runs on.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="lifecycleConfigArn")
    def lifecycle_config_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the Lifecycle Configuration to attach to the Resource.
        """
        return pulumi.get(self, "lifecycle_config_arn")

    @property
    @pulumi.getter(name="sageMakerImageArn")
    def sage_maker_image_arn(self) -> Optional[str]:
        """
        The ARN of the SageMaker image that the image version belongs to.
        """
        return pulumi.get(self, "sage_maker_image_arn")

    @property
    @pulumi.getter(name="sageMakerImageVersionArn")
    def sage_maker_image_version_arn(self) -> Optional[str]:
        """
        The ARN of the image version created on the instance.
        """
        return pulumi.get(self, "sage_maker_image_version_arn")


@pulumi.output_type
class SpaceSettings(dict):
    """
    A collection of settings that apply to spaces of Amazon SageMaker Studio. These settings are specified when the CreateSpace API is called.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appType":
            suggest = "app_type"
        elif key == "codeEditorAppSettings":
            suggest = "code_editor_app_settings"
        elif key == "customFileSystems":
            suggest = "custom_file_systems"
        elif key == "jupyterLabAppSettings":
            suggest = "jupyter_lab_app_settings"
        elif key == "jupyterServerAppSettings":
            suggest = "jupyter_server_app_settings"
        elif key == "kernelGatewayAppSettings":
            suggest = "kernel_gateway_app_settings"
        elif key == "spaceStorageSettings":
            suggest = "space_storage_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpaceSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpaceSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpaceSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_type: Optional['SpaceAppType'] = None,
                 code_editor_app_settings: Optional['outputs.SpaceCodeEditorAppSettings'] = None,
                 custom_file_systems: Optional[Sequence['outputs.SpaceCustomFileSystem']] = None,
                 jupyter_lab_app_settings: Optional['outputs.SpaceJupyterLabAppSettings'] = None,
                 jupyter_server_app_settings: Optional['outputs.SpaceJupyterServerAppSettings'] = None,
                 kernel_gateway_app_settings: Optional['outputs.SpaceKernelGatewayAppSettings'] = None,
                 space_storage_settings: Optional['outputs.SpaceStorageSettings'] = None):
        """
        A collection of settings that apply to spaces of Amazon SageMaker Studio. These settings are specified when the CreateSpace API is called.
        :param 'SpaceAppType' app_type: The type of app created within the space.
        :param 'SpaceCodeEditorAppSettings' code_editor_app_settings: The CodeEditor app settings.
        :param Sequence['SpaceCustomFileSystem'] custom_file_systems: A file system, created by you, that you assign to a space for an Amazon SageMaker Domain. Permitted users can access this file system in Amazon SageMaker Studio.
        :param 'SpaceJupyterLabAppSettings' jupyter_lab_app_settings: The JupyterLab app settings.
        :param 'SpaceJupyterServerAppSettings' jupyter_server_app_settings: The Jupyter server's app settings.
        :param 'SpaceKernelGatewayAppSettings' kernel_gateway_app_settings: The kernel gateway app settings.
        :param 'SpaceStorageSettings' space_storage_settings: Default storage settings for a space.
        """
        if app_type is not None:
            pulumi.set(__self__, "app_type", app_type)
        if code_editor_app_settings is not None:
            pulumi.set(__self__, "code_editor_app_settings", code_editor_app_settings)
        if custom_file_systems is not None:
            pulumi.set(__self__, "custom_file_systems", custom_file_systems)
        if jupyter_lab_app_settings is not None:
            pulumi.set(__self__, "jupyter_lab_app_settings", jupyter_lab_app_settings)
        if jupyter_server_app_settings is not None:
            pulumi.set(__self__, "jupyter_server_app_settings", jupyter_server_app_settings)
        if kernel_gateway_app_settings is not None:
            pulumi.set(__self__, "kernel_gateway_app_settings", kernel_gateway_app_settings)
        if space_storage_settings is not None:
            pulumi.set(__self__, "space_storage_settings", space_storage_settings)

    @property
    @pulumi.getter(name="appType")
    def app_type(self) -> Optional['SpaceAppType']:
        """
        The type of app created within the space.
        """
        return pulumi.get(self, "app_type")

    @property
    @pulumi.getter(name="codeEditorAppSettings")
    def code_editor_app_settings(self) -> Optional['outputs.SpaceCodeEditorAppSettings']:
        """
        The CodeEditor app settings.
        """
        return pulumi.get(self, "code_editor_app_settings")

    @property
    @pulumi.getter(name="customFileSystems")
    def custom_file_systems(self) -> Optional[Sequence['outputs.SpaceCustomFileSystem']]:
        """
        A file system, created by you, that you assign to a space for an Amazon SageMaker Domain. Permitted users can access this file system in Amazon SageMaker Studio.
        """
        return pulumi.get(self, "custom_file_systems")

    @property
    @pulumi.getter(name="jupyterLabAppSettings")
    def jupyter_lab_app_settings(self) -> Optional['outputs.SpaceJupyterLabAppSettings']:
        """
        The JupyterLab app settings.
        """
        return pulumi.get(self, "jupyter_lab_app_settings")

    @property
    @pulumi.getter(name="jupyterServerAppSettings")
    def jupyter_server_app_settings(self) -> Optional['outputs.SpaceJupyterServerAppSettings']:
        """
        The Jupyter server's app settings.
        """
        return pulumi.get(self, "jupyter_server_app_settings")

    @property
    @pulumi.getter(name="kernelGatewayAppSettings")
    def kernel_gateway_app_settings(self) -> Optional['outputs.SpaceKernelGatewayAppSettings']:
        """
        The kernel gateway app settings.
        """
        return pulumi.get(self, "kernel_gateway_app_settings")

    @property
    @pulumi.getter(name="spaceStorageSettings")
    def space_storage_settings(self) -> Optional['outputs.SpaceStorageSettings']:
        """
        Default storage settings for a space.
        """
        return pulumi.get(self, "space_storage_settings")


@pulumi.output_type
class SpaceSharingSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sharingType":
            suggest = "sharing_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpaceSharingSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpaceSharingSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpaceSharingSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sharing_type: 'SpaceSharingSettingsSharingType'):
        """
        :param 'SpaceSharingSettingsSharingType' sharing_type: Specifies the sharing type of the space.
        """
        pulumi.set(__self__, "sharing_type", sharing_type)

    @property
    @pulumi.getter(name="sharingType")
    def sharing_type(self) -> 'SpaceSharingSettingsSharingType':
        """
        Specifies the sharing type of the space.
        """
        return pulumi.get(self, "sharing_type")


@pulumi.output_type
class SpaceStorageSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ebsStorageSettings":
            suggest = "ebs_storage_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpaceStorageSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpaceStorageSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpaceStorageSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ebs_storage_settings: Optional['outputs.SpaceEbsStorageSettings'] = None):
        """
        :param 'SpaceEbsStorageSettings' ebs_storage_settings: A collection of EBS storage settings for a space.
        """
        if ebs_storage_settings is not None:
            pulumi.set(__self__, "ebs_storage_settings", ebs_storage_settings)

    @property
    @pulumi.getter(name="ebsStorageSettings")
    def ebs_storage_settings(self) -> Optional['outputs.SpaceEbsStorageSettings']:
        """
        A collection of EBS storage settings for a space.
        """
        return pulumi.get(self, "ebs_storage_settings")


@pulumi.output_type
class UserProfileAppLifecycleManagement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idleSettings":
            suggest = "idle_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProfileAppLifecycleManagement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProfileAppLifecycleManagement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProfileAppLifecycleManagement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 idle_settings: Optional['outputs.UserProfileIdleSettings'] = None):
        """
        :param 'UserProfileIdleSettings' idle_settings: Settings related to idle shutdown of Studio applications.
        """
        if idle_settings is not None:
            pulumi.set(__self__, "idle_settings", idle_settings)

    @property
    @pulumi.getter(name="idleSettings")
    def idle_settings(self) -> Optional['outputs.UserProfileIdleSettings']:
        """
        Settings related to idle shutdown of Studio applications.
        """
        return pulumi.get(self, "idle_settings")


@pulumi.output_type
class UserProfileCodeEditorAppSettings(dict):
    """
    The CodeEditor app settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appLifecycleManagement":
            suggest = "app_lifecycle_management"
        elif key == "customImages":
            suggest = "custom_images"
        elif key == "defaultResourceSpec":
            suggest = "default_resource_spec"
        elif key == "lifecycleConfigArns":
            suggest = "lifecycle_config_arns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProfileCodeEditorAppSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProfileCodeEditorAppSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProfileCodeEditorAppSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_lifecycle_management: Optional['outputs.UserProfileAppLifecycleManagement'] = None,
                 custom_images: Optional[Sequence['outputs.UserProfileCustomImage']] = None,
                 default_resource_spec: Optional['outputs.UserProfileResourceSpec'] = None,
                 lifecycle_config_arns: Optional[Sequence[str]] = None):
        """
        The CodeEditor app settings.
        :param 'UserProfileAppLifecycleManagement' app_lifecycle_management: Settings that are used to configure and manage the lifecycle of CodeEditor applications.
        :param Sequence['UserProfileCustomImage'] custom_images: A list of custom images for use for CodeEditor apps.
        :param 'UserProfileResourceSpec' default_resource_spec: The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the CodeEditor app.
        :param Sequence[str] lifecycle_config_arns: A list of LifecycleConfigArns available for use with CodeEditor apps.
        """
        if app_lifecycle_management is not None:
            pulumi.set(__self__, "app_lifecycle_management", app_lifecycle_management)
        if custom_images is not None:
            pulumi.set(__self__, "custom_images", custom_images)
        if default_resource_spec is not None:
            pulumi.set(__self__, "default_resource_spec", default_resource_spec)
        if lifecycle_config_arns is not None:
            pulumi.set(__self__, "lifecycle_config_arns", lifecycle_config_arns)

    @property
    @pulumi.getter(name="appLifecycleManagement")
    def app_lifecycle_management(self) -> Optional['outputs.UserProfileAppLifecycleManagement']:
        """
        Settings that are used to configure and manage the lifecycle of CodeEditor applications.
        """
        return pulumi.get(self, "app_lifecycle_management")

    @property
    @pulumi.getter(name="customImages")
    def custom_images(self) -> Optional[Sequence['outputs.UserProfileCustomImage']]:
        """
        A list of custom images for use for CodeEditor apps.
        """
        return pulumi.get(self, "custom_images")

    @property
    @pulumi.getter(name="defaultResourceSpec")
    def default_resource_spec(self) -> Optional['outputs.UserProfileResourceSpec']:
        """
        The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the CodeEditor app.
        """
        return pulumi.get(self, "default_resource_spec")

    @property
    @pulumi.getter(name="lifecycleConfigArns")
    def lifecycle_config_arns(self) -> Optional[Sequence[str]]:
        """
        A list of LifecycleConfigArns available for use with CodeEditor apps.
        """
        return pulumi.get(self, "lifecycle_config_arns")


@pulumi.output_type
class UserProfileCodeRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repositoryUrl":
            suggest = "repository_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProfileCodeRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProfileCodeRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProfileCodeRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repository_url: str):
        """
        :param str repository_url: A CodeRepository (valid URL) to be used within Jupyter's Git extension.
        """
        pulumi.set(__self__, "repository_url", repository_url)

    @property
    @pulumi.getter(name="repositoryUrl")
    def repository_url(self) -> str:
        """
        A CodeRepository (valid URL) to be used within Jupyter's Git extension.
        """
        return pulumi.get(self, "repository_url")


@pulumi.output_type
class UserProfileCustomFileSystemConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "efsFileSystemConfig":
            suggest = "efs_file_system_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProfileCustomFileSystemConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProfileCustomFileSystemConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProfileCustomFileSystemConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 efs_file_system_config: Optional['outputs.UserProfileEfsFileSystemConfig'] = None):
        """
        :param 'UserProfileEfsFileSystemConfig' efs_file_system_config: The settings for a custom Amazon EFS file system.
        """
        if efs_file_system_config is not None:
            pulumi.set(__self__, "efs_file_system_config", efs_file_system_config)

    @property
    @pulumi.getter(name="efsFileSystemConfig")
    def efs_file_system_config(self) -> Optional['outputs.UserProfileEfsFileSystemConfig']:
        """
        The settings for a custom Amazon EFS file system.
        """
        return pulumi.get(self, "efs_file_system_config")


@pulumi.output_type
class UserProfileCustomImage(dict):
    """
    A custom SageMaker image.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appImageConfigName":
            suggest = "app_image_config_name"
        elif key == "imageName":
            suggest = "image_name"
        elif key == "imageVersionNumber":
            suggest = "image_version_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProfileCustomImage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProfileCustomImage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProfileCustomImage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_image_config_name: str,
                 image_name: str,
                 image_version_number: Optional[int] = None):
        """
        A custom SageMaker image.
        :param str app_image_config_name: The Name of the AppImageConfig.
        :param str image_name: The name of the CustomImage. Must be unique to your account.
        :param int image_version_number: The version number of the CustomImage.
        """
        pulumi.set(__self__, "app_image_config_name", app_image_config_name)
        pulumi.set(__self__, "image_name", image_name)
        if image_version_number is not None:
            pulumi.set(__self__, "image_version_number", image_version_number)

    @property
    @pulumi.getter(name="appImageConfigName")
    def app_image_config_name(self) -> str:
        """
        The Name of the AppImageConfig.
        """
        return pulumi.get(self, "app_image_config_name")

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> str:
        """
        The name of the CustomImage. Must be unique to your account.
        """
        return pulumi.get(self, "image_name")

    @property
    @pulumi.getter(name="imageVersionNumber")
    def image_version_number(self) -> Optional[int]:
        """
        The version number of the CustomImage.
        """
        return pulumi.get(self, "image_version_number")


@pulumi.output_type
class UserProfileCustomPosixUserConfig(dict):
    def __init__(__self__, *,
                 gid: int,
                 uid: int):
        """
        :param int gid: The POSIX group ID.
        :param int uid: The POSIX user ID.
        """
        pulumi.set(__self__, "gid", gid)
        pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def gid(self) -> int:
        """
        The POSIX group ID.
        """
        return pulumi.get(self, "gid")

    @property
    @pulumi.getter
    def uid(self) -> int:
        """
        The POSIX user ID.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class UserProfileDefaultEbsStorageSettings(dict):
    """
    Properties related to the Amazon Elastic Block Store volume.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultEbsVolumeSizeInGb":
            suggest = "default_ebs_volume_size_in_gb"
        elif key == "maximumEbsVolumeSizeInGb":
            suggest = "maximum_ebs_volume_size_in_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProfileDefaultEbsStorageSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProfileDefaultEbsStorageSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProfileDefaultEbsStorageSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_ebs_volume_size_in_gb: int,
                 maximum_ebs_volume_size_in_gb: int):
        """
        Properties related to the Amazon Elastic Block Store volume.
        :param int default_ebs_volume_size_in_gb: Default size of the Amazon EBS volume in Gb
        :param int maximum_ebs_volume_size_in_gb: Maximum size of the Amazon EBS volume in Gb. Must be greater than or equal to the DefaultEbsVolumeSizeInGb.
        """
        pulumi.set(__self__, "default_ebs_volume_size_in_gb", default_ebs_volume_size_in_gb)
        pulumi.set(__self__, "maximum_ebs_volume_size_in_gb", maximum_ebs_volume_size_in_gb)

    @property
    @pulumi.getter(name="defaultEbsVolumeSizeInGb")
    def default_ebs_volume_size_in_gb(self) -> int:
        """
        Default size of the Amazon EBS volume in Gb
        """
        return pulumi.get(self, "default_ebs_volume_size_in_gb")

    @property
    @pulumi.getter(name="maximumEbsVolumeSizeInGb")
    def maximum_ebs_volume_size_in_gb(self) -> int:
        """
        Maximum size of the Amazon EBS volume in Gb. Must be greater than or equal to the DefaultEbsVolumeSizeInGb.
        """
        return pulumi.get(self, "maximum_ebs_volume_size_in_gb")


@pulumi.output_type
class UserProfileDefaultSpaceStorageSettings(dict):
    """
    Default storage settings for a space.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultEbsStorageSettings":
            suggest = "default_ebs_storage_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProfileDefaultSpaceStorageSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProfileDefaultSpaceStorageSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProfileDefaultSpaceStorageSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_ebs_storage_settings: Optional['outputs.UserProfileDefaultEbsStorageSettings'] = None):
        """
        Default storage settings for a space.
        :param 'UserProfileDefaultEbsStorageSettings' default_ebs_storage_settings: The default EBS storage settings for a space.
        """
        if default_ebs_storage_settings is not None:
            pulumi.set(__self__, "default_ebs_storage_settings", default_ebs_storage_settings)

    @property
    @pulumi.getter(name="defaultEbsStorageSettings")
    def default_ebs_storage_settings(self) -> Optional['outputs.UserProfileDefaultEbsStorageSettings']:
        """
        The default EBS storage settings for a space.
        """
        return pulumi.get(self, "default_ebs_storage_settings")


@pulumi.output_type
class UserProfileEfsFileSystemConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileSystemId":
            suggest = "file_system_id"
        elif key == "fileSystemPath":
            suggest = "file_system_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProfileEfsFileSystemConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProfileEfsFileSystemConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProfileEfsFileSystemConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_system_id: str,
                 file_system_path: Optional[str] = None):
        """
        :param str file_system_id: The ID of your Amazon EFS file system.
        :param str file_system_path: The path to the file system directory that is accessible in Amazon SageMaker Studio. Permitted users can access only this directory and below.
        """
        pulumi.set(__self__, "file_system_id", file_system_id)
        if file_system_path is not None:
            pulumi.set(__self__, "file_system_path", file_system_path)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> str:
        """
        The ID of your Amazon EFS file system.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter(name="fileSystemPath")
    def file_system_path(self) -> Optional[str]:
        """
        The path to the file system directory that is accessible in Amazon SageMaker Studio. Permitted users can access only this directory and below.
        """
        return pulumi.get(self, "file_system_path")


@pulumi.output_type
class UserProfileIdleSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idleTimeoutInMinutes":
            suggest = "idle_timeout_in_minutes"
        elif key == "lifecycleManagement":
            suggest = "lifecycle_management"
        elif key == "maxIdleTimeoutInMinutes":
            suggest = "max_idle_timeout_in_minutes"
        elif key == "minIdleTimeoutInMinutes":
            suggest = "min_idle_timeout_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProfileIdleSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProfileIdleSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProfileIdleSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 idle_timeout_in_minutes: Optional[int] = None,
                 lifecycle_management: Optional['UserProfileLifecycleManagement'] = None,
                 max_idle_timeout_in_minutes: Optional[int] = None,
                 min_idle_timeout_in_minutes: Optional[int] = None):
        """
        :param int idle_timeout_in_minutes: The time that SageMaker waits after the application becomes idle before shutting it down.
        :param 'UserProfileLifecycleManagement' lifecycle_management: Indicates whether idle shutdown is activated for the application type.
        :param int max_idle_timeout_in_minutes: The maximum value in minutes that custom idle shutdown can be set to by the user.
        :param int min_idle_timeout_in_minutes: The minimum value in minutes that custom idle shutdown can be set to by the user.
        """
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if lifecycle_management is not None:
            pulumi.set(__self__, "lifecycle_management", lifecycle_management)
        if max_idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "max_idle_timeout_in_minutes", max_idle_timeout_in_minutes)
        if min_idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "min_idle_timeout_in_minutes", min_idle_timeout_in_minutes)

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[int]:
        """
        The time that SageMaker waits after the application becomes idle before shutting it down.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @property
    @pulumi.getter(name="lifecycleManagement")
    def lifecycle_management(self) -> Optional['UserProfileLifecycleManagement']:
        """
        Indicates whether idle shutdown is activated for the application type.
        """
        return pulumi.get(self, "lifecycle_management")

    @property
    @pulumi.getter(name="maxIdleTimeoutInMinutes")
    def max_idle_timeout_in_minutes(self) -> Optional[int]:
        """
        The maximum value in minutes that custom idle shutdown can be set to by the user.
        """
        return pulumi.get(self, "max_idle_timeout_in_minutes")

    @property
    @pulumi.getter(name="minIdleTimeoutInMinutes")
    def min_idle_timeout_in_minutes(self) -> Optional[int]:
        """
        The minimum value in minutes that custom idle shutdown can be set to by the user.
        """
        return pulumi.get(self, "min_idle_timeout_in_minutes")


@pulumi.output_type
class UserProfileJupyterLabAppSettings(dict):
    """
    The JupyterLab app settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appLifecycleManagement":
            suggest = "app_lifecycle_management"
        elif key == "codeRepositories":
            suggest = "code_repositories"
        elif key == "customImages":
            suggest = "custom_images"
        elif key == "defaultResourceSpec":
            suggest = "default_resource_spec"
        elif key == "lifecycleConfigArns":
            suggest = "lifecycle_config_arns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProfileJupyterLabAppSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProfileJupyterLabAppSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProfileJupyterLabAppSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_lifecycle_management: Optional['outputs.UserProfileAppLifecycleManagement'] = None,
                 code_repositories: Optional[Sequence['outputs.UserProfileCodeRepository']] = None,
                 custom_images: Optional[Sequence['outputs.UserProfileCustomImage']] = None,
                 default_resource_spec: Optional['outputs.UserProfileResourceSpec'] = None,
                 lifecycle_config_arns: Optional[Sequence[str]] = None):
        """
        The JupyterLab app settings.
        :param 'UserProfileAppLifecycleManagement' app_lifecycle_management: Indicates whether idle shutdown is activated for JupyterLab applications.
        :param Sequence['UserProfileCodeRepository'] code_repositories: A list of CodeRepositories available for use with JupyterLab apps.
        :param Sequence['UserProfileCustomImage'] custom_images: A list of custom images available for use for JupyterLab apps
        :param 'UserProfileResourceSpec' default_resource_spec: The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterLab app.
        :param Sequence[str] lifecycle_config_arns: A list of LifecycleConfigArns available for use with JupyterLab apps.
        """
        if app_lifecycle_management is not None:
            pulumi.set(__self__, "app_lifecycle_management", app_lifecycle_management)
        if code_repositories is not None:
            pulumi.set(__self__, "code_repositories", code_repositories)
        if custom_images is not None:
            pulumi.set(__self__, "custom_images", custom_images)
        if default_resource_spec is not None:
            pulumi.set(__self__, "default_resource_spec", default_resource_spec)
        if lifecycle_config_arns is not None:
            pulumi.set(__self__, "lifecycle_config_arns", lifecycle_config_arns)

    @property
    @pulumi.getter(name="appLifecycleManagement")
    def app_lifecycle_management(self) -> Optional['outputs.UserProfileAppLifecycleManagement']:
        """
        Indicates whether idle shutdown is activated for JupyterLab applications.
        """
        return pulumi.get(self, "app_lifecycle_management")

    @property
    @pulumi.getter(name="codeRepositories")
    def code_repositories(self) -> Optional[Sequence['outputs.UserProfileCodeRepository']]:
        """
        A list of CodeRepositories available for use with JupyterLab apps.
        """
        return pulumi.get(self, "code_repositories")

    @property
    @pulumi.getter(name="customImages")
    def custom_images(self) -> Optional[Sequence['outputs.UserProfileCustomImage']]:
        """
        A list of custom images available for use for JupyterLab apps
        """
        return pulumi.get(self, "custom_images")

    @property
    @pulumi.getter(name="defaultResourceSpec")
    def default_resource_spec(self) -> Optional['outputs.UserProfileResourceSpec']:
        """
        The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterLab app.
        """
        return pulumi.get(self, "default_resource_spec")

    @property
    @pulumi.getter(name="lifecycleConfigArns")
    def lifecycle_config_arns(self) -> Optional[Sequence[str]]:
        """
        A list of LifecycleConfigArns available for use with JupyterLab apps.
        """
        return pulumi.get(self, "lifecycle_config_arns")


@pulumi.output_type
class UserProfileJupyterServerAppSettings(dict):
    """
    The JupyterServer app settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultResourceSpec":
            suggest = "default_resource_spec"
        elif key == "lifecycleConfigArns":
            suggest = "lifecycle_config_arns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProfileJupyterServerAppSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProfileJupyterServerAppSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProfileJupyterServerAppSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_resource_spec: Optional['outputs.UserProfileResourceSpec'] = None,
                 lifecycle_config_arns: Optional[Sequence[str]] = None):
        """
        The JupyterServer app settings.
        :param 'UserProfileResourceSpec' default_resource_spec: The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterServer app.
        :param Sequence[str] lifecycle_config_arns: A list of LifecycleConfigArns available for use with JupyterServer apps.
        """
        if default_resource_spec is not None:
            pulumi.set(__self__, "default_resource_spec", default_resource_spec)
        if lifecycle_config_arns is not None:
            pulumi.set(__self__, "lifecycle_config_arns", lifecycle_config_arns)

    @property
    @pulumi.getter(name="defaultResourceSpec")
    def default_resource_spec(self) -> Optional['outputs.UserProfileResourceSpec']:
        """
        The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterServer app.
        """
        return pulumi.get(self, "default_resource_spec")

    @property
    @pulumi.getter(name="lifecycleConfigArns")
    def lifecycle_config_arns(self) -> Optional[Sequence[str]]:
        """
        A list of LifecycleConfigArns available for use with JupyterServer apps.
        """
        return pulumi.get(self, "lifecycle_config_arns")


@pulumi.output_type
class UserProfileKernelGatewayAppSettings(dict):
    """
    The kernel gateway app settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customImages":
            suggest = "custom_images"
        elif key == "defaultResourceSpec":
            suggest = "default_resource_spec"
        elif key == "lifecycleConfigArns":
            suggest = "lifecycle_config_arns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProfileKernelGatewayAppSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProfileKernelGatewayAppSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProfileKernelGatewayAppSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_images: Optional[Sequence['outputs.UserProfileCustomImage']] = None,
                 default_resource_spec: Optional['outputs.UserProfileResourceSpec'] = None,
                 lifecycle_config_arns: Optional[Sequence[str]] = None):
        """
        The kernel gateway app settings.
        :param Sequence['UserProfileCustomImage'] custom_images: A list of custom SageMaker images that are configured to run as a KernelGateway app.
        :param 'UserProfileResourceSpec' default_resource_spec: The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the KernelGateway app.
        :param Sequence[str] lifecycle_config_arns: A list of LifecycleConfigArns available for use with KernelGateway apps.
        """
        if custom_images is not None:
            pulumi.set(__self__, "custom_images", custom_images)
        if default_resource_spec is not None:
            pulumi.set(__self__, "default_resource_spec", default_resource_spec)
        if lifecycle_config_arns is not None:
            pulumi.set(__self__, "lifecycle_config_arns", lifecycle_config_arns)

    @property
    @pulumi.getter(name="customImages")
    def custom_images(self) -> Optional[Sequence['outputs.UserProfileCustomImage']]:
        """
        A list of custom SageMaker images that are configured to run as a KernelGateway app.
        """
        return pulumi.get(self, "custom_images")

    @property
    @pulumi.getter(name="defaultResourceSpec")
    def default_resource_spec(self) -> Optional['outputs.UserProfileResourceSpec']:
        """
        The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the KernelGateway app.
        """
        return pulumi.get(self, "default_resource_spec")

    @property
    @pulumi.getter(name="lifecycleConfigArns")
    def lifecycle_config_arns(self) -> Optional[Sequence[str]]:
        """
        A list of LifecycleConfigArns available for use with KernelGateway apps.
        """
        return pulumi.get(self, "lifecycle_config_arns")


@pulumi.output_type
class UserProfileRStudioServerProAppSettings(dict):
    """
    A collection of settings that configure user interaction with the RStudioServerPro app.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessStatus":
            suggest = "access_status"
        elif key == "userGroup":
            suggest = "user_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProfileRStudioServerProAppSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProfileRStudioServerProAppSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProfileRStudioServerProAppSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_status: Optional['UserProfileRStudioServerProAppSettingsAccessStatus'] = None,
                 user_group: Optional['UserProfileRStudioServerProAppSettingsUserGroup'] = None):
        """
        A collection of settings that configure user interaction with the RStudioServerPro app.
        :param 'UserProfileRStudioServerProAppSettingsAccessStatus' access_status: Indicates whether the current user has access to the RStudioServerPro app.
        :param 'UserProfileRStudioServerProAppSettingsUserGroup' user_group: The level of permissions that the user has within the RStudioServerPro app. This value defaults to User. The Admin value allows the user access to the RStudio Administrative Dashboard.
        """
        if access_status is not None:
            pulumi.set(__self__, "access_status", access_status)
        if user_group is not None:
            pulumi.set(__self__, "user_group", user_group)

    @property
    @pulumi.getter(name="accessStatus")
    def access_status(self) -> Optional['UserProfileRStudioServerProAppSettingsAccessStatus']:
        """
        Indicates whether the current user has access to the RStudioServerPro app.
        """
        return pulumi.get(self, "access_status")

    @property
    @pulumi.getter(name="userGroup")
    def user_group(self) -> Optional['UserProfileRStudioServerProAppSettingsUserGroup']:
        """
        The level of permissions that the user has within the RStudioServerPro app. This value defaults to User. The Admin value allows the user access to the RStudio Administrative Dashboard.
        """
        return pulumi.get(self, "user_group")


@pulumi.output_type
class UserProfileResourceSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "lifecycleConfigArn":
            suggest = "lifecycle_config_arn"
        elif key == "sageMakerImageArn":
            suggest = "sage_maker_image_arn"
        elif key == "sageMakerImageVersionArn":
            suggest = "sage_maker_image_version_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProfileResourceSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProfileResourceSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProfileResourceSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: Optional['UserProfileResourceSpecInstanceType'] = None,
                 lifecycle_config_arn: Optional[str] = None,
                 sage_maker_image_arn: Optional[str] = None,
                 sage_maker_image_version_arn: Optional[str] = None):
        """
        :param 'UserProfileResourceSpecInstanceType' instance_type: The instance type that the image version runs on.
        :param str lifecycle_config_arn: The Amazon Resource Name (ARN) of the Lifecycle Configuration to attach to the Resource.
        :param str sage_maker_image_arn: The ARN of the SageMaker image that the image version belongs to.
        :param str sage_maker_image_version_arn: The ARN of the image version created on the instance.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if lifecycle_config_arn is not None:
            pulumi.set(__self__, "lifecycle_config_arn", lifecycle_config_arn)
        if sage_maker_image_arn is not None:
            pulumi.set(__self__, "sage_maker_image_arn", sage_maker_image_arn)
        if sage_maker_image_version_arn is not None:
            pulumi.set(__self__, "sage_maker_image_version_arn", sage_maker_image_version_arn)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional['UserProfileResourceSpecInstanceType']:
        """
        The instance type that the image version runs on.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="lifecycleConfigArn")
    def lifecycle_config_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the Lifecycle Configuration to attach to the Resource.
        """
        return pulumi.get(self, "lifecycle_config_arn")

    @property
    @pulumi.getter(name="sageMakerImageArn")
    def sage_maker_image_arn(self) -> Optional[str]:
        """
        The ARN of the SageMaker image that the image version belongs to.
        """
        return pulumi.get(self, "sage_maker_image_arn")

    @property
    @pulumi.getter(name="sageMakerImageVersionArn")
    def sage_maker_image_version_arn(self) -> Optional[str]:
        """
        The ARN of the image version created on the instance.
        """
        return pulumi.get(self, "sage_maker_image_version_arn")


@pulumi.output_type
class UserProfileSharingSettings(dict):
    """
    Specifies options when sharing an Amazon SageMaker Studio notebook. These settings are specified as part of DefaultUserSettings when the CreateDomain API is called, and as part of UserSettings when the CreateUserProfile API is called.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notebookOutputOption":
            suggest = "notebook_output_option"
        elif key == "s3KmsKeyId":
            suggest = "s3_kms_key_id"
        elif key == "s3OutputPath":
            suggest = "s3_output_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProfileSharingSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProfileSharingSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProfileSharingSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 notebook_output_option: Optional['UserProfileSharingSettingsNotebookOutputOption'] = None,
                 s3_kms_key_id: Optional[str] = None,
                 s3_output_path: Optional[str] = None):
        """
        Specifies options when sharing an Amazon SageMaker Studio notebook. These settings are specified as part of DefaultUserSettings when the CreateDomain API is called, and as part of UserSettings when the CreateUserProfile API is called.
        :param 'UserProfileSharingSettingsNotebookOutputOption' notebook_output_option: Whether to include the notebook cell output when sharing the notebook. The default is Disabled.
        :param str s3_kms_key_id: When NotebookOutputOption is Allowed, the AWS Key Management Service (KMS) encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.
        :param str s3_output_path: When NotebookOutputOption is Allowed, the Amazon S3 bucket used to store the shared notebook snapshots.
        """
        if notebook_output_option is not None:
            pulumi.set(__self__, "notebook_output_option", notebook_output_option)
        if s3_kms_key_id is not None:
            pulumi.set(__self__, "s3_kms_key_id", s3_kms_key_id)
        if s3_output_path is not None:
            pulumi.set(__self__, "s3_output_path", s3_output_path)

    @property
    @pulumi.getter(name="notebookOutputOption")
    def notebook_output_option(self) -> Optional['UserProfileSharingSettingsNotebookOutputOption']:
        """
        Whether to include the notebook cell output when sharing the notebook. The default is Disabled.
        """
        return pulumi.get(self, "notebook_output_option")

    @property
    @pulumi.getter(name="s3KmsKeyId")
    def s3_kms_key_id(self) -> Optional[str]:
        """
        When NotebookOutputOption is Allowed, the AWS Key Management Service (KMS) encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.
        """
        return pulumi.get(self, "s3_kms_key_id")

    @property
    @pulumi.getter(name="s3OutputPath")
    def s3_output_path(self) -> Optional[str]:
        """
        When NotebookOutputOption is Allowed, the Amazon S3 bucket used to store the shared notebook snapshots.
        """
        return pulumi.get(self, "s3_output_path")


@pulumi.output_type
class UserProfileStudioWebPortalSettings(dict):
    """
    Studio settings. If these settings are applied on a user level, they take priority over the settings applied on a domain level.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hiddenAppTypes":
            suggest = "hidden_app_types"
        elif key == "hiddenMlTools":
            suggest = "hidden_ml_tools"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProfileStudioWebPortalSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProfileStudioWebPortalSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProfileStudioWebPortalSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hidden_app_types: Optional[Sequence['UserProfileAppType']] = None,
                 hidden_ml_tools: Optional[Sequence['UserProfileMlTools']] = None):
        """
        Studio settings. If these settings are applied on a user level, they take priority over the settings applied on a domain level.
        :param Sequence['UserProfileAppType'] hidden_app_types: Applications supported in Studio that are hidden from the Studio left navigation pane.
        :param Sequence['UserProfileMlTools'] hidden_ml_tools: The machine learning tools that are hidden from the Studio left navigation pane.
        """
        if hidden_app_types is not None:
            pulumi.set(__self__, "hidden_app_types", hidden_app_types)
        if hidden_ml_tools is not None:
            pulumi.set(__self__, "hidden_ml_tools", hidden_ml_tools)

    @property
    @pulumi.getter(name="hiddenAppTypes")
    def hidden_app_types(self) -> Optional[Sequence['UserProfileAppType']]:
        """
        Applications supported in Studio that are hidden from the Studio left navigation pane.
        """
        return pulumi.get(self, "hidden_app_types")

    @property
    @pulumi.getter(name="hiddenMlTools")
    def hidden_ml_tools(self) -> Optional[Sequence['UserProfileMlTools']]:
        """
        The machine learning tools that are hidden from the Studio left navigation pane.
        """
        return pulumi.get(self, "hidden_ml_tools")


@pulumi.output_type
class UserProfileUserSettings(dict):
    """
    A collection of settings that apply to users of Amazon SageMaker Studio. These settings are specified when the CreateUserProfile API is called, and as DefaultUserSettings when the CreateDomain API is called.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "codeEditorAppSettings":
            suggest = "code_editor_app_settings"
        elif key == "customFileSystemConfigs":
            suggest = "custom_file_system_configs"
        elif key == "customPosixUserConfig":
            suggest = "custom_posix_user_config"
        elif key == "defaultLandingUri":
            suggest = "default_landing_uri"
        elif key == "executionRole":
            suggest = "execution_role"
        elif key == "jupyterLabAppSettings":
            suggest = "jupyter_lab_app_settings"
        elif key == "jupyterServerAppSettings":
            suggest = "jupyter_server_app_settings"
        elif key == "kernelGatewayAppSettings":
            suggest = "kernel_gateway_app_settings"
        elif key == "rStudioServerProAppSettings":
            suggest = "r_studio_server_pro_app_settings"
        elif key == "securityGroups":
            suggest = "security_groups"
        elif key == "sharingSettings":
            suggest = "sharing_settings"
        elif key == "spaceStorageSettings":
            suggest = "space_storage_settings"
        elif key == "studioWebPortal":
            suggest = "studio_web_portal"
        elif key == "studioWebPortalSettings":
            suggest = "studio_web_portal_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProfileUserSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProfileUserSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProfileUserSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code_editor_app_settings: Optional['outputs.UserProfileCodeEditorAppSettings'] = None,
                 custom_file_system_configs: Optional[Sequence['outputs.UserProfileCustomFileSystemConfig']] = None,
                 custom_posix_user_config: Optional['outputs.UserProfileCustomPosixUserConfig'] = None,
                 default_landing_uri: Optional[str] = None,
                 execution_role: Optional[str] = None,
                 jupyter_lab_app_settings: Optional['outputs.UserProfileJupyterLabAppSettings'] = None,
                 jupyter_server_app_settings: Optional['outputs.UserProfileJupyterServerAppSettings'] = None,
                 kernel_gateway_app_settings: Optional['outputs.UserProfileKernelGatewayAppSettings'] = None,
                 r_studio_server_pro_app_settings: Optional['outputs.UserProfileRStudioServerProAppSettings'] = None,
                 security_groups: Optional[Sequence[str]] = None,
                 sharing_settings: Optional['outputs.UserProfileSharingSettings'] = None,
                 space_storage_settings: Optional['outputs.UserProfileDefaultSpaceStorageSettings'] = None,
                 studio_web_portal: Optional['UserProfileUserSettingsStudioWebPortal'] = None,
                 studio_web_portal_settings: Optional['outputs.UserProfileStudioWebPortalSettings'] = None):
        """
        A collection of settings that apply to users of Amazon SageMaker Studio. These settings are specified when the CreateUserProfile API is called, and as DefaultUserSettings when the CreateDomain API is called.
        :param 'UserProfileCodeEditorAppSettings' code_editor_app_settings: The Code Editor application settings.
        :param Sequence['UserProfileCustomFileSystemConfig'] custom_file_system_configs: The settings for assigning a custom file system to a user profile. Permitted users can access this file system in Amazon SageMaker Studio.
        :param 'UserProfileCustomPosixUserConfig' custom_posix_user_config: Details about the POSIX identity that is used for file system operations.
        :param str default_landing_uri: Defines which Amazon SageMaker application users are directed to by default.
        :param str execution_role: The user profile Amazon Resource Name (ARN).
        :param 'UserProfileJupyterLabAppSettings' jupyter_lab_app_settings: The settings for the JupyterLab application.
        :param 'UserProfileJupyterServerAppSettings' jupyter_server_app_settings: The Jupyter server's app settings.
        :param 'UserProfileKernelGatewayAppSettings' kernel_gateway_app_settings: The kernel gateway app settings.
        :param 'UserProfileRStudioServerProAppSettings' r_studio_server_pro_app_settings: A collection of settings that configure user interaction with the `RStudioServerPro` app.
        :param Sequence[str] security_groups: The security groups for the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
        :param 'UserProfileSharingSettings' sharing_settings: The sharing settings.
        :param 'UserProfileDefaultSpaceStorageSettings' space_storage_settings: The storage settings for a space.
        :param 'UserProfileUserSettingsStudioWebPortal' studio_web_portal: Indicates whether the Studio experience is available to users. If not, users cannot access Studio.
        :param 'UserProfileStudioWebPortalSettings' studio_web_portal_settings: Studio settings. If these settings are applied on a user level, they take priority over the settings applied on a domain level.
        """
        if code_editor_app_settings is not None:
            pulumi.set(__self__, "code_editor_app_settings", code_editor_app_settings)
        if custom_file_system_configs is not None:
            pulumi.set(__self__, "custom_file_system_configs", custom_file_system_configs)
        if custom_posix_user_config is not None:
            pulumi.set(__self__, "custom_posix_user_config", custom_posix_user_config)
        if default_landing_uri is not None:
            pulumi.set(__self__, "default_landing_uri", default_landing_uri)
        if execution_role is not None:
            pulumi.set(__self__, "execution_role", execution_role)
        if jupyter_lab_app_settings is not None:
            pulumi.set(__self__, "jupyter_lab_app_settings", jupyter_lab_app_settings)
        if jupyter_server_app_settings is not None:
            pulumi.set(__self__, "jupyter_server_app_settings", jupyter_server_app_settings)
        if kernel_gateway_app_settings is not None:
            pulumi.set(__self__, "kernel_gateway_app_settings", kernel_gateway_app_settings)
        if r_studio_server_pro_app_settings is not None:
            pulumi.set(__self__, "r_studio_server_pro_app_settings", r_studio_server_pro_app_settings)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if sharing_settings is not None:
            pulumi.set(__self__, "sharing_settings", sharing_settings)
        if space_storage_settings is not None:
            pulumi.set(__self__, "space_storage_settings", space_storage_settings)
        if studio_web_portal is not None:
            pulumi.set(__self__, "studio_web_portal", studio_web_portal)
        if studio_web_portal_settings is not None:
            pulumi.set(__self__, "studio_web_portal_settings", studio_web_portal_settings)

    @property
    @pulumi.getter(name="codeEditorAppSettings")
    def code_editor_app_settings(self) -> Optional['outputs.UserProfileCodeEditorAppSettings']:
        """
        The Code Editor application settings.
        """
        return pulumi.get(self, "code_editor_app_settings")

    @property
    @pulumi.getter(name="customFileSystemConfigs")
    def custom_file_system_configs(self) -> Optional[Sequence['outputs.UserProfileCustomFileSystemConfig']]:
        """
        The settings for assigning a custom file system to a user profile. Permitted users can access this file system in Amazon SageMaker Studio.
        """
        return pulumi.get(self, "custom_file_system_configs")

    @property
    @pulumi.getter(name="customPosixUserConfig")
    def custom_posix_user_config(self) -> Optional['outputs.UserProfileCustomPosixUserConfig']:
        """
        Details about the POSIX identity that is used for file system operations.
        """
        return pulumi.get(self, "custom_posix_user_config")

    @property
    @pulumi.getter(name="defaultLandingUri")
    def default_landing_uri(self) -> Optional[str]:
        """
        Defines which Amazon SageMaker application users are directed to by default.
        """
        return pulumi.get(self, "default_landing_uri")

    @property
    @pulumi.getter(name="executionRole")
    def execution_role(self) -> Optional[str]:
        """
        The user profile Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "execution_role")

    @property
    @pulumi.getter(name="jupyterLabAppSettings")
    def jupyter_lab_app_settings(self) -> Optional['outputs.UserProfileJupyterLabAppSettings']:
        """
        The settings for the JupyterLab application.
        """
        return pulumi.get(self, "jupyter_lab_app_settings")

    @property
    @pulumi.getter(name="jupyterServerAppSettings")
    def jupyter_server_app_settings(self) -> Optional['outputs.UserProfileJupyterServerAppSettings']:
        """
        The Jupyter server's app settings.
        """
        return pulumi.get(self, "jupyter_server_app_settings")

    @property
    @pulumi.getter(name="kernelGatewayAppSettings")
    def kernel_gateway_app_settings(self) -> Optional['outputs.UserProfileKernelGatewayAppSettings']:
        """
        The kernel gateway app settings.
        """
        return pulumi.get(self, "kernel_gateway_app_settings")

    @property
    @pulumi.getter(name="rStudioServerProAppSettings")
    def r_studio_server_pro_app_settings(self) -> Optional['outputs.UserProfileRStudioServerProAppSettings']:
        """
        A collection of settings that configure user interaction with the `RStudioServerPro` app.
        """
        return pulumi.get(self, "r_studio_server_pro_app_settings")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[Sequence[str]]:
        """
        The security groups for the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter(name="sharingSettings")
    def sharing_settings(self) -> Optional['outputs.UserProfileSharingSettings']:
        """
        The sharing settings.
        """
        return pulumi.get(self, "sharing_settings")

    @property
    @pulumi.getter(name="spaceStorageSettings")
    def space_storage_settings(self) -> Optional['outputs.UserProfileDefaultSpaceStorageSettings']:
        """
        The storage settings for a space.
        """
        return pulumi.get(self, "space_storage_settings")

    @property
    @pulumi.getter(name="studioWebPortal")
    def studio_web_portal(self) -> Optional['UserProfileUserSettingsStudioWebPortal']:
        """
        Indicates whether the Studio experience is available to users. If not, users cannot access Studio.
        """
        return pulumi.get(self, "studio_web_portal")

    @property
    @pulumi.getter(name="studioWebPortalSettings")
    def studio_web_portal_settings(self) -> Optional['outputs.UserProfileStudioWebPortalSettings']:
        """
        Studio settings. If these settings are applied on a user level, they take priority over the settings applied on a domain level.
        """
        return pulumi.get(self, "studio_web_portal_settings")


