# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['ModelPackageArgs', 'ModelPackage']

@pulumi.input_type
class ModelPackageArgs:
    def __init__(__self__, *,
                 additional_inference_specifications: Optional[pulumi.Input[Sequence[pulumi.Input['ModelPackageAdditionalInferenceSpecificationDefinitionArgs']]]] = None,
                 additional_inference_specifications_to_add: Optional[pulumi.Input[Sequence[pulumi.Input['ModelPackageAdditionalInferenceSpecificationDefinitionArgs']]]] = None,
                 approval_description: Optional[pulumi.Input[str]] = None,
                 certify_for_marketplace: Optional[pulumi.Input[bool]] = None,
                 client_token: Optional[pulumi.Input[str]] = None,
                 customer_metadata_properties: Optional[pulumi.Input['ModelPackageCustomerMetadataPropertiesArgs']] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 drift_check_baselines: Optional[pulumi.Input['ModelPackageDriftCheckBaselinesArgs']] = None,
                 inference_specification: Optional[pulumi.Input['ModelPackageInferenceSpecificationArgs']] = None,
                 last_modified_time: Optional[pulumi.Input[str]] = None,
                 metadata_properties: Optional[pulumi.Input['ModelPackageMetadataPropertiesArgs']] = None,
                 model_approval_status: Optional[pulumi.Input['ModelPackageModelApprovalStatus']] = None,
                 model_card: Optional[pulumi.Input['ModelPackageModelCardArgs']] = None,
                 model_metrics: Optional[pulumi.Input['ModelPackageModelMetricsArgs']] = None,
                 model_package_description: Optional[pulumi.Input[str]] = None,
                 model_package_group_name: Optional[pulumi.Input[str]] = None,
                 model_package_name: Optional[pulumi.Input[str]] = None,
                 model_package_status_details: Optional[pulumi.Input['ModelPackageStatusDetailsArgs']] = None,
                 model_package_version: Optional[pulumi.Input[int]] = None,
                 sample_payload_url: Optional[pulumi.Input[str]] = None,
                 security_config: Optional[pulumi.Input['ModelPackageSecurityConfigArgs']] = None,
                 skip_model_validation: Optional[pulumi.Input['ModelPackageSkipModelValidation']] = None,
                 source_algorithm_specification: Optional[pulumi.Input['ModelPackageSourceAlgorithmSpecificationArgs']] = None,
                 source_uri: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 task: Optional[pulumi.Input[str]] = None,
                 validation_specification: Optional[pulumi.Input['ModelPackageValidationSpecificationArgs']] = None):
        """
        The set of arguments for constructing a ModelPackage resource.
        :param pulumi.Input[Sequence[pulumi.Input['ModelPackageAdditionalInferenceSpecificationDefinitionArgs']]] additional_inference_specifications: An array of additional Inference Specification objects.
        :param pulumi.Input[Sequence[pulumi.Input['ModelPackageAdditionalInferenceSpecificationDefinitionArgs']]] additional_inference_specifications_to_add: An array of additional Inference Specification objects to be added to the existing array. The total number of additional Inference Specification objects cannot exceed 15. Each additional Inference Specification object specifies artifacts based on this model package that can be used on inference endpoints. Generally used with SageMaker Neo to store the compiled artifacts.
        :param pulumi.Input[str] approval_description: A description provided when the model approval is set.
        :param pulumi.Input[bool] certify_for_marketplace: Whether the model package is to be certified to be listed on AWS Marketplace. For information about listing model packages on AWS Marketplace, see [List Your Algorithm or Model Package on AWS Marketplace](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-mkt-list.html) .
        :param pulumi.Input[str] client_token: A unique token that guarantees that the call to this API is idempotent.
        :param pulumi.Input['ModelPackageCustomerMetadataPropertiesArgs'] customer_metadata_properties: The metadata properties for the model package.
        :param pulumi.Input[str] domain: The machine learning domain of your model package and its components. Common machine learning domains include computer vision and natural language processing.
        :param pulumi.Input['ModelPackageDriftCheckBaselinesArgs'] drift_check_baselines: Represents the drift check baselines that can be used when the model monitor is set using the model package.
        :param pulumi.Input['ModelPackageInferenceSpecificationArgs'] inference_specification: Defines how to perform inference generation after a training job is run.
        :param pulumi.Input[str] last_modified_time: The last time the model package was modified.
        :param pulumi.Input['ModelPackageMetadataPropertiesArgs'] metadata_properties: Metadata properties of the tracking entity, trial, or trial component.
        :param pulumi.Input['ModelPackageModelApprovalStatus'] model_approval_status: The approval status of the model. This can be one of the following values.
               
               - `APPROVED` - The model is approved
               - `REJECTED` - The model is rejected.
               - `PENDING_MANUAL_APPROVAL` - The model is waiting for manual approval.
        :param pulumi.Input['ModelPackageModelCardArgs'] model_card: An Amazon SageMaker Model Card.
        :param pulumi.Input['ModelPackageModelMetricsArgs'] model_metrics: Metrics for the model.
        :param pulumi.Input[str] model_package_description: The description of the model package.
        :param pulumi.Input[str] model_package_group_name: The model group to which the model belongs.
        :param pulumi.Input[str] model_package_name: The name of the model.
        :param pulumi.Input['ModelPackageStatusDetailsArgs'] model_package_status_details: Specifies the validation and image scan statuses of the model package.
        :param pulumi.Input[int] model_package_version: The version number of a versioned model.
        :param pulumi.Input[str] sample_payload_url: The Amazon Simple Storage Service path where the sample payload are stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix).
        :param pulumi.Input['ModelPackageSkipModelValidation'] skip_model_validation: Indicates if you want to skip model validation.
        :param pulumi.Input['ModelPackageSourceAlgorithmSpecificationArgs'] source_algorithm_specification: A list of algorithms that were used to create a model package.
        :param pulumi.Input[str] source_uri: The URI of the source for the model package.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input[str] task: The machine learning task your model package accomplishes. Common machine learning tasks include object detection and image classification.
        :param pulumi.Input['ModelPackageValidationSpecificationArgs'] validation_specification: Specifies batch transform jobs that SageMaker runs to validate your model package.
        """
        if additional_inference_specifications is not None:
            pulumi.set(__self__, "additional_inference_specifications", additional_inference_specifications)
        if additional_inference_specifications_to_add is not None:
            pulumi.set(__self__, "additional_inference_specifications_to_add", additional_inference_specifications_to_add)
        if approval_description is not None:
            pulumi.set(__self__, "approval_description", approval_description)
        if certify_for_marketplace is not None:
            pulumi.set(__self__, "certify_for_marketplace", certify_for_marketplace)
        if client_token is not None:
            pulumi.set(__self__, "client_token", client_token)
        if customer_metadata_properties is not None:
            pulumi.set(__self__, "customer_metadata_properties", customer_metadata_properties)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if drift_check_baselines is not None:
            pulumi.set(__self__, "drift_check_baselines", drift_check_baselines)
        if inference_specification is not None:
            pulumi.set(__self__, "inference_specification", inference_specification)
        if last_modified_time is not None:
            pulumi.set(__self__, "last_modified_time", last_modified_time)
        if metadata_properties is not None:
            pulumi.set(__self__, "metadata_properties", metadata_properties)
        if model_approval_status is not None:
            pulumi.set(__self__, "model_approval_status", model_approval_status)
        if model_card is not None:
            pulumi.set(__self__, "model_card", model_card)
        if model_metrics is not None:
            pulumi.set(__self__, "model_metrics", model_metrics)
        if model_package_description is not None:
            pulumi.set(__self__, "model_package_description", model_package_description)
        if model_package_group_name is not None:
            pulumi.set(__self__, "model_package_group_name", model_package_group_name)
        if model_package_name is not None:
            pulumi.set(__self__, "model_package_name", model_package_name)
        if model_package_status_details is not None:
            pulumi.set(__self__, "model_package_status_details", model_package_status_details)
        if model_package_version is not None:
            pulumi.set(__self__, "model_package_version", model_package_version)
        if sample_payload_url is not None:
            pulumi.set(__self__, "sample_payload_url", sample_payload_url)
        if security_config is not None:
            pulumi.set(__self__, "security_config", security_config)
        if skip_model_validation is not None:
            pulumi.set(__self__, "skip_model_validation", skip_model_validation)
        if source_algorithm_specification is not None:
            pulumi.set(__self__, "source_algorithm_specification", source_algorithm_specification)
        if source_uri is not None:
            pulumi.set(__self__, "source_uri", source_uri)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if task is not None:
            pulumi.set(__self__, "task", task)
        if validation_specification is not None:
            pulumi.set(__self__, "validation_specification", validation_specification)

    @property
    @pulumi.getter(name="additionalInferenceSpecifications")
    def additional_inference_specifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelPackageAdditionalInferenceSpecificationDefinitionArgs']]]]:
        """
        An array of additional Inference Specification objects.
        """
        return pulumi.get(self, "additional_inference_specifications")

    @additional_inference_specifications.setter
    def additional_inference_specifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelPackageAdditionalInferenceSpecificationDefinitionArgs']]]]):
        pulumi.set(self, "additional_inference_specifications", value)

    @property
    @pulumi.getter(name="additionalInferenceSpecificationsToAdd")
    def additional_inference_specifications_to_add(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelPackageAdditionalInferenceSpecificationDefinitionArgs']]]]:
        """
        An array of additional Inference Specification objects to be added to the existing array. The total number of additional Inference Specification objects cannot exceed 15. Each additional Inference Specification object specifies artifacts based on this model package that can be used on inference endpoints. Generally used with SageMaker Neo to store the compiled artifacts.
        """
        return pulumi.get(self, "additional_inference_specifications_to_add")

    @additional_inference_specifications_to_add.setter
    def additional_inference_specifications_to_add(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelPackageAdditionalInferenceSpecificationDefinitionArgs']]]]):
        pulumi.set(self, "additional_inference_specifications_to_add", value)

    @property
    @pulumi.getter(name="approvalDescription")
    def approval_description(self) -> Optional[pulumi.Input[str]]:
        """
        A description provided when the model approval is set.
        """
        return pulumi.get(self, "approval_description")

    @approval_description.setter
    def approval_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "approval_description", value)

    @property
    @pulumi.getter(name="certifyForMarketplace")
    def certify_for_marketplace(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the model package is to be certified to be listed on AWS Marketplace. For information about listing model packages on AWS Marketplace, see [List Your Algorithm or Model Package on AWS Marketplace](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-mkt-list.html) .
        """
        return pulumi.get(self, "certify_for_marketplace")

    @certify_for_marketplace.setter
    def certify_for_marketplace(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "certify_for_marketplace", value)

    @property
    @pulumi.getter(name="clientToken")
    def client_token(self) -> Optional[pulumi.Input[str]]:
        """
        A unique token that guarantees that the call to this API is idempotent.
        """
        return pulumi.get(self, "client_token")

    @client_token.setter
    def client_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_token", value)

    @property
    @pulumi.getter(name="customerMetadataProperties")
    def customer_metadata_properties(self) -> Optional[pulumi.Input['ModelPackageCustomerMetadataPropertiesArgs']]:
        """
        The metadata properties for the model package.
        """
        return pulumi.get(self, "customer_metadata_properties")

    @customer_metadata_properties.setter
    def customer_metadata_properties(self, value: Optional[pulumi.Input['ModelPackageCustomerMetadataPropertiesArgs']]):
        pulumi.set(self, "customer_metadata_properties", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The machine learning domain of your model package and its components. Common machine learning domains include computer vision and natural language processing.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="driftCheckBaselines")
    def drift_check_baselines(self) -> Optional[pulumi.Input['ModelPackageDriftCheckBaselinesArgs']]:
        """
        Represents the drift check baselines that can be used when the model monitor is set using the model package.
        """
        return pulumi.get(self, "drift_check_baselines")

    @drift_check_baselines.setter
    def drift_check_baselines(self, value: Optional[pulumi.Input['ModelPackageDriftCheckBaselinesArgs']]):
        pulumi.set(self, "drift_check_baselines", value)

    @property
    @pulumi.getter(name="inferenceSpecification")
    def inference_specification(self) -> Optional[pulumi.Input['ModelPackageInferenceSpecificationArgs']]:
        """
        Defines how to perform inference generation after a training job is run.
        """
        return pulumi.get(self, "inference_specification")

    @inference_specification.setter
    def inference_specification(self, value: Optional[pulumi.Input['ModelPackageInferenceSpecificationArgs']]):
        pulumi.set(self, "inference_specification", value)

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[pulumi.Input[str]]:
        """
        The last time the model package was modified.
        """
        return pulumi.get(self, "last_modified_time")

    @last_modified_time.setter
    def last_modified_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_modified_time", value)

    @property
    @pulumi.getter(name="metadataProperties")
    def metadata_properties(self) -> Optional[pulumi.Input['ModelPackageMetadataPropertiesArgs']]:
        """
        Metadata properties of the tracking entity, trial, or trial component.
        """
        return pulumi.get(self, "metadata_properties")

    @metadata_properties.setter
    def metadata_properties(self, value: Optional[pulumi.Input['ModelPackageMetadataPropertiesArgs']]):
        pulumi.set(self, "metadata_properties", value)

    @property
    @pulumi.getter(name="modelApprovalStatus")
    def model_approval_status(self) -> Optional[pulumi.Input['ModelPackageModelApprovalStatus']]:
        """
        The approval status of the model. This can be one of the following values.

        - `APPROVED` - The model is approved
        - `REJECTED` - The model is rejected.
        - `PENDING_MANUAL_APPROVAL` - The model is waiting for manual approval.
        """
        return pulumi.get(self, "model_approval_status")

    @model_approval_status.setter
    def model_approval_status(self, value: Optional[pulumi.Input['ModelPackageModelApprovalStatus']]):
        pulumi.set(self, "model_approval_status", value)

    @property
    @pulumi.getter(name="modelCard")
    def model_card(self) -> Optional[pulumi.Input['ModelPackageModelCardArgs']]:
        """
        An Amazon SageMaker Model Card.
        """
        return pulumi.get(self, "model_card")

    @model_card.setter
    def model_card(self, value: Optional[pulumi.Input['ModelPackageModelCardArgs']]):
        pulumi.set(self, "model_card", value)

    @property
    @pulumi.getter(name="modelMetrics")
    def model_metrics(self) -> Optional[pulumi.Input['ModelPackageModelMetricsArgs']]:
        """
        Metrics for the model.
        """
        return pulumi.get(self, "model_metrics")

    @model_metrics.setter
    def model_metrics(self, value: Optional[pulumi.Input['ModelPackageModelMetricsArgs']]):
        pulumi.set(self, "model_metrics", value)

    @property
    @pulumi.getter(name="modelPackageDescription")
    def model_package_description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the model package.
        """
        return pulumi.get(self, "model_package_description")

    @model_package_description.setter
    def model_package_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_package_description", value)

    @property
    @pulumi.getter(name="modelPackageGroupName")
    def model_package_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The model group to which the model belongs.
        """
        return pulumi.get(self, "model_package_group_name")

    @model_package_group_name.setter
    def model_package_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_package_group_name", value)

    @property
    @pulumi.getter(name="modelPackageName")
    def model_package_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the model.
        """
        return pulumi.get(self, "model_package_name")

    @model_package_name.setter
    def model_package_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_package_name", value)

    @property
    @pulumi.getter(name="modelPackageStatusDetails")
    def model_package_status_details(self) -> Optional[pulumi.Input['ModelPackageStatusDetailsArgs']]:
        """
        Specifies the validation and image scan statuses of the model package.
        """
        return pulumi.get(self, "model_package_status_details")

    @model_package_status_details.setter
    def model_package_status_details(self, value: Optional[pulumi.Input['ModelPackageStatusDetailsArgs']]):
        pulumi.set(self, "model_package_status_details", value)

    @property
    @pulumi.getter(name="modelPackageVersion")
    def model_package_version(self) -> Optional[pulumi.Input[int]]:
        """
        The version number of a versioned model.
        """
        return pulumi.get(self, "model_package_version")

    @model_package_version.setter
    def model_package_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "model_package_version", value)

    @property
    @pulumi.getter(name="samplePayloadUrl")
    def sample_payload_url(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Simple Storage Service path where the sample payload are stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix).
        """
        return pulumi.get(self, "sample_payload_url")

    @sample_payload_url.setter
    def sample_payload_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sample_payload_url", value)

    @property
    @pulumi.getter(name="securityConfig")
    def security_config(self) -> Optional[pulumi.Input['ModelPackageSecurityConfigArgs']]:
        return pulumi.get(self, "security_config")

    @security_config.setter
    def security_config(self, value: Optional[pulumi.Input['ModelPackageSecurityConfigArgs']]):
        pulumi.set(self, "security_config", value)

    @property
    @pulumi.getter(name="skipModelValidation")
    def skip_model_validation(self) -> Optional[pulumi.Input['ModelPackageSkipModelValidation']]:
        """
        Indicates if you want to skip model validation.
        """
        return pulumi.get(self, "skip_model_validation")

    @skip_model_validation.setter
    def skip_model_validation(self, value: Optional[pulumi.Input['ModelPackageSkipModelValidation']]):
        pulumi.set(self, "skip_model_validation", value)

    @property
    @pulumi.getter(name="sourceAlgorithmSpecification")
    def source_algorithm_specification(self) -> Optional[pulumi.Input['ModelPackageSourceAlgorithmSpecificationArgs']]:
        """
        A list of algorithms that were used to create a model package.
        """
        return pulumi.get(self, "source_algorithm_specification")

    @source_algorithm_specification.setter
    def source_algorithm_specification(self, value: Optional[pulumi.Input['ModelPackageSourceAlgorithmSpecificationArgs']]):
        pulumi.set(self, "source_algorithm_specification", value)

    @property
    @pulumi.getter(name="sourceUri")
    def source_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the source for the model package.
        """
        return pulumi.get(self, "source_uri")

    @source_uri.setter
    def source_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_uri", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def task(self) -> Optional[pulumi.Input[str]]:
        """
        The machine learning task your model package accomplishes. Common machine learning tasks include object detection and image classification.
        """
        return pulumi.get(self, "task")

    @task.setter
    def task(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "task", value)

    @property
    @pulumi.getter(name="validationSpecification")
    def validation_specification(self) -> Optional[pulumi.Input['ModelPackageValidationSpecificationArgs']]:
        """
        Specifies batch transform jobs that SageMaker runs to validate your model package.
        """
        return pulumi.get(self, "validation_specification")

    @validation_specification.setter
    def validation_specification(self, value: Optional[pulumi.Input['ModelPackageValidationSpecificationArgs']]):
        pulumi.set(self, "validation_specification", value)


class ModelPackage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_inference_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ModelPackageAdditionalInferenceSpecificationDefinitionArgs', 'ModelPackageAdditionalInferenceSpecificationDefinitionArgsDict']]]]] = None,
                 additional_inference_specifications_to_add: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ModelPackageAdditionalInferenceSpecificationDefinitionArgs', 'ModelPackageAdditionalInferenceSpecificationDefinitionArgsDict']]]]] = None,
                 approval_description: Optional[pulumi.Input[str]] = None,
                 certify_for_marketplace: Optional[pulumi.Input[bool]] = None,
                 client_token: Optional[pulumi.Input[str]] = None,
                 customer_metadata_properties: Optional[pulumi.Input[Union['ModelPackageCustomerMetadataPropertiesArgs', 'ModelPackageCustomerMetadataPropertiesArgsDict']]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 drift_check_baselines: Optional[pulumi.Input[Union['ModelPackageDriftCheckBaselinesArgs', 'ModelPackageDriftCheckBaselinesArgsDict']]] = None,
                 inference_specification: Optional[pulumi.Input[Union['ModelPackageInferenceSpecificationArgs', 'ModelPackageInferenceSpecificationArgsDict']]] = None,
                 last_modified_time: Optional[pulumi.Input[str]] = None,
                 metadata_properties: Optional[pulumi.Input[Union['ModelPackageMetadataPropertiesArgs', 'ModelPackageMetadataPropertiesArgsDict']]] = None,
                 model_approval_status: Optional[pulumi.Input['ModelPackageModelApprovalStatus']] = None,
                 model_card: Optional[pulumi.Input[Union['ModelPackageModelCardArgs', 'ModelPackageModelCardArgsDict']]] = None,
                 model_metrics: Optional[pulumi.Input[Union['ModelPackageModelMetricsArgs', 'ModelPackageModelMetricsArgsDict']]] = None,
                 model_package_description: Optional[pulumi.Input[str]] = None,
                 model_package_group_name: Optional[pulumi.Input[str]] = None,
                 model_package_name: Optional[pulumi.Input[str]] = None,
                 model_package_status_details: Optional[pulumi.Input[Union['ModelPackageStatusDetailsArgs', 'ModelPackageStatusDetailsArgsDict']]] = None,
                 model_package_version: Optional[pulumi.Input[int]] = None,
                 sample_payload_url: Optional[pulumi.Input[str]] = None,
                 security_config: Optional[pulumi.Input[Union['ModelPackageSecurityConfigArgs', 'ModelPackageSecurityConfigArgsDict']]] = None,
                 skip_model_validation: Optional[pulumi.Input['ModelPackageSkipModelValidation']] = None,
                 source_algorithm_specification: Optional[pulumi.Input[Union['ModelPackageSourceAlgorithmSpecificationArgs', 'ModelPackageSourceAlgorithmSpecificationArgsDict']]] = None,
                 source_uri: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 task: Optional[pulumi.Input[str]] = None,
                 validation_specification: Optional[pulumi.Input[Union['ModelPackageValidationSpecificationArgs', 'ModelPackageValidationSpecificationArgsDict']]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::SageMaker::ModelPackage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ModelPackageAdditionalInferenceSpecificationDefinitionArgs', 'ModelPackageAdditionalInferenceSpecificationDefinitionArgsDict']]]] additional_inference_specifications: An array of additional Inference Specification objects.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ModelPackageAdditionalInferenceSpecificationDefinitionArgs', 'ModelPackageAdditionalInferenceSpecificationDefinitionArgsDict']]]] additional_inference_specifications_to_add: An array of additional Inference Specification objects to be added to the existing array. The total number of additional Inference Specification objects cannot exceed 15. Each additional Inference Specification object specifies artifacts based on this model package that can be used on inference endpoints. Generally used with SageMaker Neo to store the compiled artifacts.
        :param pulumi.Input[str] approval_description: A description provided when the model approval is set.
        :param pulumi.Input[bool] certify_for_marketplace: Whether the model package is to be certified to be listed on AWS Marketplace. For information about listing model packages on AWS Marketplace, see [List Your Algorithm or Model Package on AWS Marketplace](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-mkt-list.html) .
        :param pulumi.Input[str] client_token: A unique token that guarantees that the call to this API is idempotent.
        :param pulumi.Input[Union['ModelPackageCustomerMetadataPropertiesArgs', 'ModelPackageCustomerMetadataPropertiesArgsDict']] customer_metadata_properties: The metadata properties for the model package.
        :param pulumi.Input[str] domain: The machine learning domain of your model package and its components. Common machine learning domains include computer vision and natural language processing.
        :param pulumi.Input[Union['ModelPackageDriftCheckBaselinesArgs', 'ModelPackageDriftCheckBaselinesArgsDict']] drift_check_baselines: Represents the drift check baselines that can be used when the model monitor is set using the model package.
        :param pulumi.Input[Union['ModelPackageInferenceSpecificationArgs', 'ModelPackageInferenceSpecificationArgsDict']] inference_specification: Defines how to perform inference generation after a training job is run.
        :param pulumi.Input[str] last_modified_time: The last time the model package was modified.
        :param pulumi.Input[Union['ModelPackageMetadataPropertiesArgs', 'ModelPackageMetadataPropertiesArgsDict']] metadata_properties: Metadata properties of the tracking entity, trial, or trial component.
        :param pulumi.Input['ModelPackageModelApprovalStatus'] model_approval_status: The approval status of the model. This can be one of the following values.
               
               - `APPROVED` - The model is approved
               - `REJECTED` - The model is rejected.
               - `PENDING_MANUAL_APPROVAL` - The model is waiting for manual approval.
        :param pulumi.Input[Union['ModelPackageModelCardArgs', 'ModelPackageModelCardArgsDict']] model_card: An Amazon SageMaker Model Card.
        :param pulumi.Input[Union['ModelPackageModelMetricsArgs', 'ModelPackageModelMetricsArgsDict']] model_metrics: Metrics for the model.
        :param pulumi.Input[str] model_package_description: The description of the model package.
        :param pulumi.Input[str] model_package_group_name: The model group to which the model belongs.
        :param pulumi.Input[str] model_package_name: The name of the model.
        :param pulumi.Input[Union['ModelPackageStatusDetailsArgs', 'ModelPackageStatusDetailsArgsDict']] model_package_status_details: Specifies the validation and image scan statuses of the model package.
        :param pulumi.Input[int] model_package_version: The version number of a versioned model.
        :param pulumi.Input[str] sample_payload_url: The Amazon Simple Storage Service path where the sample payload are stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix).
        :param pulumi.Input['ModelPackageSkipModelValidation'] skip_model_validation: Indicates if you want to skip model validation.
        :param pulumi.Input[Union['ModelPackageSourceAlgorithmSpecificationArgs', 'ModelPackageSourceAlgorithmSpecificationArgsDict']] source_algorithm_specification: A list of algorithms that were used to create a model package.
        :param pulumi.Input[str] source_uri: The URI of the source for the model package.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input[str] task: The machine learning task your model package accomplishes. Common machine learning tasks include object detection and image classification.
        :param pulumi.Input[Union['ModelPackageValidationSpecificationArgs', 'ModelPackageValidationSpecificationArgsDict']] validation_specification: Specifies batch transform jobs that SageMaker runs to validate your model package.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ModelPackageArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::SageMaker::ModelPackage

        :param str resource_name: The name of the resource.
        :param ModelPackageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ModelPackageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_inference_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ModelPackageAdditionalInferenceSpecificationDefinitionArgs', 'ModelPackageAdditionalInferenceSpecificationDefinitionArgsDict']]]]] = None,
                 additional_inference_specifications_to_add: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ModelPackageAdditionalInferenceSpecificationDefinitionArgs', 'ModelPackageAdditionalInferenceSpecificationDefinitionArgsDict']]]]] = None,
                 approval_description: Optional[pulumi.Input[str]] = None,
                 certify_for_marketplace: Optional[pulumi.Input[bool]] = None,
                 client_token: Optional[pulumi.Input[str]] = None,
                 customer_metadata_properties: Optional[pulumi.Input[Union['ModelPackageCustomerMetadataPropertiesArgs', 'ModelPackageCustomerMetadataPropertiesArgsDict']]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 drift_check_baselines: Optional[pulumi.Input[Union['ModelPackageDriftCheckBaselinesArgs', 'ModelPackageDriftCheckBaselinesArgsDict']]] = None,
                 inference_specification: Optional[pulumi.Input[Union['ModelPackageInferenceSpecificationArgs', 'ModelPackageInferenceSpecificationArgsDict']]] = None,
                 last_modified_time: Optional[pulumi.Input[str]] = None,
                 metadata_properties: Optional[pulumi.Input[Union['ModelPackageMetadataPropertiesArgs', 'ModelPackageMetadataPropertiesArgsDict']]] = None,
                 model_approval_status: Optional[pulumi.Input['ModelPackageModelApprovalStatus']] = None,
                 model_card: Optional[pulumi.Input[Union['ModelPackageModelCardArgs', 'ModelPackageModelCardArgsDict']]] = None,
                 model_metrics: Optional[pulumi.Input[Union['ModelPackageModelMetricsArgs', 'ModelPackageModelMetricsArgsDict']]] = None,
                 model_package_description: Optional[pulumi.Input[str]] = None,
                 model_package_group_name: Optional[pulumi.Input[str]] = None,
                 model_package_name: Optional[pulumi.Input[str]] = None,
                 model_package_status_details: Optional[pulumi.Input[Union['ModelPackageStatusDetailsArgs', 'ModelPackageStatusDetailsArgsDict']]] = None,
                 model_package_version: Optional[pulumi.Input[int]] = None,
                 sample_payload_url: Optional[pulumi.Input[str]] = None,
                 security_config: Optional[pulumi.Input[Union['ModelPackageSecurityConfigArgs', 'ModelPackageSecurityConfigArgsDict']]] = None,
                 skip_model_validation: Optional[pulumi.Input['ModelPackageSkipModelValidation']] = None,
                 source_algorithm_specification: Optional[pulumi.Input[Union['ModelPackageSourceAlgorithmSpecificationArgs', 'ModelPackageSourceAlgorithmSpecificationArgsDict']]] = None,
                 source_uri: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 task: Optional[pulumi.Input[str]] = None,
                 validation_specification: Optional[pulumi.Input[Union['ModelPackageValidationSpecificationArgs', 'ModelPackageValidationSpecificationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ModelPackageArgs.__new__(ModelPackageArgs)

            __props__.__dict__["additional_inference_specifications"] = additional_inference_specifications
            __props__.__dict__["additional_inference_specifications_to_add"] = additional_inference_specifications_to_add
            __props__.__dict__["approval_description"] = approval_description
            __props__.__dict__["certify_for_marketplace"] = certify_for_marketplace
            __props__.__dict__["client_token"] = client_token
            __props__.__dict__["customer_metadata_properties"] = customer_metadata_properties
            __props__.__dict__["domain"] = domain
            __props__.__dict__["drift_check_baselines"] = drift_check_baselines
            __props__.__dict__["inference_specification"] = inference_specification
            __props__.__dict__["last_modified_time"] = last_modified_time
            __props__.__dict__["metadata_properties"] = metadata_properties
            __props__.__dict__["model_approval_status"] = model_approval_status
            __props__.__dict__["model_card"] = model_card
            __props__.__dict__["model_metrics"] = model_metrics
            __props__.__dict__["model_package_description"] = model_package_description
            __props__.__dict__["model_package_group_name"] = model_package_group_name
            __props__.__dict__["model_package_name"] = model_package_name
            __props__.__dict__["model_package_status_details"] = model_package_status_details
            __props__.__dict__["model_package_version"] = model_package_version
            __props__.__dict__["sample_payload_url"] = sample_payload_url
            __props__.__dict__["security_config"] = security_config
            __props__.__dict__["skip_model_validation"] = skip_model_validation
            __props__.__dict__["source_algorithm_specification"] = source_algorithm_specification
            __props__.__dict__["source_uri"] = source_uri
            __props__.__dict__["tags"] = tags
            __props__.__dict__["task"] = task
            __props__.__dict__["validation_specification"] = validation_specification
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["model_package_arn"] = None
            __props__.__dict__["model_package_status"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["clientToken", "domain", "driftCheckBaselines", "inferenceSpecification", "metadataProperties", "modelMetrics", "modelPackageDescription", "modelPackageGroupName", "samplePayloadUrl", "securityConfig", "sourceAlgorithmSpecification", "task", "validationSpecification"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ModelPackage, __self__).__init__(
            'aws-native:sagemaker:ModelPackage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ModelPackage':
        """
        Get an existing ModelPackage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ModelPackageArgs.__new__(ModelPackageArgs)

        __props__.__dict__["additional_inference_specifications"] = None
        __props__.__dict__["additional_inference_specifications_to_add"] = None
        __props__.__dict__["approval_description"] = None
        __props__.__dict__["certify_for_marketplace"] = None
        __props__.__dict__["client_token"] = None
        __props__.__dict__["creation_time"] = None
        __props__.__dict__["customer_metadata_properties"] = None
        __props__.__dict__["domain"] = None
        __props__.__dict__["drift_check_baselines"] = None
        __props__.__dict__["inference_specification"] = None
        __props__.__dict__["last_modified_time"] = None
        __props__.__dict__["metadata_properties"] = None
        __props__.__dict__["model_approval_status"] = None
        __props__.__dict__["model_card"] = None
        __props__.__dict__["model_metrics"] = None
        __props__.__dict__["model_package_arn"] = None
        __props__.__dict__["model_package_description"] = None
        __props__.__dict__["model_package_group_name"] = None
        __props__.__dict__["model_package_name"] = None
        __props__.__dict__["model_package_status"] = None
        __props__.__dict__["model_package_status_details"] = None
        __props__.__dict__["model_package_version"] = None
        __props__.__dict__["sample_payload_url"] = None
        __props__.__dict__["security_config"] = None
        __props__.__dict__["skip_model_validation"] = None
        __props__.__dict__["source_algorithm_specification"] = None
        __props__.__dict__["source_uri"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["task"] = None
        __props__.__dict__["validation_specification"] = None
        return ModelPackage(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalInferenceSpecifications")
    def additional_inference_specifications(self) -> pulumi.Output[Optional[Sequence['outputs.ModelPackageAdditionalInferenceSpecificationDefinition']]]:
        """
        An array of additional Inference Specification objects.
        """
        return pulumi.get(self, "additional_inference_specifications")

    @property
    @pulumi.getter(name="additionalInferenceSpecificationsToAdd")
    def additional_inference_specifications_to_add(self) -> pulumi.Output[Optional[Sequence['outputs.ModelPackageAdditionalInferenceSpecificationDefinition']]]:
        """
        An array of additional Inference Specification objects to be added to the existing array. The total number of additional Inference Specification objects cannot exceed 15. Each additional Inference Specification object specifies artifacts based on this model package that can be used on inference endpoints. Generally used with SageMaker Neo to store the compiled artifacts.
        """
        return pulumi.get(self, "additional_inference_specifications_to_add")

    @property
    @pulumi.getter(name="approvalDescription")
    def approval_description(self) -> pulumi.Output[Optional[str]]:
        """
        A description provided when the model approval is set.
        """
        return pulumi.get(self, "approval_description")

    @property
    @pulumi.getter(name="certifyForMarketplace")
    def certify_for_marketplace(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the model package is to be certified to be listed on AWS Marketplace. For information about listing model packages on AWS Marketplace, see [List Your Algorithm or Model Package on AWS Marketplace](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-mkt-list.html) .
        """
        return pulumi.get(self, "certify_for_marketplace")

    @property
    @pulumi.getter(name="clientToken")
    def client_token(self) -> pulumi.Output[Optional[str]]:
        """
        A unique token that guarantees that the call to this API is idempotent.
        """
        return pulumi.get(self, "client_token")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[str]:
        """
        The time that the model package was created.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="customerMetadataProperties")
    def customer_metadata_properties(self) -> pulumi.Output[Optional['outputs.ModelPackageCustomerMetadataProperties']]:
        """
        The metadata properties for the model package.
        """
        return pulumi.get(self, "customer_metadata_properties")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[Optional[str]]:
        """
        The machine learning domain of your model package and its components. Common machine learning domains include computer vision and natural language processing.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="driftCheckBaselines")
    def drift_check_baselines(self) -> pulumi.Output[Optional['outputs.ModelPackageDriftCheckBaselines']]:
        """
        Represents the drift check baselines that can be used when the model monitor is set using the model package.
        """
        return pulumi.get(self, "drift_check_baselines")

    @property
    @pulumi.getter(name="inferenceSpecification")
    def inference_specification(self) -> pulumi.Output[Optional['outputs.ModelPackageInferenceSpecification']]:
        """
        Defines how to perform inference generation after a training job is run.
        """
        return pulumi.get(self, "inference_specification")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> pulumi.Output[Optional[str]]:
        """
        The last time the model package was modified.
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter(name="metadataProperties")
    def metadata_properties(self) -> pulumi.Output[Optional['outputs.ModelPackageMetadataProperties']]:
        """
        Metadata properties of the tracking entity, trial, or trial component.
        """
        return pulumi.get(self, "metadata_properties")

    @property
    @pulumi.getter(name="modelApprovalStatus")
    def model_approval_status(self) -> pulumi.Output[Optional['ModelPackageModelApprovalStatus']]:
        """
        The approval status of the model. This can be one of the following values.

        - `APPROVED` - The model is approved
        - `REJECTED` - The model is rejected.
        - `PENDING_MANUAL_APPROVAL` - The model is waiting for manual approval.
        """
        return pulumi.get(self, "model_approval_status")

    @property
    @pulumi.getter(name="modelCard")
    def model_card(self) -> pulumi.Output[Optional['outputs.ModelPackageModelCard']]:
        """
        An Amazon SageMaker Model Card.
        """
        return pulumi.get(self, "model_card")

    @property
    @pulumi.getter(name="modelMetrics")
    def model_metrics(self) -> pulumi.Output[Optional['outputs.ModelPackageModelMetrics']]:
        """
        Metrics for the model.
        """
        return pulumi.get(self, "model_metrics")

    @property
    @pulumi.getter(name="modelPackageArn")
    def model_package_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the model package.
        """
        return pulumi.get(self, "model_package_arn")

    @property
    @pulumi.getter(name="modelPackageDescription")
    def model_package_description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the model package.
        """
        return pulumi.get(self, "model_package_description")

    @property
    @pulumi.getter(name="modelPackageGroupName")
    def model_package_group_name(self) -> pulumi.Output[Optional[str]]:
        """
        The model group to which the model belongs.
        """
        return pulumi.get(self, "model_package_group_name")

    @property
    @pulumi.getter(name="modelPackageName")
    def model_package_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the model.
        """
        return pulumi.get(self, "model_package_name")

    @property
    @pulumi.getter(name="modelPackageStatus")
    def model_package_status(self) -> pulumi.Output['ModelPackageStatus']:
        """
        The status of the model package. This can be one of the following values.

        - `PENDING` - The model package creation is pending.
        - `IN_PROGRESS` - The model package is in the process of being created.
        - `COMPLETED` - The model package was successfully created.
        - `FAILED` - The model package creation failed.
        - `DELETING` - The model package is in the process of being deleted.
        """
        return pulumi.get(self, "model_package_status")

    @property
    @pulumi.getter(name="modelPackageStatusDetails")
    def model_package_status_details(self) -> pulumi.Output[Optional['outputs.ModelPackageStatusDetails']]:
        """
        Specifies the validation and image scan statuses of the model package.
        """
        return pulumi.get(self, "model_package_status_details")

    @property
    @pulumi.getter(name="modelPackageVersion")
    def model_package_version(self) -> pulumi.Output[Optional[int]]:
        """
        The version number of a versioned model.
        """
        return pulumi.get(self, "model_package_version")

    @property
    @pulumi.getter(name="samplePayloadUrl")
    def sample_payload_url(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon Simple Storage Service path where the sample payload are stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix).
        """
        return pulumi.get(self, "sample_payload_url")

    @property
    @pulumi.getter(name="securityConfig")
    def security_config(self) -> pulumi.Output[Optional['outputs.ModelPackageSecurityConfig']]:
        return pulumi.get(self, "security_config")

    @property
    @pulumi.getter(name="skipModelValidation")
    def skip_model_validation(self) -> pulumi.Output[Optional['ModelPackageSkipModelValidation']]:
        """
        Indicates if you want to skip model validation.
        """
        return pulumi.get(self, "skip_model_validation")

    @property
    @pulumi.getter(name="sourceAlgorithmSpecification")
    def source_algorithm_specification(self) -> pulumi.Output[Optional['outputs.ModelPackageSourceAlgorithmSpecification']]:
        """
        A list of algorithms that were used to create a model package.
        """
        return pulumi.get(self, "source_algorithm_specification")

    @property
    @pulumi.getter(name="sourceUri")
    def source_uri(self) -> pulumi.Output[Optional[str]]:
        """
        The URI of the source for the model package.
        """
        return pulumi.get(self, "source_uri")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def task(self) -> pulumi.Output[Optional[str]]:
        """
        The machine learning task your model package accomplishes. Common machine learning tasks include object detection and image classification.
        """
        return pulumi.get(self, "task")

    @property
    @pulumi.getter(name="validationSpecification")
    def validation_specification(self) -> pulumi.Output[Optional['outputs.ModelPackageValidationSpecification']]:
        """
        Specifies batch transform jobs that SageMaker runs to validate your model package.
        """
        return pulumi.get(self, "validation_specification")

