# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = ['MlflowTrackingServerArgs', 'MlflowTrackingServer']

@pulumi.input_type
class MlflowTrackingServerArgs:
    def __init__(__self__, *,
                 artifact_store_uri: pulumi.Input[str],
                 role_arn: pulumi.Input[str],
                 automatic_model_registration: Optional[pulumi.Input[bool]] = None,
                 mlflow_version: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 tracking_server_name: Optional[pulumi.Input[str]] = None,
                 tracking_server_size: Optional[pulumi.Input['MlflowTrackingServerTrackingServerSize']] = None,
                 weekly_maintenance_window_start: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MlflowTrackingServer resource.
        :param pulumi.Input[str] artifact_store_uri: The Amazon S3 URI for MLFlow Tracking Server artifacts.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on behalf of the customer.
        :param pulumi.Input[bool] automatic_model_registration: A flag to enable Automatic SageMaker Model Registration.
        :param pulumi.Input[str] mlflow_version: The MLFlow Version used on the MLFlow Tracking Server.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input[str] tracking_server_name: The name of the MLFlow Tracking Server.
        :param pulumi.Input['MlflowTrackingServerTrackingServerSize'] tracking_server_size: The size of the MLFlow Tracking Server.
        :param pulumi.Input[str] weekly_maintenance_window_start: The start of the time window for maintenance of the MLFlow Tracking Server in UTC time.
        """
        pulumi.set(__self__, "artifact_store_uri", artifact_store_uri)
        pulumi.set(__self__, "role_arn", role_arn)
        if automatic_model_registration is not None:
            pulumi.set(__self__, "automatic_model_registration", automatic_model_registration)
        if mlflow_version is not None:
            pulumi.set(__self__, "mlflow_version", mlflow_version)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tracking_server_name is not None:
            pulumi.set(__self__, "tracking_server_name", tracking_server_name)
        if tracking_server_size is not None:
            pulumi.set(__self__, "tracking_server_size", tracking_server_size)
        if weekly_maintenance_window_start is not None:
            pulumi.set(__self__, "weekly_maintenance_window_start", weekly_maintenance_window_start)

    @property
    @pulumi.getter(name="artifactStoreUri")
    def artifact_store_uri(self) -> pulumi.Input[str]:
        """
        The Amazon S3 URI for MLFlow Tracking Server artifacts.
        """
        return pulumi.get(self, "artifact_store_uri")

    @artifact_store_uri.setter
    def artifact_store_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "artifact_store_uri", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on behalf of the customer.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="automaticModelRegistration")
    def automatic_model_registration(self) -> Optional[pulumi.Input[bool]]:
        """
        A flag to enable Automatic SageMaker Model Registration.
        """
        return pulumi.get(self, "automatic_model_registration")

    @automatic_model_registration.setter
    def automatic_model_registration(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "automatic_model_registration", value)

    @property
    @pulumi.getter(name="mlflowVersion")
    def mlflow_version(self) -> Optional[pulumi.Input[str]]:
        """
        The MLFlow Version used on the MLFlow Tracking Server.
        """
        return pulumi.get(self, "mlflow_version")

    @mlflow_version.setter
    def mlflow_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mlflow_version", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="trackingServerName")
    def tracking_server_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the MLFlow Tracking Server.
        """
        return pulumi.get(self, "tracking_server_name")

    @tracking_server_name.setter
    def tracking_server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tracking_server_name", value)

    @property
    @pulumi.getter(name="trackingServerSize")
    def tracking_server_size(self) -> Optional[pulumi.Input['MlflowTrackingServerTrackingServerSize']]:
        """
        The size of the MLFlow Tracking Server.
        """
        return pulumi.get(self, "tracking_server_size")

    @tracking_server_size.setter
    def tracking_server_size(self, value: Optional[pulumi.Input['MlflowTrackingServerTrackingServerSize']]):
        pulumi.set(self, "tracking_server_size", value)

    @property
    @pulumi.getter(name="weeklyMaintenanceWindowStart")
    def weekly_maintenance_window_start(self) -> Optional[pulumi.Input[str]]:
        """
        The start of the time window for maintenance of the MLFlow Tracking Server in UTC time.
        """
        return pulumi.get(self, "weekly_maintenance_window_start")

    @weekly_maintenance_window_start.setter
    def weekly_maintenance_window_start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "weekly_maintenance_window_start", value)


class MlflowTrackingServer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifact_store_uri: Optional[pulumi.Input[str]] = None,
                 automatic_model_registration: Optional[pulumi.Input[bool]] = None,
                 mlflow_version: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 tracking_server_name: Optional[pulumi.Input[str]] = None,
                 tracking_server_size: Optional[pulumi.Input['MlflowTrackingServerTrackingServerSize']] = None,
                 weekly_maintenance_window_start: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::SageMaker::MlflowTrackingServer

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] artifact_store_uri: The Amazon S3 URI for MLFlow Tracking Server artifacts.
        :param pulumi.Input[bool] automatic_model_registration: A flag to enable Automatic SageMaker Model Registration.
        :param pulumi.Input[str] mlflow_version: The MLFlow Version used on the MLFlow Tracking Server.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on behalf of the customer.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input[str] tracking_server_name: The name of the MLFlow Tracking Server.
        :param pulumi.Input['MlflowTrackingServerTrackingServerSize'] tracking_server_size: The size of the MLFlow Tracking Server.
        :param pulumi.Input[str] weekly_maintenance_window_start: The start of the time window for maintenance of the MLFlow Tracking Server in UTC time.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MlflowTrackingServerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::SageMaker::MlflowTrackingServer

        :param str resource_name: The name of the resource.
        :param MlflowTrackingServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MlflowTrackingServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifact_store_uri: Optional[pulumi.Input[str]] = None,
                 automatic_model_registration: Optional[pulumi.Input[bool]] = None,
                 mlflow_version: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 tracking_server_name: Optional[pulumi.Input[str]] = None,
                 tracking_server_size: Optional[pulumi.Input['MlflowTrackingServerTrackingServerSize']] = None,
                 weekly_maintenance_window_start: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MlflowTrackingServerArgs.__new__(MlflowTrackingServerArgs)

            if artifact_store_uri is None and not opts.urn:
                raise TypeError("Missing required property 'artifact_store_uri'")
            __props__.__dict__["artifact_store_uri"] = artifact_store_uri
            __props__.__dict__["automatic_model_registration"] = automatic_model_registration
            __props__.__dict__["mlflow_version"] = mlflow_version
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tracking_server_name"] = tracking_server_name
            __props__.__dict__["tracking_server_size"] = tracking_server_size
            __props__.__dict__["weekly_maintenance_window_start"] = weekly_maintenance_window_start
            __props__.__dict__["tracking_server_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["trackingServerName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(MlflowTrackingServer, __self__).__init__(
            'aws-native:sagemaker:MlflowTrackingServer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'MlflowTrackingServer':
        """
        Get an existing MlflowTrackingServer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = MlflowTrackingServerArgs.__new__(MlflowTrackingServerArgs)

        __props__.__dict__["artifact_store_uri"] = None
        __props__.__dict__["automatic_model_registration"] = None
        __props__.__dict__["mlflow_version"] = None
        __props__.__dict__["role_arn"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["tracking_server_arn"] = None
        __props__.__dict__["tracking_server_name"] = None
        __props__.__dict__["tracking_server_size"] = None
        __props__.__dict__["weekly_maintenance_window_start"] = None
        return MlflowTrackingServer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="artifactStoreUri")
    def artifact_store_uri(self) -> pulumi.Output[str]:
        """
        The Amazon S3 URI for MLFlow Tracking Server artifacts.
        """
        return pulumi.get(self, "artifact_store_uri")

    @property
    @pulumi.getter(name="automaticModelRegistration")
    def automatic_model_registration(self) -> pulumi.Output[Optional[bool]]:
        """
        A flag to enable Automatic SageMaker Model Registration.
        """
        return pulumi.get(self, "automatic_model_registration")

    @property
    @pulumi.getter(name="mlflowVersion")
    def mlflow_version(self) -> pulumi.Output[Optional[str]]:
        """
        The MLFlow Version used on the MLFlow Tracking Server.
        """
        return pulumi.get(self, "mlflow_version")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on behalf of the customer.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="trackingServerArn")
    def tracking_server_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the MLFlow Tracking Server.
        """
        return pulumi.get(self, "tracking_server_arn")

    @property
    @pulumi.getter(name="trackingServerName")
    def tracking_server_name(self) -> pulumi.Output[str]:
        """
        The name of the MLFlow Tracking Server.
        """
        return pulumi.get(self, "tracking_server_name")

    @property
    @pulumi.getter(name="trackingServerSize")
    def tracking_server_size(self) -> pulumi.Output[Optional['MlflowTrackingServerTrackingServerSize']]:
        """
        The size of the MLFlow Tracking Server.
        """
        return pulumi.get(self, "tracking_server_size")

    @property
    @pulumi.getter(name="weeklyMaintenanceWindowStart")
    def weekly_maintenance_window_start(self) -> pulumi.Output[Optional[str]]:
        """
        The start of the time window for maintenance of the MLFlow Tracking Server in UTC time.
        """
        return pulumi.get(self, "weekly_maintenance_window_start")

