# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetModelPackageGroupResult',
    'AwaitableGetModelPackageGroupResult',
    'get_model_package_group',
    'get_model_package_group_output',
]

@pulumi.output_type
class GetModelPackageGroupResult:
    def __init__(__self__, creation_time=None, model_package_group_arn=None, model_package_group_policy=None, model_package_group_status=None, tags=None):
        if creation_time and not isinstance(creation_time, str):
            raise TypeError("Expected argument 'creation_time' to be a str")
        pulumi.set(__self__, "creation_time", creation_time)
        if model_package_group_arn and not isinstance(model_package_group_arn, str):
            raise TypeError("Expected argument 'model_package_group_arn' to be a str")
        pulumi.set(__self__, "model_package_group_arn", model_package_group_arn)
        if model_package_group_policy and not isinstance(model_package_group_policy, dict):
            raise TypeError("Expected argument 'model_package_group_policy' to be a dict")
        pulumi.set(__self__, "model_package_group_policy", model_package_group_policy)
        if model_package_group_status and not isinstance(model_package_group_status, str):
            raise TypeError("Expected argument 'model_package_group_status' to be a str")
        pulumi.set(__self__, "model_package_group_status", model_package_group_status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[str]:
        """
        The time at which the model package group was created.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="modelPackageGroupArn")
    def model_package_group_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the model group.
        """
        return pulumi.get(self, "model_package_group_arn")

    @property
    @pulumi.getter(name="modelPackageGroupPolicy")
    def model_package_group_policy(self) -> Optional[Any]:
        """
        A resouce policy to control access to a model group. For information about resoure policies, see [Identity-based policies and resource-based policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html) in the *AWS Identity and Access Management User Guide.* .

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SageMaker::ModelPackageGroup` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "model_package_group_policy")

    @property
    @pulumi.getter(name="modelPackageGroupStatus")
    def model_package_group_status(self) -> Optional['ModelPackageGroupStatus']:
        """
        The status of a modelpackage group job.
        """
        return pulumi.get(self, "model_package_group_status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetModelPackageGroupResult(GetModelPackageGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetModelPackageGroupResult(
            creation_time=self.creation_time,
            model_package_group_arn=self.model_package_group_arn,
            model_package_group_policy=self.model_package_group_policy,
            model_package_group_status=self.model_package_group_status,
            tags=self.tags)


def get_model_package_group(model_package_group_arn: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetModelPackageGroupResult:
    """
    Resource Type definition for AWS::SageMaker::ModelPackageGroup


    :param str model_package_group_arn: The Amazon Resource Name (ARN) of the model group.
    """
    __args__ = dict()
    __args__['modelPackageGroupArn'] = model_package_group_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:sagemaker:getModelPackageGroup', __args__, opts=opts, typ=GetModelPackageGroupResult).value

    return AwaitableGetModelPackageGroupResult(
        creation_time=pulumi.get(__ret__, 'creation_time'),
        model_package_group_arn=pulumi.get(__ret__, 'model_package_group_arn'),
        model_package_group_policy=pulumi.get(__ret__, 'model_package_group_policy'),
        model_package_group_status=pulumi.get(__ret__, 'model_package_group_status'),
        tags=pulumi.get(__ret__, 'tags'))
def get_model_package_group_output(model_package_group_arn: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetModelPackageGroupResult]:
    """
    Resource Type definition for AWS::SageMaker::ModelPackageGroup


    :param str model_package_group_arn: The Amazon Resource Name (ARN) of the model group.
    """
    __args__ = dict()
    __args__['modelPackageGroupArn'] = model_package_group_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:sagemaker:getModelPackageGroup', __args__, opts=opts, typ=GetModelPackageGroupResult)
    return __ret__.apply(lambda __response__: GetModelPackageGroupResult(
        creation_time=pulumi.get(__response__, 'creation_time'),
        model_package_group_arn=pulumi.get(__response__, 'model_package_group_arn'),
        model_package_group_policy=pulumi.get(__response__, 'model_package_group_policy'),
        model_package_group_status=pulumi.get(__response__, 'model_package_group_status'),
        tags=pulumi.get(__response__, 'tags')))
