# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetMlflowTrackingServerResult',
    'AwaitableGetMlflowTrackingServerResult',
    'get_mlflow_tracking_server',
    'get_mlflow_tracking_server_output',
]

@pulumi.output_type
class GetMlflowTrackingServerResult:
    def __init__(__self__, artifact_store_uri=None, automatic_model_registration=None, mlflow_version=None, role_arn=None, tags=None, tracking_server_arn=None, tracking_server_size=None, weekly_maintenance_window_start=None):
        if artifact_store_uri and not isinstance(artifact_store_uri, str):
            raise TypeError("Expected argument 'artifact_store_uri' to be a str")
        pulumi.set(__self__, "artifact_store_uri", artifact_store_uri)
        if automatic_model_registration and not isinstance(automatic_model_registration, bool):
            raise TypeError("Expected argument 'automatic_model_registration' to be a bool")
        pulumi.set(__self__, "automatic_model_registration", automatic_model_registration)
        if mlflow_version and not isinstance(mlflow_version, str):
            raise TypeError("Expected argument 'mlflow_version' to be a str")
        pulumi.set(__self__, "mlflow_version", mlflow_version)
        if role_arn and not isinstance(role_arn, str):
            raise TypeError("Expected argument 'role_arn' to be a str")
        pulumi.set(__self__, "role_arn", role_arn)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if tracking_server_arn and not isinstance(tracking_server_arn, str):
            raise TypeError("Expected argument 'tracking_server_arn' to be a str")
        pulumi.set(__self__, "tracking_server_arn", tracking_server_arn)
        if tracking_server_size and not isinstance(tracking_server_size, str):
            raise TypeError("Expected argument 'tracking_server_size' to be a str")
        pulumi.set(__self__, "tracking_server_size", tracking_server_size)
        if weekly_maintenance_window_start and not isinstance(weekly_maintenance_window_start, str):
            raise TypeError("Expected argument 'weekly_maintenance_window_start' to be a str")
        pulumi.set(__self__, "weekly_maintenance_window_start", weekly_maintenance_window_start)

    @property
    @pulumi.getter(name="artifactStoreUri")
    def artifact_store_uri(self) -> Optional[str]:
        """
        The Amazon S3 URI for MLFlow Tracking Server artifacts.
        """
        return pulumi.get(self, "artifact_store_uri")

    @property
    @pulumi.getter(name="automaticModelRegistration")
    def automatic_model_registration(self) -> Optional[bool]:
        """
        A flag to enable Automatic SageMaker Model Registration.
        """
        return pulumi.get(self, "automatic_model_registration")

    @property
    @pulumi.getter(name="mlflowVersion")
    def mlflow_version(self) -> Optional[str]:
        """
        The MLFlow Version used on the MLFlow Tracking Server.
        """
        return pulumi.get(self, "mlflow_version")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on behalf of the customer.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="trackingServerArn")
    def tracking_server_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the MLFlow Tracking Server.
        """
        return pulumi.get(self, "tracking_server_arn")

    @property
    @pulumi.getter(name="trackingServerSize")
    def tracking_server_size(self) -> Optional['MlflowTrackingServerTrackingServerSize']:
        """
        The size of the MLFlow Tracking Server.
        """
        return pulumi.get(self, "tracking_server_size")

    @property
    @pulumi.getter(name="weeklyMaintenanceWindowStart")
    def weekly_maintenance_window_start(self) -> Optional[str]:
        """
        The start of the time window for maintenance of the MLFlow Tracking Server in UTC time.
        """
        return pulumi.get(self, "weekly_maintenance_window_start")


class AwaitableGetMlflowTrackingServerResult(GetMlflowTrackingServerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMlflowTrackingServerResult(
            artifact_store_uri=self.artifact_store_uri,
            automatic_model_registration=self.automatic_model_registration,
            mlflow_version=self.mlflow_version,
            role_arn=self.role_arn,
            tags=self.tags,
            tracking_server_arn=self.tracking_server_arn,
            tracking_server_size=self.tracking_server_size,
            weekly_maintenance_window_start=self.weekly_maintenance_window_start)


def get_mlflow_tracking_server(tracking_server_name: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMlflowTrackingServerResult:
    """
    Resource Type definition for AWS::SageMaker::MlflowTrackingServer


    :param str tracking_server_name: The name of the MLFlow Tracking Server.
    """
    __args__ = dict()
    __args__['trackingServerName'] = tracking_server_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:sagemaker:getMlflowTrackingServer', __args__, opts=opts, typ=GetMlflowTrackingServerResult).value

    return AwaitableGetMlflowTrackingServerResult(
        artifact_store_uri=pulumi.get(__ret__, 'artifact_store_uri'),
        automatic_model_registration=pulumi.get(__ret__, 'automatic_model_registration'),
        mlflow_version=pulumi.get(__ret__, 'mlflow_version'),
        role_arn=pulumi.get(__ret__, 'role_arn'),
        tags=pulumi.get(__ret__, 'tags'),
        tracking_server_arn=pulumi.get(__ret__, 'tracking_server_arn'),
        tracking_server_size=pulumi.get(__ret__, 'tracking_server_size'),
        weekly_maintenance_window_start=pulumi.get(__ret__, 'weekly_maintenance_window_start'))
def get_mlflow_tracking_server_output(tracking_server_name: Optional[pulumi.Input[str]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMlflowTrackingServerResult]:
    """
    Resource Type definition for AWS::SageMaker::MlflowTrackingServer


    :param str tracking_server_name: The name of the MLFlow Tracking Server.
    """
    __args__ = dict()
    __args__['trackingServerName'] = tracking_server_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:sagemaker:getMlflowTrackingServer', __args__, opts=opts, typ=GetMlflowTrackingServerResult)
    return __ret__.apply(lambda __response__: GetMlflowTrackingServerResult(
        artifact_store_uri=pulumi.get(__response__, 'artifact_store_uri'),
        automatic_model_registration=pulumi.get(__response__, 'automatic_model_registration'),
        mlflow_version=pulumi.get(__response__, 'mlflow_version'),
        role_arn=pulumi.get(__response__, 'role_arn'),
        tags=pulumi.get(__response__, 'tags'),
        tracking_server_arn=pulumi.get(__response__, 'tracking_server_arn'),
        tracking_server_size=pulumi.get(__response__, 'tracking_server_size'),
        weekly_maintenance_window_start=pulumi.get(__response__, 'weekly_maintenance_window_start')))
