# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetInferenceExperimentResult',
    'AwaitableGetInferenceExperimentResult',
    'get_inference_experiment',
    'get_inference_experiment_output',
]

@pulumi.output_type
class GetInferenceExperimentResult:
    def __init__(__self__, arn=None, creation_time=None, data_storage_config=None, description=None, desired_state=None, endpoint_metadata=None, last_modified_time=None, model_variants=None, schedule=None, shadow_mode_config=None, status=None, status_reason=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if creation_time and not isinstance(creation_time, str):
            raise TypeError("Expected argument 'creation_time' to be a str")
        pulumi.set(__self__, "creation_time", creation_time)
        if data_storage_config and not isinstance(data_storage_config, dict):
            raise TypeError("Expected argument 'data_storage_config' to be a dict")
        pulumi.set(__self__, "data_storage_config", data_storage_config)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if desired_state and not isinstance(desired_state, str):
            raise TypeError("Expected argument 'desired_state' to be a str")
        pulumi.set(__self__, "desired_state", desired_state)
        if endpoint_metadata and not isinstance(endpoint_metadata, dict):
            raise TypeError("Expected argument 'endpoint_metadata' to be a dict")
        pulumi.set(__self__, "endpoint_metadata", endpoint_metadata)
        if last_modified_time and not isinstance(last_modified_time, str):
            raise TypeError("Expected argument 'last_modified_time' to be a str")
        pulumi.set(__self__, "last_modified_time", last_modified_time)
        if model_variants and not isinstance(model_variants, list):
            raise TypeError("Expected argument 'model_variants' to be a list")
        pulumi.set(__self__, "model_variants", model_variants)
        if schedule and not isinstance(schedule, dict):
            raise TypeError("Expected argument 'schedule' to be a dict")
        pulumi.set(__self__, "schedule", schedule)
        if shadow_mode_config and not isinstance(shadow_mode_config, dict):
            raise TypeError("Expected argument 'shadow_mode_config' to be a dict")
        pulumi.set(__self__, "shadow_mode_config", shadow_mode_config)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if status_reason and not isinstance(status_reason, str):
            raise TypeError("Expected argument 'status_reason' to be a str")
        pulumi.set(__self__, "status_reason", status_reason)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the inference experiment.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[str]:
        """
        The timestamp at which you created the inference experiment.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="dataStorageConfig")
    def data_storage_config(self) -> Optional['outputs.InferenceExperimentDataStorageConfig']:
        """
        The Amazon S3 location and configuration for storing inference request and response data.
        """
        return pulumi.get(self, "data_storage_config")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the inference experiment.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> Optional['InferenceExperimentDesiredState']:
        """
        The desired state of the experiment after starting or stopping operation.
        """
        return pulumi.get(self, "desired_state")

    @property
    @pulumi.getter(name="endpointMetadata")
    def endpoint_metadata(self) -> Optional['outputs.InferenceExperimentEndpointMetadata']:
        return pulumi.get(self, "endpoint_metadata")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[str]:
        """
        The timestamp at which you last modified the inference experiment.
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter(name="modelVariants")
    def model_variants(self) -> Optional[Sequence['outputs.InferenceExperimentModelVariantConfig']]:
        """
        An array of ModelVariantConfig objects. Each ModelVariantConfig object in the array describes the infrastructure configuration for the corresponding variant.
        """
        return pulumi.get(self, "model_variants")

    @property
    @pulumi.getter
    def schedule(self) -> Optional['outputs.InferenceExperimentSchedule']:
        """
        The duration for which the inference experiment ran or will run.

        The maximum duration that you can set for an inference experiment is 30 days.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="shadowModeConfig")
    def shadow_mode_config(self) -> Optional['outputs.InferenceExperimentShadowModeConfig']:
        """
        The configuration of `ShadowMode` inference experiment type, which shows the production variant that takes all the inference requests, and the shadow variant to which Amazon SageMaker replicates a percentage of the inference requests. For the shadow variant it also shows the percentage of requests that Amazon SageMaker replicates.
        """
        return pulumi.get(self, "shadow_mode_config")

    @property
    @pulumi.getter
    def status(self) -> Optional['InferenceExperimentStatus']:
        """
        The status of the inference experiment.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> Optional[str]:
        """
        The error message or client-specified reason from the StopInferenceExperiment API, that explains the status of the inference experiment.
        """
        return pulumi.get(self, "status_reason")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetInferenceExperimentResult(GetInferenceExperimentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInferenceExperimentResult(
            arn=self.arn,
            creation_time=self.creation_time,
            data_storage_config=self.data_storage_config,
            description=self.description,
            desired_state=self.desired_state,
            endpoint_metadata=self.endpoint_metadata,
            last_modified_time=self.last_modified_time,
            model_variants=self.model_variants,
            schedule=self.schedule,
            shadow_mode_config=self.shadow_mode_config,
            status=self.status,
            status_reason=self.status_reason,
            tags=self.tags)


def get_inference_experiment(name: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInferenceExperimentResult:
    """
    Resource Type definition for AWS::SageMaker::InferenceExperiment


    :param str name: The name for the inference experiment.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:sagemaker:getInferenceExperiment', __args__, opts=opts, typ=GetInferenceExperimentResult).value

    return AwaitableGetInferenceExperimentResult(
        arn=pulumi.get(__ret__, 'arn'),
        creation_time=pulumi.get(__ret__, 'creation_time'),
        data_storage_config=pulumi.get(__ret__, 'data_storage_config'),
        description=pulumi.get(__ret__, 'description'),
        desired_state=pulumi.get(__ret__, 'desired_state'),
        endpoint_metadata=pulumi.get(__ret__, 'endpoint_metadata'),
        last_modified_time=pulumi.get(__ret__, 'last_modified_time'),
        model_variants=pulumi.get(__ret__, 'model_variants'),
        schedule=pulumi.get(__ret__, 'schedule'),
        shadow_mode_config=pulumi.get(__ret__, 'shadow_mode_config'),
        status=pulumi.get(__ret__, 'status'),
        status_reason=pulumi.get(__ret__, 'status_reason'),
        tags=pulumi.get(__ret__, 'tags'))
def get_inference_experiment_output(name: Optional[pulumi.Input[str]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetInferenceExperimentResult]:
    """
    Resource Type definition for AWS::SageMaker::InferenceExperiment


    :param str name: The name for the inference experiment.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:sagemaker:getInferenceExperiment', __args__, opts=opts, typ=GetInferenceExperimentResult)
    return __ret__.apply(lambda __response__: GetInferenceExperimentResult(
        arn=pulumi.get(__response__, 'arn'),
        creation_time=pulumi.get(__response__, 'creation_time'),
        data_storage_config=pulumi.get(__response__, 'data_storage_config'),
        description=pulumi.get(__response__, 'description'),
        desired_state=pulumi.get(__response__, 'desired_state'),
        endpoint_metadata=pulumi.get(__response__, 'endpoint_metadata'),
        last_modified_time=pulumi.get(__response__, 'last_modified_time'),
        model_variants=pulumi.get(__response__, 'model_variants'),
        schedule=pulumi.get(__response__, 'schedule'),
        shadow_mode_config=pulumi.get(__response__, 'shadow_mode_config'),
        status=pulumi.get(__response__, 'status'),
        status_reason=pulumi.get(__response__, 'status_reason'),
        tags=pulumi.get(__response__, 'tags')))
