# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['FeatureGroupArgs', 'FeatureGroup']

@pulumi.input_type
class FeatureGroupArgs:
    def __init__(__self__, *,
                 event_time_feature_name: pulumi.Input[str],
                 feature_definitions: pulumi.Input[Sequence[pulumi.Input['FeatureGroupFeatureDefinitionArgs']]],
                 record_identifier_feature_name: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 feature_group_name: Optional[pulumi.Input[str]] = None,
                 offline_store_config: Optional[pulumi.Input['OfflineStoreConfigPropertiesArgs']] = None,
                 online_store_config: Optional[pulumi.Input['OnlineStoreConfigPropertiesArgs']] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]]] = None,
                 throughput_config: Optional[pulumi.Input['FeatureGroupThroughputConfigArgs']] = None):
        """
        The set of arguments for constructing a FeatureGroup resource.
        :param pulumi.Input[str] event_time_feature_name: The Event Time Feature Name.
        :param pulumi.Input[Sequence[pulumi.Input['FeatureGroupFeatureDefinitionArgs']]] feature_definitions: An Array of Feature Definition
        :param pulumi.Input[str] record_identifier_feature_name: The Record Identifier Feature Name.
        :param pulumi.Input[str] description: Description about the FeatureGroup.
        :param pulumi.Input[str] feature_group_name: The Name of the FeatureGroup.
        :param pulumi.Input['OfflineStoreConfigPropertiesArgs'] offline_store_config: The configuration of an `OfflineStore` .
        :param pulumi.Input['OnlineStoreConfigPropertiesArgs'] online_store_config: The configuration of an `OnlineStore` .
        :param pulumi.Input[str] role_arn: Role Arn
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]] tags: An array of key-value pair to apply to this resource.
        :param pulumi.Input['FeatureGroupThroughputConfigArgs'] throughput_config: Used to set feature group throughput configuration. There are two modes: `ON_DEMAND` and `PROVISIONED` . With on-demand mode, you are charged for data reads and writes that your application performs on your feature group. You do not need to specify read and write throughput because Feature Store accommodates your workloads as they ramp up and down. You can switch a feature group to on-demand only once in a 24 hour period. With provisioned throughput mode, you specify the read and write capacity per second that you expect your application to require, and you are billed based on those limits. Exceeding provisioned throughput will result in your requests being throttled.
               
               Note: `PROVISIONED` throughput mode is supported only for feature groups that are offline-only, or use the [`Standard`](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OnlineStoreConfig.html#sagemaker-Type-OnlineStoreConfig-StorageType) tier online store.
        """
        pulumi.set(__self__, "event_time_feature_name", event_time_feature_name)
        pulumi.set(__self__, "feature_definitions", feature_definitions)
        pulumi.set(__self__, "record_identifier_feature_name", record_identifier_feature_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if feature_group_name is not None:
            pulumi.set(__self__, "feature_group_name", feature_group_name)
        if offline_store_config is not None:
            pulumi.set(__self__, "offline_store_config", offline_store_config)
        if online_store_config is not None:
            pulumi.set(__self__, "online_store_config", online_store_config)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if throughput_config is not None:
            pulumi.set(__self__, "throughput_config", throughput_config)

    @property
    @pulumi.getter(name="eventTimeFeatureName")
    def event_time_feature_name(self) -> pulumi.Input[str]:
        """
        The Event Time Feature Name.
        """
        return pulumi.get(self, "event_time_feature_name")

    @event_time_feature_name.setter
    def event_time_feature_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "event_time_feature_name", value)

    @property
    @pulumi.getter(name="featureDefinitions")
    def feature_definitions(self) -> pulumi.Input[Sequence[pulumi.Input['FeatureGroupFeatureDefinitionArgs']]]:
        """
        An Array of Feature Definition
        """
        return pulumi.get(self, "feature_definitions")

    @feature_definitions.setter
    def feature_definitions(self, value: pulumi.Input[Sequence[pulumi.Input['FeatureGroupFeatureDefinitionArgs']]]):
        pulumi.set(self, "feature_definitions", value)

    @property
    @pulumi.getter(name="recordIdentifierFeatureName")
    def record_identifier_feature_name(self) -> pulumi.Input[str]:
        """
        The Record Identifier Feature Name.
        """
        return pulumi.get(self, "record_identifier_feature_name")

    @record_identifier_feature_name.setter
    def record_identifier_feature_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "record_identifier_feature_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description about the FeatureGroup.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="featureGroupName")
    def feature_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Name of the FeatureGroup.
        """
        return pulumi.get(self, "feature_group_name")

    @feature_group_name.setter
    def feature_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "feature_group_name", value)

    @property
    @pulumi.getter(name="offlineStoreConfig")
    def offline_store_config(self) -> Optional[pulumi.Input['OfflineStoreConfigPropertiesArgs']]:
        """
        The configuration of an `OfflineStore` .
        """
        return pulumi.get(self, "offline_store_config")

    @offline_store_config.setter
    def offline_store_config(self, value: Optional[pulumi.Input['OfflineStoreConfigPropertiesArgs']]):
        pulumi.set(self, "offline_store_config", value)

    @property
    @pulumi.getter(name="onlineStoreConfig")
    def online_store_config(self) -> Optional[pulumi.Input['OnlineStoreConfigPropertiesArgs']]:
        """
        The configuration of an `OnlineStore` .
        """
        return pulumi.get(self, "online_store_config")

    @online_store_config.setter
    def online_store_config(self, value: Optional[pulumi.Input['OnlineStoreConfigPropertiesArgs']]):
        pulumi.set(self, "online_store_config", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Role Arn
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]]]:
        """
        An array of key-value pair to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="throughputConfig")
    def throughput_config(self) -> Optional[pulumi.Input['FeatureGroupThroughputConfigArgs']]:
        """
        Used to set feature group throughput configuration. There are two modes: `ON_DEMAND` and `PROVISIONED` . With on-demand mode, you are charged for data reads and writes that your application performs on your feature group. You do not need to specify read and write throughput because Feature Store accommodates your workloads as they ramp up and down. You can switch a feature group to on-demand only once in a 24 hour period. With provisioned throughput mode, you specify the read and write capacity per second that you expect your application to require, and you are billed based on those limits. Exceeding provisioned throughput will result in your requests being throttled.

        Note: `PROVISIONED` throughput mode is supported only for feature groups that are offline-only, or use the [`Standard`](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OnlineStoreConfig.html#sagemaker-Type-OnlineStoreConfig-StorageType) tier online store.
        """
        return pulumi.get(self, "throughput_config")

    @throughput_config.setter
    def throughput_config(self, value: Optional[pulumi.Input['FeatureGroupThroughputConfigArgs']]):
        pulumi.set(self, "throughput_config", value)


class FeatureGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 event_time_feature_name: Optional[pulumi.Input[str]] = None,
                 feature_definitions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FeatureGroupFeatureDefinitionArgs', 'FeatureGroupFeatureDefinitionArgsDict']]]]] = None,
                 feature_group_name: Optional[pulumi.Input[str]] = None,
                 offline_store_config: Optional[pulumi.Input[Union['OfflineStoreConfigPropertiesArgs', 'OfflineStoreConfigPropertiesArgsDict']]] = None,
                 online_store_config: Optional[pulumi.Input[Union['OnlineStoreConfigPropertiesArgs', 'OnlineStoreConfigPropertiesArgsDict']]] = None,
                 record_identifier_feature_name: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.CreateOnlyTagArgs', '_root_inputs.CreateOnlyTagArgsDict']]]]] = None,
                 throughput_config: Optional[pulumi.Input[Union['FeatureGroupThroughputConfigArgs', 'FeatureGroupThroughputConfigArgsDict']]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::SageMaker::FeatureGroup

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description about the FeatureGroup.
        :param pulumi.Input[str] event_time_feature_name: The Event Time Feature Name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FeatureGroupFeatureDefinitionArgs', 'FeatureGroupFeatureDefinitionArgsDict']]]] feature_definitions: An Array of Feature Definition
        :param pulumi.Input[str] feature_group_name: The Name of the FeatureGroup.
        :param pulumi.Input[Union['OfflineStoreConfigPropertiesArgs', 'OfflineStoreConfigPropertiesArgsDict']] offline_store_config: The configuration of an `OfflineStore` .
        :param pulumi.Input[Union['OnlineStoreConfigPropertiesArgs', 'OnlineStoreConfigPropertiesArgsDict']] online_store_config: The configuration of an `OnlineStore` .
        :param pulumi.Input[str] record_identifier_feature_name: The Record Identifier Feature Name.
        :param pulumi.Input[str] role_arn: Role Arn
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.CreateOnlyTagArgs', '_root_inputs.CreateOnlyTagArgsDict']]]] tags: An array of key-value pair to apply to this resource.
        :param pulumi.Input[Union['FeatureGroupThroughputConfigArgs', 'FeatureGroupThroughputConfigArgsDict']] throughput_config: Used to set feature group throughput configuration. There are two modes: `ON_DEMAND` and `PROVISIONED` . With on-demand mode, you are charged for data reads and writes that your application performs on your feature group. You do not need to specify read and write throughput because Feature Store accommodates your workloads as they ramp up and down. You can switch a feature group to on-demand only once in a 24 hour period. With provisioned throughput mode, you specify the read and write capacity per second that you expect your application to require, and you are billed based on those limits. Exceeding provisioned throughput will result in your requests being throttled.
               
               Note: `PROVISIONED` throughput mode is supported only for feature groups that are offline-only, or use the [`Standard`](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OnlineStoreConfig.html#sagemaker-Type-OnlineStoreConfig-StorageType) tier online store.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FeatureGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::SageMaker::FeatureGroup

        :param str resource_name: The name of the resource.
        :param FeatureGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FeatureGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 event_time_feature_name: Optional[pulumi.Input[str]] = None,
                 feature_definitions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FeatureGroupFeatureDefinitionArgs', 'FeatureGroupFeatureDefinitionArgsDict']]]]] = None,
                 feature_group_name: Optional[pulumi.Input[str]] = None,
                 offline_store_config: Optional[pulumi.Input[Union['OfflineStoreConfigPropertiesArgs', 'OfflineStoreConfigPropertiesArgsDict']]] = None,
                 online_store_config: Optional[pulumi.Input[Union['OnlineStoreConfigPropertiesArgs', 'OnlineStoreConfigPropertiesArgsDict']]] = None,
                 record_identifier_feature_name: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.CreateOnlyTagArgs', '_root_inputs.CreateOnlyTagArgsDict']]]]] = None,
                 throughput_config: Optional[pulumi.Input[Union['FeatureGroupThroughputConfigArgs', 'FeatureGroupThroughputConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FeatureGroupArgs.__new__(FeatureGroupArgs)

            __props__.__dict__["description"] = description
            if event_time_feature_name is None and not opts.urn:
                raise TypeError("Missing required property 'event_time_feature_name'")
            __props__.__dict__["event_time_feature_name"] = event_time_feature_name
            if feature_definitions is None and not opts.urn:
                raise TypeError("Missing required property 'feature_definitions'")
            __props__.__dict__["feature_definitions"] = feature_definitions
            __props__.__dict__["feature_group_name"] = feature_group_name
            __props__.__dict__["offline_store_config"] = offline_store_config
            __props__.__dict__["online_store_config"] = online_store_config
            if record_identifier_feature_name is None and not opts.urn:
                raise TypeError("Missing required property 'record_identifier_feature_name'")
            __props__.__dict__["record_identifier_feature_name"] = record_identifier_feature_name
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["throughput_config"] = throughput_config
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["feature_group_status"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["description", "eventTimeFeatureName", "featureGroupName", "offlineStoreConfig", "recordIdentifierFeatureName", "roleArn", "tags[*]"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(FeatureGroup, __self__).__init__(
            'aws-native:sagemaker:FeatureGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'FeatureGroup':
        """
        Get an existing FeatureGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = FeatureGroupArgs.__new__(FeatureGroupArgs)

        __props__.__dict__["creation_time"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["event_time_feature_name"] = None
        __props__.__dict__["feature_definitions"] = None
        __props__.__dict__["feature_group_name"] = None
        __props__.__dict__["feature_group_status"] = None
        __props__.__dict__["offline_store_config"] = None
        __props__.__dict__["online_store_config"] = None
        __props__.__dict__["record_identifier_feature_name"] = None
        __props__.__dict__["role_arn"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["throughput_config"] = None
        return FeatureGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[str]:
        """
        A timestamp of FeatureGroup creation time.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description about the FeatureGroup.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="eventTimeFeatureName")
    def event_time_feature_name(self) -> pulumi.Output[str]:
        """
        The Event Time Feature Name.
        """
        return pulumi.get(self, "event_time_feature_name")

    @property
    @pulumi.getter(name="featureDefinitions")
    def feature_definitions(self) -> pulumi.Output[Sequence['outputs.FeatureGroupFeatureDefinition']]:
        """
        An Array of Feature Definition
        """
        return pulumi.get(self, "feature_definitions")

    @property
    @pulumi.getter(name="featureGroupName")
    def feature_group_name(self) -> pulumi.Output[str]:
        """
        The Name of the FeatureGroup.
        """
        return pulumi.get(self, "feature_group_name")

    @property
    @pulumi.getter(name="featureGroupStatus")
    def feature_group_status(self) -> pulumi.Output[str]:
        """
        The status of the feature group.
        """
        return pulumi.get(self, "feature_group_status")

    @property
    @pulumi.getter(name="offlineStoreConfig")
    def offline_store_config(self) -> pulumi.Output[Optional['outputs.OfflineStoreConfigProperties']]:
        """
        The configuration of an `OfflineStore` .
        """
        return pulumi.get(self, "offline_store_config")

    @property
    @pulumi.getter(name="onlineStoreConfig")
    def online_store_config(self) -> pulumi.Output[Optional['outputs.OnlineStoreConfigProperties']]:
        """
        The configuration of an `OnlineStore` .
        """
        return pulumi.get(self, "online_store_config")

    @property
    @pulumi.getter(name="recordIdentifierFeatureName")
    def record_identifier_feature_name(self) -> pulumi.Output[str]:
        """
        The Record Identifier Feature Name.
        """
        return pulumi.get(self, "record_identifier_feature_name")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[Optional[str]]:
        """
        Role Arn
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.CreateOnlyTag']]]:
        """
        An array of key-value pair to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="throughputConfig")
    def throughput_config(self) -> pulumi.Output[Optional['outputs.FeatureGroupThroughputConfig']]:
        """
        Used to set feature group throughput configuration. There are two modes: `ON_DEMAND` and `PROVISIONED` . With on-demand mode, you are charged for data reads and writes that your application performs on your feature group. You do not need to specify read and write throughput because Feature Store accommodates your workloads as they ramp up and down. You can switch a feature group to on-demand only once in a 24 hour period. With provisioned throughput mode, you specify the read and write capacity per second that you expect your application to require, and you are billed based on those limits. Exceeding provisioned throughput will result in your requests being throttled.

        Note: `PROVISIONED` throughput mode is supported only for feature groups that are offline-only, or use the [`Standard`](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OnlineStoreConfig.html#sagemaker-Type-OnlineStoreConfig-StorageType) tier online store.
        """
        return pulumi.get(self, "throughput_config")

