# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['AppImageConfigArgs', 'AppImageConfig']

@pulumi.input_type
class AppImageConfigArgs:
    def __init__(__self__, *,
                 app_image_config_name: Optional[pulumi.Input[str]] = None,
                 code_editor_app_image_config: Optional[pulumi.Input['AppImageConfigCodeEditorAppImageConfigArgs']] = None,
                 jupyter_lab_app_image_config: Optional[pulumi.Input['AppImageConfigJupyterLabAppImageConfigArgs']] = None,
                 kernel_gateway_image_config: Optional[pulumi.Input['AppImageConfigKernelGatewayImageConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]]] = None):
        """
        The set of arguments for constructing a AppImageConfig resource.
        :param pulumi.Input[str] app_image_config_name: The Name of the AppImageConfig.
        :param pulumi.Input['AppImageConfigCodeEditorAppImageConfigArgs'] code_editor_app_image_config: The CodeEditorAppImageConfig.
        :param pulumi.Input['AppImageConfigJupyterLabAppImageConfigArgs'] jupyter_lab_app_image_config: The JupyterLabAppImageConfig.
        :param pulumi.Input['AppImageConfigKernelGatewayImageConfigArgs'] kernel_gateway_image_config: The KernelGatewayImageConfig.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]] tags: A list of tags to apply to the AppImageConfig.
        """
        if app_image_config_name is not None:
            pulumi.set(__self__, "app_image_config_name", app_image_config_name)
        if code_editor_app_image_config is not None:
            pulumi.set(__self__, "code_editor_app_image_config", code_editor_app_image_config)
        if jupyter_lab_app_image_config is not None:
            pulumi.set(__self__, "jupyter_lab_app_image_config", jupyter_lab_app_image_config)
        if kernel_gateway_image_config is not None:
            pulumi.set(__self__, "kernel_gateway_image_config", kernel_gateway_image_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="appImageConfigName")
    def app_image_config_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Name of the AppImageConfig.
        """
        return pulumi.get(self, "app_image_config_name")

    @app_image_config_name.setter
    def app_image_config_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_image_config_name", value)

    @property
    @pulumi.getter(name="codeEditorAppImageConfig")
    def code_editor_app_image_config(self) -> Optional[pulumi.Input['AppImageConfigCodeEditorAppImageConfigArgs']]:
        """
        The CodeEditorAppImageConfig.
        """
        return pulumi.get(self, "code_editor_app_image_config")

    @code_editor_app_image_config.setter
    def code_editor_app_image_config(self, value: Optional[pulumi.Input['AppImageConfigCodeEditorAppImageConfigArgs']]):
        pulumi.set(self, "code_editor_app_image_config", value)

    @property
    @pulumi.getter(name="jupyterLabAppImageConfig")
    def jupyter_lab_app_image_config(self) -> Optional[pulumi.Input['AppImageConfigJupyterLabAppImageConfigArgs']]:
        """
        The JupyterLabAppImageConfig.
        """
        return pulumi.get(self, "jupyter_lab_app_image_config")

    @jupyter_lab_app_image_config.setter
    def jupyter_lab_app_image_config(self, value: Optional[pulumi.Input['AppImageConfigJupyterLabAppImageConfigArgs']]):
        pulumi.set(self, "jupyter_lab_app_image_config", value)

    @property
    @pulumi.getter(name="kernelGatewayImageConfig")
    def kernel_gateway_image_config(self) -> Optional[pulumi.Input['AppImageConfigKernelGatewayImageConfigArgs']]:
        """
        The KernelGatewayImageConfig.
        """
        return pulumi.get(self, "kernel_gateway_image_config")

    @kernel_gateway_image_config.setter
    def kernel_gateway_image_config(self, value: Optional[pulumi.Input['AppImageConfigKernelGatewayImageConfigArgs']]):
        pulumi.set(self, "kernel_gateway_image_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]]]:
        """
        A list of tags to apply to the AppImageConfig.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]]]):
        pulumi.set(self, "tags", value)


class AppImageConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_image_config_name: Optional[pulumi.Input[str]] = None,
                 code_editor_app_image_config: Optional[pulumi.Input[Union['AppImageConfigCodeEditorAppImageConfigArgs', 'AppImageConfigCodeEditorAppImageConfigArgsDict']]] = None,
                 jupyter_lab_app_image_config: Optional[pulumi.Input[Union['AppImageConfigJupyterLabAppImageConfigArgs', 'AppImageConfigJupyterLabAppImageConfigArgsDict']]] = None,
                 kernel_gateway_image_config: Optional[pulumi.Input[Union['AppImageConfigKernelGatewayImageConfigArgs', 'AppImageConfigKernelGatewayImageConfigArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.CreateOnlyTagArgs', '_root_inputs.CreateOnlyTagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::SageMaker::AppImageConfig

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_image_config_name: The Name of the AppImageConfig.
        :param pulumi.Input[Union['AppImageConfigCodeEditorAppImageConfigArgs', 'AppImageConfigCodeEditorAppImageConfigArgsDict']] code_editor_app_image_config: The CodeEditorAppImageConfig.
        :param pulumi.Input[Union['AppImageConfigJupyterLabAppImageConfigArgs', 'AppImageConfigJupyterLabAppImageConfigArgsDict']] jupyter_lab_app_image_config: The JupyterLabAppImageConfig.
        :param pulumi.Input[Union['AppImageConfigKernelGatewayImageConfigArgs', 'AppImageConfigKernelGatewayImageConfigArgsDict']] kernel_gateway_image_config: The KernelGatewayImageConfig.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.CreateOnlyTagArgs', '_root_inputs.CreateOnlyTagArgsDict']]]] tags: A list of tags to apply to the AppImageConfig.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AppImageConfigArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::SageMaker::AppImageConfig

        :param str resource_name: The name of the resource.
        :param AppImageConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppImageConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_image_config_name: Optional[pulumi.Input[str]] = None,
                 code_editor_app_image_config: Optional[pulumi.Input[Union['AppImageConfigCodeEditorAppImageConfigArgs', 'AppImageConfigCodeEditorAppImageConfigArgsDict']]] = None,
                 jupyter_lab_app_image_config: Optional[pulumi.Input[Union['AppImageConfigJupyterLabAppImageConfigArgs', 'AppImageConfigJupyterLabAppImageConfigArgsDict']]] = None,
                 kernel_gateway_image_config: Optional[pulumi.Input[Union['AppImageConfigKernelGatewayImageConfigArgs', 'AppImageConfigKernelGatewayImageConfigArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.CreateOnlyTagArgs', '_root_inputs.CreateOnlyTagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppImageConfigArgs.__new__(AppImageConfigArgs)

            __props__.__dict__["app_image_config_name"] = app_image_config_name
            __props__.__dict__["code_editor_app_image_config"] = code_editor_app_image_config
            __props__.__dict__["jupyter_lab_app_image_config"] = jupyter_lab_app_image_config
            __props__.__dict__["kernel_gateway_image_config"] = kernel_gateway_image_config
            __props__.__dict__["tags"] = tags
            __props__.__dict__["app_image_config_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["appImageConfigName", "tags[*]"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(AppImageConfig, __self__).__init__(
            'aws-native:sagemaker:AppImageConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'AppImageConfig':
        """
        Get an existing AppImageConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AppImageConfigArgs.__new__(AppImageConfigArgs)

        __props__.__dict__["app_image_config_arn"] = None
        __props__.__dict__["app_image_config_name"] = None
        __props__.__dict__["code_editor_app_image_config"] = None
        __props__.__dict__["jupyter_lab_app_image_config"] = None
        __props__.__dict__["kernel_gateway_image_config"] = None
        __props__.__dict__["tags"] = None
        return AppImageConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appImageConfigArn")
    def app_image_config_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the AppImageConfig.
        """
        return pulumi.get(self, "app_image_config_arn")

    @property
    @pulumi.getter(name="appImageConfigName")
    def app_image_config_name(self) -> pulumi.Output[str]:
        """
        The Name of the AppImageConfig.
        """
        return pulumi.get(self, "app_image_config_name")

    @property
    @pulumi.getter(name="codeEditorAppImageConfig")
    def code_editor_app_image_config(self) -> pulumi.Output[Optional['outputs.AppImageConfigCodeEditorAppImageConfig']]:
        """
        The CodeEditorAppImageConfig.
        """
        return pulumi.get(self, "code_editor_app_image_config")

    @property
    @pulumi.getter(name="jupyterLabAppImageConfig")
    def jupyter_lab_app_image_config(self) -> pulumi.Output[Optional['outputs.AppImageConfigJupyterLabAppImageConfig']]:
        """
        The JupyterLabAppImageConfig.
        """
        return pulumi.get(self, "jupyter_lab_app_image_config")

    @property
    @pulumi.getter(name="kernelGatewayImageConfig")
    def kernel_gateway_image_config(self) -> pulumi.Output[Optional['outputs.AppImageConfigKernelGatewayImageConfig']]:
        """
        The KernelGatewayImageConfig.
        """
        return pulumi.get(self, "kernel_gateway_image_config")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.CreateOnlyTag']]]:
        """
        A list of tags to apply to the AppImageConfig.
        """
        return pulumi.get(self, "tags")

