# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['StorageLensGroupArgs', 'StorageLensGroup']

@pulumi.input_type
class StorageLensGroupArgs:
    def __init__(__self__, *,
                 filter: pulumi.Input['StorageLensGroupFilterArgs'],
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a StorageLensGroup resource.
        :param pulumi.Input['StorageLensGroupFilterArgs'] filter: This property contains the criteria for the Storage Lens group data that is displayed
        :param pulumi.Input[str] name: This property contains the Storage Lens group name.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: A set of tags (key-value pairs) for this Amazon S3 Storage Lens Group.
        """
        pulumi.set(__self__, "filter", filter)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Input['StorageLensGroupFilterArgs']:
        """
        This property contains the criteria for the Storage Lens group data that is displayed
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: pulumi.Input['StorageLensGroupFilterArgs']):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        This property contains the Storage Lens group name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        A set of tags (key-value pairs) for this Amazon S3 Storage Lens Group.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class StorageLensGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 filter: Optional[pulumi.Input[Union['StorageLensGroupFilterArgs', 'StorageLensGroupFilterArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        The AWS::S3::StorageLensGroup resource is an Amazon S3 resource type that you can use to create Storage Lens Group.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['StorageLensGroupFilterArgs', 'StorageLensGroupFilterArgsDict']] filter: This property contains the criteria for the Storage Lens group data that is displayed
        :param pulumi.Input[str] name: This property contains the Storage Lens group name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: A set of tags (key-value pairs) for this Amazon S3 Storage Lens Group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StorageLensGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The AWS::S3::StorageLensGroup resource is an Amazon S3 resource type that you can use to create Storage Lens Group.

        :param str resource_name: The name of the resource.
        :param StorageLensGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StorageLensGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 filter: Optional[pulumi.Input[Union['StorageLensGroupFilterArgs', 'StorageLensGroupFilterArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StorageLensGroupArgs.__new__(StorageLensGroupArgs)

            if filter is None and not opts.urn:
                raise TypeError("Missing required property 'filter'")
            __props__.__dict__["filter"] = filter
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["storage_lens_group_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["name"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(StorageLensGroup, __self__).__init__(
            'aws-native:s3:StorageLensGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'StorageLensGroup':
        """
        Get an existing StorageLensGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = StorageLensGroupArgs.__new__(StorageLensGroupArgs)

        __props__.__dict__["filter"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["storage_lens_group_arn"] = None
        __props__.__dict__["tags"] = None
        return StorageLensGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Output['outputs.StorageLensGroupFilter']:
        """
        This property contains the criteria for the Storage Lens group data that is displayed
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        This property contains the Storage Lens group name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="storageLensGroupArn")
    def storage_lens_group_arn(self) -> pulumi.Output[str]:
        """
        The ARN for the Amazon S3 Storage Lens Group.
        """
        return pulumi.get(self, "storage_lens_group_arn")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        A set of tags (key-value pairs) for this Amazon S3 Storage Lens Group.
        """
        return pulumi.get(self, "tags")

