# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AccessGrantGrantee',
    'AccessGrantsLocationConfiguration',
    'AccessPointPublicAccessBlockConfiguration',
    'AccessPointVpcConfiguration',
    'BucketAbortIncompleteMultipartUpload',
    'BucketAccelerateConfiguration',
    'BucketAccessControlTranslation',
    'BucketAnalyticsConfiguration',
    'BucketCorsConfiguration',
    'BucketCorsRule',
    'BucketDataExport',
    'BucketDefaultRetention',
    'BucketDeleteMarkerReplication',
    'BucketDestination',
    'BucketEncryption',
    'BucketEncryptionConfiguration',
    'BucketEventBridgeConfiguration',
    'BucketFilterRule',
    'BucketIntelligentTieringConfiguration',
    'BucketInventoryConfiguration',
    'BucketLambdaConfiguration',
    'BucketLifecycleConfiguration',
    'BucketLoggingConfiguration',
    'BucketMetrics',
    'BucketMetricsConfiguration',
    'BucketNoncurrentVersionExpiration',
    'BucketNoncurrentVersionTransition',
    'BucketNotificationConfiguration',
    'BucketNotificationFilter',
    'BucketObjectLockConfiguration',
    'BucketObjectLockRule',
    'BucketOwnershipControls',
    'BucketOwnershipControlsRule',
    'BucketPublicAccessBlockConfiguration',
    'BucketQueueConfiguration',
    'BucketRedirectAllRequestsTo',
    'BucketRedirectRule',
    'BucketReplicaModifications',
    'BucketReplicationConfiguration',
    'BucketReplicationDestination',
    'BucketReplicationRule',
    'BucketReplicationRuleAndOperator',
    'BucketReplicationRuleFilter',
    'BucketReplicationTime',
    'BucketReplicationTimeValue',
    'BucketRoutingRule',
    'BucketRoutingRuleCondition',
    'BucketRule',
    'BucketS3KeyFilter',
    'BucketServerSideEncryptionByDefault',
    'BucketServerSideEncryptionRule',
    'BucketSourceSelectionCriteria',
    'BucketSseKmsEncryptedObjects',
    'BucketStorageClassAnalysis',
    'BucketTagFilter',
    'BucketTargetObjectKeyFormat',
    'BucketTiering',
    'BucketTopicConfiguration',
    'BucketTransition',
    'BucketVersioningConfiguration',
    'BucketWebsiteConfiguration',
    'MultiRegionAccessPointPublicAccessBlockConfiguration',
    'MultiRegionAccessPointRegion',
    'PolicyStatusProperties',
    'StorageLensAccountLevel',
    'StorageLensActivityMetrics',
    'StorageLensAdvancedCostOptimizationMetrics',
    'StorageLensAdvancedDataProtectionMetrics',
    'StorageLensAwsOrg',
    'StorageLensBucketLevel',
    'StorageLensBucketsAndRegions',
    'StorageLensCloudWatchMetrics',
    'StorageLensConfiguration',
    'StorageLensDataExport',
    'StorageLensDetailedStatusCodesMetrics',
    'StorageLensEncryption',
    'StorageLensGroupAnd',
    'StorageLensGroupFilter',
    'StorageLensGroupLevel',
    'StorageLensGroupMatchObjectAge',
    'StorageLensGroupMatchObjectSize',
    'StorageLensGroupOr',
    'StorageLensGroupSelectionCriteria',
    'StorageLensGroupTag',
    'StorageLensPrefixLevel',
    'StorageLensPrefixLevelStorageMetrics',
    'StorageLensS3BucketDestination',
    'StorageLensSelectionCriteria',
]

@pulumi.output_type
class AccessGrantGrantee(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "granteeIdentifier":
            suggest = "grantee_identifier"
        elif key == "granteeType":
            suggest = "grantee_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessGrantGrantee. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessGrantGrantee.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessGrantGrantee.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 grantee_identifier: str,
                 grantee_type: 'AccessGrantGranteeGranteeType'):
        """
        :param str grantee_identifier: The unique identifier of the Grantee
        :param 'AccessGrantGranteeGranteeType' grantee_type: Configures the transfer acceleration state for an Amazon S3 bucket.
        """
        pulumi.set(__self__, "grantee_identifier", grantee_identifier)
        pulumi.set(__self__, "grantee_type", grantee_type)

    @property
    @pulumi.getter(name="granteeIdentifier")
    def grantee_identifier(self) -> str:
        """
        The unique identifier of the Grantee
        """
        return pulumi.get(self, "grantee_identifier")

    @property
    @pulumi.getter(name="granteeType")
    def grantee_type(self) -> 'AccessGrantGranteeGranteeType':
        """
        Configures the transfer acceleration state for an Amazon S3 bucket.
        """
        return pulumi.get(self, "grantee_type")


@pulumi.output_type
class AccessGrantsLocationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3SubPrefix":
            suggest = "s3_sub_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessGrantsLocationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessGrantsLocationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessGrantsLocationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_sub_prefix: str):
        """
        :param str s3_sub_prefix: The S3 sub prefix of a registered location in your S3 Access Grants instance
        """
        pulumi.set(__self__, "s3_sub_prefix", s3_sub_prefix)

    @property
    @pulumi.getter(name="s3SubPrefix")
    def s3_sub_prefix(self) -> str:
        """
        The S3 sub prefix of a registered location in your S3 Access Grants instance
        """
        return pulumi.get(self, "s3_sub_prefix")


@pulumi.output_type
class AccessPointPublicAccessBlockConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blockPublicAcls":
            suggest = "block_public_acls"
        elif key == "blockPublicPolicy":
            suggest = "block_public_policy"
        elif key == "ignorePublicAcls":
            suggest = "ignore_public_acls"
        elif key == "restrictPublicBuckets":
            suggest = "restrict_public_buckets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessPointPublicAccessBlockConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessPointPublicAccessBlockConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessPointPublicAccessBlockConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 block_public_acls: Optional[bool] = None,
                 block_public_policy: Optional[bool] = None,
                 ignore_public_acls: Optional[bool] = None,
                 restrict_public_buckets: Optional[bool] = None):
        """
        :param bool block_public_acls: Specifies whether Amazon S3 should block public access control lists (ACLs) for buckets in this account. Setting this element to TRUE causes the following behavior:
               - PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.
                - PUT Object calls fail if the request includes a public ACL.
               . - PUT Bucket calls fail if the request includes a public ACL.
               Enabling this setting doesn't affect existing policies or ACLs.
        :param bool block_public_policy: Specifies whether Amazon S3 should block public bucket policies for buckets in this account. Setting this element to TRUE causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access. Enabling this setting doesn't affect existing bucket policies.
        :param bool ignore_public_acls: Specifies whether Amazon S3 should ignore public ACLs for buckets in this account. Setting this element to TRUE causes Amazon S3 to ignore all public ACLs on buckets in this account and any objects that they contain. Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.
        :param bool restrict_public_buckets: Specifies whether Amazon S3 should restrict public bucket policies for this bucket. Setting this element to TRUE restricts access to this bucket to only AWS services and authorized users within this account if the bucket has a public policy.
               Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.
        """
        if block_public_acls is not None:
            pulumi.set(__self__, "block_public_acls", block_public_acls)
        if block_public_policy is not None:
            pulumi.set(__self__, "block_public_policy", block_public_policy)
        if ignore_public_acls is not None:
            pulumi.set(__self__, "ignore_public_acls", ignore_public_acls)
        if restrict_public_buckets is not None:
            pulumi.set(__self__, "restrict_public_buckets", restrict_public_buckets)

    @property
    @pulumi.getter(name="blockPublicAcls")
    def block_public_acls(self) -> Optional[bool]:
        """
        Specifies whether Amazon S3 should block public access control lists (ACLs) for buckets in this account. Setting this element to TRUE causes the following behavior:
        - PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.
         - PUT Object calls fail if the request includes a public ACL.
        . - PUT Bucket calls fail if the request includes a public ACL.
        Enabling this setting doesn't affect existing policies or ACLs.
        """
        return pulumi.get(self, "block_public_acls")

    @property
    @pulumi.getter(name="blockPublicPolicy")
    def block_public_policy(self) -> Optional[bool]:
        """
        Specifies whether Amazon S3 should block public bucket policies for buckets in this account. Setting this element to TRUE causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access. Enabling this setting doesn't affect existing bucket policies.
        """
        return pulumi.get(self, "block_public_policy")

    @property
    @pulumi.getter(name="ignorePublicAcls")
    def ignore_public_acls(self) -> Optional[bool]:
        """
        Specifies whether Amazon S3 should ignore public ACLs for buckets in this account. Setting this element to TRUE causes Amazon S3 to ignore all public ACLs on buckets in this account and any objects that they contain. Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.
        """
        return pulumi.get(self, "ignore_public_acls")

    @property
    @pulumi.getter(name="restrictPublicBuckets")
    def restrict_public_buckets(self) -> Optional[bool]:
        """
        Specifies whether Amazon S3 should restrict public bucket policies for this bucket. Setting this element to TRUE restricts access to this bucket to only AWS services and authorized users within this account if the bucket has a public policy.
        Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.
        """
        return pulumi.get(self, "restrict_public_buckets")


@pulumi.output_type
class AccessPointVpcConfiguration(dict):
    """
    The Virtual Private Cloud (VPC) configuration for a bucket access point.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcId":
            suggest = "vpc_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessPointVpcConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessPointVpcConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessPointVpcConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_id: Optional[str] = None):
        """
        The Virtual Private Cloud (VPC) configuration for a bucket access point.
        :param str vpc_id: If this field is specified, this access point will only allow connections from the specified VPC ID.
        """
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[str]:
        """
        If this field is specified, this access point will only allow connections from the specified VPC ID.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class BucketAbortIncompleteMultipartUpload(dict):
    """
    Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 will wait before permanently removing all parts of the upload. For more information, see [Stopping Incomplete Multipart Uploads Using a Bucket Lifecycle Policy](https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config) in the *Amazon S3 User Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "daysAfterInitiation":
            suggest = "days_after_initiation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketAbortIncompleteMultipartUpload. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketAbortIncompleteMultipartUpload.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketAbortIncompleteMultipartUpload.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days_after_initiation: int):
        """
        Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 will wait before permanently removing all parts of the upload. For more information, see [Stopping Incomplete Multipart Uploads Using a Bucket Lifecycle Policy](https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config) in the *Amazon S3 User Guide*.
        :param int days_after_initiation: Specifies the number of days after which Amazon S3 stops an incomplete multipart upload.
        """
        pulumi.set(__self__, "days_after_initiation", days_after_initiation)

    @property
    @pulumi.getter(name="daysAfterInitiation")
    def days_after_initiation(self) -> int:
        """
        Specifies the number of days after which Amazon S3 stops an incomplete multipart upload.
        """
        return pulumi.get(self, "days_after_initiation")


@pulumi.output_type
class BucketAccelerateConfiguration(dict):
    """
    Configures the transfer acceleration state for an Amazon S3 bucket. For more information, see [Amazon S3 Transfer Acceleration](https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html) in the *Amazon S3 User Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accelerationStatus":
            suggest = "acceleration_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketAccelerateConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketAccelerateConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketAccelerateConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acceleration_status: 'BucketAccelerateConfigurationAccelerationStatus'):
        """
        Configures the transfer acceleration state for an Amazon S3 bucket. For more information, see [Amazon S3 Transfer Acceleration](https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html) in the *Amazon S3 User Guide*.
        :param 'BucketAccelerateConfigurationAccelerationStatus' acceleration_status: Specifies the transfer acceleration status of the bucket.
        """
        pulumi.set(__self__, "acceleration_status", acceleration_status)

    @property
    @pulumi.getter(name="accelerationStatus")
    def acceleration_status(self) -> 'BucketAccelerateConfigurationAccelerationStatus':
        """
        Specifies the transfer acceleration status of the bucket.
        """
        return pulumi.get(self, "acceleration_status")


@pulumi.output_type
class BucketAccessControlTranslation(dict):
    """
    Specify this only in a cross-account scenario (where source and destination bucket owners are not the same), and you want to change replica ownership to the AWS-account that owns the destination bucket. If this is not specified in the replication configuration, the replicas are owned by same AWS-account that owns the source object.
    """
    def __init__(__self__, *,
                 owner: str):
        """
        Specify this only in a cross-account scenario (where source and destination bucket owners are not the same), and you want to change replica ownership to the AWS-account that owns the destination bucket. If this is not specified in the replication configuration, the replicas are owned by same AWS-account that owns the source object.
        :param str owner: Specifies the replica ownership. For default and valid values, see [PUT bucket replication](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTreplication.html) in the *Amazon S3 API Reference*.
        """
        pulumi.set(__self__, "owner", owner)

    @property
    @pulumi.getter
    def owner(self) -> str:
        """
        Specifies the replica ownership. For default and valid values, see [PUT bucket replication](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTreplication.html) in the *Amazon S3 API Reference*.
        """
        return pulumi.get(self, "owner")


@pulumi.output_type
class BucketAnalyticsConfiguration(dict):
    """
    Specifies the configuration and any analyses for the analytics filter of an Amazon S3 bucket.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClassAnalysis":
            suggest = "storage_class_analysis"
        elif key == "tagFilters":
            suggest = "tag_filters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketAnalyticsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketAnalyticsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketAnalyticsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 storage_class_analysis: 'outputs.BucketStorageClassAnalysis',
                 prefix: Optional[str] = None,
                 tag_filters: Optional[Sequence['outputs.BucketTagFilter']] = None):
        """
        Specifies the configuration and any analyses for the analytics filter of an Amazon S3 bucket.
        :param str id: The ID that identifies the analytics configuration.
        :param 'BucketStorageClassAnalysis' storage_class_analysis: Contains data related to access patterns to be collected and made available to analyze the tradeoffs between different storage classes.
        :param str prefix: The prefix that an object must have to be included in the analytics results.
        :param Sequence['BucketTagFilter'] tag_filters: The tags to use when evaluating an analytics filter.
                The analytics only includes objects that meet the filter's criteria. If no filter is specified, all of the contents of the bucket are included in the analysis.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "storage_class_analysis", storage_class_analysis)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tag_filters is not None:
            pulumi.set(__self__, "tag_filters", tag_filters)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID that identifies the analytics configuration.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="storageClassAnalysis")
    def storage_class_analysis(self) -> 'outputs.BucketStorageClassAnalysis':
        """
        Contains data related to access patterns to be collected and made available to analyze the tradeoffs between different storage classes.
        """
        return pulumi.get(self, "storage_class_analysis")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        The prefix that an object must have to be included in the analytics results.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter(name="tagFilters")
    def tag_filters(self) -> Optional[Sequence['outputs.BucketTagFilter']]:
        """
        The tags to use when evaluating an analytics filter.
         The analytics only includes objects that meet the filter's criteria. If no filter is specified, all of the contents of the bucket are included in the analysis.
        """
        return pulumi.get(self, "tag_filters")


@pulumi.output_type
class BucketCorsConfiguration(dict):
    """
    Describes the cross-origin access configuration for objects in an Amazon S3 bucket. For more information, see [Enabling Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html) in the *Amazon S3 User Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "corsRules":
            suggest = "cors_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketCorsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketCorsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketCorsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cors_rules: Sequence['outputs.BucketCorsRule']):
        """
        Describes the cross-origin access configuration for objects in an Amazon S3 bucket. For more information, see [Enabling Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html) in the *Amazon S3 User Guide*.
        :param Sequence['BucketCorsRule'] cors_rules: A set of origins and methods (cross-origin access that you want to allow). You can add up to 100 rules to the configuration.
        """
        pulumi.set(__self__, "cors_rules", cors_rules)

    @property
    @pulumi.getter(name="corsRules")
    def cors_rules(self) -> Sequence['outputs.BucketCorsRule']:
        """
        A set of origins and methods (cross-origin access that you want to allow). You can add up to 100 rules to the configuration.
        """
        return pulumi.get(self, "cors_rules")


@pulumi.output_type
class BucketCorsRule(dict):
    """
    Specifies a cross-origin access rule for an Amazon S3 bucket.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "allowedHeaders":
            suggest = "allowed_headers"
        elif key == "exposedHeaders":
            suggest = "exposed_headers"
        elif key == "maxAge":
            suggest = "max_age"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketCorsRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketCorsRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketCorsRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_methods: Sequence['BucketCorsRuleAllowedMethodsItem'],
                 allowed_origins: Sequence[str],
                 allowed_headers: Optional[Sequence[str]] = None,
                 exposed_headers: Optional[Sequence[str]] = None,
                 id: Optional[str] = None,
                 max_age: Optional[int] = None):
        """
        Specifies a cross-origin access rule for an Amazon S3 bucket.
        :param Sequence['BucketCorsRuleAllowedMethodsItem'] allowed_methods: An HTTP method that you allow the origin to run.
                 *Allowed values*: ``GET`` | ``PUT`` | ``HEAD`` | ``POST`` | ``DELETE``
        :param Sequence[str] allowed_origins: One or more origins you want customers to be able to access the bucket from.
        :param Sequence[str] allowed_headers: Headers that are specified in the ``Access-Control-Request-Headers`` header. These headers are allowed in a preflight OPTIONS request. In response to any preflight OPTIONS request, Amazon S3 returns any requested headers that are allowed.
        :param Sequence[str] exposed_headers: One or more headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript ``XMLHttpRequest`` object).
        :param str id: A unique identifier for this rule. The value must be no more than 255 characters.
        :param int max_age: The time in seconds that your browser is to cache the preflight response for the specified resource.
        """
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if exposed_headers is not None:
            pulumi.set(__self__, "exposed_headers", exposed_headers)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if max_age is not None:
            pulumi.set(__self__, "max_age", max_age)

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence['BucketCorsRuleAllowedMethodsItem']:
        """
        An HTTP method that you allow the origin to run.
          *Allowed values*: ``GET`` | ``PUT`` | ``HEAD`` | ``POST`` | ``DELETE``
        """
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[str]:
        """
        One or more origins you want customers to be able to access the bucket from.
        """
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[Sequence[str]]:
        """
        Headers that are specified in the ``Access-Control-Request-Headers`` header. These headers are allowed in a preflight OPTIONS request. In response to any preflight OPTIONS request, Amazon S3 returns any requested headers that are allowed.
        """
        return pulumi.get(self, "allowed_headers")

    @property
    @pulumi.getter(name="exposedHeaders")
    def exposed_headers(self) -> Optional[Sequence[str]]:
        """
        One or more headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript ``XMLHttpRequest`` object).
        """
        return pulumi.get(self, "exposed_headers")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        A unique identifier for this rule. The value must be no more than 255 characters.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> Optional[int]:
        """
        The time in seconds that your browser is to cache the preflight response for the specified resource.
        """
        return pulumi.get(self, "max_age")


@pulumi.output_type
class BucketDataExport(dict):
    """
    Specifies how data related to the storage class analysis for an Amazon S3 bucket should be exported.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "outputSchemaVersion":
            suggest = "output_schema_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketDataExport. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketDataExport.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketDataExport.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: 'outputs.BucketDestination',
                 output_schema_version: str):
        """
        Specifies how data related to the storage class analysis for an Amazon S3 bucket should be exported.
        :param 'BucketDestination' destination: The place to store the data for an analysis.
        :param str output_schema_version: The version of the output schema to use when exporting data. Must be ``V_1``.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "output_schema_version", output_schema_version)

    @property
    @pulumi.getter
    def destination(self) -> 'outputs.BucketDestination':
        """
        The place to store the data for an analysis.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="outputSchemaVersion")
    def output_schema_version(self) -> str:
        """
        The version of the output schema to use when exporting data. Must be ``V_1``.
        """
        return pulumi.get(self, "output_schema_version")


@pulumi.output_type
class BucketDefaultRetention(dict):
    """
    The container element for optionally specifying the default Object Lock retention settings for new objects placed in the specified bucket.
       +  The ``DefaultRetention`` settings require both a mode and a period.
      +  The ``DefaultRetention`` period can be either ``Days`` or ``Years`` but you must select one. You cannot specify ``Days`` and ``Years`` at the same time.
    """
    def __init__(__self__, *,
                 days: Optional[int] = None,
                 mode: Optional['BucketDefaultRetentionMode'] = None,
                 years: Optional[int] = None):
        """
        The container element for optionally specifying the default Object Lock retention settings for new objects placed in the specified bucket.
           +  The ``DefaultRetention`` settings require both a mode and a period.
          +  The ``DefaultRetention`` period can be either ``Days`` or ``Years`` but you must select one. You cannot specify ``Days`` and ``Years`` at the same time.
        :param int days: The number of days that you want to specify for the default retention period. If Object Lock is turned on, you must specify ``Mode`` and specify either ``Days`` or ``Years``.
        :param 'BucketDefaultRetentionMode' mode: The default Object Lock retention mode you want to apply to new objects placed in the specified bucket. If Object Lock is turned on, you must specify ``Mode`` and specify either ``Days`` or ``Years``.
        :param int years: The number of years that you want to specify for the default retention period. If Object Lock is turned on, you must specify ``Mode`` and specify either ``Days`` or ``Years``.
        """
        if days is not None:
            pulumi.set(__self__, "days", days)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if years is not None:
            pulumi.set(__self__, "years", years)

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        The number of days that you want to specify for the default retention period. If Object Lock is turned on, you must specify ``Mode`` and specify either ``Days`` or ``Years``.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter
    def mode(self) -> Optional['BucketDefaultRetentionMode']:
        """
        The default Object Lock retention mode you want to apply to new objects placed in the specified bucket. If Object Lock is turned on, you must specify ``Mode`` and specify either ``Days`` or ``Years``.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def years(self) -> Optional[int]:
        """
        The number of years that you want to specify for the default retention period. If Object Lock is turned on, you must specify ``Mode`` and specify either ``Days`` or ``Years``.
        """
        return pulumi.get(self, "years")


@pulumi.output_type
class BucketDeleteMarkerReplication(dict):
    """
    Specifies whether Amazon S3 replicates delete markers. If you specify a ``Filter`` in your replication configuration, you must also include a ``DeleteMarkerReplication`` element. If your ``Filter`` includes a ``Tag`` element, the ``DeleteMarkerReplication`` ``Status`` must be set to Disabled, because Amazon S3 does not support replicating delete markers for tag-based rules. For an example configuration, see [Basic Rule Configuration](https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-config-min-rule-config). 
     For more information about delete marker replication, see [Basic Rule Configuration](https://docs.aws.amazon.com/AmazonS3/latest/dev/delete-marker-replication.html). 
      If you are using an earlier version of the replication configuration, Amazon S3 handles replication of delete markers differently. For more information, see [Backward Compatibility](https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-backward-compat-considerations).
    """
    def __init__(__self__, *,
                 status: Optional['BucketDeleteMarkerReplicationStatus'] = None):
        """
        Specifies whether Amazon S3 replicates delete markers. If you specify a ``Filter`` in your replication configuration, you must also include a ``DeleteMarkerReplication`` element. If your ``Filter`` includes a ``Tag`` element, the ``DeleteMarkerReplication`` ``Status`` must be set to Disabled, because Amazon S3 does not support replicating delete markers for tag-based rules. For an example configuration, see [Basic Rule Configuration](https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-config-min-rule-config). 
         For more information about delete marker replication, see [Basic Rule Configuration](https://docs.aws.amazon.com/AmazonS3/latest/dev/delete-marker-replication.html). 
          If you are using an earlier version of the replication configuration, Amazon S3 handles replication of delete markers differently. For more information, see [Backward Compatibility](https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-backward-compat-considerations).
        :param 'BucketDeleteMarkerReplicationStatus' status: Indicates whether to replicate delete markers. Disabled by default.
        """
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> Optional['BucketDeleteMarkerReplicationStatus']:
        """
        Indicates whether to replicate delete markers. Disabled by default.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class BucketDestination(dict):
    """
    Specifies information about where to publish analysis or configuration results for an Amazon S3 bucket.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketArn":
            suggest = "bucket_arn"
        elif key == "bucketAccountId":
            suggest = "bucket_account_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_arn: str,
                 format: 'BucketDestinationFormat',
                 bucket_account_id: Optional[str] = None,
                 prefix: Optional[str] = None):
        """
        Specifies information about where to publish analysis or configuration results for an Amazon S3 bucket.
        :param str bucket_arn: The Amazon Resource Name (ARN) of the bucket to which data is exported.
        :param 'BucketDestinationFormat' format: Specifies the file format used when exporting data to Amazon S3.
                 *Allowed values*: ``CSV`` | ``ORC`` | ``Parquet``
        :param str bucket_account_id: The account ID that owns the destination S3 bucket. If no account ID is provided, the owner is not validated before exporting data.
                  Although this value is optional, we strongly recommend that you set it to help prevent problems if the destination bucket ownership changes.
        :param str prefix: The prefix to use when exporting data. The prefix is prepended to all results.
        """
        pulumi.set(__self__, "bucket_arn", bucket_arn)
        pulumi.set(__self__, "format", format)
        if bucket_account_id is not None:
            pulumi.set(__self__, "bucket_account_id", bucket_account_id)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter(name="bucketArn")
    def bucket_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the bucket to which data is exported.
        """
        return pulumi.get(self, "bucket_arn")

    @property
    @pulumi.getter
    def format(self) -> 'BucketDestinationFormat':
        """
        Specifies the file format used when exporting data to Amazon S3.
          *Allowed values*: ``CSV`` | ``ORC`` | ``Parquet``
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="bucketAccountId")
    def bucket_account_id(self) -> Optional[str]:
        """
        The account ID that owns the destination S3 bucket. If no account ID is provided, the owner is not validated before exporting data.
           Although this value is optional, we strongly recommend that you set it to help prevent problems if the destination bucket ownership changes.
        """
        return pulumi.get(self, "bucket_account_id")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        The prefix to use when exporting data. The prefix is prepended to all results.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class BucketEncryption(dict):
    """
    Specifies default encryption for a bucket using server-side encryption with Amazon S3-managed keys (SSE-S3), AWS KMS-managed keys (SSE-KMS), or dual-layer server-side encryption with KMS-managed keys (DSSE-KMS). For information about the Amazon S3 default encryption feature, see [Amazon S3 Default Encryption for S3 Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html) in the *Amazon S3 User Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverSideEncryptionConfiguration":
            suggest = "server_side_encryption_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 server_side_encryption_configuration: Sequence['outputs.BucketServerSideEncryptionRule']):
        """
        Specifies default encryption for a bucket using server-side encryption with Amazon S3-managed keys (SSE-S3), AWS KMS-managed keys (SSE-KMS), or dual-layer server-side encryption with KMS-managed keys (DSSE-KMS). For information about the Amazon S3 default encryption feature, see [Amazon S3 Default Encryption for S3 Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html) in the *Amazon S3 User Guide*.
        :param Sequence['BucketServerSideEncryptionRule'] server_side_encryption_configuration: Specifies the default server-side-encryption configuration.
        """
        pulumi.set(__self__, "server_side_encryption_configuration", server_side_encryption_configuration)

    @property
    @pulumi.getter(name="serverSideEncryptionConfiguration")
    def server_side_encryption_configuration(self) -> Sequence['outputs.BucketServerSideEncryptionRule']:
        """
        Specifies the default server-side-encryption configuration.
        """
        return pulumi.get(self, "server_side_encryption_configuration")


@pulumi.output_type
class BucketEncryptionConfiguration(dict):
    """
    Specifies encryption-related information for an Amazon S3 bucket that is a destination for replicated objects.
      If you're specifying a customer managed KMS key, we recommend using a fully qualified KMS key ARN. If you use a KMS key alias instead, then KMS resolves the key within the requester’s account. This behavior can result in data that's encrypted with a KMS key that belongs to the requester, and not the bucket owner.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "replicaKmsKeyId":
            suggest = "replica_kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 replica_kms_key_id: str):
        """
        Specifies encryption-related information for an Amazon S3 bucket that is a destination for replicated objects.
          If you're specifying a customer managed KMS key, we recommend using a fully qualified KMS key ARN. If you use a KMS key alias instead, then KMS resolves the key within the requester’s account. This behavior can result in data that's encrypted with a KMS key that belongs to the requester, and not the bucket owner.
        :param str replica_kms_key_id: Specifies the ID (Key ARN or Alias ARN) of the customer managed AWS KMS key stored in AWS Key Management Service (KMS) for the destination bucket. Amazon S3 uses this key to encrypt replica objects. Amazon S3 only supports symmetric encryption KMS keys. For more information, see [Asymmetric keys in KMS](https://docs.aws.amazon.com//kms/latest/developerguide/symmetric-asymmetric.html) in the *Key Management Service Developer Guide*.
        """
        pulumi.set(__self__, "replica_kms_key_id", replica_kms_key_id)

    @property
    @pulumi.getter(name="replicaKmsKeyId")
    def replica_kms_key_id(self) -> str:
        """
        Specifies the ID (Key ARN or Alias ARN) of the customer managed AWS KMS key stored in AWS Key Management Service (KMS) for the destination bucket. Amazon S3 uses this key to encrypt replica objects. Amazon S3 only supports symmetric encryption KMS keys. For more information, see [Asymmetric keys in KMS](https://docs.aws.amazon.com//kms/latest/developerguide/symmetric-asymmetric.html) in the *Key Management Service Developer Guide*.
        """
        return pulumi.get(self, "replica_kms_key_id")


@pulumi.output_type
class BucketEventBridgeConfiguration(dict):
    """
    Amazon S3 can send events to Amazon EventBridge whenever certain events happen in your bucket, see [Using EventBridge](https://docs.aws.amazon.com/AmazonS3/latest/userguide/EventBridge.html) in the *Amazon S3 User Guide*.
     Unlike other destinations, delivery of events to EventBridge can be either enabled or disabled for a bucket. If enabled, all events will be sent to EventBridge and you can use EventBridge rules to route events to additional targets. For more information, see [What Is Amazon EventBridge](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-what-is.html) in the *Amazon EventBridge User Guide*
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventBridgeEnabled":
            suggest = "event_bridge_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketEventBridgeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketEventBridgeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketEventBridgeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_bridge_enabled: bool):
        """
        Amazon S3 can send events to Amazon EventBridge whenever certain events happen in your bucket, see [Using EventBridge](https://docs.aws.amazon.com/AmazonS3/latest/userguide/EventBridge.html) in the *Amazon S3 User Guide*.
         Unlike other destinations, delivery of events to EventBridge can be either enabled or disabled for a bucket. If enabled, all events will be sent to EventBridge and you can use EventBridge rules to route events to additional targets. For more information, see [What Is Amazon EventBridge](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-what-is.html) in the *Amazon EventBridge User Guide*
        :param bool event_bridge_enabled: Enables delivery of events to Amazon EventBridge.
        """
        pulumi.set(__self__, "event_bridge_enabled", event_bridge_enabled)

    @property
    @pulumi.getter(name="eventBridgeEnabled")
    def event_bridge_enabled(self) -> bool:
        """
        Enables delivery of events to Amazon EventBridge.
        """
        return pulumi.get(self, "event_bridge_enabled")


@pulumi.output_type
class BucketFilterRule(dict):
    """
    Specifies the Amazon S3 object key name to filter on. An object key name is the name assigned to an object in your Amazon S3 bucket. You specify whether to filter on the suffix or prefix of the object key name. A prefix is a specific string of characters at the beginning of an object key name, which you can use to organize objects. For example, you can start the key names of related objects with a prefix, such as ``2023-`` or ``engineering/``. Then, you can use ``FilterRule`` to find objects in a bucket with key names that have the same prefix. A suffix is similar to a prefix, but it is at the end of the object key name instead of at the beginning.
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        Specifies the Amazon S3 object key name to filter on. An object key name is the name assigned to an object in your Amazon S3 bucket. You specify whether to filter on the suffix or prefix of the object key name. A prefix is a specific string of characters at the beginning of an object key name, which you can use to organize objects. For example, you can start the key names of related objects with a prefix, such as ``2023-`` or ``engineering/``. Then, you can use ``FilterRule`` to find objects in a bucket with key names that have the same prefix. A suffix is similar to a prefix, but it is at the end of the object key name instead of at the beginning.
        :param str name: The object key name prefix or suffix identifying one or more objects to which the filtering rule applies. The maximum length is 1,024 characters. Overlapping prefixes and suffixes are not supported. For more information, see [Configuring Event Notifications](https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html) in the *Amazon S3 User Guide*.
        :param str value: The value that the filter searches for in object key names.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The object key name prefix or suffix identifying one or more objects to which the filtering rule applies. The maximum length is 1,024 characters. Overlapping prefixes and suffixes are not supported. For more information, see [Configuring Event Notifications](https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html) in the *Amazon S3 User Guide*.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value that the filter searches for in object key names.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class BucketIntelligentTieringConfiguration(dict):
    """
    Specifies the S3 Intelligent-Tiering configuration for an Amazon S3 bucket.
     For information about the S3 Intelligent-Tiering storage class, see [Storage class for automatically optimizing frequently and infrequently accessed objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tagFilters":
            suggest = "tag_filters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketIntelligentTieringConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketIntelligentTieringConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketIntelligentTieringConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 status: 'BucketIntelligentTieringConfigurationStatus',
                 tierings: Sequence['outputs.BucketTiering'],
                 prefix: Optional[str] = None,
                 tag_filters: Optional[Sequence['outputs.BucketTagFilter']] = None):
        """
        Specifies the S3 Intelligent-Tiering configuration for an Amazon S3 bucket.
         For information about the S3 Intelligent-Tiering storage class, see [Storage class for automatically optimizing frequently and infrequently accessed objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access).
        :param str id: The ID used to identify the S3 Intelligent-Tiering configuration.
        :param 'BucketIntelligentTieringConfigurationStatus' status: Specifies the status of the configuration.
        :param Sequence['BucketTiering'] tierings: Specifies a list of S3 Intelligent-Tiering storage class tiers in the configuration. At least one tier must be defined in the list. At most, you can specify two tiers in the list, one for each available AccessTier: ``ARCHIVE_ACCESS`` and ``DEEP_ARCHIVE_ACCESS``.
                 You only need Intelligent Tiering Configuration enabled on a bucket if you want to automatically move objects stored in the Intelligent-Tiering storage class to Archive Access or Deep Archive Access tiers.
        :param str prefix: An object key name prefix that identifies the subset of objects to which the rule applies.
        :param Sequence['BucketTagFilter'] tag_filters: A container for a key-value pair.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tierings", tierings)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tag_filters is not None:
            pulumi.set(__self__, "tag_filters", tag_filters)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID used to identify the S3 Intelligent-Tiering configuration.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def status(self) -> 'BucketIntelligentTieringConfigurationStatus':
        """
        Specifies the status of the configuration.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tierings(self) -> Sequence['outputs.BucketTiering']:
        """
        Specifies a list of S3 Intelligent-Tiering storage class tiers in the configuration. At least one tier must be defined in the list. At most, you can specify two tiers in the list, one for each available AccessTier: ``ARCHIVE_ACCESS`` and ``DEEP_ARCHIVE_ACCESS``.
          You only need Intelligent Tiering Configuration enabled on a bucket if you want to automatically move objects stored in the Intelligent-Tiering storage class to Archive Access or Deep Archive Access tiers.
        """
        return pulumi.get(self, "tierings")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        An object key name prefix that identifies the subset of objects to which the rule applies.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter(name="tagFilters")
    def tag_filters(self) -> Optional[Sequence['outputs.BucketTagFilter']]:
        """
        A container for a key-value pair.
        """
        return pulumi.get(self, "tag_filters")


@pulumi.output_type
class BucketInventoryConfiguration(dict):
    """
    Specifies the inventory configuration for an Amazon S3 bucket. For more information, see [GET Bucket inventory](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketGETInventoryConfig.html) in the *Amazon S3 API Reference*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includedObjectVersions":
            suggest = "included_object_versions"
        elif key == "scheduleFrequency":
            suggest = "schedule_frequency"
        elif key == "optionalFields":
            suggest = "optional_fields"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketInventoryConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketInventoryConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketInventoryConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: 'outputs.BucketDestination',
                 enabled: bool,
                 id: str,
                 included_object_versions: 'BucketInventoryConfigurationIncludedObjectVersions',
                 schedule_frequency: 'BucketInventoryConfigurationScheduleFrequency',
                 optional_fields: Optional[Sequence['BucketInventoryConfigurationOptionalFieldsItem']] = None,
                 prefix: Optional[str] = None):
        """
        Specifies the inventory configuration for an Amazon S3 bucket. For more information, see [GET Bucket inventory](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketGETInventoryConfig.html) in the *Amazon S3 API Reference*.
        :param 'BucketDestination' destination: Contains information about where to publish the inventory results.
        :param bool enabled: Specifies whether the inventory is enabled or disabled. If set to ``True``, an inventory list is generated. If set to ``False``, no inventory list is generated.
        :param str id: The ID used to identify the inventory configuration.
        :param 'BucketInventoryConfigurationIncludedObjectVersions' included_object_versions: Object versions to include in the inventory list. If set to ``All``, the list includes all the object versions, which adds the version-related fields ``VersionId``, ``IsLatest``, and ``DeleteMarker`` to the list. If set to ``Current``, the list does not contain these version-related fields.
        :param 'BucketInventoryConfigurationScheduleFrequency' schedule_frequency: Specifies the schedule for generating inventory results.
        :param Sequence['BucketInventoryConfigurationOptionalFieldsItem'] optional_fields: Contains the optional fields that are included in the inventory results.
        :param str prefix: Specifies the inventory filter prefix.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "included_object_versions", included_object_versions)
        pulumi.set(__self__, "schedule_frequency", schedule_frequency)
        if optional_fields is not None:
            pulumi.set(__self__, "optional_fields", optional_fields)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def destination(self) -> 'outputs.BucketDestination':
        """
        Contains information about where to publish the inventory results.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Specifies whether the inventory is enabled or disabled. If set to ``True``, an inventory list is generated. If set to ``False``, no inventory list is generated.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID used to identify the inventory configuration.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="includedObjectVersions")
    def included_object_versions(self) -> 'BucketInventoryConfigurationIncludedObjectVersions':
        """
        Object versions to include in the inventory list. If set to ``All``, the list includes all the object versions, which adds the version-related fields ``VersionId``, ``IsLatest``, and ``DeleteMarker`` to the list. If set to ``Current``, the list does not contain these version-related fields.
        """
        return pulumi.get(self, "included_object_versions")

    @property
    @pulumi.getter(name="scheduleFrequency")
    def schedule_frequency(self) -> 'BucketInventoryConfigurationScheduleFrequency':
        """
        Specifies the schedule for generating inventory results.
        """
        return pulumi.get(self, "schedule_frequency")

    @property
    @pulumi.getter(name="optionalFields")
    def optional_fields(self) -> Optional[Sequence['BucketInventoryConfigurationOptionalFieldsItem']]:
        """
        Contains the optional fields that are included in the inventory results.
        """
        return pulumi.get(self, "optional_fields")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Specifies the inventory filter prefix.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class BucketLambdaConfiguration(dict):
    """
    Describes the LAMlong functions to invoke and the events for which to invoke them.
    """
    def __init__(__self__, *,
                 event: str,
                 function: str,
                 filter: Optional['outputs.BucketNotificationFilter'] = None):
        """
        Describes the LAMlong functions to invoke and the events for which to invoke them.
        :param str event: The Amazon S3 bucket event for which to invoke the LAMlong function. For more information, see [Supported Event Types](https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html) in the *Amazon S3 User Guide*.
        :param str function: The Amazon Resource Name (ARN) of the LAMlong function that Amazon S3 invokes when the specified event type occurs.
        :param 'BucketNotificationFilter' filter: The filtering rules that determine which objects invoke the AWS Lambda function. For example, you can create a filter so that only image files with a ``.jpg`` extension invoke the function when they are added to the Amazon S3 bucket.
        """
        pulumi.set(__self__, "event", event)
        pulumi.set(__self__, "function", function)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)

    @property
    @pulumi.getter
    def event(self) -> str:
        """
        The Amazon S3 bucket event for which to invoke the LAMlong function. For more information, see [Supported Event Types](https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html) in the *Amazon S3 User Guide*.
        """
        return pulumi.get(self, "event")

    @property
    @pulumi.getter
    def function(self) -> str:
        """
        The Amazon Resource Name (ARN) of the LAMlong function that Amazon S3 invokes when the specified event type occurs.
        """
        return pulumi.get(self, "function")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.BucketNotificationFilter']:
        """
        The filtering rules that determine which objects invoke the AWS Lambda function. For example, you can create a filter so that only image files with a ``.jpg`` extension invoke the function when they are added to the Amazon S3 bucket.
        """
        return pulumi.get(self, "filter")


@pulumi.output_type
class BucketLifecycleConfiguration(dict):
    """
    Specifies the lifecycle configuration for objects in an Amazon S3 bucket. For more information, see [Object Lifecycle Management](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html) in the *Amazon S3 User Guide*.
    """
    def __init__(__self__, *,
                 rules: Sequence['outputs.BucketRule']):
        """
        Specifies the lifecycle configuration for objects in an Amazon S3 bucket. For more information, see [Object Lifecycle Management](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html) in the *Amazon S3 User Guide*.
        :param Sequence['BucketRule'] rules: A lifecycle rule for individual objects in an Amazon S3 bucket.
        """
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.BucketRule']:
        """
        A lifecycle rule for individual objects in an Amazon S3 bucket.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class BucketLoggingConfiguration(dict):
    """
    Describes where logs are stored and the prefix that Amazon S3 assigns to all log object keys for a bucket. For examples and more information, see [PUT Bucket logging](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlogging.html) in the *Amazon S3 API Reference*.
      To successfully complete the ``AWS::S3::Bucket LoggingConfiguration`` request, you must have ``s3:PutObject`` and ``s3:PutObjectAcl`` in your IAM permissions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationBucketName":
            suggest = "destination_bucket_name"
        elif key == "logFilePrefix":
            suggest = "log_file_prefix"
        elif key == "targetObjectKeyFormat":
            suggest = "target_object_key_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLoggingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLoggingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLoggingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_bucket_name: Optional[str] = None,
                 log_file_prefix: Optional[str] = None,
                 target_object_key_format: Optional['outputs.BucketTargetObjectKeyFormat'] = None):
        """
        Describes where logs are stored and the prefix that Amazon S3 assigns to all log object keys for a bucket. For examples and more information, see [PUT Bucket logging](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlogging.html) in the *Amazon S3 API Reference*.
          To successfully complete the ``AWS::S3::Bucket LoggingConfiguration`` request, you must have ``s3:PutObject`` and ``s3:PutObjectAcl`` in your IAM permissions.
        :param str destination_bucket_name: The name of the bucket where Amazon S3 should store server access log files. You can store log files in any bucket that you own. By default, logs are stored in the bucket where the ``LoggingConfiguration`` property is defined.
        :param str log_file_prefix: A prefix for all log object keys. If you store log files from multiple Amazon S3 buckets in a single bucket, you can use a prefix to distinguish which log files came from which bucket.
        :param 'BucketTargetObjectKeyFormat' target_object_key_format: Amazon S3 key format for log objects. Only one format, either PartitionedPrefix or SimplePrefix, is allowed.
        """
        if destination_bucket_name is not None:
            pulumi.set(__self__, "destination_bucket_name", destination_bucket_name)
        if log_file_prefix is not None:
            pulumi.set(__self__, "log_file_prefix", log_file_prefix)
        if target_object_key_format is not None:
            pulumi.set(__self__, "target_object_key_format", target_object_key_format)

    @property
    @pulumi.getter(name="destinationBucketName")
    def destination_bucket_name(self) -> Optional[str]:
        """
        The name of the bucket where Amazon S3 should store server access log files. You can store log files in any bucket that you own. By default, logs are stored in the bucket where the ``LoggingConfiguration`` property is defined.
        """
        return pulumi.get(self, "destination_bucket_name")

    @property
    @pulumi.getter(name="logFilePrefix")
    def log_file_prefix(self) -> Optional[str]:
        """
        A prefix for all log object keys. If you store log files from multiple Amazon S3 buckets in a single bucket, you can use a prefix to distinguish which log files came from which bucket.
        """
        return pulumi.get(self, "log_file_prefix")

    @property
    @pulumi.getter(name="targetObjectKeyFormat")
    def target_object_key_format(self) -> Optional['outputs.BucketTargetObjectKeyFormat']:
        """
        Amazon S3 key format for log objects. Only one format, either PartitionedPrefix or SimplePrefix, is allowed.
        """
        return pulumi.get(self, "target_object_key_format")


@pulumi.output_type
class BucketMetrics(dict):
    """
    A container specifying replication metrics-related settings enabling replication metrics and events.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventThreshold":
            suggest = "event_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketMetrics. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketMetrics.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketMetrics.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: 'BucketMetricsStatus',
                 event_threshold: Optional['outputs.BucketReplicationTimeValue'] = None):
        """
        A container specifying replication metrics-related settings enabling replication metrics and events.
        :param 'BucketMetricsStatus' status: Specifies whether the replication metrics are enabled.
        :param 'BucketReplicationTimeValue' event_threshold: A container specifying the time threshold for emitting the ``s3:Replication:OperationMissedThreshold`` event.
        """
        pulumi.set(__self__, "status", status)
        if event_threshold is not None:
            pulumi.set(__self__, "event_threshold", event_threshold)

    @property
    @pulumi.getter
    def status(self) -> 'BucketMetricsStatus':
        """
        Specifies whether the replication metrics are enabled.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="eventThreshold")
    def event_threshold(self) -> Optional['outputs.BucketReplicationTimeValue']:
        """
        A container specifying the time threshold for emitting the ``s3:Replication:OperationMissedThreshold`` event.
        """
        return pulumi.get(self, "event_threshold")


@pulumi.output_type
class BucketMetricsConfiguration(dict):
    """
    Specifies a metrics configuration for the CloudWatch request metrics (specified by the metrics configuration ID) from an Amazon S3 bucket. If you're updating an existing metrics configuration, note that this is a full replacement of the existing metrics configuration. If you don't include the elements you want to keep, they are erased. For examples, see [AWS::S3::Bucket](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#aws-properties-s3-bucket--examples). For more information, see [PUT Bucket metrics](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTMetricConfiguration.html) in the *Amazon S3 API Reference*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessPointArn":
            suggest = "access_point_arn"
        elif key == "tagFilters":
            suggest = "tag_filters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketMetricsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketMetricsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketMetricsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 access_point_arn: Optional[str] = None,
                 prefix: Optional[str] = None,
                 tag_filters: Optional[Sequence['outputs.BucketTagFilter']] = None):
        """
        Specifies a metrics configuration for the CloudWatch request metrics (specified by the metrics configuration ID) from an Amazon S3 bucket. If you're updating an existing metrics configuration, note that this is a full replacement of the existing metrics configuration. If you don't include the elements you want to keep, they are erased. For examples, see [AWS::S3::Bucket](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#aws-properties-s3-bucket--examples). For more information, see [PUT Bucket metrics](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTMetricConfiguration.html) in the *Amazon S3 API Reference*.
        :param str id: The ID used to identify the metrics configuration. This can be any value you choose that helps you identify your metrics configuration.
        :param str access_point_arn: The access point that was used while performing operations on the object. The metrics configuration only includes objects that meet the filter's criteria.
        :param str prefix: The prefix that an object must have to be included in the metrics results.
        :param Sequence['BucketTagFilter'] tag_filters: Specifies a list of tag filters to use as a metrics configuration filter. The metrics configuration includes only objects that meet the filter's criteria.
        """
        pulumi.set(__self__, "id", id)
        if access_point_arn is not None:
            pulumi.set(__self__, "access_point_arn", access_point_arn)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tag_filters is not None:
            pulumi.set(__self__, "tag_filters", tag_filters)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID used to identify the metrics configuration. This can be any value you choose that helps you identify your metrics configuration.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="accessPointArn")
    def access_point_arn(self) -> Optional[str]:
        """
        The access point that was used while performing operations on the object. The metrics configuration only includes objects that meet the filter's criteria.
        """
        return pulumi.get(self, "access_point_arn")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        The prefix that an object must have to be included in the metrics results.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter(name="tagFilters")
    def tag_filters(self) -> Optional[Sequence['outputs.BucketTagFilter']]:
        """
        Specifies a list of tag filters to use as a metrics configuration filter. The metrics configuration includes only objects that meet the filter's criteria.
        """
        return pulumi.get(self, "tag_filters")


@pulumi.output_type
class BucketNoncurrentVersionExpiration(dict):
    """
    Specifies when noncurrent object versions expire. Upon expiration, S3 permanently deletes the noncurrent object versions. You set this lifecycle configuration action on a bucket that has versioning enabled (or suspended) to request that S3 delete noncurrent object versions at a specific period in the object's lifetime. For more information about setting a lifecycle rule configuration, see [AWS::S3::Bucket Rule](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "noncurrentDays":
            suggest = "noncurrent_days"
        elif key == "newerNoncurrentVersions":
            suggest = "newer_noncurrent_versions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketNoncurrentVersionExpiration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketNoncurrentVersionExpiration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketNoncurrentVersionExpiration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 noncurrent_days: int,
                 newer_noncurrent_versions: Optional[int] = None):
        """
        Specifies when noncurrent object versions expire. Upon expiration, S3 permanently deletes the noncurrent object versions. You set this lifecycle configuration action on a bucket that has versioning enabled (or suspended) to request that S3 delete noncurrent object versions at a specific period in the object's lifetime. For more information about setting a lifecycle rule configuration, see [AWS::S3::Bucket Rule](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html).
        :param int noncurrent_days: Specifies the number of days an object is noncurrent before S3 can perform the associated action. For information about the noncurrent days calculations, see [How Amazon S3 Calculates When an Object Became Noncurrent](https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations) in the *Amazon S3 User Guide*.
        :param int newer_noncurrent_versions: Specifies how many noncurrent versions S3 will retain. If there are this many more recent noncurrent versions, S3 will take the associated action. For more information about noncurrent versions, see [Lifecycle configuration elements](https://docs.aws.amazon.com/AmazonS3/latest/userguide/intro-lifecycle-rules.html) in the *Amazon S3 User Guide*.
        """
        pulumi.set(__self__, "noncurrent_days", noncurrent_days)
        if newer_noncurrent_versions is not None:
            pulumi.set(__self__, "newer_noncurrent_versions", newer_noncurrent_versions)

    @property
    @pulumi.getter(name="noncurrentDays")
    def noncurrent_days(self) -> int:
        """
        Specifies the number of days an object is noncurrent before S3 can perform the associated action. For information about the noncurrent days calculations, see [How Amazon S3 Calculates When an Object Became Noncurrent](https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations) in the *Amazon S3 User Guide*.
        """
        return pulumi.get(self, "noncurrent_days")

    @property
    @pulumi.getter(name="newerNoncurrentVersions")
    def newer_noncurrent_versions(self) -> Optional[int]:
        """
        Specifies how many noncurrent versions S3 will retain. If there are this many more recent noncurrent versions, S3 will take the associated action. For more information about noncurrent versions, see [Lifecycle configuration elements](https://docs.aws.amazon.com/AmazonS3/latest/userguide/intro-lifecycle-rules.html) in the *Amazon S3 User Guide*.
        """
        return pulumi.get(self, "newer_noncurrent_versions")


@pulumi.output_type
class BucketNoncurrentVersionTransition(dict):
    """
    Container for the transition rule that describes when noncurrent objects transition to the ``STANDARD_IA``, ``ONEZONE_IA``, ``INTELLIGENT_TIERING``, ``GLACIER_IR``, ``GLACIER``, or ``DEEP_ARCHIVE`` storage class. If your bucket is versioning-enabled (or versioning is suspended), you can set this action to request that Amazon S3 transition noncurrent object versions to the ``STANDARD_IA``, ``ONEZONE_IA``, ``INTELLIGENT_TIERING``, ``GLACIER_IR``, ``GLACIER``, or ``DEEP_ARCHIVE`` storage class at a specific period in the object's lifetime. If you specify this property, don't specify the ``NoncurrentVersionTransitions`` property.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClass":
            suggest = "storage_class"
        elif key == "transitionInDays":
            suggest = "transition_in_days"
        elif key == "newerNoncurrentVersions":
            suggest = "newer_noncurrent_versions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketNoncurrentVersionTransition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketNoncurrentVersionTransition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketNoncurrentVersionTransition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_class: 'BucketNoncurrentVersionTransitionStorageClass',
                 transition_in_days: int,
                 newer_noncurrent_versions: Optional[int] = None):
        """
        Container for the transition rule that describes when noncurrent objects transition to the ``STANDARD_IA``, ``ONEZONE_IA``, ``INTELLIGENT_TIERING``, ``GLACIER_IR``, ``GLACIER``, or ``DEEP_ARCHIVE`` storage class. If your bucket is versioning-enabled (or versioning is suspended), you can set this action to request that Amazon S3 transition noncurrent object versions to the ``STANDARD_IA``, ``ONEZONE_IA``, ``INTELLIGENT_TIERING``, ``GLACIER_IR``, ``GLACIER``, or ``DEEP_ARCHIVE`` storage class at a specific period in the object's lifetime. If you specify this property, don't specify the ``NoncurrentVersionTransitions`` property.
        :param 'BucketNoncurrentVersionTransitionStorageClass' storage_class: The class of storage used to store the object.
        :param int transition_in_days: Specifies the number of days an object is noncurrent before Amazon S3 can perform the associated action. For information about the noncurrent days calculations, see [How Amazon S3 Calculates How Long an Object Has Been Noncurrent](https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations) in the *Amazon S3 User Guide*.
        :param int newer_noncurrent_versions: Specifies how many noncurrent versions S3 will retain. If there are this many more recent noncurrent versions, S3 will take the associated action. For more information about noncurrent versions, see [Lifecycle configuration elements](https://docs.aws.amazon.com/AmazonS3/latest/userguide/intro-lifecycle-rules.html) in the *Amazon S3 User Guide*.
        """
        pulumi.set(__self__, "storage_class", storage_class)
        pulumi.set(__self__, "transition_in_days", transition_in_days)
        if newer_noncurrent_versions is not None:
            pulumi.set(__self__, "newer_noncurrent_versions", newer_noncurrent_versions)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> 'BucketNoncurrentVersionTransitionStorageClass':
        """
        The class of storage used to store the object.
        """
        return pulumi.get(self, "storage_class")

    @property
    @pulumi.getter(name="transitionInDays")
    def transition_in_days(self) -> int:
        """
        Specifies the number of days an object is noncurrent before Amazon S3 can perform the associated action. For information about the noncurrent days calculations, see [How Amazon S3 Calculates How Long an Object Has Been Noncurrent](https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations) in the *Amazon S3 User Guide*.
        """
        return pulumi.get(self, "transition_in_days")

    @property
    @pulumi.getter(name="newerNoncurrentVersions")
    def newer_noncurrent_versions(self) -> Optional[int]:
        """
        Specifies how many noncurrent versions S3 will retain. If there are this many more recent noncurrent versions, S3 will take the associated action. For more information about noncurrent versions, see [Lifecycle configuration elements](https://docs.aws.amazon.com/AmazonS3/latest/userguide/intro-lifecycle-rules.html) in the *Amazon S3 User Guide*.
        """
        return pulumi.get(self, "newer_noncurrent_versions")


@pulumi.output_type
class BucketNotificationConfiguration(dict):
    """
    Describes the notification configuration for an Amazon S3 bucket.
      If you create the target resource and related permissions in the same template, you might have a circular dependency.
     For example, you might use the ``AWS::Lambda::Permission`` resource to grant the bucket permission to invoke an AWS Lambda function. However, AWS CloudFormation can't create the bucket until the bucket has permission to invoke the function (AWS CloudFormation checks whether the bucket can invoke the function). If you're using Refs to pass the bucket name, this leads to a circular dependency.
     To avoid this dependency, you can create all resources without specifying the notification configuration. Then, update the stack with a notification configuration.
     For more information on permissions, see [AWS::Lambda::Permission](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html) and [Granting Permissions to Publish Event Notification Messages to a Destination](https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#grant-destinations-permissions-to-s3).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventBridgeConfiguration":
            suggest = "event_bridge_configuration"
        elif key == "lambdaConfigurations":
            suggest = "lambda_configurations"
        elif key == "queueConfigurations":
            suggest = "queue_configurations"
        elif key == "topicConfigurations":
            suggest = "topic_configurations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketNotificationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketNotificationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketNotificationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_bridge_configuration: Optional['outputs.BucketEventBridgeConfiguration'] = None,
                 lambda_configurations: Optional[Sequence['outputs.BucketLambdaConfiguration']] = None,
                 queue_configurations: Optional[Sequence['outputs.BucketQueueConfiguration']] = None,
                 topic_configurations: Optional[Sequence['outputs.BucketTopicConfiguration']] = None):
        """
        Describes the notification configuration for an Amazon S3 bucket.
          If you create the target resource and related permissions in the same template, you might have a circular dependency.
         For example, you might use the ``AWS::Lambda::Permission`` resource to grant the bucket permission to invoke an AWS Lambda function. However, AWS CloudFormation can't create the bucket until the bucket has permission to invoke the function (AWS CloudFormation checks whether the bucket can invoke the function). If you're using Refs to pass the bucket name, this leads to a circular dependency.
         To avoid this dependency, you can create all resources without specifying the notification configuration. Then, update the stack with a notification configuration.
         For more information on permissions, see [AWS::Lambda::Permission](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html) and [Granting Permissions to Publish Event Notification Messages to a Destination](https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#grant-destinations-permissions-to-s3).
        :param 'BucketEventBridgeConfiguration' event_bridge_configuration: Enables delivery of events to Amazon EventBridge.
        :param Sequence['BucketLambdaConfiguration'] lambda_configurations: Describes the LAMlong functions to invoke and the events for which to invoke them.
        :param Sequence['BucketQueueConfiguration'] queue_configurations: The Amazon Simple Queue Service queues to publish messages to and the events for which to publish messages.
        :param Sequence['BucketTopicConfiguration'] topic_configurations: The topic to which notifications are sent and the events for which notifications are generated.
        """
        if event_bridge_configuration is not None:
            pulumi.set(__self__, "event_bridge_configuration", event_bridge_configuration)
        if lambda_configurations is not None:
            pulumi.set(__self__, "lambda_configurations", lambda_configurations)
        if queue_configurations is not None:
            pulumi.set(__self__, "queue_configurations", queue_configurations)
        if topic_configurations is not None:
            pulumi.set(__self__, "topic_configurations", topic_configurations)

    @property
    @pulumi.getter(name="eventBridgeConfiguration")
    def event_bridge_configuration(self) -> Optional['outputs.BucketEventBridgeConfiguration']:
        """
        Enables delivery of events to Amazon EventBridge.
        """
        return pulumi.get(self, "event_bridge_configuration")

    @property
    @pulumi.getter(name="lambdaConfigurations")
    def lambda_configurations(self) -> Optional[Sequence['outputs.BucketLambdaConfiguration']]:
        """
        Describes the LAMlong functions to invoke and the events for which to invoke them.
        """
        return pulumi.get(self, "lambda_configurations")

    @property
    @pulumi.getter(name="queueConfigurations")
    def queue_configurations(self) -> Optional[Sequence['outputs.BucketQueueConfiguration']]:
        """
        The Amazon Simple Queue Service queues to publish messages to and the events for which to publish messages.
        """
        return pulumi.get(self, "queue_configurations")

    @property
    @pulumi.getter(name="topicConfigurations")
    def topic_configurations(self) -> Optional[Sequence['outputs.BucketTopicConfiguration']]:
        """
        The topic to which notifications are sent and the events for which notifications are generated.
        """
        return pulumi.get(self, "topic_configurations")


@pulumi.output_type
class BucketNotificationFilter(dict):
    """
    Specifies object key name filtering rules. For information about key name filtering, see [Configuring event notifications using object key name filtering](https://docs.aws.amazon.com/AmazonS3/latest/userguide/notification-how-to-filtering.html) in the *Amazon S3 User Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Key":
            suggest = "s3_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketNotificationFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketNotificationFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketNotificationFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_key: 'outputs.BucketS3KeyFilter'):
        """
        Specifies object key name filtering rules. For information about key name filtering, see [Configuring event notifications using object key name filtering](https://docs.aws.amazon.com/AmazonS3/latest/userguide/notification-how-to-filtering.html) in the *Amazon S3 User Guide*.
        :param 'BucketS3KeyFilter' s3_key: A container for object key name prefix and suffix filtering rules.
        """
        pulumi.set(__self__, "s3_key", s3_key)

    @property
    @pulumi.getter(name="s3Key")
    def s3_key(self) -> 'outputs.BucketS3KeyFilter':
        """
        A container for object key name prefix and suffix filtering rules.
        """
        return pulumi.get(self, "s3_key")


@pulumi.output_type
class BucketObjectLockConfiguration(dict):
    """
    Places an Object Lock configuration on the specified bucket. The rule specified in the Object Lock configuration will be applied by default to every new object placed in the specified bucket. For more information, see [Locking Objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectLockEnabled":
            suggest = "object_lock_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketObjectLockConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketObjectLockConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketObjectLockConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_lock_enabled: Optional[str] = None,
                 rule: Optional['outputs.BucketObjectLockRule'] = None):
        """
        Places an Object Lock configuration on the specified bucket. The rule specified in the Object Lock configuration will be applied by default to every new object placed in the specified bucket. For more information, see [Locking Objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html).
        :param str object_lock_enabled: Indicates whether this bucket has an Object Lock configuration enabled. Enable ``ObjectLockEnabled`` when you apply ``ObjectLockConfiguration`` to a bucket.
        :param 'BucketObjectLockRule' rule: Specifies the Object Lock rule for the specified object. Enable this rule when you apply ``ObjectLockConfiguration`` to a bucket. If Object Lock is turned on, bucket settings require both ``Mode`` and a period of either ``Days`` or ``Years``. You cannot specify ``Days`` and ``Years`` at the same time. For more information, see [ObjectLockRule](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-objectlockrule.html) and [DefaultRetention](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-defaultretention.html).
        """
        if object_lock_enabled is not None:
            pulumi.set(__self__, "object_lock_enabled", object_lock_enabled)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)

    @property
    @pulumi.getter(name="objectLockEnabled")
    def object_lock_enabled(self) -> Optional[str]:
        """
        Indicates whether this bucket has an Object Lock configuration enabled. Enable ``ObjectLockEnabled`` when you apply ``ObjectLockConfiguration`` to a bucket.
        """
        return pulumi.get(self, "object_lock_enabled")

    @property
    @pulumi.getter
    def rule(self) -> Optional['outputs.BucketObjectLockRule']:
        """
        Specifies the Object Lock rule for the specified object. Enable this rule when you apply ``ObjectLockConfiguration`` to a bucket. If Object Lock is turned on, bucket settings require both ``Mode`` and a period of either ``Days`` or ``Years``. You cannot specify ``Days`` and ``Years`` at the same time. For more information, see [ObjectLockRule](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-objectlockrule.html) and [DefaultRetention](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-defaultretention.html).
        """
        return pulumi.get(self, "rule")


@pulumi.output_type
class BucketObjectLockRule(dict):
    """
    Specifies the Object Lock rule for the specified object. Enable the this rule when you apply ``ObjectLockConfiguration`` to a bucket.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultRetention":
            suggest = "default_retention"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketObjectLockRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketObjectLockRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketObjectLockRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_retention: Optional['outputs.BucketDefaultRetention'] = None):
        """
        Specifies the Object Lock rule for the specified object. Enable the this rule when you apply ``ObjectLockConfiguration`` to a bucket.
        :param 'BucketDefaultRetention' default_retention: The default Object Lock retention mode and period that you want to apply to new objects placed in the specified bucket. If Object Lock is turned on, bucket settings require both ``Mode`` and a period of either ``Days`` or ``Years``. You cannot specify ``Days`` and ``Years`` at the same time. For more information about allowable values for mode and period, see [DefaultRetention](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-defaultretention.html).
        """
        if default_retention is not None:
            pulumi.set(__self__, "default_retention", default_retention)

    @property
    @pulumi.getter(name="defaultRetention")
    def default_retention(self) -> Optional['outputs.BucketDefaultRetention']:
        """
        The default Object Lock retention mode and period that you want to apply to new objects placed in the specified bucket. If Object Lock is turned on, bucket settings require both ``Mode`` and a period of either ``Days`` or ``Years``. You cannot specify ``Days`` and ``Years`` at the same time. For more information about allowable values for mode and period, see [DefaultRetention](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-defaultretention.html).
        """
        return pulumi.get(self, "default_retention")


@pulumi.output_type
class BucketOwnershipControls(dict):
    """
    Specifies the container element for Object Ownership rules.
     S3 Object Ownership is an Amazon S3 bucket-level setting that you can use to disable access control lists (ACLs) and take ownership of every object in your bucket, simplifying access management for data stored in Amazon S3. For more information, see [Controlling ownership of objects and disabling ACLs](https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html) in the *Amazon S3 User Guide*.
    """
    def __init__(__self__, *,
                 rules: Sequence['outputs.BucketOwnershipControlsRule']):
        """
        Specifies the container element for Object Ownership rules.
         S3 Object Ownership is an Amazon S3 bucket-level setting that you can use to disable access control lists (ACLs) and take ownership of every object in your bucket, simplifying access management for data stored in Amazon S3. For more information, see [Controlling ownership of objects and disabling ACLs](https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html) in the *Amazon S3 User Guide*.
        :param Sequence['BucketOwnershipControlsRule'] rules: Specifies the container element for Object Ownership rules.
        """
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.BucketOwnershipControlsRule']:
        """
        Specifies the container element for Object Ownership rules.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class BucketOwnershipControlsRule(dict):
    """
    Specifies an Object Ownership rule.
     S3 Object Ownership is an Amazon S3 bucket-level setting that you can use to disable access control lists (ACLs) and take ownership of every object in your bucket, simplifying access management for data stored in Amazon S3. For more information, see [Controlling ownership of objects and disabling ACLs](https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html) in the *Amazon S3 User Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectOwnership":
            suggest = "object_ownership"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketOwnershipControlsRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketOwnershipControlsRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketOwnershipControlsRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_ownership: Optional['BucketOwnershipControlsRuleObjectOwnership'] = None):
        """
        Specifies an Object Ownership rule.
         S3 Object Ownership is an Amazon S3 bucket-level setting that you can use to disable access control lists (ACLs) and take ownership of every object in your bucket, simplifying access management for data stored in Amazon S3. For more information, see [Controlling ownership of objects and disabling ACLs](https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html) in the *Amazon S3 User Guide*.
        :param 'BucketOwnershipControlsRuleObjectOwnership' object_ownership: Specifies an object ownership rule.
        """
        if object_ownership is not None:
            pulumi.set(__self__, "object_ownership", object_ownership)

    @property
    @pulumi.getter(name="objectOwnership")
    def object_ownership(self) -> Optional['BucketOwnershipControlsRuleObjectOwnership']:
        """
        Specifies an object ownership rule.
        """
        return pulumi.get(self, "object_ownership")


@pulumi.output_type
class BucketPublicAccessBlockConfiguration(dict):
    """
    The PublicAccessBlock configuration that you want to apply to this Amazon S3 bucket. You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see [The Meaning of "Public"](https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status) in the *Amazon S3 User Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blockPublicAcls":
            suggest = "block_public_acls"
        elif key == "blockPublicPolicy":
            suggest = "block_public_policy"
        elif key == "ignorePublicAcls":
            suggest = "ignore_public_acls"
        elif key == "restrictPublicBuckets":
            suggest = "restrict_public_buckets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketPublicAccessBlockConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketPublicAccessBlockConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketPublicAccessBlockConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 block_public_acls: Optional[bool] = None,
                 block_public_policy: Optional[bool] = None,
                 ignore_public_acls: Optional[bool] = None,
                 restrict_public_buckets: Optional[bool] = None):
        """
        The PublicAccessBlock configuration that you want to apply to this Amazon S3 bucket. You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see [The Meaning of "Public"](https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status) in the *Amazon S3 User Guide*.
        :param bool block_public_acls: Specifies whether Amazon S3 should block public access control lists (ACLs) for this bucket and objects in this bucket. Setting this element to ``TRUE`` causes the following behavior:
                 +  PUT Bucket ACL and PUT Object ACL calls fail if the specified ACL is public.
                 +  PUT Object calls fail if the request includes a public ACL.
                 +  PUT Bucket calls fail if the request includes a public ACL.
                 
                Enabling this setting doesn't affect existing policies or ACLs.
        :param bool block_public_policy: Specifies whether Amazon S3 should block public bucket policies for this bucket. Setting this element to ``TRUE`` causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access. 
                Enabling this setting doesn't affect existing bucket policies.
        :param bool ignore_public_acls: Specifies whether Amazon S3 should ignore public ACLs for this bucket and objects in this bucket. Setting this element to ``TRUE`` causes Amazon S3 to ignore all public ACLs on this bucket and objects in this bucket.
                Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.
        :param bool restrict_public_buckets: Specifies whether Amazon S3 should restrict public bucket policies for this bucket. Setting this element to ``TRUE`` restricts access to this bucket to only AWS-service principals and authorized users within this account if the bucket has a public policy.
                Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.
        """
        if block_public_acls is not None:
            pulumi.set(__self__, "block_public_acls", block_public_acls)
        if block_public_policy is not None:
            pulumi.set(__self__, "block_public_policy", block_public_policy)
        if ignore_public_acls is not None:
            pulumi.set(__self__, "ignore_public_acls", ignore_public_acls)
        if restrict_public_buckets is not None:
            pulumi.set(__self__, "restrict_public_buckets", restrict_public_buckets)

    @property
    @pulumi.getter(name="blockPublicAcls")
    def block_public_acls(self) -> Optional[bool]:
        """
        Specifies whether Amazon S3 should block public access control lists (ACLs) for this bucket and objects in this bucket. Setting this element to ``TRUE`` causes the following behavior:
          +  PUT Bucket ACL and PUT Object ACL calls fail if the specified ACL is public.
          +  PUT Object calls fail if the request includes a public ACL.
          +  PUT Bucket calls fail if the request includes a public ACL.
          
         Enabling this setting doesn't affect existing policies or ACLs.
        """
        return pulumi.get(self, "block_public_acls")

    @property
    @pulumi.getter(name="blockPublicPolicy")
    def block_public_policy(self) -> Optional[bool]:
        """
        Specifies whether Amazon S3 should block public bucket policies for this bucket. Setting this element to ``TRUE`` causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access. 
         Enabling this setting doesn't affect existing bucket policies.
        """
        return pulumi.get(self, "block_public_policy")

    @property
    @pulumi.getter(name="ignorePublicAcls")
    def ignore_public_acls(self) -> Optional[bool]:
        """
        Specifies whether Amazon S3 should ignore public ACLs for this bucket and objects in this bucket. Setting this element to ``TRUE`` causes Amazon S3 to ignore all public ACLs on this bucket and objects in this bucket.
         Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.
        """
        return pulumi.get(self, "ignore_public_acls")

    @property
    @pulumi.getter(name="restrictPublicBuckets")
    def restrict_public_buckets(self) -> Optional[bool]:
        """
        Specifies whether Amazon S3 should restrict public bucket policies for this bucket. Setting this element to ``TRUE`` restricts access to this bucket to only AWS-service principals and authorized users within this account if the bucket has a public policy.
         Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.
        """
        return pulumi.get(self, "restrict_public_buckets")


@pulumi.output_type
class BucketQueueConfiguration(dict):
    """
    Specifies the configuration for publishing messages to an Amazon Simple Queue Service (Amazon SQS) queue when Amazon S3 detects specified events.
    """
    def __init__(__self__, *,
                 event: str,
                 queue: str,
                 filter: Optional['outputs.BucketNotificationFilter'] = None):
        """
        Specifies the configuration for publishing messages to an Amazon Simple Queue Service (Amazon SQS) queue when Amazon S3 detects specified events.
        :param str event: The Amazon S3 bucket event about which you want to publish messages to Amazon SQS. For more information, see [Supported Event Types](https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html) in the *Amazon S3 User Guide*.
        :param str queue: The Amazon Resource Name (ARN) of the Amazon SQS queue to which Amazon S3 publishes a message when it detects events of the specified type. FIFO queues are not allowed when enabling an SQS queue as the event notification destination.
        :param 'BucketNotificationFilter' filter: The filtering rules that determine which objects trigger notifications. For example, you can create a filter so that Amazon S3 sends notifications only when image files with a ``.jpg`` extension are added to the bucket. For more information, see [Configuring event notifications using object key name filtering](https://docs.aws.amazon.com/AmazonS3/latest/user-guide/notification-how-to-filtering.html) in the *Amazon S3 User Guide*.
        """
        pulumi.set(__self__, "event", event)
        pulumi.set(__self__, "queue", queue)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)

    @property
    @pulumi.getter
    def event(self) -> str:
        """
        The Amazon S3 bucket event about which you want to publish messages to Amazon SQS. For more information, see [Supported Event Types](https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html) in the *Amazon S3 User Guide*.
        """
        return pulumi.get(self, "event")

    @property
    @pulumi.getter
    def queue(self) -> str:
        """
        The Amazon Resource Name (ARN) of the Amazon SQS queue to which Amazon S3 publishes a message when it detects events of the specified type. FIFO queues are not allowed when enabling an SQS queue as the event notification destination.
        """
        return pulumi.get(self, "queue")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.BucketNotificationFilter']:
        """
        The filtering rules that determine which objects trigger notifications. For example, you can create a filter so that Amazon S3 sends notifications only when image files with a ``.jpg`` extension are added to the bucket. For more information, see [Configuring event notifications using object key name filtering](https://docs.aws.amazon.com/AmazonS3/latest/user-guide/notification-how-to-filtering.html) in the *Amazon S3 User Guide*.
        """
        return pulumi.get(self, "filter")


@pulumi.output_type
class BucketRedirectAllRequestsTo(dict):
    """
    Specifies the redirect behavior of all requests to a website endpoint of an Amazon S3 bucket.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostName":
            suggest = "host_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketRedirectAllRequestsTo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketRedirectAllRequestsTo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketRedirectAllRequestsTo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_name: str,
                 protocol: Optional['BucketRedirectAllRequestsToProtocol'] = None):
        """
        Specifies the redirect behavior of all requests to a website endpoint of an Amazon S3 bucket.
        :param str host_name: Name of the host where requests are redirected.
        :param 'BucketRedirectAllRequestsToProtocol' protocol: Protocol to use when redirecting requests. The default is the protocol that is used in the original request.
        """
        pulumi.set(__self__, "host_name", host_name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> str:
        """
        Name of the host where requests are redirected.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def protocol(self) -> Optional['BucketRedirectAllRequestsToProtocol']:
        """
        Protocol to use when redirecting requests. The default is the protocol that is used in the original request.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class BucketRedirectRule(dict):
    """
    Specifies how requests are redirected. In the event of an error, you can specify a different error code to return.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostName":
            suggest = "host_name"
        elif key == "httpRedirectCode":
            suggest = "http_redirect_code"
        elif key == "replaceKeyPrefixWith":
            suggest = "replace_key_prefix_with"
        elif key == "replaceKeyWith":
            suggest = "replace_key_with"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketRedirectRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketRedirectRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketRedirectRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_name: Optional[str] = None,
                 http_redirect_code: Optional[str] = None,
                 protocol: Optional['BucketRedirectRuleProtocol'] = None,
                 replace_key_prefix_with: Optional[str] = None,
                 replace_key_with: Optional[str] = None):
        """
        Specifies how requests are redirected. In the event of an error, you can specify a different error code to return.
        :param str host_name: The host name to use in the redirect request.
        :param str http_redirect_code: The HTTP redirect code to use on the response. Not required if one of the siblings is present.
        :param 'BucketRedirectRuleProtocol' protocol: Protocol to use when redirecting requests. The default is the protocol that is used in the original request.
        :param str replace_key_prefix_with: The object key prefix to use in the redirect request. For example, to redirect requests for all pages with prefix ``docs/`` (objects in the ``docs/`` folder) to ``documents/``, you can set a condition block with ``KeyPrefixEquals`` set to ``docs/`` and in the Redirect set ``ReplaceKeyPrefixWith`` to ``/documents``. Not required if one of the siblings is present. Can be present only if ``ReplaceKeyWith`` is not provided.
                 Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
        :param str replace_key_with: The specific object key to use in the redirect request. For example, redirect request to ``error.html``. Not required if one of the siblings is present. Can be present only if ``ReplaceKeyPrefixWith`` is not provided.
                 Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
        """
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if http_redirect_code is not None:
            pulumi.set(__self__, "http_redirect_code", http_redirect_code)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if replace_key_prefix_with is not None:
            pulumi.set(__self__, "replace_key_prefix_with", replace_key_prefix_with)
        if replace_key_with is not None:
            pulumi.set(__self__, "replace_key_with", replace_key_with)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[str]:
        """
        The host name to use in the redirect request.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="httpRedirectCode")
    def http_redirect_code(self) -> Optional[str]:
        """
        The HTTP redirect code to use on the response. Not required if one of the siblings is present.
        """
        return pulumi.get(self, "http_redirect_code")

    @property
    @pulumi.getter
    def protocol(self) -> Optional['BucketRedirectRuleProtocol']:
        """
        Protocol to use when redirecting requests. The default is the protocol that is used in the original request.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="replaceKeyPrefixWith")
    def replace_key_prefix_with(self) -> Optional[str]:
        """
        The object key prefix to use in the redirect request. For example, to redirect requests for all pages with prefix ``docs/`` (objects in the ``docs/`` folder) to ``documents/``, you can set a condition block with ``KeyPrefixEquals`` set to ``docs/`` and in the Redirect set ``ReplaceKeyPrefixWith`` to ``/documents``. Not required if one of the siblings is present. Can be present only if ``ReplaceKeyWith`` is not provided.
          Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
        """
        return pulumi.get(self, "replace_key_prefix_with")

    @property
    @pulumi.getter(name="replaceKeyWith")
    def replace_key_with(self) -> Optional[str]:
        """
        The specific object key to use in the redirect request. For example, redirect request to ``error.html``. Not required if one of the siblings is present. Can be present only if ``ReplaceKeyPrefixWith`` is not provided.
          Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
        """
        return pulumi.get(self, "replace_key_with")


@pulumi.output_type
class BucketReplicaModifications(dict):
    """
    A filter that you can specify for selection for modifications on replicas.
    """
    def __init__(__self__, *,
                 status: 'BucketReplicaModificationsStatus'):
        """
        A filter that you can specify for selection for modifications on replicas.
        :param 'BucketReplicaModificationsStatus' status: Specifies whether Amazon S3 replicates modifications on replicas.
                 *Allowed values*: ``Enabled`` | ``Disabled``
        """
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> 'BucketReplicaModificationsStatus':
        """
        Specifies whether Amazon S3 replicates modifications on replicas.
          *Allowed values*: ``Enabled`` | ``Disabled``
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class BucketReplicationConfiguration(dict):
    """
    A container for replication rules. You can add up to 1,000 rules. The maximum size of a replication configuration is 2 MB. The latest version of the replication configuration XML is V2. For more information about XML V2 replication configurations, see [Replication configuration](https://docs.aws.amazon.com/AmazonS3/latest/userguide/replication-add-config.html) in the *Amazon S3 User Guide*.
    """
    def __init__(__self__, *,
                 role: str,
                 rules: Sequence['outputs.BucketReplicationRule']):
        """
        A container for replication rules. You can add up to 1,000 rules. The maximum size of a replication configuration is 2 MB. The latest version of the replication configuration XML is V2. For more information about XML V2 replication configurations, see [Replication configuration](https://docs.aws.amazon.com/AmazonS3/latest/userguide/replication-add-config.html) in the *Amazon S3 User Guide*.
        :param str role: The Amazon Resource Name (ARN) of the IAMlong (IAM) role that Amazon S3 assumes when replicating objects. For more information, see [How to Set Up Replication](https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-how-setup.html) in the *Amazon S3 User Guide*.
        :param Sequence['BucketReplicationRule'] rules: A container for one or more replication rules. A replication configuration must have at least one rule and can contain a maximum of 1,000 rules.
        """
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        The Amazon Resource Name (ARN) of the IAMlong (IAM) role that Amazon S3 assumes when replicating objects. For more information, see [How to Set Up Replication](https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-how-setup.html) in the *Amazon S3 User Guide*.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.BucketReplicationRule']:
        """
        A container for one or more replication rules. A replication configuration must have at least one rule and can contain a maximum of 1,000 rules.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class BucketReplicationDestination(dict):
    """
    A container for information about the replication destination and its configurations including enabling the S3 Replication Time Control (S3 RTC).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessControlTranslation":
            suggest = "access_control_translation"
        elif key == "encryptionConfiguration":
            suggest = "encryption_configuration"
        elif key == "replicationTime":
            suggest = "replication_time"
        elif key == "storageClass":
            suggest = "storage_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketReplicationDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketReplicationDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketReplicationDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 access_control_translation: Optional['outputs.BucketAccessControlTranslation'] = None,
                 account: Optional[str] = None,
                 encryption_configuration: Optional['outputs.BucketEncryptionConfiguration'] = None,
                 metrics: Optional['outputs.BucketMetrics'] = None,
                 replication_time: Optional['outputs.BucketReplicationTime'] = None,
                 storage_class: Optional['BucketReplicationDestinationStorageClass'] = None):
        """
        A container for information about the replication destination and its configurations including enabling the S3 Replication Time Control (S3 RTC).
        :param str bucket: The Amazon Resource Name (ARN) of the bucket where you want Amazon S3 to store the results.
        :param 'BucketAccessControlTranslation' access_control_translation: Specify this only in a cross-account scenario (where source and destination bucket owners are not the same), and you want to change replica ownership to the AWS-account that owns the destination bucket. If this is not specified in the replication configuration, the replicas are owned by same AWS-account that owns the source object.
        :param str account: Destination bucket owner account ID. In a cross-account scenario, if you direct Amazon S3 to change replica ownership to the AWS-account that owns the destination bucket by specifying the ``AccessControlTranslation`` property, this is the account ID of the destination bucket owner. For more information, see [Cross-Region Replication Additional Configuration: Change Replica Owner](https://docs.aws.amazon.com/AmazonS3/latest/dev/crr-change-owner.html) in the *Amazon S3 User Guide*.
                If you specify the ``AccessControlTranslation`` property, the ``Account`` property is required.
        :param 'BucketEncryptionConfiguration' encryption_configuration: Specifies encryption-related information.
        :param 'BucketMetrics' metrics: A container specifying replication metrics-related settings enabling replication metrics and events.
        :param 'BucketReplicationTime' replication_time: A container specifying S3 Replication Time Control (S3 RTC), including whether S3 RTC is enabled and the time when all objects and operations on objects must be replicated. Must be specified together with a ``Metrics`` block.
        :param 'BucketReplicationDestinationStorageClass' storage_class: The storage class to use when replicating objects, such as S3 Standard or reduced redundancy. By default, Amazon S3 uses the storage class of the source object to create the object replica. 
                For valid values, see the ``StorageClass`` element of the [PUT Bucket replication](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTreplication.html) action in the *Amazon S3 API Reference*.
        """
        pulumi.set(__self__, "bucket", bucket)
        if access_control_translation is not None:
            pulumi.set(__self__, "access_control_translation", access_control_translation)
        if account is not None:
            pulumi.set(__self__, "account", account)
        if encryption_configuration is not None:
            pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if replication_time is not None:
            pulumi.set(__self__, "replication_time", replication_time)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The Amazon Resource Name (ARN) of the bucket where you want Amazon S3 to store the results.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="accessControlTranslation")
    def access_control_translation(self) -> Optional['outputs.BucketAccessControlTranslation']:
        """
        Specify this only in a cross-account scenario (where source and destination bucket owners are not the same), and you want to change replica ownership to the AWS-account that owns the destination bucket. If this is not specified in the replication configuration, the replicas are owned by same AWS-account that owns the source object.
        """
        return pulumi.get(self, "access_control_translation")

    @property
    @pulumi.getter
    def account(self) -> Optional[str]:
        """
        Destination bucket owner account ID. In a cross-account scenario, if you direct Amazon S3 to change replica ownership to the AWS-account that owns the destination bucket by specifying the ``AccessControlTranslation`` property, this is the account ID of the destination bucket owner. For more information, see [Cross-Region Replication Additional Configuration: Change Replica Owner](https://docs.aws.amazon.com/AmazonS3/latest/dev/crr-change-owner.html) in the *Amazon S3 User Guide*.
         If you specify the ``AccessControlTranslation`` property, the ``Account`` property is required.
        """
        return pulumi.get(self, "account")

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional['outputs.BucketEncryptionConfiguration']:
        """
        Specifies encryption-related information.
        """
        return pulumi.get(self, "encryption_configuration")

    @property
    @pulumi.getter
    def metrics(self) -> Optional['outputs.BucketMetrics']:
        """
        A container specifying replication metrics-related settings enabling replication metrics and events.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="replicationTime")
    def replication_time(self) -> Optional['outputs.BucketReplicationTime']:
        """
        A container specifying S3 Replication Time Control (S3 RTC), including whether S3 RTC is enabled and the time when all objects and operations on objects must be replicated. Must be specified together with a ``Metrics`` block.
        """
        return pulumi.get(self, "replication_time")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional['BucketReplicationDestinationStorageClass']:
        """
        The storage class to use when replicating objects, such as S3 Standard or reduced redundancy. By default, Amazon S3 uses the storage class of the source object to create the object replica. 
         For valid values, see the ``StorageClass`` element of the [PUT Bucket replication](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTreplication.html) action in the *Amazon S3 API Reference*.
        """
        return pulumi.get(self, "storage_class")


@pulumi.output_type
class BucketReplicationRule(dict):
    """
    Specifies which Amazon S3 objects to replicate and where to store the replicas.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteMarkerReplication":
            suggest = "delete_marker_replication"
        elif key == "sourceSelectionCriteria":
            suggest = "source_selection_criteria"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketReplicationRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketReplicationRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketReplicationRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: 'outputs.BucketReplicationDestination',
                 status: 'BucketReplicationRuleStatus',
                 delete_marker_replication: Optional['outputs.BucketDeleteMarkerReplication'] = None,
                 filter: Optional['outputs.BucketReplicationRuleFilter'] = None,
                 id: Optional[str] = None,
                 prefix: Optional[str] = None,
                 priority: Optional[int] = None,
                 source_selection_criteria: Optional['outputs.BucketSourceSelectionCriteria'] = None):
        """
        Specifies which Amazon S3 objects to replicate and where to store the replicas.
        :param 'BucketReplicationDestination' destination: A container for information about the replication destination and its configurations including enabling the S3 Replication Time Control (S3 RTC).
        :param 'BucketReplicationRuleStatus' status: Specifies whether the rule is enabled.
        :param 'BucketDeleteMarkerReplication' delete_marker_replication: Specifies whether Amazon S3 replicates delete markers. If you specify a ``Filter`` in your replication configuration, you must also include a ``DeleteMarkerReplication`` element. If your ``Filter`` includes a ``Tag`` element, the ``DeleteMarkerReplication`` ``Status`` must be set to Disabled, because Amazon S3 does not support replicating delete markers for tag-based rules. For an example configuration, see [Basic Rule Configuration](https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-config-min-rule-config). 
                For more information about delete marker replication, see [Basic Rule Configuration](https://docs.aws.amazon.com/AmazonS3/latest/dev/delete-marker-replication.html). 
                 If you are using an earlier version of the replication configuration, Amazon S3 handles replication of delete markers differently. For more information, see [Backward Compatibility](https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-backward-compat-considerations).
        :param 'BucketReplicationRuleFilter' filter: A filter that identifies the subset of objects to which the replication rule applies. A ``Filter`` must specify exactly one ``Prefix``, ``TagFilter``, or an ``And`` child element. The use of the filter field indicates that this is a V2 replication configuration. This field isn't supported in a V1 replication configuration.
                 V1 replication configuration only supports filtering by key prefix. To filter using a V1 replication configuration, add the ``Prefix`` directly as a child element of the ``Rule`` element.
        :param str id: A unique identifier for the rule. The maximum value is 255 characters. If you don't specify a value, AWS CloudFormation generates a random ID. When using a V2 replication configuration this property is capitalized as "ID".
        :param str prefix: An object key name prefix that identifies the object or objects to which the rule applies. The maximum prefix length is 1,024 characters. To include all objects in a bucket, specify an empty string. To filter using a V1 replication configuration, add the ``Prefix`` directly as a child element of the ``Rule`` element.
                 Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
        :param int priority: The priority indicates which rule has precedence whenever two or more replication rules conflict. Amazon S3 will attempt to replicate objects according to all replication rules. However, if there are two or more rules with the same destination bucket, then objects will be replicated according to the rule with the highest priority. The higher the number, the higher the priority. 
                For more information, see [Replication](https://docs.aws.amazon.com/AmazonS3/latest/dev/replication.html) in the *Amazon S3 User Guide*.
        :param 'BucketSourceSelectionCriteria' source_selection_criteria: A container that describes additional filters for identifying the source objects that you want to replicate. You can choose to enable or disable the replication of these objects.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "status", status)
        if delete_marker_replication is not None:
            pulumi.set(__self__, "delete_marker_replication", delete_marker_replication)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if source_selection_criteria is not None:
            pulumi.set(__self__, "source_selection_criteria", source_selection_criteria)

    @property
    @pulumi.getter
    def destination(self) -> 'outputs.BucketReplicationDestination':
        """
        A container for information about the replication destination and its configurations including enabling the S3 Replication Time Control (S3 RTC).
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def status(self) -> 'BucketReplicationRuleStatus':
        """
        Specifies whether the rule is enabled.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="deleteMarkerReplication")
    def delete_marker_replication(self) -> Optional['outputs.BucketDeleteMarkerReplication']:
        """
        Specifies whether Amazon S3 replicates delete markers. If you specify a ``Filter`` in your replication configuration, you must also include a ``DeleteMarkerReplication`` element. If your ``Filter`` includes a ``Tag`` element, the ``DeleteMarkerReplication`` ``Status`` must be set to Disabled, because Amazon S3 does not support replicating delete markers for tag-based rules. For an example configuration, see [Basic Rule Configuration](https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-config-min-rule-config). 
         For more information about delete marker replication, see [Basic Rule Configuration](https://docs.aws.amazon.com/AmazonS3/latest/dev/delete-marker-replication.html). 
          If you are using an earlier version of the replication configuration, Amazon S3 handles replication of delete markers differently. For more information, see [Backward Compatibility](https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-backward-compat-considerations).
        """
        return pulumi.get(self, "delete_marker_replication")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.BucketReplicationRuleFilter']:
        """
        A filter that identifies the subset of objects to which the replication rule applies. A ``Filter`` must specify exactly one ``Prefix``, ``TagFilter``, or an ``And`` child element. The use of the filter field indicates that this is a V2 replication configuration. This field isn't supported in a V1 replication configuration.
          V1 replication configuration only supports filtering by key prefix. To filter using a V1 replication configuration, add the ``Prefix`` directly as a child element of the ``Rule`` element.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        A unique identifier for the rule. The maximum value is 255 characters. If you don't specify a value, AWS CloudFormation generates a random ID. When using a V2 replication configuration this property is capitalized as "ID".
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        An object key name prefix that identifies the object or objects to which the rule applies. The maximum prefix length is 1,024 characters. To include all objects in a bucket, specify an empty string. To filter using a V1 replication configuration, add the ``Prefix`` directly as a child element of the ``Rule`` element.
          Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        The priority indicates which rule has precedence whenever two or more replication rules conflict. Amazon S3 will attempt to replicate objects according to all replication rules. However, if there are two or more rules with the same destination bucket, then objects will be replicated according to the rule with the highest priority. The higher the number, the higher the priority. 
         For more information, see [Replication](https://docs.aws.amazon.com/AmazonS3/latest/dev/replication.html) in the *Amazon S3 User Guide*.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="sourceSelectionCriteria")
    def source_selection_criteria(self) -> Optional['outputs.BucketSourceSelectionCriteria']:
        """
        A container that describes additional filters for identifying the source objects that you want to replicate. You can choose to enable or disable the replication of these objects.
        """
        return pulumi.get(self, "source_selection_criteria")


@pulumi.output_type
class BucketReplicationRuleAndOperator(dict):
    """
    A container for specifying rule filters. The filters determine the subset of objects to which the rule applies. This element is required only if you specify more than one filter. 
     For example:
      +  If you specify both a ``Prefix`` and a ``TagFilter``, wrap these filters in an ``And`` tag. 
      +  If you specify a filter based on multiple tags, wrap the ``TagFilter`` elements in an ``And`` tag
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tagFilters":
            suggest = "tag_filters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketReplicationRuleAndOperator. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketReplicationRuleAndOperator.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketReplicationRuleAndOperator.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 prefix: Optional[str] = None,
                 tag_filters: Optional[Sequence['outputs.BucketTagFilter']] = None):
        """
        A container for specifying rule filters. The filters determine the subset of objects to which the rule applies. This element is required only if you specify more than one filter. 
         For example:
          +  If you specify both a ``Prefix`` and a ``TagFilter``, wrap these filters in an ``And`` tag. 
          +  If you specify a filter based on multiple tags, wrap the ``TagFilter`` elements in an ``And`` tag
        :param str prefix: An object key name prefix that identifies the subset of objects to which the rule applies.
        :param Sequence['BucketTagFilter'] tag_filters: An array of tags containing key and value pairs.
        """
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tag_filters is not None:
            pulumi.set(__self__, "tag_filters", tag_filters)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        An object key name prefix that identifies the subset of objects to which the rule applies.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter(name="tagFilters")
    def tag_filters(self) -> Optional[Sequence['outputs.BucketTagFilter']]:
        """
        An array of tags containing key and value pairs.
        """
        return pulumi.get(self, "tag_filters")


@pulumi.output_type
class BucketReplicationRuleFilter(dict):
    """
    A filter that identifies the subset of objects to which the replication rule applies. A ``Filter`` must specify exactly one ``Prefix``, ``TagFilter``, or an ``And`` child element.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "and":
            suggest = "and_"
        elif key == "tagFilter":
            suggest = "tag_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketReplicationRuleFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketReplicationRuleFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketReplicationRuleFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 and_: Optional['outputs.BucketReplicationRuleAndOperator'] = None,
                 prefix: Optional[str] = None,
                 tag_filter: Optional['outputs.BucketTagFilter'] = None):
        """
        A filter that identifies the subset of objects to which the replication rule applies. A ``Filter`` must specify exactly one ``Prefix``, ``TagFilter``, or an ``And`` child element.
        :param 'BucketReplicationRuleAndOperator' and_: A container for specifying rule filters. The filters determine the subset of objects to which the rule applies. This element is required only if you specify more than one filter. For example: 
                 +  If you specify both a ``Prefix`` and a ``TagFilter``, wrap these filters in an ``And`` tag.
                 +  If you specify a filter based on multiple tags, wrap the ``TagFilter`` elements in an ``And`` tag.
        :param str prefix: An object key name prefix that identifies the subset of objects to which the rule applies.
                 Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
        :param 'BucketTagFilter' tag_filter: A container for specifying a tag key and value. 
                The rule applies only to objects that have the tag in their tag set.
        """
        if and_ is not None:
            pulumi.set(__self__, "and_", and_)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tag_filter is not None:
            pulumi.set(__self__, "tag_filter", tag_filter)

    @property
    @pulumi.getter(name="and")
    def and_(self) -> Optional['outputs.BucketReplicationRuleAndOperator']:
        """
        A container for specifying rule filters. The filters determine the subset of objects to which the rule applies. This element is required only if you specify more than one filter. For example: 
          +  If you specify both a ``Prefix`` and a ``TagFilter``, wrap these filters in an ``And`` tag.
          +  If you specify a filter based on multiple tags, wrap the ``TagFilter`` elements in an ``And`` tag.
        """
        return pulumi.get(self, "and_")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        An object key name prefix that identifies the subset of objects to which the rule applies.
          Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter(name="tagFilter")
    def tag_filter(self) -> Optional['outputs.BucketTagFilter']:
        """
        A container for specifying a tag key and value. 
         The rule applies only to objects that have the tag in their tag set.
        """
        return pulumi.get(self, "tag_filter")


@pulumi.output_type
class BucketReplicationTime(dict):
    """
    A container specifying S3 Replication Time Control (S3 RTC) related information, including whether S3 RTC is enabled and the time when all objects and operations on objects must be replicated. Must be specified together with a ``Metrics`` block.
    """
    def __init__(__self__, *,
                 status: 'BucketReplicationTimeStatus',
                 time: 'outputs.BucketReplicationTimeValue'):
        """
        A container specifying S3 Replication Time Control (S3 RTC) related information, including whether S3 RTC is enabled and the time when all objects and operations on objects must be replicated. Must be specified together with a ``Metrics`` block.
        :param 'BucketReplicationTimeStatus' status: Specifies whether the replication time is enabled.
        :param 'BucketReplicationTimeValue' time: A container specifying the time by which replication should be complete for all objects and operations on objects.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter
    def status(self) -> 'BucketReplicationTimeStatus':
        """
        Specifies whether the replication time is enabled.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def time(self) -> 'outputs.BucketReplicationTimeValue':
        """
        A container specifying the time by which replication should be complete for all objects and operations on objects.
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class BucketReplicationTimeValue(dict):
    """
    A container specifying the time value for S3 Replication Time Control (S3 RTC) and replication metrics ``EventThreshold``.
    """
    def __init__(__self__, *,
                 minutes: int):
        """
        A container specifying the time value for S3 Replication Time Control (S3 RTC) and replication metrics ``EventThreshold``.
        :param int minutes: Contains an integer specifying time in minutes. 
                 Valid value: 15
        """
        pulumi.set(__self__, "minutes", minutes)

    @property
    @pulumi.getter
    def minutes(self) -> int:
        """
        Contains an integer specifying time in minutes. 
          Valid value: 15
        """
        return pulumi.get(self, "minutes")


@pulumi.output_type
class BucketRoutingRule(dict):
    """
    Specifies the redirect behavior and when a redirect is applied. For more information about routing rules, see [Configuring advanced conditional redirects](https://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html#advanced-conditional-redirects) in the *Amazon S3 User Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "redirectRule":
            suggest = "redirect_rule"
        elif key == "routingRuleCondition":
            suggest = "routing_rule_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketRoutingRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketRoutingRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketRoutingRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 redirect_rule: 'outputs.BucketRedirectRule',
                 routing_rule_condition: Optional['outputs.BucketRoutingRuleCondition'] = None):
        """
        Specifies the redirect behavior and when a redirect is applied. For more information about routing rules, see [Configuring advanced conditional redirects](https://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html#advanced-conditional-redirects) in the *Amazon S3 User Guide*.
        :param 'BucketRedirectRule' redirect_rule: Container for redirect information. You can redirect requests to another host, to another page, or with another protocol. In the event of an error, you can specify a different error code to return.
        :param 'BucketRoutingRuleCondition' routing_rule_condition: A container for describing a condition that must be met for the specified redirect to apply. For example, 1. If request is for pages in the ``/docs`` folder, redirect to the ``/documents`` folder. 2. If request results in HTTP error 4xx, redirect request to another host where you might process the error.
        """
        pulumi.set(__self__, "redirect_rule", redirect_rule)
        if routing_rule_condition is not None:
            pulumi.set(__self__, "routing_rule_condition", routing_rule_condition)

    @property
    @pulumi.getter(name="redirectRule")
    def redirect_rule(self) -> 'outputs.BucketRedirectRule':
        """
        Container for redirect information. You can redirect requests to another host, to another page, or with another protocol. In the event of an error, you can specify a different error code to return.
        """
        return pulumi.get(self, "redirect_rule")

    @property
    @pulumi.getter(name="routingRuleCondition")
    def routing_rule_condition(self) -> Optional['outputs.BucketRoutingRuleCondition']:
        """
        A container for describing a condition that must be met for the specified redirect to apply. For example, 1. If request is for pages in the ``/docs`` folder, redirect to the ``/documents`` folder. 2. If request results in HTTP error 4xx, redirect request to another host where you might process the error.
        """
        return pulumi.get(self, "routing_rule_condition")


@pulumi.output_type
class BucketRoutingRuleCondition(dict):
    """
    A container for describing a condition that must be met for the specified redirect to apply. For example, 1. If request is for pages in the ``/docs`` folder, redirect to the ``/documents`` folder. 2. If request results in HTTP error 4xx, redirect request to another host where you might process the error.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpErrorCodeReturnedEquals":
            suggest = "http_error_code_returned_equals"
        elif key == "keyPrefixEquals":
            suggest = "key_prefix_equals"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketRoutingRuleCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketRoutingRuleCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketRoutingRuleCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_error_code_returned_equals: Optional[str] = None,
                 key_prefix_equals: Optional[str] = None):
        """
        A container for describing a condition that must be met for the specified redirect to apply. For example, 1. If request is for pages in the ``/docs`` folder, redirect to the ``/documents`` folder. 2. If request results in HTTP error 4xx, redirect request to another host where you might process the error.
        :param str http_error_code_returned_equals: The HTTP error code when the redirect is applied. In the event of an error, if the error code equals this value, then the specified redirect is applied.
                Required when parent element ``Condition`` is specified and sibling ``KeyPrefixEquals`` is not specified. If both are specified, then both must be true for the redirect to be applied.
        :param str key_prefix_equals: The object key name prefix when the redirect is applied. For example, to redirect requests for ``ExamplePage.html``, the key prefix will be ``ExamplePage.html``. To redirect request for all pages with the prefix ``docs/``, the key prefix will be ``/docs``, which identifies all objects in the docs/ folder.
                Required when the parent element ``Condition`` is specified and sibling ``HttpErrorCodeReturnedEquals`` is not specified. If both conditions are specified, both must be true for the redirect to be applied.
        """
        if http_error_code_returned_equals is not None:
            pulumi.set(__self__, "http_error_code_returned_equals", http_error_code_returned_equals)
        if key_prefix_equals is not None:
            pulumi.set(__self__, "key_prefix_equals", key_prefix_equals)

    @property
    @pulumi.getter(name="httpErrorCodeReturnedEquals")
    def http_error_code_returned_equals(self) -> Optional[str]:
        """
        The HTTP error code when the redirect is applied. In the event of an error, if the error code equals this value, then the specified redirect is applied.
         Required when parent element ``Condition`` is specified and sibling ``KeyPrefixEquals`` is not specified. If both are specified, then both must be true for the redirect to be applied.
        """
        return pulumi.get(self, "http_error_code_returned_equals")

    @property
    @pulumi.getter(name="keyPrefixEquals")
    def key_prefix_equals(self) -> Optional[str]:
        """
        The object key name prefix when the redirect is applied. For example, to redirect requests for ``ExamplePage.html``, the key prefix will be ``ExamplePage.html``. To redirect request for all pages with the prefix ``docs/``, the key prefix will be ``/docs``, which identifies all objects in the docs/ folder.
         Required when the parent element ``Condition`` is specified and sibling ``HttpErrorCodeReturnedEquals`` is not specified. If both conditions are specified, both must be true for the redirect to be applied.
        """
        return pulumi.get(self, "key_prefix_equals")


@pulumi.output_type
class BucketRule(dict):
    """
    Specifies lifecycle rules for an Amazon S3 bucket. For more information, see [Put Bucket Lifecycle Configuration](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlifecycle.html) in the *Amazon S3 API Reference*.
     You must specify at least one of the following properties: ``AbortIncompleteMultipartUpload``, ``ExpirationDate``, ``ExpirationInDays``, ``NoncurrentVersionExpirationInDays``, ``NoncurrentVersionTransition``, ``NoncurrentVersionTransitions``, ``Transition``, or ``Transitions``.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "abortIncompleteMultipartUpload":
            suggest = "abort_incomplete_multipart_upload"
        elif key == "expirationDate":
            suggest = "expiration_date"
        elif key == "expirationInDays":
            suggest = "expiration_in_days"
        elif key == "expiredObjectDeleteMarker":
            suggest = "expired_object_delete_marker"
        elif key == "noncurrentVersionExpiration":
            suggest = "noncurrent_version_expiration"
        elif key == "noncurrentVersionExpirationInDays":
            suggest = "noncurrent_version_expiration_in_days"
        elif key == "noncurrentVersionTransition":
            suggest = "noncurrent_version_transition"
        elif key == "noncurrentVersionTransitions":
            suggest = "noncurrent_version_transitions"
        elif key == "objectSizeGreaterThan":
            suggest = "object_size_greater_than"
        elif key == "objectSizeLessThan":
            suggest = "object_size_less_than"
        elif key == "tagFilters":
            suggest = "tag_filters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: 'BucketRuleStatus',
                 abort_incomplete_multipart_upload: Optional['outputs.BucketAbortIncompleteMultipartUpload'] = None,
                 expiration_date: Optional[str] = None,
                 expiration_in_days: Optional[int] = None,
                 expired_object_delete_marker: Optional[bool] = None,
                 id: Optional[str] = None,
                 noncurrent_version_expiration: Optional['outputs.BucketNoncurrentVersionExpiration'] = None,
                 noncurrent_version_expiration_in_days: Optional[int] = None,
                 noncurrent_version_transition: Optional['outputs.BucketNoncurrentVersionTransition'] = None,
                 noncurrent_version_transitions: Optional[Sequence['outputs.BucketNoncurrentVersionTransition']] = None,
                 object_size_greater_than: Optional[str] = None,
                 object_size_less_than: Optional[str] = None,
                 prefix: Optional[str] = None,
                 tag_filters: Optional[Sequence['outputs.BucketTagFilter']] = None,
                 transition: Optional['outputs.BucketTransition'] = None,
                 transitions: Optional[Sequence['outputs.BucketTransition']] = None):
        """
        Specifies lifecycle rules for an Amazon S3 bucket. For more information, see [Put Bucket Lifecycle Configuration](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlifecycle.html) in the *Amazon S3 API Reference*.
         You must specify at least one of the following properties: ``AbortIncompleteMultipartUpload``, ``ExpirationDate``, ``ExpirationInDays``, ``NoncurrentVersionExpirationInDays``, ``NoncurrentVersionTransition``, ``NoncurrentVersionTransitions``, ``Transition``, or ``Transitions``.
        :param 'BucketRuleStatus' status: If ``Enabled``, the rule is currently being applied. If ``Disabled``, the rule is not currently being applied.
        :param 'BucketAbortIncompleteMultipartUpload' abort_incomplete_multipart_upload: Specifies a lifecycle rule that stops incomplete multipart uploads to an Amazon S3 bucket.
        :param str expiration_date: Indicates when objects are deleted from Amazon S3 and Amazon S3 Glacier. The date value must be in ISO 8601 format. The time is always midnight UTC. If you specify an expiration and transition time, you must use the same time unit for both properties (either in days or by date). The expiration time must also be later than the transition time.
        :param int expiration_in_days: Indicates the number of days after creation when objects are deleted from Amazon S3 and Amazon S3 Glacier. If you specify an expiration and transition time, you must use the same time unit for both properties (either in days or by date). The expiration time must also be later than the transition time.
        :param bool expired_object_delete_marker: Indicates whether Amazon S3 will remove a delete marker without any noncurrent versions. If set to true, the delete marker will be removed if there are no noncurrent versions. This cannot be specified with ``ExpirationInDays``, ``ExpirationDate``, or ``TagFilters``.
        :param str id: Unique identifier for the rule. The value can't be longer than 255 characters.
        :param 'BucketNoncurrentVersionExpiration' noncurrent_version_expiration: Specifies when noncurrent object versions expire. Upon expiration, S3 permanently deletes the noncurrent object versions. You set this lifecycle configuration action on a bucket that has versioning enabled (or suspended) to request that S3 delete noncurrent object versions at a specific period in the object's lifetime.
        :param int noncurrent_version_expiration_in_days: (Deprecated.) For buckets with versioning enabled (or suspended), specifies the time, in days, between when a new version of the object is uploaded to the bucket and when old versions of the object expire. When object versions expire, Amazon S3 permanently deletes them. If you specify a transition and expiration time, the expiration time must be later than the transition time.
        :param 'BucketNoncurrentVersionTransition' noncurrent_version_transition: (Deprecated.) For buckets with versioning enabled (or suspended), specifies when non-current objects transition to a specified storage class. If you specify a transition and expiration time, the expiration time must be later than the transition time. If you specify this property, don't specify the ``NoncurrentVersionTransitions`` property.
        :param Sequence['BucketNoncurrentVersionTransition'] noncurrent_version_transitions: For buckets with versioning enabled (or suspended), one or more transition rules that specify when non-current objects transition to a specified storage class. If you specify a transition and expiration time, the expiration time must be later than the transition time. If you specify this property, don't specify the ``NoncurrentVersionTransition`` property.
        :param str object_size_greater_than: Specifies the minimum object size in bytes for this rule to apply to. Objects must be larger than this value in bytes. For more information about size based rules, see [Lifecycle configuration using size-based rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/lifecycle-configuration-examples.html#lc-size-rules) in the *Amazon S3 User Guide*.
        :param str object_size_less_than: Specifies the maximum object size in bytes for this rule to apply to. Objects must be smaller than this value in bytes. For more information about sized based rules, see [Lifecycle configuration using size-based rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/lifecycle-configuration-examples.html#lc-size-rules) in the *Amazon S3 User Guide*.
        :param str prefix: Object key prefix that identifies one or more objects to which this rule applies.
                 Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
        :param Sequence['BucketTagFilter'] tag_filters: Tags to use to identify a subset of objects to which the lifecycle rule applies.
        :param 'BucketTransition' transition: (Deprecated.) Specifies when an object transitions to a specified storage class. If you specify an expiration and transition time, you must use the same time unit for both properties (either in days or by date). The expiration time must also be later than the transition time. If you specify this property, don't specify the ``Transitions`` property.
        :param Sequence['BucketTransition'] transitions: One or more transition rules that specify when an object transitions to a specified storage class. If you specify an expiration and transition time, you must use the same time unit for both properties (either in days or by date). The expiration time must also be later than the transition time. If you specify this property, don't specify the ``Transition`` property.
        """
        pulumi.set(__self__, "status", status)
        if abort_incomplete_multipart_upload is not None:
            pulumi.set(__self__, "abort_incomplete_multipart_upload", abort_incomplete_multipart_upload)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if expiration_in_days is not None:
            pulumi.set(__self__, "expiration_in_days", expiration_in_days)
        if expired_object_delete_marker is not None:
            pulumi.set(__self__, "expired_object_delete_marker", expired_object_delete_marker)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if noncurrent_version_expiration is not None:
            pulumi.set(__self__, "noncurrent_version_expiration", noncurrent_version_expiration)
        if noncurrent_version_expiration_in_days is not None:
            pulumi.set(__self__, "noncurrent_version_expiration_in_days", noncurrent_version_expiration_in_days)
        if noncurrent_version_transition is not None:
            pulumi.set(__self__, "noncurrent_version_transition", noncurrent_version_transition)
        if noncurrent_version_transitions is not None:
            pulumi.set(__self__, "noncurrent_version_transitions", noncurrent_version_transitions)
        if object_size_greater_than is not None:
            pulumi.set(__self__, "object_size_greater_than", object_size_greater_than)
        if object_size_less_than is not None:
            pulumi.set(__self__, "object_size_less_than", object_size_less_than)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tag_filters is not None:
            pulumi.set(__self__, "tag_filters", tag_filters)
        if transition is not None:
            pulumi.set(__self__, "transition", transition)
        if transitions is not None:
            pulumi.set(__self__, "transitions", transitions)

    @property
    @pulumi.getter
    def status(self) -> 'BucketRuleStatus':
        """
        If ``Enabled``, the rule is currently being applied. If ``Disabled``, the rule is not currently being applied.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="abortIncompleteMultipartUpload")
    def abort_incomplete_multipart_upload(self) -> Optional['outputs.BucketAbortIncompleteMultipartUpload']:
        """
        Specifies a lifecycle rule that stops incomplete multipart uploads to an Amazon S3 bucket.
        """
        return pulumi.get(self, "abort_incomplete_multipart_upload")

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[str]:
        """
        Indicates when objects are deleted from Amazon S3 and Amazon S3 Glacier. The date value must be in ISO 8601 format. The time is always midnight UTC. If you specify an expiration and transition time, you must use the same time unit for both properties (either in days or by date). The expiration time must also be later than the transition time.
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter(name="expirationInDays")
    def expiration_in_days(self) -> Optional[int]:
        """
        Indicates the number of days after creation when objects are deleted from Amazon S3 and Amazon S3 Glacier. If you specify an expiration and transition time, you must use the same time unit for both properties (either in days or by date). The expiration time must also be later than the transition time.
        """
        return pulumi.get(self, "expiration_in_days")

    @property
    @pulumi.getter(name="expiredObjectDeleteMarker")
    def expired_object_delete_marker(self) -> Optional[bool]:
        """
        Indicates whether Amazon S3 will remove a delete marker without any noncurrent versions. If set to true, the delete marker will be removed if there are no noncurrent versions. This cannot be specified with ``ExpirationInDays``, ``ExpirationDate``, or ``TagFilters``.
        """
        return pulumi.get(self, "expired_object_delete_marker")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier for the rule. The value can't be longer than 255 characters.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="noncurrentVersionExpiration")
    def noncurrent_version_expiration(self) -> Optional['outputs.BucketNoncurrentVersionExpiration']:
        """
        Specifies when noncurrent object versions expire. Upon expiration, S3 permanently deletes the noncurrent object versions. You set this lifecycle configuration action on a bucket that has versioning enabled (or suspended) to request that S3 delete noncurrent object versions at a specific period in the object's lifetime.
        """
        return pulumi.get(self, "noncurrent_version_expiration")

    @property
    @pulumi.getter(name="noncurrentVersionExpirationInDays")
    def noncurrent_version_expiration_in_days(self) -> Optional[int]:
        """
        (Deprecated.) For buckets with versioning enabled (or suspended), specifies the time, in days, between when a new version of the object is uploaded to the bucket and when old versions of the object expire. When object versions expire, Amazon S3 permanently deletes them. If you specify a transition and expiration time, the expiration time must be later than the transition time.
        """
        return pulumi.get(self, "noncurrent_version_expiration_in_days")

    @property
    @pulumi.getter(name="noncurrentVersionTransition")
    def noncurrent_version_transition(self) -> Optional['outputs.BucketNoncurrentVersionTransition']:
        """
        (Deprecated.) For buckets with versioning enabled (or suspended), specifies when non-current objects transition to a specified storage class. If you specify a transition and expiration time, the expiration time must be later than the transition time. If you specify this property, don't specify the ``NoncurrentVersionTransitions`` property.
        """
        return pulumi.get(self, "noncurrent_version_transition")

    @property
    @pulumi.getter(name="noncurrentVersionTransitions")
    def noncurrent_version_transitions(self) -> Optional[Sequence['outputs.BucketNoncurrentVersionTransition']]:
        """
        For buckets with versioning enabled (or suspended), one or more transition rules that specify when non-current objects transition to a specified storage class. If you specify a transition and expiration time, the expiration time must be later than the transition time. If you specify this property, don't specify the ``NoncurrentVersionTransition`` property.
        """
        return pulumi.get(self, "noncurrent_version_transitions")

    @property
    @pulumi.getter(name="objectSizeGreaterThan")
    def object_size_greater_than(self) -> Optional[str]:
        """
        Specifies the minimum object size in bytes for this rule to apply to. Objects must be larger than this value in bytes. For more information about size based rules, see [Lifecycle configuration using size-based rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/lifecycle-configuration-examples.html#lc-size-rules) in the *Amazon S3 User Guide*.
        """
        return pulumi.get(self, "object_size_greater_than")

    @property
    @pulumi.getter(name="objectSizeLessThan")
    def object_size_less_than(self) -> Optional[str]:
        """
        Specifies the maximum object size in bytes for this rule to apply to. Objects must be smaller than this value in bytes. For more information about sized based rules, see [Lifecycle configuration using size-based rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/lifecycle-configuration-examples.html#lc-size-rules) in the *Amazon S3 User Guide*.
        """
        return pulumi.get(self, "object_size_less_than")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Object key prefix that identifies one or more objects to which this rule applies.
          Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter(name="tagFilters")
    def tag_filters(self) -> Optional[Sequence['outputs.BucketTagFilter']]:
        """
        Tags to use to identify a subset of objects to which the lifecycle rule applies.
        """
        return pulumi.get(self, "tag_filters")

    @property
    @pulumi.getter
    def transition(self) -> Optional['outputs.BucketTransition']:
        """
        (Deprecated.) Specifies when an object transitions to a specified storage class. If you specify an expiration and transition time, you must use the same time unit for both properties (either in days or by date). The expiration time must also be later than the transition time. If you specify this property, don't specify the ``Transitions`` property.
        """
        return pulumi.get(self, "transition")

    @property
    @pulumi.getter
    def transitions(self) -> Optional[Sequence['outputs.BucketTransition']]:
        """
        One or more transition rules that specify when an object transitions to a specified storage class. If you specify an expiration and transition time, you must use the same time unit for both properties (either in days or by date). The expiration time must also be later than the transition time. If you specify this property, don't specify the ``Transition`` property.
        """
        return pulumi.get(self, "transitions")


@pulumi.output_type
class BucketS3KeyFilter(dict):
    """
    A container for object key name prefix and suffix filtering rules. For more information about object key name filtering, see [Configuring event notifications using object key name filtering](https://docs.aws.amazon.com/AmazonS3/latest/userguide/notification-how-to-filtering.html) in the *Amazon S3 User Guide*.
      The same type of filter rule cannot be used more than once. For example, you cannot specify two prefix rules.
    """
    def __init__(__self__, *,
                 rules: Sequence['outputs.BucketFilterRule']):
        """
        A container for object key name prefix and suffix filtering rules. For more information about object key name filtering, see [Configuring event notifications using object key name filtering](https://docs.aws.amazon.com/AmazonS3/latest/userguide/notification-how-to-filtering.html) in the *Amazon S3 User Guide*.
          The same type of filter rule cannot be used more than once. For example, you cannot specify two prefix rules.
        :param Sequence['BucketFilterRule'] rules: A list of containers for the key-value pair that defines the criteria for the filter rule.
        """
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.BucketFilterRule']:
        """
        A list of containers for the key-value pair that defines the criteria for the filter rule.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class BucketServerSideEncryptionByDefault(dict):
    """
    Describes the default server-side encryption to apply to new objects in the bucket. If a PUT Object request doesn't specify any server-side encryption, this default encryption will be applied. If you don't specify a customer managed key at configuration, Amazon S3 automatically creates an AWS KMS key in your AWS account the first time that you add an object encrypted with SSE-KMS to a bucket. By default, Amazon S3 uses this KMS key for SSE-KMS. For more information, see [PUT Bucket encryption](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTencryption.html) in the *Amazon S3 API Reference*.
      If you're specifying a customer managed KMS key, we recommend using a fully qualified KMS key ARN. If you use a KMS key alias instead, then KMS resolves the key within the requester’s account. This behavior can result in data that's encrypted with a KMS key that belongs to the requester, and not the bucket owner.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sseAlgorithm":
            suggest = "sse_algorithm"
        elif key == "kmsMasterKeyId":
            suggest = "kms_master_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketServerSideEncryptionByDefault. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketServerSideEncryptionByDefault.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketServerSideEncryptionByDefault.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sse_algorithm: 'BucketServerSideEncryptionByDefaultSseAlgorithm',
                 kms_master_key_id: Optional[str] = None):
        """
        Describes the default server-side encryption to apply to new objects in the bucket. If a PUT Object request doesn't specify any server-side encryption, this default encryption will be applied. If you don't specify a customer managed key at configuration, Amazon S3 automatically creates an AWS KMS key in your AWS account the first time that you add an object encrypted with SSE-KMS to a bucket. By default, Amazon S3 uses this KMS key for SSE-KMS. For more information, see [PUT Bucket encryption](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTencryption.html) in the *Amazon S3 API Reference*.
          If you're specifying a customer managed KMS key, we recommend using a fully qualified KMS key ARN. If you use a KMS key alias instead, then KMS resolves the key within the requester’s account. This behavior can result in data that's encrypted with a KMS key that belongs to the requester, and not the bucket owner.
        :param 'BucketServerSideEncryptionByDefaultSseAlgorithm' sse_algorithm: Server-side encryption algorithm to use for the default encryption.
        :param str kms_master_key_id: AWS Key Management Service (KMS) customer AWS KMS key ID to use for the default encryption. This parameter is allowed if and only if ``SSEAlgorithm`` is set to ``aws:kms`` or ``aws:kms:dsse``.
                You can specify the key ID, key alias, or the Amazon Resource Name (ARN) of the KMS key.
                 +  Key ID: ``1234abcd-12ab-34cd-56ef-1234567890ab`` 
                 +  Key ARN: ``arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`` 
                 +  Key Alias: ``alias/alias-name`` 
                 
                If you use a key ID, you can run into a LogDestination undeliverable error when creating a VPC flow log. 
                If you are using encryption with cross-account or AWS service operations you must use a fully qualified KMS key ARN. For more information, see [Using encryption for cross-account operations](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html#bucket-encryption-update-bucket-policy).
                 Amazon S3 only supports symmetric encryption KMS keys. For more information, see [Asymmetric keys in KMS](https://docs.aws.amazon.com//kms/latest/developerguide/symmetric-asymmetric.html) in the *Key Management Service Developer Guide*.
        """
        pulumi.set(__self__, "sse_algorithm", sse_algorithm)
        if kms_master_key_id is not None:
            pulumi.set(__self__, "kms_master_key_id", kms_master_key_id)

    @property
    @pulumi.getter(name="sseAlgorithm")
    def sse_algorithm(self) -> 'BucketServerSideEncryptionByDefaultSseAlgorithm':
        """
        Server-side encryption algorithm to use for the default encryption.
        """
        return pulumi.get(self, "sse_algorithm")

    @property
    @pulumi.getter(name="kmsMasterKeyId")
    def kms_master_key_id(self) -> Optional[str]:
        """
        AWS Key Management Service (KMS) customer AWS KMS key ID to use for the default encryption. This parameter is allowed if and only if ``SSEAlgorithm`` is set to ``aws:kms`` or ``aws:kms:dsse``.
         You can specify the key ID, key alias, or the Amazon Resource Name (ARN) of the KMS key.
          +  Key ID: ``1234abcd-12ab-34cd-56ef-1234567890ab`` 
          +  Key ARN: ``arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`` 
          +  Key Alias: ``alias/alias-name`` 
          
         If you use a key ID, you can run into a LogDestination undeliverable error when creating a VPC flow log. 
         If you are using encryption with cross-account or AWS service operations you must use a fully qualified KMS key ARN. For more information, see [Using encryption for cross-account operations](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html#bucket-encryption-update-bucket-policy).
          Amazon S3 only supports symmetric encryption KMS keys. For more information, see [Asymmetric keys in KMS](https://docs.aws.amazon.com//kms/latest/developerguide/symmetric-asymmetric.html) in the *Key Management Service Developer Guide*.
        """
        return pulumi.get(self, "kms_master_key_id")


@pulumi.output_type
class BucketServerSideEncryptionRule(dict):
    """
    Specifies the default server-side encryption configuration.
      If you're specifying a customer managed KMS key, we recommend using a fully qualified KMS key ARN. If you use a KMS key alias instead, then KMS resolves the key within the requester’s account. This behavior can result in data that's encrypted with a KMS key that belongs to the requester, and not the bucket owner.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketKeyEnabled":
            suggest = "bucket_key_enabled"
        elif key == "serverSideEncryptionByDefault":
            suggest = "server_side_encryption_by_default"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketServerSideEncryptionRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketServerSideEncryptionRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketServerSideEncryptionRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_key_enabled: Optional[bool] = None,
                 server_side_encryption_by_default: Optional['outputs.BucketServerSideEncryptionByDefault'] = None):
        """
        Specifies the default server-side encryption configuration.
          If you're specifying a customer managed KMS key, we recommend using a fully qualified KMS key ARN. If you use a KMS key alias instead, then KMS resolves the key within the requester’s account. This behavior can result in data that's encrypted with a KMS key that belongs to the requester, and not the bucket owner.
        :param bool bucket_key_enabled: Specifies whether Amazon S3 should use an S3 Bucket Key with server-side encryption using KMS (SSE-KMS) for new objects in the bucket. Existing objects are not affected. Setting the ``BucketKeyEnabled`` element to ``true`` causes Amazon S3 to use an S3 Bucket Key. By default, S3 Bucket Key is not enabled.
                For more information, see [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) in the *Amazon S3 User Guide*.
        :param 'BucketServerSideEncryptionByDefault' server_side_encryption_by_default: Specifies the default server-side encryption to apply to new objects in the bucket. If a PUT Object request doesn't specify any server-side encryption, this default encryption will be applied.
        """
        if bucket_key_enabled is not None:
            pulumi.set(__self__, "bucket_key_enabled", bucket_key_enabled)
        if server_side_encryption_by_default is not None:
            pulumi.set(__self__, "server_side_encryption_by_default", server_side_encryption_by_default)

    @property
    @pulumi.getter(name="bucketKeyEnabled")
    def bucket_key_enabled(self) -> Optional[bool]:
        """
        Specifies whether Amazon S3 should use an S3 Bucket Key with server-side encryption using KMS (SSE-KMS) for new objects in the bucket. Existing objects are not affected. Setting the ``BucketKeyEnabled`` element to ``true`` causes Amazon S3 to use an S3 Bucket Key. By default, S3 Bucket Key is not enabled.
         For more information, see [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) in the *Amazon S3 User Guide*.
        """
        return pulumi.get(self, "bucket_key_enabled")

    @property
    @pulumi.getter(name="serverSideEncryptionByDefault")
    def server_side_encryption_by_default(self) -> Optional['outputs.BucketServerSideEncryptionByDefault']:
        """
        Specifies the default server-side encryption to apply to new objects in the bucket. If a PUT Object request doesn't specify any server-side encryption, this default encryption will be applied.
        """
        return pulumi.get(self, "server_side_encryption_by_default")


@pulumi.output_type
class BucketSourceSelectionCriteria(dict):
    """
    A container that describes additional filters for identifying the source objects that you want to replicate. You can choose to enable or disable the replication of these objects.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "replicaModifications":
            suggest = "replica_modifications"
        elif key == "sseKmsEncryptedObjects":
            suggest = "sse_kms_encrypted_objects"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketSourceSelectionCriteria. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketSourceSelectionCriteria.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketSourceSelectionCriteria.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 replica_modifications: Optional['outputs.BucketReplicaModifications'] = None,
                 sse_kms_encrypted_objects: Optional['outputs.BucketSseKmsEncryptedObjects'] = None):
        """
        A container that describes additional filters for identifying the source objects that you want to replicate. You can choose to enable or disable the replication of these objects.
        :param 'BucketReplicaModifications' replica_modifications: A filter that you can specify for selection for modifications on replicas.
        :param 'BucketSseKmsEncryptedObjects' sse_kms_encrypted_objects: A container for filter information for the selection of Amazon S3 objects encrypted with AWS KMS.
        """
        if replica_modifications is not None:
            pulumi.set(__self__, "replica_modifications", replica_modifications)
        if sse_kms_encrypted_objects is not None:
            pulumi.set(__self__, "sse_kms_encrypted_objects", sse_kms_encrypted_objects)

    @property
    @pulumi.getter(name="replicaModifications")
    def replica_modifications(self) -> Optional['outputs.BucketReplicaModifications']:
        """
        A filter that you can specify for selection for modifications on replicas.
        """
        return pulumi.get(self, "replica_modifications")

    @property
    @pulumi.getter(name="sseKmsEncryptedObjects")
    def sse_kms_encrypted_objects(self) -> Optional['outputs.BucketSseKmsEncryptedObjects']:
        """
        A container for filter information for the selection of Amazon S3 objects encrypted with AWS KMS.
        """
        return pulumi.get(self, "sse_kms_encrypted_objects")


@pulumi.output_type
class BucketSseKmsEncryptedObjects(dict):
    """
    A container for filter information for the selection of S3 objects encrypted with AWS KMS.
    """
    def __init__(__self__, *,
                 status: 'BucketSseKmsEncryptedObjectsStatus'):
        """
        A container for filter information for the selection of S3 objects encrypted with AWS KMS.
        :param 'BucketSseKmsEncryptedObjectsStatus' status: Specifies whether Amazon S3 replicates objects created with server-side encryption using an AWS KMS key stored in AWS Key Management Service.
        """
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> 'BucketSseKmsEncryptedObjectsStatus':
        """
        Specifies whether Amazon S3 replicates objects created with server-side encryption using an AWS KMS key stored in AWS Key Management Service.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class BucketStorageClassAnalysis(dict):
    """
    Specifies data related to access patterns to be collected and made available to analyze the tradeoffs between different storage classes for an Amazon S3 bucket.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataExport":
            suggest = "data_export"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketStorageClassAnalysis. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketStorageClassAnalysis.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketStorageClassAnalysis.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_export: Optional['outputs.BucketDataExport'] = None):
        """
        Specifies data related to access patterns to be collected and made available to analyze the tradeoffs between different storage classes for an Amazon S3 bucket.
        :param 'BucketDataExport' data_export: Specifies how data related to the storage class analysis for an Amazon S3 bucket should be exported.
        """
        if data_export is not None:
            pulumi.set(__self__, "data_export", data_export)

    @property
    @pulumi.getter(name="dataExport")
    def data_export(self) -> Optional['outputs.BucketDataExport']:
        """
        Specifies how data related to the storage class analysis for an Amazon S3 bucket should be exported.
        """
        return pulumi.get(self, "data_export")


@pulumi.output_type
class BucketTagFilter(dict):
    """
    Specifies tags to use to identify a subset of objects for an Amazon S3 bucket.
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        Specifies tags to use to identify a subset of objects for an Amazon S3 bucket.
        :param str key: The tag key.
        :param str value: The tag value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The tag key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The tag value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class BucketTargetObjectKeyFormat(dict):
    """
    Describes the key format for server access log file in the target bucket. You can choose between SimplePrefix and PartitionedPrefix.
    """
    def __init__(__self__):
        """
        Describes the key format for server access log file in the target bucket. You can choose between SimplePrefix and PartitionedPrefix.
        """
        pass


@pulumi.output_type
class BucketTiering(dict):
    """
    The S3 Intelligent-Tiering storage class is designed to optimize storage costs by automatically moving data to the most cost-effective storage access tier, without additional operational overhead.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessTier":
            suggest = "access_tier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketTiering. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketTiering.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketTiering.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_tier: 'BucketTieringAccessTier',
                 days: int):
        """
        The S3 Intelligent-Tiering storage class is designed to optimize storage costs by automatically moving data to the most cost-effective storage access tier, without additional operational overhead.
        :param 'BucketTieringAccessTier' access_tier: S3 Intelligent-Tiering access tier. See [Storage class for automatically optimizing frequently and infrequently accessed objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access) for a list of access tiers in the S3 Intelligent-Tiering storage class.
        :param int days: The number of consecutive days of no access after which an object will be eligible to be transitioned to the corresponding tier. The minimum number of days specified for Archive Access tier must be at least 90 days and Deep Archive Access tier must be at least 180 days. The maximum can be up to 2 years (730 days).
        """
        pulumi.set(__self__, "access_tier", access_tier)
        pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter(name="accessTier")
    def access_tier(self) -> 'BucketTieringAccessTier':
        """
        S3 Intelligent-Tiering access tier. See [Storage class for automatically optimizing frequently and infrequently accessed objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access) for a list of access tiers in the S3 Intelligent-Tiering storage class.
        """
        return pulumi.get(self, "access_tier")

    @property
    @pulumi.getter
    def days(self) -> int:
        """
        The number of consecutive days of no access after which an object will be eligible to be transitioned to the corresponding tier. The minimum number of days specified for Archive Access tier must be at least 90 days and Deep Archive Access tier must be at least 180 days. The maximum can be up to 2 years (730 days).
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class BucketTopicConfiguration(dict):
    """
    A container for specifying the configuration for publication of messages to an Amazon Simple Notification Service (Amazon SNS) topic when Amazon S3 detects specified events.
    """
    def __init__(__self__, *,
                 event: str,
                 topic: str,
                 filter: Optional['outputs.BucketNotificationFilter'] = None):
        """
        A container for specifying the configuration for publication of messages to an Amazon Simple Notification Service (Amazon SNS) topic when Amazon S3 detects specified events.
        :param str event: The Amazon S3 bucket event about which to send notifications. For more information, see [Supported Event Types](https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html) in the *Amazon S3 User Guide*.
        :param str topic: The Amazon Resource Name (ARN) of the Amazon SNS topic to which Amazon S3 publishes a message when it detects events of the specified type.
        :param 'BucketNotificationFilter' filter: The filtering rules that determine for which objects to send notifications. For example, you can create a filter so that Amazon S3 sends notifications only when image files with a ``.jpg`` extension are added to the bucket.
        """
        pulumi.set(__self__, "event", event)
        pulumi.set(__self__, "topic", topic)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)

    @property
    @pulumi.getter
    def event(self) -> str:
        """
        The Amazon S3 bucket event about which to send notifications. For more information, see [Supported Event Types](https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html) in the *Amazon S3 User Guide*.
        """
        return pulumi.get(self, "event")

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        The Amazon Resource Name (ARN) of the Amazon SNS topic to which Amazon S3 publishes a message when it detects events of the specified type.
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.BucketNotificationFilter']:
        """
        The filtering rules that determine for which objects to send notifications. For example, you can create a filter so that Amazon S3 sends notifications only when image files with a ``.jpg`` extension are added to the bucket.
        """
        return pulumi.get(self, "filter")


@pulumi.output_type
class BucketTransition(dict):
    """
    Specifies when an object transitions to a specified storage class. For more information about Amazon S3 lifecycle configuration rules, see [Transitioning Objects Using Amazon S3 Lifecycle](https://docs.aws.amazon.com/AmazonS3/latest/dev/lifecycle-transition-general-considerations.html) in the *Amazon S3 User Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClass":
            suggest = "storage_class"
        elif key == "transitionDate":
            suggest = "transition_date"
        elif key == "transitionInDays":
            suggest = "transition_in_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketTransition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketTransition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketTransition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_class: 'BucketTransitionStorageClass',
                 transition_date: Optional[str] = None,
                 transition_in_days: Optional[int] = None):
        """
        Specifies when an object transitions to a specified storage class. For more information about Amazon S3 lifecycle configuration rules, see [Transitioning Objects Using Amazon S3 Lifecycle](https://docs.aws.amazon.com/AmazonS3/latest/dev/lifecycle-transition-general-considerations.html) in the *Amazon S3 User Guide*.
        :param 'BucketTransitionStorageClass' storage_class: The storage class to which you want the object to transition.
        :param str transition_date: Indicates when objects are transitioned to the specified storage class. The date value must be in ISO 8601 format. The time is always midnight UTC.
        :param int transition_in_days: Indicates the number of days after creation when objects are transitioned to the specified storage class. The value must be a positive integer.
        """
        pulumi.set(__self__, "storage_class", storage_class)
        if transition_date is not None:
            pulumi.set(__self__, "transition_date", transition_date)
        if transition_in_days is not None:
            pulumi.set(__self__, "transition_in_days", transition_in_days)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> 'BucketTransitionStorageClass':
        """
        The storage class to which you want the object to transition.
        """
        return pulumi.get(self, "storage_class")

    @property
    @pulumi.getter(name="transitionDate")
    def transition_date(self) -> Optional[str]:
        """
        Indicates when objects are transitioned to the specified storage class. The date value must be in ISO 8601 format. The time is always midnight UTC.
        """
        return pulumi.get(self, "transition_date")

    @property
    @pulumi.getter(name="transitionInDays")
    def transition_in_days(self) -> Optional[int]:
        """
        Indicates the number of days after creation when objects are transitioned to the specified storage class. The value must be a positive integer.
        """
        return pulumi.get(self, "transition_in_days")


@pulumi.output_type
class BucketVersioningConfiguration(dict):
    """
    Describes the versioning state of an Amazon S3 bucket. For more information, see [PUT Bucket versioning](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTVersioningStatus.html) in the *Amazon S3 API Reference*.
      When you enable versioning on a bucket for the first time, it might take a short amount of time for the change to be fully propagated. We recommend that you wait for 15 minutes after enabling versioning before issuing write operations (``PUT`` or ``DELETE``) on objects in the bucket.
    """
    def __init__(__self__, *,
                 status: 'BucketVersioningConfigurationStatus'):
        """
        Describes the versioning state of an Amazon S3 bucket. For more information, see [PUT Bucket versioning](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTVersioningStatus.html) in the *Amazon S3 API Reference*.
          When you enable versioning on a bucket for the first time, it might take a short amount of time for the change to be fully propagated. We recommend that you wait for 15 minutes after enabling versioning before issuing write operations (``PUT`` or ``DELETE``) on objects in the bucket.
        :param 'BucketVersioningConfigurationStatus' status: The versioning state of the bucket.
        """
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> 'BucketVersioningConfigurationStatus':
        """
        The versioning state of the bucket.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class BucketWebsiteConfiguration(dict):
    """
    Specifies website configuration parameters for an Amazon S3 bucket.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorDocument":
            suggest = "error_document"
        elif key == "indexDocument":
            suggest = "index_document"
        elif key == "redirectAllRequestsTo":
            suggest = "redirect_all_requests_to"
        elif key == "routingRules":
            suggest = "routing_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketWebsiteConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketWebsiteConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketWebsiteConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_document: Optional[str] = None,
                 index_document: Optional[str] = None,
                 redirect_all_requests_to: Optional['outputs.BucketRedirectAllRequestsTo'] = None,
                 routing_rules: Optional[Sequence['outputs.BucketRoutingRule']] = None):
        """
        Specifies website configuration parameters for an Amazon S3 bucket.
        :param str error_document: The name of the error document for the website.
        :param str index_document: The name of the index document for the website.
        :param 'BucketRedirectAllRequestsTo' redirect_all_requests_to: The redirect behavior for every request to this bucket's website endpoint.
                 If you specify this property, you can't specify any other property.
        :param Sequence['BucketRoutingRule'] routing_rules: Rules that define when a redirect is applied and the redirect behavior.
        """
        if error_document is not None:
            pulumi.set(__self__, "error_document", error_document)
        if index_document is not None:
            pulumi.set(__self__, "index_document", index_document)
        if redirect_all_requests_to is not None:
            pulumi.set(__self__, "redirect_all_requests_to", redirect_all_requests_to)
        if routing_rules is not None:
            pulumi.set(__self__, "routing_rules", routing_rules)

    @property
    @pulumi.getter(name="errorDocument")
    def error_document(self) -> Optional[str]:
        """
        The name of the error document for the website.
        """
        return pulumi.get(self, "error_document")

    @property
    @pulumi.getter(name="indexDocument")
    def index_document(self) -> Optional[str]:
        """
        The name of the index document for the website.
        """
        return pulumi.get(self, "index_document")

    @property
    @pulumi.getter(name="redirectAllRequestsTo")
    def redirect_all_requests_to(self) -> Optional['outputs.BucketRedirectAllRequestsTo']:
        """
        The redirect behavior for every request to this bucket's website endpoint.
          If you specify this property, you can't specify any other property.
        """
        return pulumi.get(self, "redirect_all_requests_to")

    @property
    @pulumi.getter(name="routingRules")
    def routing_rules(self) -> Optional[Sequence['outputs.BucketRoutingRule']]:
        """
        Rules that define when a redirect is applied and the redirect behavior.
        """
        return pulumi.get(self, "routing_rules")


@pulumi.output_type
class MultiRegionAccessPointPublicAccessBlockConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blockPublicAcls":
            suggest = "block_public_acls"
        elif key == "blockPublicPolicy":
            suggest = "block_public_policy"
        elif key == "ignorePublicAcls":
            suggest = "ignore_public_acls"
        elif key == "restrictPublicBuckets":
            suggest = "restrict_public_buckets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MultiRegionAccessPointPublicAccessBlockConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MultiRegionAccessPointPublicAccessBlockConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MultiRegionAccessPointPublicAccessBlockConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 block_public_acls: Optional[bool] = None,
                 block_public_policy: Optional[bool] = None,
                 ignore_public_acls: Optional[bool] = None,
                 restrict_public_buckets: Optional[bool] = None):
        """
        :param bool block_public_acls: Specifies whether Amazon S3 should block public access control lists (ACLs) for buckets in this account. Setting this element to TRUE causes the following behavior:
               - PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.
                - PUT Object calls fail if the request includes a public ACL.
               . - PUT Bucket calls fail if the request includes a public ACL.
               Enabling this setting doesn't affect existing policies or ACLs.
        :param bool block_public_policy: Specifies whether Amazon S3 should block public bucket policies for buckets in this account. Setting this element to TRUE causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access. Enabling this setting doesn't affect existing bucket policies.
        :param bool ignore_public_acls: Specifies whether Amazon S3 should ignore public ACLs for buckets in this account. Setting this element to TRUE causes Amazon S3 to ignore all public ACLs on buckets in this account and any objects that they contain. Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.
        :param bool restrict_public_buckets: Specifies whether Amazon S3 should restrict public bucket policies for this bucket. Setting this element to TRUE restricts access to this bucket to only AWS services and authorized users within this account if the bucket has a public policy.
               Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.
        """
        if block_public_acls is not None:
            pulumi.set(__self__, "block_public_acls", block_public_acls)
        if block_public_policy is not None:
            pulumi.set(__self__, "block_public_policy", block_public_policy)
        if ignore_public_acls is not None:
            pulumi.set(__self__, "ignore_public_acls", ignore_public_acls)
        if restrict_public_buckets is not None:
            pulumi.set(__self__, "restrict_public_buckets", restrict_public_buckets)

    @property
    @pulumi.getter(name="blockPublicAcls")
    def block_public_acls(self) -> Optional[bool]:
        """
        Specifies whether Amazon S3 should block public access control lists (ACLs) for buckets in this account. Setting this element to TRUE causes the following behavior:
        - PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.
         - PUT Object calls fail if the request includes a public ACL.
        . - PUT Bucket calls fail if the request includes a public ACL.
        Enabling this setting doesn't affect existing policies or ACLs.
        """
        return pulumi.get(self, "block_public_acls")

    @property
    @pulumi.getter(name="blockPublicPolicy")
    def block_public_policy(self) -> Optional[bool]:
        """
        Specifies whether Amazon S3 should block public bucket policies for buckets in this account. Setting this element to TRUE causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access. Enabling this setting doesn't affect existing bucket policies.
        """
        return pulumi.get(self, "block_public_policy")

    @property
    @pulumi.getter(name="ignorePublicAcls")
    def ignore_public_acls(self) -> Optional[bool]:
        """
        Specifies whether Amazon S3 should ignore public ACLs for buckets in this account. Setting this element to TRUE causes Amazon S3 to ignore all public ACLs on buckets in this account and any objects that they contain. Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.
        """
        return pulumi.get(self, "ignore_public_acls")

    @property
    @pulumi.getter(name="restrictPublicBuckets")
    def restrict_public_buckets(self) -> Optional[bool]:
        """
        Specifies whether Amazon S3 should restrict public bucket policies for this bucket. Setting this element to TRUE restricts access to this bucket to only AWS services and authorized users within this account if the bucket has a public policy.
        Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.
        """
        return pulumi.get(self, "restrict_public_buckets")


@pulumi.output_type
class MultiRegionAccessPointRegion(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketAccountId":
            suggest = "bucket_account_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MultiRegionAccessPointRegion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MultiRegionAccessPointRegion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MultiRegionAccessPointRegion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 bucket_account_id: Optional[str] = None):
        """
        :param str bucket: The name of the associated bucket for the Region.
        :param str bucket_account_id: The AWS account ID that owns the Amazon S3 bucket that's associated with this Multi-Region Access Point.
        """
        pulumi.set(__self__, "bucket", bucket)
        if bucket_account_id is not None:
            pulumi.set(__self__, "bucket_account_id", bucket_account_id)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The name of the associated bucket for the Region.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="bucketAccountId")
    def bucket_account_id(self) -> Optional[str]:
        """
        The AWS account ID that owns the Amazon S3 bucket that's associated with this Multi-Region Access Point.
        """
        return pulumi.get(self, "bucket_account_id")


@pulumi.output_type
class PolicyStatusProperties(dict):
    """
    The Policy Status associated with this Multi Region Access Point
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isPublic":
            suggest = "is_public"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyStatusProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyStatusProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyStatusProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_public: 'MultiRegionAccessPointPolicyPolicyStatusPropertiesIsPublic'):
        """
        The Policy Status associated with this Multi Region Access Point
        :param 'MultiRegionAccessPointPolicyPolicyStatusPropertiesIsPublic' is_public: Specifies whether the policy is public or not.
        """
        pulumi.set(__self__, "is_public", is_public)

    @property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> 'MultiRegionAccessPointPolicyPolicyStatusPropertiesIsPublic':
        """
        Specifies whether the policy is public or not.
        """
        return pulumi.get(self, "is_public")


@pulumi.output_type
class StorageLensAccountLevel(dict):
    """
    Account-level metrics configurations.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketLevel":
            suggest = "bucket_level"
        elif key == "activityMetrics":
            suggest = "activity_metrics"
        elif key == "advancedCostOptimizationMetrics":
            suggest = "advanced_cost_optimization_metrics"
        elif key == "advancedDataProtectionMetrics":
            suggest = "advanced_data_protection_metrics"
        elif key == "detailedStatusCodesMetrics":
            suggest = "detailed_status_codes_metrics"
        elif key == "storageLensGroupLevel":
            suggest = "storage_lens_group_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensAccountLevel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensAccountLevel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensAccountLevel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_level: 'outputs.StorageLensBucketLevel',
                 activity_metrics: Optional['outputs.StorageLensActivityMetrics'] = None,
                 advanced_cost_optimization_metrics: Optional['outputs.StorageLensAdvancedCostOptimizationMetrics'] = None,
                 advanced_data_protection_metrics: Optional['outputs.StorageLensAdvancedDataProtectionMetrics'] = None,
                 detailed_status_codes_metrics: Optional['outputs.StorageLensDetailedStatusCodesMetrics'] = None,
                 storage_lens_group_level: Optional['outputs.StorageLensGroupLevel'] = None):
        """
        Account-level metrics configurations.
        :param 'StorageLensBucketLevel' bucket_level: This property contains the details of the account-level bucket-level configurations for Amazon S3 Storage Lens.
        :param 'StorageLensActivityMetrics' activity_metrics: This property contains the details of account-level activity metrics for S3 Storage Lens.
        :param 'StorageLensAdvancedCostOptimizationMetrics' advanced_cost_optimization_metrics: This property contains the details of account-level advanced cost optimization metrics for S3 Storage Lens.
        :param 'StorageLensAdvancedDataProtectionMetrics' advanced_data_protection_metrics: This property contains the details of account-level advanced data protection metrics for S3 Storage Lens.
        :param 'StorageLensDetailedStatusCodesMetrics' detailed_status_codes_metrics: This property contains the details of account-level detailed status code metrics for S3 Storage Lens.
        :param 'StorageLensGroupLevel' storage_lens_group_level: This property determines the scope of Storage Lens group data that is displayed in the Storage Lens dashboard.
        """
        pulumi.set(__self__, "bucket_level", bucket_level)
        if activity_metrics is not None:
            pulumi.set(__self__, "activity_metrics", activity_metrics)
        if advanced_cost_optimization_metrics is not None:
            pulumi.set(__self__, "advanced_cost_optimization_metrics", advanced_cost_optimization_metrics)
        if advanced_data_protection_metrics is not None:
            pulumi.set(__self__, "advanced_data_protection_metrics", advanced_data_protection_metrics)
        if detailed_status_codes_metrics is not None:
            pulumi.set(__self__, "detailed_status_codes_metrics", detailed_status_codes_metrics)
        if storage_lens_group_level is not None:
            pulumi.set(__self__, "storage_lens_group_level", storage_lens_group_level)

    @property
    @pulumi.getter(name="bucketLevel")
    def bucket_level(self) -> 'outputs.StorageLensBucketLevel':
        """
        This property contains the details of the account-level bucket-level configurations for Amazon S3 Storage Lens.
        """
        return pulumi.get(self, "bucket_level")

    @property
    @pulumi.getter(name="activityMetrics")
    def activity_metrics(self) -> Optional['outputs.StorageLensActivityMetrics']:
        """
        This property contains the details of account-level activity metrics for S3 Storage Lens.
        """
        return pulumi.get(self, "activity_metrics")

    @property
    @pulumi.getter(name="advancedCostOptimizationMetrics")
    def advanced_cost_optimization_metrics(self) -> Optional['outputs.StorageLensAdvancedCostOptimizationMetrics']:
        """
        This property contains the details of account-level advanced cost optimization metrics for S3 Storage Lens.
        """
        return pulumi.get(self, "advanced_cost_optimization_metrics")

    @property
    @pulumi.getter(name="advancedDataProtectionMetrics")
    def advanced_data_protection_metrics(self) -> Optional['outputs.StorageLensAdvancedDataProtectionMetrics']:
        """
        This property contains the details of account-level advanced data protection metrics for S3 Storage Lens.
        """
        return pulumi.get(self, "advanced_data_protection_metrics")

    @property
    @pulumi.getter(name="detailedStatusCodesMetrics")
    def detailed_status_codes_metrics(self) -> Optional['outputs.StorageLensDetailedStatusCodesMetrics']:
        """
        This property contains the details of account-level detailed status code metrics for S3 Storage Lens.
        """
        return pulumi.get(self, "detailed_status_codes_metrics")

    @property
    @pulumi.getter(name="storageLensGroupLevel")
    def storage_lens_group_level(self) -> Optional['outputs.StorageLensGroupLevel']:
        """
        This property determines the scope of Storage Lens group data that is displayed in the Storage Lens dashboard.
        """
        return pulumi.get(self, "storage_lens_group_level")


@pulumi.output_type
class StorageLensActivityMetrics(dict):
    """
    Enables activity metrics.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensActivityMetrics. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensActivityMetrics.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensActivityMetrics.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: Optional[bool] = None):
        """
        Enables activity metrics.
        :param bool is_enabled: Specifies whether activity metrics are enabled or disabled.
        """
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        Specifies whether activity metrics are enabled or disabled.
        """
        return pulumi.get(self, "is_enabled")


@pulumi.output_type
class StorageLensAdvancedCostOptimizationMetrics(dict):
    """
    Enables advanced cost optimization metrics.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensAdvancedCostOptimizationMetrics. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensAdvancedCostOptimizationMetrics.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensAdvancedCostOptimizationMetrics.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: Optional[bool] = None):
        """
        Enables advanced cost optimization metrics.
        :param bool is_enabled: Specifies whether advanced cost optimization metrics are enabled or disabled.
        """
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        Specifies whether advanced cost optimization metrics are enabled or disabled.
        """
        return pulumi.get(self, "is_enabled")


@pulumi.output_type
class StorageLensAdvancedDataProtectionMetrics(dict):
    """
    Enables advanced data protection metrics.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensAdvancedDataProtectionMetrics. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensAdvancedDataProtectionMetrics.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensAdvancedDataProtectionMetrics.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: Optional[bool] = None):
        """
        Enables advanced data protection metrics.
        :param bool is_enabled: Specifies whether advanced data protection metrics are enabled or disabled.
        """
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        Specifies whether advanced data protection metrics are enabled or disabled.
        """
        return pulumi.get(self, "is_enabled")


@pulumi.output_type
class StorageLensAwsOrg(dict):
    """
    The AWS Organizations ARN to use in the Amazon S3 Storage Lens configuration.
    """
    def __init__(__self__, *,
                 arn: str):
        """
        The AWS Organizations ARN to use in the Amazon S3 Storage Lens configuration.
        :param str arn: This resource contains the ARN of the AWS Organization.
        """
        pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        This resource contains the ARN of the AWS Organization.
        """
        return pulumi.get(self, "arn")


@pulumi.output_type
class StorageLensBucketLevel(dict):
    """
    Bucket-level metrics configurations.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activityMetrics":
            suggest = "activity_metrics"
        elif key == "advancedCostOptimizationMetrics":
            suggest = "advanced_cost_optimization_metrics"
        elif key == "advancedDataProtectionMetrics":
            suggest = "advanced_data_protection_metrics"
        elif key == "detailedStatusCodesMetrics":
            suggest = "detailed_status_codes_metrics"
        elif key == "prefixLevel":
            suggest = "prefix_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensBucketLevel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensBucketLevel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensBucketLevel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 activity_metrics: Optional['outputs.StorageLensActivityMetrics'] = None,
                 advanced_cost_optimization_metrics: Optional['outputs.StorageLensAdvancedCostOptimizationMetrics'] = None,
                 advanced_data_protection_metrics: Optional['outputs.StorageLensAdvancedDataProtectionMetrics'] = None,
                 detailed_status_codes_metrics: Optional['outputs.StorageLensDetailedStatusCodesMetrics'] = None,
                 prefix_level: Optional['outputs.StorageLensPrefixLevel'] = None):
        """
        Bucket-level metrics configurations.
        :param 'StorageLensActivityMetrics' activity_metrics: A property for bucket-level activity metrics for S3 Storage Lens.
        :param 'StorageLensAdvancedCostOptimizationMetrics' advanced_cost_optimization_metrics: A property for bucket-level advanced cost optimization metrics for S3 Storage Lens.
        :param 'StorageLensAdvancedDataProtectionMetrics' advanced_data_protection_metrics: A property for bucket-level advanced data protection metrics for S3 Storage Lens.
        :param 'StorageLensDetailedStatusCodesMetrics' detailed_status_codes_metrics: A property for bucket-level detailed status code metrics for S3 Storage Lens.
        :param 'StorageLensPrefixLevel' prefix_level: A property for bucket-level prefix-level storage metrics for S3 Storage Lens.
        """
        if activity_metrics is not None:
            pulumi.set(__self__, "activity_metrics", activity_metrics)
        if advanced_cost_optimization_metrics is not None:
            pulumi.set(__self__, "advanced_cost_optimization_metrics", advanced_cost_optimization_metrics)
        if advanced_data_protection_metrics is not None:
            pulumi.set(__self__, "advanced_data_protection_metrics", advanced_data_protection_metrics)
        if detailed_status_codes_metrics is not None:
            pulumi.set(__self__, "detailed_status_codes_metrics", detailed_status_codes_metrics)
        if prefix_level is not None:
            pulumi.set(__self__, "prefix_level", prefix_level)

    @property
    @pulumi.getter(name="activityMetrics")
    def activity_metrics(self) -> Optional['outputs.StorageLensActivityMetrics']:
        """
        A property for bucket-level activity metrics for S3 Storage Lens.
        """
        return pulumi.get(self, "activity_metrics")

    @property
    @pulumi.getter(name="advancedCostOptimizationMetrics")
    def advanced_cost_optimization_metrics(self) -> Optional['outputs.StorageLensAdvancedCostOptimizationMetrics']:
        """
        A property for bucket-level advanced cost optimization metrics for S3 Storage Lens.
        """
        return pulumi.get(self, "advanced_cost_optimization_metrics")

    @property
    @pulumi.getter(name="advancedDataProtectionMetrics")
    def advanced_data_protection_metrics(self) -> Optional['outputs.StorageLensAdvancedDataProtectionMetrics']:
        """
        A property for bucket-level advanced data protection metrics for S3 Storage Lens.
        """
        return pulumi.get(self, "advanced_data_protection_metrics")

    @property
    @pulumi.getter(name="detailedStatusCodesMetrics")
    def detailed_status_codes_metrics(self) -> Optional['outputs.StorageLensDetailedStatusCodesMetrics']:
        """
        A property for bucket-level detailed status code metrics for S3 Storage Lens.
        """
        return pulumi.get(self, "detailed_status_codes_metrics")

    @property
    @pulumi.getter(name="prefixLevel")
    def prefix_level(self) -> Optional['outputs.StorageLensPrefixLevel']:
        """
        A property for bucket-level prefix-level storage metrics for S3 Storage Lens.
        """
        return pulumi.get(self, "prefix_level")


@pulumi.output_type
class StorageLensBucketsAndRegions(dict):
    """
    S3 buckets and Regions to include/exclude in the Amazon S3 Storage Lens configuration.
    """
    def __init__(__self__, *,
                 buckets: Optional[Sequence[str]] = None,
                 regions: Optional[Sequence[str]] = None):
        """
        S3 buckets and Regions to include/exclude in the Amazon S3 Storage Lens configuration.
        :param Sequence[str] buckets: This property contains the details of the buckets for the Amazon S3 Storage Lens configuration. This should be the bucket Amazon Resource Name(ARN). For valid values, see [Buckets ARN format here](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_Include.html#API_control_Include_Contents) in the *Amazon S3 API Reference* .
        :param Sequence[str] regions: This property contains the details of the Regions for the S3 Storage Lens configuration.
        """
        if buckets is not None:
            pulumi.set(__self__, "buckets", buckets)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)

    @property
    @pulumi.getter
    def buckets(self) -> Optional[Sequence[str]]:
        """
        This property contains the details of the buckets for the Amazon S3 Storage Lens configuration. This should be the bucket Amazon Resource Name(ARN). For valid values, see [Buckets ARN format here](https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_Include.html#API_control_Include_Contents) in the *Amazon S3 API Reference* .
        """
        return pulumi.get(self, "buckets")

    @property
    @pulumi.getter
    def regions(self) -> Optional[Sequence[str]]:
        """
        This property contains the details of the Regions for the S3 Storage Lens configuration.
        """
        return pulumi.get(self, "regions")


@pulumi.output_type
class StorageLensCloudWatchMetrics(dict):
    """
    CloudWatch metrics settings for the Amazon S3 Storage Lens metrics export.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensCloudWatchMetrics. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensCloudWatchMetrics.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensCloudWatchMetrics.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: bool):
        """
        CloudWatch metrics settings for the Amazon S3 Storage Lens metrics export.
        :param bool is_enabled: Specifies whether CloudWatch metrics are enabled or disabled.
        """
        pulumi.set(__self__, "is_enabled", is_enabled)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Specifies whether CloudWatch metrics are enabled or disabled.
        """
        return pulumi.get(self, "is_enabled")


@pulumi.output_type
class StorageLensConfiguration(dict):
    """
    Specifies the details of Amazon S3 Storage Lens configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountLevel":
            suggest = "account_level"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "awsOrg":
            suggest = "aws_org"
        elif key == "dataExport":
            suggest = "data_export"
        elif key == "storageLensArn":
            suggest = "storage_lens_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_level: 'outputs.StorageLensAccountLevel',
                 id: str,
                 is_enabled: bool,
                 aws_org: Optional['outputs.StorageLensAwsOrg'] = None,
                 data_export: Optional['outputs.StorageLensDataExport'] = None,
                 exclude: Optional['outputs.StorageLensBucketsAndRegions'] = None,
                 include: Optional['outputs.StorageLensBucketsAndRegions'] = None,
                 storage_lens_arn: Optional[str] = None):
        """
        Specifies the details of Amazon S3 Storage Lens configuration.
        :param 'StorageLensAccountLevel' account_level: This property contains the details of the account-level metrics for Amazon S3 Storage Lens configuration.
        :param str id: This property contains the details of the ID of the S3 Storage Lens configuration.
        :param bool is_enabled: Specifies whether the Amazon S3 Storage Lens configuration is enabled or disabled.
        :param 'StorageLensAwsOrg' aws_org: This property contains the details of the AWS Organization for the S3 Storage Lens configuration.
        :param 'StorageLensDataExport' data_export: This property contains the details of this S3 Storage Lens configuration's metrics export.
        :param 'StorageLensBucketsAndRegions' exclude: This property contains the details of the bucket and or Regions excluded for Amazon S3 Storage Lens configuration.
        :param 'StorageLensBucketsAndRegions' include: This property contains the details of the bucket and or Regions included for Amazon S3 Storage Lens configuration.
        :param str storage_lens_arn: The ARN for the Amazon S3 Storage Lens configuration.
        """
        pulumi.set(__self__, "account_level", account_level)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_enabled", is_enabled)
        if aws_org is not None:
            pulumi.set(__self__, "aws_org", aws_org)
        if data_export is not None:
            pulumi.set(__self__, "data_export", data_export)
        if exclude is not None:
            pulumi.set(__self__, "exclude", exclude)
        if include is not None:
            pulumi.set(__self__, "include", include)
        if storage_lens_arn is not None:
            pulumi.set(__self__, "storage_lens_arn", storage_lens_arn)

    @property
    @pulumi.getter(name="accountLevel")
    def account_level(self) -> 'outputs.StorageLensAccountLevel':
        """
        This property contains the details of the account-level metrics for Amazon S3 Storage Lens configuration.
        """
        return pulumi.get(self, "account_level")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        This property contains the details of the ID of the S3 Storage Lens configuration.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Specifies whether the Amazon S3 Storage Lens configuration is enabled or disabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="awsOrg")
    def aws_org(self) -> Optional['outputs.StorageLensAwsOrg']:
        """
        This property contains the details of the AWS Organization for the S3 Storage Lens configuration.
        """
        return pulumi.get(self, "aws_org")

    @property
    @pulumi.getter(name="dataExport")
    def data_export(self) -> Optional['outputs.StorageLensDataExport']:
        """
        This property contains the details of this S3 Storage Lens configuration's metrics export.
        """
        return pulumi.get(self, "data_export")

    @property
    @pulumi.getter
    def exclude(self) -> Optional['outputs.StorageLensBucketsAndRegions']:
        """
        This property contains the details of the bucket and or Regions excluded for Amazon S3 Storage Lens configuration.
        """
        return pulumi.get(self, "exclude")

    @property
    @pulumi.getter
    def include(self) -> Optional['outputs.StorageLensBucketsAndRegions']:
        """
        This property contains the details of the bucket and or Regions included for Amazon S3 Storage Lens configuration.
        """
        return pulumi.get(self, "include")

    @property
    @pulumi.getter(name="storageLensArn")
    def storage_lens_arn(self) -> Optional[str]:
        """
        The ARN for the Amazon S3 Storage Lens configuration.
        """
        return pulumi.get(self, "storage_lens_arn")


@pulumi.output_type
class StorageLensDataExport(dict):
    """
    Specifies how Amazon S3 Storage Lens metrics should be exported.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudWatchMetrics":
            suggest = "cloud_watch_metrics"
        elif key == "s3BucketDestination":
            suggest = "s3_bucket_destination"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensDataExport. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensDataExport.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensDataExport.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_watch_metrics: Optional['outputs.StorageLensCloudWatchMetrics'] = None,
                 s3_bucket_destination: Optional['outputs.StorageLensS3BucketDestination'] = None):
        """
        Specifies how Amazon S3 Storage Lens metrics should be exported.
        :param 'StorageLensCloudWatchMetrics' cloud_watch_metrics: This property enables the Amazon CloudWatch publishing option for S3 Storage Lens metrics.
        :param 'StorageLensS3BucketDestination' s3_bucket_destination: This property contains the details of the bucket where the S3 Storage Lens metrics export will be placed.
        """
        if cloud_watch_metrics is not None:
            pulumi.set(__self__, "cloud_watch_metrics", cloud_watch_metrics)
        if s3_bucket_destination is not None:
            pulumi.set(__self__, "s3_bucket_destination", s3_bucket_destination)

    @property
    @pulumi.getter(name="cloudWatchMetrics")
    def cloud_watch_metrics(self) -> Optional['outputs.StorageLensCloudWatchMetrics']:
        """
        This property enables the Amazon CloudWatch publishing option for S3 Storage Lens metrics.
        """
        return pulumi.get(self, "cloud_watch_metrics")

    @property
    @pulumi.getter(name="s3BucketDestination")
    def s3_bucket_destination(self) -> Optional['outputs.StorageLensS3BucketDestination']:
        """
        This property contains the details of the bucket where the S3 Storage Lens metrics export will be placed.
        """
        return pulumi.get(self, "s3_bucket_destination")


@pulumi.output_type
class StorageLensDetailedStatusCodesMetrics(dict):
    """
    Enables detailed status codes metrics.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensDetailedStatusCodesMetrics. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensDetailedStatusCodesMetrics.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensDetailedStatusCodesMetrics.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: Optional[bool] = None):
        """
        Enables detailed status codes metrics.
        :param bool is_enabled: Specifies whether detailed status codes metrics are enabled or disabled.
        """
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        Specifies whether detailed status codes metrics are enabled or disabled.
        """
        return pulumi.get(self, "is_enabled")


@pulumi.output_type
class StorageLensEncryption(dict):
    """
    Configures the server-side encryption for Amazon S3 Storage Lens report files with either S3-managed keys (SSE-S3) or KMS-managed keys (SSE-KMS).
    """
    def __init__(__self__):
        """
        Configures the server-side encryption for Amazon S3 Storage Lens report files with either S3-managed keys (SSE-S3) or KMS-managed keys (SSE-KMS).
        """
        pass


@pulumi.output_type
class StorageLensGroupAnd(dict):
    """
    The Storage Lens group will include objects that match all of the specified filter values.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchAnyPrefix":
            suggest = "match_any_prefix"
        elif key == "matchAnySuffix":
            suggest = "match_any_suffix"
        elif key == "matchAnyTag":
            suggest = "match_any_tag"
        elif key == "matchObjectAge":
            suggest = "match_object_age"
        elif key == "matchObjectSize":
            suggest = "match_object_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensGroupAnd. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensGroupAnd.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensGroupAnd.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_any_prefix: Optional[Sequence[str]] = None,
                 match_any_suffix: Optional[Sequence[str]] = None,
                 match_any_tag: Optional[Sequence['outputs.StorageLensGroupTag']] = None,
                 match_object_age: Optional['outputs.StorageLensGroupMatchObjectAge'] = None,
                 match_object_size: Optional['outputs.StorageLensGroupMatchObjectSize'] = None):
        """
        The Storage Lens group will include objects that match all of the specified filter values.
        :param Sequence[str] match_any_prefix: This property contains a list of prefixes. At least one prefix must be specified. Up to 10 prefixes are allowed.
        :param Sequence[str] match_any_suffix: This property contains a list of suffixes. At least one suffix must be specified. Up to 10 suffixes are allowed.
        :param Sequence['StorageLensGroupTag'] match_any_tag: This property contains the list of object tags. At least one object tag must be specified. Up to 10 object tags are allowed.
        :param 'StorageLensGroupMatchObjectAge' match_object_age: This property contains `DaysGreaterThan` and `DaysLessThan` properties to define the object age range (minimum and maximum number of days).
        :param 'StorageLensGroupMatchObjectSize' match_object_size: This property contains `BytesGreaterThan` and `BytesLessThan` to define the object size range (minimum and maximum number of Bytes).
        """
        if match_any_prefix is not None:
            pulumi.set(__self__, "match_any_prefix", match_any_prefix)
        if match_any_suffix is not None:
            pulumi.set(__self__, "match_any_suffix", match_any_suffix)
        if match_any_tag is not None:
            pulumi.set(__self__, "match_any_tag", match_any_tag)
        if match_object_age is not None:
            pulumi.set(__self__, "match_object_age", match_object_age)
        if match_object_size is not None:
            pulumi.set(__self__, "match_object_size", match_object_size)

    @property
    @pulumi.getter(name="matchAnyPrefix")
    def match_any_prefix(self) -> Optional[Sequence[str]]:
        """
        This property contains a list of prefixes. At least one prefix must be specified. Up to 10 prefixes are allowed.
        """
        return pulumi.get(self, "match_any_prefix")

    @property
    @pulumi.getter(name="matchAnySuffix")
    def match_any_suffix(self) -> Optional[Sequence[str]]:
        """
        This property contains a list of suffixes. At least one suffix must be specified. Up to 10 suffixes are allowed.
        """
        return pulumi.get(self, "match_any_suffix")

    @property
    @pulumi.getter(name="matchAnyTag")
    def match_any_tag(self) -> Optional[Sequence['outputs.StorageLensGroupTag']]:
        """
        This property contains the list of object tags. At least one object tag must be specified. Up to 10 object tags are allowed.
        """
        return pulumi.get(self, "match_any_tag")

    @property
    @pulumi.getter(name="matchObjectAge")
    def match_object_age(self) -> Optional['outputs.StorageLensGroupMatchObjectAge']:
        """
        This property contains `DaysGreaterThan` and `DaysLessThan` properties to define the object age range (minimum and maximum number of days).
        """
        return pulumi.get(self, "match_object_age")

    @property
    @pulumi.getter(name="matchObjectSize")
    def match_object_size(self) -> Optional['outputs.StorageLensGroupMatchObjectSize']:
        """
        This property contains `BytesGreaterThan` and `BytesLessThan` to define the object size range (minimum and maximum number of Bytes).
        """
        return pulumi.get(self, "match_object_size")


@pulumi.output_type
class StorageLensGroupFilter(dict):
    """
    Sets the Storage Lens Group filter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "and":
            suggest = "and_"
        elif key == "matchAnyPrefix":
            suggest = "match_any_prefix"
        elif key == "matchAnySuffix":
            suggest = "match_any_suffix"
        elif key == "matchAnyTag":
            suggest = "match_any_tag"
        elif key == "matchObjectAge":
            suggest = "match_object_age"
        elif key == "matchObjectSize":
            suggest = "match_object_size"
        elif key == "or":
            suggest = "or_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensGroupFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensGroupFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensGroupFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 and_: Optional['outputs.StorageLensGroupAnd'] = None,
                 match_any_prefix: Optional[Sequence[str]] = None,
                 match_any_suffix: Optional[Sequence[str]] = None,
                 match_any_tag: Optional[Sequence['outputs.StorageLensGroupTag']] = None,
                 match_object_age: Optional['outputs.StorageLensGroupMatchObjectAge'] = None,
                 match_object_size: Optional['outputs.StorageLensGroupMatchObjectSize'] = None,
                 or_: Optional['outputs.StorageLensGroupOr'] = None):
        """
        Sets the Storage Lens Group filter.
        :param 'StorageLensGroupAnd' and_: This property contains the `And` logical operator, which allows multiple filter conditions to be joined for more complex comparisons of Storage Lens group data. Objects must match all of the listed filter conditions that are joined by the `And` logical operator. Only one of each filter condition is allowed.
        :param Sequence[str] match_any_prefix: This property contains a list of prefixes. At least one prefix must be specified. Up to 10 prefixes are allowed.
        :param Sequence[str] match_any_suffix: This property contains a list of suffixes. At least one suffix must be specified. Up to 10 suffixes are allowed.
        :param Sequence['StorageLensGroupTag'] match_any_tag: This property contains the list of S3 object tags. At least one object tag must be specified. Up to 10 object tags are allowed.
        :param 'StorageLensGroupMatchObjectAge' match_object_age: This property contains `DaysGreaterThan` and `DaysLessThan` to define the object age range (minimum and maximum number of days).
        :param 'StorageLensGroupMatchObjectSize' match_object_size: This property contains `BytesGreaterThan` and `BytesLessThan` to define the object size range (minimum and maximum number of Bytes).
        :param 'StorageLensGroupOr' or_: This property contains the `Or` logical operator, which allows multiple filter conditions to be joined. Objects can match any of the listed filter conditions, which are joined by the `Or` logical operator. Only one of each filter condition is allowed.
        """
        if and_ is not None:
            pulumi.set(__self__, "and_", and_)
        if match_any_prefix is not None:
            pulumi.set(__self__, "match_any_prefix", match_any_prefix)
        if match_any_suffix is not None:
            pulumi.set(__self__, "match_any_suffix", match_any_suffix)
        if match_any_tag is not None:
            pulumi.set(__self__, "match_any_tag", match_any_tag)
        if match_object_age is not None:
            pulumi.set(__self__, "match_object_age", match_object_age)
        if match_object_size is not None:
            pulumi.set(__self__, "match_object_size", match_object_size)
        if or_ is not None:
            pulumi.set(__self__, "or_", or_)

    @property
    @pulumi.getter(name="and")
    def and_(self) -> Optional['outputs.StorageLensGroupAnd']:
        """
        This property contains the `And` logical operator, which allows multiple filter conditions to be joined for more complex comparisons of Storage Lens group data. Objects must match all of the listed filter conditions that are joined by the `And` logical operator. Only one of each filter condition is allowed.
        """
        return pulumi.get(self, "and_")

    @property
    @pulumi.getter(name="matchAnyPrefix")
    def match_any_prefix(self) -> Optional[Sequence[str]]:
        """
        This property contains a list of prefixes. At least one prefix must be specified. Up to 10 prefixes are allowed.
        """
        return pulumi.get(self, "match_any_prefix")

    @property
    @pulumi.getter(name="matchAnySuffix")
    def match_any_suffix(self) -> Optional[Sequence[str]]:
        """
        This property contains a list of suffixes. At least one suffix must be specified. Up to 10 suffixes are allowed.
        """
        return pulumi.get(self, "match_any_suffix")

    @property
    @pulumi.getter(name="matchAnyTag")
    def match_any_tag(self) -> Optional[Sequence['outputs.StorageLensGroupTag']]:
        """
        This property contains the list of S3 object tags. At least one object tag must be specified. Up to 10 object tags are allowed.
        """
        return pulumi.get(self, "match_any_tag")

    @property
    @pulumi.getter(name="matchObjectAge")
    def match_object_age(self) -> Optional['outputs.StorageLensGroupMatchObjectAge']:
        """
        This property contains `DaysGreaterThan` and `DaysLessThan` to define the object age range (minimum and maximum number of days).
        """
        return pulumi.get(self, "match_object_age")

    @property
    @pulumi.getter(name="matchObjectSize")
    def match_object_size(self) -> Optional['outputs.StorageLensGroupMatchObjectSize']:
        """
        This property contains `BytesGreaterThan` and `BytesLessThan` to define the object size range (minimum and maximum number of Bytes).
        """
        return pulumi.get(self, "match_object_size")

    @property
    @pulumi.getter(name="or")
    def or_(self) -> Optional['outputs.StorageLensGroupOr']:
        """
        This property contains the `Or` logical operator, which allows multiple filter conditions to be joined. Objects can match any of the listed filter conditions, which are joined by the `Or` logical operator. Only one of each filter condition is allowed.
        """
        return pulumi.get(self, "or_")


@pulumi.output_type
class StorageLensGroupLevel(dict):
    """
    Specifies the details of Amazon S3 Storage Lens Group configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageLensGroupSelectionCriteria":
            suggest = "storage_lens_group_selection_criteria"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensGroupLevel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensGroupLevel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensGroupLevel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_lens_group_selection_criteria: Optional['outputs.StorageLensGroupSelectionCriteria'] = None):
        """
        Specifies the details of Amazon S3 Storage Lens Group configuration.
        :param 'StorageLensGroupSelectionCriteria' storage_lens_group_selection_criteria: This property indicates which Storage Lens group ARNs to include or exclude in the Storage Lens group aggregation. If this value is left null, then all Storage Lens groups are selected.
        """
        if storage_lens_group_selection_criteria is not None:
            pulumi.set(__self__, "storage_lens_group_selection_criteria", storage_lens_group_selection_criteria)

    @property
    @pulumi.getter(name="storageLensGroupSelectionCriteria")
    def storage_lens_group_selection_criteria(self) -> Optional['outputs.StorageLensGroupSelectionCriteria']:
        """
        This property indicates which Storage Lens group ARNs to include or exclude in the Storage Lens group aggregation. If this value is left null, then all Storage Lens groups are selected.
        """
        return pulumi.get(self, "storage_lens_group_selection_criteria")


@pulumi.output_type
class StorageLensGroupMatchObjectAge(dict):
    """
    Filter to match all of the specified values for the minimum and maximum object age.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "daysGreaterThan":
            suggest = "days_greater_than"
        elif key == "daysLessThan":
            suggest = "days_less_than"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensGroupMatchObjectAge. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensGroupMatchObjectAge.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensGroupMatchObjectAge.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days_greater_than: Optional[int] = None,
                 days_less_than: Optional[int] = None):
        """
        Filter to match all of the specified values for the minimum and maximum object age.
        :param int days_greater_than: Minimum object age to which the rule applies.
        :param int days_less_than: Maximum object age to which the rule applies.
        """
        if days_greater_than is not None:
            pulumi.set(__self__, "days_greater_than", days_greater_than)
        if days_less_than is not None:
            pulumi.set(__self__, "days_less_than", days_less_than)

    @property
    @pulumi.getter(name="daysGreaterThan")
    def days_greater_than(self) -> Optional[int]:
        """
        Minimum object age to which the rule applies.
        """
        return pulumi.get(self, "days_greater_than")

    @property
    @pulumi.getter(name="daysLessThan")
    def days_less_than(self) -> Optional[int]:
        """
        Maximum object age to which the rule applies.
        """
        return pulumi.get(self, "days_less_than")


@pulumi.output_type
class StorageLensGroupMatchObjectSize(dict):
    """
    Filter to match all of the specified values for the minimum and maximum object size.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bytesGreaterThan":
            suggest = "bytes_greater_than"
        elif key == "bytesLessThan":
            suggest = "bytes_less_than"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensGroupMatchObjectSize. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensGroupMatchObjectSize.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensGroupMatchObjectSize.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bytes_greater_than: Optional[int] = None,
                 bytes_less_than: Optional[int] = None):
        """
        Filter to match all of the specified values for the minimum and maximum object size.
        :param int bytes_greater_than: Minimum object size to which the rule applies.
        :param int bytes_less_than: Maximum object size to which the rule applies.
        """
        if bytes_greater_than is not None:
            pulumi.set(__self__, "bytes_greater_than", bytes_greater_than)
        if bytes_less_than is not None:
            pulumi.set(__self__, "bytes_less_than", bytes_less_than)

    @property
    @pulumi.getter(name="bytesGreaterThan")
    def bytes_greater_than(self) -> Optional[int]:
        """
        Minimum object size to which the rule applies.
        """
        return pulumi.get(self, "bytes_greater_than")

    @property
    @pulumi.getter(name="bytesLessThan")
    def bytes_less_than(self) -> Optional[int]:
        """
        Maximum object size to which the rule applies.
        """
        return pulumi.get(self, "bytes_less_than")


@pulumi.output_type
class StorageLensGroupOr(dict):
    """
    The Storage Lens group will include objects that match any of the specified filter values.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchAnyPrefix":
            suggest = "match_any_prefix"
        elif key == "matchAnySuffix":
            suggest = "match_any_suffix"
        elif key == "matchAnyTag":
            suggest = "match_any_tag"
        elif key == "matchObjectAge":
            suggest = "match_object_age"
        elif key == "matchObjectSize":
            suggest = "match_object_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensGroupOr. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensGroupOr.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensGroupOr.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_any_prefix: Optional[Sequence[str]] = None,
                 match_any_suffix: Optional[Sequence[str]] = None,
                 match_any_tag: Optional[Sequence['outputs.StorageLensGroupTag']] = None,
                 match_object_age: Optional['outputs.StorageLensGroupMatchObjectAge'] = None,
                 match_object_size: Optional['outputs.StorageLensGroupMatchObjectSize'] = None):
        """
        The Storage Lens group will include objects that match any of the specified filter values.
        :param Sequence[str] match_any_prefix: This property contains a list of prefixes. At least one prefix must be specified. Up to 10 prefixes are allowed.
        :param Sequence[str] match_any_suffix: This property contains the list of suffixes. At least one suffix must be specified. Up to 10 suffixes are allowed.
        :param Sequence['StorageLensGroupTag'] match_any_tag: This property contains the list of S3 object tags. At least one object tag must be specified. Up to 10 object tags are allowed.
        :param 'StorageLensGroupMatchObjectAge' match_object_age: This property filters objects that match the specified object age range.
        :param 'StorageLensGroupMatchObjectSize' match_object_size: This property contains the `BytesGreaterThan` and `BytesLessThan` values to define the object size range (minimum and maximum number of Bytes).
        """
        if match_any_prefix is not None:
            pulumi.set(__self__, "match_any_prefix", match_any_prefix)
        if match_any_suffix is not None:
            pulumi.set(__self__, "match_any_suffix", match_any_suffix)
        if match_any_tag is not None:
            pulumi.set(__self__, "match_any_tag", match_any_tag)
        if match_object_age is not None:
            pulumi.set(__self__, "match_object_age", match_object_age)
        if match_object_size is not None:
            pulumi.set(__self__, "match_object_size", match_object_size)

    @property
    @pulumi.getter(name="matchAnyPrefix")
    def match_any_prefix(self) -> Optional[Sequence[str]]:
        """
        This property contains a list of prefixes. At least one prefix must be specified. Up to 10 prefixes are allowed.
        """
        return pulumi.get(self, "match_any_prefix")

    @property
    @pulumi.getter(name="matchAnySuffix")
    def match_any_suffix(self) -> Optional[Sequence[str]]:
        """
        This property contains the list of suffixes. At least one suffix must be specified. Up to 10 suffixes are allowed.
        """
        return pulumi.get(self, "match_any_suffix")

    @property
    @pulumi.getter(name="matchAnyTag")
    def match_any_tag(self) -> Optional[Sequence['outputs.StorageLensGroupTag']]:
        """
        This property contains the list of S3 object tags. At least one object tag must be specified. Up to 10 object tags are allowed.
        """
        return pulumi.get(self, "match_any_tag")

    @property
    @pulumi.getter(name="matchObjectAge")
    def match_object_age(self) -> Optional['outputs.StorageLensGroupMatchObjectAge']:
        """
        This property filters objects that match the specified object age range.
        """
        return pulumi.get(self, "match_object_age")

    @property
    @pulumi.getter(name="matchObjectSize")
    def match_object_size(self) -> Optional['outputs.StorageLensGroupMatchObjectSize']:
        """
        This property contains the `BytesGreaterThan` and `BytesLessThan` values to define the object size range (minimum and maximum number of Bytes).
        """
        return pulumi.get(self, "match_object_size")


@pulumi.output_type
class StorageLensGroupSelectionCriteria(dict):
    """
    Selection criteria for Storage Lens Group level metrics
    """
    def __init__(__self__, *,
                 exclude: Optional[Sequence[str]] = None,
                 include: Optional[Sequence[str]] = None):
        """
        Selection criteria for Storage Lens Group level metrics
        :param Sequence[str] exclude: This property indicates which Storage Lens group ARNs to exclude from the Storage Lens group aggregation.
        :param Sequence[str] include: This property indicates which Storage Lens group ARNs to include in the Storage Lens group aggregation.
        """
        if exclude is not None:
            pulumi.set(__self__, "exclude", exclude)
        if include is not None:
            pulumi.set(__self__, "include", include)

    @property
    @pulumi.getter
    def exclude(self) -> Optional[Sequence[str]]:
        """
        This property indicates which Storage Lens group ARNs to exclude from the Storage Lens group aggregation.
        """
        return pulumi.get(self, "exclude")

    @property
    @pulumi.getter
    def include(self) -> Optional[Sequence[str]]:
        """
        This property indicates which Storage Lens group ARNs to include in the Storage Lens group aggregation.
        """
        return pulumi.get(self, "include")


@pulumi.output_type
class StorageLensGroupTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class StorageLensPrefixLevel(dict):
    """
    Prefix-level metrics configurations.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageMetrics":
            suggest = "storage_metrics"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensPrefixLevel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensPrefixLevel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensPrefixLevel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_metrics: 'outputs.StorageLensPrefixLevelStorageMetrics'):
        """
        Prefix-level metrics configurations.
        :param 'StorageLensPrefixLevelStorageMetrics' storage_metrics: A property for the prefix-level storage metrics for Amazon S3 Storage Lens.
        """
        pulumi.set(__self__, "storage_metrics", storage_metrics)

    @property
    @pulumi.getter(name="storageMetrics")
    def storage_metrics(self) -> 'outputs.StorageLensPrefixLevelStorageMetrics':
        """
        A property for the prefix-level storage metrics for Amazon S3 Storage Lens.
        """
        return pulumi.get(self, "storage_metrics")


@pulumi.output_type
class StorageLensPrefixLevelStorageMetrics(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"
        elif key == "selectionCriteria":
            suggest = "selection_criteria"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensPrefixLevelStorageMetrics. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensPrefixLevelStorageMetrics.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensPrefixLevelStorageMetrics.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: Optional[bool] = None,
                 selection_criteria: Optional['outputs.StorageLensSelectionCriteria'] = None):
        """
        :param bool is_enabled: Specifies whether prefix-level storage metrics are enabled or disabled.
        :param 'StorageLensSelectionCriteria' selection_criteria: This property identifies whether the details of the prefix-level storage metrics for S3 Storage Lens are enabled.
        """
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if selection_criteria is not None:
            pulumi.set(__self__, "selection_criteria", selection_criteria)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        Specifies whether prefix-level storage metrics are enabled or disabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="selectionCriteria")
    def selection_criteria(self) -> Optional['outputs.StorageLensSelectionCriteria']:
        """
        This property identifies whether the details of the prefix-level storage metrics for S3 Storage Lens are enabled.
        """
        return pulumi.get(self, "selection_criteria")


@pulumi.output_type
class StorageLensS3BucketDestination(dict):
    """
    S3 bucket destination settings for the Amazon S3 Storage Lens metrics export.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountId":
            suggest = "account_id"
        elif key == "outputSchemaVersion":
            suggest = "output_schema_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensS3BucketDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensS3BucketDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensS3BucketDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_id: str,
                 arn: str,
                 format: 'StorageLensS3BucketDestinationFormat',
                 output_schema_version: 'StorageLensS3BucketDestinationOutputSchemaVersion',
                 encryption: Optional['outputs.StorageLensEncryption'] = None,
                 prefix: Optional[str] = None):
        """
        S3 bucket destination settings for the Amazon S3 Storage Lens metrics export.
        :param str account_id: The AWS account ID that owns the destination S3 bucket.
        :param str arn: The ARN of the bucket to which Amazon S3 Storage Lens exports will be placed.
        :param 'StorageLensS3BucketDestinationFormat' format: Specifies the file format to use when exporting Amazon S3 Storage Lens metrics export.
        :param 'StorageLensS3BucketDestinationOutputSchemaVersion' output_schema_version: The version of the output schema to use when exporting Amazon S3 Storage Lens metrics.
        :param 'StorageLensEncryption' encryption: This property contains the details of the encryption of the bucket destination of the Amazon S3 Storage Lens metrics export.
        :param str prefix: The prefix to use for Amazon S3 Storage Lens export.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "output_schema_version", output_schema_version)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        The AWS account ID that owns the destination S3 bucket.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        The ARN of the bucket to which Amazon S3 Storage Lens exports will be placed.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def format(self) -> 'StorageLensS3BucketDestinationFormat':
        """
        Specifies the file format to use when exporting Amazon S3 Storage Lens metrics export.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="outputSchemaVersion")
    def output_schema_version(self) -> 'StorageLensS3BucketDestinationOutputSchemaVersion':
        """
        The version of the output schema to use when exporting Amazon S3 Storage Lens metrics.
        """
        return pulumi.get(self, "output_schema_version")

    @property
    @pulumi.getter
    def encryption(self) -> Optional['outputs.StorageLensEncryption']:
        """
        This property contains the details of the encryption of the bucket destination of the Amazon S3 Storage Lens metrics export.
        """
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        The prefix to use for Amazon S3 Storage Lens export.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class StorageLensSelectionCriteria(dict):
    """
    Selection criteria for prefix-level metrics.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxDepth":
            suggest = "max_depth"
        elif key == "minStorageBytesPercentage":
            suggest = "min_storage_bytes_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensSelectionCriteria. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensSelectionCriteria.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensSelectionCriteria.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delimiter: Optional[str] = None,
                 max_depth: Optional[int] = None,
                 min_storage_bytes_percentage: Optional[float] = None):
        """
        Selection criteria for prefix-level metrics.
        :param str delimiter: Delimiter to divide S3 key into hierarchy of prefixes.
        :param int max_depth: Max depth of prefixes of S3 key that Amazon S3 Storage Lens will analyze.
        :param float min_storage_bytes_percentage: The minimum storage bytes threshold for the prefixes to be included in the analysis.
        """
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if max_depth is not None:
            pulumi.set(__self__, "max_depth", max_depth)
        if min_storage_bytes_percentage is not None:
            pulumi.set(__self__, "min_storage_bytes_percentage", min_storage_bytes_percentage)

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[str]:
        """
        Delimiter to divide S3 key into hierarchy of prefixes.
        """
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter(name="maxDepth")
    def max_depth(self) -> Optional[int]:
        """
        Max depth of prefixes of S3 key that Amazon S3 Storage Lens will analyze.
        """
        return pulumi.get(self, "max_depth")

    @property
    @pulumi.getter(name="minStorageBytesPercentage")
    def min_storage_bytes_percentage(self) -> Optional[float]:
        """
        The minimum storage bytes threshold for the prefixes to be included in the analysis.
        """
        return pulumi.get(self, "min_storage_bytes_percentage")


