# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MultiRegionAccessPointArgs', 'MultiRegionAccessPoint']

@pulumi.input_type
class MultiRegionAccessPointArgs:
    def __init__(__self__, *,
                 regions: pulumi.Input[Sequence[pulumi.Input['MultiRegionAccessPointRegionArgs']]],
                 name: Optional[pulumi.Input[str]] = None,
                 public_access_block_configuration: Optional[pulumi.Input['MultiRegionAccessPointPublicAccessBlockConfigurationArgs']] = None):
        """
        The set of arguments for constructing a MultiRegionAccessPoint resource.
        :param pulumi.Input[Sequence[pulumi.Input['MultiRegionAccessPointRegionArgs']]] regions: The list of buckets that you want to associate this Multi Region Access Point with.
        :param pulumi.Input[str] name: The name you want to assign to this Multi Region Access Point.
        :param pulumi.Input['MultiRegionAccessPointPublicAccessBlockConfigurationArgs'] public_access_block_configuration: The PublicAccessBlock configuration that you want to apply to this Multi Region Access Point. You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status 'The Meaning of Public' in the Amazon Simple Storage Service Developer Guide.
        """
        pulumi.set(__self__, "regions", regions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_access_block_configuration is not None:
            pulumi.set(__self__, "public_access_block_configuration", public_access_block_configuration)

    @property
    @pulumi.getter
    def regions(self) -> pulumi.Input[Sequence[pulumi.Input['MultiRegionAccessPointRegionArgs']]]:
        """
        The list of buckets that you want to associate this Multi Region Access Point with.
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: pulumi.Input[Sequence[pulumi.Input['MultiRegionAccessPointRegionArgs']]]):
        pulumi.set(self, "regions", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name you want to assign to this Multi Region Access Point.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publicAccessBlockConfiguration")
    def public_access_block_configuration(self) -> Optional[pulumi.Input['MultiRegionAccessPointPublicAccessBlockConfigurationArgs']]:
        """
        The PublicAccessBlock configuration that you want to apply to this Multi Region Access Point. You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status 'The Meaning of Public' in the Amazon Simple Storage Service Developer Guide.
        """
        return pulumi.get(self, "public_access_block_configuration")

    @public_access_block_configuration.setter
    def public_access_block_configuration(self, value: Optional[pulumi.Input['MultiRegionAccessPointPublicAccessBlockConfigurationArgs']]):
        pulumi.set(self, "public_access_block_configuration", value)


class MultiRegionAccessPoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 public_access_block_configuration: Optional[pulumi.Input[Union['MultiRegionAccessPointPublicAccessBlockConfigurationArgs', 'MultiRegionAccessPointPublicAccessBlockConfigurationArgsDict']]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MultiRegionAccessPointRegionArgs', 'MultiRegionAccessPointRegionArgsDict']]]]] = None,
                 __props__=None):
        """
        AWS::S3::MultiRegionAccessPoint is an Amazon S3 resource type that dynamically routes S3 requests to easily satisfy geographic compliance requirements based on customer-defined routing policies.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The name you want to assign to this Multi Region Access Point.
        :param pulumi.Input[Union['MultiRegionAccessPointPublicAccessBlockConfigurationArgs', 'MultiRegionAccessPointPublicAccessBlockConfigurationArgsDict']] public_access_block_configuration: The PublicAccessBlock configuration that you want to apply to this Multi Region Access Point. You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status 'The Meaning of Public' in the Amazon Simple Storage Service Developer Guide.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MultiRegionAccessPointRegionArgs', 'MultiRegionAccessPointRegionArgsDict']]]] regions: The list of buckets that you want to associate this Multi Region Access Point with.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MultiRegionAccessPointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        AWS::S3::MultiRegionAccessPoint is an Amazon S3 resource type that dynamically routes S3 requests to easily satisfy geographic compliance requirements based on customer-defined routing policies.

        :param str resource_name: The name of the resource.
        :param MultiRegionAccessPointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MultiRegionAccessPointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 public_access_block_configuration: Optional[pulumi.Input[Union['MultiRegionAccessPointPublicAccessBlockConfigurationArgs', 'MultiRegionAccessPointPublicAccessBlockConfigurationArgsDict']]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MultiRegionAccessPointRegionArgs', 'MultiRegionAccessPointRegionArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MultiRegionAccessPointArgs.__new__(MultiRegionAccessPointArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["public_access_block_configuration"] = public_access_block_configuration
            if regions is None and not opts.urn:
                raise TypeError("Missing required property 'regions'")
            __props__.__dict__["regions"] = regions
            __props__.__dict__["alias"] = None
            __props__.__dict__["created_at"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["name", "publicAccessBlockConfiguration", "regions[*]"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(MultiRegionAccessPoint, __self__).__init__(
            'aws-native:s3:MultiRegionAccessPoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'MultiRegionAccessPoint':
        """
        Get an existing MultiRegionAccessPoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = MultiRegionAccessPointArgs.__new__(MultiRegionAccessPointArgs)

        __props__.__dict__["alias"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["public_access_block_configuration"] = None
        __props__.__dict__["regions"] = None
        return MultiRegionAccessPoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def alias(self) -> pulumi.Output[str]:
        """
        The alias is a unique identifier to, and is part of the public DNS name for this Multi Region Access Point
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The timestamp of the when the Multi Region Access Point is created
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[str]]:
        """
        The name you want to assign to this Multi Region Access Point.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicAccessBlockConfiguration")
    def public_access_block_configuration(self) -> pulumi.Output[Optional['outputs.MultiRegionAccessPointPublicAccessBlockConfiguration']]:
        """
        The PublicAccessBlock configuration that you want to apply to this Multi Region Access Point. You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status 'The Meaning of Public' in the Amazon Simple Storage Service Developer Guide.
        """
        return pulumi.get(self, "public_access_block_configuration")

    @property
    @pulumi.getter
    def regions(self) -> pulumi.Output[Sequence['outputs.MultiRegionAccessPointRegion']]:
        """
        The list of buckets that you want to associate this Multi Region Access Point with.
        """
        return pulumi.get(self, "regions")

