# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAccessGrantsInstanceResult',
    'AwaitableGetAccessGrantsInstanceResult',
    'get_access_grants_instance',
    'get_access_grants_instance_output',
]

@pulumi.output_type
class GetAccessGrantsInstanceResult:
    def __init__(__self__, access_grants_instance_arn=None, access_grants_instance_id=None, identity_center_arn=None):
        if access_grants_instance_arn and not isinstance(access_grants_instance_arn, str):
            raise TypeError("Expected argument 'access_grants_instance_arn' to be a str")
        pulumi.set(__self__, "access_grants_instance_arn", access_grants_instance_arn)
        if access_grants_instance_id and not isinstance(access_grants_instance_id, str):
            raise TypeError("Expected argument 'access_grants_instance_id' to be a str")
        pulumi.set(__self__, "access_grants_instance_id", access_grants_instance_id)
        if identity_center_arn and not isinstance(identity_center_arn, str):
            raise TypeError("Expected argument 'identity_center_arn' to be a str")
        pulumi.set(__self__, "identity_center_arn", identity_center_arn)

    @property
    @pulumi.getter(name="accessGrantsInstanceArn")
    def access_grants_instance_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the specified Access Grants instance.
        """
        return pulumi.get(self, "access_grants_instance_arn")

    @property
    @pulumi.getter(name="accessGrantsInstanceId")
    def access_grants_instance_id(self) -> Optional[str]:
        """
        A unique identifier for the specified access grants instance.
        """
        return pulumi.get(self, "access_grants_instance_id")

    @property
    @pulumi.getter(name="identityCenterArn")
    def identity_center_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the specified AWS Identity Center.
        """
        return pulumi.get(self, "identity_center_arn")


class AwaitableGetAccessGrantsInstanceResult(GetAccessGrantsInstanceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccessGrantsInstanceResult(
            access_grants_instance_arn=self.access_grants_instance_arn,
            access_grants_instance_id=self.access_grants_instance_id,
            identity_center_arn=self.identity_center_arn)


def get_access_grants_instance(access_grants_instance_arn: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccessGrantsInstanceResult:
    """
    The AWS::S3::AccessGrantsInstance resource is an Amazon S3 resource type that hosts Access Grants and their associated locations


    :param str access_grants_instance_arn: The Amazon Resource Name (ARN) of the specified Access Grants instance.
    """
    __args__ = dict()
    __args__['accessGrantsInstanceArn'] = access_grants_instance_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:s3:getAccessGrantsInstance', __args__, opts=opts, typ=GetAccessGrantsInstanceResult).value

    return AwaitableGetAccessGrantsInstanceResult(
        access_grants_instance_arn=pulumi.get(__ret__, 'access_grants_instance_arn'),
        access_grants_instance_id=pulumi.get(__ret__, 'access_grants_instance_id'),
        identity_center_arn=pulumi.get(__ret__, 'identity_center_arn'))
def get_access_grants_instance_output(access_grants_instance_arn: Optional[pulumi.Input[str]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAccessGrantsInstanceResult]:
    """
    The AWS::S3::AccessGrantsInstance resource is an Amazon S3 resource type that hosts Access Grants and their associated locations


    :param str access_grants_instance_arn: The Amazon Resource Name (ARN) of the specified Access Grants instance.
    """
    __args__ = dict()
    __args__['accessGrantsInstanceArn'] = access_grants_instance_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:s3:getAccessGrantsInstance', __args__, opts=opts, typ=GetAccessGrantsInstanceResult)
    return __ret__.apply(lambda __response__: GetAccessGrantsInstanceResult(
        access_grants_instance_arn=pulumi.get(__response__, 'access_grants_instance_arn'),
        access_grants_instance_id=pulumi.get(__response__, 'access_grants_instance_id'),
        identity_center_arn=pulumi.get(__response__, 'identity_center_arn')))
