# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs

__all__ = ['AccessGrantsLocationArgs', 'AccessGrantsLocation']

@pulumi.input_type
class AccessGrantsLocationArgs:
    def __init__(__self__, *,
                 iam_role_arn: Optional[pulumi.Input[str]] = None,
                 location_scope: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]]] = None):
        """
        The set of arguments for constructing a AccessGrantsLocation resource.
        :param pulumi.Input[str] iam_role_arn: The Amazon Resource Name (ARN) of the access grant location's associated IAM role.
        :param pulumi.Input[str] location_scope: Descriptor for where the location actually points
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]] tags: The AWS resource tags that you are adding to the S3 Access Grants location. Each tag is a label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter resources.
        """
        if iam_role_arn is not None:
            pulumi.set(__self__, "iam_role_arn", iam_role_arn)
        if location_scope is not None:
            pulumi.set(__self__, "location_scope", location_scope)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the access grant location's associated IAM role.
        """
        return pulumi.get(self, "iam_role_arn")

    @iam_role_arn.setter
    def iam_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iam_role_arn", value)

    @property
    @pulumi.getter(name="locationScope")
    def location_scope(self) -> Optional[pulumi.Input[str]]:
        """
        Descriptor for where the location actually points
        """
        return pulumi.get(self, "location_scope")

    @location_scope.setter
    def location_scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location_scope", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]]]:
        """
        The AWS resource tags that you are adding to the S3 Access Grants location. Each tag is a label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter resources.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]]]):
        pulumi.set(self, "tags", value)


class AccessGrantsLocation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 iam_role_arn: Optional[pulumi.Input[str]] = None,
                 location_scope: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.CreateOnlyTagArgs', '_root_inputs.CreateOnlyTagArgsDict']]]]] = None,
                 __props__=None):
        """
        The AWS::S3::AccessGrantsLocation resource is an Amazon S3 resource type hosted in an access grants instance which can be the target of S3 access grants.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] iam_role_arn: The Amazon Resource Name (ARN) of the access grant location's associated IAM role.
        :param pulumi.Input[str] location_scope: Descriptor for where the location actually points
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.CreateOnlyTagArgs', '_root_inputs.CreateOnlyTagArgsDict']]]] tags: The AWS resource tags that you are adding to the S3 Access Grants location. Each tag is a label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter resources.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AccessGrantsLocationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The AWS::S3::AccessGrantsLocation resource is an Amazon S3 resource type hosted in an access grants instance which can be the target of S3 access grants.

        :param str resource_name: The name of the resource.
        :param AccessGrantsLocationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccessGrantsLocationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 iam_role_arn: Optional[pulumi.Input[str]] = None,
                 location_scope: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.CreateOnlyTagArgs', '_root_inputs.CreateOnlyTagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccessGrantsLocationArgs.__new__(AccessGrantsLocationArgs)

            __props__.__dict__["iam_role_arn"] = iam_role_arn
            __props__.__dict__["location_scope"] = location_scope
            __props__.__dict__["tags"] = tags
            __props__.__dict__["access_grants_location_arn"] = None
            __props__.__dict__["access_grants_location_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["tags[*]"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(AccessGrantsLocation, __self__).__init__(
            'aws-native:s3:AccessGrantsLocation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'AccessGrantsLocation':
        """
        Get an existing AccessGrantsLocation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AccessGrantsLocationArgs.__new__(AccessGrantsLocationArgs)

        __props__.__dict__["access_grants_location_arn"] = None
        __props__.__dict__["access_grants_location_id"] = None
        __props__.__dict__["iam_role_arn"] = None
        __props__.__dict__["location_scope"] = None
        __props__.__dict__["tags"] = None
        return AccessGrantsLocation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessGrantsLocationArn")
    def access_grants_location_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the specified Access Grants location.
        """
        return pulumi.get(self, "access_grants_location_arn")

    @property
    @pulumi.getter(name="accessGrantsLocationId")
    def access_grants_location_id(self) -> pulumi.Output[str]:
        """
        The unique identifier for the specified Access Grants location.
        """
        return pulumi.get(self, "access_grants_location_id")

    @property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon Resource Name (ARN) of the access grant location's associated IAM role.
        """
        return pulumi.get(self, "iam_role_arn")

    @property
    @pulumi.getter(name="locationScope")
    def location_scope(self) -> pulumi.Output[Optional[str]]:
        """
        Descriptor for where the location actually points
        """
        return pulumi.get(self, "location_scope")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.CreateOnlyTag']]]:
        """
        The AWS resource tags that you are adding to the S3 Access Grants location. Each tag is a label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter resources.
        """
        return pulumi.get(self, "tags")

