# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetOutpostResolverResult',
    'AwaitableGetOutpostResolverResult',
    'get_outpost_resolver',
    'get_outpost_resolver_output',
]

@pulumi.output_type
class GetOutpostResolverResult:
    def __init__(__self__, arn=None, creation_time=None, creator_request_id=None, id=None, instance_count=None, modification_time=None, name=None, preferred_instance_type=None, status=None, status_message=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if creation_time and not isinstance(creation_time, str):
            raise TypeError("Expected argument 'creation_time' to be a str")
        pulumi.set(__self__, "creation_time", creation_time)
        if creator_request_id and not isinstance(creator_request_id, str):
            raise TypeError("Expected argument 'creator_request_id' to be a str")
        pulumi.set(__self__, "creator_request_id", creator_request_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_count and not isinstance(instance_count, int):
            raise TypeError("Expected argument 'instance_count' to be a int")
        pulumi.set(__self__, "instance_count", instance_count)
        if modification_time and not isinstance(modification_time, str):
            raise TypeError("Expected argument 'modification_time' to be a str")
        pulumi.set(__self__, "modification_time", modification_time)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if preferred_instance_type and not isinstance(preferred_instance_type, str):
            raise TypeError("Expected argument 'preferred_instance_type' to be a str")
        pulumi.set(__self__, "preferred_instance_type", preferred_instance_type)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if status_message and not isinstance(status_message, str):
            raise TypeError("Expected argument 'status_message' to be a str")
        pulumi.set(__self__, "status_message", status_message)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The OutpostResolver ARN.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[str]:
        """
        The OutpostResolver creation time
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="creatorRequestId")
    def creator_request_id(self) -> Optional[str]:
        """
        The id of the creator request.
        """
        return pulumi.get(self, "creator_request_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        """
        The number of OutpostResolvers.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="modificationTime")
    def modification_time(self) -> Optional[str]:
        """
        The OutpostResolver last modified time
        """
        return pulumi.get(self, "modification_time")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The OutpostResolver name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="preferredInstanceType")
    def preferred_instance_type(self) -> Optional[str]:
        """
        The OutpostResolver instance type.
        """
        return pulumi.get(self, "preferred_instance_type")

    @property
    @pulumi.getter
    def status(self) -> Optional['OutpostResolverStatus']:
        """
        The OutpostResolver status, possible values are CREATING, OPERATIONAL, UPDATING, DELETING, ACTION_NEEDED, FAILED_CREATION and FAILED_DELETION.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> Optional[str]:
        """
        The OutpostResolver status message.
        """
        return pulumi.get(self, "status_message")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetOutpostResolverResult(GetOutpostResolverResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOutpostResolverResult(
            arn=self.arn,
            creation_time=self.creation_time,
            creator_request_id=self.creator_request_id,
            id=self.id,
            instance_count=self.instance_count,
            modification_time=self.modification_time,
            name=self.name,
            preferred_instance_type=self.preferred_instance_type,
            status=self.status,
            status_message=self.status_message,
            tags=self.tags)


def get_outpost_resolver(id: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOutpostResolverResult:
    """
    Resource schema for AWS::Route53Resolver::OutpostResolver.


    :param str id: Id
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:route53resolver:getOutpostResolver', __args__, opts=opts, typ=GetOutpostResolverResult).value

    return AwaitableGetOutpostResolverResult(
        arn=pulumi.get(__ret__, 'arn'),
        creation_time=pulumi.get(__ret__, 'creation_time'),
        creator_request_id=pulumi.get(__ret__, 'creator_request_id'),
        id=pulumi.get(__ret__, 'id'),
        instance_count=pulumi.get(__ret__, 'instance_count'),
        modification_time=pulumi.get(__ret__, 'modification_time'),
        name=pulumi.get(__ret__, 'name'),
        preferred_instance_type=pulumi.get(__ret__, 'preferred_instance_type'),
        status=pulumi.get(__ret__, 'status'),
        status_message=pulumi.get(__ret__, 'status_message'),
        tags=pulumi.get(__ret__, 'tags'))
def get_outpost_resolver_output(id: Optional[pulumi.Input[str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOutpostResolverResult]:
    """
    Resource schema for AWS::Route53Resolver::OutpostResolver.


    :param str id: Id
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:route53resolver:getOutpostResolver', __args__, opts=opts, typ=GetOutpostResolverResult)
    return __ret__.apply(lambda __response__: GetOutpostResolverResult(
        arn=pulumi.get(__response__, 'arn'),
        creation_time=pulumi.get(__response__, 'creation_time'),
        creator_request_id=pulumi.get(__response__, 'creator_request_id'),
        id=pulumi.get(__response__, 'id'),
        instance_count=pulumi.get(__response__, 'instance_count'),
        modification_time=pulumi.get(__response__, 'modification_time'),
        name=pulumi.get(__response__, 'name'),
        preferred_instance_type=pulumi.get(__response__, 'preferred_instance_type'),
        status=pulumi.get(__response__, 'status'),
        status_message=pulumi.get(__response__, 'status_message'),
        tags=pulumi.get(__response__, 'tags')))
